/*
 * Decompiled with CFR 0.152.
 */
package at.jta;

import at.jta.CachedEntry;
import at.jta.CachedValue;
import at.jta.Key;
import at.jta.NotSupportedOSException;
import at.jta.RegistryErrorException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class Regor {
    public static final int _HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int _HKEY_CURRENT_USER = -2147483647;
    public static final int _HKEY_LOCAL_MACHINE = -2147483646;
    public static final Key HKEY_CLASSES_ROOT = new Key(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final Key HKEY_CURRENT_USER = new Key(-2147483647, "HKEY_CURRENT_USER");
    public static final Key HKEY_LOCAL_MACHINE = new Key(-2147483646, "HKEY_LOCAL_MACHINE");
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private Method openKey = null;
    private Method closeKey = null;
    private Method delKey = null;
    private Method createKey = null;
    private Method flushKey = null;
    private Method queryValue = null;
    private Method setValue = null;
    private Method delValue = null;
    private Method queryInfoKey = null;
    private Method enumKey = null;
    private Method enumValue = null;
    private static final String NULL_STRING = new String(new char[]{'\u0000'});
    private static final String INIT_WINDOWS_STRING = "Windows Registry Editor Version 5.00";
    private static final String BINARY_KEY = "hex:";
    private static final String DWORD_KEY = "dword:";
    private static final String MULTI_KEY = "hex(7):";
    private static final String EXPAND_KEY = "hex(2):";
    public static int WAIT_FOR_FILE = 250;
    private ArrayList caches;
    private boolean useCache = false;

    public Regor() throws RegistryErrorException {
        this.checkOS();
        this.initMethods();
    }

    private void checkOS() {
        String str = System.getProperty("os.name");
        if (str == null || str.toLowerCase().indexOf("windows") == -1) {
            throw new NotSupportedOSException("Operating system: " + str + " is not supported!");
        }
    }

    private boolean saveAnyValue(String path, String valueName, String type, String data) throws RegistryErrorException {
        try {
            File f = File.createTempFile("regorexp", ".jta");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            bw.write(INIT_WINDOWS_STRING);
            bw.newLine();
            bw.newLine();
            bw.write("[");
            bw.write(path);
            bw.write("]");
            bw.newLine();
            bw.write("\"");
            bw.write(valueName);
            bw.write("\"=");
            bw.write(type);
            bw.write(data);
            bw.newLine();
            bw.close();
            Runtime.getRuntime().exec("regedit /s /i " + f.getAbsolutePath()).waitFor();
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            throw new RegistryErrorException(ex.getLocalizedMessage());
        }
        return true;
    }

    private String extractAnyValue(String path, String valueName) throws RegistryErrorException {
        block10: {
            try {
                String tmp = this.getCachedValue(path, valueName);
                if (tmp != null) {
                    return tmp;
                }
                if (this.useCache) {
                    System.out.println("CACHED KEY: " + path + " AND VALUE NOT FOUND: " + valueName);
                }
            }
            catch (NoEntryException nee) {
                if (!this.isCachingActive()) break block10;
                return null;
            }
        }
        StringBuffer strRet = new StringBuffer();
        try {
            File f = File.createTempFile("regorexp", ".jta");
            Runtime.getRuntime().exec("regedit /e " + f.getAbsolutePath() + " \"" + path + "\"").waitFor();
            Regor._waitForFile(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String line = "";
            boolean lineFound = false;
            boolean keyFound = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.replaceAll(NULL_STRING, "")).length() <= 0 || !keyFound && (!line.startsWith("[") || !line.endsWith("]"))) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    if (keyFound) break;
                    if (!line.equals("[" + path + "]")) continue;
                    keyFound = true;
                    continue;
                }
                if (!keyFound || !lineFound && (!line.startsWith("\"" + valueName) || line.indexOf("=") == -1)) continue;
                if (lineFound) {
                    if (line.length() <= 0) continue;
                    if (line.indexOf("=") != -1) break;
                    strRet.append(line.trim().replaceAll("\\\\", ""));
                    if (line.endsWith("\\")) continue;
                    break;
                }
                line = line.substring(line.indexOf("=") + 1);
                strRet.append(line.replaceAll("\\\\", ""));
                lineFound = true;
                if (line.indexOf("\\") != -1) continue;
            }
            br.close();
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            throw new RegistryErrorException(ex.getLocalizedMessage());
        }
        return strRet.length() == 0 ? null : strRet.toString();
    }

    public void saveBinary(Key key, String valueName, String hexCommaData) throws RegistryErrorException {
        this.saveAnyValue(key.getPath(), valueName, BINARY_KEY, hexCommaData);
    }

    public String readBinary(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        String ret = this.extractAnyValue(key.getPath(), valueName);
        if (ret != null && ret.startsWith(BINARY_KEY)) {
            return ret.substring(4);
        }
        return null;
    }

    public void saveDword(Key key, String valueName, String hexData) throws RegistryErrorException {
        this.saveAnyValue(key.getPath(), valueName, DWORD_KEY, hexData);
    }

    public String readDword(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        String ret = this.extractAnyValue(key.getPath(), valueName);
        if (ret != null && ret.startsWith(DWORD_KEY)) {
            return ret.substring(6);
        }
        return null;
    }

    public void saveMulti(Key key, String valueName, String hexCommaZeroData) throws RegistryErrorException {
        this.saveAnyValue(key.getPath(), valueName, MULTI_KEY, hexCommaZeroData);
    }

    public String readMulti(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        String ret = this.extractAnyValue(key.getPath(), valueName);
        if (ret != null && ret.startsWith(MULTI_KEY)) {
            return ret.substring(7);
        }
        return null;
    }

    public void saveExpand(Key key, String valueName, String hexCommaZeroData) throws RegistryErrorException {
        this.saveAnyValue(key.getPath(), valueName, EXPAND_KEY, hexCommaZeroData);
    }

    public String readExpand(Key key, String valueName) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        if (valueName == null) {
            throw new NullPointerException("Valuename cannot be null, because the default value is always a STRING! If you want to read a String use readValue");
        }
        String ret = this.extractAnyValue(key.getPath(), valueName);
        if (ret != null && ret.startsWith(EXPAND_KEY)) {
            return ret.substring(7);
        }
        return null;
    }

    public byte[] enumValueName(Key key, int valueNameIndex, int maxValueNameLength) throws RegistryErrorException {
        return this._enumValueName(key.getKey(), valueNameIndex, maxValueNameLength);
    }

    public byte[] _enumValueName(int key, int valueNameIndex, int maxValueNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumValue.invoke(null, new Integer(key), new Integer(valueNameIndex), new Integer(maxValueNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public List listValueNames(Key key, String subkey) throws RegistryErrorException {
        return this._listValueNames(key.getKey(), subkey);
    }

    public List listValueNames(Key key) throws RegistryErrorException {
        return this.listValueNames(key, null);
    }

    public List _listValueNames(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this._openKey(key, subkey, 131097);
            if (handle != -1 && (info = this._getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x != info[2]; ++x) {
                    String tmp = Regor.parseValue(this._enumValueName(handle, x, info[4] + 1));
                    if (tmp == null) continue;
                    ret.add(tmp);
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        finally {
            this._closeKey(handle);
        }
        return null;
    }

    public List _listValueNames(int key) throws RegistryErrorException {
        return this._listValueNames(key, null);
    }

    public byte[] enumKeys(Key key, int subkeyIndex, int maxKeyNameLength) throws RegistryErrorException {
        return this._enumKeys(key.getKey(), subkeyIndex, maxKeyNameLength);
    }

    public byte[] _enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumKey.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public List listKeys(Key key, String subkey) throws RegistryErrorException {
        return this._listKeys(key.getKey(), subkey);
    }

    public List listKeys(Key key) throws RegistryErrorException {
        return this.listKeys(key, null);
    }

    public List _listKeys(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this._openKey(key, subkey, 131097);
            if (handle != -1 && (info = this._getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x != info[0]; ++x) {
                    String tmp = Regor.parseValue(this._enumKeys(handle, x, info[3] + 1));
                    if (tmp == null) continue;
                    ret.add(tmp);
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        finally {
            this._closeKey(handle);
        }
        return null;
    }

    public List _listKeys(int key) throws RegistryErrorException {
        return this._listKeys(key, null);
    }

    public int[] getChildInformation(Key key) throws RegistryErrorException {
        return this._getChildInformation(key.getKey());
    }

    public int[] _getChildInformation(int key) throws RegistryErrorException {
        try {
            return (int[])this.queryInfoKey.invoke(null, new Integer(key));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int delValue(Key key, String valueName) throws RegistryErrorException {
        return this._delValue(key.getKey(), valueName);
    }

    public int _delValue(int key, String valueName) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.delValue.invoke(null, new Integer(key), this.getString(valueName));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int setValue(Key key, String valueName, String value) throws RegistryErrorException {
        return this._setValue(key.getKey(), valueName, value);
    }

    public int _setValue(int key, String valueName, String value) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.setValue.invoke(null, new Integer(key), this.getString(valueName), this.getString(value));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public byte[] readValue(Key key, String valueName) throws RegistryErrorException {
        return this._readValue(key.getKey(), valueName);
    }

    public byte[] _readValue(int key, String valueName) throws RegistryErrorException {
        try {
            byte[] ret = (byte[])this.queryValue.invoke(null, new Integer(key), this.getString(valueName));
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int flushKey(Key key) throws RegistryErrorException {
        return this._flushKey(key.getKey());
    }

    public int _flushKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.flushKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int delKey(Key key, String subkey) throws RegistryErrorException {
        return this._delKey(key.getKey(), subkey);
    }

    public int _delKey(int key, String subkey) throws RegistryErrorException {
        if (subkey == null || subkey.length() == 0) {
            throw new RegistryErrorException("subkey cannot be null");
        }
        try {
            Integer ret = (Integer)this.delKey.invoke(null, new Integer(key), this.getString(subkey));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public Key createKey(Key key, String subkey) throws RegistryErrorException {
        int tmpKey = this._createKey(key.getKey(), subkey);
        if (tmpKey == -1) {
            return null;
        }
        return new Key(key, tmpKey, subkey);
    }

    public int _createKey(int key, String subkey) throws RegistryErrorException {
        try {
            int[] result = (int[])this.createKey.invoke(null, new Integer(key), this.getString(subkey));
            if (result[1] == 0) {
                return result[0];
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int closeKey(Key key) throws RegistryErrorException {
        return this._closeKey(key.getKey());
    }

    public int _closeKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.closeKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public Key openKey(Key key, String subkey, int security_mask) throws RegistryErrorException {
        int tmpKey = this._openKey(key.getKey(), subkey, security_mask);
        if (tmpKey == -1) {
            return null;
        }
        return new Key(key, tmpKey, subkey);
    }

    public Key openKey(Key key, String subkey) throws RegistryErrorException {
        return this.openKey(key, subkey, 983103);
    }

    public int _openKey(int key, String subkey, int security_mask) throws RegistryErrorException {
        try {
            int[] result = (int[])this.openKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
            if (result == null || result[1] != 0) {
                return -1;
            }
            return result[0];
        }
        catch (InvocationTargetException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
    }

    public int _openKey(int key, String subkey) throws RegistryErrorException {
        return this._openKey(key, subkey, 983103);
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = str + "\u0000";
        return str.getBytes();
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String parseHexString(String hexCommaString, boolean deleteNullSigns) {
        if (hexCommaString == null || hexCommaString.trim().length() == 0) {
            return hexCommaString;
        }
        String[] items = hexCommaString.split(",");
        if (items == null || items.length == 0) {
            return hexCommaString;
        }
        StringBuffer strRet = new StringBuffer();
        for (int x = 0; items != null && x != items.length; ++x) {
            char sign = (char)Integer.parseInt(items[x], 16);
            if (deleteNullSigns && (!deleteNullSigns || sign == '\u0000') && x % 2 != 0) continue;
            strRet.append(sign);
        }
        if (deleteNullSigns && strRet.charAt(strRet.length() - 1) == '\u0000') {
            strRet.deleteCharAt(strRet.length() - 1);
        }
        return strRet.toString();
    }

    public static String convertStringToHexComma(String plain, boolean appendNullSigns) {
        if (plain == null || plain.trim().length() == 0) {
            return plain;
        }
        StringBuffer strBuf = new StringBuffer();
        for (int x = 0; x != plain.length(); ++x) {
            if (x > 0) {
                strBuf.append(",");
            }
            strBuf.append(Integer.toHexString(plain.charAt(x)));
            if (!appendNullSigns) continue;
            strBuf.append(",00");
        }
        return strBuf.toString();
    }

    private void initMethods() throws RegistryErrorException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method[] ms = clazz.getDeclaredMethods();
            if (ms == null) {
                throw new RegistryErrorException("Cannot access java.util.prefs.WindowsPreferences class!");
            }
            for (int x = 0; x != ms.length; ++x) {
                if (ms[x] == null) continue;
                if (ms[x].getName().equals("WindowsRegOpenKey")) {
                    this.openKey = ms[x];
                    this.openKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegCloseKey")) {
                    this.closeKey = ms[x];
                    this.closeKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegCreateKeyEx")) {
                    this.createKey = ms[x];
                    this.createKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegDeleteKey")) {
                    this.delKey = ms[x];
                    this.delKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegFlushKey")) {
                    this.flushKey = ms[x];
                    this.flushKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegQueryValueEx")) {
                    this.queryValue = ms[x];
                    this.queryValue.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegSetValueEx")) {
                    this.setValue = ms[x];
                    this.setValue.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegDeleteValue")) {
                    this.delValue = ms[x];
                    this.delValue.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegQueryInfoKey")) {
                    this.queryInfoKey = ms[x];
                    this.queryInfoKey.setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegEnumKeyEx")) {
                    this.enumKey = ms[x];
                    this.enumKey.setAccessible(true);
                    continue;
                }
                if (!ms[x].getName().equals("WindowsRegEnumValue")) continue;
                this.enumValue = ms[x];
                this.enumValue.setAccessible(true);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public void cacheKeys(Key key) throws RegistryErrorException {
        this.cacheKeys(key, 1);
    }

    public void cacheKeys(Key key, int maximumChildren) throws RegistryErrorException {
        if (key == null) {
            throw new NullPointerException("Registry key cannot be null");
        }
        this.cacheKeys(key.getPath(), maximumChildren);
    }

    private void cacheKeys(String key, int maximumChildren) throws RegistryErrorException {
        StringBuffer strRet = new StringBuffer();
        try {
            Object[] tmp;
            File f = File.createTempFile("regorexp", ".jta");
            Runtime.getRuntime().exec("regedit /e " + f.getAbsolutePath() + " \"" + key + "\"").waitFor();
            Regor._waitForFile(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String line = "";
            CachedEntry entry = new CachedEntry();
            CachedEntry currentEntry = null;
            CachedValue currentValue = null;
            entry.setKey(key);
            while ((line = br.readLine()) != null) {
                if ((line = line.replaceAll(NULL_STRING, "")) == null || line.length() <= 0) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String currentKey;
                    if (currentEntry != null) {
                        tmp = entry.getSub(currentEntry.getKey());
                        if (tmp != null && (Integer)tmp[1] < maximumChildren) {
                            ((CachedEntry)tmp[0]).appendChildren(currentEntry);
                        }
                        currentEntry = null;
                    }
                    if ((currentKey = line.substring(1, line.length() - 1)) == null || currentKey.length() <= 0) continue;
                    if (currentKey.equals(entry.getKey())) {
                        currentEntry = entry;
                        continue;
                    }
                    currentEntry = new CachedEntry();
                    currentEntry.setKey(currentKey);
                    continue;
                }
                if (currentEntry == null || line.indexOf("=") == -1 && currentValue == null) continue;
                if (currentValue != null) {
                    if (line.length() <= 0) continue;
                    if (line.indexOf("=") != -1) {
                        currentValue.setData(strRet.toString());
                        strRet.delete(0, strRet.length());
                        currentEntry.appendEntry(currentValue);
                        currentValue = null;
                        continue;
                    }
                    if ((line = line.trim()).endsWith("\\")) {
                        strRet.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    strRet.append(line.trim());
                    currentValue.setData(strRet.toString());
                    strRet.delete(0, strRet.length());
                    currentEntry.appendEntry(currentValue);
                    currentValue = null;
                    continue;
                }
                String currentName = line.substring(0, line.indexOf("="));
                if (currentName.equals("@")) {
                    currentName = "";
                }
                currentValue = new CachedValue();
                currentValue.setName(currentName.replaceAll("\"", ""));
                line = line.substring(line.indexOf("=") + 1);
                if (line.endsWith("\\")) {
                    strRet.append(line.substring(0, line.length() - 1));
                    continue;
                }
                strRet.append(line);
                currentValue.setData(strRet.toString());
                strRet.delete(0, strRet.length());
                currentEntry.appendEntry(currentValue);
                currentValue = null;
            }
            if (currentEntry != null && (tmp = entry.getSub(currentEntry.getKey())) != null && (Integer)tmp[1] < maximumChildren) {
                ((CachedEntry)tmp[0]).appendChildren(currentEntry);
            }
            br.close();
            if (!f.delete()) {
                f.deleteOnExit();
            }
            if (this.caches == null) {
                this.caches = new ArrayList();
            }
            this.caches.add(entry);
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            throw new RegistryErrorException(ex.getLocalizedMessage());
        }
    }

    public void setCaching(boolean aValue) {
        if (this.useCache != aValue) {
            this.useCache = aValue;
        }
    }

    public boolean isCachingActive() {
        return this.useCache;
    }

    public List getCachingKeys() {
        ArrayList<String> ret = null;
        if (this.isCachingActive() && this.caches != null && this.caches.size() > 0) {
            ret = new ArrayList<String>();
            for (int x = 0; x != this.caches.size(); ++x) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                if (entry == null) continue;
                ret.add(entry.getKey());
            }
        }
        return ret;
    }

    public void refreshCaches() throws RegistryErrorException {
        if (this.isCachingActive() && this.caches != null && this.caches.size() > 0) {
            List tmpCache = (List)this.caches.clone();
            this.caches = new ArrayList();
            for (int x = 0; tmpCache != null && x != tmpCache.size(); ++x) {
                CachedEntry entry = (CachedEntry)tmpCache.get(x);
                if (entry == null) continue;
                String key = entry.getKey();
                this.cacheKeys(key, 1);
            }
        }
    }

    public void deleteCaches() {
        if (this.isCachingActive()) {
            for (int x = 0; this.caches != null && x != this.caches.size(); ++x) {
                List entries;
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                if (entry == null) continue;
                List children = entry.getChildren();
                if (children != null) {
                    children.clear();
                }
                if ((entries = entry.getEntries()) == null) continue;
                entries.clear();
            }
            this.caches.clear();
            this.caches = null;
        }
    }

    private String getCachedValue(String key, String name) throws NoEntryException {
        if (this.isCachingActive()) {
            for (int x = 0; this.caches != null && x != this.caches.size(); ++x) {
                CachedEntry entry = (CachedEntry)this.caches.get(x);
                CachedEntry child = entry.findSub(key);
                if (child == null) continue;
                List list = child.getEntries();
                if (list == null) {
                    throw new NoEntryException(key + " @ " + name + " not found in registry");
                }
                for (int y = 0; list != null && y != list.size(); ++y) {
                    CachedValue val = (CachedValue)list.get(y);
                    if (val == null || !val.getName().equals(name)) continue;
                    return val.getData();
                }
                if (list.size() <= 0) continue;
                throw new NoEntryException(key + " @ " + name + " not found in registry");
            }
        }
        return null;
    }

    private static String parseData(String data) {
        if (data == null || data.length() == 0) {
            return data;
        }
        if (data.startsWith(BINARY_KEY)) {
            return data.substring(4);
        }
        if (data.startsWith(DWORD_KEY)) {
            return data.substring(6);
        }
        if (data.startsWith(MULTI_KEY)) {
            return data.substring(7);
        }
        if (data.startsWith(EXPAND_KEY)) {
            return data.substring(7);
        }
        if (data.startsWith("\"")) {
            return data.replaceAll("\"", "");
        }
        return data;
    }

    private static void _waitForFile(File file) {
        try {
            long size = file.length();
            Thread.currentThread();
            Thread.sleep(WAIT_FOR_FILE);
            if (size != file.length()) {
                Regor._waitForFile(file);
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR WAITING FOR FILE: " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        Regor regor = new Regor();
        Key _key = regor.openKey(HKEY_LOCAL_MACHINE, "SYSTEM\\ControlSet001\\Services");
        regor.cacheKeys(_key, 2);
        Key __key = regor.openKey(_key, "xmlprov");
        System.out.println("KEY:: " + __key);
        System.out.println(">>>> " + regor.readMulti(__key, "DependOnService"));
        System.out.println(">>> " + Regor.parseHexString(regor.readMulti(__key, "DependOnService"), true));
        System.out.println(">>>> " + regor.readExpand(__key, "ImagePath"));
        System.out.println(">>> " + Regor.parseHexString(regor.readExpand(__key, "ImagePath"), true));
        regor.closeKey(__key);
        regor.closeKey(_key);
    }

    private static class NoEntryException
    extends Exception {
        public NoEntryException(String str) {
            super(str);
        }
    }
}

