/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class RandomAccessStreamReader
extends RandomAccessReader {
    public static final int DEFAULT_CHUNK_LENGTH = 2048;
    @NotNull
    private final InputStream _stream;
    private final int _chunkLength;
    private final ArrayList<byte[]> _chunks = new ArrayList();
    private boolean _isStreamFinished;
    private long _streamLength;

    public RandomAccessStreamReader(@NotNull InputStream inputStream) {
        this(inputStream, 2048, -1L);
    }

    public RandomAccessStreamReader(@NotNull InputStream inputStream, int n) {
        this(inputStream, n, -1L);
    }

    public RandomAccessStreamReader(@NotNull InputStream inputStream, int n, long l) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("chunkLength must be greater than zero");
        }
        this._chunkLength = n;
        this._stream = inputStream;
        this._streamLength = l;
    }

    public long getLength() throws IOException {
        if (this._streamLength != -1L) {
            return this._streamLength;
        }
        this.isValidIndex(Integer.MAX_VALUE, 1);
        assert (this._isStreamFinished);
        return this._streamLength;
    }

    protected void validateIndex(int n, int n2) throws IOException {
        if (n < 0) {
            throw new BufferBoundsException(String.format("Attempt to read from buffer using a negative index (%d)", n));
        }
        if (n2 < 0) {
            throw new BufferBoundsException("Number of requested bytes must be zero or greater");
        }
        if ((long)n + (long)n2 - 1L > Integer.MAX_VALUE) {
            throw new BufferBoundsException(String.format("Number of requested bytes summed with starting index exceed maximum range of signed 32 bit integers (requested index: %d, requested count: %d)", n, n2));
        }
        if (!this.isValidIndex(n, n2)) {
            assert (this._isStreamFinished);
            throw new BufferBoundsException(n, n2, this._streamLength);
        }
    }

    protected boolean isValidIndex(int n, int n2) throws IOException {
        if (n < 0 || n2 < 0) {
            return false;
        }
        long l = (long)n + (long)n2 - 1L;
        if (l > Integer.MAX_VALUE) {
            return false;
        }
        int n3 = (int)l;
        if (this._isStreamFinished) {
            return (long)n3 < this._streamLength;
        }
        int n4 = n3 / this._chunkLength;
        while (n4 >= this._chunks.size()) {
            assert (!this._isStreamFinished);
            byte[] byArray = new byte[this._chunkLength];
            int n5 = 0;
            while (!this._isStreamFinished && n5 != this._chunkLength) {
                int n6 = this._stream.read(byArray, n5, this._chunkLength - n5);
                if (n6 == -1) {
                    this._isStreamFinished = true;
                    int n7 = this._chunks.size() * this._chunkLength + n5;
                    if (this._streamLength == -1L) {
                        this._streamLength = n7;
                    } else if (this._streamLength != (long)n7) assert (false);
                    if ((long)n3 < this._streamLength) continue;
                    this._chunks.add(byArray);
                    return false;
                }
                n5 += n6;
            }
            this._chunks.add(byArray);
        }
        return true;
    }

    protected byte getByte(int n) throws IOException {
        assert (n >= 0);
        int n2 = n / this._chunkLength;
        int n3 = n % this._chunkLength;
        byte[] byArray = this._chunks.get(n2);
        return byArray[n3];
    }

    @NotNull
    public byte[] getBytes(int n, int n2) throws IOException {
        this.validateIndex(n, n2);
        byte[] byArray = new byte[n2];
        int n3 = n2;
        int n4 = n;
        int n5 = 0;
        while (n3 != 0) {
            int n6 = n4 / this._chunkLength;
            int n7 = n4 % this._chunkLength;
            int n8 = Math.min(n3, this._chunkLength - n7);
            byte[] byArray2 = this._chunks.get(n6);
            System.arraycopy(byArray2, n7, byArray, n5, n8);
            n3 -= n8;
            n4 += n8;
            n5 += n8;
        }
        return byArray;
    }
}

