/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.lang.annotations.SuppressWarnings;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Directory {
    private static final DecimalFormat _floatFormat = new DecimalFormat("0.###");
    @NotNull
    protected final Map<Integer, Object> _tagMap = new HashMap<Integer, Object>();
    @NotNull
    protected final Collection<Tag> _definedTagList = new ArrayList<Tag>();
    @NotNull
    private final Collection<String> _errorList = new ArrayList<String>(4);
    protected TagDescriptor _descriptor;

    @NotNull
    public abstract String getName();

    @NotNull
    protected abstract HashMap<Integer, String> getTagNameMap();

    protected Directory() {
    }

    public boolean isEmpty() {
        return this._errorList.isEmpty() && this._definedTagList.isEmpty();
    }

    public boolean containsTag(int n) {
        return this._tagMap.containsKey(n);
    }

    @NotNull
    public Collection<Tag> getTags() {
        return Collections.unmodifiableCollection(this._definedTagList);
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(@NotNull TagDescriptor tagDescriptor) {
        if (tagDescriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = tagDescriptor;
    }

    public void addError(@NotNull String string) {
        this._errorList.add(string);
    }

    public boolean hasErrors() {
        return this._errorList.size() > 0;
    }

    @NotNull
    public Iterable<String> getErrors() {
        return Collections.unmodifiableCollection(this._errorList);
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setInt(int n, int n2) {
        this.setObject(n, n2);
    }

    public void setIntArray(int n, @NotNull int[] nArray) {
        this.setObjectArray(n, nArray);
    }

    public void setFloat(int n, float f) {
        this.setObject(n, Float.valueOf(f));
    }

    public void setFloatArray(int n, @NotNull float[] fArray) {
        this.setObjectArray(n, fArray);
    }

    public void setDouble(int n, double d) {
        this.setObject(n, d);
    }

    public void setDoubleArray(int n, @NotNull double[] dArray) {
        this.setObjectArray(n, dArray);
    }

    public void setString(int n, @NotNull String string) {
        if (string == null) {
            throw new NullPointerException("cannot set a null String");
        }
        this.setObject(n, string);
    }

    public void setStringArray(int n, @NotNull String[] stringArray) {
        this.setObjectArray(n, stringArray);
    }

    public void setBoolean(int n, boolean bl) {
        this.setObject(n, bl);
    }

    public void setLong(int n, long l) {
        this.setObject(n, l);
    }

    public void setDate(int n, @NotNull Date date) {
        this.setObject(n, date);
    }

    public void setRational(int n, @NotNull Rational rational) {
        this.setObject(n, rational);
    }

    public void setRationalArray(int n, @NotNull Rational[] rationalArray) {
        this.setObjectArray(n, rationalArray);
    }

    public void setByteArray(int n, @NotNull byte[] byArray) {
        this.setObjectArray(n, byArray);
    }

    public void setObject(int n, @NotNull Object object) {
        if (object == null) {
            throw new NullPointerException("cannot set a null object");
        }
        if (!this._tagMap.containsKey(n)) {
            this._definedTagList.add(new Tag(n, this));
        }
        this._tagMap.put(n, object);
    }

    public void setObjectArray(int n, @NotNull Object object) {
        this.setObject(n, object);
    }

    public int getInt(int n) throws MetadataException {
        Integer n2 = this.getInteger(n);
        if (n2 != null) {
            return n2;
        }
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag '" + this.getTagName(n) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + n + "' cannot be converted to int.  It is of type '" + object.getClass() + "'.");
    }

    @Nullable
    public Integer getInteger(int n) {
        int[] nArray;
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = (String)object;
                byte[] byArray = string.getBytes();
                long l = 0L;
                for (byte by : byArray) {
                    l <<= 8;
                    l += (long)(by & 0xFF);
                }
                return (int)l;
            }
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            if (rationalArray.length == 1) {
                return rationalArray[0].intValue();
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 1) {
                return byArray[0];
            }
        } else if (object instanceof int[] && (nArray = (int[])object).length == 1) {
            return nArray[0];
        }
        return null;
    }

    @Nullable
    public String[] getStringArray(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            return new String[]{(String)object};
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(nArray[i]);
            }
            return stringArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            String[] stringArray = new String[byArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Byte.toString(byArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            String[] stringArray = new String[rationalArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = rationalArray[i].toSimpleString(false);
            }
            return stringArray;
        }
        return null;
    }

    @Nullable
    public int[] getIntArray(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            int[] nArray = new int[rationalArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = rationalArray[i].intValue();
            }
            return nArray;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int[] nArray = new int[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                nArray[i] = sArray[i];
            }
            return nArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                nArray[i] = byArray[i];
            }
            return nArray;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            int[] nArray = new int[charSequence.length()];
            for (int i = 0; i < charSequence.length(); ++i) {
                nArray[i] = charSequence.charAt(i);
            }
            return nArray;
        }
        if (object instanceof Integer) {
            return new int[]{(Integer)object};
        }
        return null;
    }

    @Nullable
    public byte[] getByteArray(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational[]) {
            Rational[] rationalArray = (Rational[])object;
            byte[] byArray = new byte[rationalArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = rationalArray[i].byteValue();
            }
            return byArray;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            byte[] byArray = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
            return byArray;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            byte[] byArray = new byte[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                byArray[i] = (byte)sArray[i];
            }
            return byArray;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            byte[] byArray = new byte[charSequence.length()];
            for (int i = 0; i < charSequence.length(); ++i) {
                byArray[i] = (byte)charSequence.charAt(i);
            }
            return byArray;
        }
        if (object instanceof Integer) {
            return new byte[]{((Integer)object).byteValue()};
        }
        return null;
    }

    public double getDouble(int n) throws MetadataException {
        Double d = this.getDoubleObject(n);
        if (d != null) {
            return d;
        }
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag '" + this.getTagName(n) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + n + "' cannot be converted to a double.  It is of type '" + object.getClass() + "'.");
    }

    @Nullable
    public Double getDoubleObject(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return null;
    }

    public float getFloat(int n) throws MetadataException {
        Float f = this.getFloatObject(n);
        if (f != null) {
            return f.floatValue();
        }
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag '" + this.getTagName(n) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + n + "' cannot be converted to a float.  It is of type '" + object.getClass() + "'.");
    }

    @Nullable
    public Float getFloatObject(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        return null;
    }

    public long getLong(int n) throws MetadataException {
        Long l = this.getLongObject(n);
        if (l != null) {
            return l;
        }
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag '" + this.getTagName(n) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + n + "' cannot be converted to a long.  It is of type '" + object.getClass() + "'.");
    }

    @Nullable
    public Long getLongObject(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return null;
    }

    public boolean getBoolean(int n) throws MetadataException {
        Boolean bl = this.getBooleanObject(n);
        if (bl != null) {
            return bl;
        }
        Object object = this.getObject(n);
        if (object == null) {
            throw new MetadataException("Tag '" + this.getTagName(n) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + n + "' cannot be converted to a boolean.  It is of type '" + object.getClass() + "'.");
    }

    @Nullable
    @SuppressWarnings(value="NP_BOOLEAN_RETURN_NULL", justification="keep API interface consistent")
    public Boolean getBooleanObject(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            try {
                return Boolean.getBoolean((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        return null;
    }

    @Nullable
    public Date getDate(int n) {
        return this.getDate(n, null, null);
    }

    @Nullable
    public Date getDate(int n, @Nullable TimeZone timeZone) {
        return this.getDate(n, null, timeZone);
    }

    @Nullable
    public Date getDate(int n, @Nullable String string, @Nullable TimeZone timeZone) {
        Object object;
        Object object2 = this.getObject(n);
        if (object2 instanceof Date) {
            return (Date)object2;
        }
        Date date = null;
        if (object2 instanceof String) {
            Pattern pattern;
            Matcher matcher;
            String[] stringArray = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
            object = (String)object2;
            Pattern pattern2 = Pattern.compile("(\\d\\d:\\d\\d:\\d\\d)(\\.\\d+)");
            Matcher matcher2 = pattern2.matcher((CharSequence)object);
            if (matcher2.find()) {
                string = matcher2.group(2).substring(1);
                object = matcher2.replaceAll("$1");
            }
            if ((matcher = (pattern = Pattern.compile("(Z|[+-]\\d\\d:\\d\\d)$")).matcher((CharSequence)object)).find()) {
                timeZone = TimeZone.getTimeZone("GMT" + matcher.group().replaceAll("Z", ""));
                object = matcher.replaceAll("");
            }
            for (String string2 : stringArray) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                    if (timeZone != null) {
                        simpleDateFormat.setTimeZone(timeZone);
                    } else {
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    }
                    date = simpleDateFormat.parse((String)object);
                    break;
                }
                catch (ParseException parseException) {
                }
            }
        }
        if (date == null) {
            return null;
        }
        if (string == null) {
            return date;
        }
        try {
            int n2 = (int)(Double.parseDouble("." + string) * 1000.0);
            if (n2 >= 0 && n2 < 1000) {
                object = Calendar.getInstance();
                ((Calendar)object).setTime(date);
                ((Calendar)object).set(14, n2);
                return ((Calendar)object).getTime();
            }
            return date;
        }
        catch (NumberFormatException numberFormatException) {
            return date;
        }
    }

    @Nullable
    public Rational getRational(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational) {
            return (Rational)object;
        }
        if (object instanceof Integer) {
            return new Rational(((Integer)object).intValue(), 1L);
        }
        if (object instanceof Long) {
            return new Rational((Long)object, 1L);
        }
        return null;
    }

    @Nullable
    public Rational[] getRationalArray(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational[]) {
            return (Rational[])object;
        }
        return null;
    }

    @Nullable
    public String getString(int n) {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Rational) {
            return ((Rational)object).toSimpleString(true);
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            Class<?> clazz = object.getClass().getComponentType();
            StringBuilder stringBuilder = new StringBuilder();
            if (Object.class.isAssignableFrom(clazz)) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Array.get(object, i).toString());
                }
            } else if (clazz.getName().equals("int")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Array.getInt(object, i));
                }
            } else if (clazz.getName().equals("short")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Array.getShort(object, i));
                }
            } else if (clazz.getName().equals("long")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Array.getLong(object, i));
                }
            } else if (clazz.getName().equals("float")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(_floatFormat.format(Array.getFloat(object, i)));
                }
            } else if (clazz.getName().equals("double")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(_floatFormat.format(Array.getDouble(object, i)));
                }
            } else if (clazz.getName().equals("byte")) {
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Array.getByte(object, i) & 0xFF);
                }
            } else {
                this.addError("Unexpected array component type: " + clazz.getName());
            }
            return stringBuilder.toString();
        }
        if (object instanceof Double) {
            return _floatFormat.format((Double)object);
        }
        if (object instanceof Float) {
            return _floatFormat.format(((Float)object).floatValue());
        }
        return object.toString();
    }

    @Nullable
    public String getString(int n, String string) {
        byte[] byArray = this.getByteArray(n);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Nullable
    public Object getObject(int n) {
        return this._tagMap.get(n);
    }

    @NotNull
    public String getTagName(int n) {
        HashMap<Integer, String> hashMap = this.getTagNameMap();
        if (!hashMap.containsKey(n)) {
            String string = Integer.toHexString(n);
            while (string.length() < 4) {
                string = "0" + string;
            }
            return "Unknown tag (0x" + string + ")";
        }
        return hashMap.get(n);
    }

    public boolean hasTagName(int n) {
        return this.getTagNameMap().containsKey(n);
    }

    @Nullable
    public String getDescription(int n) {
        assert (this._descriptor != null);
        return this._descriptor.getDescription(n);
    }

    public String toString() {
        return String.format("%s Directory (%d %s)", this.getName(), this._tagMap.size(), this._tagMap.size() == 1 ? "tag" : "tags");
    }
}

