/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.DateUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import java.math.RoundingMode;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlympusMakernoteDescriptor
extends TagDescriptor<OlympusMakernoteDirectory> {
    public OlympusMakernoteDescriptor(@NotNull OlympusMakernoteDirectory olympusMakernoteDirectory) {
        super(olympusMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return this.getMakernoteVersionDescription();
            }
            case 257: {
                return this.getColorModeDescription();
            }
            case 258: {
                return this.getImageQuality1Description();
            }
            case 259: {
                return this.getImageQuality2Description();
            }
            case 512: {
                return this.getSpecialModeDescription();
            }
            case 513: {
                return this.getJpegQualityDescription();
            }
            case 514: {
                return this.getMacroModeDescription();
            }
            case 515: {
                return this.getBWModeDescription();
            }
            case 516: {
                return this.getDigiZoomRatioDescription();
            }
            case 521: {
                return this.getCameraIdDescription();
            }
            case 4100: {
                return this.getFlashModeDescription();
            }
            case 4106: {
                return this.getFocusRangeDescription();
            }
            case 4107: {
                return this.getFocusModeDescription();
            }
            case 4111: {
                return this.getSharpnessDescription();
            }
            case 61442: {
                return this.getExposureModeDescription();
            }
            case 61443: {
                return this.getFlashModeCameraSettingDescription();
            }
            case 61444: {
                return this.getWhiteBalanceDescription();
            }
            case 61445: {
                return this.getImageSizeDescription();
            }
            case 61446: {
                return this.getImageQualityDescription();
            }
            case 61447: {
                return this.getShootingModeDescription();
            }
            case 61448: {
                return this.getMeteringModeDescription();
            }
            case 61449: {
                return this.getApexFilmSpeedDescription();
            }
            case 61450: {
                return this.getApexShutterSpeedTimeDescription();
            }
            case 61451: {
                return this.getApexApertureDescription();
            }
            case 61452: {
                return this.getMacroModeCameraSettingDescription();
            }
            case 61453: {
                return this.getDigitalZoomDescription();
            }
            case 61454: {
                return this.getExposureCompensationDescription();
            }
            case 61455: {
                return this.getBracketStepDescription();
            }
            case 61457: {
                return this.getIntervalLengthDescription();
            }
            case 61458: {
                return this.getIntervalNumberDescription();
            }
            case 61459: {
                return this.getFocalLengthDescription();
            }
            case 61460: {
                return this.getFocusDistanceDescription();
            }
            case 61461: {
                return this.getFlashFiredDescription();
            }
            case 61462: {
                return this.getDateDescription();
            }
            case 61463: {
                return this.getTimeDescription();
            }
            case 61464: {
                return this.getMaxApertureAtFocalLengthDescription();
            }
            case 61467: {
                return this.getFileNumberMemoryDescription();
            }
            case 61468: {
                return this.getLastFileNumberDescription();
            }
            case 61469: {
                return this.getWhiteBalanceRedDescription();
            }
            case 61470: {
                return this.getWhiteBalanceGreenDescription();
            }
            case 61471: {
                return this.getWhiteBalanceBlueDescription();
            }
            case 61472: {
                return this.getSaturationDescription();
            }
            case 61473: {
                return this.getContrastDescription();
            }
            case 61474: {
                return this.getSharpnessCameraSettingDescription();
            }
            case 61475: {
                return this.getSubjectProgramDescription();
            }
            case 61476: {
                return this.getFlashCompensationDescription();
            }
            case 61477: {
                return this.getIsoSettingDescription();
            }
            case 61478: {
                return this.getCameraModelDescription();
            }
            case 61479: {
                return this.getIntervalModeDescription();
            }
            case 61480: {
                return this.getFolderNameDescription();
            }
            case 61481: {
                return this.getColorModeCameraSettingDescription();
            }
            case 61482: {
                return this.getColorFilterDescription();
            }
            case 61483: {
                return this.getBlackAndWhiteFilterDescription();
            }
            case 61484: {
                return this.getInternalFlashDescription();
            }
            case 61485: {
                return this.getApexBrightnessDescription();
            }
            case 61486: {
                return this.getSpotFocusPointXCoordinateDescription();
            }
            case 61487: {
                return this.getSpotFocusPointYCoordinateDescription();
            }
            case 61488: {
                return this.getWideFocusZoneDescription();
            }
            case 61489: {
                return this.getFocusModeCameraSettingDescription();
            }
            case 61490: {
                return this.getFocusAreaDescription();
            }
            case 61491: {
                return this.getDecSwitchPositionDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getExposureModeDescription() {
        return this.getIndexedDescription(61442, "P", "A", "S", "M");
    }

    @Nullable
    public String getFlashModeCameraSettingDescription() {
        return this.getIndexedDescription(61443, "Normal", "Red-eye reduction", "Rear flash sync", "Wireless");
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(61444, "Auto", "Daylight", "Cloudy", "Tungsten", null, "Custom", null, "Fluorescent", "Fluorescent 2", null, null, "Custom 2", "Custom 3");
    }

    @Nullable
    public String getImageSizeDescription() {
        return this.getIndexedDescription(61445, "2560 x 1920", "1600 x 1200", "1280 x 960", "640 x 480");
    }

    @Nullable
    public String getImageQualityDescription() {
        return this.getIndexedDescription(61446, "Raw", "Super Fine", "Fine", "Standard", "Economy", "Extra Fine");
    }

    @Nullable
    public String getShootingModeDescription() {
        return this.getIndexedDescription(61447, "Single", "Continuous", "Self Timer", null, "Bracketing", "Interval", "UHS Continuous", "HS Continuous");
    }

    @Nullable
    public String getMeteringModeDescription() {
        return this.getIndexedDescription(61448, "Multi-Segment", "Centre Weighted", "Spot");
    }

    @Nullable
    public String getApexFilmSpeedDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61449);
        if (l == null) {
            return null;
        }
        double d = Math.pow((double)l.longValue() / 8.0 - 1.0, 2.0) * 3.125;
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(d);
    }

    @Nullable
    public String getApexShutterSpeedTimeDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61450);
        if (l == null) {
            return null;
        }
        double d = Math.pow((double)(49L - l) / 8.0, 2.0);
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(d) + " sec";
    }

    @Nullable
    public String getApexApertureDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61451);
        if (l == null) {
            return null;
        }
        double d = Math.pow((double)l.longValue() / 16.0 - 0.5, 2.0);
        return OlympusMakernoteDescriptor.getFStopDescription(d);
    }

    @Nullable
    public String getMacroModeCameraSettingDescription() {
        return this.getIndexedDescription(61452, "Off", "On");
    }

    @Nullable
    public String getDigitalZoomDescription() {
        return this.getIndexedDescription(61453, "Off", "Electronic magnification", "Digital zoom 2x");
    }

    @Nullable
    public String getExposureCompensationDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61454);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)l.longValue() / 3.0 - 2.0) + " EV";
    }

    @Nullable
    public String getBracketStepDescription() {
        return this.getIndexedDescription(61455, "1/3 EV", "2/3 EV", "1 EV");
    }

    @Nullable
    public String getIntervalLengthDescription() {
        if (!((OlympusMakernoteDirectory)this._directory).isIntervalMode()) {
            return "N/A";
        }
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61457);
        return l == null ? null : l + " min";
    }

    @Nullable
    public String getIntervalNumberDescription() {
        if (!((OlympusMakernoteDirectory)this._directory).isIntervalMode()) {
            return "N/A";
        }
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61458);
        return l == null ? null : Long.toString(l);
    }

    @Nullable
    public String getFocalLengthDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61459);
        return l == null ? null : OlympusMakernoteDescriptor.getFocalLengthDescription((double)l.longValue() / 256.0);
    }

    @Nullable
    public String getFocusDistanceDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61460);
        return l == null ? null : (l == 0L ? "Infinity" : l + " mm");
    }

    @Nullable
    public String getFlashFiredDescription() {
        return this.getIndexedDescription(61461, "No", "Yes");
    }

    @Nullable
    public String getDateDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61462);
        if (l == null) {
            return null;
        }
        int n = (int)(l & 0xFFL);
        int n2 = (int)(l >> 16 & 0xFFL);
        int n3 = (int)(l >> 8 & 0xFFL) + 1970;
        if (!DateUtil.isValidDate(n3, n2, n)) {
            return "Invalid date";
        }
        return String.format("%04d-%02d-%02d", n3, n2 + 1, n);
    }

    @Nullable
    public String getTimeDescription() {
        int n;
        int n2;
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61463);
        if (l == null) {
            return null;
        }
        int n3 = (int)(l >> 8 & 0xFFL);
        if (!DateUtil.isValidTime(n3, n2 = (int)(l >> 16 & 0xFFL), n = (int)(l & 0xFFL))) {
            return "Invalid time";
        }
        return String.format("%02d:%02d:%02d", n3, n2, n);
    }

    @Nullable
    public String getMaxApertureAtFocalLengthDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61463);
        if (l == null) {
            return null;
        }
        double d = Math.pow((double)l.longValue() / 16.0 - 0.5, 2.0);
        return OlympusMakernoteDescriptor.getFStopDescription(d);
    }

    @Nullable
    public String getFileNumberMemoryDescription() {
        return this.getIndexedDescription(61467, "Off", "On");
    }

    @Nullable
    public String getLastFileNumberDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61468);
        return l == null ? null : (l == 0L ? "File Number Memory Off" : Long.toString(l));
    }

    @Nullable
    public String getWhiteBalanceRedDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61469);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)l.longValue() / 256.0);
    }

    @Nullable
    public String getWhiteBalanceGreenDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61470);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)l.longValue() / 256.0);
    }

    @Nullable
    public String getWhiteBalanceBlueDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61471);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)l.longValue() / 256.0);
    }

    @Nullable
    public String getSaturationDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61472);
        return l == null ? null : Long.toString(l - 3L);
    }

    @Nullable
    public String getContrastDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61473);
        return l == null ? null : Long.toString(l - 3L);
    }

    @Nullable
    public String getSharpnessCameraSettingDescription() {
        return this.getIndexedDescription(61474, "Hard", "Normal", "Soft");
    }

    @Nullable
    public String getSubjectProgramDescription() {
        return this.getIndexedDescription(61475, "None", "Portrait", "Text", "Night Portrait", "Sunset", "Sports Action");
    }

    @Nullable
    public String getFlashCompensationDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61476);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)(l - 6L) / 3.0) + " EV";
    }

    @Nullable
    public String getIsoSettingDescription() {
        return this.getIndexedDescription(61477, "100", "200", "400", "800", "Auto", "64");
    }

    @Nullable
    public String getCameraModelDescription() {
        return this.getIndexedDescription(61478, "DiMAGE 7", "DiMAGE 5", "DiMAGE S304", "DiMAGE S404", "DiMAGE 7i", "DiMAGE 7Hi", "DiMAGE A1", "DiMAGE S414");
    }

    @Nullable
    public String getIntervalModeDescription() {
        return this.getIndexedDescription(61479, "Still Image", "Time Lapse Movie");
    }

    @Nullable
    public String getFolderNameDescription() {
        return this.getIndexedDescription(61480, "Standard Form", "Data Form");
    }

    @Nullable
    public String getColorModeCameraSettingDescription() {
        return this.getIndexedDescription(61481, "Natural Color", "Black & White", "Vivid Color", "Solarization", "AdobeRGB");
    }

    @Nullable
    public String getColorFilterDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61482);
        return l == null ? null : Long.toString(l - 3L);
    }

    @Nullable
    public String getBlackAndWhiteFilterDescription() {
        return super.getDescription(61483);
    }

    @Nullable
    public String getInternalFlashDescription() {
        return this.getIndexedDescription(61484, "Did Not Fire", "Fired");
    }

    @Nullable
    public String getApexBrightnessDescription() {
        Long l = ((OlympusMakernoteDirectory)this._directory).getLongObject(61485);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return l == null ? null : decimalFormat.format((double)l.longValue() / 8.0 - 6.0);
    }

    @Nullable
    public String getSpotFocusPointXCoordinateDescription() {
        return super.getDescription(61486);
    }

    @Nullable
    public String getSpotFocusPointYCoordinateDescription() {
        return super.getDescription(61487);
    }

    @Nullable
    public String getWideFocusZoneDescription() {
        return this.getIndexedDescription(61488, "No Zone or AF Failed", "Center Zone (Horizontal Orientation)", "Center Zone (Vertical Orientation)", "Left Zone", "Right Zone");
    }

    @Nullable
    public String getFocusModeCameraSettingDescription() {
        return this.getIndexedDescription(61489, "Auto Focus", "Manual Focus");
    }

    @Nullable
    public String getFocusAreaDescription() {
        return this.getIndexedDescription(61490, "Wide Focus (Normal)", "Spot Focus");
    }

    @Nullable
    public String getDecSwitchPositionDescription() {
        return this.getIndexedDescription(61491, "Exposure", "Contrast", "Saturation", "Filter");
    }

    @Nullable
    public String getMakernoteVersionDescription() {
        return this.getVersionBytesDescription(0, 2);
    }

    @Nullable
    public String getImageQuality2Description() {
        return this.getIndexedDescription(259, "Raw", "Super Fine", "Fine", "Standard", "Extra Fine");
    }

    @Nullable
    public String getImageQuality1Description() {
        return this.getIndexedDescription(258, "Raw", "Super Fine", "Fine", "Standard", "Extra Fine");
    }

    @Nullable
    public String getColorModeDescription() {
        return this.getIndexedDescription(257, "Natural Colour", "Black & White", "Vivid Colour", "Solarization", "AdobeRGB");
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(4111, "Normal", "Hard", "Soft");
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(4107, "Auto", "Manual");
    }

    @Nullable
    public String getFocusRangeDescription() {
        return this.getIndexedDescription(4106, "Normal", "Macro");
    }

    @Nullable
    public String getFlashModeDescription() {
        return this.getIndexedDescription(4100, null, null, "On", "Off");
    }

    @Nullable
    public String getDigiZoomRatioDescription() {
        return this.getIndexedDescription(516, "Normal", null, "Digital 2x Zoom");
    }

    @Nullable
    public String getCameraIdDescription() {
        byte[] byArray = ((OlympusMakernoteDirectory)this._directory).getByteArray(521);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getIndexedDescription(514, "Normal (no macro)", "Macro");
    }

    @Nullable
    public String getBWModeDescription() {
        return this.getIndexedDescription(515, "Off", "On");
    }

    @Nullable
    public String getJpegQualityDescription() {
        return this.getIndexedDescription(513, 1, "Standard Quality", "High Quality", "Super High Quality");
    }

    @Nullable
    public String getSpecialModeDescription() {
        long[] lArray = (long[])((OlympusMakernoteDirectory)this._directory).getObject(512);
        if (lArray == null) {
            return null;
        }
        if (lArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch ((int)lArray[0]) {
            case 0: {
                stringBuilder.append("Normal picture taking mode");
                break;
            }
            case 1: {
                stringBuilder.append("Unknown picture taking mode");
                break;
            }
            case 2: {
                stringBuilder.append("Fast picture taking mode");
                break;
            }
            case 3: {
                stringBuilder.append("Panorama picture taking mode");
                break;
            }
            default: {
                stringBuilder.append("Unknown picture taking mode");
            }
        }
        if (lArray.length >= 2) {
            switch ((int)lArray[1]) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuilder.append(" / 1st in a sequence");
                    break;
                }
                case 2: {
                    stringBuilder.append(" / 2nd in a sequence");
                    break;
                }
                case 3: {
                    stringBuilder.append(" / 3rd in a sequence");
                    break;
                }
                default: {
                    stringBuilder.append(" / ");
                    stringBuilder.append(lArray[1]);
                    stringBuilder.append("th in a sequence");
                }
            }
        }
        if (lArray.length >= 3) {
            switch ((int)lArray[2]) {
                case 1: {
                    stringBuilder.append(" / Left to right panorama direction");
                    break;
                }
                case 2: {
                    stringBuilder.append(" / Right to left panorama direction");
                    break;
                }
                case 3: {
                    stringBuilder.append(" / Bottom to top panorama direction");
                    break;
                }
                case 4: {
                    stringBuilder.append(" / Top to bottom panorama direction");
                }
            }
        }
        return stringBuilder.toString();
    }
}

