/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.Iso2022Converter;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IptcReader
implements JpegSegmentMetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPD);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        for (byte[] byArray : iterable) {
            if (byArray.length == 0 || byArray[0] != 28) continue;
            this.extract(new SequentialByteArrayReader(byArray), metadata, byArray.length);
        }
    }

    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata, long l) {
        IptcDirectory iptcDirectory = new IptcDirectory();
        metadata.addDirectory(iptcDirectory);
        int n = 0;
        while ((long)n < l) {
            int n2;
            short s;
            short s2;
            short s3;
            try {
                s3 = sequentialReader.getUInt8();
                ++n;
            }
            catch (IOException iOException) {
                iptcDirectory.addError("Unable to read starting byte of IPTC tag");
                return;
            }
            if (s3 != 28) {
                if ((long)n != l) {
                    iptcDirectory.addError("Invalid IPTC tag marker at offset " + (n - 1) + ". Expected '0x1c' but got '0x" + Integer.toHexString(s3) + "'.");
                }
                return;
            }
            if ((long)(n + 5) >= l) {
                iptcDirectory.addError("Too few bytes remain for a valid IPTC tag");
                return;
            }
            try {
                s2 = sequentialReader.getUInt8();
                s = sequentialReader.getUInt8();
                n2 = sequentialReader.getUInt16();
            }
            catch (IOException iOException) {
                iptcDirectory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((long)((n += 4) + n2) > l) {
                iptcDirectory.addError("Data for tag extends beyond end of IPTC segment");
                return;
            }
            try {
                this.processTag(sequentialReader, iptcDirectory, s2, s, n2);
            }
            catch (IOException iOException) {
                iptcDirectory.addError("Error processing IPTC tag");
                return;
            }
            n += n2;
        }
    }

    private void processTag(@NotNull SequentialReader sequentialReader, @NotNull Directory directory, int n, int n2, int n3) throws IOException {
        String[] stringArray;
        Object object;
        int n4 = n2 | n << 8;
        if (n3 == 0) {
            directory.setString(n4, "");
            return;
        }
        String string = null;
        switch (n4) {
            case 346: {
                object = sequentialReader.getBytes(n3);
                stringArray = Iso2022Converter.convertISO2022CharsetToJavaCharset(object);
                if (stringArray == null) {
                    string = new String((byte[])object);
                    break;
                }
                directory.setString(n4, (String)stringArray);
                return;
            }
            case 256: 
            case 278: 
            case 378: 
            case 512: 
            case 582: {
                if (n3 < 2) break;
                int n5 = sequentialReader.getUInt16();
                sequentialReader.skip(n3 - 2);
                directory.setInt(n4, n5);
                return;
            }
            case 522: {
                directory.setInt(n4, sequentialReader.getUInt8());
                sequentialReader.skip(n3 - 1);
                return;
            }
        }
        if (string == null) {
            object = directory.getString(346);
            if (object != null) {
                string = sequentialReader.getString(n3, (String)object);
            } else {
                stringArray = (String[])sequentialReader.getBytes(n3);
                object = Iso2022Converter.guessEncoding((byte[])stringArray);
                String string2 = string = object != null ? new String((byte[])stringArray, (String)object) : new String((byte[])stringArray);
            }
        }
        if (directory.containsTag(n4)) {
            object = directory.getStringArray(n4);
            if (object == null) {
                stringArray = new String[1];
            } else {
                stringArray = new String[((byte[])object).length + 1];
                System.arraycopy(object, 0, stringArray, 0, ((byte[])object).length);
            }
            stringArray[stringArray.length - 1] = string;
            directory.setStringArray(n4, stringArray);
        } else {
            directory.setString(n4, string);
        }
    }
}

