/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpReader
implements JpegSegmentMetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    private static final int FMT_STRING_ARRAY = 5;
    @NotNull
    private static final String SCHEMA_XMP_PROPERTIES = "http://ns.adobe.com/xap/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";
    @NotNull
    public static final String XMP_JPEG_PREAMBLE = "http://ns.adobe.com/xap/1.0/\u0000";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP1);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        for (byte[] byArray : iterable) {
            int n;
            if (byArray.length < (n = XMP_JPEG_PREAMBLE.length()) || !XMP_JPEG_PREAMBLE.equalsIgnoreCase(new String(byArray, 0, n)) && !"XMP".equalsIgnoreCase(new String(byArray, 0, 3))) continue;
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            this.extract(byArray2, metadata);
        }
    }

    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata) {
        XmpDirectory xmpDirectory = new XmpDirectory();
        try {
            XMPMeta xMPMeta = XMPMetaFactory.parseFromBuffer(byArray);
            XmpReader.processXmpTags(xmpDirectory, xMPMeta);
        }
        catch (XMPException xMPException) {
            xmpDirectory.addError("Error processing XMP data: " + xMPException.getMessage());
        }
        if (!xmpDirectory.isEmpty()) {
            metadata.addDirectory(xmpDirectory);
        }
    }

    public void extract(@NotNull String string, @NotNull Metadata metadata) {
        XmpDirectory xmpDirectory = new XmpDirectory();
        try {
            XMPMeta xMPMeta = XMPMetaFactory.parseFromString(string);
            XmpReader.processXmpTags(xmpDirectory, xMPMeta);
        }
        catch (XMPException xMPException) {
            xmpDirectory.addError("Error processing XMP data: " + xMPException.getMessage());
        }
        if (!xmpDirectory.isEmpty()) {
            metadata.addDirectory(xmpDirectory);
        }
    }

    private static void processXmpTags(XmpDirectory xmpDirectory, XMPMeta xMPMeta) throws XMPException {
        xmpDirectory.setXMPMeta(xMPMeta);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 6, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 7, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 8, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 9, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 1, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 2, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 3, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 12, 3);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 11, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 5, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 10, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 4, 2);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 13, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 14, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 513, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 514, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 515, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 516, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 517, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 518, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 519, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 4097, 4);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, 8192, 1);
        XmpReader.processXmpTag(xMPMeta, xmpDirectory, XmpDirectory.TAG_SUBJECT, 5);
        XMPIterator xMPIterator = xMPMeta.iterator();
        while (xMPIterator.hasNext()) {
            XMPPropertyInfo xMPPropertyInfo = (XMPPropertyInfo)xMPIterator.next();
            String string = xMPPropertyInfo.getPath();
            String string2 = xMPPropertyInfo.getValue();
            if (string == null || string2 == null) continue;
            xmpDirectory.addProperty(string, string2);
        }
    }

    private static void processXmpTag(@NotNull XMPMeta xMPMeta, @NotNull XmpDirectory xmpDirectory, int n, int n2) throws XMPException {
        String string;
        String string2 = XmpDirectory._tagSchemaMap.get(n);
        String string3 = xMPMeta.getPropertyString(string2, string = XmpDirectory._tagPropNameMap.get(n));
        if (string3 == null) {
            return;
        }
        switch (n2) {
            case 2: {
                String[] stringArray = string3.split("/", 2);
                if (stringArray.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(stringArray[0]), (long)Float.parseFloat(stringArray[1]));
                        xmpDirectory.setRational(n, rational);
                    }
                    catch (NumberFormatException numberFormatException) {
                        xmpDirectory.addError(String.format("Unable to parse XMP property %s as a Rational.", string));
                    }
                    break;
                }
                xmpDirectory.addError("Error in rational format for tag " + n);
                break;
            }
            case 3: {
                try {
                    xmpDirectory.setInt(n, Integer.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an int.", string));
                }
                break;
            }
            case 4: {
                try {
                    xmpDirectory.setDouble(n, Double.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an double.", string));
                }
                break;
            }
            case 1: {
                xmpDirectory.setString(n, string3);
                break;
            }
            case 5: {
                int n3 = xMPMeta.countArrayItems(string2, string);
                String[] stringArray = new String[n3];
                for (int i = 1; i <= n3; ++i) {
                    stringArray[i - 1] = xMPMeta.getArrayItem(string2, string, i).getValue();
                }
                xmpDirectory.setStringArray(n, stringArray);
                break;
            }
            default: {
                xmpDirectory.addError(String.format("Unknown format code %d for tag %d", n2, n));
            }
        }
    }
}

