/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextArea;

public class AufbereitenRezept {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Eingabedatei;
    private String Charset;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private String Ausgabedatei;
    private String Funktion;
    private boolean BlanksEntfernen;
    private boolean StrichBlankEntfernen;
    private boolean Komma2NeueZeile;
    private boolean VerbindenZeilen;
    private boolean TextAreaEingabe;
    private boolean TextAreaAusgabe;
    private boolean KopierenAusgabeInClipboard;
    private boolean KopierenClipboardInEingabe;
    private boolean TabsNichtSetzen;
    private boolean NummerierungSetzen;
    private final boolean SetzenWerteInGUInachRun = true;
    private final String Stand = "24.7.2009";

    public static void main(String[] args) {
        AufbereitenRezept aufbereitenRezept = new AufbereitenRezept(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(aufbereitenRezept.ArgTab, aufbereitenRezept.ArgTabDefault, aufbereitenRezept.getHilfeText())) {
            try {
                aufbereitenRezept.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + aufbereitenRezept.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                aufbereitenRezept.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + aufbereitenRezept.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + aufbereitenRezept.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public AufbereitenRezept() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public AufbereitenRezept(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "24.7.2009";
    }

    public boolean isBlanksEntfernen() {
        return this.BlanksEntfernen;
    }

    public boolean isKomma2NeueZeile() {
        return this.Komma2NeueZeile;
    }

    public boolean isKopierenAusgabeInClipboard() {
        return this.KopierenAusgabeInClipboard;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    public boolean isNummerierungSetzen() {
        return this.NummerierungSetzen;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isStrichBlankEntfernen() {
        return this.StrichBlankEntfernen;
    }

    public boolean isTabsNichtSetzen() {
        return this.TabsNichtSetzen;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    public boolean isVerbindenZeilen() {
        return this.VerbindenZeilen;
    }

    public String replaceZeile(String zeile) {
        String[] element;
        Futi.instance();
        String Zeile = zeile;
        String[][] ChangeOhneTab = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".ChangeOhneTab");
        String[] ChangeMitTab = Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".ChangeMitTab");
        String[][] stringArray = ChangeOhneTab;
        int n = ChangeOhneTab.length;
        int n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            Zeile = Zeile.replace(" " + element[0] + " ", " " + element[1] + " ");
            ++n2;
        }
        stringArray = ChangeMitTab;
        n = ChangeMitTab.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            Zeile = Zeile.replace(" " + (String)element + " ", " " + (String)element + "\t");
            ++n2;
        }
        return Zeile;
    }

    public void run() {
        String[] Teile;
        int i;
        FProt fProt = FProt.instance();
        Futi.instance();
        String Zwi = "";
        String[] Zeile = Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), false, this.getCharset());
        ArrayList<String> Ausgabe = new ArrayList<String>();
        this.setSchalter();
        if (this.isBlanksEntfernen()) {
            i = 0;
            while (i < Zeile.length) {
                Zeile[i] = Zeile[i].trim();
                do {
                    Zeile[i] = Zeile[i].replace("  ", " ");
                } while (Zeile[i].indexOf("  ") >= 0);
                ++i;
            }
        }
        if (this.isVerbindenZeilen()) {
            i = 0;
            while (i < Zeile.length) {
                Zwi = String.valueOf(Zwi) + Zeile[i] + " ";
                if (i < Zeile.length - 1) {
                    if (Zeile[i + 1].length() == 0) {
                        Ausgabe.add(Zwi);
                        Zwi = "";
                        Ausgabe.add(Zwi);
                    }
                } else {
                    Ausgabe.add(Zwi);
                }
                ++i;
            }
            Zeile = FString.arrayListToStringArray(Ausgabe);
        }
        if (this.isStrichBlankEntfernen()) {
            i = 0;
            while (i < Zeile.length) {
                do {
                    Zeile[i] = Zeile[i].replace("- ", "");
                } while (Zeile[i].indexOf("- ") >= 0);
                ++i;
            }
        }
        if (this.isKomma2NeueZeile()) {
            Ausgabe.clear();
            i = 0;
            while (i < Zeile.length) {
                Zeile[i] = Zeile[i].trim();
                Teile = Zeile[i].split(",");
                int j = 0;
                while (j < Teile.length) {
                    Ausgabe.add(Teile[j]);
                    ++j;
                }
                ++i;
            }
            Zeile = FString.arrayListToStringArray(Ausgabe);
        }
        i = 0;
        while (i < Zeile.length) {
            Zeile[i] = Zeile[i].trim();
            ++i;
        }
        if (!this.isTabsNichtSetzen()) {
            i = 0;
            while (i < Zeile.length) {
                Zeile[i] = Zeile[i].replace("\t", " ");
                Teile = Zeile[i].split(" ");
                fProt.prot(String.valueOf(i) + ":" + Zeile[i] + " hat " + Teile.length + " Teile", 9);
                fProt.prot(Teile, 11);
                if (Teile.length == 1) {
                    Zeile[i] = "\t" + Zeile[i];
                }
                if (Teile.length == 2) {
                    Zeile[i] = String.valueOf(Teile[0]) + "\t" + Teile[1];
                }
                Zeile[i] = this.replaceZeile(Zeile[i]);
                if (Zeile[i].indexOf("\t") < 0) {
                    Zeile[i] = "\t" + Zeile[i];
                }
                ++i;
            }
        }
        if (this.isNummerierungSetzen()) {
            i = 0;
            while (i < Zeile.length) {
                Zeile[i] = String.valueOf(i + 1) + "\t" + Zeile[i];
                ++i;
            }
        }
        Futi.setAusgabe(Zeile, this.getAusgabedatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), this.isKopierenAusgabeInClipboard());
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setBlanksEntfernen() {
        this.BlanksEntfernen = FParam.getBooleanParameter("BlanksEntfernen", this.ArgTab);
    }

    public void setBlanksEntfernen(boolean blanksEntfernen) {
        this.BlanksEntfernen = blanksEntfernen;
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKomma2NeueZeile() {
        this.Komma2NeueZeile = FParam.getBooleanParameter("Komma2NeueZeile", this.ArgTab);
    }

    public void setKomma2NeueZeile(boolean komma2NeueZeile) {
        this.Komma2NeueZeile = komma2NeueZeile;
    }

    public void setKopierenAusgabeInClipboard() {
        this.KopierenAusgabeInClipboard = FParam.getBooleanParameter("KopierenAusgabeInClipboard", this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard(boolean kopierenAusgabeInClipboard) {
        this.KopierenAusgabeInClipboard = kopierenAusgabeInClipboard;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setNummerierungSetzen() {
        this.NummerierungSetzen = FParam.getBooleanParameter("NummerierungSetzen", this.ArgTab);
    }

    public void setNummerierungSetzen(boolean nummerierungSetzen) {
        this.NummerierungSetzen = nummerierungSetzen;
    }

    public void setSchalter() {
        if (this.getFunktion().compareTo("Z") == 0) {
            this.setBlanksEntfernen(false);
            this.setStrichBlankEntfernen(false);
            this.setKomma2NeueZeile(false);
            this.setVerbindenZeilen(false);
            this.setTabsNichtSetzen(false);
            this.setNummerierungSetzen(true);
        }
        if (this.getFunktion().compareTo("VZ") == 0) {
            this.setBlanksEntfernen(true);
            this.setStrichBlankEntfernen(true);
            this.setKomma2NeueZeile(true);
            this.setVerbindenZeilen(false);
            this.setTabsNichtSetzen(false);
            this.setNummerierungSetzen(true);
        }
        if (this.getFunktion().compareTo("VB") == 0) {
            this.setBlanksEntfernen(true);
            this.setStrichBlankEntfernen(true);
            this.setKomma2NeueZeile(false);
            this.setVerbindenZeilen(true);
            this.setTabsNichtSetzen(true);
            this.setNummerierungSetzen(false);
        }
    }

    public void setStrichBlankEntfernen() {
        this.StrichBlankEntfernen = FParam.getBooleanParameter("StrichBlankEntfernen", this.ArgTab);
    }

    public void setStrichBlankEntfernen(boolean strichBlankEntfernen) {
        this.StrichBlankEntfernen = strichBlankEntfernen;
    }

    public void setTabsNichtSetzen() {
        this.TabsNichtSetzen = FParam.getBooleanParameter("TabsNichtSetzen", this.ArgTab);
    }

    public void setTabsNichtSetzen(boolean tabsNichtSetzen) {
        this.TabsNichtSetzen = tabsNichtSetzen;
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setVerbindenZeilen() {
        this.VerbindenZeilen = FParam.getBooleanParameter("VerbindenZeilen", this.ArgTab);
    }

    public void setVerbindenZeilen(boolean verbindenZeilen) {
        this.VerbindenZeilen = verbindenZeilen;
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setCharset();
        this.setBlanksEntfernen();
        this.setStrichBlankEntfernen();
        this.setKomma2NeueZeile();
        this.setVerbindenZeilen();
        this.setTabsNichtSetzen();
        this.setNummerierungSetzen();
        this.setEingabedatei();
        this.setAusgabedatei();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
        this.setKopierenAusgabeInClipboard();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Zusammenfassen von Schaltern                    :" + this.getFunktion());
        fProt.prot("Charset (Codepage) fuer Eingabe                 :" + this.getCharset());
        fProt.prot("Blanks entfernen                                :" + this.isBlanksEntfernen());
        fProt.prot("Strich mit folgendem Blank entfernen            :" + this.isStrichBlankEntfernen());
        fProt.prot("bei Komma Zeilenumbruch einfuegen               :" + this.isKomma2NeueZeile());
        fProt.prot("Zeilen verbinden (Ende bei Leerzeile)           :" + this.isVerbindenZeilen());
        fProt.prot("Tabs nicht setzen                               :" + this.isTabsNichtSetzen());
        fProt.prot("Nummerierung (fuer Zutaten) setzen              :" + this.isNummerierungSetzen());
        fProt.prot("Eingabedatei                                    :" + this.getEingabedatei());
        fProt.prot("Ausgabedatei                                    :" + this.getAusgabedatei());
        fProt.prot("TextArea statt Eingabedatei verwenden           :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden           :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Eingabe in TextArea kopieren:" + this.isKopierenClipboardInEingabe());
        fProt.prot("TextArea fuer Ausgabe in Zwischenablage kopieren:" + this.isKopierenAusgabeInClipboard());
    }
}

