/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Datei2Tabelle;
import de.nss.jfi.FDir;
import de.nss.jfi.SQLBatch;
import de.nss.jfi.Tabelle2Datei;
import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.FSystemProperties;
import de.nss.jfi.Uti.Futi;
import de.nss.jfi.VglVerz;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Backup {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String DBName;
    private String FolgeBefehl;
    private String FolgeParameter;
    private String SteuerungTabelle;
    private String SteuerungDatei;
    private String MedienTabelle;
    private String Auswahl;
    private boolean MoveDateien;
    private String Funktion;
    private boolean NurCheck;
    private boolean robocopyVorhanden;
    private boolean LeerenStatussaetze;
    private boolean DateiStattDB;
    private String RestoreTree;
    private String RestoreOrg;
    private String RestoreZuDatum;
    private String RestoreZuUhrzeit;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean ShutdownAfterBackup;
    private boolean SleepAfterBackup;
    private final String Stand = "19.12.2018";

    private static String abgleichenVerzeichnisse(String OrgVerz, String ZielVerz, boolean nurProtokoll) {
        String Zeile;
        FProt fProt = FProt.instance();
        VglVerz vglVerz = new VglVerz();
        File TestDirOrg = new File(OrgVerz);
        File TestDirZiel = new File(ZielVerz);
        if (TestDirOrg.canRead() && (TestDirZiel.canRead() || !nurProtokoll)) {
            vglVerz.setPrimaerVerz(OrgVerz);
            vglVerz.setSekundaerVerz(ZielVerz);
            vglVerz.setProtokollohneHeader(true);
            vglVerz.setTest(nurProtokoll);
            fProt.prot("VglVerz Start", 2);
            vglVerz.run();
            Zeile = vglVerz.holenKurzprotokoll();
        } else {
            Zeile = String.valueOf(OrgVerz) + " und/oder " + ZielVerz + " nicht vorhanden!";
        }
        return Zeile;
    }

    private static boolean checkZielVerz(String zielVerz) {
        boolean ok = true;
        String ZielVerz = FDatei.checkDatei(zielVerz, 'V', 'W', "Zielverzeichnis Backup", true);
        if (ZielVerz.length() < 6 || Futi.isWindows() && (ZielVerz.charAt(1) != ':' || ZielVerz.charAt(2) != '\\')) {
            FProt.instance().prot("Zielverzeichnis >" + zielVerz + "< fehlerhaft bzw. nicht zugreifbar!");
            ok = false;
        }
        return ok;
    }

    private static String erstellenVerzeichnisListe(String OrgVerz, String zielVerz, int tiefe) {
        FProt fProt = FProt.instance();
        String Zeile = "erstelle Verzeichnisbaum von " + OrgVerz;
        String ZielVerz = FDatei.checkDatei(zielVerz, 'V', 'W', "Zielverzeichnis Backup", false);
        if (Backup.checkZielVerz(ZielVerz)) {
            FDir fDir = new FDir();
            fDir.setVerzeichnis(OrgVerz);
            String ZielDatei = String.valueOf(zielVerz) + System.getProperty("file.separator") + "Dateien.txt";
            fDir.setAusgabedatei(ZielDatei);
            fDir.setNurDirectories(false);
            fDir.setTiefe(tiefe);
            fDir.setMusterFormat("K");
            fDir.setFormat(":S:T:g:T:V:T:F");
            fDir.setFunktion("L");
            fProt.prot("Aufruf FDir.java: " + fDir.getVerzeichnis() + " Dateiliste, Tiefe=" + tiefe + " -> " + ZielDatei);
            fDir.run();
            ZielDatei = String.valueOf(zielVerz) + System.getProperty("file.separator") + "Verzeichnisse.txt";
            fDir.setAusgabedatei(ZielDatei);
            fDir.setNurDirectories(true);
            fDir.setFormat(":g:T:R");
            fDir.setFunktion("L");
            fProt.prot("Aufruf FDir.java: " + fDir.getVerzeichnis() + " Verzeichnisliste, Tiefe=" + tiefe + " -> " + ZielDatei);
            fDir.run();
            fProt.prot("Aufruf FDir.java beendet", 2);
        }
        return Zeile;
    }

    private static String getLastUpdate(String[] zielDirs, boolean searchFullBackup) {
        String zeitpunkt = "";
        char art_2 = 'I';
        if (searchFullBackup) {
            art_2 = 'F';
        }
        int i = 0;
        while (i < zielDirs.length) {
            if (zielDirs[i].charAt(20) == 'F' || zielDirs[i].charAt(20) == art_2) {
                zeitpunkt = String.valueOf(zielDirs[i].substring(8, 10)) + zielDirs[i].substring(4, 8) + zielDirs[i].substring(0, 4) + "," + zielDirs[i].substring(11, 19);
                break;
            }
            ++i;
        }
        return zeitpunkt;
    }

    public static void main(String[] args) {
        Backup backup = new Backup(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(backup.ArgTab, backup.ArgTabDefault, backup.getHilfeText())) {
            try {
                backup.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + backup.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                backup.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + backup.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + backup.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    private static String[] prepareDirs(String[] dirs) {
        ArrayList<String> validDirs = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            int posDatum = Math.max(dir.lastIndexOf("_I"), dir.lastIndexOf("_F")) - 19;
            if (posDatum >= 0) {
                try {
                    dateFormat.parse(dir.substring(posDatum, posDatum + 19));
                    validDirs.add(String.valueOf(dir.substring(posDatum, posDatum + 19)) + "/" + dir.substring(dir.length() - 1) + "/" + dir);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return FQuickSort.instance().quickSort(FString.arrayListToStringArray(validDirs), false, false);
    }

    private static void vglDir(String org, String ziel) {
        FDir fDir = new FDir();
        Datei2Tabelle datei2Tabelle = new Datei2Tabelle();
        SQLBatch sQLBatch = new SQLBatch();
        Tabelle2Datei tabelle2Datei = new Tabelle2Datei();
        String orgName = String.valueOf(System.getenv("Temp")) + System.getProperty("file.separator") + "Access" + System.getProperty("file.separator") + "FvglDirOrg.txt";
        String zielName = String.valueOf(System.getenv("Temp")) + System.getProperty("file.separator") + "Access" + System.getProperty("file.separator") + "FvglDirZiel.txt";
        String dbName = String.valueOf(System.getenv("Temp")) + System.getProperty("file.separator") + "Access" + System.getProperty("file.separator") + "FvglDir.mdb";
        String[][] daten = new String[][]{{""}};
        ArrayList<String> befehle = new ArrayList<String>();
        FProt.instance().prot("vergleiche >" + org + "< mit >" + ziel + "<");
        fDir.setVerzeichnis(org);
        fDir.setAusgabedatei(orgName);
        fDir.setFunktion("L");
        fDir.setFormat(":S:T:G:T:R\\:F:T:R:T:F:Tnicht_identisch:Tnicht_verlegen");
        fDir.setMusterFormat("K");
        fDir.run();
        fDir.setVerzeichnis(ziel);
        fDir.setAusgabedatei(zielName);
        fDir.run();
        datei2Tabelle.setTabelle("Org");
        datei2Tabelle.setExterneListe(FString.instance().convertStringArrayToTabelle(new FFile(orgName).inhaltToStringArray()));
        datei2Tabelle.setDBName(dbName);
        datei2Tabelle.setOhneFeldnamen(true);
        datei2Tabelle.setOhneStand(false);
        datei2Tabelle.setNichtLoeschen(false);
        datei2Tabelle.setLeereSpaltenUebernehmen(true);
        datei2Tabelle.run();
        datei2Tabelle.setTabelle("Ziel");
        datei2Tabelle.setExterneListe(FString.instance().convertStringArrayToTabelle(new FFile(zielName).inhaltToStringArray()));
        datei2Tabelle.run();
        sQLBatch.setDBName(dbName);
        sQLBatch.setBefehl("UPDATE Org INNER JOIN Ziel ON (Org.Verz_Datei = Ziel.Verz_Datei) AND (Org.Datum_Zeit = Ziel.Datum_Zeit) AND (Org.Groesse = Ziel.Groesse) SET Org.identisch = 'identisch', Ziel.identisch = 'identisch'");
        sQLBatch.run();
        tabelle2Datei.setDBName(dbName);
        tabelle2Datei.setTabelle("zu_verlegen");
        tabelle2Datei.setFelder("Dateiname, von, nach");
        tabelle2Datei.setTrimFeldinhalte(true);
        tabelle2Datei.setExterneListe(daten);
        tabelle2Datei.run();
        String[][] stringArray = daten = tabelle2Datei.getExterneListe();
        int n = daten.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (element.length > 1) {
                befehle.add(String.valueOf(ziel) + "\\" + element[1] + "\\" + element[0] + "/" + ziel + "\\" + element[2] + "\\" + element[0]);
            }
            ++n2;
        }
        FBefehl.executeDateiBefehl(FString.arrayListToStringArray(befehle), "/", "renForce", false);
    }

    public Backup() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Backup(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private String aufrufFDir(String OrgVerz, String ZielVerz, String Letzter_Backup) {
        FDir fDir = new FDir();
        FProt fProt = FProt.instance();
        fDir.setVerzeichnis(OrgVerz);
        fDir.setStichtagAlsDatum(Letzter_Backup.length() > 10 ? Letzter_Backup.substring(0, 10) : "01.01.1980");
        fDir.setStichtagUhrzeitZumDatum(Letzter_Backup.length() >= 19 ? Letzter_Backup.substring(11, 19).replace(".", ":") : "01:00:00");
        fDir.setKopierVerzeichnis(ZielVerz);
        if (this.isNurCheck()) {
            fDir.setFunktion("L");
        } else {
            fDir.setFunktion("KV");
        }
        if (FSystemProperties.holenSystemProperty("user.name").compareTo("hans") == 0) {
            fDir.setAuswahlVerzeichnis(Futi.isWindows() ? ".*.metadata.*" : ".*\\/\\..*");
            fDir.setAuswahlVerzExclude(true);
            fDir.setAuswahlDatei(Futi.isWindows() ? ".*.class" : "\\..*");
            fDir.setAuswahlDatExclude(true);
        }
        fProt.prot("Aufruf FDir.java: " + fDir.getVerzeichnis() + " -> " + fDir.getKopierVerzeichnis() + " Dateien juenger als " + fDir.getStichtagAlsDatum() + " " + fDir.getStichtagUhrzeitZumDatum() + ", excl. Verz:" + fDir.getAuswahlVerzeichnis() + ", excl. Dat:" + fDir.getAuswahlDatei());
        fDir.run();
        fProt.prot("Aufruf FDir.java beendet", 2);
        return "Kopieren von >" + OrgVerz + "< nach >" + ZielVerz + "<" + (Letzter_Backup.length() >= 19 ? " (Dateien juenger als " + Letzter_Backup : "");
    }

    private void backupDateien(String zeile) {
        FProt fProt = FProt.instance();
        Futi.instance();
        String LVerz = "";
        ArrayList<BackupZeile> backupZeilen = new ArrayList<BackupZeile>();
        ArrayList<String> msgArray = new ArrayList<String>();
        String Zeile = zeile;
        msgArray.add("INSERT INTO LOG (Logsatz) VALUES('" + Zeile + "')");
        if (this.isLeerenStatussaetze()) {
            msgArray.add("DELETE * FROM Status");
        }
        msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Zeile + "')");
        backupZeilen = this.getSteuerungszeilen(backupZeilen, zeile);
        if (backupZeilen.size() == 0) {
            fProt.prot("Keine Steuerungsdaten gefunden, keine Verarbeitung, kein Backup!");
        } else {
            Statement DBStatement;
            int i = 0;
            while (i < backupZeilen.size()) {
                String Verz = backupZeilen.get(i).getVerz();
                File TestDirOrg = new File(Verz = FDatei.pruefenPfadname(Verz, 2, false));
                if (!TestDirOrg.exists() || !TestDirOrg.canRead()) {
                    if (Verz.compareToIgnoreCase(LVerz) != 0) {
                        fProt.prot(String.valueOf(Verz) + " nicht vorhanden bzw. nicht zugreifbar!");
                    }
                    LVerz = Verz;
                } else {
                    String Medium = backupZeilen.get(i).getMedium();
                    String Pfad = backupZeilen.get(i).getPfad();
                    Pfad = FDatei.pruefenPfadname(Pfad, 2, false);
                    String Ziel = backupZeilen.get(i).getZiel();
                    Ziel = FDatei.pruefenPfadname(Ziel, 0, false);
                    int Stufe = backupZeilen.get(i).getStufe();
                    boolean checkMove = backupZeilen.get(i).isCheckMove();
                    int Tage_bis_naechster_Full_Backup = backupZeilen.get(i).getTage_bis_naechster_Full_Backup();
                    FFile TestDirZiel = new FFile(String.valueOf(Pfad) + System.getProperty("file.separator") + FDatei.pruefenPfadname(Ziel, 2, false) + "_Extra" + System.getProperty("file.separator"));
                    TestDirZiel.setSortiereAufsteigend(false);
                    String[] ZielDirs = Backup.prepareDirs(TestDirZiel.listFileNames('V', 3, "(.*_F)||(.*_I)"));
                    String Letzter_Backup = Backup.getLastUpdate(ZielDirs, false);
                    String Letzter_Full_Backup = Backup.getLastUpdate(ZielDirs, true);
                    String Fkt = this.set_Fkt(Stufe, Letzter_Full_Backup, Tage_bis_naechster_Full_Backup);
                    fProt.prot(String.valueOf(Verz) + " -> " + Pfad + System.getProperty("file.separator") + Ziel + " (Art:" + Fkt + (Medium.length() > 0 ? ", Zielmedium:" + Medium : "") + (Letzter_Backup.length() > 0 ? ", Letztes Backup: " + Letzter_Backup : "") + (Letzter_Full_Backup.length() > 0 ? ", Letztes Fullbackup: " + Letzter_Full_Backup : "") + ")");
                    fProt.prot("V:" + Verz + " M:" + Medium + " MV:" + Pfad + " ZV:" + Ziel + " I:" + Fkt + " ==", 2);
                    fProt.prot("S:" + this.getFunktion() + " St:" + Stufe + " I:" + Fkt + " V:" + Verz + " M:" + Medium + " MV:" + Pfad + " ZV:" + Ziel, 2);
                    if (this.getFunktion().charAt(0) != 'Z') {
                        String ZielVerz;
                        if ((Fkt.charAt(0) == '1' || Fkt.charAt(0) == '2' || Fkt.charAt(0) == 'F' || Fkt.charAt(0) == 'I') && Backup.checkZielVerz(ZielVerz = FDatei.pruefenPfadname(String.valueOf(Pfad) + System.getProperty("file.separator") + Ziel, 2, false))) {
                            if (this.isNurCheck()) {
                                Zeile = Backup.abgleichenVerzeichnisse(Verz, ZielVerz, true);
                            } else {
                                if (checkMove && this.isMoveDateien() && !this.isDateiStattDB()) {
                                    Backup.vglDir(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                                }
                                Zeile = this.synchronisierenVerzeichnisse(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                            }
                            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Futi.getZeitSortierbar() + " " + Zeile + "')");
                        }
                        if ((Fkt.charAt(0) == '2' || Fkt.charAt(0) == 'F' || Fkt.charAt(0) == 'I') && Backup.checkZielVerz(ZielVerz = String.valueOf(Pfad) + System.getProperty("file.separator") + Ziel + "_Extra" + System.getProperty("file.separator") + "_alles")) {
                            if (checkMove && this.isMoveDateien() && !this.isDateiStattDB()) {
                                Backup.vglDir(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                            }
                            Zeile = this.kopierenVerzeichnis(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Futi.getZeitSortierbar() + " " + Zeile + "')");
                        }
                        if (Fkt.charAt(0) == 'I' || Fkt.charAt(0) == 'Q') {
                            ZielVerz = String.valueOf(Pfad) + System.getProperty("file.separator") + FDatei.pruefenPfadname(Ziel, 2, false) + "_Extra" + System.getProperty("file.separator") + Futi.getZeitSortierbar("-") + (Letzter_Backup.length() > 0 ? "_I" : "_F");
                            if (Backup.checkZielVerz(ZielVerz)) {
                                if (Letzter_Backup.length() > 0) {
                                    this.aufrufFDir(Verz, ZielVerz, Letzter_Backup);
                                } else {
                                    Zeile = this.synchronisierenVerzeichnisse(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                                }
                            }
                            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Futi.getZeitSortierbar() + " " + Zeile + "')");
                        }
                        if (Fkt.charAt(0) == 'F' && Backup.checkZielVerz(ZielVerz = String.valueOf(Pfad) + System.getProperty("file.separator") + FDatei.pruefenPfadname(Ziel, 2, false) + "_Extra" + System.getProperty("file.separator") + Futi.getZeitSortierbar("-") + "_F")) {
                            Zeile = this.kopierenVerzeichnis(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false));
                            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Futi.getZeitSortierbar() + " " + Zeile + "')");
                        }
                        if (Fkt.charAt(0) == '0' && Backup.checkZielVerz(ZielVerz = String.valueOf(Pfad) + System.getProperty("file.separator") + FDatei.pruefenPfadname(Ziel, 2, false) + "_Extra" + System.getProperty("file.separator") + Futi.getZeitSortierbar("-") + "_L")) {
                            Zeile = Backup.erstellenVerzeichnisListe(Verz, FDatei.pruefenPfadname(ZielVerz, 2, false), Tage_bis_naechster_Full_Backup);
                            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Futi.getZeitSortierbar() + " " + Zeile + "')");
                        }
                    }
                }
                ++i;
            }
            Zeile = String.valueOf(Futi.getZeitSortierbar()) + " Ende";
            msgArray.add("INSERT INTO LOG (Logsatz) VALUES('" + Zeile + "')");
            msgArray.add("INSERT INTO Status (Statussatz) VALUES('" + Zeile + "')");
            if (!this.isDateiStattDB() && (DBStatement = FDB.createDBStatement(this.getDBName())) != null) {
                i = 0;
                while (i < msgArray.size()) {
                    FDB.executeUpdate(DBStatement, (String)msgArray.get(i), true, 1);
                    ++i;
                }
            }
        }
    }

    private String checkMedien() {
        String Zeile = "";
        if (!this.isDateiStattDB()) {
            Zeile = String.valueOf(Futi.getZeitSortierbar()) + " Start Funktion=" + this.getFunktion() + ", Medien: ";
            FProt fProt = FProt.instance();
            Futi.instance();
            int Anzahl_Medien = 0;
            String[][] Medien = new String[20][2];
            FGregorianCalendar zeitBackup = new FGregorianCalendar();
            FGregorianCalendar zeitJetzt = new FGregorianCalendar(System.currentTimeMillis());
            SimpleDateFormat tagFormat = new SimpleDateFormat("dd.MM.yyyy");
            ArrayList<String> SQLArray = new ArrayList<String>();
            Statement DBStatement = FDB.createDBStatement(this.getDBName());
            if (DBStatement != null) {
                ResultSet rs = FDB.executeQuery(DBStatement, "SELECT * FROM " + FDB.instance().getName4Query(this.getMedienTabelle()), true, 1);
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            String Medium;
                            Medien[Anzahl_Medien][0] = Medium = rs.getString("Medium").trim();
                            Medien[Anzahl_Medien++][1] = " ";
                            String Pfad = rs.getString("Pfad").trim();
                            boolean zugreifbar_letzter_Lauf = rs.getBoolean("zugreifbar");
                            fProt.prot(" M:" + Medium + " MV:" + Pfad + " Status zugreifbar letzter Lauf: " + zugreifbar_letzter_Lauf, 2);
                            File Check_Medium = new File(Pfad);
                            boolean zugreifbar_aktuell = Check_Medium.exists() && Check_Medium.canWrite() && Check_Medium.getFreeSpace() > 0L;
                            try {
                                int Wartezeit_naechster_Backup = rs.getInt("Wartezeit_naechster_Backup");
                                if (Wartezeit_naechster_Backup > 0) {
                                    String tag = rs.getString("letzter_Backup_Tag");
                                    zeitBackup.setTime(tagFormat.parse(tag));
                                    fProt.prot(" M:" + Medium + " letzter Backup: " + zeitBackup.toGermanFormat('D'), 0);
                                    zeitBackup.add(10, Wartezeit_naechster_Backup * 24);
                                    fProt.prot(" M:" + Medium + " naechster Backup: " + zeitBackup.toGermanFormat('D'), 0);
                                    boolean bl = zugreifbar_aktuell = zeitJetzt.getTimeInMillis() >= zeitBackup.getTimeInMillis();
                                    if (zugreifbar_aktuell) {
                                        SQLArray.add("UPDATE " + FDB.instance().getName4Query(this.getMedienTabelle()) + " Set letzter_Backup_Tag = '" + zeitJetzt.toGermanFormat('K') + "' WHERE Medium = '" + Medium + "'");
                                    }
                                }
                            }
                            catch (Exception tag) {
                                // empty catch block
                            }
                            fProt.prot(" M:" + Medium + " MV:" + Pfad + " Status zugreifbar aktuell: " + zugreifbar_aktuell, 2);
                            Zeile = String.valueOf(Zeile) + Medium + " " + (zugreifbar_aktuell ? "on" : "off") + ", ";
                            if (zugreifbar_aktuell == zugreifbar_letzter_Lauf) continue;
                            FDB.instance();
                            SQLArray.add("UPDATE " + FDB.instance().getName4Query(this.getMedienTabelle()) + " Set zugreifbar = " + (zugreifbar_aktuell ? FDB.getDBtrue() : FDB.getDBfalse()) + " WHERE Medium = '" + Medium + "'");
                        }
                        int i = 0;
                        while (i < SQLArray.size()) {
                            FDB.executeUpdate(DBStatement, (String)SQLArray.get(i), true, 1);
                            ++i;
                        }
                        i = 0;
                        while (i < Anzahl_Medien) {
                            fProt.prot(String.valueOf(Medien[i][0]) + Medien[i][1], 7);
                            ++i;
                        }
                    }
                    catch (SQLException SQLe1) {
                        FDB.handleException(SQLe1);
                    }
                }
                FDB.closeDBStatement(DBStatement);
                fProt.prot(Zeile);
            }
        }
        return Zeile;
    }

    public String getAuswahl() {
        return this.Auswahl;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFolgeBefehl() {
        return this.FolgeBefehl;
    }

    public String getFolgeParameter() {
        return this.FolgeParameter;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getMedienTabelle() {
        return this.MedienTabelle;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getRestoreOrg() {
        return this.RestoreOrg;
    }

    public String getRestoreTree() {
        return this.RestoreTree;
    }

    public String getRestoreZuDatum() {
        return this.RestoreZuDatum;
    }

    public String getRestoreZuUhrzeit() {
        return this.RestoreZuUhrzeit;
    }

    public String getStand() {
        return "19.12.2018";
    }

    public String getSteuerungDatei() {
        return this.SteuerungDatei;
    }

    public ArrayList<BackupZeile> getSteuerungszeilen(ArrayList<BackupZeile> backupZeilen, String zeile) {
        FProt fProt = FProt.instance();
        FDB fDB = FDB.instance();
        String WhereTeil = "";
        String sqlStatement = "";
        ArrayList<String> SQLArray = new ArrayList<String>();
        if (this.isDateiStattDB()) {
            String[][] zeilen;
            String[][] stringArray = zeilen = FString.convertStringArrayToTabelle(new FFile(this.getSteuerungDatei()).inhaltToStringArray(), 6, true);
            int n = zeilen.length;
            int n2 = 0;
            while (n2 < n) {
                String[] element = stringArray[n2];
                if (!element[0].startsWith("*")) {
                    BackupZeile backupZeile = new BackupZeile();
                    backupZeile.init();
                    backupZeile.setVerz(element[0]);
                    backupZeile.setPfad(element[1]);
                    backupZeile.setZiel(element[2]);
                    try {
                        backupZeile.setStufe(Integer.parseInt(element[3]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        backupZeile.setTage_bis_naechster_Full_Backup(Integer.parseInt(element[4]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    backupZeile.setMedium(element[5]);
                    backupZeilen.add(backupZeile);
                }
                ++n2;
            }
        } else {
            String Zeile = zeile;
            SQLArray.add("INSERT INTO LOG (Logsatz) VALUES('" + Zeile + "')");
            if (this.isLeerenStatussaetze()) {
                SQLArray.add("DELETE * FROM Status");
            }
            SQLArray.add("INSERT INTO Status (Statussatz) VALUES('" + Zeile + "')");
            WhereTeil = this.getAuswahl().length() > 0 ? " WHERE zugreifbar = " + FDB.getDBtrue() + " and (VonMedium = '" + fDB.getName4Query(this.getAuswahl()) + "'" + " or Medium = '" + fDB.getName4Query(this.getAuswahl()) + "')" : " WHERE zugreifbar = " + FDB.getDBtrue();
            Statement DBStatement = FDB.createDBStatement(this.getDBName());
            if (DBStatement != null) {
                ResultSet rs = FDB.executeQuery(DBStatement, "SELECT Verz, Medium, Pfad, Ziel, Stufe, CheckMove, zugreifbar, Tage_bis_naechster_Full_Backup FROM " + this.getTabelle() + WhereTeil, true, 1);
                if (rs != null) {
                    try {
                        while (rs.next()) {
                            BackupZeile backupZeile = new BackupZeile();
                            backupZeile.init();
                            backupZeile.setVerz(rs.getString("Verz").trim());
                            backupZeile.setMedium(rs.getString("Medium").trim());
                            backupZeile.setPfad(rs.getString("Pfad").trim());
                            backupZeile.setZiel(rs.getString("Ziel").trim());
                            backupZeile.setStufe(rs.getInt("Stufe"));
                            backupZeile.setCheckMove(rs.getString("CheckMove").compareTo("1") == 0);
                            backupZeile.setTage_bis_naechster_Full_Backup(rs.getInt("Tage_bis_naechster_Full_Backup"));
                            backupZeilen.add(backupZeile);
                        }
                    }
                    catch (SQLException SQLe) {
                        fProt.prot("Fehler bei SQL-Statements: ");
                        FDB.handleException(SQLe);
                    }
                    catch (Exception e) {
                        fProt.prot(e.toString());
                    }
                }
                FDB.closeDBStatement(DBStatement);
            }
        }
        return backupZeilen;
    }

    public String getSteuerungTabelle() {
        return this.SteuerungTabelle;
    }

    public String getTabelle() {
        return this.SteuerungTabelle;
    }

    public boolean isDateiStattDB() {
        return this.DateiStattDB;
    }

    public boolean isLeerenStatussaetze() {
        return this.LeerenStatussaetze;
    }

    public boolean isMoveDateien() {
        return this.MoveDateien;
    }

    public boolean isNurCheck() {
        return this.NurCheck;
    }

    public boolean isRobocopyVorhanden() {
        return this.robocopyVorhanden;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isShutdownAfterBackup() {
        return this.ShutdownAfterBackup;
    }

    public boolean isSleepAfterBackup() {
        return this.SleepAfterBackup;
    }

    private String kopierenVerzeichnis(String OrgVerz, String zielVerz) {
        FProt fProt = FProt.instance();
        String Zeile = "";
        String ZielVerz = FDatei.checkDatei(zielVerz, 'V', 'W', "Zielverzeichnis Backup", false);
        if (Backup.checkZielVerz(ZielVerz)) {
            if (this.isRobocopyVorhanden()) {
                String[] Parm = FString.verbindenArrayMitString(FString.verbindenStringArray(new String[]{FDatei.checkFileSeperator(OrgVerz, true), FDatei.checkFileSeperator(ZielVerz, true)}, Futi.getBenutzerWert("RobocopyRsyncParameter").split(" ")), Futi.getBenutzerWert("RobocopyRsyncCopy"));
                Zeile = String.valueOf(Futi.getBenutzerWert("RobocopyRsyncOrtName")) + " " + FString.stringArrayToString(Parm);
                fProt.prot(Zeile);
                if (this.isNurCheck()) {
                    Zeile = Backup.abgleichenVerzeichnisse(OrgVerz, ZielVerz, true);
                } else {
                    fProt.prot(FBefehl.aufrufBefehl(Futi.getBenutzerWert("RobocopyRsyncOrtName"), Parm, 5), 2);
                }
            } else {
                fProt.prot("internes Kopieren von >" + OrgVerz + "< nach >" + ZielVerz + "<");
                Zeile = this.aufrufFDir(OrgVerz, ZielVerz, "");
            }
        }
        return Zeile;
    }

    private void restoreDateien() {
        int startRestore = -1;
        int endRestore = 0;
        boolean endRestoreFound = false;
        if (this.getRestoreTree().length() == 0) {
            FProt.instance().prot("Kein wiederherzustellendes Verzeichnis angegeben!");
        } else if (this.getRestoreOrg().length() == 0) {
            FProt.instance().prot("Kein Verzeichnisbaum mit Sicherungen angegeben!");
        } else if (this.getRestoreZuDatum().length() < 10) {
            FProt.instance().prot("Restore zum Datum zu kurz!");
        } else if (this.getRestoreZuUhrzeit().length() < 8) {
            FProt.instance().prot("Restore zum Zeitpunkt zu kurz!");
        } else {
            String restoreVerz = FDatei.pruefenPfadname(this.getRestoreTree(), 2, false);
            FFile OrgVerz = new FFile(FDatei.pruefenPfadname(this.getRestoreOrg(), 2, false));
            String[] OrgDirs = Backup.prepareDirs(OrgVerz.listFileNames('V', 3, "(.*_F)||(.*_I)"));
            String RestoreDatumZeit = String.valueOf(this.getRestoreZuDatum().substring(6, 10)) + "." + this.getRestoreZuDatum().substring(3, 5) + "." + this.getRestoreZuDatum().substring(0, 2) + "-" + this.getRestoreZuUhrzeit().substring(0, 2) + "." + this.getRestoreZuUhrzeit().substring(3, 5) + "." + this.getRestoreZuUhrzeit().substring(6, 8);
            int i = 0;
            while (i < OrgDirs.length) {
                if (!endRestoreFound && OrgDirs[i].substring(0, 19).compareTo(RestoreDatumZeit) <= 0) {
                    endRestore = i;
                    endRestoreFound = true;
                }
                if (OrgDirs[i].charAt(20) == 'F' && OrgDirs[i].substring(0, 19).compareTo(RestoreDatumZeit) <= 0) {
                    startRestore = i;
                    break;
                }
                ++i;
            }
            FProt.instance().prot("Restore >" + restoreVerz + "< zum Zeitpunkt " + this.getRestoreZuDatum() + " " + this.getRestoreZuUhrzeit());
            if (!endRestoreFound) {
                FProt.instance().prot("keine geeigneten Sicherungen gefunden");
            } else {
                FProt.instance().prot("Restore >" + restoreVerz + "< aus folgenden Sicherungen:");
                i = startRestore = startRestore == -1 ? OrgDirs.length - 1 : startRestore;
                while (i >= endRestore) {
                    FProt.instance().prot(String.valueOf(OrgVerz.getAbsolutePath()) + System.getProperty("file.separator") + OrgDirs[i].substring(22));
                    if (this.getFunktion().charAt(0) == 'R') {
                        if (OrgDirs[i].charAt(20) == 'F') {
                            this.synchronisierenVerzeichnisse(String.valueOf(OrgVerz.getAbsolutePath()) + System.getProperty("file.separator") + OrgDirs[i].substring(22), restoreVerz);
                        } else {
                            this.kopierenVerzeichnis(String.valueOf(OrgVerz.getAbsolutePath()) + System.getProperty("file.separator") + OrgDirs[i].substring(22), restoreVerz);
                        }
                    }
                    --i;
                }
            }
        }
    }

    public void run() {
        this.setRobocopyVorhanden(FBefehl.testBefehl(Futi.getBenutzerWert("RobocopyRsyncOrtName"), new String[]{""}, 2));
        if (this.getFunktion().charAt(0) == 'R' || this.getFunktion().charAt(0) == 'Y') {
            this.restoreDateien();
        } else {
            FBefehl.instance();
            String Zeile = this.checkMedien();
            this.backupDateien(Zeile);
            if (this.getFolgeBefehl().length() > 0) {
                FBefehl.aufrufBefehl(this.getFolgeBefehl(), this.getFolgeParameter().split(" "), 5);
            }
            if (FSystemProperties.holenSystemProperty("os.name").compareTo("Windows XP") == 0) {
                if (this.isShutdownAfterBackup()) {
                    FBefehl.aufrufBefehl("shutdown", new String[]{"-s", "-f", "-t", "10"}, 5);
                }
                if (this.isSleepAfterBackup()) {
                    FBefehl.aufrufBefehl("rundll32.exe", new String[]{"powrprof.dll,SetSuspendState"}, 5);
                }
            }
        }
    }

    private String set_Fkt(int Stufe, String Letzter_Full_Backup, int Tage_bis_naechster_Full_Backup) {
        FProt fProt = FProt.instance();
        String Fkt = "" + Stufe;
        FGregorianCalendar aktZeit = new FGregorianCalendar();
        FGregorianCalendar letzter_Full_Backup_plus_Zeitdifferenz = new FGregorianCalendar();
        DateFormat ZeitFormat = DateFormat.getDateInstance();
        switch (this.getFunktion().charAt(0)) {
            case '1': {
                Fkt = "1";
                break;
            }
            case '2': {
                if (Stufe <= 1) break;
                Fkt = "2";
                break;
            }
            case '3': 
            case 'S': 
            case 'Z': {
                if (Stufe <= 2) break;
                try {
                    letzter_Full_Backup_plus_Zeitdifferenz.setTime(ZeitFormat.parse(Letzter_Full_Backup));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Tage_bis_naechster_Full_Backup == 0) {
                    Fkt = "I";
                    break;
                }
                fProt.prot("letzter Fullbackup " + letzter_Full_Backup_plus_Zeitdifferenz.toGermanFormat(), 10);
                aktZeit.setTime(new Date());
                aktZeit.set(11, 0);
                aktZeit.set(12, 0);
                aktZeit.set(13, 0);
                fProt.prot("aktuelle Zeit " + aktZeit.toGermanFormat(), 10);
                letzter_Full_Backup_plus_Zeitdifferenz.add(10, Tage_bis_naechster_Full_Backup * 24);
                boolean Zeitdifferenz_ueberschritten = aktZeit.after(letzter_Full_Backup_plus_Zeitdifferenz);
                fProt.prot("letzter Fullbackup + Wartezeit:" + letzter_Full_Backup_plus_Zeitdifferenz.toGermanFormat() + " Zeitdifferenz ueberschritten: " + Zeitdifferenz_ueberschritten, 1);
                if (Zeitdifferenz_ueberschritten) {
                    Fkt = "F";
                    break;
                }
                Fkt = "I";
                break;
            }
            case 'I': {
                if (Stufe <= 2) break;
                Fkt = "I";
                break;
            }
            case 'F': {
                if (Stufe <= 2) break;
                Fkt = "F";
                break;
            }
            case 'Q': {
                if (Stufe > 2) {
                    Fkt = "Q";
                    break;
                }
                Fkt = "-";
                break;
            }
            default: {
                System.err.println("Funktion >" + this.getFunktion() + "< unbekannt, ignoriert und auf S gesetzt.");
                Fkt = "S";
            }
        }
        return Fkt;
    }

    public void setAuswahl() {
        this.Auswahl = FParam.getStringParameter("Auswahl", this.ArgTab);
    }

    public void setAuswahl(String auswahl) {
        FParam.instance();
        this.Auswahl = FParam.checkStringParameter("Auswahl", auswahl, this.ArgTab);
    }

    public void setDateiStattDB() {
        this.DateiStattDB = FParam.getBooleanParameter("DateiStattDB", this.ArgTab);
    }

    public void setDateiStattDB(boolean dateiStattDB) {
        this.DateiStattDB = dateiStattDB;
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setFolgeBefehl() {
        this.FolgeBefehl = FParam.getStringParameter("FolgeBefehl", this.ArgTab);
    }

    public void setFolgeBefehl(String folgeBefehl) {
        this.FolgeBefehl = FParam.checkStringParameter("FolgeBefehl", folgeBefehl, this.ArgTab);
    }

    public void setFolgeParameter() {
        this.FolgeParameter = FParam.getStringParameter("FolgeParameter", this.ArgTab);
    }

    public void setFolgeParameter(String folgeParameter) {
        this.FolgeParameter = FParam.checkStringParameter("FolgeParameter", folgeParameter, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setLeerenStatussaetze() {
        this.LeerenStatussaetze = FParam.getBooleanParameter("LeerenStatussaetze", this.ArgTab);
    }

    public void setLeerenStatussaetze(boolean leerenStatussaetze) {
        this.LeerenStatussaetze = leerenStatussaetze;
    }

    public void setMedienTabelle() {
        this.MedienTabelle = FParam.getStringParameter("MedienTabelle", this.ArgTab);
    }

    public void setMedienTabelle(String medienTabelle) {
        FParam.instance();
        this.MedienTabelle = FParam.checkStringParameter("MedienTabelle", medienTabelle, this.ArgTab);
    }

    public void setMoveDateien() {
        this.MoveDateien = FParam.getBooleanParameter("MoveDateien", this.ArgTab);
    }

    public void setMoveDateien(boolean moveDateien) {
        this.MoveDateien = moveDateien;
    }

    public void setNurCheck() {
        this.NurCheck = FParam.getBooleanParameter("NurCheck", this.ArgTab);
    }

    public void setNurCheck(boolean nurCheck) {
        this.NurCheck = nurCheck;
    }

    public void setRestoreOrg() {
        this.RestoreOrg = FParam.getStringParameter("RestoreOrg", this.ArgTab);
    }

    public void setRestoreOrg(String restoreOrg) {
        this.RestoreOrg = FParam.checkStringParameter("RestoreOrg", restoreOrg, this.ArgTab);
    }

    public void setRestoreTree() {
        this.RestoreTree = FParam.getStringParameter("RestoreTree", this.ArgTab);
    }

    public void setRestoreTree(String restoreTree) {
        this.RestoreTree = FParam.checkStringParameter("RestoreTree", restoreTree, this.ArgTab);
    }

    public void setRestoreZuDatum() {
        this.RestoreZuDatum = FParam.getDateParameter("RestoreZuDatum", this.ArgTab);
    }

    public void setRestoreZuDatum(String restoreZuDatum) {
        this.RestoreZuDatum = FParam.checkDateParameter("RestoreZuDatum", restoreZuDatum, this.ArgTab);
    }

    public void setRestoreZuDatum(String restoreZuDatum, boolean umsetzen) {
        this.RestoreZuDatum = FParam.checkDateParameter("RestoreZuDatum", restoreZuDatum, umsetzen, this.ArgTab);
    }

    public void setRestoreZuUhrzeit() {
        this.RestoreZuUhrzeit = FParam.getTimeParameter("RestoreZuUhrzeit", this.ArgTab);
    }

    public void setRestoreZuUhrzeit(String restoreZuUhrzeit) {
        this.RestoreZuUhrzeit = FParam.checkTimeParameter("RestoreZuUhrzeit", restoreZuUhrzeit, this.ArgTab);
    }

    public void setRestoreZuUhrzeit(String restoreZuUhrzeit, boolean umsetzen) {
        this.RestoreZuUhrzeit = FParam.checkTimeParameter("RestoreZuUhrzeit", restoreZuUhrzeit, umsetzen, this.ArgTab);
    }

    public void setRobocopyVorhanden(boolean robocopyVorhanden) {
        this.robocopyVorhanden = robocopyVorhanden;
    }

    public void setShutdownAfterBackup() {
        this.ShutdownAfterBackup = FParam.getBooleanParameter("ShutdownAfterBackup", this.ArgTab);
    }

    public void setShutdownAfterBackup(boolean shutdownAfterBackup) {
        this.ShutdownAfterBackup = shutdownAfterBackup;
    }

    public void setSleepAfterBackup() {
        this.SleepAfterBackup = FParam.getBooleanParameter("SleepAfterBackup", this.ArgTab);
    }

    public void setSleepAfterBackup(boolean sleepAfterBackup) {
        this.SleepAfterBackup = sleepAfterBackup;
    }

    public void setSteuerungDatei() {
        this.SteuerungDatei = FParam.getStringParameter("SteuerungDatei", this.ArgTab);
    }

    public void setSteuerungDatei(String steuerungDatei) {
        this.SteuerungDatei = FParam.checkStringParameter("SteuerungDatei", steuerungDatei, this.ArgTab);
    }

    public void setSteuerungTabelle() {
        this.SteuerungTabelle = FParam.getStringParameter("SteuerungTabelle", this.ArgTab);
    }

    public void setSteuerungTabelle(String steuerungTabelle) {
        this.SteuerungTabelle = FParam.checkStringParameter("SteuerungTabelle", steuerungTabelle, this.ArgTab);
    }

    public void setTabelle() {
        this.SteuerungTabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.SteuerungTabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setDateiStattDB();
        this.setSteuerungDatei();
        this.setDBName();
        this.setSteuerungTabelle();
        this.setMedienTabelle();
        this.setAuswahl();
        this.setFunktion();
        this.setNurCheck();
        this.setLeerenStatussaetze();
        this.setMoveDateien();
        this.setRestoreTree();
        this.setRestoreOrg();
        this.setRestoreZuDatum();
        this.setRestoreZuUhrzeit();
        this.setShutdownAfterBackup();
        this.setSleepAfterBackup();
        this.setFolgeBefehl();
        this.setFolgeParameter();
    }

    private String synchronisierenVerzeichnisse(String OrgVerz, String ZielVerz) {
        FProt fProt = FProt.instance();
        String Zeile = "";
        if (this.isRobocopyVorhanden()) {
            String[] Parm = FString.verbindenArrayMitString(FString.verbindenStringArray(new String[]{FDatei.checkFileSeperator(OrgVerz, true), FDatei.checkFileSeperator(FDatei.checkDatei(ZielVerz, 'V', 'W', "Zielverzeichnis Backup", false), true)}, Futi.getBenutzerWert("RobocopyRsyncParameter").split(" ")), Futi.getBenutzerWert("RobocopyRsyncSync"));
            Zeile = String.valueOf(Futi.getBenutzerWert("RobocopyRsyncOrtName")) + " " + FString.stringArrayToString(Parm);
            fProt.prot(Zeile);
            if (this.isNurCheck()) {
                Zeile = Backup.abgleichenVerzeichnisse(OrgVerz, ZielVerz, true);
            } else {
                fProt.prot(FBefehl.aufrufBefehl(Futi.getBenutzerWert("RobocopyRsyncOrtName"), Parm, 5), 2);
            }
        } else {
            fProt.prot("internes Synchronisieren von >" + OrgVerz + "< mit >" + ZielVerz + "<");
            Zeile = Backup.abgleichenVerzeichnisse(OrgVerz, ZielVerz, this.isNurCheck());
        }
        return Zeile;
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Steuerungsdatei statt DB-Tabellen verwenden                                                    :" + this.isDateiStattDB());
        fProt.prot("Steuerungsdatei                                                                                :" + this.getSteuerungDatei());
        fProt.prot("Name Datenbank                                                                                 :" + this.getDBName());
        fProt.prot("Tabelle/Abfrage fuer Steuerung                                                                 :" + this.getSteuerungTabelle());
        fProt.prot("Tabelle der Backup-Medien                                                                      :" + this.getMedienTabelle());
        fProt.prot("Auswahl Medium                                                                                 :" + this.getAuswahl());
        fProt.prot("Funktion                                                                                       :" + this.getFunktion());
        fProt.prot("nur Check, keine Dateioperationen                                                              :" + this.isNurCheck());
        fProt.prot("Statussaetze leeren (nur bei DB)                                                               :" + this.isLeerenStatussaetze());
        fProt.prot("Dateien bei Verschieben oder Umbenennen im Zielverzeichnis bewegen statt kopieren (nur bei DB) :" + this.isMoveDateien());
        fProt.prot("zu restorender Verzeichnisbaum                                                                 :" + this.getRestoreTree());
        fProt.prot("Verzeichnisbaum mit den Sicherungen                                                            :" + this.getRestoreOrg());
        fProt.prot("Restore zum: Datum                                                                             :" + this.getRestoreZuDatum());
        fProt.prot("Restore zum: Uhrzeit                                                                           :" + this.getRestoreZuUhrzeit());
        fProt.prot("nach dem Backup Shutdown durchfuehren (nur Windows)                                            :" + this.isShutdownAfterBackup());
        fProt.prot("nach dem Backup in Ruhezustand (nur Windows)                                                   :" + this.isSleepAfterBackup());
        fProt.prot("Folgebefehl nach Backup                                                                        :" + this.getFolgeBefehl());
        fProt.prot("Parameter fuer Folgebefehl nach Backup                                                         :" + this.getFolgeParameter());
    }

    public class BackupZeile {
        private String Verz;
        private String Medium;
        private String Pfad;
        private String Ziel;
        private int Stufe;
        private boolean CheckMove;
        private boolean zugreifbar;
        private int Tage_bis_naechster_Full_Backup;

        public String getMedium() {
            return this.Medium;
        }

        public String getPfad() {
            return this.Pfad;
        }

        public int getStufe() {
            return this.Stufe;
        }

        public int getTage_bis_naechster_Full_Backup() {
            return this.Tage_bis_naechster_Full_Backup;
        }

        public String getVerz() {
            return this.Verz;
        }

        public String getZiel() {
            return this.Ziel;
        }

        public void init() {
            this.setVerz("");
            this.setMedium("");
            this.setPfad("");
            this.setZiel("");
            this.setStufe(1);
            this.setCheckMove(false);
            this.setZugreifbar(false);
            this.setTage_bis_naechster_Full_Backup(999);
        }

        public boolean isCheckMove() {
            return this.CheckMove;
        }

        public boolean isZugreifbar() {
            return this.zugreifbar;
        }

        public void setCheckMove(boolean checkMove) {
            this.CheckMove = checkMove;
        }

        public void setMedium(String medium) {
            this.Medium = medium;
        }

        public void setPfad(String pfad) {
            this.Pfad = pfad;
        }

        public void setStufe(int stufe) {
            this.Stufe = stufe;
        }

        public void setTage_bis_naechster_Full_Backup(int tage_bis_naechster_Full_Backup) {
            this.Tage_bis_naechster_Full_Backup = tage_bis_naechster_Full_Backup;
        }

        public void setVerz(String verz) {
            this.Verz = verz;
        }

        public void setZiel(String ziel) {
            this.Ziel = ziel;
        }

        public void setZugreifbar(boolean zugreifbar) {
            this.zugreifbar = zugreifbar;
        }
    }
}

