/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Datei2Tabelle;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGUI;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class CheckAppl {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean Test;
    private boolean UpdateDB;
    private String DBName;
    private String Tabelle;
    private String Funktion;
    private String[][] ArgTab;
    private final String Stand = "24.7.2011";

    public static void main(String[] args) {
        CheckAppl checkAppl = new CheckAppl(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(checkAppl.ArgTab, checkAppl.ArgTabDefault, checkAppl.getHilfeText())) {
            try {
                checkAppl.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + checkAppl.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                checkAppl.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + checkAppl.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + checkAppl.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public CheckAppl() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public CheckAppl(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public void checkHistorie() {
        FProt fProt = FProt.instance();
        FGUI fGUI = FGUI.instance();
        Futi.instance();
        int del = 0;
        int ok = 0;
        int changed = 0;
        String[] Liste2 = new FFile(fGUI.getHistoriePfad()).listFileNames('D', true);
        String[] ListeExtra = Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".add");
        int i = 0;
        while (i < ListeExtra.length) {
            Liste2 = FString.deleteStringStammFromArray(Liste2, ListeExtra[i], true);
            ++i;
        }
        String[][] ApplTabelle = fGUI.getGUIApplArgTabelle(false, true);
        String[] HistNamen = new String[ApplTabelle.length];
        i = 0;
        while (i < ApplTabelle.length) {
            HistNamen[i] = ApplTabelle[i][12];
            ++i;
        }
        HistNamen = FString.deleteDoppelte(HistNamen);
        i = 0;
        while (i < ListeExtra.length) {
            HistNamen = FString.deleteStringFromArray(HistNamen, ListeExtra[i], true);
            ++i;
        }
        fProt.prot(HistNamen, 3);
        fProt.prot(Liste2, 3);
        i = 0;
        while (i < Liste2.length) {
            if (FString.findFirstStringPos(HistNamen, Liste2[i], true) >= 0) {
                fProt.prot("E " + Liste2[i], 2);
                if (Liste2[i].endsWith(".CheckBoxenUndSlider.txt")) {
                    ++ok;
                } else {
                    String[] ZeilenOhneDuplikate;
                    String[] Zeilen = new FFile(String.valueOf(fGUI.getHistoriePfad()) + Liste2[i]).inhaltToStringArray();
                    if (Zeilen.length != (ZeilenOhneDuplikate = FString.deleteDoppelte(Zeilen, true)).length) {
                        fProt.prot("C " + Liste2[i], 1);
                        if (!this.isTest()) {
                            new FFile(String.valueOf(fGUI.getHistoriePfad()) + Liste2[i]).StringArrayToInhalt(ZeilenOhneDuplikate);
                            fProt.prot(String.valueOf(Liste2[i]) + " -> Doppelte Zeilen geloescht");
                        }
                        ++changed;
                    } else {
                        ++ok;
                    }
                }
            } else {
                fProt.prot("D " + Liste2[i], 1);
                if (!this.isTest()) {
                    new FFile(String.valueOf(fGUI.getHistoriePfad()) + Liste2[i]).delete();
                    fProt.prot(String.valueOf(Liste2[i]) + " -> geloescht");
                }
                ++del;
            }
            ++i;
        }
        fProt.prot("Statistik fuer Dateien in " + fGUI.getHistoriePfad());
        if (this.isTest()) {
            fProt.prot("O.K.     : " + ok);
            fProt.prot("To Change: " + changed);
            fProt.prot("To Delete: " + del);
        } else {
            fProt.prot("O.K.   : " + ok);
            fProt.prot("Changed: " + changed);
            fProt.prot("Deleted: " + del);
        }
        this.checkHistorieDoUpdateDB();
    }

    public void checkHistorieDoUpdateDB() {
        if (this.isUpdateDB()) {
            FGUI fGUI = FGUI.instance();
            Datei2Tabelle datei2Tabelle = new Datei2Tabelle();
            datei2Tabelle.setDBName(this.getDBName());
            datei2Tabelle.setTabelle(this.getTabelle());
            String[] Liste2 = new FFile(fGUI.getHistoriePfad()).listFileNames('D', true);
            String[][] Tab = new String[Liste2.length + 1][2];
            Tab[0][0] = "Name";
            Tab[0][1] = "FullName";
            int i = 0;
            while (i < Liste2.length) {
                Tab[i + 1][0] = Liste2[i];
                Tab[i + 1][1] = String.valueOf(fGUI.getHistoriePfad()) + Liste2[i];
                ++i;
            }
            datei2Tabelle.setExterneListe(Tab);
            datei2Tabelle.run();
        }
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "24.7.2011";
    }

    public String getTabelle() {
        return this.Tabelle;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTest() {
        return this.Test;
    }

    public boolean isUpdateDB() {
        return this.UpdateDB;
    }

    public void run() {
        FGUI fGUI = FGUI.instance();
        if (this.getFunktion().compareToIgnoreCase("T") == 0) {
            this.setTest(true);
            this.checkHistorie();
        }
        if (this.getFunktion().compareToIgnoreCase("H") == 0) {
            this.setTest(false);
            this.checkHistorie();
        }
        if (this.getFunktion().compareToIgnoreCase("P") == 0) {
            this.store2Tabelle(fGUI.getGUIApplArgTabelle(true, true));
        }
        if (this.getFunktion().compareToIgnoreCase("B") == 0) {
            this.store2Tabelle(fGUI.getGUIApplBeschreibung(true));
        }
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setTabelle() {
        this.Tabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.Tabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setTest(boolean test) {
        this.Test = test;
    }

    public void setUpdateDB() {
        this.UpdateDB = FParam.getBooleanParameter("UpdateDB", this.ArgTab);
    }

    public void setUpdateDB(boolean updateDB) {
        this.UpdateDB = updateDB;
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setUpdateDB();
        this.setDBName();
        this.setTabelle();
    }

    public void store2Tabelle(String[][] DatenTabelle) {
        Datei2Tabelle datei2Tabelle = new Datei2Tabelle();
        datei2Tabelle.setDBName(this.getDBName());
        datei2Tabelle.setTabelle(this.getTabelle());
        datei2Tabelle.setExterneListe(DatenTabelle);
        datei2Tabelle.run();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Funktion                     :" + this.getFunktion());
        fProt.prot("Historie in Tabelle schreiben:" + this.isUpdateDB());
        fProt.prot("DBName                       :" + this.getDBName());
        fProt.prot("Tabelle                      :" + this.getTabelle());
    }
}

