/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;

public class CopyDiff {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Org;
    private int Puffer;
    private String Ziel;
    private String Backup;
    private int Differenz;
    private final boolean SetzenWerteInGUInachRun = false;
    private final String Stand = "26.10.09";

    public static void main(String[] args) {
        CopyDiff copyDiff = new CopyDiff(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(copyDiff.ArgTab, copyDiff.ArgTabDefault, copyDiff.getHilfeText())) {
            try {
                copyDiff.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + copyDiff.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                copyDiff.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + copyDiff.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + copyDiff.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public CopyDiff() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public CopyDiff(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getBackup() {
        return this.Backup;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public int getDifferenz() {
        return this.Differenz;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getOrg() {
        return this.Org;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public int getPuffer() {
        return this.Puffer;
    }

    public String getStand() {
        return "26.10.09";
    }

    public String getZiel() {
        return this.Ziel;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        FProt fProt = FProt.instance();
        if (this.getOrg().length() > 0 && this.getZiel().length() > 0) {
            FFile OrgFile = new FFile(this.getOrg());
            FFile ZielFile = new FFile(this.getZiel());
            long aktDiff = Math.abs(OrgFile.length() - ZielFile.length());
            fProt.prot("Last modified >" + this.getOrg() + "< " + OrgFile.lastModifiedString(), 1);
            fProt.prot("Last modified >" + this.getZiel() + "< " + ZielFile.lastModifiedString(), 1);
            fProt.prot("Groesse >" + this.getOrg() + "< " + OrgFile.length(), 1);
            fProt.prot("Groesse >" + this.getZiel() + "< " + ZielFile.length(), 1);
            fProt.prot("aktuelle Differenz >" + aktDiff + "<", 1);
            if (OrgFile.lastModified() >= ZielFile.lastModified() && aktDiff > (long)this.getDifferenz()) {
                if (this.getBackup().length() > 0) {
                    File BackupFile = new File(this.getBackup());
                    BackupFile.delete();
                    fProt.prot(">" + this.getBackup() + "< geloescht");
                    ZielFile.renameTo(BackupFile);
                    fProt.prot(">" + this.getZiel() + "< in >" + this.getBackup() + "< umbenannt");
                }
                if (this.getPuffer() <= 0) {
                    this.setPuffer(this.getDefault("Puffer", "int"));
                    fProt.prot("Puffer fuer Kopieren auf >" + this.getPuffer() + "< gesetzt");
                }
                OrgFile.copyFile(this.getZiel(), this.getPuffer(), true);
                fProt.prot(">" + this.getOrg() + "< auf >" + this.getZiel() + "< kopiert");
            } else {
                fProt.prot("Kopieren >" + this.getOrg() + "< auf >" + this.getZiel() + "< nicht notwendig, da keine signifikante Aenderung");
            }
        }
    }

    public void setBackup() {
        this.Backup = FParam.getStringParameter("Backup", this.ArgTab);
    }

    public void setBackup(String backup) {
        FParam.instance();
        this.Backup = FParam.checkStringParameter("Backup", backup, this.ArgTab);
    }

    public void setDifferenz() {
        this.Differenz = FParam.getIntParameter("Differenz", this.ArgTab);
    }

    public void setDifferenz(int differenz) {
        FParam.instance();
        this.Differenz = FParam.checkIntParameter("Differenz", differenz, this.ArgTab);
    }

    public void setDifferenz(String differenz) {
        this.Differenz = FParam.checkIntParameter("Differenz", differenz, this.ArgTab);
    }

    public void setOrg() {
        this.Org = FParam.getStringParameter("Org", this.ArgTab);
    }

    public void setOrg(String org) {
        FParam.instance();
        this.Org = FParam.checkStringParameter("Org", org, this.ArgTab);
    }

    public void setPuffer() {
        this.Puffer = FParam.getIntParameter("Puffer", this.ArgTab);
    }

    public void setPuffer(int puffer) {
        FParam.instance();
        this.Puffer = FParam.checkIntParameter("Puffer", puffer, this.ArgTab);
    }

    public void setPuffer(String puffer) {
        this.Puffer = FParam.checkIntParameter("Puffer", puffer, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setOrg();
        this.setZiel();
        this.setBackup();
        this.setDifferenz();
        this.setPuffer();
    }

    public void setZiel() {
        this.Ziel = FParam.getStringParameter("Ziel", this.ArgTab);
    }

    public void setZiel(String ziel) {
        FParam.instance();
        this.Ziel = FParam.checkStringParameter("Ziel", ziel, this.ArgTab);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("zu kopierende Datei                                                           :" + this.getOrg());
        fProt.prot("Zieldatei                                                                     :" + this.getZiel());
        fProt.prot("Backupdatei                                                                   :" + this.getBackup());
        fProt.prot("Differenz um die sich die Datei in der Groesse mindestens geaendert haben muss:" + this.getDifferenz());
        fProt.prot("Puffergroesse                                                                 :" + this.getPuffer());
    }
}

