/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FBild;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class Diashow {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = true;
    private String[][] ArgTab;
    private final String Stand = "1.2.2019";
    private String Verzeichnis;
    private String VideoVerzeichnisBasis;
    private String BilderVerzeichnis;
    private String IndexPHPQuelle;
    private String CheckDateiName;
    private String UrlBilder;
    private String Funktion;
    private String UrlVideos;
    private String VerzVideos;
    private String[][] VideoText;
    private String[][] GifText;
    private String Name;
    private String BilderAspekt;
    private String ThumbsAspekt;
    private int BilderBreite;
    private int BilderObenProzent;
    private int BilderHoehe;
    private String[] ExterneListe;
    private int AzHtmlWrite;
    private int AzVideoHtmlWrite;
    private int AzHtmlUnchanged;
    private int AzVideoHtmlUnchanged;
    private int HilfeBildHoehe;
    private int HilfeBildBreite;
    private int GesamtdauerVideos;
    private int GesamtdauerGifs;
    private double groesseBilder;
    private double groesseGifs;
    private double groesseVideos;
    private int ThumbsBreite;
    private final int ZoomLevelOpenStreetMap = 16;
    private int ThumbsHoehe;
    private boolean CreateBilderUndThumbs;
    private boolean MehrAlsEineMedienart;
    private boolean KeineStatistikAufIndexseite;
    private int MsgLvlAufrufVonAussen = 0;
    private boolean GetTitleIfAvailable;
    private boolean CheckAndCleanWebsite;
    private boolean reiseberichtVorhanden;
    private boolean ShowWarnMissCoord;
    private boolean CreateVideoThumbsOnly;
    private boolean CheckAndTableOutput;
    private boolean VideoSteuerungValid;
    private boolean VideoUrlImWebspace;
    private boolean ShowWrite;
    private boolean ShowNoWrite;
    private boolean CheckWebsite;
    private boolean HilfeBildOK;

    private static String formatGroesse(double summe) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return String.valueOf(nf.format(summe)) + " MB";
    }

    private static int getHoeheVonAspekt(int breite, String aspekt) {
        int hoehe = breite;
        if (aspekt.compareToIgnoreCase("16:9") == 0) {
            hoehe = breite * 9 / 16;
        } else if (aspekt.compareToIgnoreCase("4:3") == 0) {
            hoehe = breite * 3 / 4;
        }
        return hoehe;
    }

    private static String getMedienDauer(String typ, String art, int dauerSekGesamt) {
        int dauerSek;
        String[][] texte = new String[][]{{" Die Diashow der ", ""}, {" dauert etwa ", ": "}, {" Minuten", " Min."}, {" und ", " "}, {" Sekunden", " Sek."}, {".", ""}};
        if (typ.compareToIgnoreCase("Bild") == 0) {
            texte[0][0] = " Die Diashow des ";
            texte[1][0] = "es dauert ";
        } else if (typ.compareToIgnoreCase("Video") == 0 || typ.compareToIgnoreCase("Gif") == 0) {
            texte[0][0] = " Das ";
            texte[1][0] = " dauert ";
        } else if (typ.compareToIgnoreCase("Videos") == 0 || typ.compareToIgnoreCase("Gifs") == 0) {
            texte[0][0] = " Die ";
            texte[1][0] = " dauern ";
        } else if (typ.compareTo("Gesamt") == 0) {
            texte[0][0] = " Die ";
            texte[1][0] = "dauer ist etwa ";
        }
        int index = art == "lang" ? 0 : 1;
        int dauerMin = dauerSekGesamt / 60;
        int n = dauerSek = dauerMin > 8 ? 0 : dauerSekGesamt % 60;
        if (dauerMin == 1) {
            texte[2][0] = " Minute";
        }
        if (dauerSek == 1) {
            texte[4][0] = " Sekunde";
        }
        return dauerSekGesamt == 0 ? "" : String.valueOf(texte[0][index]) + typ + texte[1][index] + (dauerMin > 0 ? String.valueOf(dauerMin) + texte[2][index] : "") + (dauerMin > 0 && dauerSek > 0 ? texte[3][index] : "") + (dauerSek > 0 ? String.valueOf(dauerSek) + texte[4][index] : "") + texte[5][index];
    }

    public static void main(String[] args) {
        Diashow diashow = new Diashow(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(diashow.ArgTab, diashow.ArgTabDefault, diashow.getHilfeText())) {
            try {
                diashow.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + diashow.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                diashow.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + diashow.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + diashow.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Diashow() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Diashow(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void checkHilfe() {
        String verzIndex = FDatei.checkFileSeperator(FDatei.verzeichnisEbenenZurueck(this.getVerzeichnis(), 2), true);
        FFile test = new FFile(String.valueOf(verzIndex) + "_hilfe.jpg");
        this.setHilfeBildOK(test.exists() && test.canRead() && test.isPicture());
        if (this.isHilfeBildOK()) {
            this.setHilfeBildBreite(FBild.getGroesse(String.valueOf(verzIndex) + "_hilfe.jpg")[0]);
            this.setHilfeBildHoehe(FBild.getGroesse(String.valueOf(verzIndex) + "_hilfe.jpg")[1]);
        }
    }

    private void checkWebsite() {
        String[] filenames;
        FProt fProt = FProt.instance();
        boolean websiteOk = true;
        int websiteFehlen = 0;
        int websiteObsolet = 0;
        boolean videoOk = true;
        int videoFehlen = 0;
        int videoObsolet = 0;
        String[] obenMitteUnten = new String[]{"oben", "mitte", "unten"};
        ArrayList<String> stamm = new ArrayList<String>();
        ArrayList<String> stammTyp = new ArrayList<String>();
        String[] stringArray = filenames = new FFile(this.getVerzeichnis()).listFileNames();
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if (dateiname.endsWith("_thumb.jpg")) {
                stamm.add(dateiname.substring(0, dateiname.length() - 10));
                stammTyp.add("jpg");
            } else if (dateiname.endsWith("_thumb_gif.jpg")) {
                stamm.add(dateiname.substring(0, dateiname.length() - 14));
                stammTyp.add("gif");
            } else if (dateiname.endsWith("_gallery.jpg")) {
                stamm.add(dateiname.substring(0, dateiname.length() - 12));
                stammTyp.add("mp4");
            }
            ++n2;
        }
        if (stamm.size() == 0) {
            fProt.prot("Das Verzeichnis >" + this.getVerzeichnis() + "< ist keine mit de.nss.jfi.Diashow generierte Website");
        } else {
            Object element;
            int typChar;
            ArrayList<String> soll = new ArrayList<String>();
            ArrayList<String> ist = new ArrayList<String>();
            soll.add("_hilfe.html");
            soll.add("_fillerLinks.jpg");
            soll.add("index.htm");
            int i = 0;
            while (i < stamm.size()) {
                String name = (String)stamm.get(i);
                typChar = ((String)stammTyp.get(i)).charAt(0);
                if (typChar == 106) {
                    soll.add(String.valueOf(name) + ".html");
                    soll.add(String.valueOf(name) + "_hilfe.html");
                    soll.add(String.valueOf(name) + "_dia.html");
                    soll.add(String.valueOf(name) + "_dia_3.html");
                    soll.add(String.valueOf(name) + "_dia_1.html");
                    soll.add(String.valueOf(name) + "_dia_hilfe.html");
                    soll.add(String.valueOf(name) + "_hilfe.html");
                    soll.add(String.valueOf(name) + "_dia_hilfe.html");
                    soll.add(String.valueOf(name) + "_thumb.jpg");
                    String[] stringArray2 = obenMitteUnten;
                    int n3 = obenMitteUnten.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        element = stringArray2[n4];
                        int j = 0;
                        while (j < 4) {
                            soll.add(String.valueOf(name) + "-" + (String)element + "-" + j + ".jpg");
                            ++j;
                        }
                        ++n4;
                    }
                } else if (typChar == 103) {
                    soll.add(String.valueOf(name) + ".html");
                    soll.add(String.valueOf(name) + "_dia.html");
                    soll.add(String.valueOf(name) + "_thumb_gif.jpg");
                    soll.add(String.valueOf(name) + ".gif");
                } else if (typChar == 109) {
                    soll.add(String.valueOf(name) + "_gallery.jpg");
                    soll.add(String.valueOf(name) + "_video_poster.jpg");
                    if (!this.isVideoSteuerungValid()) {
                        soll.add(String.valueOf(name) + ".html");
                        soll.add(String.valueOf(name) + "_dia.html");
                        soll.add(String.valueOf(name) + ".mp4");
                    }
                }
                ++i;
            }
            filenames = new FFile(this.getVerzeichnis()).listFileNames();
            element = filenames;
            typChar = filenames.length;
            int name = 0;
            while (name < typChar) {
                String dateiname = element[name];
                if (dateiname.compareTo(".htaccess") != 0 && dateiname.compareTo("_videos.txt") != 0 && dateiname.compareTo("_gifs.txt") != 0 && dateiname.compareTo(this.getCheckDateiName()) != 0 && dateiname.compareTo("_metadaten.txt") != 0 && dateiname.compareTo("_reisebericht.pdf") != 0 && dateiname.compareTo("index.htm.save") != 0 && dateiname.compareTo("_keine_Statistik_auf_Indexseite") != 0) {
                    ist.add(dateiname);
                }
                ++name;
            }
            ArrayList<String> sollNichtInIst = FString.arrayListSollNichtInIst(soll, ist);
            ArrayList<String> istNichtInSoll = FString.arrayListSollNichtInIst(ist, soll);
            websiteOk = sollNichtInIst.size() + istNichtInSoll.size() == 0;
            fProt.prot(String.valueOf(websiteOk ? "" : "!!! ") + "Website >" + this.getVerzeichnis() + "< ist " + (websiteOk ? "" : "nicht ") + "konsistent", websiteOk ? this.getMsgLvlAufrufVonAussen() : 0);
            websiteFehlen = sollNichtInIst.size();
            if (sollNichtInIst.size() > 0) {
                fProt.prot("fehlen : " + FString.arrayListToString(sollNichtInIst, false, ", "), 0);
            }
            websiteObsolet = istNichtInSoll.size();
            if (istNichtInSoll.size() > 0) {
                fProt.prot("obsolet: " + FString.arrayListToString(istNichtInSoll, false, ", "), 0);
                if (this.isCheckAndCleanWebsite()) {
                    for (String dateiname : istNichtInSoll) {
                        new FFile(this.getVerzeichnis(), dateiname).delete();
                        fProt.prot("Datei >" + dateiname + "<  geloescht");
                    }
                }
            }
            if (this.isVideoSteuerungValid()) {
                int typChar2;
                soll.clear();
                ist.clear();
                soll.add("index.php");
                int i2 = 0;
                while (i2 < stamm.size()) {
                    String name2 = stamm.get(i2);
                    typChar2 = ((String)stammTyp.get(i2)).charAt(0);
                    if (typChar2 == 109) {
                        soll.add(String.valueOf(name2) + "_gallery.jpg");
                        soll.add(String.valueOf(name2) + "_video_poster.jpg");
                        soll.add(String.valueOf(name2) + ".html");
                        soll.add(String.valueOf(name2) + "_dia.html");
                        soll.add(String.valueOf(name2) + ".mp4");
                    }
                    ++i2;
                }
                String[] stringArray3 = filenames = new FFile(this.getVerzVideos()).listFileNames();
                typChar2 = filenames.length;
                int name2 = 0;
                while (name2 < typChar2) {
                    String dateiname = stringArray3[name2];
                    if (dateiname.compareTo("_fillerLinks.jpg") != 0 && dateiname.compareTo("_videos.txt") != 0) {
                        if (!dateiname.endsWith(".webm")) {
                            ist.add(dateiname);
                        } else {
                            ist.add(String.valueOf(dateiname.substring(0, dateiname.length() - 4)) + "mp4");
                        }
                    }
                    ++name2;
                }
                sollNichtInIst = FString.arrayListSollNichtInIst(soll, ist);
                istNichtInSoll = FString.arrayListSollNichtInIst(ist, soll);
                videoOk = sollNichtInIst.size() + istNichtInSoll.size() == 0;
                fProt.prot(String.valueOf(videoOk ? "" : "!!! ") + "Videoverzeichnis >" + this.getVerzVideos() + "< ist " + (videoOk ? "" : "nicht ") + "konsistent", videoOk ? this.getMsgLvlAufrufVonAussen() : 0);
                videoFehlen = sollNichtInIst.size();
                if (sollNichtInIst.size() > 0) {
                    fProt.prot("fehlen : " + FString.arrayListToString(sollNichtInIst, false, ", "), this.isCheckAndTableOutput() ? 1 : 0);
                }
                videoObsolet = istNichtInSoll.size();
                if (istNichtInSoll.size() > 0) {
                    fProt.prot("obsolet: " + FString.arrayListToString(istNichtInSoll, false, ", "), this.isCheckAndTableOutput() ? 1 : 0);
                    if (this.isCheckAndCleanWebsite()) {
                        for (String dateiname : istNichtInSoll) {
                            new FFile(this.getVerzVideos(), dateiname).delete();
                            fProt.prot("Datei >" + dateiname + "<  geloescht");
                        }
                    }
                }
            }
            ArrayList<String> metadaten = new FFile(this.getVerzeichnis(), "_metadaten.txt").inhaltToStringArrayList("UTF-8");
            boolean metadatenOK = true;
            String[] stammArray = FString.arrayListToStringArray(stamm);
            int i3 = 0;
            while (i3 < metadaten.size()) {
                String dateiname;
                String zeile = metadaten.get(i3);
                String string = dateiname = zeile.contains("\t") ? zeile.substring(0, zeile.indexOf("\t")) : zeile;
                if (FString.findFirstString(stammArray, dateiname, true, true) < 0) {
                    metadatenOK = false;
                    if (this.isCheckAndCleanWebsite()) {
                        fProt.prot(String.valueOf(dateiname) + "<  geloescht in " + this.getVerzeichnis() + "_metadaten.txt");
                        metadaten.remove(i3);
                        --i3;
                    } else {
                        fProt.prot(String.valueOf(dateiname) + "<  obsolet in " + this.getVerzeichnis() + "_metadaten.txt");
                    }
                }
                ++i3;
            }
            fProt.prot(String.valueOf(metadatenOK ? "" : "!!! ") + "Datei >" + this.getVerzeichnis() + "_metadaten.txt" + "< ist " + (metadatenOK ? "" : "nicht ") + "konsistent", metadatenOK ? this.getMsgLvlAufrufVonAussen() : 0);
            if (this.isCheckAndCleanWebsite()) {
                new FFile(this.getVerzeichnis(), "_metadaten.txt").StringArrayListToInhalt(metadaten, "UTF-8", true);
            }
            if (this.isCheckAndTableOutput()) {
                if (this.getExterneListe() != null && this.getExterneListe().length > 0) {
                    String[] stringArray4 = new String[11];
                    stringArray4[0] = websiteOk ? "1" : "0";
                    stringArray4[1] = String.valueOf(websiteFehlen);
                    stringArray4[2] = String.valueOf(websiteObsolet);
                    stringArray4[3] = this.getName();
                    stringArray4[4] = "";
                    stringArray4[5] = this.isVideoSteuerungValid() ? (videoOk ? "1" : "0") : "-2";
                    stringArray4[6] = String.valueOf(videoFehlen);
                    stringArray4[7] = this.getVerzVideos();
                    stringArray4[8] = String.valueOf(videoObsolet);
                    stringArray4[9] = this.getUrlVideos();
                    stringArray4[10] = this.getUrlBilder();
                    String[] liste = stringArray4;
                    this.setExterneListe(liste);
                } else {
                    fProt.prot(String.valueOf(this.getVerzeichnis()) + "\tWebseite\t" + (websiteOk ? "OK" : "nicht OK") + "\tWebsiteFehlen\t" + websiteFehlen + "\tWebsiteObsolet\t" + websiteObsolet + "\tName Diashow\t" + this.getName() + "\tVideos\t" + (this.isVideoSteuerungValid() ? (videoOk ? "OK" : "nicht OK") : "nicht vorhanden") + "\tVerzeichnis Videos\t" + this.getVerzVideos() + "\tVideoFehlen\t" + videoFehlen + "\tVideoObsolet\t" + videoObsolet);
                }
            }
        }
    }

    private void createAnzeigeSeite(char typCharAktiv, char typCharPrev, char typCharNext, int diaSekundenIn, String aktiv, String prev, String next, String[] fotoMetadaten, boolean keinRuecksprungNachGanzOben) {
        String nextPrevStore;
        String hilfe;
        FProt fProt = FProt.instance();
        int diaSekunden = FMath.checkRange(diaSekundenIn, 0, 5);
        int gifSekunden = 0;
        if (diaSekunden > 0) {
            if (typCharAktiv == 'j') {
                diaSekunden = diaSekunden == 2 ? (diaSekunden = 1) : (diaSekunden == 4 ? (diaSekunden = 3) : diaSekunden);
            } else if (typCharAktiv == 'g') {
                try {
                    gifSekunden = Integer.parseInt(this.getGifText(aktiv, 3, true)) + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        boolean istDiaModus = diaSekunden > 0;
        String nextPrev = istDiaModus ? "_dia.html" : ".html";
        String umschaltenDia = istDiaModus ? ".html" : "_dia.html";
        String string = hilfe = istDiaModus ? "_dia_hilfe.html" : "_hilfe.html";
        String diaStufe = diaSekunden == 3 ? "_dia_3" : (diaSekunden == 1 ? "_dia_1" : "_dia");
        String string2 = nextPrevStore = istDiaModus ? String.valueOf(diaStufe) + ".html" : ".html";
        String diaStufeNext = diaSekunden == 5 ? "_dia_3" : (diaSekunden == 3 ? "_dia_1" : "_dia");
        String prefixGallerie = "";
        String prefixPrev = "";
        String prefixNext = "";
        String workTyp = "";
        if (this.isVideoSteuerungValid()) {
            if (typCharAktiv == 'm') {
                prefixGallerie = this.getUrlBilder();
                if (typCharPrev == 'j' || typCharPrev == 'g') {
                    prefixPrev = this.getUrlBilder();
                }
                if (typCharNext == 'j' || typCharNext == 'g') {
                    prefixNext = this.getUrlBilder();
                }
            }
            if (typCharAktiv == 'j' || typCharAktiv == 'g') {
                if (typCharPrev == 'm') {
                    prefixPrev = this.getUrlVideos();
                }
                if (typCharNext == 'm') {
                    prefixNext = this.getUrlVideos();
                }
            }
        }
        int breite = 1;
        int hoehe = 1;
        if (typCharAktiv == 'j') {
            breite = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "-oben-0.jpg")[0] * 4;
            hoehe = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "-oben-0.jpg")[1] + FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "-mitte-0.jpg")[1] + FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "-unten-0.jpg")[1];
        } else if (typCharAktiv == 'g') {
            breite = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + ".gif")[0];
            hoehe = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + ".gif")[1];
        } else if (typCharAktiv == 'm') {
            breite = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "_video_poster.jpg")[0];
            hoehe = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + aktiv + "_video_poster.jpg")[1];
        }
        float breiteVgl = 0.0f;
        String vorigeSeite = prev.length() > 0 ? String.valueOf(prefixPrev) + prev + nextPrev : "index.htm";
        String naechsteSeite = next.length() > 0 ? String.valueOf(prefixNext) + next + nextPrev : "index.htm";
        String naechsteSeiteDia = String.valueOf(istDiaModus && diaSekunden > 1 ? "" : prefixNext) + (istDiaModus && diaSekunden > 1 ? aktiv : next) + diaStufeNext + ".html";
        String umschaltenSeite = String.valueOf(aktiv) + umschaltenDia;
        String showOpenStreetMap = fotoMetadaten[0].isEmpty() || fotoMetadaten[1].isEmpty() ? umschaltenSeite : this.getLinkOpenStreetMap(fotoMetadaten);
        String showBingMap = fotoMetadaten[0].isEmpty() || fotoMetadaten[1].isEmpty() ? umschaltenSeite : this.getLinkBingMap(fotoMetadaten);
        String hilfeSeite = String.valueOf(aktiv) + hilfe;
        String positionierenIndex = "index.htm#" + aktiv;
        ArrayList<String> html = new ArrayList<String>();
        html.add("<!DOCTYPE html>");
        html.add("<html>");
        html.add("<head>");
        html.add("<meta charset=\"UTF-8\">");
        html.add("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=1\" />");
        html.add("<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />");
        html.add("<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black\" />");
        if (typCharAktiv == 'j') {
            if (istDiaModus) {
                if (next.length() > 0 || diaSekunden > 1) {
                    html.add("<meta http-equiv=\"refresh\" content=\"2; URL=" + naechsteSeiteDia + "\">");
                } else {
                    html.add("<meta http-equiv=\"refresh\" content=\"2; URL=index.htm\">");
                }
            }
            html.add("<style>");
            html.add("body { height: 100vh; padding: 0; margin: 0; }");
            html.add(".container img { float: left; object-fit: cover; }");
            if (istDiaModus) {
                html.add(".container .content { position: fixed; margin-left: " + (53 - diaSekunden) + "%; font-size: 2vw; color: #f1f1f1;");
                html.add(" background: rgb(0, 0, 0); /* Fallback color */");
                html.add(" background: rgba(0, 0, 0, 0.2); /* Black background with 0.2 opacity */ }");
            }
            html.add("img.fillerLinks { width: 0%; height: 1px; opacity: 0.0; filter: alpha(opacity=0); }");
            html.add("img.viertel { width: 25%; }");
            float prozent = 0.5f;
            while (prozent <= 40.0f) {
                breiteVgl = (float)breite * 98.0f / (100.0f - 2.0f * prozent);
                if ((double)(breiteVgl / (float)hoehe) > 2.0) break;
                html.add(" @media only screen and (min-aspect-ratio: " + Math.round(breiteVgl) + "/" + hoehe + ") { img.fillerLinks { width: " + prozent + "%; } } ");
                html.add(" @media only screen and (min-aspect-ratio: " + Math.round(breiteVgl) + "/" + hoehe + ") { img.viertel { width: " + (100.0f - prozent * 2.0f) / 4.0f + "%; } } ");
                prozent += 0.5f;
            }
            html.add("</style>");
        } else if (typCharAktiv == 'm' || typCharAktiv == 'g') {
            if (istDiaModus && typCharAktiv == 'g' && gifSekunden > 1) {
                html.add("<meta http-equiv=\"refresh\" content=\"" + gifSekunden + "; URL=" + (next.length() > 0 ? String.valueOf(prefixNext) + next + nextPrev : String.valueOf(prefixGallerie) + "index.htm") + "\">");
            }
            workTyp = typCharAktiv == 'm' ? "video." : "img.";
            html.add("<style> div.textLinks { text-align: left; } div.textMitte { text-align: center; } div.textRechts { text-align: right; } ");
            html.add(".container img.fillerLinks { width: 0%; }");
            html.add(".container " + workTyp + "ganz { width: 100%; }");
            html.add(" @media only screen and (max-aspect-ratio: " + Math.round((float)breite * 0.9f) + "/" + hoehe + ") { img.fillerLinks { width: 0%; } } ");
            html.add(" @media only screen and (max-aspect-ratio: " + Math.round((float)breite * 0.9f) + "/" + hoehe + ") { " + workTyp + "ganz { width: 100% }; } ");
            float prozent = 0.5f;
            while (prozent <= 50.0f) {
                breiteVgl = (float)breite * 85.0f / (100.0f - 2.0f * prozent);
                if ((double)(breiteVgl / (float)hoehe) > 2.0) break;
                html.add(" @media only screen and (min-aspect-ratio: " + Math.round(breiteVgl) + "/" + hoehe + ") { img.fillerLinks { width: " + prozent + "%; } } ");
                html.add(" @media only screen and (min-aspect-ratio: " + Math.round(breiteVgl) + "/" + hoehe + ") { " + workTyp + "ganz { width: " + (100.0f - prozent * 2.0f) + "% }; } ");
                prozent += 0.5f;
            }
            html.add("</style>");
        }
        html.add("<title>" + Futi.makeHtmlKompatibel(this.getName(), true) + "</title>");
        html.add("</head>");
        html.add("<body" + (typCharAktiv == 'j' ? " onload=\"toggleFullScreen(event);\"" : "") + ">");
        if (typCharAktiv == 'j') {
            html.add("<div class=\"container\" id=\"myImage\">");
            html.add(" <a><img class=\"fillerLinks\" src=\"_fillerLinks.jpg\"></a>");
            html.add(" <a href=\"" + positionierenIndex + "\"><img class=\"viertel\" src=\"" + aktiv + "-oben-0.jpg\"></a>");
            html.add(" <a href=\"index.htm\"><img class=\"viertel\" src=\"" + aktiv + "-oben-1.jpg\"></a>");
            html.add(" <a href=\"index.htm\"><img class=\"viertel\" src=\"" + aktiv + "-oben-2.jpg\"></a>");
            html.add(" <a href=\"" + hilfeSeite + "\"><img class=\"viertel\" src=\"" + aktiv + "-oben-3.jpg\"></a>");
            if (istDiaModus) {
                html.add("  <div class=\"content\"><a>&deg;" + (diaSekunden == 5 ? "&nbsp;&deg;&nbsp;&deg;&nbsp;&deg;&nbsp;&deg;" : (diaSekunden == 3 ? "&nbsp;&deg;&nbsp;&deg;" : "")) + "</a></div>");
            }
            html.add(" <a><img class=\"fillerLinks\" src=\"_fillerLinks.jpg\" style=\"clear: left; opacity: 0;\"></a>");
            html.add(" <a href=\"" + vorigeSeite + "\" onclick=\"rueckwaerts();return false;\"><img class=\"viertel\" src=\"" + aktiv + "-mitte-0.jpg\"></a>");
            html.add(" <a href=\"" + umschaltenSeite + "\"><img class=\"viertel\" src=\"" + aktiv + "-mitte-1.jpg\"></a>");
            html.add(" <a href=\"" + umschaltenSeite + "\"><img class=\"viertel\" src=\"" + aktiv + "-mitte-2.jpg\"></a>");
            html.add(" <a href=\"" + naechsteSeite + "\" onclick=\"vorwaerts();return false;\"><img class=\"viertel\" src=\"" + aktiv + "-mitte-3.jpg\"></a>");
            html.add(" <a><img class=\"fillerLinks\" src=\"_fillerLinks.jpg\" style=\"clear:left;\"></a>");
            html.add(" <a href=\"" + showBingMap + "\"><img class=\"viertel\" src=\"" + aktiv + "-unten-0.jpg\"></a>");
            html.add(" <a href=\"" + showOpenStreetMap + "\"><img class=\"viertel\" src=\"" + aktiv + "-unten-1.jpg\"></a>");
            html.add(" <a href=\"" + showOpenStreetMap + "\"><img class=\"viertel\" src=\"" + aktiv + "-unten-2.jpg\"></a>");
            html.add(" <a onclick=\"toggleFullScreen(event);\"><img class=\"viertel\" src=\"" + aktiv + "-unten-3.jpg\"></a>");
            html.add("</div>");
            html.add("<script>");
            html.add("var openWindowParm = \"location=no,toolbar=no,menubar=no,status=no,titlebar=no,scrollbars=yes,resizable=yes\";");
            html.add("function rueckwaerts() { window.open(\"" + vorigeSeite + "\", \"_self\", openWindowParm) };");
            html.add("function vorwaerts() { window.open(\"" + naechsteSeite + "\", \"_self\", openWindowParm) };");
            html.add("var element = document.documentElement; // = document.getElementById(\"myImage\")");
            html.add("var isFullscreen = 0;");
            html.add("function toggleFullScreen(event) {");
            html.add("  if (isFullscreen == 0) {");
            html.add("    if (event.target.nodeName == \"IMG\") { isFullscreen = 1; }");
            html.add("    if (element.requestFullscreen) { element.requestFullscreen(); }");
            html.add("    else if (element.mozRequestFullScreen) { element.mozRequestFullScreen(); } /* Firefox */ ");
            html.add("    else if (element.webkitRequestFullscreen) { element.webkitRequestFullscreen(); } /* Chrome, Safari and Opera */");
            html.add("    else if (element.msRequestFullscreen) { element.msRequestFullscreen(); } /* IE/Edge */");
            html.add("  } else {");
            html.add("    if (event.target.nodeName == \"IMG\") { isFullscreen = 0; }");
            html.add("    if (document.exitFullscreen) { document.exitFullscreen(); }");
            html.add("    else if (document.mozCancelFullScreen) { document.mozCancelFullScreen(); } /* Firefox */");
            html.add("    else if (document.webkitExitFullscreen) { document.webkitExitFullscreen(); } /* Chrome, Safari and Opera */");
            html.add("    else if (document.msExitFullscreen) {  document.msExitFullscreen(); } /* IE/Edge */");
            html.add("  } };");
            Futi.addSwiper(html, "myImage", vorigeSeite, naechsteSeite);
            html.add("</script>");
        } else if (typCharAktiv == 'm' || typCharAktiv == 'g') {
            html.add("<table border=\"0\" width=\"100%\">");
            html.add(" <tr>");
            html.add("  <td width=\"15%\"><div class=\"textRechts\"><a href=\"" + prefixGallerie + positionierenIndex + "\"><big>Galerie</big></a></div>");
            html.add("                  <div class=\"textLinks\">" + (prev.length() > 0 ? "<a href=\"" + prefixPrev + prev + nextPrev + "\"><big>voriges</big></a>" : "&nbsp;") + "</div></td>");
            if (typCharAktiv == 'm') {
                html.add("  <td><div class=\"textMitte\"><big><big>" + Futi.makeHtmlKompatibel(this.getVideoText(aktiv, 1, true), true) + "</big></big></big></div></td>");
            } else {
                html.add("  <td><div class=\"textMitte\"><big><big>" + Futi.makeHtmlKompatibel(this.getGifText(aktiv, 1, true), true) + "</big></big></big></div></td>");
            }
            html.add("  <td width=\"15%\">" + (keinRuecksprungNachGanzOben ? "" : "<div class=\"textLinks\"><a href=\"" + prefixGallerie + "index.htm\"><big>Galerie oben</big></a></div>") + "<div class=\"textRechts\">" + (next.length() > 0 ? "<a href=\"" + prefixNext + next + nextPrev + "\"><big>n&auml;chstes</big></a>" : "&nbsp;") + "</div></td>");
            html.add(" </tr>");
            html.add("</table>");
            html.add("<a><img class=\"fillerLinks\" src=\"_fillerLinks.jpg\" style=\"clear: left; opacity: 0;\"></a>");
            if (typCharAktiv == 'm') {
                html.add("<video class=\"ganz\" id=\"myVideo\" controls autoplay poster=\"" + aktiv + "_video_poster.jpg\">");
                html.add("  <source src=\"" + aktiv + ".mp4\" type=\"video/mp4\">");
                html.add("   Your browser does not support HTML5 video.");
                html.add("</video>");
            } else {
                html.add("<a><img class=\"ganz\" id=\"myGif\" src=\"" + aktiv + ".gif\"</a>");
            }
            html.add("<script>");
            html.add("var openWindowParm = \"location=no,toolbar=no,menubar=no,status=no,titlebar=no,scrollbars=yes,resizable=yes\";");
            if (istDiaModus) {
                html.add("var video = document.getElementById(\"my" + (typCharAktiv == 'm' ? "Video" : "Gif") + "\"); ");
                if (typCharAktiv == 'm') {
                    html.add("video.onended = function(){ document.location.href=\"" + (next.length() > 0 ? String.valueOf(prefixNext) + next + nextPrev : String.valueOf(prefixGallerie) + "index.htm") + "\"; };");
                }
            }
            Futi.addSwiper(html, "my" + (typCharAktiv == 'm' ? "Video" : "Gif"), vorigeSeite, naechsteSeite);
            html.add("</script>");
        }
        html.add("</body>");
        html.add("</html>");
        fProt.prot("Htmlseite >" + aktiv + nextPrev + "< in >" + this.getVerzeichnis() + "< erstellt.", 1);
        this.protokolliereWrite(new FFile(typCharAktiv == 'm' && this.isVideoSteuerungValid() ? this.getVerzVideos() : this.getVerzeichnis(), String.valueOf(aktiv) + nextPrevStore).StringArrayListToInhalt(html, true));
        if (typCharAktiv == 'j' && (!istDiaModus || istDiaModus && diaSekunden == 5)) {
            this.createHilfe(hilfeSeite, String.valueOf(aktiv) + nextPrev, fotoMetadaten);
        }
    }

    private void createBilderAndThumbs() {
        String bildName;
        String[] filenames = new FFile(this.getVerzeichnis()).listFileNames();
        ArrayList<String> videoPoster = new ArrayList<String>();
        String[] obenMitteUnten = new String[]{"oben", "mitte", "unten"};
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if (dateiname.endsWith(".jpg") || dateiname.endsWith(".JPG") || dateiname.endsWith(".jpeg") || dateiname.endsWith(".JPEG") || dateiname.endsWith(".gif") || dateiname.endsWith(".GIF")) {
                if (dateiname.endsWith("_video_poster.jpg")) {
                    videoPoster.add(dateiname);
                    new FFile(this.getVerzeichnis(), dateiname).renameTo(this.getVerzeichnis(), String.valueOf(dateiname) + ".save");
                } else {
                    new FFile(this.getVerzeichnis(), dateiname).delete();
                }
            }
            ++n2;
        }
        ArrayList<String> images = this.getRelevanteBildernamen();
        String[] parmCopyResize = new String[]{this.getBilderVerzeichnis(), "-resize", String.valueOf(this.getBilderGroesse()) + ">", "-define", "preserve-timestamp=true", this.getVerzeichnis()};
        for (String dateiname : images) {
            if (dateiname.endsWith(".jpg") || dateiname.endsWith(".JPG") || dateiname.endsWith(".jpeg") || dateiname.endsWith(".JPEG")) {
                parmCopyResize[0] = String.valueOf(this.getBilderVerzeichnis()) + dateiname;
                parmCopyResize[5] = String.valueOf(this.getVerzeichnis()) + dateiname.substring(0, dateiname.length() - 4) + "-oben.jpg";
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmCopyResize, 0);
            }
            if (!dateiname.endsWith(".gif") && !dateiname.endsWith(".GIF")) continue;
            new FFile(this.getBilderVerzeichnis(), dateiname).copyFile(String.valueOf(this.getVerzeichnis()) + dateiname.substring(0, dateiname.length() - 4) + ".gif");
        }
        String[] parmCrop = new String[]{"-crop", "25.025%x" + this.getBilderObenProzent() + "%", String.valueOf(this.getVerzeichnis()) + "*.jpg"};
        if (images.size() > 0) {
            FBefehl.aufrufBefehl("mogrify", parmCrop, 0);
        }
        for (String dateiname : videoPoster) {
            new FFile(this.getVerzeichnis(), String.valueOf(dateiname) + ".save").renameTo(this.getVerzeichnis(), dateiname);
        }
        String[] parmResizeLetztesTeil = new String[]{"-define", "jpeg:size=" + this.getBilderGroesse(), "-resize", String.valueOf(this.getBilderGroesse()) + ">", "-background", "grey", "-gravity", "west", "-extent", this.getBilderGroesse(), this.getVerzeichnis()};
        String[] parmAppendUntereTeile = new String[]{"Teil1", "Teil2", "Teil3", "-append", "Teilgesamt"};
        int hoehe = 0;
        int breiteVorletztesTeil = 0;
        int breiteLetztesTeil = 0;
        for (String dateiname : images) {
            if (!dateiname.endsWith(".jpg") && !dateiname.endsWith(".JPG") && !dateiname.endsWith(".jpeg") && !dateiname.endsWith(".JPEG")) continue;
            bildName = dateiname.substring(0, dateiname.length() - 4);
            int restRechtsUeberspringen = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + bildName + "-oben-4.jpg")[0] < 10 ? 1 : 0;
            int i = 0;
            while (i < 4) {
                parmAppendUntereTeile[0] = String.valueOf(this.getVerzeichnis()) + bildName + "-oben-" + (i + 4 + restRechtsUeberspringen) + ".jpg";
                parmAppendUntereTeile[1] = String.valueOf(this.getVerzeichnis()) + bildName + "-oben-" + (i + 8 + restRechtsUeberspringen * 2) + ".jpg";
                parmAppendUntereTeile[2] = "";
                parmAppendUntereTeile[4] = String.valueOf(this.getVerzeichnis()) + bildName + "-mitte-" + i + ".jpg";
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmAppendUntereTeile, 0);
                new FFile(this.getVerzeichnis(), String.valueOf(bildName) + "-oben-" + (i + 12 + restRechtsUeberspringen * 3) + ".jpg").renameTo(this.getVerzeichnis(), String.valueOf(bildName) + "-unten-" + i + ".jpg");
                ++i;
            }
            String[] stringArray2 = obenMitteUnten;
            int n3 = obenMitteUnten.length;
            int n4 = 0;
            while (n4 < n3) {
                String element = stringArray2[n4];
                breiteVorletztesTeil = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + bildName + "-" + element + "-2.jpg")[0];
                breiteLetztesTeil = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + bildName + "-" + element + "-3.jpg")[0];
                hoehe = FBild.getGroesse(String.valueOf(this.getVerzeichnis()) + bildName + "-" + element + "-3.jpg")[1];
                if (breiteLetztesTeil < breiteVorletztesTeil) {
                    parmResizeLetztesTeil[1] = "jpeg:size=" + breiteVorletztesTeil + "x" + hoehe;
                    parmResizeLetztesTeil[3] = String.valueOf(breiteVorletztesTeil) + "x" + hoehe + ">";
                    parmResizeLetztesTeil[9] = String.valueOf(breiteVorletztesTeil) + "x" + hoehe;
                    parmResizeLetztesTeil[10] = String.valueOf(this.getVerzeichnis()) + bildName + "-" + element + "-3.jpg";
                    FBefehl.aufrufBefehl("mogrify", parmResizeLetztesTeil, 0);
                }
                ++n4;
            }
            i = 4;
            while (i < 20) {
                new FFile(this.getVerzeichnis(), String.valueOf(bildName) + "-oben-" + i + ".jpg").delete();
                ++i;
            }
        }
        String[] parmCreateThumbs = new String[]{"-define", "jpeg:size=" + this.getThumbsGroesse(), this.getBilderVerzeichnis(), "-thumbnail", this.getThumbsGroesse(), "-background", "grey", "-gravity", "center", "-extent", this.getThumbsGroesse(), this.getVerzeichnis()};
        for (String dateiname : images) {
            parmCreateThumbs[2] = String.valueOf(this.getBilderVerzeichnis()) + dateiname + (dateiname.endsWith(".gif") || dateiname.endsWith(".GIF") ? "[0]" : "");
            parmCreateThumbs[11] = String.valueOf(this.getVerzeichnis()) + dateiname.substring(0, dateiname.length() - 4) + "_thumb" + (dateiname.endsWith(".gif") || dateiname.endsWith(".GIF") ? "_gif" : "") + ".jpg";
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmCreateThumbs, 0);
            if (dateiname.endsWith(".gif") || dateiname.endsWith(".GIF")) {
                this.setTextOnThumb(parmCreateThumbs[11], dateiname.substring(0, dateiname.length() - 4), 'g');
            }
            new File(this.getVerzeichnis(), String.valueOf(dateiname.substring(0, dateiname.length() - 4)) + "_thumb" + (dateiname.endsWith(".gif") || dateiname.endsWith(".GIF") ? "_gif" : "") + ".jpg").setLastModified(new File(this.getBilderVerzeichnis(), dateiname).lastModified());
        }
        for (String dateiname : images) {
            long fileCreationDate = new File(this.getBilderVerzeichnis(), dateiname).lastModified();
            if (fileCreationDate <= 0L) continue;
            bildName = dateiname.substring(0, dateiname.length() - 4);
            new File(this.getVerzeichnis(), String.valueOf(bildName) + "_thumb.jpg").setLastModified(fileCreationDate);
            String[] stringArray3 = obenMitteUnten;
            int n5 = obenMitteUnten.length;
            int n6 = 0;
            while (n6 < n5) {
                String element = stringArray3[n6];
                int i = 0;
                while (i < 4) {
                    new File(this.getVerzeichnis(), String.valueOf(bildName) + "-" + element + "-" + i + ".jpg").setLastModified(fileCreationDate);
                    ++i;
                }
                ++n6;
            }
        }
        this.createVideoAndThumbs();
        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{"-size", "200x1", "xc:none", String.valueOf(this.getVerzeichnis()) + "_fillerLinks.jpg"}, 0);
    }

    private void createHilfe(String name, String back, String[] fotoMetadaten) {
        FProt fProt = FProt.instance();
        ArrayList<String> hilfe = new ArrayList<String>();
        hilfe.add("<!DOCTYPE html>");
        hilfe.add("<html>");
        hilfe.add("<head>");
        hilfe.add("<meta charset=\"UTF-8\">");
        hilfe.add("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />");
        hilfe.add("<meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />");
        hilfe.add("<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black\" />");
        if (this.isHilfeBildOK()) {
            hilfe.add("<style> img { width:100%; height:auto; } </style>");
        }
        hilfe.add("<title>Hilfe zur Navigation in der Diashow</title>");
        hilfe.add("</head>");
        hilfe.add("<body>");
        hilfe.add("<table border=\"0\" width=\"100%\">");
        hilfe.add("  <tr>");
        hilfe.add("    <td><p align=\"left\"><a href=\"" + back + "\"><big>zur&uuml;ck</big></a></p></td>");
        hilfe.add("    <td><h2 align=\"center\">Hilfe f&uuml;r die Anzeige der Fotos der Bildergalerie</h2></td>");
        if (fotoMetadaten != null) {
            if (!fotoMetadaten[0].isEmpty() && !fotoMetadaten[1].isEmpty() || !fotoMetadaten[3].isEmpty() || !fotoMetadaten[4].isEmpty()) {
                hilfe.add("    <td><p align=\"right\">");
            }
            if (!fotoMetadaten[0].isEmpty() && !fotoMetadaten[1].isEmpty()) {
                hilfe.add("      " + (fotoMetadaten[4].isEmpty() ? "" : "<a href=\"_reisebericht.pdf\"><big>Reisebericht</big></a></big>&nbsp;&nbsp;") + "<big>Koordinaten: B: " + fotoMetadaten[0] + ", L: " + fotoMetadaten[1] + (fotoMetadaten[2].isEmpty() ? "" : ", H: " + fotoMetadaten[2]) + "&nbsp;<a href=\"" + this.getLinkOpenStreetMap(fotoMetadaten) + "\"><big>OSM</big></a>&nbsp;<a href=\"" + this.getLinkBingMap(fotoMetadaten) + "\"><big>Bing</big></a>" + (fotoMetadaten[3].isEmpty() ? "" : "<br>"));
            } else if (!fotoMetadaten[4].isEmpty()) {
                hilfe.add("      <a href=\"_reisebericht.pdf\"><big><big>Reisebericht</big></a></big>");
            }
            if (!fotoMetadaten[3].isEmpty()) {
                hilfe.add("      <big>Kameradaten: " + Futi.makeHtmlKompatibel(fotoMetadaten[3]) + "</big>");
            }
            if (!fotoMetadaten[0].isEmpty() && !fotoMetadaten[1].isEmpty() || !fotoMetadaten[3].isEmpty() || !fotoMetadaten[4].isEmpty()) {
                hilfe.add("    </p></td>");
            }
        }
        hilfe.add("  </tr>");
        hilfe.add("</table>");
        hilfe.add("<div class=\"container\" id=\"myHelp\">");
        if (this.isHilfeBildOK()) {
            hilfe.add("<img src=\"../../_hilfe.jpg\" width=\"" + this.getHilfeBildBreite() + "\" height=\"" + this.getHilfeBildHoehe() + "\"  usemap=\"#mapLinksOben\">");
            hilfe.add("<map name=\"mapLinksOben\"><area shape=\"rect\" coords=\"0,0," + this.getHilfeBildBreite() / 4 + "," + this.getHilfeBildHoehe() / 4 + "\" href=\"" + back + "\">");
        } else {
            hilfe.add("<table border=\"1\" cellpadding=\"2\" cellspacing=\"3\" width=\"100%\">");
            hilfe.add("  <tr>");
            hilfe.add("    <td><p align=\"left\"><big>zur &Uuml;bersichtsseite</big></p><p align=\"left\"><big>(positioniert auf aktuelles Bild)</big></p></td>");
            hilfe.add("    <td><p align=\"center\"><big>zur &Uuml;bersichtsseite (oben) </big></p></td>");
            hilfe.add("    <td><p align=\"right\"><big>anzeigen diese Hilfe</big></p></td>");
            hilfe.add("  </tr>");
            hilfe.add("  <tr>");
            hilfe.add("    <td rowspan=\"2\"><p align=\"left\">&nbsp;</p><p align=\"left\">&nbsp;</p><p align=\"left\"><big>zum vorigen Bild&ast;</big></p><p align=\"left\">&nbsp;</p><p align=\"left\">&nbsp;</p></td>");
            hilfe.add("    <td rowspan=\"2\">");
            hilfe.add("      <p align=\"center\">&nbsp;</p>");
            hilfe.add("      <p align=\"center\"><big>Umschalten Diashow (Wechsel 5 Sekunden)</p>");
            hilfe.add("      <p align=\"center\">bzw. keine Diashow (Bildwechsel durch Anklicken links oder rechts)</p>");
            hilfe.add("      <p align=\"center\">Bildwechsel durch Anklicken funktioniert auch in der Diashow</p>");
            hilfe.add("      <p align=\"center\">&nbsp;</p>");
            hilfe.add("    </td>");
            hilfe.add("    <td>");
            hilfe.add("     <p align=\"right\">&nbsp;</p>");
            hilfe.add("     <p align=\"right\">&nbsp;</p>");
            hilfe.add("     <p align=\"right\"><big>zum n&auml;chsten Bild&ast;</big></p>");
            hilfe.add("     <p align=\"right\">&nbsp;</p>");
            hilfe.add("     <p align=\"right\">&nbsp;</p>");
            hilfe.add("    </td>");
            hilfe.add("  </tr>");
            hilfe.add("  <tr>");
            hilfe.add("    <td><p align=\"right\"><big>Vollbild ein-<br>und ausschalten&ast;&ast;</big></p></td>");
            hilfe.add("  </tr>");
            hilfe.add("</table>");
            hilfe.add("<p><big>&ast;&nbsp;wischen nach links (voriges Bild) und rechts (n&auml;chstes Bild) funktioniert nur bei Touchscreens und aktiviertem Javascript</big></p>");
            hilfe.add("<p><big>&ast;&ast;&nbsp;funktioniert nur bei Touchscreens und aktiviertem Javascript, verh&auml;lt sich je Browser und Betriebssystem unterschiedlich, iOS unterst&uuml;tzt z.B. kein Vollbild im Browser</big></p>");
        }
        hilfe.add("</div>");
        hilfe.add("<script>");
        Futi.addSwiper(hilfe, "myHelp", back, "");
        hilfe.add("</script>");
        hilfe.add("</body>");
        hilfe.add("</html>");
        fProt.prot("Hilfeseite >" + name + "< fuer >" + this.getVerzeichnis() + " erstellt.", name.compareTo("_hilfe.html") == 0 ? 0 : 1);
        this.protokolliereWrite(new FFile(this.getVerzeichnis(), name).StringArrayListToInhalt(hilfe, "UTF-8", true));
    }

    private void createIndex(ArrayList<String> baseName, ArrayList<String> baseTyp, int az_Bilder, int az_Gifs, int az_Videos) {
        FProt fProt = FProt.instance();
        ArrayList<String> index = new ArrayList<String>();
        index.addAll(Futi.getHtmlPageStart(true));
        index.add("<title>" + Futi.makeHtmlKompatibel(this.getName(), true) + "</title>");
        index.add("</head>");
        index.add("<body>");
        index.add("<table border=\"0\" width=\"100%\">");
        index.add(" <tr>");
        index.add("  <td width=\"8%\"><div class=\"textLinks\"><a href=\"../../index.htm\"><big><big><big>zur&uuml;ck</big></big></big></a></div></td>");
        index.add("  <td><div class=\"textMitte\"><big><big><big>" + Futi.makeHtmlKompatibel(this.getName(), true) + "</big></big></big>" + (this.isKeineStatistikAufIndexseite() ? "" : "<br><big>" + this.getMedienGroesse("kurz", az_Bilder, az_Gifs, az_Videos) + (az_Bilder > 0 ? ", " : "") + Diashow.getMedienDauer("Diashow", "kurz", az_Bilder * 6) + (this.getGesamtdauerGifs() > 0 ? ", " : "") + Diashow.getMedienDauer(az_Gifs > 1 ? "Gifs" : "Gif", "kurz", this.getGesamtdauerGifs()) + (this.getGesamtdauerVideos() > 0 ? ", " : "") + Diashow.getMedienDauer(az_Videos > 1 ? "Videos" : "Video", "kurz", this.getGesamtdauerVideos()) + (az_Bilder > 0 && (this.getGesamtdauerGifs() > 0 || this.getGesamtdauerVideos() > 0) ? ", " + Diashow.getMedienDauer("Gesamt", "kurz", az_Bilder * 6 + this.getGesamtdauerGifs() + this.getGesamtdauerVideos()) : "") + "</big>") + "</div></td>");
        if (az_Bilder > 0) {
            if (this.isReiseberichtVorhanden()) {
                index.add("  <td width=\"10%\"><div class=\"textRechts\"><a href=\"_reisebericht.pdf\"><big><big>Reisebericht</big></a></big></div></td>");
            }
            index.add("  <td width=\"25%\"><div class=\"textRechts\"><a href=\"_hilfe.html\"><big><big>Hilfe Anzeige Fotos der Bildergalerie</big></big></a></div></td>");
        }
        index.add(" </tr>");
        index.add("</table>");
        int i = 0;
        while (i < baseName.size()) {
            String name = baseName.get(i);
            char typChar = baseTyp.get(i).charAt(0);
            index.add("<div class=\"responsive\"> <div class=\"gallery\" id=\"" + name + "\">");
            index.add("<a target=\"_self\" href=\"" + (typChar == 'm' ? this.getUrlVideos() : "") + name + "_dia.html\"> <img src=\"" + name + (typChar == 'j' ? "_thumb" : (typChar == 'g' ? "_thumb_gif" : "_gallery")) + ".jpg\">");
            index.add("</a> </div> </div>");
            ++i;
        }
        index.add("<div class=\"clearfix\"></div>");
        if (!this.isKeineStatistikAufIndexseite()) {
            index.add("<p><big>" + this.getMedienGroesse("lang", az_Bilder, az_Gifs, az_Videos) + Diashow.getMedienDauer(az_Bilder > 1 ? "Bilder" : "Bild", "lang", az_Bilder * 6) + Diashow.getMedienDauer(az_Gifs > 1 ? "Gifs" : "Gif", "lang", this.getGesamtdauerGifs()) + Diashow.getMedienDauer(az_Videos > 1 ? "Videos" : "Video", "lang", this.getGesamtdauerVideos()) + (az_Bilder > 0 && (this.getGesamtdauerGifs() > 0 || this.getGesamtdauerVideos() > 0) ? Diashow.getMedienDauer("Gesamt", "lang", az_Bilder * 6 + this.getGesamtdauerGifs() + this.getGesamtdauerVideos()) : "") + "</big></p>");
        }
        index.add("</body>");
        index.add("</html>");
        fProt.prot("Indexseite >index.htm< fuer >" + this.getVerzeichnis() + "< mit " + baseName.size() + " Thumbs erstellt.");
        this.protokolliereWrite(new FFile(this.getVerzeichnis(), "index.htm").StringArrayListToInhalt(index, "UTF-8", true));
        if (this.isVideoSteuerungValid()) {
            String[] index_videos = new FFile(this.getIndexPHPQuelle()).inhaltToStringArray();
            fProt.prot("Indexseite >index.php< fuer Videos in >" + this.getVerzVideos() + " aus " + this.getIndexPHPQuelle() + " neu erstellt, falls veraendert.");
            this.protokolliereWrite(new FFile(this.getVerzVideos(), "index.php").StringArrayToInhalt(index_videos, "UTF-8", true));
            String[] videos_txt = new FFile(this.getVerzeichnis(), "_videos.txt").inhaltToStringArray();
            fProt.prot("Info zu Videos >_videos.txt< von >" + this.getVerzeichnis() + " nach " + this.getVerzVideos() + " kopiert, falls veraendert.");
            this.protokolliereWrite(new FFile(this.getVerzVideos(), "_videos.txt").StringArrayToInhalt(videos_txt, "UTF-8", true));
        }
    }

    private void createVideoAndThumbs() {
        ArrayList<Object> videoPoster = new ArrayList();
        videoPoster = this.getVideoPoster();
        if (videoPoster.size() > 0) {
            String[] parmCreateThumbs = new String[]{"-define", "jpeg:size=" + this.getThumbsGroesse(), this.getBilderVerzeichnis(), "-thumbnail", this.getThumbsGroesse(), "-background", "grey", "-gravity", "center", "-extent", this.getThumbsGroesse(), this.getVerzeichnis()};
            for (String string : videoPoster) {
                parmCreateThumbs[2] = String.valueOf(this.getVerzeichnis()) + string;
                parmCreateThumbs[11] = String.valueOf(this.getVerzeichnis()) + string.substring(0, string.length() - 17) + "_gallery.jpg";
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmCreateThumbs, 0);
                this.setTextOnThumb(parmCreateThumbs[11], string.substring(0, string.length() - 17), 'm');
                new FFile(String.valueOf(this.getVerzVideos()) + string.substring(0, string.length() - 17) + "_gallery.jpg").deleteIfExits();
                new FFile(parmCreateThumbs[11]).copyFile(String.valueOf(this.getVerzVideos()) + string.substring(0, string.length() - 17) + "_gallery.jpg");
            }
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{"-size", "200x1", "xc:none", String.valueOf(this.getVerzVideos()) + "_fillerLinks.jpg"}, 0);
        }
    }

    private int getAzHtmlUnchanged() {
        return this.AzHtmlUnchanged;
    }

    private int getAzHtmlWrite() {
        return this.AzHtmlWrite;
    }

    private int getAzVideoHtmlUnchanged() {
        return this.AzVideoHtmlUnchanged;
    }

    private int getAzVideoHtmlWrite() {
        return this.AzVideoHtmlWrite;
    }

    public String getBilderAspekt() {
        return this.BilderAspekt;
    }

    public int getBilderBreite() {
        return this.BilderBreite;
    }

    private String getBilderGroesse() {
        return String.valueOf(this.getBilderBreite()) + "x" + this.getBilderHoehe();
    }

    private int getBilderHoehe() {
        return this.BilderHoehe;
    }

    public int getBilderObenProzent() {
        return this.BilderObenProzent;
    }

    private String getBilderUndVideoText(int az_Bilder, int az_Gifs, int az_Videos) {
        String text_Gifs;
        String text_Bilder;
        String string = az_Bilder == 0 ? "" : (text_Bilder = String.valueOf(az_Bilder == 1 ? "1 Bild" : String.valueOf(az_Bilder) + " Bilder") + (this.isMehrAlsEineMedienart() ? " (" + Diashow.formatGroesse(this.getGroesseBilder()) + ")" : ""));
        String string2 = az_Gifs == 0 ? "" : (text_Gifs = String.valueOf(az_Gifs == 1 ? "1 Gif" : String.valueOf(az_Gifs) + " Gifs") + (this.isMehrAlsEineMedienart() ? " (" + Diashow.formatGroesse(this.getGroesseGifs()) + ")" : ""));
        String text_Videos = az_Videos == 0 ? "" : String.valueOf(az_Videos == 1 ? "1 Video" : String.valueOf(az_Videos) + " Videos") + (this.isMehrAlsEineMedienart() ? " (" + Diashow.formatGroesse(this.getGroesseVideos()) + ")" : "");
        return String.valueOf(text_Bilder) + (text_Bilder.length() == 0 ? "" : (text_Gifs.length() == 0 ? "" : (text_Videos.length() == 0 ? " und " : ", "))) + text_Gifs + (text_Bilder.length() + text_Gifs.length() == 0 ? "" : (text_Videos.length() == 0 ? "" : " und ")) + text_Videos;
    }

    public String getBilderVerzeichnis() {
        return this.BilderVerzeichnis;
    }

    public String getCheckDateiName() {
        return this.CheckDateiName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getExterneListe() {
        return this.ExterneListe;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    private int getGesamtdauerGifs() {
        return this.GesamtdauerGifs;
    }

    private int getGesamtdauerVideos() {
        return this.GesamtdauerVideos;
    }

    private String getGifText(String suche, int spalte, boolean sucheBeiNotfoundZurueckgeben) {
        int pos;
        String gefunden;
        String string = gefunden = sucheBeiNotfoundZurueckgeben ? suche : "";
        if (this.GifText != null && (pos = FString.findFirstString(this.GifText, 0, suche, true, true)) >= 0) {
            gefunden = this.GifText[pos][spalte];
        }
        return gefunden;
    }

    private double getGroesseBilder() {
        return this.groesseBilder;
    }

    private double getGroesseGifs() {
        return this.groesseGifs;
    }

    private double getGroesseVideos() {
        return this.groesseVideos;
    }

    private int getHilfeBildBreite() {
        return this.HilfeBildBreite;
    }

    private int getHilfeBildHoehe() {
        return this.HilfeBildHoehe;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getIndexPHPQuelle() {
        return this.IndexPHPQuelle;
    }

    private String getLinkBingMap(String[] fotoMetadaten) {
        return "https://bing.com/maps/default.aspx?cp=" + fotoMetadaten[0] + "~" + fotoMetadaten[1] + "&lvl=" + (this.getZoomLevelOpenStreetMap() - 3) + "&sp=point." + fotoMetadaten[0] + "_" + fotoMetadaten[1] + "_Foto";
    }

    private String getLinkOpenStreetMap(String[] fotoMetadaten) {
        return fotoMetadaten[0].isEmpty() || fotoMetadaten[1].isEmpty() ? "" : "https://www.openstreetmap.org/?mlat=" + fotoMetadaten[0] + "&mlon=" + fotoMetadaten[1] + "#map=" + this.getZoomLevelOpenStreetMap() + "/" + fotoMetadaten[0] + "/" + fotoMetadaten[1];
    }

    private String getMedienGroesse(String art, int az_Bilder, int az_Gifs, int az_Videos) {
        String[][] texte = new String[][]{{"Die Galerie hat ", ""}, {" im Umfang von ", ": "}, {".", ""}};
        int index = art == "lang" ? 0 : 1;
        return String.valueOf(texte[0][index]) + this.getBilderUndVideoText(az_Bilder, az_Gifs, az_Videos) + texte[1][index] + Diashow.formatGroesse(this.getGroesseBilder() + this.getGroesseGifs() + this.getGroesseVideos()) + texte[2][index];
    }

    private String[] getMetadaten(ArrayList<String> metadaten, String foto, char aktivTypChar) {
        String[] fotoMetadaten = new String[]{"", "", "", ""};
        int posMetadaten = FString.findFirstString(metadaten, String.valueOf(foto) + "\t");
        if (posMetadaten < 0) {
            FDatei.Exif2Text fotoText = new FDatei.Exif2Text(FDatei.instance());
            fotoText.setData(String.valueOf(this.getVerzeichnis()) + foto + (aktivTypChar == 'j' ? "-oben-0.jpg" : "_video_poster.jpg"));
            fotoMetadaten = fotoText.getDaten4Diashow();
            if (fotoMetadaten[0] == null || fotoMetadaten[0].isEmpty() || fotoMetadaten[1] == null || fotoMetadaten[1].isEmpty() || fotoMetadaten[3] == null || fotoMetadaten[3].isEmpty()) {
                FProt.instance().prot(String.valueOf(foto) + " hat keine Koordinaten oder Kamera-Metadaten", this.isShowWarnMissCoord() ? 0 : 5);
            }
            metadaten.add(String.valueOf(foto) + "\t" + fotoMetadaten[0] + "\t" + fotoMetadaten[1] + "\t" + fotoMetadaten[2] + "\t" + fotoMetadaten[3]);
        } else {
            String[] teile = metadaten.get(posMetadaten).split("\t");
            int i = 1;
            while (i < teile.length) {
                fotoMetadaten[i - 1] = teile[i];
                ++i;
            }
        }
        fotoMetadaten = FString.verbindenArrayMitString(fotoMetadaten, this.isReiseberichtVorhanden() ? "Reisebericht vorhanden" : "");
        return fotoMetadaten;
    }

    public int getMsgLvlAufrufVonAussen() {
        return this.MsgLvlAufrufVonAussen;
    }

    public String getName() {
        return this.Name;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    private ArrayList<String> getRelevanteBildernamen() {
        String[] filenames = new FFile(this.getBilderVerzeichnis()).listFileNames();
        ArrayList<String> images = new ArrayList<String>();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if ((dateiname.endsWith(".JPG") || dateiname.endsWith(".jpg") || dateiname.endsWith(".GIF") || dateiname.endsWith(".gif")) && dateiname.compareToIgnoreCase("Filler.jpg") != 0 && !dateiname.endsWith("_video_poster.jpg")) {
                images.add(dateiname);
            }
            ++n2;
        }
        return images;
    }

    public String getStand() {
        return "1.2.2019";
    }

    public String getThumbsAspekt() {
        return this.ThumbsAspekt;
    }

    public int getThumbsBreite() {
        return this.ThumbsBreite;
    }

    private String getThumbsGroesse() {
        return String.valueOf(this.getThumbsBreite()) + "x" + this.getThumbsHoehe();
    }

    private int getThumbsHoehe() {
        return this.ThumbsHoehe;
    }

    private String getTitleFromIndex() {
        String titleFromIndex = "";
        if (this.isGetTitleIfAvailable()) {
            String[] index;
            String[] stringArray = index = new FFile(this.Verzeichnis, "index.htm").inhaltToStringArray("UTF-8");
            int n = index.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.indexOf("<title>") >= 0) {
                    try {
                        String[] teile = element.split("<title>");
                        titleFromIndex = teile[1].split("</title>")[0];
                    }
                    catch (Exception exception) {}
                    break;
                }
                ++n2;
            }
        }
        return Futi.htmlVariablenAufloesen(titleFromIndex);
    }

    private String getUrlBilder() {
        return this.UrlBilder;
    }

    private String getUrlVideos() {
        return this.UrlVideos;
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    private String getVerzVideos() {
        return this.VerzVideos;
    }

    private ArrayList<String> getVideoPoster() {
        String[] filenames = new FFile(this.getVerzeichnis()).listFileNames();
        ArrayList<String> videoPoster = new ArrayList<String>();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if (dateiname.endsWith("_video_poster.jpg")) {
                videoPoster.add(dateiname);
            }
            ++n2;
        }
        return videoPoster;
    }

    private String getVideoText(String suche, int spalte, boolean sucheBeiNotfoundZurueckgeben) {
        int pos;
        String gefunden;
        String string = gefunden = sucheBeiNotfoundZurueckgeben ? suche : "";
        if (this.VideoText != null && (pos = FString.findFirstString(this.VideoText, 0, suche, true, true)) >= 0) {
            gefunden = this.VideoText[pos][spalte];
        }
        return gefunden;
    }

    public String getVideoVerzeichnisBasis() {
        return this.VideoVerzeichnisBasis;
    }

    private int getZoomLevelOpenStreetMap() {
        return 16;
    }

    private void increaseGesamtdauerGifs(int dauerGif) {
        this.GesamtdauerGifs += dauerGif;
    }

    private void increaseGesamtdauerVideos(int dauerVideo) {
        this.GesamtdauerVideos += dauerVideo;
    }

    private int incrementAzHtmlUnchanged() {
        return this.AzHtmlUnchanged++;
    }

    private int incrementAzHtmlWrite() {
        return this.AzHtmlWrite++;
    }

    private int incrementAzVideoHtmlUnchanged() {
        return this.AzVideoHtmlUnchanged++;
    }

    private int incrementAzVideoHtmlWrite() {
        return this.AzVideoHtmlWrite++;
    }

    private void initGesamtdauerGifs() {
        this.GesamtdauerGifs = 0;
    }

    private void initGesamtdauerVideos() {
        this.GesamtdauerVideos = 0;
    }

    private boolean isCheckAndCleanWebsite() {
        return this.CheckAndCleanWebsite;
    }

    private boolean isCheckAndTableOutput() {
        return this.CheckAndTableOutput;
    }

    private boolean isCheckWebsite() {
        return this.CheckWebsite;
    }

    public boolean isCreateBilderUndThumbs() {
        return this.CreateBilderUndThumbs;
    }

    public boolean isCreateVideoThumbsOnly() {
        return this.CreateVideoThumbsOnly;
    }

    public boolean isGetTitleIfAvailable() {
        return this.GetTitleIfAvailable;
    }

    private boolean isHilfeBildOK() {
        return this.HilfeBildOK;
    }

    private boolean isKeineStatistikAufIndexseite() {
        return this.KeineStatistikAufIndexseite;
    }

    private boolean isMehrAlsEineMedienart() {
        return this.MehrAlsEineMedienart;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isShowNoWrite() {
        return this.ShowNoWrite;
    }

    public boolean isShowWarnMissCoord() {
        return this.ShowWarnMissCoord;
    }

    public boolean isShowWrite() {
        return this.ShowWrite;
    }

    private boolean isVideoSteuerungValid() {
        return this.VideoSteuerungValid;
    }

    public boolean isVideoUrlImWebspace() {
        return this.VideoUrlImWebspace;
    }

    private void protokolliereWrite(String[] write) {
        FProt fProt = FProt.instance();
        if (write.length > 0) {
            String Dateiname = write[0].split(": ")[1];
            if (write[0].startsWith("create") || write[0].startsWith("overwrite")) {
                if (Dateiname.startsWith(this.getVerzeichnis())) {
                    this.incrementAzHtmlWrite();
                } else if (Dateiname.startsWith(this.getVerzVideos())) {
                    this.incrementAzVideoHtmlWrite();
                }
                if (this.isShowWrite()) {
                    fProt.prot(write[0]);
                }
            }
            if (write[0].startsWith("nowrite")) {
                if (Dateiname.startsWith(this.getVerzeichnis())) {
                    this.incrementAzHtmlUnchanged();
                } else if (Dateiname.startsWith(this.getVerzVideos())) {
                    this.incrementAzVideoHtmlUnchanged();
                }
                if (this.isShowNoWrite()) {
                    fProt.prot(write[0]);
                }
            }
        }
    }

    public void run() {
        this.setVerzeichnis(FDatei.checkFileSeperator(this.getVerzeichnis(), true));
        this.setBilderVerzeichnis(FDatei.checkFileSeperator(this.getBilderVerzeichnis(), true));
        this.setVideoSteuerung();
        this.setGifText();
        String titleFromIndex = this.getTitleFromIndex();
        this.setName(titleFromIndex.length() > 0 ? titleFromIndex : this.getName());
        this.setCheckWebsite(this.getFunktion().compareToIgnoreCase("Check") == 0);
        this.setCheckAndCleanWebsite(this.getFunktion().compareToIgnoreCase("CheckAndClean") == 0);
        this.setCheckAndTableOutput(this.getFunktion().compareToIgnoreCase("CheckAndTableOutput") == 0);
        if (this.isCreateVideoThumbsOnly()) {
            this.setCreateBilderUndThumbs(false);
        }
        if (this.isCheckWebsite() || this.isCheckAndCleanWebsite() || this.isCheckAndTableOutput()) {
            this.checkWebsite();
        } else {
            FProt fProt = FProt.instance();
            this.setBilderHoehe(Diashow.getHoeheVonAspekt(this.getBilderBreite(), this.getBilderAspekt()));
            this.setThumbsHoehe(Diashow.getHoeheVonAspekt(this.getThumbsBreite(), this.getThumbsAspekt()));
            int az_Bilder = 0;
            int az_Gifs = 0;
            int az_Videos = 0;
            if (this.isCreateBilderUndThumbs()) {
                fProt.prot("Bilder: " + this.getBilderGroesse() + ", Thumbs: " + this.getThumbsGroesse());
                this.createBilderAndThumbs();
            }
            if (this.isCreateVideoThumbsOnly()) {
                fProt.prot("Thumbs: " + this.getThumbsGroesse());
                this.createVideoAndThumbs();
            }
            String[] filenames = new FFile(this.getVerzeichnis()).listFileNames();
            ArrayList<String> baseName = new ArrayList<String>();
            ArrayList<String> baseTyp = new ArrayList<String>();
            ArrayList<String> metadaten = new FFile(this.getVerzeichnis(), "_metadaten.txt").inhaltToStringArrayList("UTF-8");
            String[] fotoMetadaten = new String[2];
            this.setReiseberichtVorhanden(new File(this.getVerzeichnis(), "_reisebericht.pdf").exists());
            this.initGesamtdauerGifs();
            this.initGesamtdauerVideos();
            this.setGroesseBilderGifsUndVideos(az_Bilder, az_Gifs, az_Videos);
            String laengeGif = "";
            String laengeVideo = "";
            this.setKeineStatistikAufIndexseite(false);
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String dateiname = stringArray[n2];
                if (dateiname.endsWith("_thumb.jpg")) {
                    baseName.add(dateiname.substring(0, dateiname.length() - 10));
                    baseTyp.add("jpg");
                    ++az_Bilder;
                } else if (dateiname.endsWith("_thumb_gif.jpg")) {
                    baseName.add(dateiname.substring(0, dateiname.length() - 14));
                    baseTyp.add("gif");
                    ++az_Gifs;
                    laengeGif = this.getGifText(dateiname.substring(0, dateiname.length() - 14), 3, false);
                    try {
                        this.increaseGesamtdauerGifs(Integer.parseInt(laengeGif));
                    }
                    catch (Exception exception) {}
                } else if (dateiname.endsWith("_gallery.jpg")) {
                    baseName.add(dateiname.substring(0, dateiname.length() - 12));
                    baseTyp.add("mp4");
                    ++az_Videos;
                    if (this.isVideoSteuerungValid()) {
                        laengeVideo = this.getVideoText(dateiname.substring(0, dateiname.length() - 12), 3, false);
                        try {
                            this.increaseGesamtdauerVideos(Integer.parseInt(laengeVideo));
                        }
                        catch (Exception exception) {}
                    }
                } else if (dateiname.compareToIgnoreCase("_keine_Statistik_auf_Indexseite") == 0) {
                    this.setKeineStatistikAufIndexseite(true);
                }
                ++n2;
            }
            if (baseName.size() == 0) {
                fProt.prot("Keine Thumbs in >" + this.getVerzeichnis() + "< vorhanden, keine Verarbeitung");
            } else {
                fProt.prot("Name der Diashow in >" + this.getVerzeichnis() + "< " + this.getName() + (this.isVideoSteuerungValid() ? ", Videos werden in >" + this.getVerzVideos() + "< gespeichert" : ""));
                if (this.isVideoSteuerungValid()) {
                    fProt.prot("URL der Videos: " + this.getUrlVideos() + ", URL der Bilder: " + this.getUrlBilder());
                }
                String aktiv = "";
                String prev = "";
                String next = "";
                char aktivTypChar = 'j';
                char prevTypChar = 'j';
                char nextTypChar = 'j';
                this.setAzHtmlUnchanged(0);
                this.setAzHtmlWrite(0);
                this.setAzVideoHtmlUnchanged(0);
                this.setAzVideoHtmlWrite(0);
                this.checkHilfe();
                if (az_Bilder + az_Gifs > 0) {
                    this.createHilfe("_hilfe.html", "index.htm", null);
                }
                this.setGroesseBilderGifsUndVideos(az_Bilder, az_Gifs, az_Videos);
                this.createIndex(baseName, baseTyp, az_Bilder, az_Gifs, az_Videos);
                int i = 0;
                while (i < baseName.size()) {
                    aktiv = baseName.get(i);
                    aktivTypChar = baseTyp.get(i).charAt(0);
                    prev = i > 0 ? baseName.get(i - 1) : "";
                    prevTypChar = i > 0 ? (char)baseTyp.get(i - 1).charAt(0) : (char)'j';
                    next = i < baseName.size() - 1 ? baseName.get(i + 1) : "";
                    nextTypChar = i < baseName.size() - 1 ? (char)baseTyp.get(i + 1).charAt(0) : (char)'j';
                    fotoMetadaten = this.getMetadaten(metadaten, aktiv, aktivTypChar);
                    this.createAnzeigeSeite(aktivTypChar, prevTypChar, nextTypChar, 0, aktiv, prev, next, fotoMetadaten, baseName.size() < 5);
                    this.createAnzeigeSeite(aktivTypChar, prevTypChar, nextTypChar, 5, aktiv, prev, next, fotoMetadaten, baseName.size() < 5);
                    if (aktivTypChar == 'j') {
                        this.createAnzeigeSeite(aktivTypChar, prevTypChar, nextTypChar, 3, aktiv, prev, next, fotoMetadaten, baseName.size() < 5);
                        this.createAnzeigeSeite(aktivTypChar, prevTypChar, nextTypChar, 1, aktiv, prev, next, fotoMetadaten, baseName.size() < 5);
                    }
                    ++i;
                }
                fProt.prot("Fuer " + this.getBilderUndVideoText(az_Bilder, az_Gifs, az_Videos) + " je 1 statische Html-Datei und 3 (Video oder Gif: 1) Html-Dateien fuer Diashow" + " mit den zugehoerigen Hilfeseiten in >" + this.getVerzeichnis() + "< " + (this.isVideoSteuerungValid() ? "bzw. in >" + this.getVerzVideos() + "< " : "") + "erstellt.");
                fProt.prot(String.valueOf(this.getAzHtmlWrite()) + " Html-Dateien geschrieben, " + this.getAzHtmlUnchanged() + " Html-Dateien unveraendert in >" + this.getVerzeichnis() + "<");
                if (this.isVideoSteuerungValid()) {
                    fProt.prot(String.valueOf(this.getAzVideoHtmlWrite()) + " Html-Dateien geschrieben, " + this.getAzVideoHtmlUnchanged() + " Html-Dateien unveraendert in >" + this.getVerzVideos() + "<");
                }
            }
            new FFile(this.getVerzeichnis(), "_metadaten.txt").StringArrayListToInhalt(metadaten, "UTF-8", true);
        }
    }

    private void setAzHtmlUnchanged(int azHtmlUnchanged) {
        this.AzHtmlUnchanged = azHtmlUnchanged;
    }

    private void setAzHtmlWrite(int azHtmlWrite) {
        this.AzHtmlWrite = azHtmlWrite;
    }

    private void setAzVideoHtmlUnchanged(int azVideoHtmlUnchanged) {
        this.AzVideoHtmlUnchanged = azVideoHtmlUnchanged;
    }

    private void setAzVideoHtmlWrite(int azVideoHtmlWrite) {
        this.AzVideoHtmlWrite = azVideoHtmlWrite;
    }

    public void setBilderAspekt() {
        this.BilderAspekt = FParam.getStringParameter("BilderAspekt", this.ArgTab);
    }

    public void setBilderAspekt(String bilderAspekt) {
        this.BilderAspekt = FParam.checkStringParameter("BilderAspekt", bilderAspekt, this.ArgTab);
    }

    public void setBilderBreite() {
        this.BilderBreite = FParam.getIntParameter("BilderBreite", this.ArgTab);
    }

    public void setBilderBreite(int bilderBreite) {
        this.BilderBreite = FParam.checkIntParameter("BilderBreite", bilderBreite, this.ArgTab);
    }

    public void setBilderBreite(String bilderBreite) {
        this.BilderBreite = FParam.checkIntParameter("BilderBreite", bilderBreite, this.ArgTab);
    }

    private void setBilderHoehe(int bilderHoehe) {
        this.BilderHoehe = bilderHoehe;
    }

    public void setBilderObenProzent() {
        this.BilderObenProzent = FParam.getIntParameter("BilderObenProzent", this.ArgTab);
    }

    public void setBilderObenProzent(int bilderObenProzent) {
        this.BilderObenProzent = FParam.checkIntParameter("BilderObenProzent", bilderObenProzent, this.ArgTab);
    }

    public void setBilderObenProzent(String bilderObenProzent) {
        this.BilderObenProzent = FParam.checkIntParameter("BilderObenProzent", bilderObenProzent, this.ArgTab);
    }

    public void setBilderVerzeichnis() {
        this.BilderVerzeichnis = FParam.getStringParameter("BilderVerzeichnis", this.ArgTab);
    }

    public void setBilderVerzeichnis(String bilderVerzeichnis) {
        this.BilderVerzeichnis = FParam.checkStringParameter("BilderVerzeichnis", bilderVerzeichnis, this.ArgTab);
    }

    public void setCheck() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    private void setCheckAndCleanWebsite(boolean checkAndCleanWebsite) {
        this.CheckAndCleanWebsite = checkAndCleanWebsite;
    }

    private void setCheckAndTableOutput(boolean checkAndTableOutput) {
        this.CheckAndTableOutput = checkAndTableOutput;
    }

    public void setCheckDateiName() {
        this.CheckDateiName = FParam.getStringParameter("CheckDateiName", this.ArgTab);
    }

    public void setCheckDateiName(String nameCheckDatei) {
        this.CheckDateiName = FParam.checkStringParameter("CheckDateiName", nameCheckDatei, this.ArgTab);
    }

    private void setCheckWebsite(boolean checkWebsite) {
        this.CheckWebsite = checkWebsite;
    }

    public void setCreateBilderUndThumbs() {
        this.CreateBilderUndThumbs = FParam.getBooleanParameter("CreateBilderUndThumbs", this.ArgTab);
    }

    public void setCreateBilderUndThumbs(boolean createBilderUndThumbs) {
        this.CreateBilderUndThumbs = createBilderUndThumbs;
    }

    public void setCreateVideoThumbsOnly() {
        this.CreateVideoThumbsOnly = FParam.getBooleanParameter("CreateVideoThumbsOnly", this.ArgTab);
    }

    public void setCreateVideoThumbsOnly(boolean createVideoThumbsOnly) {
        this.CreateVideoThumbsOnly = createVideoThumbsOnly;
    }

    public void setExterneListe(String[] externeListe) {
        this.ExterneListe = externeListe;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String check) {
        this.Funktion = FParam.checkStringParameter("Funktion", check, this.ArgTab);
    }

    public void setGetTitleIfAvailable() {
        this.GetTitleIfAvailable = FParam.getBooleanParameter("GetTitleIfAvailable", this.ArgTab);
    }

    public void setGetTitleIfAvailable(boolean getTitleIfAvailable) {
        this.GetTitleIfAvailable = getTitleIfAvailable;
    }

    private void setGifText() {
        String[] input = new FFile(this.getVerzeichnis(), "_gifs.txt").inhaltToStringArray("UTF-8");
        this.GifText = input.length == 0 ? null : FString.convertStringArrayToTabelle(input, 4, true);
    }

    private void setGroesseBilderGifsUndVideos(int az_Bilder, int az_Gifs, int az_Videos) {
        String[] verz;
        this.groesseBilder = 0.0;
        this.groesseGifs = 0.0;
        this.groesseVideos = 0.0;
        String[] stringArray = verz = new String[]{this.getVerzeichnis(), this.getVerzVideos()};
        int n = verz.length;
        int n2 = 0;
        while (n2 < n) {
            String verzTest = stringArray[n2];
            if (verzTest != null) {
                String[] filenames;
                String[] stringArray2 = filenames = new FFile(verzTest).listFileNames();
                int n3 = filenames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dateiname = stringArray2[n4];
                    if (dateiname.endsWith(".jpg") || dateiname.endsWith(".gif") || dateiname.endsWith(".mp4")) {
                        File getSize = new File(verzTest, dateiname);
                        if (dateiname.endsWith(".jpg")) {
                            this.groesseBilder += (double)getSize.length() / 1048576.0;
                        }
                        if (dateiname.endsWith(".gif")) {
                            this.groesseGifs += (double)getSize.length() / 1048576.0;
                        }
                        if (dateiname.endsWith(".mp4")) {
                            this.groesseVideos += (double)getSize.length() / 1048576.0;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        int anzahlMedienarten = 0;
        if (az_Bilder > 0) {
            ++anzahlMedienarten;
        }
        if (az_Gifs > 0) {
            ++anzahlMedienarten;
        }
        if (az_Videos > 0) {
            ++anzahlMedienarten;
        }
        this.MehrAlsEineMedienart = anzahlMedienarten > 1;
    }

    private void setHilfeBildBreite(int hilfeBildBreite) {
        this.HilfeBildBreite = hilfeBildBreite;
    }

    private void setHilfeBildHoehe(int hilfeBildHoehe) {
        this.HilfeBildHoehe = hilfeBildHoehe;
    }

    private void setHilfeBildOK(boolean hilfeBildOK) {
        this.HilfeBildOK = hilfeBildOK;
    }

    public void setIndexPHPQuelle() {
        this.IndexPHPQuelle = FParam.getStringParameter("IndexPHPQuelle", this.ArgTab);
    }

    public void setIndexPHPQuelle(String indexPHPQuelle) {
        this.IndexPHPQuelle = FParam.checkStringParameter("IndexPHPQuelle", indexPHPQuelle, this.ArgTab);
    }

    private void setKeineStatistikAufIndexseite(boolean keineStatistikAufIndexseite) {
        this.KeineStatistikAufIndexseite = keineStatistikAufIndexseite;
    }

    public void setMsgLvlAufrufVonAussen(int msgLvlVideosteuerung) {
        this.MsgLvlAufrufVonAussen = msgLvlVideosteuerung;
    }

    public void setName() {
        this.Name = FParam.getStringParameter("Name", this.ArgTab);
    }

    public void setName(String name) {
        this.Name = FParam.checkStringParameter("Name", name, this.ArgTab);
    }

    public void setShowNoWrite() {
        this.ShowNoWrite = FParam.getBooleanParameter("ShowNoWrite", this.ArgTab);
    }

    public void setShowNoWrite(boolean showNoWrite) {
        this.ShowNoWrite = showNoWrite;
    }

    public void setShowWarnMissCoord() {
        this.ShowWarnMissCoord = FParam.getBooleanParameter("ShowWarnMissCoord", this.ArgTab);
    }

    public void setShowWarnMissCoord(boolean showWarnMissCoord) {
        this.ShowWarnMissCoord = showWarnMissCoord;
    }

    public void setShowWrite() {
        this.ShowWrite = FParam.getBooleanParameter("ShowWrite", this.ArgTab);
    }

    public void setShowWrite(boolean showWrite) {
        this.ShowWrite = showWrite;
    }

    private void setTextOnThumb(String dateiname, String suchString, char typ) {
        int pointSize = this.getThumbsHoehe() / 10;
        float faktorStroke = 0.133f;
        String[] parmCreateText = new String[]{"-gravity", "center", "-font", Futi.getBenutzerWert("ExiftoolTAHOMA"), "-pointsize", "" + pointSize, "-stroke", "#000C", "-strokewidth", "" + (int)((float)pointSize * 0.133f), "-annotate", "+0+" + (int)((float)pointSize * 0.133f * 2.0f), "Text fehlt", "-stroke", "none", "-fill", "white", "-annotate", "+0+" + (int)((float)pointSize * 0.133f * 2.0f), "Text fehlt", this.getVerzeichnis()};
        String text = "";
        if (typ == 'm') {
            text = this.getVideoText(suchString, 2, false);
        }
        if (typ == 'g') {
            text = this.getGifText(suchString, 2, false);
        }
        if (text.length() > 0) {
            parmCreateText[12] = text;
            parmCreateText[19] = text;
            parmCreateText[20] = dateiname;
            FBefehl.aufrufBefehl("mogrify", parmCreateText, 0);
        }
    }

    public void setThumbsAspekt() {
        this.ThumbsAspekt = FParam.getStringParameter("ThumbsAspekt", this.ArgTab);
    }

    public void setThumbsAspekt(String thumbsAspekt) {
        this.ThumbsAspekt = FParam.checkStringParameter("ThumbsAspekt", thumbsAspekt, this.ArgTab);
    }

    public void setThumbsBreite() {
        this.ThumbsBreite = FParam.getIntParameter("ThumbsBreite", this.ArgTab);
    }

    public void setThumbsBreite(int thumbsBreite) {
        this.ThumbsBreite = FParam.checkIntParameter("ThumbsBreite", thumbsBreite, this.ArgTab);
    }

    public void setThumbsBreite(String thumbsBreite) {
        this.ThumbsBreite = FParam.checkIntParameter("ThumbsBreite", thumbsBreite, this.ArgTab);
    }

    private void setThumbsHoehe(int thumbsHoehe) {
        this.ThumbsHoehe = thumbsHoehe;
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setVerzeichnisStattUrl() {
        this.VideoUrlImWebspace = FParam.getBooleanParameter("VideoUrlImWebspace", this.ArgTab);
    }

    private void setVideoSteuerung() {
        String[] input = new FFile(this.getVerzeichnis(), "_videos.txt").inhaltToStringArray("UTF-8");
        if (input.length == 0) {
            this.VideoText = null;
            this.VerzVideos = "";
            this.UrlVideos = "";
            this.UrlBilder = "";
            this.VideoSteuerungValid = false;
            FProt.instance().prot("Keine VideoSteuerung vorhanden", this.getMsgLvlAufrufVonAussen());
        } else {
            this.VideoText = FString.convertStringArrayToTabelle(input, 4, true);
            this.VerzVideos = String.valueOf(this.getVideoVerzeichnisBasis()) + this.getVideoText("$$$VerzVideos$$$", 1, false);
            if (Futi.isWindows()) {
                this.VerzVideos = this.VerzVideos.replace('/', '\\');
            }
            if (Futi.isMac()) {
                this.VerzVideos = this.VerzVideos.replace('\\', '/');
            }
            if (this.isVideoUrlImWebspace()) {
                String verzBilder = this.getVerzeichnis().replace('\\', '/');
                String verzVideos = this.VerzVideos.replace('\\', '/');
                int pos = 0;
                int i = 0;
                while (i < Math.min(verzBilder.length(), verzVideos.length())) {
                    if (verzBilder.charAt(i) != verzVideos.charAt(i)) break;
                    pos = i++;
                }
                verzBilder = verzBilder.substring(pos);
                verzVideos = verzVideos.substring(pos);
                verzBilder = verzBilder.startsWith("/") ? verzBilder.substring(1) : verzBilder;
                verzVideos = verzVideos.startsWith("/") ? verzVideos.substring(1) : verzVideos;
                String back = "";
                int anzahlStufenBackBilder = Futi.getAnzahlQualifier(verzBilder, "/");
                int i2 = 0;
                while (i2 < anzahlStufenBackBilder) {
                    back = String.valueOf(back) + "../";
                    ++i2;
                }
                this.UrlVideos = String.valueOf(back) + verzVideos;
                back = "";
                int anzahlStufenBackVideos = Futi.getAnzahlQualifier(verzVideos, "/");
                int i3 = 0;
                while (i3 < anzahlStufenBackVideos) {
                    back = String.valueOf(back) + "../";
                    ++i3;
                }
                this.UrlBilder = String.valueOf(back) + verzBilder;
            } else {
                this.UrlBilder = this.getVideoText("$$$UrlBilder$$$", 1, false);
                this.UrlVideos = this.getVideoText("$$$UrlVideos$$$", 1, false);
            }
            File test = new File(this.VerzVideos);
            this.VideoSteuerungValid = this.getVideoText("$$$VerzVideos$$$", 1, false).length() > 0 && this.getVideoText("$$$UrlBilder$$$", 1, false).length() > 0 && this.getVideoText("$$$UrlVideos$$$", 1, false).length() > 0 && test.exists() && test.isDirectory();
            FProt.instance().prot(String.valueOf(this.getVerzeichnis()) + ": VideoSteuerung gueltig: " + this.isVideoSteuerungValid(), 0);
            if (!this.isVideoSteuerungValid()) {
                FProt.instance().prot(" -> getVideoText(\"$$$VerzVideos$$$\": " + this.getVideoText("$$$VerzVideos$$$", 1, false), 0);
                FProt.instance().prot(" -> getVideoText(\"$$$UrlBilder$$$\": " + this.getVideoText("$$$UrlBilder$$$", 1, false), 0);
                FProt.instance().prot(" -> getVideoText(\"$$$UrlVideos$$$\": " + this.getVideoText("$$$UrlVideos$$$", 1, false), 0);
                FProt.instance().prot(" -> VerzVideos " + test.getAbsolutePath() + " vorhanden: " + test.exists(), 0);
                FProt.instance().prot(" -> VerzVideos " + test.getAbsolutePath() + " ist Verzeichnis: " + test.isDirectory(), 0);
                FProt.instance().prot(" ->", 0);
                FProt.instance().prot(FString.convertTabelleToStringArray(this.VideoText), 0);
            }
        }
    }

    public void setVideoUrlImWebspace() {
        this.VideoUrlImWebspace = FParam.getBooleanParameter("VideoUrlImWebspace", this.ArgTab);
    }

    public void setVideoUrlImWebspace(boolean verzeichnisStattUrl) {
        this.VideoUrlImWebspace = verzeichnisStattUrl;
    }

    public void setVideoVerzeichnisBasis() {
        this.VideoVerzeichnisBasis = FParam.getStringParameter("VideoVerzeichnisBasis", this.ArgTab);
    }

    public void setVideoVerzeichnisBasis(String videoVerzeichnisBasis) {
        this.VideoVerzeichnisBasis = FParam.checkStringParameter("VideoVerzeichnisBasis", videoVerzeichnisBasis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setVerzeichnis();
        this.setBilderVerzeichnis();
        this.setVideoVerzeichnisBasis();
        this.setName();
        this.setGetTitleIfAvailable();
        this.setCreateBilderUndThumbs();
        this.setCreateVideoThumbsOnly();
        this.setBilderBreite();
        this.setBilderObenProzent();
        this.setBilderAspekt();
        this.setThumbsBreite();
        this.setThumbsAspekt();
        this.setShowWrite();
        this.setVideoUrlImWebspace();
        this.setShowNoWrite();
        this.setShowWarnMissCoord();
        this.setCheckDateiName();
        this.setIndexPHPQuelle();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Funktion                                          :" + this.getFunktion());
        fProt.prot("Verzeichnis der Diashow                           :" + this.getVerzeichnis());
        fProt.prot("Verzeichnis der Bilder                            :" + this.getBilderVerzeichnis());
        fProt.prot("Basisverzeichnis der Videos                       :" + this.getVideoVerzeichnisBasis());
        fProt.prot("Name der Diashow                                  :" + this.getName());
        fProt.prot("Titel aus index.htm holen, falls vorhanden        :" + this.isGetTitleIfAvailable());
        fProt.prot("Bilder und Thumbs neu erstellen                   :" + this.isCreateBilderUndThumbs());
        fProt.prot("Nur Thumbs fuer Videos neu erstellen              :" + this.isCreateVideoThumbsOnly());
        fProt.prot("maximale Breite der Bilder                        :" + this.getBilderBreite());
        fProt.prot("Prozent des oberen Teils                          :" + this.getBilderObenProzent());
        fProt.prot("Aspekt der Bilder                                 :" + this.getBilderAspekt());
        fProt.prot("maximale Breite der Thumbs                        :" + this.getThumbsBreite());
        fProt.prot("Aspekt der Thumbs                                 :" + this.getThumbsAspekt());
        fProt.prot("Schreiben Html-Dateien zeigen                     :" + this.isShowWrite());
        fProt.prot("bei Videos: URLs im Webspace statt im Internet    :" + this.isVideoUrlImWebspace());
        fProt.prot("Unveraenderte Html-Dateien zeigen                 :" + this.isShowNoWrite());
        fProt.prot("Warnung, falls Koordinaten oder Kameradaten fehlen:" + this.isShowWarnMissCoord());
        fProt.prot("Name der CheckDateien                             :" + this.getCheckDateiName());
        fProt.prot("Quelle fuer index.php                             :" + this.getIndexPHPQuelle());
    }

    private boolean isReiseberichtVorhanden() {
        return this.reiseberichtVorhanden;
    }

    private void setReiseberichtVorhanden(boolean reiseberichtVorhanden) {
        this.reiseberichtVorhanden = reiseberichtVorhanden;
    }
}

