/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Datei2Tabelle;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import de.nss.jfi.Uti.JpegExif;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class FDir {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Verzeichnis;
    private String AuswahlDatei;
    private boolean LeereDateien;
    private boolean NurTest;
    private boolean EndSumme;
    private boolean AusgabeNurInDatei;
    private boolean BeimKopierenNichtUeberschrieben;
    private String AuswahlVerzeichnis;
    private boolean AuswahlDatExclude;
    private String AuswahlDatumZeitFormat;
    private String Ausgabedatei;
    private String StichtagAlsDatum;
    private String StichtagUhrzeitZumDatum;
    private String[][] ExterneListe;
    private int StichtagInTagen;
    private boolean StichtagVergleichAelter;
    private boolean NurBilder;
    private boolean NurVideos;
    private final boolean SetzenWerteInGUInachRun = true;
    private boolean NurDirectories;
    private int Groesse;
    private int HardLinkCount;
    private double Summe;
    private int RenameStart;
    private int Tiefe;
    private boolean AuswahlVerzExclude;
    private String DateiListe;
    private int AnzahlDateienInVerzeichnis;
    private String Funktion;
    private String RenameName;
    private String Format;
    private String MusterFormat;
    private String DBName;
    private String CharsetAusgabeDatei;
    private String Tabelle;
    private boolean HeaderBeiFormat;
    private boolean AusgabeInTabelle;
    private int RenameLaengeNummer;
    private int RenameAnzahlDurchlaeufe;
    private String RenameTrennzeichen;
    private String KopierVerzeichnis;
    private final String Stand = "1.8.2012";
    private int MsgLvlAufrufVonAussen = 0;

    private static String getVerzeichnisOhneLetzteEbene(String verz) {
        int pos;
        String verzOhneletzteEbene = verz;
        if (verzOhneletzteEbene.endsWith(System.getProperty("file.separator"))) {
            verzOhneletzteEbene = verzOhneletzteEbene.substring(0, verzOhneletzteEbene.length() - System.getProperty("file.separator").length());
        }
        if ((pos = verzOhneletzteEbene.lastIndexOf(System.getProperty("file.separator"))) > 0) {
            verzOhneletzteEbene = verzOhneletzteEbene.substring(0, pos);
        }
        return verzOhneletzteEbene;
    }

    private static String getVerzeichnisOhneVorletzteEbene(String verz) {
        int posVorletzte;
        int posLetzte;
        String verzOhneletzteEbene = verz;
        if (verzOhneletzteEbene.endsWith(System.getProperty("file.separator"))) {
            verzOhneletzteEbene = verzOhneletzteEbene.substring(0, verzOhneletzteEbene.length() - System.getProperty("file.separator").length());
        }
        if ((posLetzte = verzOhneletzteEbene.lastIndexOf(System.getProperty("file.separator"))) > 0 && (posVorletzte = verzOhneletzteEbene.substring(0, posLetzte).lastIndexOf(System.getProperty("file.separator"))) > 0) {
            verzOhneletzteEbene = String.valueOf(verzOhneletzteEbene.substring(0, posVorletzte)) + verzOhneletzteEbene.substring(posLetzte);
        }
        return verzOhneletzteEbene;
    }

    public static void main(String[] args) {
        FDir fDir = new FDir(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fDir.ArgTab, fDir.ArgTabDefault, fDir.getHilfeText())) {
            try {
                fDir.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fDir.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fDir.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fDir.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fDir.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public FDir() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FDir(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void addSumme(double summe) {
        this.Summe += summe;
    }

    public String[] aufbereitenListeVonDateien(String[] Dateien) {
        FProt fProt = FProt.instance();
        Futi.instance();
        String Zeile = "";
        ArrayList<String> Liste2 = new ArrayList<String>();
        boolean getExifDaten = false;
        boolean getExifAlleTags = false;
        boolean getExifGueltigeTags = false;
        boolean getAttribute = false;
        boolean countChars = false;
        boolean isGroesseFormatiert = false;
        boolean doClear = false;
        String[] ClearTab = new String[]{};
        this.setSumme(0.0);
        NumberFormat nfByte = NumberFormat.getInstance();
        nfByte.setMinimumIntegerDigits(1);
        NumberFormat nfMegaByte = NumberFormat.getInstance();
        nfMegaByte.setMaximumFractionDigits(2);
        nfMegaByte.setMinimumFractionDigits(1);
        String[][] formatMuster = Futi.readUmsetzung(String.valueOf(this.getClass().getSimpleName()) + ".FormatMuster");
        int i = 0;
        while (i < formatMuster.length) {
            if (formatMuster[i][0].compareTo(this.getMusterFormat()) == 0) {
                this.setFormat(formatMuster[i][1]);
                break;
            }
            ++i;
        }
        if (this.getFormat().indexOf(":g") >= 0 || this.getFormat().indexOf(":m") >= 0) {
            isGroesseFormatiert = true;
        }
        if (this.getFormat().indexOf(":JC") >= 0) {
            doClear = true;
            ClearTab = Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".clear");
        }
        if (this.getFormat().length() == 0) {
            this.setFormat(":S:T:G:T:F:T:V");
        }
        if (this.getFormat().indexOf(":X") >= 0) {
            getExifDaten = true;
        }
        if (this.getFormat().indexOf(":XT") >= 0) {
            getExifGueltigeTags = true;
        }
        if (this.getFormat().indexOf(":XX") >= 0) {
            getExifAlleTags = true;
        }
        if (this.getFormat().indexOf(":A") >= 0) {
            getAttribute = true;
        }
        if (this.getFormat().indexOf(":c") >= 0) {
            countChars = true;
        }
        if (this.isHeaderBeiFormat() || this.isAusgabeInTabelle()) {
            Zeile = this.getHeader();
        }
        if (Zeile.length() > 0) {
            Liste2.add(Zeile);
        }
        fProt.prot("Formatstring: " + this.getFormat());
        i = 0;
        while (i < Dateien.length) {
            String[] Teile = Dateien[i].split("\t");
            if (this.EndSumme) {
                this.addSumme(Double.parseDouble(Teile[1]));
            }
            if (this.getFormat().compareToIgnoreCase(":S:T:G:T:F:T:V") == 0) {
                Liste2.add(Dateien[i]);
            } else {
                Zeile = this.getFormat();
                if (Zeile.contains(":LC")) {
                    Zeile = Zeile.replace(":LC", String.valueOf(FDatei.getHardlinkCount(String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2])));
                }
                Zeile = Zeile.replace(":V", Teile[3]);
                Zeile = Zeile.replace(":OL", FDir.getVerzeichnisOhneLetzteEbene(Teile[3]));
                Zeile = Zeile.replace(":OVL", FDir.getVerzeichnisOhneVorletzteEbene(Teile[3]));
                Zeile = Zeile.replace(":ROL", FDir.getVerzeichnisOhneLetzteEbene(this.getRelativesVerzeichnis(Teile[3])));
                Zeile = Zeile.replace(":ROVL", FDir.getVerzeichnisOhneVorletzteEbene(this.getRelativesVerzeichnis(Teile[3])));
                Zeile = Zeile.replace(":R", this.getRelativesVerzeichnis(Teile[3]));
                Zeile = Zeile.replace(":Q", this.getRelativesVerzeichnisOhneErsteEbene(Teile[3]));
                if (Teile.length > 4 && Teile[4] != null && !Teile[4].isEmpty()) {
                    Zeile = Zeile.replace(":POS", Teile[4]);
                }
                Zeile = Zeile.replace(":F", Teile[2]);
                FDatei.DateinamenTeile TeileDateinamen = FDatei.instance().zerlegeDateiname(String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2], this.getRenameTrennzeichen());
                Zeile = Zeile.replace(":B", TeileDateinamen.getName());
                if (TeileDateinamen.getName().length() > 1) {
                    Zeile = Zeile.replace(":1B", TeileDateinamen.getName().toUpperCase().substring(0, 1));
                }
                if (TeileDateinamen.getParent().length() > 1) {
                    Zeile = Zeile.replace(":1P", TeileDateinamen.getParent().toUpperCase().substring(0, 1));
                }
                Zeile = Zeile.replace(":E", TeileDateinamen.getExtend());
                Zeile = Zeile.replace(":P", TeileDateinamen.getParent());
                Zeile = Zeile.replace(":IN", TeileDateinamen.getBaseBis_EndeBaseIgnorierenAbUndNummerisch());
                Zeile = Zeile.replace(":IZ", TeileDateinamen.getNumerischesEndeVonBas());
                Zeile = Zeile.replace(":I", TeileDateinamen.getBaseBis_EndeBaseIgnorierenAb());
                if (getExifDaten || getAttribute || countChars) {
                    FFile File2 = !this.isNurDirectories() ? new FFile(String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2]) : new FFile(Teile[3]);
                    String Leerzeichen = this.getAusgabedatei().length() > 0 || this.isAusgabeInTabelle() ? "" : "   ";
                    if (getExifDaten) {
                        if (File2.isPicture()) {
                            JpegExif ExifTags = JpegExif.getJpegExifWichtigeTags(File2);
                            Zeile = Zeile.replace(":XB", ExifTags.getBeschreibung());
                            Zeile = Zeile.replace(":XA", ExifTags.getArtist());
                            Zeile = Zeile.replace(":XC", ExifTags.getKameraModel());
                            Zeile = Zeile.replace(":XR", ExifTags.getCopyright());
                            Zeile = Zeile.replace(":XW", String.valueOf(ExifTags.getBreite()));
                            Zeile = Zeile.replace(":XH", String.valueOf(ExifTags.getHoehe()));
                            Zeile = Zeile.replace(":XS", ExifTags.getDateTimeOriginal(this.getAuswahlDatumZeitFormat().charAt(0)));
                            Zeile = Zeile.replace(":XD", ExifTags.getDateOriginal());
                            Zeile = Zeile.replace(":XZ", ExifTags.getTimeOriginal());
                        } else {
                            Zeile = Zeile.replace(":XB", "");
                            Zeile = Zeile.replace(":XK", "");
                            Zeile = Zeile.replace(":XA", "");
                            Zeile = Zeile.replace(":XC", "");
                            Zeile = Zeile.replace(":XR", "");
                            Zeile = Zeile.replace(":XN", "");
                            Zeile = Zeile.replace(":XS", "");
                            Zeile = Zeile.replace(":XD", "");
                            Zeile = Zeile.replace(":XZ", "");
                        }
                        if (File2.isPicture()) {
                            if (getExifGueltigeTags || getExifAlleTags) {
                                String Tags = FString.zusammenfuegenStringArray(JpegExif.getJpegExifAlleTags(File2, true, true, true, getExifAlleTags), String.valueOf(System.getProperty("line.separator")) + Leerzeichen);
                                if (Tags.length() > 0) {
                                    if (Zeile.length() > 3) {
                                        Zeile = Zeile.replace(":XT", String.valueOf(System.getProperty("line.separator")) + Leerzeichen + Tags);
                                        Zeile = Zeile.replace(":XX", String.valueOf(System.getProperty("line.separator")) + Leerzeichen + Tags);
                                    } else {
                                        Zeile = Zeile.replace(":XT", String.valueOf(Leerzeichen) + Tags);
                                        Zeile = Zeile.replace(":XX", String.valueOf(Leerzeichen) + Tags);
                                    }
                                } else {
                                    Zeile = Zeile.replace(":XT", "");
                                    Zeile = Zeile.replace(":XX", "");
                                }
                            }
                        } else {
                            Zeile = Zeile.replace(":XS", "");
                            Zeile = Zeile.replace(":XD", "");
                            Zeile = Zeile.replace(":XZ", "");
                            Zeile = Zeile.replace(":XT", "");
                        }
                    }
                    if (getAttribute) {
                        Zeile = Zeile.replace(":A", File2.getAttributes());
                    }
                    if (countChars) {
                        String Chars = FString.zusammenfuegenStringArray(FString.prefix(FString.convertTabelleToStringArray(File2.CountChars()), String.valueOf(Leerzeichen) + Teile[3] + System.getProperty("file.separator") + Teile[2] + Leerzeichen), System.getProperty("line.separator"), false);
                        Zeile = Chars.length() > 0 ? Zeile.replace(":c", String.valueOf(System.getProperty("line.separator")) + Chars) : Zeile.replace(":c", "");
                    }
                }
                if (doClear) {
                    String Clear = TeileDateinamen.getBaseBis_EndeBaseIgnorierenAb().replace(this.getRenameTrennzeichen(), " ").trim();
                    int j = 0;
                    while (j < ClearTab.length) {
                        if (Clear.endsWith(ClearTab[j])) {
                            Clear = Clear.substring(0, Clear.length() - 1);
                        }
                        ++j;
                    }
                    Zeile = Zeile.replace(":JC", Clear.trim());
                }
                Zeile = Zeile.replace(":JN", TeileDateinamen.getBaseBis_EndeBaseIgnorierenAbUndNummerisch().replace(this.getRenameTrennzeichen(), " "));
                Zeile = Zeile.replace(":J", TeileDateinamen.getBaseBis_EndeBaseIgnorierenAb().replace(this.getRenameTrennzeichen(), " "));
                if (isGroesseFormatiert) {
                    Zeile = Zeile.replace(":g", nfByte.format(Long.parseLong(String.valueOf(Teile[1]))));
                    Zeile = Zeile.replace(":m", nfMegaByte.format(Double.parseDouble(String.valueOf(Teile[1])) / 1048576.0));
                }
                Zeile = Zeile.replace(":G", String.valueOf(Teile[1]));
                Zeile = Zeile.replace(":M", nfMegaByte.format(Double.parseDouble(String.valueOf(Teile[1])) / 1048576.0));
                Zeile = Zeile.replace(":S", Teile[0]);
                String[] TeileDatum = Teile[0].split(" ");
                Zeile = Zeile.replace(":D", TeileDatum[0]);
                if (TeileDatum.length > 1) {
                    Zeile = Zeile.replace(":Z", TeileDatum[1]);
                }
                Zeile = Zeile.replace(":H", "\"");
                Zeile = Zeile.replace(":h", "'");
                Zeile = Zeile.replace(":T", "\t");
                Zeile = Zeile.replace(":L", " ");
                Zeile = Zeile.replace(":N", System.getProperty("line.separator"));
                Zeile = Zeile.replace(":C", Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
                Liste2.add(Zeile);
            }
            ++i;
        }
        if (getExifAlleTags || getExifGueltigeTags || countChars) {
            Liste2 = FString.zerlegeArrayList(Liste2, System.getProperty("line.separator"));
        }
        if (this.EndSumme) {
            fProt.prot("Groesse aller Dateien: " + nfMegaByte.format(this.getSumme() / 1048576.0) + " MB, " + (Dateien.length + 1) + " Dateien");
        }
        return FString.arrayListToStringArray(Liste2);
    }

    public boolean checkInputKombinationen() {
        FProt fProt = FProt.instance();
        boolean ok = false;
        if (this.isAusgabeNurInDatei() && this.getAusgabedatei().length() == 0) {
            fProt.prot("Bei Ausgabe nur in Ausgabedatei muss auch AusgabeDatei angegeben werden -> keine Verarbeitung");
        } else if (this.getVerzeichnis().length() == 0 && this.getAusgabedatei().length() == 0) {
            fProt.prot("Es muss entweder ein Verzeichnis oder eine Ausgabedatei mit Dateinamen angegeben werden -> keine Verarbeitung");
        } else if (this.getFunktion().startsWith("K") && this.getKopierVerzeichnis().length() == 0) {
            fProt.prot("Bei Funktion Kopieren muss ein Zielverzeichnis angegeben werden -> keine Verarbeitung");
        } else if (this.getFunktion().startsWith("K") && this.isNurDirectories()) {
            fProt.prot("Funktion Kopieren und Auswahl nur Verzeichnisse passen nicht zusammen -> keine Verarbeitung");
        } else if (this.getFunktion().startsWith("R") && this.isNurDirectories()) {
            fProt.prot("Funktion Rename und Ausgabe nur Verzeichnisse passen nicht zusammen -> keine Verarbeitung");
        } else {
            ok = true;
        }
        if ((this.getFunktion().compareTo("D") == 0 || this.getFunktion().compareTo("E") == 0) && this.isNurDirectories() && this.getAnzahlDateienInVerzeichnis() != -1) {
            this.setAnzahlDateienInVerzeichnis(-1);
            fProt.prot("Bei Funktion Delete und Auswahl nur Verzeichnisse ist nur bei Anzahl Dateien = 0 sinnvoll");
            fProt.prot("-> Auswahl: Anzahl Dateien auf -1 gesetzt");
        }
        return ok;
    }

    public int getAnzahlDateienInVerzeichnis() {
        return this.AnzahlDateienInVerzeichnis;
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getAuswahlDatei() {
        return this.AuswahlDatei;
    }

    public String getAuswahlDatumZeitFormat() {
        return this.AuswahlDatumZeitFormat;
    }

    public String getAuswahlVerzeichnis() {
        return this.AuswahlVerzeichnis;
    }

    public String getCharsetAusgabeDatei() {
        return this.CharsetAusgabeDatei;
    }

    public String getDateiListe() {
        return this.DateiListe;
    }

    public String getDBName() {
        return this.DBName;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[][] getExterneListe() {
        return this.ExterneListe;
    }

    public String getFormat() {
        return this.Format;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public int getGroesse() {
        return this.Groesse;
    }

    public int getHardLinkCount() {
        return this.HardLinkCount;
    }

    public String getHeader() {
        Futi.instance();
        String[][] Formate = FString.convertStringArrayToTabelle(Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".Formate"), 3, true);
        String Zeile = "";
        if (this.getFormat().length() > 0) {
            Zeile = this.getFormat();
            String[][] stringArray = Formate;
            int n = Formate.length;
            int n2 = 0;
            while (n2 < n) {
                String[] element = stringArray[n2];
                if (element[0].compareToIgnoreCase(":XT") != 0 && element[0].compareToIgnoreCase(":XX") != 0 && element[0].compareToIgnoreCase(":T") != 0 && element[0].compareToIgnoreCase(":L") != 0 && element[0].compareToIgnoreCase(":N") != 0) {
                    Zeile = Zeile.replace(element[0], String.valueOf(element[2]) + element[1]);
                }
                ++n2;
            }
            Zeile = this.getFormat().compareTo(":XT") == 0 ? "Ausgabedatei\tRubrik\t#Typ\tName\tWert" : Zeile.replace(":XT", "Rubrik\t#Typ\tName\tWert");
            Zeile = this.getFormat().compareTo(":XX") == 0 ? "Ausgabedatei\tRubrik\t#Typ\tName\tWert" : Zeile.replace(":XX", "Rubrik\t#Typ\tName\tWert");
            Zeile = Zeile.replace("\\", "_");
            Zeile = Zeile.replace(":T", "\t");
            Zeile = Zeile.replace(":L", " ");
            Zeile = Zeile.replace(":N", System.getProperty("line.separator"));
            String[] Teile = Zeile.split("\t");
            int i = 0;
            while (i < Teile.length) {
                if (Teile[i].length() > 20) {
                    Teile[i] = "Feld_" + (i + 1);
                }
                ++i;
            }
            Zeile = FString.stringArrayToString(Teile, "\t");
        }
        return Zeile;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getKopierVerzeichnis() {
        return this.KopierVerzeichnis;
    }

    public int getMsgLvlAufrufVonAussen() {
        return this.MsgLvlAufrufVonAussen;
    }

    public String getMusterFormat() {
        return this.MusterFormat;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    private String getRelativesVerzeichnis(String verz) {
        String verzRel = "";
        if (verz.startsWith(this.getVerzeichnis())) {
            verzRel = verz.substring(this.getVerzeichnis().length());
        }
        if (verzRel.startsWith(System.getProperty("file.separator"))) {
            verzRel = verzRel.substring(1);
        }
        return verzRel;
    }

    private String getRelativesVerzeichnisOhneErsteEbene(String verz) {
        String verzRelOhneErsteEbene = this.getRelativesVerzeichnis(verz);
        int pos = verzRelOhneErsteEbene.indexOf(System.getProperty("file.separator"));
        verzRelOhneErsteEbene = pos >= 0 && verzRelOhneErsteEbene.length() > pos + 1 ? verzRelOhneErsteEbene.substring(pos + 1) : "";
        return verzRelOhneErsteEbene;
    }

    public int getRenameAnzahlDurchlaeufe() {
        return this.RenameAnzahlDurchlaeufe;
    }

    public int getRenameLaengeNummer() {
        return this.RenameLaengeNummer;
    }

    public String getRenameName() {
        return this.RenameName;
    }

    public int getRenameStart() {
        return this.RenameStart;
    }

    public String getRenameTrennzeichen() {
        return this.RenameTrennzeichen;
    }

    public String getStand() {
        return "1.8.2012";
    }

    public String getStichtagAlsDatum() {
        return this.StichtagAlsDatum;
    }

    public int getStichtagInTagen() {
        return this.StichtagInTagen;
    }

    public String getStichtagUhrzeitZumDatum() {
        return this.StichtagUhrzeitZumDatum;
    }

    public double getSumme() {
        return this.Summe;
    }

    public String getTabelle() {
        return this.Tabelle;
    }

    public int getTiefe() {
        return this.Tiefe;
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public boolean isAusgabeInTabelle() {
        return this.AusgabeInTabelle;
    }

    public boolean isAusgabeNurInDatei() {
        return this.AusgabeNurInDatei;
    }

    public boolean isAuswahlDatExclude() {
        return this.AuswahlDatExclude;
    }

    public boolean isAuswahlVerzExclude() {
        return this.AuswahlVerzExclude;
    }

    public boolean isBeimKopierenNichtUeberschrieben() {
        return this.BeimKopierenNichtUeberschrieben;
    }

    public boolean isEndSumme() {
        return this.EndSumme;
    }

    public boolean isHeaderBeiFormat() {
        return this.HeaderBeiFormat;
    }

    public boolean isLeereDateien() {
        return this.LeereDateien;
    }

    public boolean isNurBilder() {
        return this.NurBilder;
    }

    public boolean isNurDirectories() {
        return this.NurDirectories;
    }

    public boolean isNurTest() {
        return this.NurTest;
    }

    public boolean isNurVideos() {
        return this.NurVideos;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isStichtagVergleichAelter() {
        return this.StichtagVergleichAelter;
    }

    public void kopierenDateien(String[] Dateien) {
        FProt fProt = FProt.instance();
        boolean DateienKopierenMitVerzeichnis = false;
        String kopierVerzeichnis = this.getKopierVerzeichnis();
        FFile File2 = new FFile(this.getKopierVerzeichnis());
        if (File2.exists() && !File2.isDirectory()) {
            fProt.prot("Kopierverzeichnis vorhanden, aber keine Ausgabedatei -> keine Verarbeitung");
        } else {
            if (this.getFunktion().compareTo("KV") == 0) {
                DateienKopierenMitVerzeichnis = true;
            }
            int i = 0;
            while (i < Dateien.length) {
                String ZielDatei;
                String[] Teile = Dateien[i].split("\t");
                if (DateienKopierenMitVerzeichnis) {
                    String RelVerz = this.getRelativesVerzeichnis(Teile[3]);
                    if (RelVerz.length() > 0) {
                        RelVerz = String.valueOf(RelVerz) + System.getProperty("file.separator");
                    }
                    if (RelVerz.length() > 2 && this.getDateiListe().length() > 0) {
                        RelVerz = RelVerz.substring(3);
                    }
                    ZielDatei = String.valueOf(kopierVerzeichnis) + RelVerz + Teile[2];
                } else {
                    ZielDatei = String.valueOf(kopierVerzeichnis) + Teile[2];
                }
                String OriginalDatei = String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2];
                File2 = new FFile(OriginalDatei);
                FFile Test = new FFile(ZielDatei);
                if (this.isNurTest()) {
                    fProt.prot(String.valueOf(OriginalDatei) + " -> " + ZielDatei + " to copy");
                } else {
                    if (Test.exists() && this.isBeimKopierenNichtUeberschrieben()) {
                        String ZielDateiRenamed = Test.renameTo(ZielDatei);
                        fProt.prot(String.valueOf(ZielDatei) + " -> " + ZielDateiRenamed + ", da sonst Zieldatei ueberschrieben");
                    }
                    if (File2.lastModified() == Test.lastModified() && File2.length() == Test.length()) {
                        fProt.prot("-Copy: " + OriginalDatei + "->" + ZielDatei + " wg. Identitaet nicht notwendig", 1);
                    } else {
                        File2.copyFile(ZielDatei, true, this.isLeereDateien());
                        fProt.prot(String.valueOf(OriginalDatei) + " -> " + ZielDatei);
                    }
                }
                ++i;
            }
        }
    }

    public void renameDateien(String[] Dateien) {
        FProt fProt = FProt.instance();
        this.setRenameTrennzeichen(Futi.checkTrennzeichen(this.getRenameTrennzeichen(), true, "_"));
        int von = 0;
        String letzteGruppe = "";
        int i = 0;
        while (i < Dateien.length) {
            String[] Teile = Dateien[i].split("\t");
            Dateien[i] = String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2];
            ++i;
        }
        if (this.getRenameName().length() == 0) {
            int bis;
            i = 0;
            while (i < Dateien.length) {
                String Gruppe = FDatei.instance().zerlegeDateiname(Dateien[i], this.getRenameTrennzeichen()).getParent();
                if (Gruppe.compareTo(letzteGruppe) != 0 && i > 0) {
                    bis = i - 1;
                    fProt.prot("Rename Gruppe >" + letzteGruppe + "<, Zeilen von " + von + " bis " + bis, 1);
                    this.renameDateien(Dateien, letzteGruppe, von, bis);
                    von = i;
                }
                letzteGruppe = Gruppe;
                ++i;
            }
            bis = i - 1;
            fProt.prot("Rename Gruppe >" + letzteGruppe + "<, Zeilen von " + von + " bis " + bis, 1);
            this.renameDateien(Dateien, letzteGruppe, von, bis);
        } else {
            int bis = Dateien.length - 1;
            fProt.prot("Rename Gruppe >" + this.getRenameName() + "<, Zeilen von 0 bis " + bis, 1);
            this.renameDateien(Dateien, this.getRenameName(), 0, bis);
        }
    }

    public void renameDateien(String[] Dateien, String Gruppe, int von, int bis) {
        boolean AlleRenamesErfolgreich;
        FProt fProt = FProt.instance();
        this.setRenameTrennzeichen(Futi.checkTrennzeichen(this.getRenameTrennzeichen(), true, "_"));
        boolean RenameRichtungVorwaerts = true;
        int AnzahlDurchlaeufe = this.getRenameAnzahlDurchlaeufe();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits((int)Math.max((double)this.getRenameLaengeNummer(), Math.log10(bis - von + 1) + 1.0));
        nf.setGroupingUsed(false);
        do {
            fProt.prot("Durchlauf:" + AnzahlDurchlaeufe, 3);
            AlleRenamesErfolgreich = true;
            int i = von;
            while (i <= bis) {
                String NameNeu;
                int j = RenameRichtungVorwaerts ? i : bis - (i - von);
                FDatei.DateinamenTeile Teile = FDatei.instance().zerlegeDateiname(Dateien[j]);
                String NameAlt = String.valueOf(Teile.getName()) + "." + Teile.getExtend();
                if (NameAlt.compareToIgnoreCase(NameNeu = String.valueOf(Gruppe) + this.getRenameTrennzeichen() + nf.format(RenameRichtungVorwaerts ? j + 1 - von + this.getRenameStart() - 1 : j - von + this.getRenameStart()) + "." + Teile.getExtend()) == 0) {
                    fProt.prot(String.valueOf(NameAlt) + " muss nicht umbenannt werden", 1);
                } else {
                    FFile File2 = new FFile(Teile.getPfad(), NameAlt);
                    if (this.isNurTest()) {
                        fProt.prot(String.valueOf(Teile.getPfad()) + System.getProperty("file.separator") + NameAlt + "->" + NameNeu + " to rename", 0);
                    } else {
                        boolean RenameErfolgreich = File2.renameTo(new FFile(Teile.getPfad(), NameNeu));
                        if (!RenameErfolgreich) {
                            fProt.prot(String.valueOf(Teile.getPfad()) + System.getProperty("file.separator") + NameAlt + "->" + NameNeu + " nicht erfolgreich", 0);
                            AlleRenamesErfolgreich = false;
                        } else {
                            fProt.prot(String.valueOf(Teile.getPfad()) + System.getProperty("file.separator") + NameAlt + "->" + NameNeu + " erfolgreich", 0);
                            Dateien[j] = String.valueOf(Teile.getPfad()) + System.getProperty("file.separator") + NameNeu;
                            fProt.prot(Dateien[j], 9);
                        }
                    }
                }
                ++i;
            }
            boolean bl = RenameRichtungVorwaerts = !RenameRichtungVorwaerts;
        } while (!AlleRenamesErfolgreich && --AnzahlDurchlaeufe > 0 && !this.isNurTest());
    }

    public void run() {
        FProt fProt = FProt.instance();
        FString fString = FString.instance();
        Futi futi = Futi.instance();
        String[] Dateien = new String[]{};
        ArrayList<String> DateienArray = new ArrayList<String>();
        FFile fFile = null;
        if (this.checkInputKombinationen()) {
            int i;
            if (this.getDateiListe().length() > 0) {
                this.setVerzeichnis("");
                Dateien = new FFile(this.getDateiListe()).inhaltToStringArray();
                i = 0;
                while (i < Dateien.length) {
                    fFile = new FFile(Dateien[i]);
                    Dateien[i] = fFile.getStandardWerte();
                    if (Dateien[i].length() > 0) {
                        DateienArray.add(Dateien[i]);
                    }
                    ++i;
                }
                Dateien = FString.arrayListToStringArray(DateienArray);
            } else if (this.getVerzeichnis().length() > 0) {
                FFile datei = new FFile(this.getVerzeichnis());
                if (this.isAusgabeNurInDatei()) {
                    datei.setAuswahlAusgabeListe(this.getAusgabedatei());
                }
                datei.setAuswahlAusgabeNurInDatei(this.isAusgabeNurInDatei());
                datei.setAuswahlDatei(this.getAuswahlDatei());
                datei.setAuswahlDateiExclude(this.isAuswahlDatExclude());
                datei.setAuswahlDateiIgnoreCase(true);
                datei.setAuswahlGroesse(this.getGroesse());
                datei.setAuswahlHardLinkCount(this.getHardLinkCount());
                datei.setAuswahlDatumZeitArt(this.getAuswahlDatumZeitFormat().charAt(0));
                datei.setAuswahlAnzahlDateien(this.getAnzahlDateienInVerzeichnis());
                datei.setAuswahlTiefe(this.getTiefe());
                datei.setAuswahlNurBilder(this.isNurBilder());
                datei.setAuswahlNurVideos(this.isNurVideos());
                datei.setAuswahlStichtag(this.getStichtagInTagen());
                datei.setAuswahlStichtag(this.getStichtagAlsDatum());
                datei.setAuswahlStichtagUhrzeit(this.getStichtagUhrzeitZumDatum());
                datei.setAuswahlStichVergleichAelter(this.isStichtagVergleichAelter());
                datei.setAuswahlVerzeichnis(this.getAuswahlVerzeichnis());
                datei.setAuswahlVerzeichnisExclude(this.isAuswahlVerzExclude());
                datei.setAuswahlVerzeichnisIgnoreCase(true);
                datei.setAusgabeDateien(!this.isNurDirectories());
                datei.setAusgabeVerzeichnisse(this.isNurDirectories());
                datei.setPresortFiles(this.getFormat().contains(":POS"));
                if (this.getFunktion().compareTo("D") == 0 || this.getFunktion().compareTo("E") == 0) {
                    datei.setSortiereAufsteigend(false);
                } else if (this.getFunktion().compareTo("RD") == 0) {
                    datei.setSortiereNachDatum(true);
                }
                Dateien = datei.listjfi();
            }
            if (this.isAusgabeNurInDatei()) {
                fProt.prot("Ausgabe in Ausgabedatei >" + this.getAusgabedatei() + "< geschrieben");
            } else {
                if (Dateien.length == 0) {
                    fProt.prot("keine Dateien bzw. Verzeichnisse gefunden", this.getMsgLvlAufrufVonAussen());
                    if (this.getFunktion().compareTo("L") == 0 && this.getAusgabedatei().length() > 0) {
                        new FFile(this.getAusgabedatei()).StringArrayToInhalt(Dateien, this.getCharsetAusgabeDatei());
                    }
                } else if (this.getFunktion().compareTo("L") == 0) {
                    Dateien = this.aufbereitenListeVonDateien(Dateien);
                    if (this.getExterneListe() != null) {
                        this.setExterneListe(fString.convertStringArrayToTabelle(Dateien));
                    } else if (this.getAusgabedatei().length() > 0) {
                        new FFile(this.getAusgabedatei()).StringArrayToInhalt(Dateien, this.getCharsetAusgabeDatei());
                    } else {
                        fProt.prot(Dateien);
                    }
                    if (this.isAusgabeInTabelle() && this.getDBName().length() > 0 && this.getTabelle().length() > 0) {
                        Datei2Tabelle datei2Tabelle = new Datei2Tabelle();
                        datei2Tabelle.setDBName(this.getDBName());
                        datei2Tabelle.setTabelle(this.getTabelle());
                        datei2Tabelle.setExterneListe(fString.convertStringArrayToTabelle(Dateien));
                        datei2Tabelle.run();
                    }
                } else {
                    if (this.getFunktion().startsWith("R")) {
                        this.renameDateien(Dateien);
                    }
                    if (this.getFunktion().compareTo("V") == 0) {
                        this.verschiebenDateien(Dateien);
                    }
                    if (this.getFunktion().startsWith("K")) {
                        this.kopierenDateien(Dateien);
                    }
                    if (this.getFunktion().compareTo("D") == 0 || this.getFunktion().compareTo("E") == 0) {
                        i = 0;
                        while (i < Dateien.length) {
                            String[] Teile = Dateien[i].split("\t");
                            Teile[0] = this.isNurDirectories() ? Teile[3] : String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2];
                            fFile = new FFile(Teile[0]);
                            if (this.isNurTest()) {
                                fProt.prot(String.valueOf(Teile[0]) + " to " + (this.getFunktion().compareTo("D") == 0 ? "delete" : "erase"));
                            } else if (this.getFunktion().compareTo("D") == 0) {
                                fProt.prot(String.valueOf(Teile[0]) + ", Verschieben in Papierkorb " + futi.getPapierkorb() + " erfolgreich: " + fFile.delete(false));
                            } else {
                                fProt.prot(String.valueOf(Teile[0]) + ", Loeschen erfolgreich: " + fFile.delete());
                            }
                            ++i;
                        }
                    }
                }
                if (this.getFunktion().compareTo("L") != 0) {
                    this.setFunktion("L");
                }
            }
        }
    }

    public void setAnzahlDateienInVerzeichnis() {
        this.AnzahlDateienInVerzeichnis = FParam.getIntParameter("AnzahlDateienInVerzeichnis", this.ArgTab);
    }

    public void setAnzahlDateienInVerzeichnis(int anzahlDateienInVerzeichnis) {
        this.AnzahlDateienInVerzeichnis = FParam.checkIntParameter("AnzahlDateienInVerzeichnis", anzahlDateienInVerzeichnis, this.ArgTab);
    }

    public void setAnzahlDateienInVerzeichnis(String anzahlDateienInVerzeichnis) {
        this.AnzahlDateienInVerzeichnis = FParam.checkIntParameter("AnzahlDateienInVerzeichnis", anzahlDateienInVerzeichnis, this.ArgTab);
    }

    public void setAusdruck() {
        FParam.instance();
        this.AuswahlDatei = FParam.getStringParameter("Vergleichsausdruck", this.ArgTab);
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String datei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", datei, this.ArgTab);
    }

    public void setAusgabeInTabelle() {
        this.AusgabeInTabelle = FParam.getBooleanParameter("AusgabeInTabelle", this.ArgTab);
    }

    public void setAusgabeInTabelle(boolean ausgabeInTabelle) {
        this.AusgabeInTabelle = ausgabeInTabelle;
    }

    public void setAusgabeNurInDatei() {
        this.AusgabeNurInDatei = FParam.getBooleanParameter("AusgabeNurInDatei", this.ArgTab);
    }

    public void setAusgabeNurInDatei(boolean ausgabeNurInDatei) {
        this.AusgabeNurInDatei = ausgabeNurInDatei;
    }

    public void setAuswahlDatei() {
        this.AuswahlDatei = FParam.getStringParameter("AuswahlDatei", this.ArgTab);
    }

    public void setAuswahlDatei(String auswahlDatei) {
        FParam.instance();
        this.AuswahlDatei = FParam.checkStringParameter("AuswahlDatei", auswahlDatei, this.ArgTab);
    }

    public void setAuswahlDatExclude() {
        this.AuswahlDatExclude = FParam.getBooleanParameter("AuswahlDatExclude", this.ArgTab);
    }

    public void setAuswahlDatExclude(boolean vergleichExclude) {
        this.AuswahlDatExclude = vergleichExclude;
    }

    public void setAuswahlDatumZeitFormat() {
        this.AuswahlDatumZeitFormat = FParam.getStringParameter("AuswahlDatumZeitFormat", this.ArgTab);
    }

    public void setAuswahlDatumZeitFormat(String auswahlDatumZeitFormat) {
        FParam.instance();
        this.AuswahlDatumZeitFormat = FParam.checkStringParameter("AuswahlDatumZeitFormat", auswahlDatumZeitFormat, this.ArgTab);
    }

    public void setAuswahlVerzeichnis() {
        this.AuswahlVerzeichnis = FParam.getStringParameter("AuswahlVerzeichnis", this.ArgTab);
    }

    public void setAuswahlVerzeichnis(String auswahlVerzeichnis) {
        FParam.instance();
        this.AuswahlVerzeichnis = FParam.checkStringParameter("AuswahlVerzeichnis", auswahlVerzeichnis, this.ArgTab);
    }

    public void setAuswahlVerzExclude() {
        this.AuswahlVerzExclude = FParam.getBooleanParameter("AuswahlVerzExclude", this.ArgTab);
    }

    public void setAuswahlVerzExclude(boolean auswahlVerzeichnisExclude) {
        this.AuswahlVerzExclude = auswahlVerzeichnisExclude;
    }

    public void setBeimKopierenNichtUeberschrieben() {
        this.BeimKopierenNichtUeberschrieben = FParam.getBooleanParameter("BeimKopierenNichtUeberschrieben", this.ArgTab);
    }

    public void setBeimKopierenNichtUeberschrieben(boolean beimKopierenNichtUeberschrieben) {
        this.BeimKopierenNichtUeberschrieben = beimKopierenNichtUeberschrieben;
    }

    public void setCharsetAusgabeDatei() {
        this.CharsetAusgabeDatei = FParam.getStringParameter("CharsetAusgabeDatei", this.ArgTab);
    }

    public void setCharsetAusgabeDatei(String charsetAusgabeDatei) {
        this.CharsetAusgabeDatei = FParam.checkStringParameter("CharsetAusgabeDatei", charsetAusgabeDatei, this.ArgTab);
    }

    public void setDateiListe() {
        this.DateiListe = FParam.getStringParameter("DateiListe", this.ArgTab);
    }

    public void setDateiListe(String dateiListe) {
        FParam.instance();
        this.DateiListe = FParam.checkStringParameter("DateiListe", dateiListe, this.ArgTab);
    }

    public void setDBName() {
        this.DBName = FParam.getStringParameter("DBName", this.ArgTab);
    }

    public void setDBName(String dBName) {
        FParam.instance();
        this.DBName = FParam.checkStringParameter("DBName", dBName, this.ArgTab);
    }

    public void setEndSumme() {
        this.EndSumme = FParam.getBooleanParameter("EndSumme", this.ArgTab);
    }

    public void setEndSumme(boolean endSumme) {
        this.EndSumme = endSumme;
    }

    public void setExterneListe(String[][] externeListe) {
        this.ExterneListe = externeListe;
    }

    public void setFormat() {
        this.Format = FParam.getStringParameter("Format", this.ArgTab);
    }

    public void setFormat(String format) {
        FParam.instance();
        this.Format = FParam.checkStringParameter("Format", format, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setGroesse() {
        this.Groesse = FParam.getIntParameter("Groesse", this.ArgTab);
    }

    public void setGroesse(int groesse) {
        FParam.instance();
        this.Groesse = FParam.checkIntParameter("Groesse", groesse, this.ArgTab);
    }

    public void setGroesse(String groesse) {
        this.Groesse = FParam.checkIntParameter("Groesse", groesse, this.ArgTab);
    }

    public void setHardLinkCount() {
        this.HardLinkCount = FParam.getIntParameter("HardLinkCount", this.ArgTab);
    }

    public void setHardLinkCount(int hardLinkCount) {
        this.HardLinkCount = FParam.checkIntParameter("HardLinkCount", hardLinkCount, this.ArgTab);
    }

    public void setHardLinkCount(String hardLinkCount) {
        this.HardLinkCount = FParam.checkIntParameter("HardLinkCount", hardLinkCount, this.ArgTab);
    }

    public void setHeaderBeiFormat() {
        this.HeaderBeiFormat = FParam.getBooleanParameter("HeaderBeiFormat", this.ArgTab);
    }

    public void setHeaderBeiFormat(boolean headerBeiFormat) {
        this.HeaderBeiFormat = headerBeiFormat;
    }

    public void setKopierVerzeichnis() {
        this.KopierVerzeichnis = FParam.getStringParameter("KopierVerzeichnis", this.ArgTab);
    }

    public void setKopierVerzeichnis(String kopierVerzeichnis) {
        FParam.instance();
        this.KopierVerzeichnis = FParam.checkStringParameter("KopierVerzeichnis", kopierVerzeichnis, this.ArgTab);
    }

    public void setLeereDateien() {
        this.LeereDateien = FParam.getBooleanParameter("LeereDateien", this.ArgTab);
    }

    public void setLeereDateien(boolean leereDateien) {
        this.LeereDateien = leereDateien;
    }

    public void setMsgLvlAufrufVonAussen(int msgLvlAufrufVonAussen) {
        this.MsgLvlAufrufVonAussen = msgLvlAufrufVonAussen;
    }

    public void setMusterFormat() {
        this.MusterFormat = FParam.getStringParameter("MusterFormat", this.ArgTab);
    }

    public void setMusterFormat(String formatMuster) {
        FParam.instance();
        this.MusterFormat = FParam.checkStringParameter("MusterFormat", formatMuster, this.ArgTab);
    }

    public void setNurBilder() {
        this.NurBilder = FParam.getBooleanParameter("NurBilder", this.ArgTab);
    }

    public void setNurBilder(boolean nurBilder) {
        this.NurBilder = nurBilder;
    }

    public void setNurDirectories() {
        this.NurDirectories = FParam.getBooleanParameter("NurDirectories", this.ArgTab);
    }

    public void setNurDirectories(boolean nurDirectories) {
        this.NurDirectories = nurDirectories;
    }

    public void setNurTest() {
        this.NurTest = FParam.getBooleanParameter("NurTest", this.ArgTab);
    }

    public void setNurTest(boolean nurTest) {
        this.NurTest = nurTest;
    }

    public void setNurVideos() {
        this.NurVideos = FParam.getBooleanParameter("NurVideos", this.ArgTab);
    }

    public void setNurVideos(boolean nurVideos) {
        this.NurVideos = nurVideos;
    }

    public void setRenameAnzahlDurchlaeufe() {
        this.RenameAnzahlDurchlaeufe = FParam.getIntParameter("RenameAnzahlDurchlaeufe", this.ArgTab);
    }

    public void setRenameAnzahlDurchlaeufe(int renameAnzahlDurchlaeufe) {
        FParam.instance();
        this.RenameAnzahlDurchlaeufe = FParam.checkIntParameter("RenameAnzahlDurchlaeufe", renameAnzahlDurchlaeufe, this.ArgTab);
    }

    public void setRenameAnzahlDurchlaeufe(String renameAnzahlDurchlaeufe) {
        this.RenameAnzahlDurchlaeufe = FParam.checkIntParameter("RenameAnzahlDurchlaeufe", renameAnzahlDurchlaeufe, this.ArgTab);
    }

    public void setRenameLaengeNummer() {
        this.RenameLaengeNummer = FParam.getIntParameter("RenameLaengeNummer", this.ArgTab);
    }

    public void setRenameLaengeNummer(int renameLaengeNummer) {
        FParam.instance();
        this.RenameLaengeNummer = FParam.checkIntParameter("RenameLaengeNummer", renameLaengeNummer, this.ArgTab);
    }

    public void setRenameLaengeNummer(String renameLaengeNummer) {
        this.RenameLaengeNummer = FParam.checkIntParameter("RenameLaengeNummer", renameLaengeNummer, this.ArgTab);
    }

    public void setRenameName() {
        this.RenameName = FParam.getStringParameter("RenameName", this.ArgTab);
    }

    public void setRenameName(String renameName) {
        FParam.instance();
        this.RenameName = FParam.checkStringParameter("RenameName", renameName, this.ArgTab);
    }

    public void setRenameStart() {
        this.RenameStart = FParam.getIntParameter("RenameStart", this.ArgTab);
    }

    public void setRenameStart(int renameStart) {
        this.RenameStart = FParam.checkIntParameter("RenameStart", renameStart, this.ArgTab);
    }

    public void setRenameStart(String renameStart) {
        this.RenameStart = FParam.checkIntParameter("RenameStart", renameStart, this.ArgTab);
    }

    public void setRenameTrennzeichen() {
        this.RenameTrennzeichen = FParam.getStringParameter("RenameTrennzeichen", this.ArgTab);
    }

    public void setRenameTrennzeichen(String renameTrennzeichen) {
        FParam.instance();
        this.RenameTrennzeichen = FParam.checkStringParameter("RenameTrennzeichen", renameTrennzeichen, this.ArgTab);
    }

    public void setStichtagAlsDatum() {
        this.StichtagAlsDatum = FParam.getDateParameter("StichtagAlsDatum", this.ArgTab);
    }

    public void setStichtagAlsDatum(String stichtagAlsDatum) {
        FParam.instance();
        this.StichtagAlsDatum = FParam.checkDateParameter("StichtagAlsDatum", stichtagAlsDatum, this.ArgTab);
    }

    public void setStichtagAlsDatum(String stichtagAlsDatum, boolean umsetzen) {
        FParam.instance();
        this.StichtagAlsDatum = FParam.checkDateParameter("StichtagAlsDatum", stichtagAlsDatum, umsetzen, this.ArgTab);
    }

    public void setStichtagInTagen() {
        this.StichtagInTagen = FParam.getIntParameter("StichtagInTagen", this.ArgTab);
    }

    public void setStichtagInTagen(int stichtagInTagen) {
        FParam.instance();
        this.StichtagInTagen = FParam.checkIntParameter("StichtagInTagen", stichtagInTagen, this.ArgTab);
    }

    public void setStichtagInTagen(String stichtagInTagen) {
        this.StichtagInTagen = FParam.checkIntParameter("StichtagInTagen", stichtagInTagen, this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum() {
        this.StichtagUhrzeitZumDatum = FParam.getTimeParameter("StichtagUhrzeitZumDatum", this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum(String stichtagUhrzeitZumDatum) {
        FParam.instance();
        this.StichtagUhrzeitZumDatum = FParam.checkTimeParameter("StichtagUhrzeitZumDatum", stichtagUhrzeitZumDatum, this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum(String stichtagUhrzeitZumDatum, boolean umsetzen) {
        FParam.instance();
        this.StichtagUhrzeitZumDatum = FParam.checkTimeParameter("StichtagUhrzeitZumDatum", stichtagUhrzeitZumDatum, umsetzen, this.ArgTab);
    }

    public void setStichtagVergleichAelter() {
        this.StichtagVergleichAelter = FParam.getBooleanParameter("StichtagVergleichAelter", this.ArgTab);
    }

    public void setStichtagVergleichAelter(boolean stichVergleichAelter) {
        this.StichtagVergleichAelter = stichVergleichAelter;
    }

    private void setSumme(double summe) {
        this.Summe = summe;
    }

    public void setTabelle() {
        this.Tabelle = FParam.getStringParameter("Tabelle", this.ArgTab);
    }

    public void setTabelle(String tabelle) {
        FParam.instance();
        this.Tabelle = FParam.checkStringParameter("Tabelle", tabelle, this.ArgTab);
    }

    public void setTiefe() {
        this.Tiefe = FParam.getIntParameter("Tiefe", this.ArgTab);
    }

    public void setTiefe(int tiefe) {
        FParam.instance();
        this.Tiefe = FParam.checkIntParameter("Tiefe", tiefe, this.ArgTab);
    }

    public void setTiefe(String tiefe) {
        this.Tiefe = FParam.checkIntParameter("Tiefe", tiefe, this.ArgTab);
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setFunktion();
        this.setNurTest();
        this.setAusgabedatei();
        this.setCharsetAusgabeDatei();
        this.setDateiListe();
        this.setAusgabeNurInDatei();
        this.setAusgabeInTabelle();
        this.setDBName();
        this.setTabelle();
        this.setKopierVerzeichnis();
        this.setLeereDateien();
        this.setBeimKopierenNichtUeberschrieben();
        this.setNurDirectories();
        this.setNurBilder();
        this.setNurVideos();
        this.setEndSumme();
        this.setAuswahlDatei();
        this.setAuswahlDatExclude();
        this.setAuswahlVerzeichnis();
        this.setAuswahlVerzExclude();
        this.setStichtagAlsDatum();
        this.setStichtagUhrzeitZumDatum();
        this.setStichtagInTagen();
        this.setStichtagVergleichAelter();
        this.setGroesse();
        this.setAnzahlDateienInVerzeichnis();
        this.setHardLinkCount();
        this.setTiefe();
        this.setFormat();
        this.setMusterFormat();
        this.setAuswahlDatumZeitFormat();
        this.setHeaderBeiFormat();
        this.setRenameName();
        this.setRenameTrennzeichen();
        this.setRenameLaengeNummer();
        this.setRenameStart();
        this.setRenameAnzahlDurchlaeufe();
    }

    private void verschiebenDateien(String[] Dateien) {
        FProt fProt = FProt.instance();
        String kopierVerzeichnis = this.getKopierVerzeichnis();
        FFile File2 = new FFile(this.getKopierVerzeichnis());
        if (File2.exists() && !File2.isDirectory()) {
            fProt.prot("Kopierverzeichnis vorhanden, aber keine Ausgabedatei -> keine Verarbeitung");
        } else {
            int i = 0;
            while (i < Dateien.length) {
                String[] Teile = Dateien[i].split("\t");
                String ZielDatei = String.valueOf(kopierVerzeichnis) + Teile[2];
                String OriginalDatei = String.valueOf(Teile[3]) + System.getProperty("file.separator") + Teile[2];
                if (this.isNurTest()) {
                    fProt.prot(String.valueOf(OriginalDatei) + " -> " + ZielDatei + " to move");
                } else {
                    File2 = new FFile(OriginalDatei);
                    File2.renameTo(ZielDatei, this.isBeimKopierenNichtUeberschrieben() ? 100 : 1);
                    fProt.prot(String.valueOf(OriginalDatei) + " -> " + ZielDatei);
                }
                ++i;
            }
        }
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                         :" + this.getVerzeichnis());
        fProt.prot("Funktion                                   :" + this.getFunktion());
        fProt.prot("Testmodus                                  :" + this.isNurTest());
        fProt.prot("Ausgabedatei                               :" + this.getAusgabedatei());
        fProt.prot("Charset (Codepage) fuer Ausgabedatei       :" + this.getCharsetAusgabeDatei());
        fProt.prot("Liste von Dateien                          :" + this.getDateiListe());
        fProt.prot("Ausgabe nur in Datei (ohne Format)         :" + this.isAusgabeNurInDatei());
        fProt.prot("Ausgabe zus. in Tabelle                    :" + this.isAusgabeInTabelle());
        fProt.prot("DBName fuer zusaetzliche Ausgabe           :" + this.getDBName());
        fProt.prot("Tabelle fuer zusaetzliche Ausgabe          :" + this.getTabelle());
        fProt.prot("Zielverzeichnis (Funktion Kopieren)        :" + this.getKopierVerzeichnis());
        fProt.prot("bei Kopieren nur leere Dateien erstellen   :" + this.isLeereDateien());
        fProt.prot("bei Kopieren vorh. Dateien nicht ueberschr.:" + this.isBeimKopierenNichtUeberschrieben());
        fProt.prot("Ausgabe: nur Verz.                         :" + this.isNurDirectories());
        fProt.prot("Ausw.: nur Bilder                          :" + this.isNurBilder());
        fProt.prot("Ausw.: nur Videos                          :" + this.isNurVideos());
        fProt.prot("Groesse aller Dateien gesamt               :" + this.isEndSumme());
        fProt.prot("Ausw. Dat                                  :" + this.getAuswahlDatei());
        fProt.prot("Ausw. Dat. Excl.                           :" + this.isAuswahlDatExclude());
        fProt.prot("Ausw. Verz                                 :" + this.getAuswahlVerzeichnis());
        fProt.prot("Ausw. Verz. Excl.                          :" + this.isAuswahlVerzExclude());
        fProt.prot("Ausw. Dat.: Stichtag (Datum)               :" + this.getStichtagAlsDatum());
        fProt.prot("Ausw. Dat.: Uhrzeit zum Stichtag           :" + this.getStichtagUhrzeitZumDatum());
        fProt.prot("Ausw. Dat.: Stichtag in Tagen              :" + this.getStichtagInTagen());
        fProt.prot("aelter als Stichtag, sonst juenger         :" + this.isStichtagVergleichAelter());
        fProt.prot("Ausw. Dat.: Groesse                        :" + this.getGroesse());
        fProt.prot("Ausw. Verz.: Anz. Dateien                  :" + this.getAnzahlDateienInVerzeichnis());
        fProt.prot("Anzahl Hardlinks                           :" + this.getHardLinkCount());
        fProt.prot("Ausw. Verz.: Tiefe der Rekurs.             :" + this.getTiefe());
        fProt.prot("Format fuer Ausgabe                        :" + this.getFormat());
        fProt.prot("Musterformate                              :" + this.getMusterFormat());
        fProt.prot("Format fuer Datum                          :" + this.getAuswahlDatumZeitFormat());
        fProt.prot("Header ausgeben                            :" + this.isHeaderBeiFormat());
        fProt.prot("Rename: Suffix                             :" + this.getRenameName());
        fProt.prot("Rename: Trennz.                            :" + this.getRenameTrennzeichen());
        fProt.prot("Rename:  Len Nr                            :" + this.getRenameLaengeNummer());
        fProt.prot("Rename: Start bei Nr.                      :" + this.getRenameStart());
        fProt.prot("Rename: Anz. Durchlauefe                   :" + this.getRenameAnzahlDurchlaeufe());
    }
}

