/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;

public class FMDir {
    private final String[][] ArgTabDefault;
    private String Praefix;
    private String Verzeichnis;
    private int Von;
    private int Bis;
    private final boolean SetzenWerteInGUInachRun = true;
    private String[][] ArgTab;
    private final String Stand = "24.7.2011";

    public static String getMehrzahl(int anzahl) {
        String RC = "";
        if (anzahl > 1) {
            RC = "se";
        }
        return RC;
    }

    public static void main(String[] args) {
        FMDir fMDir = new FMDir(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fMDir.ArgTab, fMDir.ArgTabDefault, fMDir.getHilfeText())) {
            try {
                fMDir.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fMDir.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fMDir.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fMDir.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fMDir.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public FMDir() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FMDir(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getBis() {
        return this.Bis;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getPraefix() {
        return this.Praefix;
    }

    public String getStand() {
        return "24.7.2011";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public int getVon() {
        return this.Von;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public void run() {
        File dir;
        FProt fProt = FProt.instance();
        int created = 0;
        int failed = 0;
        if (this.getBis() < this.getVon()) {
            fProt.prot("Wert von Bis >" + this.getBis() + "< ist kleiner als Wert von Von >" + this.getVon() + "< -> Wert von Bis auf Wert von Von >" + this.getVon() + "< gesetzt");
            this.setBis(this.getVon());
        }
        if (this.getVerzeichnis().length() == 0) {
            this.setVerzeichnis(".");
        }
        if (!(dir = new File(this.getVerzeichnis())).isDirectory()) {
            fProt.prot(">" + this.getVerzeichnis() + "< ist kein Verzeichnis");
        } else {
            int len = Math.max(String.valueOf(this.getVon()).length(), String.valueOf(this.getBis()).length());
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(len);
            nf.setGroupingUsed(false);
            this.setVerzeichnis(FDatei.pruefenPfadname(this.getVerzeichnis(), true));
            int i = this.getVon();
            while (i <= this.getBis()) {
                dir = new File(String.valueOf(this.getVerzeichnis()) + this.getPraefix() + nf.format(i));
                if (dir.mkdirs()) {
                    fProt.prot(">" + dir + "< erfolgreich erstellt", 1);
                    ++created;
                } else {
                    fProt.prot(">" + dir + "< nicht erstellt", 1);
                    ++failed;
                }
                ++i;
            }
            fProt.prot(String.valueOf(created) + " Verzeichnis" + FMDir.getMehrzahl(created) + " erstellt, " + failed + " Verzeichnis" + FMDir.getMehrzahl(failed) + " nicht erstellt");
        }
    }

    public void setBis() {
        this.Bis = FParam.getIntParameter("Bis", this.ArgTab);
    }

    public void setBis(int bis) {
        FParam.instance();
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setBis(String bis) {
        this.Bis = FParam.checkIntParameter("Bis", bis, this.ArgTab);
    }

    public void setPraefix() {
        this.Praefix = FParam.getStringParameter("Praefix", this.ArgTab);
    }

    public void setPraefix(String praefix) {
        FParam.instance();
        this.Praefix = FParam.checkStringParameter("Praefix", praefix, this.ArgTab);
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setVon() {
        this.Von = FParam.getIntParameter("Von", this.ArgTab);
    }

    public void setVon(int von) {
        FParam.instance();
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setVon(String von) {
        this.Von = FParam.checkIntParameter("Von", von, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setPraefix();
        this.setVon();
        this.setBis();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Verzeichnis                 :" + this.getVerzeichnis());
        fProt.prot("Praefix f\u00fcr Verzeichnisnamen:" + this.getPraefix());
        fProt.prot("von                         :" + this.getVon());
        fProt.prot("bis                         :" + this.getBis());
    }
}

