/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;

public class FUti {
    private String Eingabedatei;
    private int SplitTextAnzahlDateienHoehe;
    private int MaxZeilen;
    private String RegularExpression;
    private String HomepageWork;
    private String TrennzeichenPreSufix;
    private boolean EingabeGleichAusgabedatei;
    private String Ausgabedatei;
    private String SplitTextTitel;
    private final boolean SetzenWerteInGUInachRun = true;
    private boolean TextAreaEingabe;
    private boolean KopierenAusgabeInClipboard;
    private String Funktion;
    private int SplitAnzahlPointSize;
    private int SplitTextGroesseBreite;
    private String CharsetEingabe;
    private String CharsetAusgabe;
    private String PreSufix;
    private boolean KopierenClipboardInEingabe;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private boolean TextAreaAusgabe;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "10.12.2009";

    public static String[] doExiftool(String[] zeile) {
        String dateiname = "";
        ArrayList<String> work = new ArrayList<String>();
        int i = 0;
        while (i < zeile.length) {
            if (!zeile[i].startsWith("  ")) {
                if (zeile[i].startsWith("========")) {
                    dateiname = zeile[i].substring(9);
                } else {
                    work.add(String.valueOf(dateiname) + "\t" + zeile[i]);
                }
            }
            ++i;
        }
        return FString.arrayListToStringArray(work);
    }

    public static void main(String[] args) {
        FUti fUti = new FUti(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(fUti.ArgTab, fUti.ArgTabDefault, fUti.getHilfeText())) {
            try {
                fUti.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + fUti.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                fUti.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + fUti.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + fUti.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public static String[] random(String[] zeile) {
        FProt fProt = FProt.instance();
        int j = 0;
        String[] Ausgabe = new String[zeile.length];
        ArrayList<String> Work = FString.stringArrayToArrayList(zeile);
        while (Work.size() > 0) {
            Double d = new Double((double)Work.size() * Math.random());
            int i = Math.min(d.intValue(), Work.size() - 1);
            fProt.prot("Zeile: " + i + " -> " + j, 1);
            Ausgabe[j++] = Work.get(i);
            Work.remove(i);
        }
        return Ausgabe;
    }

    public FUti() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public FUti(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private String[] doPreSufix(String[] zeilenEin, char art) {
        this.setTrennzeichenPreSufix(Futi.checkTrennzeichen(this.getTrennzeichenPreSufix()));
        int i = 0;
        while (i < zeilenEin.length) {
            if (art == 'P') {
                zeilenEin[i] = String.valueOf(this.getPreSufix()) + this.getTrennzeichenPreSufix() + zeilenEin[i];
            } else if (art == 'U') {
                int n = i;
                zeilenEin[n] = String.valueOf(zeilenEin[n]) + this.getTrennzeichenPreSufix() + this.getPreSufix();
            }
            ++i;
        }
        return zeilenEin;
    }

    private String[] doRegExFind(String[] zeile) {
        Pattern pattern = Pattern.compile(this.getRegularExpression());
        Matcher matcher = null;
        ArrayList<String> work = new ArrayList<String>();
        int i = 0;
        while (i < zeile.length) {
            matcher = pattern.matcher(zeile[i]);
            if (matcher.matches()) {
                work.add(zeile[i]);
            }
            ++i;
        }
        return FString.arrayListToStringArray(work);
    }

    private String[] doRegExGroup(String[] zeile) {
        ArrayList<String> work = new ArrayList<String>();
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.getRegularExpression());
        }
        catch (Exception e) {
            FProt.instance().prot(e.getMessage());
        }
        if (pattern != null) {
            Matcher matcher = null;
            int i = 0;
            while (i < zeile.length) {
                matcher = pattern.matcher(zeile[i]);
                while (matcher.find()) {
                    if (matcher.groupCount() <= 1) continue;
                    work.add(zeile[i].substring(matcher.end(1), matcher.start(2)));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < zeile.length) {
                work.add(zeile[i]);
                ++i;
            }
        }
        return FString.arrayListToStringArray(work);
    }

    private String[] doSplit(String[] zeile) {
        FProt fProt = FProt.instance();
        int anzahl = -1;
        int groesse = 0;
        int t = 1;
        boolean add = false;
        ArrayList<String> Work = new ArrayList<String>();
        String Teil = "";
        String ersteZeile = zeile[0];
        String letzteZeile = zeile[0];
        if (this.getSplitTextAnzahlDateienHoehe() > 0) {
            this.setSplitTextAnzahlDateienHoehe(Math.min(this.getSplitTextAnzahlDateienHoehe(), zeile.length));
            this.setSplitAnzahlPointSize(zeile.length / this.getSplitTextAnzahlDateienHoehe());
            while (zeile.length / this.getSplitAnzahlPointSize() >= this.getSplitTextAnzahlDateienHoehe() && zeile.length % this.getSplitAnzahlPointSize() != 0) {
                this.setSplitAnzahlPointSize(this.getSplitAnzahlPointSize() + 1);
            }
            while (zeile.length / this.getSplitAnzahlPointSize() <= this.getSplitTextAnzahlDateienHoehe() && zeile.length % this.getSplitAnzahlPointSize() != 0) {
                this.setSplitAnzahlPointSize(this.getSplitAnzahlPointSize() - 1);
            }
        }
        int i = 0;
        while (i < zeile.length) {
            groesse += zeile[i].length();
            if (this.getSplitAnzahlPointSize() > 0 && ++anzahl >= this.getSplitAnzahlPointSize()) {
                add = true;
            }
            if (this.getSplitTextGroesseBreite() > 0 && groesse > this.getSplitTextGroesseBreite()) {
                add = true;
            }
            if (add) {
                if (i > 0) {
                    letzteZeile = zeile[i - 1];
                }
                Teil = String.valueOf(this.getSplitTextTitel()) + " " + t + ": " + ersteZeile.substring(0, Math.min(40, ersteZeile.length())) + " ::: " + letzteZeile.substring(0, Math.min(40, letzteZeile.length())) + Teil;
                Work.add(Teil);
                fProt.prot(Teil, 1);
                anzahl = 0;
                groesse = 0;
                Teil = "";
                ++t;
                ersteZeile = zeile[i];
                add = false;
            }
            Teil = String.valueOf(Teil) + System.getProperty("line.separator") + zeile[i];
            ++i;
        }
        if (Teil.length() > 0) {
            letzteZeile = zeile[zeile.length - 1];
            Teil = String.valueOf(this.getSplitTextTitel()) + " " + t + ": " + ersteZeile.substring(0, Math.min(40, ersteZeile.length())) + " ::: " + letzteZeile.substring(0, Math.min(40, letzteZeile.length())) + Teil;
            Work.add(Teil);
            fProt.prot(Teil, 1);
        }
        return FString.arrayListToStringArray(Work);
    }

    private String[] doSrt2GPX(String[] zeilen) {
        String breite = "";
        String laenge = "";
        String zeit = "";
        String speed = "";
        String name = FDatei.instance().zerlegeDateiname(this.getEingabedatei()).getName();
        ArrayList<String> work = new ArrayList<String>();
        work.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        work.add("<gpx version=\"1.1\" creator=\"de.nss.jfi\" xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        work.add("  <trk>");
        work.add("    <name>" + (name.length() > 0 ? name : new FGregorianCalendar(System.currentTimeMillis()).toGermanFormat()) + "</name>");
        work.add("    <extensions><mytracks:timezone offset=\"60\"></mytracks:timezone></extensions>");
        work.add("    <trkseg>");
        String[] stringArray = zeilen;
        int n = zeilen.length;
        int n2 = 0;
        while (n2 < n) {
            String zeile = stringArray[n2];
            if (zeile.length() > 25 && zeile.charAt(2) == '.' && zeile.charAt(5) == '.' && zeile.charAt(13) == ':' && zeile.charAt(16) == ':' && zeile.charAt(19) == ',') {
                zeit = String.valueOf(zeile.substring(6, 10)) + "-" + zeile.substring(0, 2) + "-" + zeile.substring(3, 5) + "T" + zeile.substring(11, 19) + "Z";
                speed = zeile.substring(20).trim();
            }
            if (zeile.length() > 21 && zeile.charAt(0) == 'N' && zeile.charAt(1) == ' ' && zeile.charAt(4) == '.') {
                String[] teil = zeile.split(" ");
                breite = teil[1].substring(0, 8);
                laenge = String.valueOf(teil[2].charAt(0) == 'W' ? "-" : "") + teil[3].substring(0, 8);
            }
            if (zeile.compareTo("made by Sygic") == 0) {
                work.add("      <trkpt lat=\"" + breite + "\" lon=\"" + laenge + "\">");
                work.add("        <time>" + zeit + "</time>");
                work.add("        <desc>Lat.=" + breite + ", Long.=" + laenge + ", Speed=" + speed + "</desc>");
                work.add("      </trkpt>");
                breite = "";
                laenge = "";
                zeit = "";
                speed = "";
            }
            ++n2;
        }
        work.add("    </trkseg>");
        work.add("  </trk>");
        work.add("</gpx>");
        return FString.arrayListToStringArray(work);
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharsetAusgabe() {
        return this.CharsetAusgabe;
    }

    public String getCharsetEingabe() {
        return this.CharsetEingabe;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getHomepageWork() {
        return this.HomepageWork;
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public int getMaxZeilen() {
        return this.MaxZeilen;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getPreSufix() {
        return this.PreSufix;
    }

    public String getRegularExpression() {
        return this.RegularExpression;
    }

    public int getSplitAnzahlPointSize() {
        return this.SplitAnzahlPointSize;
    }

    public int getSplitTextAnzahlDateienHoehe() {
        return this.SplitTextAnzahlDateienHoehe;
    }

    public int getSplitTextGroesseBreite() {
        return this.SplitTextGroesseBreite;
    }

    public String getSplitTextTitel() {
        return this.SplitTextTitel;
    }

    public String getStand() {
        return "10.12.2009";
    }

    public String getTrennzeichenPreSufix() {
        return this.TrennzeichenPreSufix;
    }

    public boolean isEingabeGleichAusgabedatei() {
        return this.EingabeGleichAusgabedatei;
    }

    public boolean isKopierenAusgabeInClipboard() {
        return this.KopierenAusgabeInClipboard;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    public void run() {
        FProt fProt = FProt.instance();
        if (this.getFunktion().compareToIgnoreCase("MTK") == 0 || this.getFunktion().compareToIgnoreCase("MTS") == 0) {
            Futi.copyMyTracks(this.getHomepageWork(), this.getFunktion().compareToIgnoreCase("MTS") == 0);
        } else {
            File test;
            char funktion = this.getFunktion().toUpperCase().charAt(0);
            boolean dateiStatusOK = false;
            if (funktion == 'H' || funktion == 'M') {
                test = new File(this.getEingabedatei());
                if (!test.exists()) {
                    fProt.prot(">" + this.getEingabedatei() + "< " + (funktion == 'H' ? "Homepageverzeichnis" : "Mediathek") + " nicht vorhanden");
                } else if (!test.isDirectory()) {
                    fProt.prot(">" + this.getEingabedatei() + "< ist kein Verzeichnis");
                } else {
                    dateiStatusOK = true;
                }
            } else {
                test = new File(this.getEingabedatei());
                if (!(this.getEingabedatei().isEmpty() || test.exists() && !test.isDirectory())) {
                    fProt.prot(">" + this.getEingabedatei() + "< Eingabedatei ist nicht vorhanden oder ein Verzeichnis");
                } else {
                    dateiStatusOK = true;
                }
            }
            if (dateiStatusOK) {
                if (funktion == 'T') {
                    FFile bild = new FFile(this.getEingabedatei());
                    if (bild.isPicture()) {
                        int pointSize = FMath.checkRange(this.getSplitAnzahlPointSize(), 15, 100);
                        float faktorStroke = 0.133f;
                        String[] parmCreateText = new String[]{"-define", "jpeg:size=" + this.getSplitTextGroesseBreite() + "x" + this.getSplitTextAnzahlDateienHoehe(), this.getEingabedatei(), "-resize", this.getSplitTextGroesseBreite() + "x" + this.getSplitTextAnzahlDateienHoehe() + ">", "-gravity", "center", "-font", Futi.getBenutzerWert("ExiftoolTAHOMA"), "-pointsize", "" + pointSize, "-stroke", "#000C", "-strokewidth", "" + (int)((float)pointSize * 0.133f), "-annotate", "+0+" + (int)((float)pointSize * 0.133f * 2.0f), this.getSplitTextTitel(), "-stroke", "none", "-fill", "white", "-annotate", "+0+" + (int)((float)pointSize * 0.133f * 2.0f), this.getSplitTextTitel(), "-background", "grey", "-gravity", "center", "-extent", this.getSplitTextGroesseBreite() + "x" + this.getSplitTextAnzahlDateienHoehe(), this.getAusgabedatei()};
                        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmCreateText, 0);
                    } else {
                        fProt.prot("Keine Verarbeitung, da Eingabedatei >" + this.getEingabedatei() + "< kein Bild");
                    }
                } else if (funktion == 'H') {
                    Futi.makeVideoHomepageOverview(this.getEingabedatei(), this.getHomepageWork(), FMath.checkRange(this.getMaxZeilen(), 8, 20), false);
                    Futi.makeVideoHomepageOverview(String.valueOf(this.getEingabedatei()) + System.getProperty("file.separator") + Futi.getHomepageAuswahlName(), this.getHomepageWork(), FMath.checkRange(this.getMaxZeilen(), 8, 20), false);
                    Futi.checkVideoHomepageWork(this.getEingabedatei(), this.getHomepageWork());
                    Futi.checkVideoHomepageAuswahl(this.getEingabedatei());
                } else if (funktion == 'M') {
                    FDatei.iOSMediathekCopy(this.getEingabedatei(), this.getHomepageWork(), true);
                } else if (funktion == 'C') {
                    int save = FDatei.getMsgLevelMedien();
                    FDatei.setMsgLevelMedien(2);
                    FDatei.prepareDownloadedFilm(this.getEingabedatei());
                    FDatei.setMsgLevelMedien(save);
                } else {
                    String[] Zeile = Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), false, this.getCharsetEingabe());
                    if (funktion == 'R') {
                        Zeile = FUti.random(Zeile);
                    } else if (funktion == 'S') {
                        Zeile = this.doSplit(Zeile);
                    } else if (funktion == 'D') {
                        Zeile = FString.deleteDoppelte(Zeile, false);
                    } else if (funktion == 'I') {
                        Zeile = FString.deleteDoppelte(Zeile, true);
                    } else if (funktion == 'E') {
                        Zeile = FUti.doExiftool(Zeile);
                    } else if (funktion == 'F') {
                        Zeile = this.doRegExFind(Zeile);
                    } else if (funktion == 'G') {
                        Zeile = this.doRegExGroup(Zeile);
                    } else if (funktion == 'X') {
                        Zeile = this.doSrt2GPX(Zeile);
                    } else if (funktion == 'P' || funktion == 'U') {
                        Zeile = this.doPreSufix(Zeile, funktion);
                    } else if (funktion == 'S' && !this.isTextAreaAusgabe() && Zeile.length > 1) {
                        NumberFormat nf = NumberFormat.getInstance();
                        nf.setMinimumIntegerDigits(String.valueOf(Zeile.length).length());
                        nf.setGroupingUsed(false);
                        int i = 0;
                        while (i < Zeile.length) {
                            FDatei.DateinamenTeile aus = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
                            String Dateiname = String.valueOf(aus.getPfad()) + System.getProperty("file.separator") + aus.getName() + "_" + nf.format(i + 1) + "." + aus.getExtend();
                            new FFile(Dateiname).StringToInhalt(Zeile[i]);
                            fProt.prot("Teildatei >" + Dateiname + "< erstellt");
                            ++i;
                        }
                    }
                    if (this.isEingabeGleichAusgabedatei()) {
                        this.setAusgabedatei(this.getEingabedatei());
                    }
                    Futi.setAusgabe(Zeile, this.getAusgabedatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), this.isKopierenAusgabeInClipboard(), this.getCharsetAusgabe(), this.getMaxZeilen());
                }
            }
        }
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setCharsetAusgabe() {
        this.CharsetAusgabe = FParam.getStringParameter("CharsetAusgabe", this.ArgTab);
    }

    public void setCharsetAusgabe(String charsetAusgabe) {
        this.CharsetAusgabe = FParam.checkStringParameter("CharsetAusgabe", charsetAusgabe, this.ArgTab);
    }

    public void setCharsetEingabe() {
        this.CharsetEingabe = FParam.getStringParameter("CharsetEingabe", this.ArgTab);
    }

    public void setCharsetEingabe(String charsetEingabe) {
        this.CharsetEingabe = FParam.checkStringParameter("CharsetEingabe", charsetEingabe, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setEingabeGleichAusgabedatei() {
        this.EingabeGleichAusgabedatei = FParam.getBooleanParameter("EingabeGleichAusgabedatei", this.ArgTab);
    }

    public void setEingabeGleichAusgabedatei(boolean eingabedateiGleichAusgabedatei) {
        this.EingabeGleichAusgabedatei = eingabedateiGleichAusgabedatei;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setHomepageWork() {
        this.HomepageWork = FParam.getStringParameter("HomepageWork", this.ArgTab);
    }

    public void setHomepageWork(String homepageWork) {
        this.HomepageWork = FParam.checkStringParameter("HomepageWork", homepageWork, this.ArgTab);
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKopierenAusgabeInClipboard() {
        this.KopierenAusgabeInClipboard = FParam.getBooleanParameter("KopierenAusgabeInClipboard", this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard(boolean kopierenAusgabeInClipboard) {
        this.KopierenAusgabeInClipboard = kopierenAusgabeInClipboard;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setMaxZeilen() {
        this.MaxZeilen = FParam.getIntParameter("MaxZeilen", this.ArgTab);
    }

    public void setMaxZeilen(int maxZeilen) {
        this.MaxZeilen = FParam.checkIntParameter("MaxZeilen", maxZeilen, this.ArgTab);
    }

    public void setMaxZeilen(String maxZeilen) {
        this.MaxZeilen = FParam.checkIntParameter("MaxZeilen", maxZeilen, this.ArgTab);
    }

    public void setPreSufix() {
        this.PreSufix = FParam.getStringParameter("PreSufix", this.ArgTab);
    }

    public void setPreSufix(String preSufix) {
        this.PreSufix = FParam.checkStringParameter("PreSufix", preSufix, this.ArgTab);
    }

    public void setRegularExpression() {
        this.RegularExpression = FParam.getStringParameter("RegularExpression", this.ArgTab);
    }

    public void setRegularExpression(String regularExpression) {
        FParam.instance();
        this.RegularExpression = FParam.checkStringParameter("RegularExpression", regularExpression, this.ArgTab);
    }

    public void setSplitAnzahlPointSize() {
        this.SplitAnzahlPointSize = FParam.getIntParameter("SplitAnzahlPointSize", this.ArgTab);
    }

    public void setSplitAnzahlPointSize(int SplitAnzahlPointSize) {
        FParam.instance();
        this.SplitAnzahlPointSize = FParam.checkIntParameter("SplitAnzahlPointSize", SplitAnzahlPointSize, this.ArgTab);
    }

    public void setSplitAnzahlPointSize(String splitAnzahlPointSize) {
        this.SplitAnzahlPointSize = FParam.checkIntParameter("SplitAnzahlPointSize", splitAnzahlPointSize, this.ArgTab);
    }

    public void setSplitTextAnzahlDateienHoehe() {
        this.SplitTextAnzahlDateienHoehe = FParam.getIntParameter("SplitTextAnzahlDateienHoehe", this.ArgTab);
    }

    public void setSplitTextAnzahlDateienHoehe(int splitAnzahlDateien) {
        FParam.instance();
        this.SplitTextAnzahlDateienHoehe = FParam.checkIntParameter("SplitTextAnzahlDateienHoehe", splitAnzahlDateien, this.ArgTab);
    }

    public void setSplitTextAnzahlDateienHoehe(String splitTextAnzahlDateienHoehe) {
        this.SplitTextAnzahlDateienHoehe = FParam.checkIntParameter("SplitTextAnzahlDateienHoehe", splitTextAnzahlDateienHoehe, this.ArgTab);
    }

    public void setSplitTextGroesseBreite() {
        this.SplitTextGroesseBreite = FParam.getIntParameter("SplitTextGroesseBreite", this.ArgTab);
    }

    public void setSplitTextGroesseBreite(int splitGroesse) {
        FParam.instance();
        this.SplitTextGroesseBreite = FParam.checkIntParameter("SplitTextGroesseBreite", splitGroesse, this.ArgTab);
    }

    public void setSplitTextGroesseBreite(String splitTextGroesseBreite) {
        this.SplitTextGroesseBreite = FParam.checkIntParameter("SplitTextGroesseBreite", splitTextGroesseBreite, this.ArgTab);
    }

    public void setSplitTextTitel() {
        this.SplitTextTitel = FParam.getStringParameter("SplitTextTitel", this.ArgTab);
    }

    public void setSplitTextTitel(String splitTitel) {
        FParam.instance();
        this.SplitTextTitel = FParam.checkStringParameter("SplitTextTitel", splitTitel, this.ArgTab);
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setTrennzeichenPreSufix() {
        this.TrennzeichenPreSufix = FParam.getStringParameter("TrennzeichenPreSufix", this.ArgTab);
    }

    public void setTrennzeichenPreSufix(String trennzeichenPreSufix) {
        this.TrennzeichenPreSufix = FParam.checkStringParameter("TrennzeichenPreSufix", trennzeichenPreSufix, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setEingabedatei();
        this.setCharsetEingabe();
        this.setAusgabedatei();
        this.setHomepageWork();
        this.setCharsetAusgabe();
        this.setEingabeGleichAusgabedatei();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
        this.setKopierenAusgabeInClipboard();
        this.setFunktion();
        this.setRegularExpression();
        this.setPreSufix();
        this.setTrennzeichenPreSufix();
        this.setMaxZeilen();
        this.setSplitAnzahlPointSize();
        this.setSplitTextTitel();
        this.setSplitTextAnzahlDateienHoehe();
        this.setSplitTextGroesseBreite();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei (oder Verz bei Fkt. H o. M)                :" + this.getEingabedatei());
        fProt.prot("Charset (Codepage) fuer Eingabe                         :" + this.getCharsetEingabe());
        fProt.prot("Ausgabedatei                                            :" + this.getAusgabedatei());
        fProt.prot("HomepageWorkVerz bei Fkt. H, Ziel bei Fkt. M, MTK, MKS  :" + this.getHomepageWork());
        fProt.prot("Charset (Codepage) fuer Ausgabe                         :" + this.getCharsetAusgabe());
        fProt.prot("Eingabedatei ueberschreiben                             :" + this.isEingabeGleichAusgabedatei());
        fProt.prot("TextArea statt Eingabedatei verwenden                   :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden                   :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Eingabe in TextArea kopieren        :" + this.isKopierenClipboardInEingabe());
        fProt.prot("TextArea fuer Ausgabe in Zwischenablage kopieren        :" + this.isKopierenAusgabeInClipboard());
        fProt.prot("Funktion                                                :" + this.getFunktion());
        fProt.prot("RegEx                                                   :" + this.getRegularExpression());
        fProt.prot("Prefix bzw. Suffix                                      :" + this.getPreSufix());
        fProt.prot("Trennzeichen fuer Prefix bzw. Suffix (Separator)        :" + this.getTrennzeichenPreSufix());
        fProt.prot("Maximale Anzahl der Ausgabezeilen                       :" + this.getMaxZeilen());
        fProt.prot("Split: Anzahl Saetze pro Teildatei, Text: PointSize     :" + this.getSplitAnzahlPointSize());
        fProt.prot("Split: Titel der Teildateien, Text: Text                :" + this.getSplitTextTitel());
        fProt.prot("Split: Anzahl der Teildateien, Text: Hoehe des Bildes   :" + this.getSplitTextAnzahlDateienHoehe());
        fProt.prot("Split: max. Groesse Teildateien, Text: Breite des Bildes:" + this.getSplitTextGroesseBreite());
    }
}

