/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Datei2Tabelle;
import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import net.java.frej.fuzzy.Fuzzy;
import org.geonames.utils.Distance;

public class GPS {
    private String Funktion;
    private String Eingabedatei;
    private String KommentarWaypoints;
    private String Eingabeverzeichnis;
    private String CharsetEingabe;
    private String CharsetAusgabe;
    private String SiestaVon;
    private String SiestaBis;
    private String MokkaVon;
    private String DBNameGeonames;
    private String DBNameReisen;
    private boolean freistehendePunktePruefen = true;
    private String DBNameFotos;
    private String MokkaBis;
    private String Ausgabedatei;
    private String GeoDataArt;
    private String ZusaetzlicheAusgabedatei;
    private String OrtAnordnung;
    private boolean NoTimeStamp;
    private boolean GeonameOffline;
    private boolean NoCVS;
    private int KorrekturZeitPOI;
    private int KorrekturZeitTrack;
    private int BreakDauer;
    private int ReduceFaktor;
    private int AbstandPunkte;
    private int AbstandPunkteMeter;
    private int RundenPOIs;
    private int RundenPOIsMinuten;
    private int RundenEtappe;
    private int RundenEtappeMinuten;
    private int Waypoints;
    private int GeoDataAbSpalteAbEins;
    private int GeoDataAbSpalte;
    private int AbstandStadtGross;
    private int AbstandStadtMittel;
    private int AbstandStadtKlein;
    private int EinwohnerStadtGross10T;
    private int EinwohnerStadtMittel1T;
    private int EinwohnerStadtKlein100;
    private int EinwohnerStadtKlein;
    private int EinwohnerStadtGross;
    private int EinwohnerStadtMittel;
    private boolean ReduceTrackpoints;
    private boolean NoFreeStanding;
    private boolean IgnoreGeoData;
    private boolean AllePause;
    private boolean NichtUebernommeneProtokollieren;
    private int POIs;
    private boolean CVSVerzeichnisNichtLeer;
    private boolean NoNullSpeed;
    private boolean OnlyTimeStamp;
    private boolean SortTimeStamp;
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = true;
    private String[][] ArgTab;
    private final String Stand = "19.12.2018";

    static String byte2Hex(byte[] b, int von, int az, boolean mitBlanks) {
        byte[] bytes = new byte[1];
        String aus = "";
        String sep = mitBlanks ? " " : "";
        int i = 0;
        while (i < az) {
            bytes[0] = b[von + i];
            aus = String.valueOf(aus) + DatatypeConverter.printHexBinary((byte[])bytes) + sep;
            ++i;
        }
        return aus;
    }

    private static String changeTimeStampCSV(String in, String timeStamp) {
        String[] teile = in.split("\t");
        String aus = in;
        if (teile.length > 2) {
            aus = String.valueOf(teile[0]) + "\t" + teile[1] + "\t" + teile[2] + "\t" + timeStamp + "\t" + (teile.length > 4 ? teile[4] : "");
        }
        return aus;
    }

    private static String formatiereOrte(String[] orte) {
        int az = orte.length;
        String weg = "";
        if (az > 0) {
            if (az == 1) {
                weg = "nach " + orte[0];
            } else if (az == 2) {
                weg = "\u00fcber " + orte[0] + " nach " + orte[1];
            } else if (az == 3) {
                weg = "\u00fcber " + orte[0] + " und " + orte[1] + " nach " + orte[2];
            } else {
                int i = 0;
                while (i < az) {
                    if (i == 0) {
                        weg = "\u00fcber " + orte[i];
                    } else if (i < az - 2) {
                        weg = String.valueOf(weg) + ", " + orte[i];
                    } else if (i == az - 2) {
                        weg = String.valueOf(weg) + " und " + orte[i];
                    } else if (i == az - 1) {
                        weg = String.valueOf(weg) + " nach " + orte[i];
                    }
                    ++i;
                }
            }
        }
        return weg;
    }

    private static String formatiereOrtundOrtsteil(String ort, String ortsteilIn, char art) {
        String ortAus = "";
        String ortsteil = ort.compareToIgnoreCase(ortsteilIn) == 0 ? "" : ortsteilIn;
        switch (art) {
            default: {
                ortAus = ort.length() > 0 ? ort : ortsteil;
                break;
            }
            case 'M': {
                ortAus = String.valueOf(ort) + (ortsteil.length() > 0 ? "-" + ortsteil : "");
                break;
            }
            case 'T': {
                ortAus = ortsteil.length() > 0 ? ortsteil : ort;
                break;
            }
            case 'U': {
                ortAus = ortsteil.length() > 0 ? String.valueOf(ortsteil) + " (" + ort + ")" : ort;
            }
        }
        return ortAus;
    }

    private static String getErstenOrt(String ort1, String ort2, String ort3, String ort4, String ort5, String ort6) {
        String ortAus = "";
        if (ort1 != null && ort1.length() > 0) {
            ortAus = ort1;
        } else if (ort2 != null && ort2.length() > 0) {
            ortAus = ort2;
        } else if (ort3 != null && ort3.length() > 0) {
            ortAus = ort3;
        } else if (ort4 != null && ort4.length() > 0) {
            ortAus = ort4;
        } else if (ort5 != null && ort5.length() > 0) {
            ortAus = ort5;
        } else if (ort6 != null && ort6.length() > 0) {
            ortAus = ort6;
        }
        return ortAus;
    }

    private static String getWetterDatenFields(ResultSet rs) {
        String wetterDaten = "";
        String wert = "";
        try {
            wert = rs.getString("Sonne");
            if (wert.length() > 0) {
                wetterDaten = String.valueOf(wetterDaten) + "Sonne: " + wert + " (%)";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wert = rs.getString("Regen");
            if (wert.length() > 0) {
                wetterDaten = String.valueOf(wetterDaten) + ", Regen: " + wert + " (%)";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wert = rs.getString("Temperatur");
            if (wert.length() > 0) {
                wetterDaten = String.valueOf(wetterDaten) + ", Hoechsttemperatur: " + wert;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wert = rs.getString("Tiefsttemperatur");
            if (wert.length() > 0) {
                wetterDaten = String.valueOf(wetterDaten) + ", Tiefsttemperatur: " + wert;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wetterDaten.length() > 0) {
            wetterDaten = ", " + wetterDaten;
        }
        return wetterDaten;
    }

    public static void main(String[] args) {
        GPS gPS = new GPS(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(gPS.ArgTab, gPS.ArgTabDefault, gPS.getHilfeText())) {
            try {
                gPS.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + gPS.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                gPS.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + gPS.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + gPS.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public GPS() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public GPS(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void addGeodata2WayPoints(ArrayList<String> wayPoints) {
        FProt fProt = FProt.instance();
        String[] geoData = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        double lat = 0.0;
        double lon = 0.0;
        Statement DBStatement = null;
        FGregorianCalendar jetzt = new FGregorianCalendar();
        boolean POIFound = false;
        if (this.getDBNameReisen().length() > 1) {
            DBStatement = FDB.createDBStatement(this.getDBNameReisen());
        }
        int i = 0;
        while (i < wayPoints.size()) {
            String[] teile = wayPoints.get(i).split("\t");
            if (teile[5].indexOf("Start") < 0 && teile[5].indexOf("Ende") < 0) {
                lat = Double.parseDouble(teile[0]);
                lon = Double.parseDouble(teile[1]);
                POIFound = false;
                if (DBStatement != null && (geoData = FDB.resultSet2StringArray(FDB.executeQuery(DBStatement, "SELECT CountryId,Country,State,Bezirk,Landkreis,City,Location,Altitude,POI1,POI2,POI3,POI4,POI5,Street1,Street2,Street3,Street4,Street5,Stichworte FROM POIPlus WHERE Latitude=" + lat + " and Longitude=" + lon, 2))).length > 0) {
                    POIFound = (geoData = geoData[0].split("\t")).length > 16;
                    fProt.prot("Punkt " + lat + " " + lon + " aus " + this.getDBNameReisen() + " geholt: " + FString.stringArrayToString(geoData, ", ", true));
                }
                if (!POIFound) {
                    geoData = this.isGeonameOffline() ? Futi.getGeoDataOffline(lat, lon, this.getDBNameGeonames(), this.getEinwohnerStadtGross(), this.getAbstandStadtGross() * 1000, this.getEinwohnerStadtMittel(), this.getAbstandStadtMittel() * 1000, this.getEinwohnerStadtKlein(), this.getAbstandStadtKlein() * 1000, true, false) : Futi.getGeoDataOnline(lat, lon, this.getDBNameGeonames(), 1.0, false, 'A', true, false);
                    geoData[5] = geoData[5].replaceAll(", Markt", "");
                    geoData[6] = geoData[6].replaceAll(", Markt", "");
                    if (!this.isGeonameOffline() && Futi.isInternetVerfuegbar()) {
                        try {
                            jetzt.setTimeToNow();
                            FDB.executeUpdate(DBStatement, "INSERT INTO POI (Latitude,Longitude,CountryId,Country,State,Bezirk,Landkreis,City,Location,Altitude,POI1,POI2,POI3,POI4,POI5,Street1,Street2,Street3,Street4,Street5,UpdateTimestamp)  VALUES (\"" + lat + "\",\"" + lon + "\",\"" + FString.stringArrayToString(geoData, "\",\"").replaceAll("&", "") + "\",\"" + jetzt.toGermanFormat('Q') + "\")");
                            fProt.prot("Punkt " + lat + " " + lon + " in " + this.getDBNameReisen() + " geschrieben");
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                wayPoints.set(i, String.valueOf(wayPoints.get(i)) + "\t" + "(" + GPS.getErstenOrt(geoData[5], geoData[6], geoData[15], geoData[16], geoData[16], "") + (geoData[13].length() > 0 ? ", " + geoData[13] : "") + ")" + "\t" + (POIFound ? geoData[18] : String.valueOf(geoData[0]) + " " + geoData[1] + " " + geoData[2] + " " + geoData[3] + " " + geoData[4] + " " + geoData[5] + " " + geoData[6]));
            }
            ++i;
        }
        if (DBStatement != null) {
            try {
                DBStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private int addWayPoints(ArrayList<String> trackOrPoiArrayList, ArrayList<String> wayPoints, char trackOrPoi) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FGregorianCalendar zeitCoord = new FGregorianCalendar();
        FGregorianCalendar zeitText = new FGregorianCalendar();
        boolean dateTimeValid = false;
        int maxPausenArt = 4;
        int pausenArt = 0;
        int anzahl = 0;
        String name = "";
        if (trackOrPoi == 'W') {
            maxPausenArt = this.getWaypoints();
        }
        if (trackOrPoi == 'P') {
            maxPausenArt = this.getPOIs();
        }
        int korrekturZeit = trackOrPoi == 'W' ? this.getKorrekturZeitTrack() : (trackOrPoi == 'P' ? this.getKorrekturZeitPOI() : 0);
        String[] stringArray = FString.arrayListToStringArray(wayPoints);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] teile = element.split("\t");
            if (teile.length > 8 && (pausenArt = Integer.parseInt(teile[6])) <= maxPausenArt) {
                ++anzahl;
                trackOrPoiArrayList.add("\t<wpt lat=\"" + teile[0] + "\" lon=\"" + teile[1] + "\">");
                trackOrPoiArrayList.add("\t\t<ele>" + teile[2] + "</ele>");
                try {
                    zeitCoord.setTime(dateTimeFormat.parse(teile[3].replace('T', ' ').replace('Z', ' ')));
                    zeitText.setTime(dateTimeFormat.parse(teile[3].replace('T', ' ').replace('Z', ' ')));
                    dateTimeValid = true;
                    if (korrekturZeit != 0) {
                        zeitCoord.add(10, korrekturZeit);
                    }
                    teile[3] = zeitCoord.toGermanFormat('G');
                    if (this.getKorrekturZeitPOI() != 0) {
                        zeitText.add(10, this.getKorrekturZeitPOI());
                    }
                    zeitText.roundTimetoMinutes(this.getRundenPOIsMinuten());
                }
                catch (ParseException e) {
                    dateTimeValid = false;
                }
                trackOrPoiArrayList.add("\t\t<time>" + teile[3] + "</time>");
                name = String.valueOf(dateTimeValid ? (teile[5].startsWith("\u00dcbernachtung") ? zeitText.toGermanFormat('w') : zeitText.toGermanFormat('W')) : teile[2]) + " " + teile[5] + " " + teile[7] + (dateTimeValid ? (teile[5].startsWith("\u00dcbernachtung") ? this.getWetterDaten(zeitText.toGermanFormat('b')) : "") : teile[2]);
                trackOrPoiArrayList.add("\t\t<name>" + name.trim() + "</name>");
                trackOrPoiArrayList.add("\t\t<desc>" + (dateTimeValid ? (teile[5].startsWith("\u00dcbernachtung") ? zeitText.toGermanFormat('f') : zeitText.toGermanFormat('F')) : teile[2]) + (" " + teile[5]).trim() + "</desc>");
                trackOrPoiArrayList.add("\t\t<cmt>" + this.getKommentarWaypoints().trim() + "</cmt>");
                trackOrPoiArrayList.add("\t\t<sym>Flag," + Futi.getSymbolFarbe(teile[6]) + "</sym>");
                if (teile[8].length() > 0) {
                    trackOrPoiArrayList.add("\t\t<extensions>");
                    trackOrPoiArrayList.add("\t\t\t<mytracks:tags>" + teile[8].replaceAll("&", "").trim() + "</mytracks:tags>");
                    trackOrPoiArrayList.add("\t\t</extensions>");
                    trackOrPoiArrayList.add("\t</wpt>");
                }
            }
            ++n2;
        }
        return anzahl;
    }

    private void changeNameInVereinfacht(String dateiname) {
        ArrayList<String> gpx = new FFile(dateiname).inhaltToStringArrayList(this.getCharsetEingabe());
        boolean inTrack = false;
        int i = 0;
        while (i < gpx.size()) {
            if (gpx.get(i).endsWith("<trk>")) {
                inTrack = true;
            }
            if (gpx.get(i).endsWith("</name>") && inTrack) {
                gpx.set(i, String.valueOf(gpx.get(i).substring(0, gpx.get(i).length() - 7)) + " (vereinfacht um Faktor " + this.getReduceFaktor() + ")</name>");
                break;
            }
            ++i;
        }
        new FFile(dateiname).StringArrayListToInhalt(gpx, this.getCharsetAusgabe());
    }

    private void checkTrackName() {
        FProt fProt = FProt.instance();
        String[] filenames = new FFile(this.getEingabeverzeichnis()).listFileNames();
        ArrayList<String> gpxfilenames = new ArrayList<String>();
        ArrayList<String> liste = new ArrayList<String>();
        ArrayList<String> gpx = new ArrayList();
        String nameDatei = "";
        String nameTrack = "";
        String nameBeginnEnde = "";
        boolean namePos = false;
        boolean nameEndePos = false;
        boolean inTrackOrRoute = false;
        boolean nameFound = false;
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if (dateiname.endsWith(".gpx")) {
                gpxfilenames.add(dateiname);
            }
            ++n2;
        }
        block3: for (String gpxfile : gpxfilenames) {
            nameDatei = FDatei.instance().zerlegeDateiname(gpxfile).getName();
            nameTrack = "";
            nameBeginnEnde = "";
            inTrackOrRoute = false;
            nameFound = false;
            gpx = new FFile(this.getEingabeverzeichnis(), gpxfile).inhaltToStringArrayList(this.getCharsetEingabe());
            if (this.getFunktion().compareTo("T") == 0) {
                try {
                    nameBeginnEnde = this.getBeginnEnde(gpx);
                }
                catch (Exception e) {
                    fProt.prot("Rename nicht erfolgreich f\u00fcr: " + gpxfile);
                }
            }
            int i = 0;
            while (i < gpx.size()) {
                String element = gpx.get(i);
                if (element.indexOf("<trk>") > 0 || element.indexOf("<rte>") > 0) {
                    inTrackOrRoute = true;
                }
                if (inTrackOrRoute && element.indexOf("<name>") >= 0) {
                    nameTrack = element.substring(element.indexOf("<name>") + 6).replaceAll("\t", " ");
                    if (nameTrack.indexOf("</name>") > 0) {
                        nameTrack = nameTrack.substring(0, nameTrack.indexOf("</name>"));
                    }
                    nameFound = true;
                }
                if (nameFound) {
                    liste.add(String.valueOf(nameDatei) + "@" + nameTrack);
                    fProt.prot("Dateiname: <" + nameDatei + "> Name Track: <" + nameTrack + ">" + (nameBeginnEnde.length() > 0 ? " Soll Name <" + nameBeginnEnde + ">" : ""), nameDatei.compareTo(nameTrack) == 0 ? 2 : 0);
                    if (this.getFunktion().compareTo("R") == 0 && nameTrack.length() > 0 && nameDatei.compareTo(nameTrack) != 0) {
                        new FFile(this.getEingabeverzeichnis(), gpxfile).renameTo(this.getEingabeverzeichnis(), String.valueOf(nameTrack) + ".gpx");
                        fProt.prot("Dateiname: <" + gpxfile + "> renamed to: <" + nameTrack + ".gpx> in Verzeichnis: " + this.getEingabeverzeichnis());
                    }
                    if (this.getFunktion().compareTo("Q") == 0 && nameTrack.length() > 0 && nameDatei.compareTo(nameTrack) != 0) {
                        fProt.prot(String.valueOf(element) + " in: <" + this.getEingabeverzeichnis() + gpxfile, 30);
                        gpx.set(i, String.valueOf(element.substring(0, 0)) + nameDatei + element.substring(0));
                        fProt.prot(String.valueOf(element) + " in: <" + this.getEingabeverzeichnis() + gpxfile, 10);
                        new FFile(this.getEingabeverzeichnis(), gpxfile).StringArrayListToInhalt(gpx, this.getCharsetAusgabe());
                        fProt.prot("Trackname: <" + nameTrack + "> changed to: <" + nameDatei + "> in: <" + this.getEingabeverzeichnis() + gpxfile);
                    }
                    if (this.getFunktion().compareTo("T") != 0 || nameBeginnEnde.length() <= 0) continue block3;
                    if (nameTrack.compareTo(nameBeginnEnde) != 0) {
                        fProt.prot(String.valueOf(element) + " in: <" + this.getEingabeverzeichnis() + gpxfile, 30);
                        gpx.set(i, String.valueOf(element.substring(0, 0)) + nameBeginnEnde + element.substring(0));
                        fProt.prot(String.valueOf(element) + " in: <" + this.getEingabeverzeichnis() + gpxfile, 10);
                        new FFile(this.getEingabeverzeichnis(), gpxfile).StringArrayListToInhalt(gpx, this.getCharsetAusgabe());
                        fProt.prot("Trackname: <" + nameTrack + "> changed to: <" + nameBeginnEnde + "> in: <" + this.getEingabeverzeichnis() + gpxfile);
                    }
                    if (nameDatei.compareTo(nameBeginnEnde) == 0) continue block3;
                    new FFile(this.getEingabeverzeichnis(), gpxfile).renameTo(this.getEingabeverzeichnis(), String.valueOf(nameBeginnEnde) + ".gpx");
                    fProt.prot("Dateiname: <" + gpxfile + "> renamed to: <" + nameBeginnEnde + ".gpx> in Verzeichnis: " + this.getEingabeverzeichnis());
                    continue block3;
                }
                ++i;
            }
        }
        new FFile(this.getAusgabedatei()).StringArrayListToInhalt(liste, this.getCharsetAusgabe());
    }

    private void checkZeitpunkt(FGregorianCalendar zeitpunkt, String timeStamp, String letzterZeitpunktString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            zeitpunkt.setTime(dateFormat.parse(timeStamp.replace('T', ' ')));
            zeitpunkt.roundTimetoMinutes(this.getRundenEtappeMinuten());
            if (zeitpunkt.toGermanFormat('A').compareTo(letzterZeitpunktString) == 0) {
                zeitpunkt.setTime(dateFormat.parse(timeStamp.replace('T', ' ')));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void convertCSV2GPX(String eingabedatei, String[] eingabeArray, String eingabeName, String ausgabedateiIn) {
        FProt fProt = FProt.instance();
        String trackName = "";
        String[] csv = eingabeArray;
        boolean eingabeOK = false;
        if (eingabedatei != null) {
            FDatei.DateinamenTeile dateinameEingabe = FDatei.instance().zerlegeDateiname(eingabedatei);
            if (dateinameEingabe.getExtend().compareToIgnoreCase("csv") != 0) {
                fProt.prot(String.valueOf(eingabedatei) + " ist keine Datei mit Endung .csv");
            } else {
                csv = new FFile(eingabedatei).inhaltToStringArray(this.getCharsetEingabe());
                eingabeOK = true;
                trackName = dateinameEingabe.getName();
            }
        } else if (eingabeArray != null && eingabeName != null) {
            eingabeOK = true;
            trackName = eingabeName;
        }
        if (eingabeOK) {
            String[] teile;
            int i;
            ArrayList<String> gpx = new ArrayList<String>();
            gpx.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            gpx.add("<gpx version=\"1.1\" xmlns=\"http://www.topografix.com/GPX/1/1\" creator=\"de.nss.jfi\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
            ArrayList<String> wayPoints = new ArrayList<String>();
            ArrayList<String> poi = new ArrayList<String>();
            poi.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            poi.add("<gpx version=\"1.1\" xmlns=\"http://www.topografix.com/GPX/1/1\" creator=\"de.nss.jfi\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
            FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(ausgabedateiIn);
            String ausgabedatei = String.valueOf(ausgabedateiIn) + (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0 ? ".gpx" : "");
            String ausgabedateiReduce = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-vereinfacht um Faktor " + this.getReduceFaktor() + "." + dateinameAusgabe.getExtend() + (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0 ? ".gpx" : "");
            String ausgabedateiPOI = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-POI." + dateinameAusgabe.getExtend() + (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0 ? ".gpx" : "");
            String ausgabedateiPOIWindows = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-POI-Windows." + dateinameAusgabe.getExtend() + (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0 ? ".gpx" : "");
            String maxTimeStamp = "1980-01-01T01:00:00";
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(0);
            nf.setGroupingUsed(true);
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int azPoints = 0;
            int azPOIs = 0;
            int azWayPoints = 0;
            FGregorianCalendar zeit = new FGregorianCalendar();
            if (this.getFunktion().startsWith("G") || this.getFunktion().startsWith("E3")) {
                if (this.isNoNullSpeed() || this.isOnlyTimeStamp() || this.isNoFreeStanding()) {
                    csv = this.skipNichtrelevante(csv);
                    if (!this.isNoCVS()) {
                        new FFile(String.valueOf(ausgabedatei.substring(0, ausgabedatei.length() - 4)) + "-cleared.csv").StringArrayToInhalt(csv, this.getCharsetAusgabe());
                    }
                }
                if (this.isSortTimeStamp()) {
                    i = 0;
                    while (i < csv.length) {
                        teile = csv[i].split("\t");
                        if (teile.length == 3) {
                            csv[i] = GPS.changeTimeStampCSV(csv[i], maxTimeStamp);
                        }
                        if (teile.length > 3) {
                            if (teile[3].compareToIgnoreCase(maxTimeStamp) < 0) {
                                fProt.prot("Sortierfehler bei Punkt Nr. " + (i + 1) + "; Zeit: " + teile[3] + "; Zeit max: " + maxTimeStamp + " !! korrigiert !!");
                                csv[i] = GPS.changeTimeStampCSV(csv[i], maxTimeStamp);
                            } else {
                                maxTimeStamp = teile[3];
                            }
                        }
                        ++i;
                    }
                }
                if (this.getWaypoints() > 0 || this.getPOIs() > 0) {
                    this.findAndMarkPause(FString.instance().convertStringArrayToTabelle(csv, 11), wayPoints);
                    if (wayPoints.size() > 0) {
                        this.addGeodata2WayPoints(wayPoints);
                        azWayPoints = this.addWayPoints(gpx, wayPoints, 'W');
                        if (this.getPOIs() > 0) {
                            azPOIs = this.addWayPoints(poi, wayPoints, 'P');
                        }
                        fProt.prot(FString.arrayListToStringArray(wayPoints), 2);
                        if (azPOIs > 0) {
                            poi.add("</gpx>");
                            new FFile(ausgabedateiPOI).StringArrayListToInhalt(poi, this.getCharsetAusgabe());
                            new FFile(ausgabedateiPOIWindows).StringArrayListToInhalt(poi, "WINDOWS-1252");
                            fProt.prot(String.valueOf(azPOIs) + " POIs in " + ausgabedateiPOI + " (" + ausgabedateiPOIWindows + ")");
                        }
                    }
                }
            }
            gpx.add("\t<trk>");
            gpx.add("\t\t<name>" + trackName + "</name>");
            gpx.add("\t\t<extensions><mytracks:timezone offset=\"0\"></mytracks:timezone></extensions>");
            gpx.add("\t\t<trkseg>");
            i = 0;
            while (i < csv.length) {
                teile = csv[i].split("\t");
                if (teile.length > 2) {
                    ++azPoints;
                    gpx.add("\t\t\t<trkpt lat=\"" + teile[0] + "\" lon=\"" + teile[1] + "\">");
                    if (this.getFunktion().compareTo("GGH") == 0 || this.getFunktion().compareTo("GGSH") == 0) {
                        teile[2] = Futi.getGeoHoehe(teile[0], teile[1], teile[2], true, true, "Zeile " + i + ": ");
                    }
                    gpx.add("\t\t\t\t<ele>" + teile[2] + "</ele>");
                    if (teile.length > 3) {
                        if (this.getKorrekturZeitTrack() != 0) {
                            try {
                                zeit.setTime(dateTimeFormat.parse(teile[3].replace('T', ' ').replace('Z', ' ')));
                                zeit.add(10, this.getKorrekturZeitTrack());
                                teile[3] = zeit.toGermanFormat('G');
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        gpx.add("\t\t\t\t<time>" + teile[3] + "</time>");
                    }
                    if (teile.length > 4) {
                        gpx.add("\t\t\t\t<desc>Lat.=" + teile[0] + ", Long.=" + teile[1] + ", Alt.=" + teile[2] + ".0m, Speed=" + teile[4] + "Km/h</desc>");
                    }
                    gpx.add("\t\t\t</trkpt>");
                }
                ++i;
            }
            gpx.add("\t\t</trkseg>");
            gpx.add("\t</trk>");
            gpx.add("</gpx>");
            if (azPoints == 0) {
                fProt.prot(String.valueOf(eingabedatei) + " enthaelt keine Punkte");
            } else {
                new FFile(ausgabedatei).StringArrayListToInhalt(gpx, this.getCharsetAusgabe());
                fProt.prot(String.valueOf(nf.format(azPoints)) + " Trackpoints" + (azWayPoints > 0 ? " und " + azWayPoints + " Wegpunkte" : "") + " in " + ausgabedatei);
                if (this.getFunktion().compareTo("G") == 0 && this.isReduceTrackpoints() && this.getReduceFaktor() > 1) {
                    if (azPoints / this.getReduceFaktor() > 10) {
                        FBefehl.aufrufBefehl("GPSBabel", ("-i\tgpx\t-f\t" + ausgabedatei + "\t-x\tsimplify,count=" + azPoints / this.getReduceFaktor() + "\t-o\tgpx\t-F\t" + ausgabedateiReduce).split("\t"), 5);
                        this.changeNameInVereinfacht(ausgabedateiReduce);
                        fProt.prot(String.valueOf(ausgabedatei) + " mit " + nf.format(azPoints) + " Trackpoints" + " auf " + nf.format(azPoints / this.getReduceFaktor()) + " in " + ausgabedateiReduce + " reduziert");
                    } else {
                        fProt.prot("Reduktion auf " + azPoints / this.getReduceFaktor() + " (weniger als 10) Punkte nicht sinnvoll");
                    }
                }
            }
        }
    }

    private void convertCSV2GPXLoop() {
        String[] filenames;
        FProt fProt = FProt.instance();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(0);
        int azCsvFiles = 0;
        ArrayList<String> work = new ArrayList<String>();
        FDatei.DateinamenTeile dateinameTeile = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
        if (dateinameTeile.getExtend().compareToIgnoreCase("gpx") != 0) {
            this.setAusgabedatei(String.valueOf(dateinameTeile.getPfad()) + System.getProperty("file.separator") + dateinameTeile.getName() + ".gpx");
        }
        String ausgabeverzeichnis = (dateinameTeile = FDatei.instance().zerlegeDateiname(this.getEingabeverzeichnis())).getParent().compareToIgnoreCase("CSV") == 0 ? String.valueOf(this.getEingabeverzeichnis().substring(0, this.getEingabeverzeichnis().length() - 4)) + "GPX" + System.getProperty("file.separator") : String.valueOf(this.getEingabeverzeichnis()) + System.getProperty("file.separator") + "GPX" + System.getProperty("file.separator");
        String[] stringArray = filenames = new FFile(ausgabeverzeichnis).listFileNames();
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            new FFile(ausgabeverzeichnis, filename).delete();
            ++n2;
        }
        stringArray = filenames = new FFile(this.getEingabeverzeichnis()).listFileNames();
        n = filenames.length;
        n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            if (dateiname.endsWith(".csv")) {
                ++azCsvFiles;
                ArrayList<String> csv = new FFile(this.getEingabeverzeichnis(), dateiname).inhaltToStringArrayList(this.getCharsetEingabe());
                for (String element : csv) {
                    work.add(element);
                }
                this.convertCSV2GPX(null, FString.arrayListToStringArray(csv), dateiname.substring(0, dateiname.length() - 4), String.valueOf(ausgabeverzeichnis) + dateiname.substring(0, dateiname.length() - 4) + ".gpx");
            }
            ++n2;
        }
        fProt.prot(String.valueOf(azCsvFiles) + " csv-files in " + this.getEingabeverzeichnis());
        dateinameTeile = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
        this.setZusaetzlicheAusgabedatei(String.valueOf(dateinameTeile.getPfad()) + System.getProperty("file.separator") + dateinameTeile.getName() + ".csv");
        new FFile(this.getZusaetzlicheAusgabedatei()).StringArrayListToInhalt(work, this.getCharsetAusgabe());
        fProt.prot(String.valueOf(nf.format(work.size())) + " Trackpoints in " + this.getZusaetzlicheAusgabedatei());
        this.convertCSV2GPX(null, FString.arrayListToStringArray(work), dateinameTeile.getName(), this.getAusgabedatei());
    }

    private void convertGPX2CSV(ArrayList<String> filenames) {
        for (String filename : filenames) {
            String[] teile = filename.split("\t");
            if (teile.length <= 1) continue;
            String eingabedatei = teile[0];
            String ausgabedatei = teile[1];
            FDatei.DateinamenTeile dateinameEingabe = FDatei.instance().zerlegeDateiname(eingabedatei);
            FProt fProt = FProt.instance();
            if (dateinameEingabe.getExtend().compareToIgnoreCase("gpx") != 0) {
                fProt.prot(String.valueOf(eingabedatei) + " ist keine Datei mit Endung .gpx");
                continue;
            }
            ArrayList<String> gpx = new FFile(eingabedatei).inhaltToStringArrayList(this.getCharsetEingabe());
            FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(ausgabedatei);
            if (dateinameAusgabe.getExtend().compareToIgnoreCase("csv") != 0 && dateinameAusgabe.getExtend().compareToIgnoreCase("kmlx") != 0) {
                this.setAusgabedatei(String.valueOf(ausgabedatei) + ".csv");
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(0);
            ArrayList<String> csv = this.convertGPX2CSVInnerLoop(gpx);
            if (csv.size() == 0) {
                fProt.prot(String.valueOf(eingabedatei) + " enthaelt keine Punkte");
                continue;
            }
            new FFile(ausgabedatei).StringArrayListToInhalt(csv, this.getCharsetAusgabe());
            FProt.instance().prot(String.valueOf(nf.format(csv.size())) + " Trackpoints in " + ausgabedatei);
        }
    }

    private final ArrayList<String> convertGPX2CSVInnerLoop(ArrayList<String> gpx) {
        ArrayList<String> trkpts = new ArrayList<String>();
        ArrayList<String> rtepts = new ArrayList<String>();
        ArrayList<String> wpts = new ArrayList<String>();
        FGregorianCalendar zeit = new FGregorianCalendar();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lat = "";
        String lon = "";
        String ele = "";
        String timeStamp = "";
        String speed = "";
        String desc = "";
        String point = "";
        for (String elementx : gpx) {
            String[] teile;
            String element = elementx.trim();
            if ((element.startsWith("<trkpt") || element.startsWith("<rtept") || element.startsWith("<wpt")) && (teile = element.trim().split(" ")).length > 2) {
                int i = 1;
                while (i <= 2) {
                    String[] work;
                    if (teile[i].startsWith("lat=")) {
                        work = teile[i].split("\"");
                        lat = Futi.clearGrad(work[1]);
                    }
                    if (teile[i].startsWith("lon=")) {
                        work = teile[i].split("\"");
                        lon = Futi.clearGrad(work[1]);
                    }
                    ++i;
                }
            }
            if (element.startsWith("<ele>") && (teile = element.split("<")).length > 1 && (ele = teile[1].substring(4)).indexOf(".") > 0) {
                ele = ele.substring(0, ele.indexOf("."));
            }
            if (element.startsWith("<time>") && this.getFunktion().compareToIgnoreCase("GGR") != 0) {
                if (this.isNoTimeStamp()) {
                    timeStamp = "";
                } else if (element.length() > 25) {
                    timeStamp = String.valueOf(element.substring(6, 25)) + "Z";
                    if (this.getKorrekturZeitTrack() != 0 && !this.getFunktion().startsWith("GG")) {
                        try {
                            zeit.setTime(dateTimeFormat.parse(timeStamp.replace('T', ' ').replace('Z', ' ')));
                            zeit.add(10, this.getKorrekturZeitTrack());
                            timeStamp = zeit.toGermanFormat('G');
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (element.startsWith("<desc>") && (teile = element.split("<")).length > 2 && (teile = (desc = teile[1].substring(5)).split("Speed=")).length > 1) {
                speed = teile[1].replaceAll("Km/h", "").replaceAll("km/h", "").replaceAll(",", ".");
            }
            if (!element.trim().startsWith("</trkpt") && !element.trim().startsWith("</rtept") && !element.trim().startsWith("</wpt")) continue;
            if (lat.length() > 0 && lon.length() > 0) {
                point = this.getFunktion().compareTo("M") == 0 || this.getFunktion().compareTo("MV") == 0 ? String.valueOf(lon) + "," + lat + (ele.length() > 0 ? "," + ele : "") : String.valueOf(lat) + "\t" + lon + "\t" + ele + "\t" + timeStamp + (this.getFunktion().compareTo("CK") == 0 || this.getFunktion().compareTo("GGK") == 0 || this.getFunktion().charAt(0) == 'B' ? "" : "\t" + speed + "\t" + desc);
                if (element.trim().startsWith("</trkpt")) {
                    trkpts.add(point);
                } else if (element.trim().startsWith("</rtept")) {
                    rtepts.add(point);
                } else if (element.trim().startsWith("</wpt")) {
                    wpts.add(point);
                }
            }
            lat = "";
            lon = "";
            ele = "";
            timeStamp = "";
            speed = "";
            desc = "";
        }
        return trkpts.size() > 0 ? trkpts : (rtepts.size() > 0 ? rtepts : wpts);
    }

    private void convertGPX2CSVOuterLoop() {
        ArrayList<String> gpxfilenames = new ArrayList<String>();
        if (this.getFunktion().compareTo("MV") != 0) {
            gpxfilenames.add(String.valueOf(this.getEingabedatei()) + "\t" + this.getAusgabedatei());
        } else {
            String[] filenames = new FFile(this.getEingabeverzeichnis()).listFileNames();
            SimpleDateFormat formatKmlx = new SimpleDateFormat("yyMMdd_HHmm_HHmm");
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String dateiname = stringArray[n2];
                if (dateiname.endsWith(".gpx")) {
                    try {
                        formatKmlx.parse(dateiname.substring(0, 17));
                        gpxfilenames.add(String.valueOf(this.getEingabeverzeichnis()) + System.getProperty("file.separator") + dateiname + "\t" + this.getEingabeverzeichnis() + System.getProperty("file.separator") + dateiname.substring(0, dateiname.length() - 4) + ".kmlx");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        this.convertGPX2CSV(gpxfilenames);
        if (this.getFunktion().compareTo("MV") == 0) {
            this.convertKML();
        }
    }

    private void convertKML() {
        FDatei.DateinamenTeile dateiname;
        FProt fProt = FProt.instance();
        String[] kmlfilenames = this.convertKMLVorlauf();
        ArrayList<String> work = new ArrayList<String>();
        ArrayList<String> csv = new ArrayList<String>();
        ArrayList<String> stat = new ArrayList<String>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        int azKmlfiles = 0;
        double lastTrackLastLat = -999.0;
        double lastTrackLastLon = -999.0;
        String lastTrackZiel = "";
        String dateinameSuffix = "";
        int azStartValid = 0;
        int azEndeValid = 0;
        String[] stringArray = kmlfilenames;
        int n = kmlfilenames.length;
        int n2 = 0;
        while (n2 < n) {
            String kmlfile = stringArray[n2];
            ++azKmlfiles;
            ArrayList<String> kml = new FFile(this.getEingabeverzeichnis(), kmlfile).inhaltToStringArrayList(this.getCharsetEingabe());
            if (this.getFunktion().compareTo("KT") == 0) {
                if (kml.size() > 1) {
                    kml.clear();
                } else {
                    String[] coord2;
                    String[] coord1 = kml.get(0).split("<coordinates>");
                    if (coord1.length > 1 && (coord2 = coord1[1].split("</coordinates>")).length > 1) {
                        String[] coord = coord2[0].split(" ");
                        work.clear();
                        String[] stringArray2 = coord;
                        int n3 = coord.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String element = stringArray2[n4];
                            work.add(element);
                            ++n4;
                        }
                        kml.clear();
                        kml.addAll(work);
                    }
                }
            }
            work.clear();
            SygicKml sygicKml = new SygicKml();
            if (azKmlfiles <= 1) {
                stat.add(FString.stringArrayToString(sygicKml.printSteuerung(true, true, true), "\t").replaceAll(":", "").replaceAll(" ", ""));
            } else {
                sygicKml.setLastTrackLastLat(lastTrackLastLat);
                sygicKml.setLastTrackLastLon(lastTrackLastLon);
                sygicKml.setLastTrackZiel(lastTrackZiel);
            }
            if (sygicKml.getHeader(kml, kmlfile, kmlfilenames, azKmlfiles - 1)) {
                fProt.prot(FString.stringArrayToString(sygicKml.printSteuerung(false, false, false), "\t"), 2);
                azStartValid += sygicKml.isStartValid() ? 1 : 0;
                azEndeValid += sygicKml.isEndValid() ? 1 : 0;
                if (sygicKml.isRewriteKmlfile()) {
                    new FFile(this.getEingabeverzeichnis(), kmlfile).StringArrayListToInhalt(kml, this.getCharsetAusgabe());
                    fProt.prot(String.valueOf(kmlfile) + " Inhalt korrigiert");
                }
                int i = sygicKml.getStartPoints();
                while (i <= sygicKml.getEndePoints()) {
                    if (sygicKml.getPoint(kml.get(i), i - sygicKml.getStartPoints())) {
                        work.add(sygicKml.getZeile());
                    }
                    ++i;
                }
                if (work.size() == 0) {
                    fProt.prot(String.valueOf(kmlfile) + " enthaelt keine Punkte");
                } else {
                    lastTrackLastLat = sygicKml.getLat();
                    lastTrackLastLon = sygicKml.getLon();
                    lastTrackZiel = sygicKml.getZiel();
                    stat.add(FString.stringArrayToString(sygicKml.printSteuerung(true, false, false), "\t"));
                    dateinameSuffix = this.getFunktion().compareTo("KX") == 0 || this.getFunktion().compareTo("MV") == 0 || this.getFunktion().compareToIgnoreCase("KT") == 0 ? "" : "-von_" + sygicKml.getStart() + "-nach_" + sygicKml.getZiel();
                    dateinameSuffix = dateinameSuffix.replace('\\', '_').replace('\\', '_').replace('\\', '_').replace('\\', '_').replace('\\', '_');
                    dateinameSuffix = dateinameSuffix.replace('/', '_').replace('/', '_').replace('/', '_').replace('/', '_').replace('/', '_');
                    dateinameSuffix = dateinameSuffix.replaceAll(" ", "_").replaceAll(",", "_").replaceAll("__", "_");
                    dateiname = FDatei.instance().zerlegeDateiname(kmlfile);
                    if (!dateiname.getName().endsWith(dateinameSuffix)) {
                        new FFile(this.getEingabeverzeichnis(), kmlfile).renameTo(this.getEingabeverzeichnis(), String.valueOf(dateiname.getName()) + dateinameSuffix + "." + dateiname.getExtend());
                    }
                    if (!this.isNoCVS()) {
                        new FFile(this.getEingabeverzeichnis(), "CSV" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".csv").StringArrayToInhalt(FString.arrayListToStringArray(work), this.getCharsetAusgabe());
                    }
                    nf.setMinimumFractionDigits(0);
                    this.convertCSV2GPX(null, FString.arrayListToStringArray(work), dateiname.getName(), String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".gpx");
                    fProt.prot(String.valueOf(nf.format(work.size())) + " Trackpoints" + " in " + this.getEingabeverzeichnis() + "CSV" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".csv", !this.isNoCVS() ? 0 : 999);
                    nf.setMinimumFractionDigits(2);
                    csv.addAll(work);
                }
            }
            ++n2;
        }
        if (this.getFunktion().compareTo("MV") != 0) {
            new FFile(this.getEingabeverzeichnis(), "_kml_Statistik.csv").StringArrayListToInhalt(stat, this.getCharsetAusgabe());
            nf.setMinimumFractionDigits(0);
            nf.setGroupingUsed(true);
            fProt.prot(String.valueOf(azKmlfiles) + " kml-files in " + this.getEingabeverzeichnis() + " Startzeit gueltig: " + nf.format(azStartValid) + "; Endezeit gueltig: " + nf.format(azEndeValid));
            new FFile(this.getZusaetzlicheAusgabedatei()).StringArrayListToInhalt(csv, this.getCharsetAusgabe());
            fProt.prot(String.valueOf(nf.format(csv.size())) + " Trackpoints in " + this.getZusaetzlicheAusgabedatei());
            dateiname = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
            this.convertCSV2GPX(null, FString.arrayListToStringArray(csv), dateiname.getName(), this.getAusgabedatei());
        }
    }

    private String[] convertKMLVorlauf() {
        if (this.getFunktion().compareTo("MV") != 0) {
            FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
            if (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0) {
                this.setAusgabedatei(String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + ".gpx");
            }
            this.setZusaetzlicheAusgabedatei(String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + ".csv");
        }
        SimpleDateFormat formatKml = new SimpleDateFormat("yyMMdd_HHmmss");
        SimpleDateFormat formatKmlx = new SimpleDateFormat("yyMMdd_HHmm_HHmm");
        String[] filenames = new FFile(this.getEingabeverzeichnis()).listFileNames();
        ArrayList<String> kmlfilenames = new ArrayList<String>();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String dateiname = stringArray[n2];
            try {
                if (this.getFunktion().compareTo("KX") == 0 || this.getFunktion().compareTo("MV") == 0) {
                    formatKmlx.parse(dateiname.substring(0, 17));
                    if (dateiname.endsWith(".kmlx")) {
                        kmlfilenames.add(dateiname);
                    }
                } else if (this.getFunktion().compareTo("KT") == 0) {
                    formatKmlx.parse(dateiname.substring(0, 17));
                    if (dateiname.endsWith(".kml.txt")) {
                        String dateinameNeu = String.valueOf(dateiname.substring(0, dateiname.length() - 8)) + ".kmlt";
                        new FFile(this.getEingabeverzeichnis(), dateiname).renameTo(this.getEingabeverzeichnis(), dateinameNeu);
                        kmlfilenames.add(dateinameNeu);
                    } else if (dateiname.endsWith(".kmlt")) {
                        kmlfilenames.add(dateiname);
                    }
                } else {
                    formatKml.parse(dateiname.substring(0, 17));
                    if (dateiname.endsWith(".kml")) {
                        kmlfilenames.add(dateiname);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        stringArray = filenames = new FFile(String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator")).listFileNames();
        n = filenames.length;
        n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            new FFile(String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator") + filename).delete();
            ++n2;
        }
        return FString.arrayListToStringArray(kmlfilenames);
    }

    private void convertLog() {
        FProt fProt = FProt.instance();
        String[] logfilenames = this.convertLogVorlauf();
        if (this.isCVSVerzeichnisNichtLeer()) {
            FDatei.DateinamenTeile dateiname;
            ArrayList<String> work = new ArrayList<String>();
            ArrayList<String> csv = new ArrayList<String>();
            ArrayList<String> stat = new ArrayList<String>();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            int azLogfiles = 0;
            long azPoints = 0L;
            double lastTrackLastLat = -999.0;
            double lastTrackLastLon = -999.0;
            String lastTrackZiel = "";
            String dateinameSuffix = "";
            String[] stringArray = logfilenames;
            int n = logfilenames.length;
            int n2 = 0;
            while (n2 < n) {
                String logfile = stringArray[n2];
                dateiname = FDatei.instance().zerlegeDateiname(logfile);
                if (dateiname.getExtend().compareToIgnoreCase("log") == 0) {
                    azPoints = 0L;
                    work.clear();
                    FFile sygicLogFile = new FFile(this.getEingabeverzeichnis(), logfile);
                    SygicLog sygicLog = new SygicLog();
                    if (++azLogfiles <= 1) {
                        stat.add(FString.stringArrayToString(sygicLog.printSteuerung(true, true, true), "\t").replaceAll(":", "").replaceAll(" ", ""));
                    } else {
                        sygicLog.setLastTrackLastLat(lastTrackLastLat);
                        sygicLog.setLastTrackLastLon(lastTrackLastLon);
                        sygicLog.setLastTrackZiel(lastTrackZiel);
                    }
                    sygicLog.getHeader(sygicLogFile);
                    byte[] b = sygicLogFile.inhaltToByteArray(25);
                    while (azPoints < sygicLog.getPointCount()) {
                        sygicLog.getPoint(b);
                        work.add(sygicLog.getZeile());
                        if (++azPoints == 1L) {
                            sygicLog.setFirstLat(sygicLog.getLat());
                            sygicLog.setFirstLon(sygicLog.getLon());
                        }
                        fProt.prot(GPS.byte2Hex(b, 0, 25, true), 2);
                        fProt.prot(sygicLog.getZeile(), 2);
                        fProt.prot(FString.stringArrayToString(sygicLog.printPoint(false), "\t"), 2);
                        b = sygicLogFile.inhaltToByteArray(25);
                    }
                    sygicLogFile.close();
                    fProt.prot(sygicLog.printSteuerung(), 2);
                    if (work.size() == 0) {
                        fProt.prot(String.valueOf(logfile) + " enthaelt keine Punkte");
                    } else {
                        lastTrackLastLat = sygicLog.getLat();
                        lastTrackLastLon = sygicLog.getLon();
                        lastTrackZiel = sygicLog.getZiel();
                        stat.add(FString.stringArrayToString(sygicLog.printSteuerung(true, false, false), "\t"));
                        dateinameSuffix = "-von_" + sygicLog.getStart() + "-nach_" + sygicLog.getZiel();
                        dateinameSuffix = dateinameSuffix.replace('\\', '_').replace('\\', '_').replace('\\', '_').replace('\\', '_').replace('\\', '_');
                        dateinameSuffix = dateinameSuffix.replace('/', '_').replace('/', '_').replace('/', '_').replace('/', '_').replace('/', '_');
                        dateinameSuffix = dateinameSuffix.replaceAll(" ", "_").replaceAll(",", "_").replaceAll("__", "_");
                        new FFile(this.getEingabeverzeichnis(), "CSV" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".csv").StringArrayToInhalt(FString.arrayListToStringArray(work), this.getCharsetAusgabe());
                        nf.setMinimumFractionDigits(0);
                        this.convertCSV2GPX(null, FString.arrayListToStringArray(work), dateiname.getName(), String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".gpx");
                        fProt.prot(String.valueOf(nf.format(work.size())) + " Trackpoints" + " in " + this.getEingabeverzeichnis() + "CSV" + System.getProperty("file.separator") + dateiname.getName() + (!dateiname.getName().endsWith(dateinameSuffix) ? dateinameSuffix : "") + ".csv");
                        nf.setMinimumFractionDigits(2);
                        csv.addAll(work);
                    }
                }
                ++n2;
            }
            new FFile(this.getEingabeverzeichnis(), "_log_Statistik.csv").StringArrayListToInhalt(stat, this.getCharsetAusgabe());
            nf.setMinimumFractionDigits(0);
            nf.setGroupingUsed(true);
            fProt.prot(String.valueOf(azLogfiles) + " log-files in " + this.getEingabeverzeichnis());
            new FFile(this.getZusaetzlicheAusgabedatei()).StringArrayListToInhalt(csv, this.getCharsetAusgabe());
            fProt.prot(String.valueOf(nf.format(csv.size())) + " Trackpoints in " + this.getZusaetzlicheAusgabedatei());
            dateiname = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
            this.convertCSV2GPX(null, FString.arrayListToStringArray(csv), dateiname.getName(), this.getAusgabedatei());
        }
    }

    private String[] convertLogVorlauf() {
        FProt fProt = FProt.instance();
        ArrayList<String> logfilenames = new ArrayList<String>();
        String[] filenames = new FFile(String.valueOf(this.getEingabeverzeichnis()) + "CSV" + System.getProperty("file.separator")).listFileNames();
        if (filenames.length > 0) {
            this.setCVSVerzeichnisNichtLeer(false);
            fProt.prot("Das Verzeichnis " + this.getEingabeverzeichnis() + "CSV" + System.getProperty("file.separator") + " muss leer sein.");
            fProt.prot("Auf den Dateien dieses Verzeichnisses wird bzw. wurde ggf. editiert. Keine Verarbeitung moeglich.");
        } else {
            this.setCVSVerzeichnisNichtLeer(true);
            FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
            if (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0) {
                this.setAusgabedatei(String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + ".gpx");
            }
            this.setZusaetzlicheAusgabedatei(String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + ".csv");
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd_HHmmss");
            String[] stringArray = filenames = new FFile(this.getEingabeverzeichnis()).listFileNames();
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String dateiname = stringArray[n2];
                try {
                    format.parse(dateiname.substring(0, 17));
                    if (dateiname.endsWith(".log")) {
                        logfilenames.add(dateiname);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            stringArray = filenames = new FFile(String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator")).listFileNames();
            n = filenames.length;
            n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                new FFile(String.valueOf(this.getEingabeverzeichnis()) + "GPX" + System.getProperty("file.separator") + filename).delete();
                ++n2;
            }
        }
        return FString.arrayListToStringArray(logfilenames);
    }

    private final String[] convertTKStar2CSV(String nameAusgabedateiOhneExtend) {
        boolean isGetHoehe;
        ArrayList<Object> kml = new ArrayList();
        boolean bl = isGetHoehe = this.getFunktion().charAt(this.getFunktion().length() - 1) == 'H';
        if (this.getFunktion().length() > 2 && this.getFunktion().toUpperCase().charAt(2) == 'Z') {
            String data = "";
            try {
                data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                kml.add(data);
            }
            catch (Exception exception) {}
        } else {
            kml = new FFile(this.getEingabedatei()).inhaltToStringArrayList(this.getCharsetEingabe());
        }
        ArrayList<String> csv = new ArrayList<String>();
        int posPoint = 0;
        int lastPosPoint = 0;
        String punkt = "";
        String lat = "";
        String lon = "";
        String zeit = "";
        String speed = "";
        int i = 0;
        while (i < kml.size()) {
            posPoint = -1;
            lastPosPoint = -1;
            do {
                String[] teile;
                posPoint = ((String)kml.get(i)).indexOf("deviceUtcDate:", posPoint + 1);
                if (lastPosPoint >= 0 && (teile = (punkt = ((String)kml.get(i)).substring(lastPosPoint + 16, posPoint > lastPosPoint + 16 ? posPoint : ((String)kml.get(i)).length())).split(",")).length > 3) {
                    zeit = String.valueOf(teile[0].substring(0, 10)) + "T" + teile[0].substring(11, 19) + "Z";
                    lat = teile[1].substring(11);
                    lat = lat.substring(0, lat.length() - 2);
                    lon = teile[2].substring(12);
                    lon = lon.substring(0, lon.length() - 2);
                    speed = teile[3].substring(8);
                    speed = speed.substring(0, speed.length() - 2);
                    csv.add(String.valueOf(lat) + "\t" + lon + "\t" + (isGetHoehe ? Futi.getGeoHoehe(lat, lon, "0", false, true, String.valueOf(zeit) + " (Zeile " + i + "): ") : "") + "\t" + zeit + "\t" + speed);
                }
                lastPosPoint = posPoint;
            } while (posPoint >= 0);
            ++i;
        }
        if (!this.isNoCVS()) {
            new FFile(String.valueOf(nameAusgabedateiOhneExtend) + ".csv").StringArrayListToInhalt(csv, this.getCharsetAusgabe());
        }
        return FString.arrayListToStringArray(csv);
    }

    private void createCSVTrackAusEtappen() {
        FProt fProt = FProt.instance();
        ArrayList<String> work = new ArrayList<String>();
        ArrayList<String> ausgabe = new ArrayList<String>();
        FGregorianCalendar zeitpunkt = new FGregorianCalendar();
        FGregorianCalendar endeEtappe = new FGregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> orte = new ArrayList<String>();
        String[][] in = FString.convertStringArrayToTabelle(new FFile(this.getEingabedatei()).inhaltToStringArray(this.getCharsetEingabe()), 2, true);
        int i = 0;
        while (i < in.length) {
            boolean endeEtappeValid;
            boolean zeitpunktValid;
            in[i][1] = in[i][1].replaceAll("\u00fcber ", "").replaceAll("bis kurz vor ", "").replaceAll("kurz vor ", "").replaceAll("nach ", ",").replaceAll("zur\u00fcck ", ",").replaceAll(" und ", ",").replaceAll(";", "").replaceAll("\"", "");
            if (in[i][1].indexOf(":") > 0) {
                in[i][1] = in[i][1].substring(0, in[i][1].indexOf(":"));
            }
            try {
                zeitpunkt.setTime(dateFormat.parse(in[i][0].replace('T', ' ')));
                zeitpunktValid = true;
            }
            catch (Exception e) {
                zeitpunktValid = false;
            }
            try {
                endeEtappe.setTime(dateFormat.parse(in[i + 1][0].replace('T', ' ')));
                endeEtappeValid = true;
            }
            catch (Exception e) {
                endeEtappeValid = false;
            }
            if (!endeEtappeValid && i < in.length - 1) {
                fProt.prot("EndeEtappe nicht vorhanden " + in[i][1]);
            }
            if (!zeitpunktValid) {
                fProt.prot("uebersprungen, da kein Timestamp " + in[i][1]);
            } else {
                String[] teile = in[i][1].split(",");
                orte.clear();
                String[] stringArray = teile;
                int n = teile.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (element.trim().length() > 0) {
                        orte.add(element.trim());
                    }
                    ++n2;
                }
                if (orte.size() > 0) {
                    int zeitIncrement = endeEtappeValid ? (int)((endeEtappe.getTimeInMillis() - zeitpunkt.getTimeInMillis()) / (long)orte.size()) : 30;
                    int j = 0;
                    while (j < orte.size()) {
                        if (j > 0) {
                            zeitpunkt.add(14, zeitIncrement);
                        }
                        fProt.prot(String.valueOf(zeitpunkt.toGermanFormat('G')) + " " + teile[j].trim(), 2);
                        if (teile[j].trim().length() > 0) {
                            work.add("\t\t\t" + zeitpunkt.toGermanFormat('G').replace("T", " ") + "\t" + "\t" + teile[j].trim());
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (work.size() > 0) {
            i = 0;
            while (i < work.size()) {
                String zeile = (String)work.get(i);
                if (zeile.indexOf("(") > 0) {
                    zeile = zeile.substring(0, zeile.indexOf("("));
                }
                if (i == 0 || zeile.length() > 23 && zeile.indexOf("Richtung ") < 0) {
                    ausgabe.add(zeile);
                }
                ++i;
            }
        }
        new FFile(this.getAusgabedatei()).StringArrayListToInhalt(ausgabe, this.getCharsetAusgabe());
        fProt.prot("Aus " + in.length + " Etappen in " + this.getEingabedatei() + " " + ausgabe.size() + " Trackpunkte in " + this.getAusgabedatei() + " erstellt");
    }

    private void createFotopausen() {
        FProt fProt = FProt.instance();
        if (this.getDBNameFotos().length() <= 1) {
            fProt.prot("keine Foto-DB benannt.");
        } else {
            boolean eingabeOK = false;
            FGregorianCalendar pauseBeginn = new FGregorianCalendar();
            FGregorianCalendar pauseEnde = new FGregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int abstandAlles = 10000000;
            ArrayList<String> fotopausen = new ArrayList<String>();
            Datei2Tabelle datei2Tabelle = new Datei2Tabelle();
            if (this.getFunktion().compareTo("F") == 0) {
                if (this.getEingabedatei().endsWith("csv")) {
                    eingabeOK = true;
                } else {
                    fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .csv");
                }
            }
            if (this.getFunktion().compareTo("FG") == 0) {
                if (this.getEingabedatei().endsWith("gpx")) {
                    eingabeOK = true;
                } else {
                    fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .gpx");
                }
            }
            if (eingabeOK) {
                if (!this.getAusgabedatei().endsWith("csv")) {
                    fProt.prot(String.valueOf(this.getAusgabedatei()) + " ist keine Datei mit Endung .csv");
                } else {
                    ArrayList<String> work = new FFile(this.getEingabedatei()).inhaltToStringArrayList(this.getCharsetEingabe());
                    String[][] csv = null;
                    csv = this.getFunktion().compareTo("FG") == 0 ? FString.instance().convertStringArrayToTabelle(FString.arrayListToStringArray(this.convertGPX2CSVInnerLoop(work)), 35) : FString.instance().convertStringArrayToTabelle(FString.arrayListToStringArray(work), 35);
                    if (csv == null || csv.length == 0) {
                        fProt.prot("fehlerhafte Eingabedatei, keine Punkte vorhanden");
                    } else {
                        this.findAndMarkPause(csv, null);
                        if (!csv[0][5].startsWith("Start") || !csv[csv.length - 1][5].startsWith("Ende")) {
                            fProt.prot("fehlerhafte Eingabedatei, moeglicherweise zu wenige Punkte oder zu kurze Etappen, Erstellung Reisebericht nicht moeglich");
                        } else {
                            int i = 0;
                            while (i < csv.length) {
                                if (csv[i][5].startsWith("Pause, Beginn")) {
                                    String[] geoData = this.isGeonameOffline() ? Futi.getGeoDataOffline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), this.getEinwohnerStadtGross(), 10000000, this.getEinwohnerStadtMittel(), 10000000, this.getEinwohnerStadtKlein(), 10000000, true, false) : Futi.getGeoDataOnline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), Math.min((double)this.getAbstandPunkteMeter() / 1000.0, 1.0), false, 'S', true, false);
                                    csv[i][8] = geoData[5];
                                    csv[i][9] = geoData[6];
                                    csv[i][10] = geoData[13];
                                    csv[i][17] = FString.stringArrayToString(geoData, "\t");
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < csv.length) {
                                if (csv[i][5].startsWith("Pause, Beginn")) {
                                    try {
                                        pauseBeginn.setTime(dateFormat.parse(csv[i][3].replace('T', ' ')));
                                        pauseEnde.setTime(dateFormat.parse(csv[i + 1][3].replace('T', ' ')));
                                    }
                                    catch (ParseException parseException) {
                                        // empty catch block
                                    }
                                    fotopausen.add(String.valueOf(pauseBeginn.toGermanFormat('F')) + "\t" + pauseEnde.toGermanFormat(pauseBeginn.toGermanFormat('S').compareTo(pauseEnde.toGermanFormat('S')) == 0 ? (char)'z' : 'F') + "\t" + GPS.formatiereOrtundOrtsteil(csv[i][8], csv[i][9], 'M') + (csv[i][10].length() > 0 ? ", " + csv[i][10] : "") + ": " + csv[i][5].replaceAll("Pause, Beginn - \u00dcbernachtung", "\u00dcbernachtungsplatz").replaceAll("Pause, Beginn - ", "") + "\t" + (pauseBeginn.getTimeInMillis() / 1000L + (long)(this.getKorrekturZeitPOI() * 3600)) + "\t" + (pauseEnde.getTimeInMillis() / 1000L + (long)(this.getKorrekturZeitPOI() * 3600)));
                                }
                                ++i;
                            }
                            new FFile(this.getAusgabedatei()).StringArrayListToInhalt(fotopausen, this.getCharsetAusgabe());
                            fProt.prot(String.valueOf(fotopausen.size()) + " Etappen in " + this.getAusgabedatei() + " erstellt");
                            datei2Tabelle.setTabelle("Fotopausen");
                            datei2Tabelle.setExterneListe(FString.instance().convertStringArrayToTabelle(FString.arrayListToStringArray(fotopausen)));
                            datei2Tabelle.setDBName(this.getDBNameFotos());
                            datei2Tabelle.setOhneFeldnamen(true);
                            datei2Tabelle.setOhneStand(true);
                            datei2Tabelle.setLeereSpaltenUebernehmen(true);
                            datei2Tabelle.run();
                        }
                    }
                }
            }
        }
    }

    private void createReisebericht() {
        FProt fProt = FProt.instance();
        boolean eingabeOK = false;
        double letzterOrtLat = 0.0;
        double letzterOrtLon = 0.0;
        double lat = 0.0;
        double lon = 0.0;
        double entfernungPunkte = 0.0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FGregorianCalendar letzterZeitpunkt = new FGregorianCalendar();
        FGregorianCalendar zeitpunkt = new FGregorianCalendar();
        int azFehlendeOrte = 0;
        int abstandAlles = 10000000;
        int abstand = 0;
        String Grossstadt = "";
        String MittlereStadt = "";
        String Kleinstadt = "";
        String letzterZeitpunktString = "";
        String[] siesta = new String[]{"Siesta-Ort", "Siesta-Stelle", "\u00dcbernachtung-Ort", "\u00dcbernachtung-Stelle"};
        ArrayList<String> etappen = new ArrayList<String>();
        ArrayList<String> reisetage = new ArrayList<String>();
        ArrayList<String> ausgabeWork = new ArrayList<String>();
        ArrayList<String> orte = new ArrayList<String>();
        ArrayList<String> orte1 = new ArrayList<String>();
        ArrayList<String> orte2 = new ArrayList<String>();
        ArrayList<String> orte3 = new ArrayList<String>();
        ArrayList<String> grossstadt = new ArrayList<String>();
        ArrayList<String> mittlereStadt = new ArrayList<String>();
        ArrayList<String> kleinstadt = new ArrayList<String>();
        ArrayList<String> kleinGgfMittlereStadt = new ArrayList<String>();
        ArrayList<String> kleinGgfMittlereGgfGrossstadt = new ArrayList<String>();
        char[] orteAnordung = this.getOrteAnordnung();
        if (this.getFunktion().compareTo("BG") == 0) {
            if (this.getEingabedatei().endsWith("gpx")) {
                eingabeOK = true;
            } else {
                fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .gpx");
            }
        } else if (this.getEingabedatei().endsWith("csv")) {
            eingabeOK = true;
        } else {
            fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .csv");
        }
        if (eingabeOK) {
            if (!this.getAusgabedatei().endsWith("csv")) {
                fProt.prot(String.valueOf(this.getAusgabedatei()) + " ist keine Datei mit Endung .csv");
            } else {
                FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
                String ausgabeEtappenDateiname = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-Etappen." + dateinameAusgabe.getExtend();
                String ausgabeReisetageDateiname = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-Reisetage." + dateinameAusgabe.getExtend();
                String ausgabeWorkDateiname = String.valueOf(dateinameAusgabe.getPfad()) + System.getProperty("file.separator") + dateinameAusgabe.getName() + "-get-Ortsnamen-" + this.getAbstandPunkteMeter() + "m." + dateinameAusgabe.getExtend();
                ArrayList<String> work = new FFile(this.getEingabedatei()).inhaltToStringArrayList(this.getCharsetEingabe());
                String[][] csv = null;
                csv = this.getFunktion().compareTo("BG") == 0 ? FString.instance().convertStringArrayToTabelle(FString.arrayListToStringArray(this.convertGPX2CSVInnerLoop(work)), 35) : FString.instance().convertStringArrayToTabelle(FString.arrayListToStringArray(work), 35);
                if (csv == null || csv.length == 0) {
                    fProt.prot("fehlerhafte Eingabedatei, keine Punkte vorhanden");
                } else {
                    int i;
                    if (this.getFunktion().compareTo("B") == 0 || this.getFunktion().compareTo("BG") == 0 || this.getFunktion().compareTo("BW") == 0) {
                        this.findAndMarkPause(csv, null);
                        i = 0;
                        while (i < csv.length) {
                            if (i == 0) {
                                letzterOrtLat = Double.parseDouble(csv[i][0]);
                                letzterOrtLon = Double.parseDouble(csv[i][1]);
                                try {
                                    letzterZeitpunkt.setTime(dateFormat.parse(csv[i][3].replace('T', ' ')));
                                }
                                catch (ParseException parseException) {}
                            } else {
                                lat = Double.parseDouble(csv[i][0]);
                                lon = Double.parseDouble(csv[i][1]);
                                entfernungPunkte = Math.round(Distance.distance(letzterOrtLat, letzterOrtLon, lat, lon, 'K', 6) * 1000.0);
                                csv[i][6] = Double.toString(entfernungPunkte).replace(".0", "");
                                if (entfernungPunkte >= (double)this.getAbstandPunkteMeter() || csv[i][5].startsWith("Pause, Beginn") || csv[i][5].compareTo("Ende") == 0) {
                                    if (csv[i][5].length() == 0) {
                                        csv[i][5] = "get Ort";
                                    }
                                    letzterOrtLat = lat;
                                    letzterOrtLon = lon;
                                }
                            }
                            ++i;
                        }
                    }
                    if (!csv[0][5].startsWith("Start") || !csv[csv.length - 1][5].startsWith("Ende")) {
                        fProt.prot("fehlerhafte Eingabedatei, moeglicherweise zu wenige Punkte oder zu kurze Etappen, Erstellung Reisebericht nicht moeglich");
                    } else {
                        i = 0;
                        while (i < csv.length) {
                            if (!(csv[i][5].length() <= 0 || csv[i][5].startsWith("Start") || csv[i][5].startsWith("Pause, Ende") || csv[i][5].startsWith("ignore") || csv[i][8].length() + csv[i][9].length() != 0)) {
                                String[] geoData = this.isGeonameOffline() || csv[i][5].startsWith("get Ort") ? Futi.getGeoDataOffline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), this.getEinwohnerStadtGross(), 10000000, this.getEinwohnerStadtMittel(), 10000000, this.getEinwohnerStadtKlein(), 10000000, true, false) : Futi.getGeoDataOnline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), Math.min((double)this.getAbstandPunkteMeter() / 1000.0, 1.0), false, 'S', true, false);
                                csv[i][8] = geoData[5];
                                csv[i][9] = geoData[6];
                                csv[i][10] = geoData[13];
                                csv[i][11] = geoData[15];
                                csv[i][12] = geoData[10];
                                csv[i][13] = geoData[16];
                                csv[i][14] = geoData[11];
                                csv[i][15] = geoData[17];
                                csv[i][16] = geoData[12];
                                csv[i][17] = FString.stringArrayToString(geoData, "\t");
                            }
                            ++i;
                        }
                        String[][] stringArray = csv;
                        int n = csv.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] element = stringArray[n2];
                            if (element[5].startsWith("Start") || element[5].startsWith("Pause, Ende")) {
                                this.checkZeitpunkt(zeitpunkt, element[3], letzterZeitpunktString);
                            } else if (element[5].compareTo("get Ort") == 0) {
                                orte.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], this.getOrtAnordnung().toUpperCase().charAt(0)));
                                orte1.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[0]));
                                orte2.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[1]));
                                orte3.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[2]));
                                if (element[12].length() > 0) {
                                    abstand = Integer.parseInt(element[12]);
                                    String string = Grossstadt = abstand < this.getAbstandStadtGross() * 1000 ? element[11] : "";
                                }
                                if (element[14].length() > 0) {
                                    abstand = Integer.parseInt(element[14]);
                                    String string = MittlereStadt = abstand < this.getAbstandStadtMittel() * 1000 ? element[13] : "";
                                }
                                if (element[16].length() > 0) {
                                    abstand = Integer.parseInt(element[16]);
                                    Kleinstadt = abstand < this.getAbstandStadtKlein() * 1000 ? element[15] : "";
                                }
                                grossstadt.add(Grossstadt);
                                mittlereStadt.add(MittlereStadt);
                                kleinstadt.add(Kleinstadt);
                                kleinGgfMittlereStadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, "", "", "", ""));
                                kleinGgfMittlereGgfGrossstadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, "", "", ""));
                            } else if (element[5].startsWith("Pause, Beginn") || element[5].compareTo("Ende") == 0) {
                                orte.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], this.getOrtAnordnung().toUpperCase().charAt(0)));
                                orte1.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[0]));
                                orte2.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[1]));
                                orte3.add(GPS.formatiereOrtundOrtsteil(element[8], element[9], orteAnordung[2]));
                                if (element[12].length() > 0) {
                                    abstand = Integer.parseInt(element[12]);
                                    String string = Grossstadt = abstand < this.getAbstandStadtGross() * 1000 ? element[11] : "";
                                }
                                if (element[14].length() > 0) {
                                    abstand = Integer.parseInt(element[14]);
                                    String string = MittlereStadt = abstand < this.getAbstandStadtMittel() * 1000 ? element[13] : "";
                                }
                                if (element[16].length() > 0) {
                                    abstand = Integer.parseInt(element[16]);
                                    Kleinstadt = abstand < this.getAbstandStadtKlein() * 1000 ? element[15] : "";
                                }
                                grossstadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, element[8], element[9], element[10]));
                                mittlereStadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, element[8], element[9], element[10]));
                                kleinstadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, element[8], element[9], element[10]));
                                kleinGgfMittlereStadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, element[8], element[9], element[10]));
                                kleinGgfMittlereGgfGrossstadt.add(GPS.getErstenOrt(Kleinstadt, MittlereStadt, Grossstadt, element[8], element[9], element[10]));
                                etappen.add(String.valueOf(zeitpunkt.toGermanFormat('A').substring(0, 10)) + "\t" + zeitpunkt.toGermanFormat('A').substring(10) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(orte))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(orte1))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(orte2))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(orte3))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(grossstadt))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(mittlereStadt))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(kleinstadt))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(kleinGgfMittlereStadt))) + "\t" + GPS.formatiereOrte(FString.deleteDoppelte(FString.arrayListToStringArray(kleinGgfMittlereGgfGrossstadt))));
                                letzterZeitpunktString = zeitpunkt.toGermanFormat('A');
                                this.checkZeitpunkt(zeitpunkt, element[3], letzterZeitpunktString);
                                etappen.add(String.valueOf(zeitpunkt.toGermanFormat('A').substring(0, 10)) + "\t" + zeitpunkt.toGermanFormat('A').substring(10) + "\t" + GPS.formatiereOrtundOrtsteil(element[8], element[9], 'M') + (element[10].length() > 0 ? ", " + element[10] : "") + ": " + element[5].replaceAll("Pause, Beginn - \u00dcbernachtung", "\u00dcbernachtungsplatz").replaceAll("Pause, Beginn - ", ""));
                                if (element[5].endsWith("Siesta")) {
                                    siesta[0] = GPS.formatiereOrtundOrtsteil(element[8], element[9], 'M');
                                    siesta[1] = element[10];
                                }
                                if (element[5].endsWith("\u00dcbernachtung") || element[5].endsWith("Ende")) {
                                    reisetage.add(String.valueOf(zeitpunkt.toGermanFormat('A').substring(0, 10)) + "\t" + siesta[0] + "\t" + siesta[1] + "\t" + GPS.formatiereOrtundOrtsteil(element[8], element[9], 'M') + "\t" + element[10] + "\t");
                                    siesta[0] = "";
                                    siesta[1] = "";
                                }
                                letzterZeitpunktString = zeitpunkt.toGermanFormat('A');
                                orte.clear();
                                orte1.clear();
                                orte2.clear();
                                orte3.clear();
                                grossstadt.clear();
                                mittlereStadt.clear();
                                kleinstadt.clear();
                                kleinGgfMittlereStadt.clear();
                                kleinGgfMittlereGgfGrossstadt.clear();
                            }
                            if (element[5].length() > 0 && !element[5].startsWith("ignore")) {
                                ausgabeWork.add(FString.stringArrayToString(element, "\t"));
                                if (element[8].length() + element[9].length() == 0 && !element[5].startsWith("Pause, Ende") && element[5].compareTo("Start") != 0) {
                                    ++azFehlendeOrte;
                                }
                            }
                            ++n2;
                        }
                        new FFile(ausgabeEtappenDateiname).StringArrayListToInhalt(etappen, this.getCharsetAusgabe());
                        fProt.prot(String.valueOf(etappen.size()) + " Etappen in " + ausgabeEtappenDateiname + " erstellt");
                        new FFile(ausgabeReisetageDateiname).StringArrayListToInhalt(reisetage, this.getCharsetAusgabe());
                        fProt.prot(String.valueOf(reisetage.size()) + " Reisetage in " + ausgabeReisetageDateiname + " erstellt");
                        new FFile(ausgabeWorkDateiname).StringArrayListToInhalt(ausgabeWork, this.getCharsetAusgabe());
                        fProt.prot("Workdatei " + ausgabeWorkDateiname + " erstellt, " + azFehlendeOrte + " Orte fehlen");
                        if (this.getFunktion().compareTo("BW") == 0) {
                            FDatei.DateinamenTeile dateinameTeile = FDatei.instance().zerlegeDateiname(this.getEingabedatei());
                            this.setZusaetzlicheAusgabedatei(String.valueOf(dateinameTeile.getPfad()) + System.getProperty("file.separator") + dateinameTeile.getName() + ".txt");
                            new FFile(this.getZusaetzlicheAusgabedatei()).StringArrayToInhalt(FString.convertTabelleToStringArray(csv), this.getCharsetAusgabe());
                            NumberFormat nf = NumberFormat.getInstance();
                            nf.setMaximumFractionDigits(2);
                            nf.setMinimumFractionDigits(0);
                            nf.setGroupingUsed(true);
                            fProt.prot(String.valueOf(this.getZusaetzlicheAusgabedatei()) + " mit Zeit- und geometrischen Abstaenden fuer " + nf.format(csv.length) + " Trackpoints erstellt");
                        }
                    }
                }
            }
        }
    }

    private void extractPOI() {
        FDatei.DateinamenTeile dateinameEingabe = FDatei.instance().zerlegeDateiname(this.getEingabedatei());
        FProt fProt = FProt.instance();
        if (dateinameEingabe.getExtend().compareToIgnoreCase("gpx") != 0) {
            fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .gpx");
        } else {
            String[] gpx = new FFile(this.getEingabedatei()).inhaltToStringArray(this.getCharsetEingabe());
            ArrayList<String> poi = new ArrayList<String>();
            int azPOI = 0;
            FDatei.DateinamenTeile dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
            if (dateinameAusgabe.getExtend().compareToIgnoreCase("gpx") != 0) {
                this.setAusgabedatei(String.valueOf(this.getAusgabedatei()) + ".gpx");
            }
            poi.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            poi.add("<gpx version=\"1.1\" xmlns=\"http://www.topografix.com/GPX/1/1\" creator=\"de.nss.jfi\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
            boolean imWayPointBereich = false;
            String[] stringArray = gpx;
            int n = gpx.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (!imWayPointBereich && element.indexOf("<wpt") >= 0) {
                    imWayPointBereich = true;
                }
                if (imWayPointBereich) {
                    if (element.indexOf("<trk>") < 0) {
                        poi.add(element);
                        if (element.indexOf("</wpt>") > 0) {
                            ++azPOI;
                        }
                    } else {
                        imWayPointBereich = false;
                        break;
                    }
                }
                ++n2;
            }
            poi.add("</gpx>");
            if (poi.size() == 0) {
                fProt.prot(String.valueOf(this.getEingabedatei()) + " enthaelt keine POIs");
            } else {
                new FFile(this.getAusgabedatei()).StringArrayListToInhalt(poi, this.getCharsetAusgabe());
                FProt.instance().prot(String.valueOf(azPOI) + " POI in " + this.getAusgabedatei());
            }
        }
    }

    private void findAndMarkPause(String[][] csv, ArrayList<String> wayPoints) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FGregorianCalendar lastZeitpunkt = new FGregorianCalendar();
        FGregorianCalendar zeitpunkt = new FGregorianCalendar();
        FGregorianCalendar nextZeitpunkt = new FGregorianCalendar();
        int zeitDifferenzInMinuten = 0;
        if (this.getFunktion().compareToIgnoreCase("E3") == 0 || this.getFunktion().compareToIgnoreCase("GS") == 0 || this.getFunktion().compareToIgnoreCase("GGS") == 0 || this.getFunktion().compareToIgnoreCase("GGSH") == 0) {
            this.setFreistehendePunktePruefen(false);
        }
        boolean pauseAktiv = false;
        int posPauseBeginn = 0;
        csv[0][5] = "Start";
        if (wayPoints != null) {
            wayPoints.add(String.valueOf(FString.stringArrayToString(csv[0], "\t", 6)) + "\t1");
        }
        csv[csv.length - 1][5] = "Ende";
        int i = 0;
        while (i < csv.length) {
            if (i == 0) {
                try {
                    lastZeitpunkt.setTime(dateFormat.parse(csv[i][3].replace('T', ' ')));
                }
                catch (ParseException parseException) {}
            } else if (i == csv.length - 1) {
                try {
                    nextZeitpunkt.setTime(dateFormat.parse(csv[i][3].replace('T', ' ')));
                }
                catch (ParseException parseException) {}
            } else {
                csv[i][5] = "";
                try {
                    lastZeitpunkt.setTime(dateFormat.parse(csv[i - 1][3].replace('T', ' ')));
                    zeitpunkt.setTime(dateFormat.parse(csv[i][3].replace('T', ' ')));
                    nextZeitpunkt.setTime(dateFormat.parse(csv[i + 1][3].replace('T', ' ')));
                    zeitDifferenzInMinuten = (int)((zeitpunkt.getTimeInMillis() - lastZeitpunkt.getTimeInMillis()) / 60000L);
                }
                catch (Exception e) {
                    zeitDifferenzInMinuten = -1;
                }
                csv[i][7] = String.valueOf((zeitpunkt.getTimeInMillis() - lastZeitpunkt.getTimeInMillis()) / 1000L);
                if (zeitDifferenzInMinuten >= this.getBreakDauer()) {
                    if (!pauseAktiv) {
                        posPauseBeginn = i - 1;
                    }
                    if (this.isFreistehendePunktePruefen() && (int)((nextZeitpunkt.getTimeInMillis() - zeitpunkt.getTimeInMillis()) / 60000L) >= this.getBreakDauer()) {
                        csv[i][5] = "ignore";
                        FProt.instance().prot(String.valueOf(csv[i][0]) + ", " + csv[i][1] + ", " + csv[i][3] + ", ignoriert (zeitlich singulaerer Punkt)");
                        pauseAktiv = true;
                    } else {
                        String[] pausenart = this.getPausenart(lastZeitpunkt, zeitpunkt, wayPoints != null);
                        if (pausenart[1].compareTo(String.valueOf(this.getWaypoints())) <= 0 || pausenart[1].compareTo(String.valueOf(this.getPOIs())) <= 0) {
                            csv[posPauseBeginn][5] = "Pause, Beginn - " + pausenart[0];
                            if (wayPoints != null) {
                                wayPoints.add(String.valueOf(FString.stringArrayToString(csv[posPauseBeginn], "\t", 5)) + "\t" + FString.stringArrayToString(pausenart, "\t"));
                            }
                            csv[i][5] = "Pause, Ende - " + pausenart[0];
                            pauseAktiv = false;
                        }
                    }
                }
            }
            ++i;
        }
        if (wayPoints != null) {
            wayPoints.add(String.valueOf(FString.stringArrayToString(csv[csv.length - 1], "\t", 6)) + "\t1");
        }
        this.setFreistehendePunktePruefen(true);
    }

    public int getAbstandPunkte() {
        return this.AbstandPunkte;
    }

    private int getAbstandPunkteMeter() {
        return this.AbstandPunkteMeter;
    }

    public int getAbstandStadtGross() {
        return this.AbstandStadtGross;
    }

    public int getAbstandStadtKlein() {
        return this.AbstandStadtKlein;
    }

    public int getAbstandStadtMittel() {
        return this.AbstandStadtMittel;
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    private String getBeginnEnde(ArrayList<String> gpx) {
        String name = "";
        String bis = "";
        boolean inTrackPoint = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FGregorianCalendar zeit = new FGregorianCalendar();
        for (String element : gpx) {
            if (element.indexOf("<trkpt") > 0) {
                inTrackPoint = true;
            }
            if (!inTrackPoint || element.indexOf("<time>") <= 0) continue;
            try {
                zeit.setTime(dateFormat.parse(element.substring(element.indexOf("<time>") + 8, element.indexOf("<time>") + 28).replace('T', ' ')));
                zeit.add(10, this.getKorrekturZeitTrack());
                name = zeit.toGermanFormat('R');
            }
            catch (ParseException parseException) {}
            break;
        }
        inTrackPoint = false;
        int i = gpx.size() - 1;
        while (i >= 0) {
            if (gpx.get(i).indexOf("</trkpt") > 0) {
                inTrackPoint = true;
            }
            if (inTrackPoint && gpx.get(i).indexOf("<time>") > 0) {
                try {
                    zeit.setTime(dateFormat.parse(gpx.get(i).substring(gpx.get(i).indexOf("<time>") + 8, gpx.get(i).indexOf("<time>") + 28).replace('T', ' ')));
                    zeit.add(10, this.getKorrekturZeitTrack());
                    bis = zeit.toGermanFormat('R');
                }
                catch (ParseException parseException) {}
                break;
            }
            --i;
        }
        name = name.substring(0, 6).compareTo(bis.substring(0, 6)) == 0 ? String.valueOf(name) + bis.substring(6) : String.valueOf(name) + "_" + bis;
        return name;
    }

    public int getBreakDauer() {
        return this.BreakDauer;
    }

    public String getCharsetAusgabe() {
        return this.CharsetAusgabe;
    }

    public String getCharsetEingabe() {
        return this.CharsetEingabe;
    }

    public String getDBNameFotos() {
        return this.DBNameFotos;
    }

    public String getDBNameGeonames() {
        return this.DBNameGeonames;
    }

    public String getDBNameReisen() {
        return this.DBNameReisen;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String getEingabeverzeichnis() {
        return this.Eingabeverzeichnis;
    }

    private int getEinwohnerStadtGross() {
        return this.EinwohnerStadtGross;
    }

    public int getEinwohnerStadtGross10T() {
        return this.EinwohnerStadtGross10T;
    }

    private int getEinwohnerStadtKlein() {
        return this.EinwohnerStadtKlein;
    }

    public int getEinwohnerStadtKlein100() {
        return this.EinwohnerStadtKlein100;
    }

    private int getEinwohnerStadtMittel() {
        return this.EinwohnerStadtMittel;
    }

    public int getEinwohnerStadtMittel1T() {
        return this.EinwohnerStadtMittel1T;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    private void getGeoData() {
        FDatei.DateinamenTeile dateinameEingabe = FDatei.instance().zerlegeDateiname(this.getEingabedatei());
        FProt fProt = FProt.instance();
        if (dateinameEingabe.getExtend().compareToIgnoreCase("csv") != 0 && dateinameEingabe.getExtend().compareToIgnoreCase("txt") != 0) {
            fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .csv oder .txt");
        } else {
            this.setGeoDataAbSpalte(this.getGeoDataAbSpalteAbEins() - 1);
            String[][] csv = FString.convertStringArrayToTabelle(new FFile(this.getEingabedatei()).inhaltToStringArray(this.getCharsetEingabe()), 18 + this.getGeoDataAbSpalte(), "\t");
            if (csv.length == 0) {
                fProt.prot(String.valueOf(this.getEingabedatei()) + " enthaelt keine Punkte");
            } else {
                int azGot = 0;
                int i = 0;
                while (i < csv.length) {
                    if (this.isIgnoreGeoData() || csv[i][this.getGeoDataAbSpalte()].length() + csv[i][this.getGeoDataAbSpalte() + 1].length() + csv[i][this.getGeoDataAbSpalte() + 2].length() + csv[i][this.getGeoDataAbSpalte() + 3].length() == 0) {
                        String[] geoData = this.isGeonameOffline() ? Futi.getGeoDataOffline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), this.getEinwohnerStadtGross(), this.getAbstandStadtGross() * 1000, this.getEinwohnerStadtMittel(), this.getAbstandStadtMittel() * 1000, this.getEinwohnerStadtKlein(), this.getAbstandStadtKlein() * 1000, true, false) : Futi.getGeoDataOnline(Double.parseDouble(csv[i][0]), Double.parseDouble(csv[i][1]), this.getDBNameGeonames(), 1.0, false, this.getGeoDataArt().charAt(0), true, false);
                        int j = 0;
                        while (j < geoData.length) {
                            csv[i][this.getGeoDataAbSpalte() + j] = geoData[j];
                            ++j;
                        }
                        if (csv[i][this.getGeoDataAbSpalte()].length() + csv[i][this.getGeoDataAbSpalte() + 1].length() + csv[i][this.getGeoDataAbSpalte() + 2].length() + csv[i][this.getGeoDataAbSpalte() + 3].length() > 0) {
                            ++azGot;
                        }
                    }
                    ++i;
                }
                new FFile(this.getEingabedatei()).StringArrayToInhalt(FString.convertTabelleToStringArray(csv), this.getCharsetAusgabe());
                FProt.instance().prot(String.valueOf(csv.length) + " Points in " + this.getEingabedatei() + ", fuer " + azGot + " Points Geodaten geholt");
            }
        }
    }

    private int getGeoDataAbSpalte() {
        return this.GeoDataAbSpalte;
    }

    public int getGeoDataAbSpalteAbEins() {
        return this.GeoDataAbSpalteAbEins;
    }

    public String getGeoDataArt() {
        return this.GeoDataArt;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    private void getHoehe4CSVTracks() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        int hoeheGeaendert = 0;
        String hoeheAlt = "";
        FFile csv = new FFile(this.getEingabedatei());
        String[][] in = FString.convertStringArrayToTabelle(csv.inhaltToStringArray(), 4, true);
        int i = 0;
        while (i < in.length) {
            hoeheAlt = in[i][2];
            in[i][2] = Futi.getGeoHoehe(in[i][0], in[i][1], in[i][2], this.getFunktion().compareTo("HN") == 0, true, "Zeile " + i + ": ");
            if (hoeheAlt.compareTo(in[i][2]) != 0) {
                ++hoeheGeaendert;
            }
            ++i;
        }
        csv.StringArrayToInhalt(FString.convertTabelleToStringArray(in));
        FProt.instance().prot("Hoehe in " + nf.format(hoeheGeaendert) + " Trackpoints in " + this.getEingabedatei() + " angepasst");
    }

    public String getKommentarWaypoints() {
        return this.KommentarWaypoints;
    }

    private void getKoordinaten4CSVTracks() {
        FProt fProt = FProt.instance();
        String[][] in = FString.convertStringArrayToTabelle(new FFile(this.getEingabedatei()).inhaltToStringArray(this.getCharsetEingabe()), 9, true);
        String lastBreite = "";
        String lastLaenge = "";
        int koordGefunden = 0;
        int koordNichtGefunden = 0;
        int koordKopiert = 0;
        boolean forceGetAll = false;
        ArrayList<String> ausgabe = new ArrayList<String>();
        int i = 0;
        while (i < in.length) {
            if (in[i][0].trim().length() > 0 && in[i][1].trim().length() > 0 && in[i][7].trim().length() > 0) {
                ausgabe.add(String.valueOf(in[i][0]) + "\t" + in[i][1] + "\t0\t" + in[i][3].replace(" ", "T") + "\t0\t" + in[i][7] + " " + in[i][5] + " " + in[i][8] + " " + in[i][6]);
                ++koordKopiert;
            } else {
                String[] koord = Futi.getGeoKoordinaten(in[i][5].trim().replaceAll(" ", "%20"), in[i][4], "0.5", lastBreite, lastLaenge, "500");
                if (koord[0].length() + koord[1].length() == 0) {
                    fProt.prot(String.valueOf(in[i][5]) + ": keine Koordinaten gefunden");
                    ++koordNichtGefunden;
                } else {
                    fProt.prot(String.valueOf(koord[0]) + "\t" + koord[1] + "\t" + Futi.getGeoHoehe(koord[0], koord[1]) + "\t" + in[i][3] + "\t" + koord[2] + " " + koord[3] + " " + koord[4] + " " + koord[5]);
                    ausgabe.add(String.valueOf(koord[0]) + "\t" + koord[1] + "\t0\t" + in[i][3].replace(" ", "T") + "\t0\t" + koord[2] + " " + koord[3] + " " + koord[4] + " " + koord[5]);
                    ++koordGefunden;
                    in[i][0] = koord[0];
                    in[i][1] = koord[1];
                    in[i][6] = koord[5].replace(".", ",");
                    in[i][7] = koord[3];
                    in[i][8] = koord[4];
                    lastBreite = koord[0];
                    lastLaenge = koord[1];
                }
            }
            ++i;
        }
        new FFile(this.getEingabedatei()).StringArrayToInhalt(FString.convertTabelleToStringArray(in), this.getCharsetEingabe());
        new FFile(this.getAusgabedatei()).StringArrayListToInhalt(ausgabe, this.getCharsetAusgabe());
        fProt.prot(String.valueOf(ausgabe.size()) + " Trackpunkte aus " + this.getEingabedatei() + " (" + koordGefunden + " Koordinaten gefunden, " + koordKopiert + " kopiert) und in " + this.getAusgabedatei() + " geschrieben");
        if (koordNichtGefunden > 0) {
            fProt.prot("Zu " + koordNichtGefunden + " Trackpunkten aus " + this.getEingabedatei() + " keine Koordinaten gefunden");
        }
    }

    public int getKorrekturZeitPOI() {
        return this.KorrekturZeitPOI;
    }

    public int getKorrekturZeitTrack() {
        return this.KorrekturZeitTrack;
    }

    public String getMokkaBis() {
        return this.MokkaBis;
    }

    public String getMokkaVon() {
        return this.MokkaVon;
    }

    public String getOrtAnordnung() {
        return this.OrtAnordnung;
    }

    private char[] getOrteAnordnung() {
        char[] orteAnordnung = new char[]{' ', ' ', ' '};
        String alle = "OMTU";
        int pos = 0;
        int i = 0;
        while (i < "OMTU".length()) {
            if ("OMTU".substring(i, i + 1).compareToIgnoreCase(this.getOrtAnordnung()) != 0) {
                orteAnordnung[pos] = "OMTU".charAt(i);
                ++pos;
            }
            ++i;
        }
        return orteAnordnung;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    private String[] getPausenart(FGregorianCalendar letzterZeitpunkt, FGregorianCalendar zeitpunkt, boolean mitDauer) {
        String[] art = new String[]{"Pause", "4"};
        FGregorianCalendar zeitPunktCheck = new FGregorianCalendar(letzterZeitpunkt.getTimeInMillis() + (zeitpunkt.getTimeInMillis() - letzterZeitpunkt.getTimeInMillis()) / 2L);
        String zeitCheck = zeitPunktCheck.toGermanFormat('Y');
        if (zeitpunkt.toGermanFormat('C').compareTo(letzterZeitpunkt.toGermanFormat('C')) > 0) {
            art[0] = "\u00dcbernachtung";
            art[1] = "1";
        } else if (zeitCheck.compareTo(this.getSiestaVon()) >= 0 && zeitCheck.compareTo(this.getSiestaBis()) <= 0) {
            art[0] = this.isAllePause() ? "Pause" : "Siesta";
            art[1] = "2";
        } else if (zeitCheck.compareTo(this.getMokkaVon()) >= 0 && zeitCheck.compareTo(this.getMokkaBis()) <= 0) {
            art[0] = this.isAllePause() ? "Pause" : "Mokkatrinken";
            art[1] = "3";
        }
        if (mitDauer && art[1].compareTo("1") != 0) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setMinimumFractionDigits(0);
            art[0] = String.valueOf(art[0]) + " (" + nf.format((double)(zeitpunkt.getTimeInMillis() - letzterZeitpunkt.getTimeInMillis()) / 3600000.0) + "h)";
        }
        return art;
    }

    public int getPOIs() {
        return this.POIs;
    }

    public int getReduceFaktor() {
        return this.ReduceFaktor;
    }

    public int getRundenEtappe() {
        return this.RundenEtappe;
    }

    private int getRundenEtappeMinuten() {
        return this.RundenEtappeMinuten;
    }

    public int getRundenPOIs() {
        return this.RundenPOIs;
    }

    private int getRundenPOIsMinuten() {
        return this.RundenPOIsMinuten;
    }

    public String getSiestaBis() {
        return this.SiestaBis;
    }

    public String getSiestaVon() {
        return this.SiestaVon;
    }

    public String getStand() {
        return "19.12.2018";
    }

    public int getWaypoints() {
        return this.Waypoints;
    }

    private String getWetterDaten(String tag) {
        Statement DBStatement;
        ResultSet rs;
        String wetterDaten = "";
        if (this.getDBNameReisen().length() > 1 && (rs = FDB.executeQuery(DBStatement = FDB.createDBStatement(this.getDBNameReisen()), "SELECT Sonne,Regen,Temperatur, Tiefsttemperatur FROM Reisetag WHERE Tag = '" + tag + "'", true, 10)) != null) {
            try {
                if (!rs.isClosed()) {
                    wetterDaten = GPS.getWetterDatenFields(rs);
                } else {
                    rs = FDB.executeQuery(DBStatement, "SELECT Sonne,Regen,Temperatur, Tiefsttemperatur FROM Avanti_Tage WHERE Tag = '" + tag + "'", true, 10);
                    if (rs != null && !rs.isClosed()) {
                        wetterDaten = GPS.getWetterDatenFields(rs);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return wetterDaten;
    }

    public String getZusaetzlicheAusgabedatei() {
        return this.ZusaetzlicheAusgabedatei;
    }

    public boolean isAllePause() {
        return this.AllePause;
    }

    public boolean isCVSVerzeichnisNichtLeer() {
        return this.CVSVerzeichnisNichtLeer;
    }

    private boolean isFreistehendePunktePruefen() {
        return this.freistehendePunktePruefen;
    }

    public boolean isGeonameOffline() {
        return this.GeonameOffline;
    }

    public boolean isIgnoreGeoData() {
        return this.IgnoreGeoData;
    }

    public boolean isNichtUebernommeneProtokollieren() {
        return this.NichtUebernommeneProtokollieren;
    }

    public boolean isNoCVS() {
        return this.NoCVS;
    }

    public boolean isNoFreeStanding() {
        return this.NoFreeStanding;
    }

    public boolean isNoNullSpeed() {
        return this.NoNullSpeed;
    }

    public boolean isNoTimeStamp() {
        return this.NoTimeStamp;
    }

    public boolean isOnlyTimeStamp() {
        return this.OnlyTimeStamp;
    }

    public boolean isReduceTrackpoints() {
        return this.ReduceTrackpoints;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isSortTimeStamp() {
        return this.SortTimeStamp;
    }

    public void run() {
        this.setFunktion(this.getFunktion().toUpperCase());
        this.setAbstandPunkteMeter(this.getAbstandPunkte() * 100);
        this.setRundenPOIsMinuten(this.getRundenPOIs() * 5);
        this.setRundenEtappeMinuten(this.getRundenEtappe() * 5);
        this.setEinwohnerStadtGross(this.getEinwohnerStadtGross10T() * 10000);
        this.setEinwohnerStadtMittel(this.getEinwohnerStadtMittel1T() * 1000);
        this.setEinwohnerStadtKlein(this.getEinwohnerStadtKlein100() * 100);
        if (this.getWaypoints() > 0) {
            this.setSortTimeStamp(true);
        }
        if (this.isSortTimeStamp() || this.NoFreeStanding) {
            this.setOnlyTimeStamp(true);
        }
        switch (this.getFunktion().charAt(0)) {
            case 'C': 
            case 'M': {
                this.convertGPX2CSVOuterLoop();
                break;
            }
            case 'G': {
                if (this.getFunktion().length() > 1) {
                    FDatei.DateinamenTeile dateinameAusgabe;
                    if (this.getFunktion().toUpperCase().charAt(1) == 'V') {
                        this.convertCSV2GPXLoop();
                    }
                    if (this.getFunktion().toUpperCase().charAt(1) == 'S') {
                        this.convertCSV2GPX(this.getEingabedatei(), null, null, this.getAusgabedatei());
                    }
                    if (this.getFunktion().toUpperCase().charAt(1) != 'T' && this.getFunktion().toUpperCase().charAt(1) != 'G') break;
                    FProt fProt = FProt.instance();
                    if (!this.getAusgabedatei().endsWith(".gpx")) {
                        fProt.prot(String.valueOf(this.getAusgabedatei()) + " ist keine Datei mit Endung .gpx");
                        break;
                    }
                    if (this.getFunktion().toUpperCase().charAt(1) == 'T') {
                        dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
                        this.convertCSV2GPX(null, this.convertTKStar2CSV(this.getAusgabedatei().substring(0, this.getAusgabedatei().length() - 4)), dateinameAusgabe.getName(), this.getAusgabedatei());
                    }
                    if (this.getFunktion().toUpperCase().charAt(1) != 'G') break;
                    if (!this.getEingabedatei().endsWith(".gpx")) {
                        fProt.prot(String.valueOf(this.getEingabedatei()) + " ist keine Datei mit Endung .gpx");
                        break;
                    }
                    dateinameAusgabe = FDatei.instance().zerlegeDateiname(this.getAusgabedatei());
                    this.convertCSV2GPX(null, FString.arrayListToStringArray(this.convertGPX2CSVInnerLoop(new FFile(this.getEingabedatei()).inhaltToStringArrayList(this.getCharsetEingabe()))), dateinameAusgabe.getName(), this.getAusgabedatei());
                    break;
                }
                this.convertCSV2GPX(this.getEingabedatei(), null, null, this.getAusgabedatei());
                break;
            }
            case 'K': {
                this.convertKML();
                break;
            }
            case 'L': {
                this.convertLog();
                break;
            }
            case 'P': {
                this.extractPOI();
                break;
            }
            case 'O': {
                this.getGeoData();
                break;
            }
            case 'N': 
            case 'Q': 
            case 'R': 
            case 'T': {
                this.checkTrackName();
                break;
            }
            case 'B': {
                int saveWaypoints = this.getWaypoints();
                this.setWaypoints(4);
                this.createReisebericht();
                this.setWaypoints(saveWaypoints);
                break;
            }
            case 'H': {
                this.getHoehe4CSVTracks();
                break;
            }
            case 'W': {
                FFile gpxFile = new FFile(this.getEingabedatei());
                String[] gpxZeilen = gpxFile.inhaltToStringArray("UTF-8");
                int waypointCount = Futi.extraktWaypoints(gpxZeilen, gpxFile.getName(), this.getDBNameReisen())[1];
                gpxFile.StringArrayToInhalt(gpxZeilen, "UTF-8", true);
                FProt.instance().prot(String.valueOf(waypointCount) + " Waypoints aus " + this.Eingabedatei + " extrahiert");
                break;
            }
            case 'E': {
                if (this.getFunktion().length() <= 1) break;
                if (this.getFunktion().charAt(1) == '1') {
                    this.createCSVTrackAusEtappen();
                    break;
                }
                if (this.getFunktion().charAt(1) == '2') {
                    this.getKoordinaten4CSVTracks();
                    break;
                }
                if (this.getFunktion().charAt(1) != '3') break;
                this.getKoordinaten4CSVTracks();
                this.convertCSV2GPX(this.getAusgabedatei(), null, null, String.valueOf(this.getAusgabedatei().substring(0, this.getAusgabedatei().lastIndexOf("."))) + ".gpx");
                break;
            }
            case 'F': {
                this.createFotopausen();
                break;
            }
        }
    }

    public void setAbstandPunkte() {
        this.AbstandPunkte = FParam.getIntParameter("AbstandPunkte", this.ArgTab);
    }

    public void setAbstandPunkte(int abstandPunkte) {
        this.AbstandPunkte = FParam.checkIntParameter("AbstandPunkte", abstandPunkte, this.ArgTab);
    }

    public void setAbstandPunkte(String abstandPunkte) {
        this.AbstandPunkte = FParam.checkIntParameter("AbstandPunkte", abstandPunkte, this.ArgTab);
    }

    private void setAbstandPunkteMeter(int abstandPunkteMeter) {
        this.AbstandPunkteMeter = abstandPunkteMeter;
    }

    public void setAbstandStadtGross() {
        this.AbstandStadtGross = FParam.getIntParameter("AbstandStadtGross", this.ArgTab);
    }

    public void setAbstandStadtGross(int abstandCities15000) {
        this.AbstandStadtGross = FParam.checkIntParameter("AbstandStadtGross", abstandCities15000, this.ArgTab);
    }

    public void setAbstandStadtGross(String abstandStadtGross) {
        this.AbstandStadtGross = FParam.checkIntParameter("AbstandStadtGross", abstandStadtGross, this.ArgTab);
    }

    public void setAbstandStadtKlein() {
        this.AbstandStadtKlein = FParam.getIntParameter("AbstandStadtKlein", this.ArgTab);
    }

    public void setAbstandStadtKlein(int abstandStadtKlein) {
        this.AbstandStadtKlein = FParam.checkIntParameter("AbstandStadtKlein", abstandStadtKlein, this.ArgTab);
    }

    public void setAbstandStadtKlein(String abstandStadtKlein) {
        this.AbstandStadtKlein = FParam.checkIntParameter("AbstandStadtKlein", abstandStadtKlein, this.ArgTab);
    }

    public void setAbstandStadtMittel() {
        this.AbstandStadtMittel = FParam.getIntParameter("AbstandStadtMittel", this.ArgTab);
    }

    public void setAbstandStadtMittel(int abstandCities5000) {
        this.AbstandStadtMittel = FParam.checkIntParameter("AbstandStadtMittel", abstandCities5000, this.ArgTab);
    }

    public void setAbstandStadtMittel(String abstandStadtMittel) {
        this.AbstandStadtMittel = FParam.checkIntParameter("AbstandStadtMittel", abstandStadtMittel, this.ArgTab);
    }

    public void setAllePause() {
        this.AllePause = FParam.getBooleanParameter("AllePause", this.ArgTab);
    }

    public void setAllePause(boolean allePause) {
        this.AllePause = allePause;
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setBreakDauer() {
        this.BreakDauer = FParam.getIntParameter("BreakDauer", this.ArgTab);
    }

    public void setBreakDauer(int breakDauer) {
        this.BreakDauer = FParam.checkIntParameter("BreakDauer", breakDauer, this.ArgTab);
    }

    public void setBreakDauer(String breakDauer) {
        this.BreakDauer = FParam.checkIntParameter("BreakDauer", breakDauer, this.ArgTab);
    }

    public void setCharsetAusgabe() {
        this.CharsetAusgabe = FParam.getStringParameter("CharsetAusgabe", this.ArgTab);
    }

    public void setCharsetAusgabe(String charsetAusgabe) {
        this.CharsetAusgabe = FParam.checkStringParameter("CharsetAusgabe", charsetAusgabe, this.ArgTab);
    }

    public void setCharsetEingabe() {
        this.CharsetEingabe = FParam.getStringParameter("CharsetEingabe", this.ArgTab);
    }

    public void setCharsetEingabe(String charsetEingabe) {
        this.CharsetEingabe = FParam.checkStringParameter("CharsetEingabe", charsetEingabe, this.ArgTab);
    }

    public void setCVSVerzeichnisNichtLeer(boolean cVSVerzeichnisNichtLeer) {
        this.CVSVerzeichnisNichtLeer = cVSVerzeichnisNichtLeer;
    }

    public void setDBNameFotos() {
        this.DBNameFotos = FParam.getStringParameter("DBNameFotos", this.ArgTab);
    }

    public void setDBNameFotos(String dBNameFoto) {
        this.DBNameFotos = FParam.checkStringParameter("DBNameFotos", dBNameFoto, this.ArgTab);
    }

    public void setDBNameGeonames() {
        this.DBNameGeonames = FParam.getStringParameter("DBNameGeonames", this.ArgTab);
    }

    public void setDBNameGeonames(String dBName) {
        this.DBNameGeonames = FParam.checkStringParameter("DBNameGeonames", dBName, this.ArgTab);
    }

    public void setDBNameReisen() {
        this.DBNameReisen = FParam.getStringParameter("DBNameReisen", this.ArgTab);
    }

    public void setDBNameReisen(String dBNameReisen) {
        this.DBNameReisen = FParam.checkStringParameter("DBNameReisen", dBNameReisen, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setEingabeverzeichnis() {
        this.Eingabeverzeichnis = FParam.getStringParameter("Eingabeverzeichnis", this.ArgTab);
    }

    public void setEingabeverzeichnis(String eingabeverzeichnis) {
        this.Eingabeverzeichnis = FParam.checkStringParameter("Eingabeverzeichnis", eingabeverzeichnis, this.ArgTab);
    }

    private void setEinwohnerStadtGross(int einwohnerStadtGross) {
        this.EinwohnerStadtGross = einwohnerStadtGross;
    }

    public void setEinwohnerStadtGross10T() {
        this.EinwohnerStadtGross10T = FParam.getIntParameter("EinwohnerStadtGross10T", this.ArgTab);
    }

    public void setEinwohnerStadtGross10T(int EinwohnerStadtGross10T) {
        this.EinwohnerStadtGross10T = FParam.checkIntParameter("EinwohnerStadtGross10T", EinwohnerStadtGross10T, this.ArgTab);
    }

    public void setEinwohnerStadtGross10T(String einwohnerStadtGross10T) {
        this.EinwohnerStadtGross10T = FParam.checkIntParameter("EinwohnerStadtGross10T", einwohnerStadtGross10T, this.ArgTab);
    }

    private void setEinwohnerStadtKlein(int einwohnerStadtKlein) {
        this.EinwohnerStadtKlein = einwohnerStadtKlein;
    }

    public void setEinwohnerStadtKlein100() {
        this.EinwohnerStadtKlein100 = FParam.getIntParameter("EinwohnerStadtKlein100", this.ArgTab);
    }

    public void setEinwohnerStadtKlein100(int einwohnerStadtKlein100) {
        this.EinwohnerStadtKlein100 = FParam.checkIntParameter("EinwohnerStadtKlein100", einwohnerStadtKlein100, this.ArgTab);
    }

    public void setEinwohnerStadtKlein100(String einwohnerStadtKlein100) {
        this.EinwohnerStadtKlein100 = FParam.checkIntParameter("EinwohnerStadtKlein100", einwohnerStadtKlein100, this.ArgTab);
    }

    private void setEinwohnerStadtMittel(int einwohnerStadtMittel) {
        this.EinwohnerStadtMittel = einwohnerStadtMittel;
    }

    public void setEinwohnerStadtMittel1T() {
        this.EinwohnerStadtMittel1T = FParam.getIntParameter("EinwohnerStadtMittel1T", this.ArgTab);
    }

    public void setEinwohnerStadtMittel1T(int EinwohnerStadtMittel1T) {
        this.EinwohnerStadtMittel1T = FParam.checkIntParameter("EinwohnerStadtMittel1T", EinwohnerStadtMittel1T, this.ArgTab);
    }

    public void setEinwohnerStadtMittel1T(String einwohnerStadtMittel1T) {
        this.EinwohnerStadtMittel1T = FParam.checkIntParameter("EinwohnerStadtMittel1T", einwohnerStadtMittel1T, this.ArgTab);
    }

    private void setFreistehendePunktePruefen(boolean freistehendePunktePruefen) {
        this.freistehendePunktePruefen = freistehendePunktePruefen;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setGeoDataAbSpalte() {
        this.GeoDataAbSpalte = FParam.getIntParameter("GeoDataAbSpalte", this.ArgTab);
    }

    private void setGeoDataAbSpalte(int geoDataAbSpalte) {
        this.GeoDataAbSpalte = geoDataAbSpalte;
    }

    public void setGeoDataAbSpalte(String geoDataAbSpalte) {
        this.GeoDataAbSpalte = FParam.checkIntParameter("GeoDataAbSpalte", geoDataAbSpalte, this.ArgTab);
    }

    public void setGeoDataAbSpalteAbEins() {
        this.GeoDataAbSpalteAbEins = FParam.getIntParameter("GeoDataAbSpalteAbEins", this.ArgTab);
    }

    public void setGeoDataAbSpalteAbEins(int GeoDataAbSpalteAbEins) {
        this.GeoDataAbSpalteAbEins = FParam.checkIntParameter("GeoDataAbSpalteAbEins", GeoDataAbSpalteAbEins, this.ArgTab);
    }

    public void setGeoDataAbSpalteAbEins(String geoDataAbSpalteAbEins) {
        this.GeoDataAbSpalteAbEins = FParam.checkIntParameter("GeoDataAbSpalteAbEins", geoDataAbSpalteAbEins, this.ArgTab);
    }

    public void setGeoDataArt() {
        this.GeoDataArt = FParam.getStringParameter("GeoDataArt", this.ArgTab);
    }

    public void setGeoDataArt(String geoDataArt) {
        this.GeoDataArt = FParam.checkStringParameter("GeoDataArt", geoDataArt, this.ArgTab);
    }

    public void setGeonameOffline() {
        this.GeonameOffline = FParam.getBooleanParameter("GeonameOffline", this.ArgTab);
    }

    public void setGeonameOffline(boolean geonameOffline) {
        this.GeonameOffline = geonameOffline;
    }

    public void setIgnoreGeoData() {
        this.IgnoreGeoData = FParam.getBooleanParameter("IgnoreGeoData", this.ArgTab);
    }

    public void setIgnoreGeoData(boolean ignoreGeoData) {
        this.IgnoreGeoData = ignoreGeoData;
    }

    public void setKommentarWaypoints() {
        this.KommentarWaypoints = FParam.getStringParameter("KommentarWaypoints", this.ArgTab);
    }

    public void setKommentarWaypoints(String kommentarWaypoints) {
        this.KommentarWaypoints = FParam.checkStringParameter("KommentarWaypoints", kommentarWaypoints, this.ArgTab);
    }

    public void setKorrekturZeitPOI() {
        this.KorrekturZeitPOI = FParam.getIntParameter("KorrekturZeitPOI", this.ArgTab);
    }

    public void setKorrekturZeitPOI(int korrekturZeitPOI) {
        this.KorrekturZeitPOI = FParam.checkIntParameter("KorrekturZeitPOI", korrekturZeitPOI, this.ArgTab);
    }

    public void setKorrekturZeitPOI(String korrekturZeitPOI) {
        this.KorrekturZeitPOI = FParam.checkIntParameter("KorrekturZeitPOI", korrekturZeitPOI, this.ArgTab);
    }

    public void setKorrekturZeitTrack() {
        this.KorrekturZeitTrack = FParam.getIntParameter("KorrekturZeitTrack", this.ArgTab);
    }

    public void setKorrekturZeitTrack(int korrekturZeitTrack) {
        this.KorrekturZeitTrack = FParam.checkIntParameter("KorrekturZeitTrack", korrekturZeitTrack, this.ArgTab);
    }

    public void setKorrekturZeitTrack(String korrekturZeitTrack) {
        this.KorrekturZeitTrack = FParam.checkIntParameter("KorrekturZeitTrack", korrekturZeitTrack, this.ArgTab);
    }

    public void setMokkaBis() {
        this.MokkaBis = FParam.getTimeParameter("MokkaBis", this.ArgTab);
    }

    public void setMokkaBis(String mokkaBis) {
        this.MokkaBis = FParam.checkTimeParameter("MokkaBis", mokkaBis, this.ArgTab);
    }

    public void setMokkaBis(String mokkaBis, boolean umsetzen) {
        this.MokkaBis = FParam.checkTimeParameter("MokkaBis", mokkaBis, umsetzen, this.ArgTab);
    }

    public void setMokkaVon() {
        this.MokkaVon = FParam.getTimeParameter("MokkaVon", this.ArgTab);
    }

    public void setMokkaVon(String mokkaVon) {
        this.MokkaVon = FParam.checkTimeParameter("MokkaVon", mokkaVon, this.ArgTab);
    }

    public void setMokkaVon(String mokkaVon, boolean umsetzen) {
        this.MokkaVon = FParam.checkTimeParameter("MokkaVon", mokkaVon, umsetzen, this.ArgTab);
    }

    public void setNameGeoname() {
        this.DBNameGeonames = FParam.getStringParameter("DBNameGeonames", this.ArgTab);
    }

    public void setNichtUebernommeneProtokollieren() {
        this.NichtUebernommeneProtokollieren = FParam.getBooleanParameter("NichtUebernommeneProtokollieren", this.ArgTab);
    }

    public void setNichtUebernommeneProtokollieren(boolean nichtUebernommeneProtokollieren) {
        this.NichtUebernommeneProtokollieren = nichtUebernommeneProtokollieren;
    }

    public void setNoCVS() {
        this.NoCVS = FParam.getBooleanParameter("NoCVS", this.ArgTab);
    }

    public void setNoCVS(boolean noCVS) {
        this.NoCVS = noCVS;
    }

    public void setNoFreeStanding() {
        this.NoFreeStanding = FParam.getBooleanParameter("NoFreeStanding", this.ArgTab);
    }

    public void setNoFreeStanding(boolean noFreeStanding) {
        this.NoFreeStanding = noFreeStanding;
    }

    public void setNoNullSpeed() {
        this.NoNullSpeed = FParam.getBooleanParameter("NoNullSpeed", this.ArgTab);
    }

    public void setNoNullSpeed(boolean noNullSpeed) {
        this.NoNullSpeed = noNullSpeed;
    }

    public void setNoTimeStamp() {
        this.NoTimeStamp = FParam.getBooleanParameter("NoTimeStamp", this.ArgTab);
    }

    public void setNoTimeStamp(boolean noTimeStamp) {
        this.NoTimeStamp = noTimeStamp;
    }

    public void setOnlyTimeStamp() {
        this.OnlyTimeStamp = FParam.getBooleanParameter("OnlyTimeStamp", this.ArgTab);
    }

    public void setOnlyTimeStamp(boolean onlyTimeStamp) {
        this.OnlyTimeStamp = onlyTimeStamp;
    }

    public void setOrtAnordnung() {
        this.OrtAnordnung = FParam.getStringParameter("OrtAnordnung", this.ArgTab);
    }

    public void setOrtAnordnung(String ortAnordnung) {
        this.OrtAnordnung = FParam.checkStringParameter("OrtAnordnung", ortAnordnung, this.ArgTab);
    }

    public void setPOIs() {
        this.POIs = FParam.getIntParameter("POIs", this.ArgTab);
    }

    public void setPOIs(int pOIs) {
        this.POIs = FParam.checkIntParameter("POIs", pOIs, this.ArgTab);
    }

    public void setPOIs(String pOIs) {
        this.POIs = FParam.checkIntParameter("POIs", pOIs, this.ArgTab);
    }

    public void setReduceFaktor() {
        this.ReduceFaktor = FParam.getIntParameter("ReduceFaktor", this.ArgTab);
    }

    public void setReduceFaktor(int reduceFaktor) {
        this.ReduceFaktor = FParam.checkIntParameter("ReduceFaktor", reduceFaktor, this.ArgTab);
    }

    public void setReduceFaktor(String reduceFaktor) {
        this.ReduceFaktor = FParam.checkIntParameter("ReduceFaktor", reduceFaktor, this.ArgTab);
    }

    public void setReduceTrackpoints() {
        this.ReduceTrackpoints = FParam.getBooleanParameter("ReduceTrackpoints", this.ArgTab);
    }

    public void setReduceTrackpoints(boolean reduceTrackpoints) {
        this.ReduceTrackpoints = reduceTrackpoints;
    }

    public void setRundenEtappe() {
        this.RundenEtappe = FParam.getIntParameter("RundenEtappe", this.ArgTab);
    }

    public void setRundenEtappe(int rundenEtappe) {
        this.RundenEtappe = FParam.checkIntParameter("RundenEtappe", rundenEtappe, this.ArgTab);
    }

    public void setRundenEtappe(String rundenEtappe) {
        this.RundenEtappe = FParam.checkIntParameter("RundenEtappe", rundenEtappe, this.ArgTab);
    }

    private void setRundenEtappeMinuten(int rundenEtappeMinuten) {
        this.RundenEtappeMinuten = rundenEtappeMinuten;
    }

    public void setRundenPOIs() {
        this.RundenPOIs = FParam.getIntParameter("RundenPOIs", this.ArgTab);
    }

    public void setRundenPOIs(int rundenPOIs) {
        this.RundenPOIs = FParam.checkIntParameter("RundenPOIs", rundenPOIs, this.ArgTab);
    }

    public void setRundenPOIs(String rundenPOIs) {
        this.RundenPOIs = FParam.checkIntParameter("RundenPOIs", rundenPOIs, this.ArgTab);
    }

    private void setRundenPOIsMinuten(int rundenPOIsMinuten) {
        this.RundenPOIsMinuten = rundenPOIsMinuten;
    }

    public void setSiestaBis() {
        this.SiestaBis = FParam.getTimeParameter("SiestaBis", this.ArgTab);
    }

    public void setSiestaBis(String siestaBis) {
        this.SiestaBis = FParam.checkTimeParameter("SiestaBis", siestaBis, this.ArgTab);
    }

    public void setSiestaBis(String siestaBis, boolean umsetzen) {
        this.SiestaBis = FParam.checkTimeParameter("SiestaBis", siestaBis, umsetzen, this.ArgTab);
    }

    public void setSiestaVon() {
        this.SiestaVon = FParam.getTimeParameter("SiestaVon", this.ArgTab);
    }

    public void setSiestaVon(String siestaVon) {
        this.SiestaVon = FParam.checkTimeParameter("SiestaVon", siestaVon, this.ArgTab);
    }

    public void setSiestaVon(String siestaVon, boolean umsetzen) {
        this.SiestaVon = FParam.checkTimeParameter("SiestaVon", siestaVon, umsetzen, this.ArgTab);
    }

    public void setSortTimeStamp() {
        this.SortTimeStamp = FParam.getBooleanParameter("SortTimeStamp", this.ArgTab);
    }

    public void setSortTimeStamp(boolean sortTimeStamp) {
        this.SortTimeStamp = sortTimeStamp;
    }

    public void setWaypoints() {
        this.Waypoints = FParam.getIntParameter("Waypoints", this.ArgTab);
    }

    public void setWaypoints(int waypoints) {
        this.Waypoints = FParam.checkIntParameter("Waypoints", waypoints, this.ArgTab);
    }

    public void setWaypoints(String waypoints) {
        this.Waypoints = FParam.checkIntParameter("Waypoints", waypoints, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setEingabedatei();
        this.setCharsetEingabe();
        this.setEingabeverzeichnis();
        this.setAusgabedatei();
        this.setCharsetAusgabe();
        this.setDBNameGeonames();
        this.setGeonameOffline();
        this.setNoCVS();
        this.setNoTimeStamp();
        this.setNoNullSpeed();
        this.setNoFreeStanding();
        this.setNichtUebernommeneProtokollieren();
        this.setSortTimeStamp();
        this.setOnlyTimeStamp();
        this.setWaypoints();
        this.setPOIs();
        this.setRundenPOIs();
        this.setKommentarWaypoints();
        this.setKorrekturZeitTrack();
        this.setKorrekturZeitPOI();
        this.setReduceTrackpoints();
        this.setReduceFaktor();
        this.setAbstandPunkte();
        this.setDBNameFotos();
        this.setDBNameReisen();
        this.setBreakDauer();
        this.setSiestaVon();
        this.setSiestaBis();
        this.setMokkaVon();
        this.setMokkaBis();
        this.setAllePause();
        this.setRundenEtappe();
        this.setEinwohnerStadtGross10T();
        this.setAbstandStadtGross();
        this.setEinwohnerStadtMittel1T();
        this.setAbstandStadtMittel();
        this.setEinwohnerStadtKlein100();
        this.setAbstandStadtKlein();
        this.setOrtAnordnung();
        this.setGeoDataAbSpalteAbEins();
        this.setGeoDataArt();
        this.setIgnoreGeoData();
    }

    public void setZusaetzlicheAusgabedatei(String zusaetzlicheAusgabedatei) {
        this.ZusaetzlicheAusgabedatei = zusaetzlicheAusgabedatei;
    }

    private String[] skipNichtrelevante(String[] csv) {
        int azNoTime = 0;
        int azNoSpeed = 0;
        int azFreistehend = 0;
        ArrayList<String> work = new ArrayList<String>();
        ArrayList<String> del = new ArrayList<String>();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(0);
        nf.setGroupingUsed(true);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FGregorianCalendar zeit = new FGregorianCalendar();
        if (this.isNoNullSpeed() || this.isOnlyTimeStamp()) {
            long timeVgl2;
            long time;
            long timeVgl1;
            String[] teileVgl2;
            String[] teileVgl1;
            String[] teile;
            long abstand = 300000L;
            int i = 0;
            while (i < csv.length) {
                boolean punktUebernehmen = true;
                teile = csv[i].split("\t");
                if (this.isOnlyTimeStamp() && teile.length <= 3) {
                    punktUebernehmen = false;
                    del.add("kein Timestamp\t" + csv[i]);
                    ++azNoTime;
                }
                if (punktUebernehmen && this.isNoNullSpeed() && teile.length > 4 && teile[4].startsWith("0.0")) {
                    teileVgl1 = csv[i == 0 ? i + 1 : i - 1].split("\t");
                    teileVgl2 = csv[i == csv.length - 1 ? i - 1 : i + 1].split("\t");
                    if (teileVgl1.length > 3 && teileVgl2.length > 3) {
                        try {
                            zeit.setTime(dateTimeFormat.parse(teileVgl1[3].replace('T', ' ').replace('Z', ' ')));
                            timeVgl1 = zeit.getTimeInMillis();
                            zeit.setTime(dateTimeFormat.parse(teile[3].replace('T', ' ').replace('Z', ' ')));
                            time = zeit.getTimeInMillis();
                            zeit.setTime(dateTimeFormat.parse(teileVgl2[3].replace('T', ' ').replace('Z', ' ')));
                            timeVgl2 = zeit.getTimeInMillis();
                            if (Math.abs(time - timeVgl1) > abstand && Math.abs(timeVgl2 - time) > abstand) {
                                punktUebernehmen = false;
                                del.add("Speed=0.0 und im Abstand von 5 Minuten gibt es keine Punkte\t" + csv[i]);
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (punktUebernehmen && teileVgl1.length > 4 && teileVgl1[1].startsWith("0.0")) {
                        punktUebernehmen = false;
                        del.add("Speed=0.0 und Punkt mit Speed=0.0 geht voran\t" + csv[i]);
                    }
                    if (punktUebernehmen && teileVgl2.length > 4 && teileVgl2[4].startsWith("0.0")) {
                        punktUebernehmen = false;
                        del.add("Speed=0.0 und Punkt mit Speed=0.0 folgt\t" + csv[i]);
                    }
                    if (!punktUebernehmen) {
                        ++azNoSpeed;
                    }
                }
                if (punktUebernehmen) {
                    work.add(csv[i]);
                }
                ++i;
            }
            if (this.isNoFreeStanding() && work.size() > 2) {
                abstand = this.getBreakDauer() * 60000;
                i = 0;
                while (i < work.size()) {
                    teileVgl1 = ((String)work.get(i == 0 ? i + 1 : i - 1)).split("\t");
                    teile = ((String)work.get(i)).split("\t");
                    teileVgl2 = ((String)work.get(i == work.size() - 1 ? i - 1 : i + 1)).split("\t");
                    if (teileVgl1.length <= 3 || teileVgl2.length <= 3) continue;
                    try {
                        zeit.setTime(dateTimeFormat.parse(teileVgl1[3].replace('T', ' ').replace('Z', ' ')));
                        timeVgl1 = zeit.getTimeInMillis();
                        zeit.setTime(dateTimeFormat.parse(teile[3].replace('T', ' ').replace('Z', ' ')));
                        time = zeit.getTimeInMillis();
                        zeit.setTime(dateTimeFormat.parse(teileVgl2[3].replace('T', ' ').replace('Z', ' ')));
                        timeVgl2 = zeit.getTimeInMillis();
                        if (Math.abs(time - timeVgl1) > abstand && Math.abs(timeVgl2 - time) > abstand) {
                            del.add("freistehend (Abstand mehr als 1 Stunde)\t" + work.get(i));
                            work.remove(i);
                            ++azFreistehend;
                            continue;
                        }
                        ++i;
                    }
                    catch (ParseException e) {
                        ++i;
                    }
                }
            }
        }
        if (this.isNichtUebernommeneProtokollieren()) {
            FProt.instance().prot(del);
        }
        FProt.instance().prot(String.valueOf(nf.format(csv.length)) + " Punkte geprueft, " + nf.format(del.size()) + " Punkt" + (del.size() == 1 ? "" : "e") + " uebersprungen (Speed=0.0: " + nf.format(azNoSpeed) + ", freistehend: " + nf.format(azFreistehend) + ", Zeit fehlt: " + nf.format(azNoTime) + ")");
        return FString.arrayListToStringArray(work);
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Funktion                     :" + this.getFunktion());
        fProt.prot("Eingabedatei                 :" + this.getEingabedatei());
        fProt.prot("Charset Eingabe              :" + this.getCharsetEingabe());
        fProt.prot("Eingabeverzeichnis           :" + this.getEingabeverzeichnis());
        fProt.prot("Ausgabedatei                 :" + this.getAusgabedatei());
        fProt.prot("Charset Ausgabe              :" + this.getCharsetAusgabe());
        fProt.prot("Geonames-DB                  :" + this.getDBNameGeonames());
        fProt.prot("GeonamesOffline              :" + this.isGeonameOffline());
        fProt.prot("NoCVS                        :" + this.isNoCVS());
        fProt.prot("NoTimeStamp                  :" + this.isNoTimeStamp());
        fProt.prot("NoNullSpeed                  :" + this.isNoNullSpeed());
        fProt.prot("keine freistehenden Punkte   :" + this.isNoFreeStanding());
        fProt.prot("Protokoll Skip               :" + this.isNichtUebernommeneProtokollieren());
        fProt.prot("SortTimeStamp                :" + this.isSortTimeStamp());
        fProt.prot("OnlyTimeStamp                :" + this.isOnlyTimeStamp());
        fProt.prot("Waypoints                    :" + this.getWaypoints());
        fProt.prot("POIs                         :" + this.getPOIs());
        fProt.prot("RundenPOIs                   :" + this.getRundenPOIs());
        fProt.prot("Kommentar Wegpunkte          :" + this.getKommentarWaypoints());
        fProt.prot("Korrekturzeit Track          :" + this.getKorrekturZeitTrack());
        fProt.prot("Korrekturzeit POI            :" + this.getKorrekturZeitPOI());
        fProt.prot("Punkte reduzieren            :" + this.isReduceTrackpoints());
        fProt.prot("Punkte 1/Faktor reduzieren   :" + this.getReduceFaktor());
        fProt.prot("Abstand Punkte Ortswechsel   :" + this.getAbstandPunkte());
        fProt.prot("Foto-DB                      :" + this.getDBNameFotos());
        fProt.prot("Reisen-DB                    :" + this.getDBNameReisen());
        fProt.prot("Pausenlaenge                 :" + this.getBreakDauer());
        fProt.prot("SiestaVon                    :" + this.getSiestaVon());
        fProt.prot("SiestaBis                    :" + this.getSiestaBis());
        fProt.prot("MokkaVon                     :" + this.getMokkaVon());
        fProt.prot("MokkaBis                     :" + this.getMokkaBis());
        fProt.prot("Siesta und Mokka ist Pause   :" + this.isAllePause());
        fProt.prot("Runden Etappe                :" + this.getRundenEtappe());
        fProt.prot("Einw. Grossstadt             :" + this.getEinwohnerStadtGross10T());
        fProt.prot("Abst. Grossstadt             :" + this.getAbstandStadtGross());
        fProt.prot("Einw. Stadt mittel           :" + this.getEinwohnerStadtMittel1T());
        fProt.prot("Abst. Stadt mittel           :" + this.getAbstandStadtMittel());
        fProt.prot("Einw. Kleinstadt             :" + this.getEinwohnerStadtKlein100());
        fProt.prot("Abst. Stadt klein            :" + this.getAbstandStadtKlein());
        fProt.prot("Anordnung Ort und Ortsteil   :" + this.getOrtAnordnung());
        fProt.prot("Ortsdaten ab Spalte          :" + this.getGeoDataAbSpalteAbEins());
        fProt.prot("GeoData Art                  :" + this.getGeoDataArt());
        fProt.prot("Ignoriere vorhandene Geodaten:" + this.isIgnoreGeoData());
    }

    private class SygicKml {
        private String[] teile;
        private String start = "";
        private String ziel = "";
        private String startTimeString = "";
        private String startTimeFormatiert = "";
        private long startTime = 0L;
        private boolean startValid = false;
        private String logDurationString = "";
        private String logDurationFormatiert = "";
        private long logDuration = 0L;
        private long endTime = 0L;
        private boolean endValid = false;
        private String endTimeFormatiert = "";
        private String distance = "";
        private String maxSpeed = "";
        private String avgSpeed = "";
        private double lon = 0.0;
        private double lat = 0.0;
        private String alt = "";
        private String time = "";
        private int startPoints = 0;
        private int endePoints = 0;
        private final FGregorianCalendar zeit = new FGregorianCalendar();
        private boolean rewriteKmlfile = false;
        private double lastTrackLastLat = -999.0;
        private double lastTrackLastLon = -999.0;
        private double startLat = 0.0;
        private double startLon = 0.0;
        private double firstLat = 0.0;
        private double firstLon = 0.0;
        private String lastTrackZiel = "-";
        private double abstandZuZielLastTrack = 0.0;
        private double abstandZuLastPointLastTrack = 0.0;
        private double abstandFirstPointZuStartPoint = 0.0;
        private double abstandFirstPointZuLastPointLastTrack = 0.0;

        SygicKml() {
            this.init();
        }

        private double getAbstandFirstPointZuLastPointLastTrack() {
            return this.abstandFirstPointZuLastPointLastTrack;
        }

        private double getAbstandFirstPointZuStartPoint() {
            return this.abstandFirstPointZuStartPoint;
        }

        private double getAbstandZuLastPointLastTrack() {
            return this.abstandZuLastPointLastTrack;
        }

        private double getAbstandZuZielLastTrack() {
            return this.abstandZuZielLastTrack;
        }

        private String getAlt() {
            return this.alt;
        }

        String getAvgSpeed() {
            return this.avgSpeed;
        }

        String getDistance() {
            return this.distance;
        }

        int getEndePoints() {
            return this.endePoints;
        }

        long getEndTime() {
            return this.endTime;
        }

        String getEndTimeFormatiert() {
            return this.endTimeFormatiert;
        }

        private double getFirstLat() {
            return this.firstLat;
        }

        private double getFirstLon() {
            return this.firstLon;
        }

        boolean getHeader(ArrayList<String> kml, String kmlfile, String[] kmlfilenames, int kmlfilenamesPos) {
            FProt fProt = FProt.instance();
            boolean KmlfileHatPunkte = false;
            this.setAzPoints(kml);
            if (this.getEndePoints() <= this.getStartPoints()) {
                fProt.prot(String.valueOf(kmlfile) + " enthaelt keine Punkte");
            } else {
                KmlfileHatPunkte = true;
                if (GPS.this.getFunktion().compareTo("KX") == 0 || GPS.this.getFunktion().compareTo("MV") == 0 || GPS.this.getFunktion().compareTo("KT") == 0) {
                    String timestamp = kmlfile.substring(0, 11);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd_HHmm");
                    try {
                        this.getZeit().setTime(dateFormat.parse(timestamp));
                        this.setStartTime(this.getZeit().getTimeInMillis());
                        this.setStartTimeFormatiert(this.getZeit().toGermanFormat());
                        this.setStartValid(true);
                        timestamp = String.valueOf(kmlfile.substring(0, 7)) + kmlfile.substring(12, 16);
                        this.getZeit().setTime(dateFormat.parse(timestamp));
                        this.setEndTime(this.getZeit().getTimeInMillis());
                        this.setEndTimeFormatiert(this.getZeit().toGermanFormat());
                        this.setEndValid(true);
                        this.setLogDuration(this.getEndTime() - this.getStartTime());
                        this.setLogDurationFormatiert(Futi.formatDauerMilliSeconds(this.getStartTime(), this.getEndTime(), 'D'));
                    }
                    catch (ParseException parseException) {}
                } else {
                    String beginnCheck = "";
                    String dauerCheck = "";
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    SimpleDateFormat endeMaxFormat = new SimpleDateFormat("yyMMdd_HHmmss");
                    long endeMax = 0L;
                    int zPos = 0;
                    int posLatLon = 0;
                    for (String element : kml) {
                        if (element.startsWith("<tr><td>Date</td><td>") && element.length() > 42) {
                            this.setStartTimeString(element.substring(21, 40));
                            beginnCheck = String.valueOf(kmlfile.substring(4, 6)) + "." + kmlfile.substring(2, 4) + ".20" + kmlfile.substring(0, 2) + " " + kmlfile.substring(7, 9) + ":" + kmlfile.substring(9, 11) + ":" + kmlfile.substring(11, 13);
                            if (this.getStartTimeString().compareTo(beginnCheck) != 0) {
                                fProt.prot(String.valueOf(kmlfile) + " Beginn von " + this.getStartTimeString() + " auf " + beginnCheck + " korrigiert");
                                this.setStartTimeString(beginnCheck);
                                kml.set(zPos, "<tr><td>Date</td><td>" + this.getStartTimeString() + "</td></tr>");
                                this.setRewriteKmlfile(true);
                            }
                            try {
                                this.getZeit().setTime(dateFormat.parse(this.getStartTimeString()));
                                this.setStartTime(this.getZeit().getTimeInMillis());
                                this.setStartTimeFormatiert(this.getZeit().toGermanFormat());
                                this.setStartValid(true);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (element.startsWith("<tr><td>Duration</td><td>") && element.length() > 26) {
                            dauerCheck = element.substring(25);
                            if (dauerCheck.startsWith("<")) {
                                fProt.prot(String.valueOf(kmlfile) + " Dauer von " + dauerCheck.split("</td></tr>")[0] + " auf " + dauerCheck.substring(1).split("</td></tr>")[0] + " korrigiert");
                                dauerCheck = dauerCheck.substring(1);
                                kml.set(zPos, "<tr><td>Duration</td><td>" + dauerCheck);
                                this.setRewriteKmlfile(true);
                            }
                            this.setTeile(dauerCheck.split("<"));
                            if (this.getTeile().length > 0) {
                                this.setLogDurationString(this.getTeile()[0]);
                                this.setTeile(this.getLogDurationString().split(" "));
                                if (this.getTeile().length > 0 && this.isStartValid()) {
                                    this.getZeit().setTimeInMillis(this.getStartTime());
                                    String[] stringArray = this.getTeile();
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String element2 = stringArray[n2];
                                        if (element2.endsWith("s")) {
                                            this.getZeit().add(13, Integer.parseInt(element2.substring(0, element2.length() - 1)));
                                        } else if (element2.endsWith("m")) {
                                            this.getZeit().add(12, Integer.parseInt(element2.substring(0, element2.length() - 1)));
                                        } else if (element2.endsWith("min")) {
                                            this.getZeit().add(12, Integer.parseInt(element2.substring(0, element2.length() - 3)));
                                        } else if (element2.endsWith("h")) {
                                            this.getZeit().add(10, Integer.parseInt(element2.substring(0, element2.length() - 1)));
                                        } else {
                                            fProt.prot(String.valueOf(kmlfile) + "; Zeiteinheit: " + element2 + " unbekannt.");
                                        }
                                        ++n2;
                                    }
                                    this.setEndTime(this.getZeit().getTimeInMillis());
                                    try {
                                        endeMax = endeMaxFormat.parse(kmlfilenames[kmlfilenamesPos + 1].substring(0, 17)).getTime();
                                    }
                                    catch (Exception e) {
                                        endeMax = this.getEndTime() + 216000000L;
                                    }
                                    if (this.getEndTime() > this.getStartTime() && this.getEndTime() <= endeMax) {
                                        this.setEndValid(true);
                                    } else {
                                        this.setEndValid(true);
                                        if (this.getEndTime() > endeMax) {
                                            this.setEndTime(endeMax);
                                        } else {
                                            this.setEndTime(Math.min(this.getStartTime() + (long)((this.getEndePoints() - this.getStartPoints()) * 3000), endeMax));
                                        }
                                        fProt.prot(String.valueOf(kmlfile) + " Dauer von " + this.getLogDurationFormatiert() + " auf " + Futi.formatDauerMilliSeconds(this.getStartTime(), this.getEndTime()) + " korrigiert");
                                        kml.set(zPos, "<tr><td>Duration</td><td>" + Futi.formatDauerMilliSeconds(this.getStartTime(), this.getEndTime()) + "</td></tr>");
                                        this.setRewriteKmlfile(true);
                                    }
                                    this.setEndTimeFormatiert(this.getZeit().toGermanFormat());
                                    this.setLogDuration(this.getEndTime() - this.getStartTime());
                                    this.setLogDurationFormatiert(Futi.formatDauerMilliSeconds(this.getStartTime(), this.getEndTime(), 'D'));
                                }
                            }
                        }
                        if (element.startsWith("<tr><td>Start</td><td>") && element.length() > 23) {
                            this.setTeile(element.substring(22).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setStart(this.getTeile()[0]);
                            }
                        }
                        if (element.startsWith("<tr><td>End</td><td>") && element.length() > 21) {
                            this.setTeile(element.substring(20).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setZiel(this.getTeile()[0]);
                            }
                        }
                        if (element.startsWith("<tr><td>Distance</td><td>") && element.length() > 26) {
                            this.setTeile(element.substring(25).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setDistance(this.getTeile()[0].replace('.', ','));
                                if (this.getDistance().endsWith("km")) {
                                    this.setDistance(this.getDistance().substring(0, this.getDistance().length() - 2));
                                } else {
                                    this.setDistance(this.getDistance().substring(0, this.getDistance().length() - 1));
                                    if (this.getDistance().length() == 1) {
                                        this.setDistance("0,00" + this.getDistance());
                                    } else if (this.getDistance().length() == 2) {
                                        this.setDistance("0,0" + this.getDistance());
                                    } else if (this.getDistance().length() == 3) {
                                        this.setDistance("0," + this.getDistance());
                                    }
                                }
                            }
                        }
                        if (element.startsWith("<tr><td>Max speed</td><td>") && element.length() > 27) {
                            this.setTeile(element.substring(26).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setMaxSpeed(this.getTeile()[0].replaceFirst("km/h", ""));
                            }
                        }
                        if (element.startsWith("<tr><td>Average speed</td><td>") && element.length() > 31) {
                            this.setTeile(element.substring(30).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setAvgSpeed(this.getTeile()[0].replaceFirst("km/h", ""));
                            }
                        }
                        if (element.indexOf("<longitude>") >= 0) {
                            posLatLon = element.indexOf("<longitude>") + 11;
                            this.setTeile(element.substring(posLatLon).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setStartLon(Double.parseDouble(this.getTeile()[0]));
                            }
                        }
                        if (element.indexOf("<latitude>") >= 0) {
                            posLatLon = element.indexOf("<latitude>") + 10;
                            this.setTeile(element.substring(posLatLon).split("<"));
                            if (this.getTeile().length > 0) {
                                this.setStartLat(Double.parseDouble(this.getTeile()[0]));
                            }
                        }
                        if (element.indexOf("<coordinates>") >= 0) {
                            this.setAbstandZuLastPointLastTrack(this.getLastTrackLastLat() >= -180.0 ? Distance.distance(this.getLastTrackLastLat(), this.getLastTrackLastLon(), this.getStartLat(), this.getStartLon(), 'K', 6) : 0.0);
                            this.setAbstandZuZielLastTrack(Fuzzy.similarity(this.getLastTrackZiel(), this.getStart()));
                            break;
                        }
                        ++zPos;
                    }
                }
            }
            return KmlfileHatPunkte;
        }

        private double getLastTrackLastLat() {
            return this.lastTrackLastLat;
        }

        private double getLastTrackLastLon() {
            return this.lastTrackLastLon;
        }

        private String getLastTrackZiel() {
            return this.lastTrackZiel;
        }

        double getLat() {
            return this.lat;
        }

        long getLogDuration() {
            return this.logDuration;
        }

        String getLogDurationFormatiert() {
            return this.logDurationFormatiert;
        }

        String getLogDurationString() {
            return this.logDurationString;
        }

        double getLon() {
            return this.lon;
        }

        String getMaxSpeed() {
            return this.maxSpeed;
        }

        boolean getPoint(String element, int pos) {
            this.initPoint();
            boolean pointVorhanden = false;
            this.setTeile(element.split(","));
            if (this.getTeile().length > 1) {
                this.setLat(Double.parseDouble(this.getTeile()[1]));
                this.setLon(Double.parseDouble(this.getTeile()[0]));
                pointVorhanden = true;
                if (pos == 0) {
                    this.setFirstLat(this.getLat());
                    this.setFirstLon(this.getLon());
                }
            }
            this.setAlt(this.getTeile().length > 2 ? this.getTeile()[2] : "");
            if (this.isStartValid() && this.isEndValid()) {
                this.getZeit().setTimeInMillis(this.getStartTime());
                this.getZeit().add(14, (int)((long)((double)((long)pos * this.getLogDuration()) * 1.0) / (long)(this.getEndePoints() - this.getStartPoints())));
                this.setTime(this.getZeit().toGermanFormat('G'));
            }
            return pointVorhanden;
        }

        String getStart() {
            return this.start;
        }

        double getStartLat() {
            return this.startLat;
        }

        double getStartLon() {
            return this.startLon;
        }

        int getStartPoints() {
            return this.startPoints;
        }

        long getStartTime() {
            return this.startTime;
        }

        String getStartTimeFormatiert() {
            return this.startTimeFormatiert;
        }

        String getStartTimeString() {
            return this.startTimeString;
        }

        private String[] getTeile() {
            return this.teile;
        }

        private String getTime() {
            return this.time;
        }

        String getZeile() {
            return this.getZeile("\t");
        }

        String getZeile(String sep) {
            return String.valueOf(this.getLat()) + sep + this.getLon() + sep + this.getAlt() + sep + this.getTime();
        }

        private FGregorianCalendar getZeit() {
            return this.zeit;
        }

        String getZiel() {
            return this.ziel;
        }

        void init() {
            this.setStart("unbekannt");
            this.setZiel("unbekannt");
            this.setDistance("unbekannt");
            this.setMaxSpeed("unbekannt");
            this.setAvgSpeed("unbekannt");
            this.setStartTimeString("");
            this.setLogDurationFormatiert("");
            this.setStartValid(false);
            this.setEndValid(false);
        }

        void initPoint() {
            this.setLon(-999.0);
            this.setLat(-999.0);
            this.setAlt("");
            this.setTime("");
        }

        boolean isEndValid() {
            return this.endValid;
        }

        boolean isRewriteKmlfile() {
            return this.rewriteKmlfile;
        }

        boolean isStartValid() {
            return this.startValid;
        }

        String[] printSteuerung(boolean kurz, boolean mitHeader, boolean nurHeader) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            nf.setMinimumFractionDigits(3);
            NumberFormat latLon = NumberFormat.getInstance();
            latLon.setMaximumFractionDigits(8);
            latLon.setMinimumFractionDigits(8);
            this.setAbstandFirstPointZuStartPoint(Distance.distance(this.getFirstLat(), this.getFirstLon(), this.getStartLat(), this.getStartLon(), 'K', 6));
            this.setAbstandFirstPointZuLastPointLastTrack(Distance.distance(this.getLastTrackLastLat(), this.getLastTrackLastLon(), this.getFirstLat(), this.getFirstLon(), 'K', 6));
            ArrayList<String> aus = new ArrayList<String>();
            aus.add(String.valueOf(mitHeader ? "Start            :" : "") + (nurHeader ? "" : this.getStart()));
            aus.add(String.valueOf(mitHeader ? "Ziel             :" : "") + (nurHeader ? "" : this.getZiel()));
            aus.add(String.valueOf(mitHeader ? "ZielDetail       :" : "") + (nurHeader ? "" : "-"));
            aus.add(String.valueOf(mitHeader ? "StartTime        :" : "") + (nurHeader ? "" : this.getStartTimeFormatiert()));
            aus.add(String.valueOf(mitHeader ? "EndeTime         :" : "") + (nurHeader ? "" : this.getEndTimeFormatiert()));
            aus.add(String.valueOf(mitHeader ? "LogDuration      :" : "") + (nurHeader ? "" : this.getLogDurationFormatiert()));
            aus.add(String.valueOf(mitHeader ? "LastTrackLastLon :" : "") + (nurHeader ? "" : latLon.format(this.getLastTrackLastLon())));
            aus.add(String.valueOf(mitHeader ? "LastTrackLastLat :" : "") + (nurHeader ? "" : latLon.format(this.getLastTrackLastLat())));
            aus.add(String.valueOf(mitHeader ? "FirstLon         :" : "") + (nurHeader ? "" : latLon.format(this.getFirstLon())));
            aus.add(String.valueOf(mitHeader ? "FirstLat         :" : "") + (nurHeader ? "" : latLon.format(this.getFirstLat())));
            aus.add(String.valueOf(mitHeader ? "First2LastTrackPt:" : "") + (nurHeader ? "" : nf.format(this.getAbstandFirstPointZuLastPointLastTrack())));
            aus.add(String.valueOf(mitHeader ? "PointCount       :" : "") + (nurHeader ? "" : "" + (this.getEndePoints() - this.getStartPoints() + 1)));
            aus.add(String.valueOf(mitHeader ? "Distance         :" : "") + (nurHeader ? "" : this.getDistance()));
            aus.add(String.valueOf(mitHeader ? "AverageSpeed     :" : "") + (nurHeader ? "" : this.getAvgSpeed()));
            aus.add(String.valueOf(mitHeader ? "MaxSpeed         :" : "") + (nurHeader ? "" : this.getMaxSpeed()));
            if (!kurz) {
                aus.add(String.valueOf(mitHeader ? "LastTrackZiel    :" : "") + (nurHeader ? "" : this.getLastTrackZiel()));
                aus.add(String.valueOf(mitHeader ? "Abst.2LastTrackTx:" : "") + (nurHeader ? "" : nf.format(this.getAbstandZuZielLastTrack())));
                aus.add(String.valueOf(mitHeader ? "StartTimeString  :" : "") + (nurHeader ? "" : this.getStartTimeString()));
                aus.add(String.valueOf(mitHeader ? "StartLon         :" : "") + (nurHeader ? "" : latLon.format(this.getStartLon())));
                aus.add(String.valueOf(mitHeader ? "StartLat         :" : "") + (nurHeader ? "" : latLon.format(this.getStartLat())));
                aus.add(String.valueOf(mitHeader ? "LastLon          :" : "") + (nurHeader ? "" : latLon.format(this.getLon())));
                aus.add(String.valueOf(mitHeader ? "LastLat          :" : "") + (nurHeader ? "" : latLon.format(this.getLat())));
                aus.add(String.valueOf(mitHeader ? "Start2LastTrackPt:" : "") + (nurHeader ? "" : nf.format(this.getAbstandZuLastPointLastTrack())));
                aus.add(String.valueOf(mitHeader ? "First2StartPoint :" : "") + (nurHeader ? "" : nf.format(this.getAbstandFirstPointZuStartPoint())));
            }
            return FString.arrayListToStringArray(aus);
        }

        private void setAbstandFirstPointZuLastPointLastTrack(double abstandFirstPointZuLastPointLastTrack) {
            this.abstandFirstPointZuLastPointLastTrack = abstandFirstPointZuLastPointLastTrack;
        }

        private void setAbstandFirstPointZuStartPoint(double abstandFirstPointZuStartPoint) {
            this.abstandFirstPointZuStartPoint = abstandFirstPointZuStartPoint;
        }

        private void setAbstandZuLastPointLastTrack(double abstandZuLastPointLastTrack) {
            this.abstandZuLastPointLastTrack = abstandZuLastPointLastTrack;
        }

        private void setAbstandZuZielLastTrack(double abstandZuZielLastTrack) {
            this.abstandZuZielLastTrack = abstandZuZielLastTrack;
        }

        private void setAlt(String alt) {
            this.alt = alt;
        }

        private void setAvgSpeed(String avgSpeed) {
            this.avgSpeed = avgSpeed;
        }

        void setAzPoints(ArrayList<String> zeile) {
            if (GPS.this.getFunktion().compareTo("KX") == 0 || GPS.this.getFunktion().compareTo("MV") == 0 || GPS.this.getFunktion().compareTo("KT") == 0) {
                this.setStartPoints(0);
                this.setEndePoints(zeile.size() - 1);
            } else {
                int i = 0;
                while (i < zeile.size()) {
                    if (zeile.get(i).indexOf("<coordinates>") >= 0) {
                        this.setStartPoints(i + 1);
                    }
                    if (zeile.get(i).indexOf("</coordinates>") >= 0) {
                        this.setEndePoints(i - 1);
                    }
                    ++i;
                }
            }
        }

        private void setDistance(String distanz) {
            this.distance = distanz;
        }

        void setEndePoints(int endePoints) {
            this.endePoints = endePoints;
        }

        void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        void setEndTimeFormatiert(String endeFormatiert) {
            this.endTimeFormatiert = endeFormatiert;
        }

        private void setEndValid(boolean endeValid) {
            this.endValid = endeValid;
        }

        private void setFirstLat(double firstLat) {
            this.firstLat = firstLat;
        }

        private void setFirstLon(double firstLon) {
            this.firstLon = firstLon;
        }

        void setLastTrackLastLat(double lastTrackLastLat) {
            this.lastTrackLastLat = lastTrackLastLat;
        }

        void setLastTrackLastLon(double lastTrackLastLon) {
            this.lastTrackLastLon = lastTrackLastLon;
        }

        void setLastTrackZiel(String lastTrackZiel) {
            this.lastTrackZiel = lastTrackZiel;
        }

        private void setLat(double lat) {
            this.lat = lat;
        }

        private void setLogDuration(long dauer) {
            this.logDuration = dauer;
        }

        private void setLogDurationFormatiert(String dauerFormatiert) {
            this.logDurationFormatiert = dauerFormatiert;
        }

        void setLogDurationString(String logDurationString) {
            this.logDurationString = logDurationString;
        }

        private void setLon(double lon) {
            this.lon = lon;
        }

        private void setMaxSpeed(String maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        void setRewriteKmlfile(boolean rewriteKmlfile) {
            this.rewriteKmlfile = rewriteKmlfile;
        }

        private void setStart(String startPunkt) {
            this.start = startPunkt;
        }

        void setStartLat(double startLat) {
            this.startLat = startLat;
        }

        void setStartLon(double startLon) {
            this.startLon = startLon;
        }

        void setStartPoints(int startPoints) {
            this.startPoints = startPoints;
        }

        private void setStartTime(long start) {
            this.startTime = start;
        }

        private void setStartTimeFormatiert(String time) {
            this.startTimeFormatiert = time;
        }

        void setStartTimeString(String startTimeString) {
            this.startTimeString = startTimeString;
        }

        private void setStartValid(boolean startValid) {
            this.startValid = startValid;
        }

        private void setTeile(String[] teile) {
            this.teile = teile;
        }

        private void setTime(String time) {
            this.time = time;
        }

        private void setZiel(String ziel) {
            this.ziel = ziel;
        }
    }

    private class SygicLog {
        private String version = "";
        private long favorite = 0L;
        private String logType = "";
        private long logDuration = 0L;
        private long logLength = 0L;
        private long lastMarkDistance = 0L;
        private String start = "";
        private String ziel = "";
        private String startTimeString = "";
        private String zielDetail = "-";
        private double startLon = 0.0;
        private double startLat = 0.0;
        private long pointCount = 0L;
        private long startTime = 0L;
        private String startTimeFormatiert = "";
        private String logDurationFormatiert = "";
        private String endTimeFormatiert = "";
        private double distance = 0.0;
        private double maxSpeed = 0.0;
        private double cumSpeed = 0.0;
        private double abstandZuZielLastTrack = 0.0;
        private double abstandZuLastPointLastTrack = 0.0;
        private double lastTrackLastLat = -999.0;
        private double lastTrackLastLon = -999.0;
        private String lastTrackZiel = "-";
        private double firstLat = 0.0;
        private double firstLon = 0.0;
        private double abstandFirstPointZuStartPoint = 0.0;
        private double abstandFirstPointZuLastPointLastTrack = 0.0;
        private double lon = 0.0;
        private double lat = 0.0;
        private long alt = 0L;
        private int timeAdd = 0;
        private double speed = 0.0;
        private String signalQuality = "";
        private String speeding = "";
        private String gsmSignalQuality = "";
        private String internetSignalQuality = "";
        private String batteryStatus = "";
        private String time = "";
        private long timeStamp = 0L;
        private double speedCalc = 0.0;
        double speedCalcRaw = 0.0;
        String speedCalcText = "";
        private final FGregorianCalendar zeit = new FGregorianCalendar();
        private String speedString = "";
        double lastLon = 0.0;
        double lastLat = 0.0;
        long lastTimeStamp = -1L;
        double[] lastSpeed = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0};

        SygicLog() {
        }

        String byte2ANSI(byte[] b, int von, int laenge) {
            int[] intArray = new int[laenge];
            int i = 0;
            while (i < intArray.length) {
                intArray[i] = b[i + von];
                ++i;
            }
            return new String(intArray, 0, intArray.length);
        }

        String byte2Hex(byte[] b, int von, int az, boolean mitBlanks) {
            byte[] bytes = new byte[1];
            String aus = "";
            String sep = mitBlanks ? " " : "";
            int i = 0;
            while (i < az) {
                bytes[0] = b[von + i];
                aus = String.valueOf(aus) + DatatypeConverter.printHexBinary((byte[])bytes) + sep;
                ++i;
            }
            return aus;
        }

        String byte2UTF16LE(byte[] b, int von, int laenge) {
            byte[] byteArray = new byte[laenge * 2];
            int i = 0;
            while (i < byteArray.length) {
                byteArray[i] = b[i + von];
                ++i;
            }
            return new String(byteArray, Charset.forName("UTF-16LE"));
        }

        long forByte2Long(byte[] b, int von) {
            byte[] bytes = new byte[8];
            bytes[5] = b[von];
            bytes[4] = b[von + 1];
            bytes[7] = b[von + 2];
            bytes[6] = b[von + 3];
            FProt.instance().prot(String.valueOf(von) + ", Hex: " + Integer.toHexString(von) + ", HexString: " + DatatypeConverter.printHexBinary((byte[])bytes), 2);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            return buffer.getLong();
        }

        long forByteReverse2Long(byte[] b, int von) {
            byte[] bytes = new byte[8];
            bytes[7] = b[von];
            bytes[6] = b[von + 1];
            bytes[5] = b[von + 2];
            bytes[4] = b[von + 3];
            FProt.instance().prot(String.valueOf(von) + ", Hex: " + Integer.toHexString(von) + ", HexString: " + DatatypeConverter.printHexBinary((byte[])bytes), 2);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            return buffer.getLong();
        }

        private double getAbstandFirstPointZuLastPointLastTrack() {
            return this.abstandFirstPointZuLastPointLastTrack;
        }

        private double getAbstandFirstPointZuStartPoint() {
            return this.abstandFirstPointZuStartPoint;
        }

        private double getAbstandZuLastPointLastTrack() {
            return this.abstandZuLastPointLastTrack;
        }

        private double getAbstandZuZielLastTrack() {
            return this.abstandZuZielLastTrack;
        }

        long getAlt() {
            return this.alt;
        }

        String getBatteryStatus() {
            return this.batteryStatus;
        }

        double getDistance() {
            return this.distance;
        }

        String getEndTimeFormatiert() {
            return this.endTimeFormatiert;
        }

        private long getFavorite() {
            return this.favorite;
        }

        private double getFirstLat() {
            return this.firstLat;
        }

        private double getFirstLon() {
            return this.firstLon;
        }

        String getGsmSignalQuality() {
            return this.gsmSignalQuality;
        }

        void getHeader(FFile sygicLog) {
            int len = 0;
            int startTimeCorrecture = 0;
            SimpleDateFormat startTimeFormat = new SimpleDateFormat("yyMMdd_HHmmss");
            byte[] b = sygicLog.inhaltToByteArray(21);
            this.setVersion(this.byte2ANSI(b, 0, 4));
            if (this.getVersion().compareTo("5FRT") == 0) {
                this.setFavorite(this.forByteReverse2Long(b, 4));
                this.setLogType(this.byte2Hex(b, 8, 1, false));
                this.setLogDuration(this.forByteReverse2Long(b, 9));
                this.setLogLength(this.forByteReverse2Long(b, 13));
                this.setLastMarkDistance(this.forByteReverse2Long(b, 17));
                len = this.twoByteReverse2Int(sygicLog.inhaltToByteArray(2), 0);
                this.setStart(this.byte2UTF16LE(sygicLog.inhaltToByteArray(len * 2), 0, len));
                len = this.twoByteReverse2Int(sygicLog.inhaltToByteArray(2), 0);
                this.setZiel(this.byte2UTF16LE(sygicLog.inhaltToByteArray(len * 2), 0, len));
                len = this.twoByteReverse2Int(sygicLog.inhaltToByteArray(2), 0);
                this.setStartTimeString(this.byte2UTF16LE(sygicLog.inhaltToByteArray(len * 2), 0, len));
                try {
                    startTimeCorrecture = Integer.parseInt(this.getStartTimeString().substring(14));
                    this.setStartTime(startTimeFormat.parse(this.getStartTimeString()).getTime() + (long)(startTimeCorrecture * 60000));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (this.getStartTime() > 0L) {
                    this.getZeit().setTime(this.getStartTime());
                }
                if ((len = this.twoByteReverse2Int(sygicLog.inhaltToByteArray(2), 0)) > 0) {
                    this.setZielDetail(this.byte2UTF16LE(sygicLog.inhaltToByteArray(len * 2), 0, len));
                }
                this.setStartLon((double)this.forByteReverse2Long(sygicLog.inhaltToByteArray(4), 0) / 100000.0);
                this.setStartLat((double)this.forByteReverse2Long(sygicLog.inhaltToByteArray(4), 0) / 100000.0);
                this.setPointCount(this.forByteReverse2Long(sygicLog.inhaltToByteArray(4), 0));
                this.getZeit().setTimeInMillis(this.getStartTime());
                this.setStartTimeFormatiert(this.getZeit().toGermanFormat());
                this.getZeit().add(14, (int)this.getLogDuration());
                this.setEndTimeFormatiert(this.getZeit().toGermanFormat());
                this.setLogDurationFormatiert(Futi.formatDauerMilliSeconds(this.getLogDuration()));
                this.setAbstandZuLastPointLastTrack(this.getLastTrackLastLat() >= -180.0 ? Distance.distance(this.getLastTrackLastLat(), this.getLastTrackLastLon(), this.getStartLat(), this.getStartLon(), 'K', 6) : 0.0);
                this.setAbstandZuZielLastTrack(Fuzzy.similarity(this.getLastTrackZiel(), this.getStart()));
            }
        }

        String getInternetSignalQuality() {
            return this.internetSignalQuality;
        }

        double getLastLat() {
            return this.lastLat;
        }

        double getLastLon() {
            return this.lastLon;
        }

        private long getLastMarkDistance() {
            return this.lastMarkDistance;
        }

        private double[] getLastSpeed() {
            return this.lastSpeed;
        }

        private long getlastTimeStamp() {
            return this.lastTimeStamp;
        }

        private double getLastTrackLastLat() {
            return this.lastTrackLastLat;
        }

        private double getLastTrackLastLon() {
            return this.lastTrackLastLon;
        }

        String getLastTrackZiel() {
            return this.lastTrackZiel;
        }

        double getLat() {
            return this.lat;
        }

        long getLogDuration() {
            return this.logDuration;
        }

        String getLogDurationFormatiert() {
            return this.logDurationFormatiert;
        }

        private long getLogLength() {
            return this.logLength;
        }

        private String getLogType() {
            return this.logType;
        }

        double getLon() {
            return this.lon;
        }

        double getMaxSpeed() {
            return this.maxSpeed;
        }

        void getPoint(byte[] b) {
            this.initPoint();
            this.setLon((double)this.forByteReverse2Long(b, 0) / 100000.0);
            this.setLat((double)this.forByteReverse2Long(b, 4) / 100000.0);
            this.setAlt(this.forByteReverse2Long(b, 8));
            this.setTimeAdd((int)this.forByteReverse2Long(b, 12));
            this.getZeit().setTimeInMillis(this.getStartTime());
            this.getZeit().add(14, this.getTimeAdd());
            this.setTime(this.getZeit().toGermanFormat('G'));
            this.setTimeStamp(this.getZeit().getTimeInMillis());
            this.setSpeed((double)this.forByte2Long(b, 16) / 1.0E8);
            this.setSpeedString(String.valueOf(this.byte2Hex(b, 16, 4, true)) + "\t" + b[16] + "\t" + b[17] + "\t" + b[18] + "\t" + b[19]);
            this.setSignalQuality(this.byte2Hex(b, 20, 1, false));
            this.setSpeeding(this.byte2Hex(b, 21, 1, false));
            this.setGsmSignalQuality(this.byte2Hex(b, 22, 1, false));
            this.setInternetSignalQuality(this.byte2Hex(b, 23, 1, false));
            this.setBatteryStatus(this.byte2Hex(b, 24, 1, false));
            if (this.getlastTimeStamp() > 0L) {
                double avgLastSpeed;
                double abstand = Distance.distance(this.getLastLat(), this.getLastLon(), this.getLat(), this.getLon(), 'K', 6);
                this.speedCalcRaw = (this.getTimeStamp() - this.getlastTimeStamp() <= 0L ? 0.0 : abstand * 3600000.0) / (double)(this.getTimeStamp() - this.getlastTimeStamp());
                double SumLastSpeed = 0.0;
                int azLastSpeed = 0;
                double[] dArray = this.getLastSpeed();
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double element = dArray[n2];
                    if (element >= 0.0) {
                        SumLastSpeed += element;
                        ++azLastSpeed;
                    }
                    ++n2;
                }
                double d = avgLastSpeed = azLastSpeed > 0 ? SumLastSpeed / (double)azLastSpeed : 0.0;
                if (this.speedCalcRaw <= 25.0) {
                    this.setSpeedCalc(this.speedCalcRaw);
                } else if (this.speedCalcRaw <= 50.0) {
                    this.setSpeedCalc(FMath.checkRange(this.speedCalcRaw, avgLastSpeed * 0.75, avgLastSpeed * 1.25));
                    this.speedCalcText = " <=50";
                } else if (this.speedCalcRaw <= 90.0) {
                    this.setSpeedCalc(FMath.checkRange(this.speedCalcRaw, avgLastSpeed * 0.8, avgLastSpeed * 1.2));
                    this.speedCalcText = "<=90";
                } else if (this.speedCalcRaw <= 120.0) {
                    this.setSpeedCalc(FMath.checkRange(this.speedCalcRaw, avgLastSpeed * 0.9, avgLastSpeed * 1.1));
                    this.speedCalcText = "<=120";
                } else {
                    this.setSpeedCalc(120.0);
                    this.speedCalcText = ">120";
                }
                this.setDistance(this.getDistance() + abstand);
                this.setMaxSpeed(Math.max(this.getMaxSpeed(), this.getSpeedCalc()));
                this.cumSpeed += this.getSpeedCalc();
            }
            this.setlastTimeStamp(this.getTimeStamp());
            this.setLastLat(this.getLat());
            this.setLastLon(this.getLon());
            this.updateLastSpeed();
        }

        long getPointCount() {
            return this.pointCount;
        }

        String getSignalQuality() {
            return this.signalQuality;
        }

        double getSpeed() {
            return this.speed;
        }

        private double getSpeedCalc() {
            return this.speedCalc;
        }

        String getSpeeding() {
            return this.speeding;
        }

        private String getSpeedString() {
            return this.speedString;
        }

        String getStart() {
            return this.start;
        }

        private double getStartLat() {
            return this.startLat;
        }

        private double getStartLon() {
            return this.startLon;
        }

        long getStartTime() {
            return this.startTime;
        }

        String getStartTimeFormatiert() {
            return this.startTimeFormatiert;
        }

        private String getStartTimeString() {
            return this.startTimeString;
        }

        String getTime() {
            return this.time;
        }

        int getTimeAdd() {
            return this.timeAdd;
        }

        private long getTimeStamp() {
            return this.timeStamp;
        }

        private String getVersion() {
            return this.version;
        }

        String getZeile() {
            return this.getZeile("\t");
        }

        String getZeile(String sep) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            return String.valueOf(this.getLat()) + sep + this.getLon() + sep + this.getAlt() + sep + this.getTime() + sep + nf.format(this.getSpeedCalc());
        }

        private FGregorianCalendar getZeit() {
            return this.zeit;
        }

        String getZiel() {
            return this.ziel;
        }

        private String getZielDetail() {
            return this.zielDetail;
        }

        void initPoint() {
            this.setLon(0.0);
            this.setLat(0.0);
            this.setAlt(0L);
            this.setTimeAdd(0);
            this.setSpeed(0.0);
            this.setSpeedCalc(0.0);
            this.setSignalQuality("");
            this.setSpeeding("");
            this.setGsmSignalQuality("");
            this.setInternetSignalQuality("");
            this.setBatteryStatus("");
            this.setTime("");
            this.setTimeStamp(-1L);
            this.speedCalcRaw = 0.0;
            this.speedCalcText = "";
        }

        String[] printPoint(boolean mitHeader) {
            ArrayList<String> aus = new ArrayList<String>();
            aus.add(String.valueOf(mitHeader ? "Longitude            :" : "") + this.getLon());
            aus.add(String.valueOf(mitHeader ? "Latitude             :" : "") + this.getLat());
            aus.add(String.valueOf(mitHeader ? "Altitude             :" : "") + this.getAlt());
            aus.add(String.valueOf(mitHeader ? "TimeAdd              :" : "") + this.getTimeAdd());
            aus.add(String.valueOf(mitHeader ? "Speed                :" : "") + this.getSpeed());
            aus.add(String.valueOf(mitHeader ? "SpeedCalculated      :" : "") + this.getSpeedCalc());
            aus.add(String.valueOf(mitHeader ? "SpeedCalculatedText  :" : "") + this.speedCalcText);
            aus.add(String.valueOf(mitHeader ? "SpeedString          :" : "") + this.getSpeedString());
            aus.add(String.valueOf(mitHeader ? "SignalQuality        :" : "") + this.getSignalQuality());
            aus.add(String.valueOf(mitHeader ? "Speeding             :" : "") + this.getSpeeding());
            aus.add(String.valueOf(mitHeader ? "GsmSignalQuality     :" : "") + this.getGsmSignalQuality());
            aus.add(String.valueOf(mitHeader ? "InternetSignalQuality:" : "") + this.getInternetSignalQuality());
            aus.add(String.valueOf(mitHeader ? "BatteryStatus        :" : "") + this.getBatteryStatus());
            aus.add(String.valueOf(mitHeader ? "Time                 :" : "") + this.getTime());
            aus.add(String.valueOf(mitHeader ? "TimeStamp            :" : "") + this.getTimeStamp());
            return FString.arrayListToStringArray(aus);
        }

        String[] printSteuerung() {
            return this.printSteuerung(false, true, false);
        }

        String[] printSteuerung(boolean kurz, boolean mitHeader, boolean nurHeader) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(3);
            nf.setMinimumFractionDigits(3);
            NumberFormat latLon = NumberFormat.getInstance();
            latLon.setMaximumFractionDigits(8);
            latLon.setMinimumFractionDigits(8);
            this.setAbstandFirstPointZuStartPoint(Distance.distance(this.getFirstLat(), this.getFirstLon(), this.getStartLat(), this.getStartLon(), 'K', 6));
            this.setAbstandFirstPointZuLastPointLastTrack(Distance.distance(this.getLastTrackLastLat(), this.getLastTrackLastLon(), this.getFirstLat(), this.getFirstLon(), 'K', 6));
            ArrayList<String> aus = new ArrayList<String>();
            aus.add(String.valueOf(mitHeader ? "Start            :" : "") + (nurHeader ? "" : this.getStart()));
            aus.add(String.valueOf(mitHeader ? "Ziel             :" : "") + (nurHeader ? "" : this.getZiel()));
            aus.add(String.valueOf(mitHeader ? "ZielDetail       :" : "") + (nurHeader ? "" : this.getZielDetail()));
            aus.add(String.valueOf(mitHeader ? "StartTime        :" : "") + (nurHeader ? "" : this.getStartTimeFormatiert()));
            aus.add(String.valueOf(mitHeader ? "EndeTime         :" : "") + (nurHeader ? "" : this.getEndTimeFormatiert()));
            aus.add(String.valueOf(mitHeader ? "LogDuration      :" : "") + (nurHeader ? "" : this.getLogDurationFormatiert()));
            aus.add(String.valueOf(mitHeader ? "LastTrackLastLon :" : "") + (nurHeader ? "" : latLon.format(this.getLastTrackLastLon())));
            aus.add(String.valueOf(mitHeader ? "LastTrackLastLat :" : "") + (nurHeader ? "" : latLon.format(this.getLastTrackLastLat())));
            aus.add(String.valueOf(mitHeader ? "FirstLon         :" : "") + (nurHeader ? "" : latLon.format(this.getFirstLon())));
            aus.add(String.valueOf(mitHeader ? "FirstLat         :" : "") + (nurHeader ? "" : latLon.format(this.getFirstLat())));
            aus.add(String.valueOf(mitHeader ? "First2LastTrackPt:" : "") + (nurHeader ? "" : nf.format(this.getAbstandFirstPointZuLastPointLastTrack())));
            aus.add(String.valueOf(mitHeader ? "PointCount       :" : "") + (nurHeader ? "" : "" + this.getPointCount()));
            aus.add(String.valueOf(mitHeader ? "Distance         :" : "") + (nurHeader ? "" : nf.format(this.getDistance())));
            aus.add(String.valueOf(mitHeader ? "AverageSpeed     :" : "") + (nurHeader ? "" : nf.format(this.cumSpeed / (double)this.getPointCount())));
            aus.add(String.valueOf(mitHeader ? "MaxSpeed         :" : "") + (nurHeader ? "" : nf.format(this.getMaxSpeed())));
            aus.add(String.valueOf(mitHeader ? "LogLength        :" : "") + (nurHeader ? "" : "" + this.getLogLength()));
            if (!kurz) {
                aus.add(String.valueOf(mitHeader ? "LastTrackZiel    :" : "") + (nurHeader ? "" : this.getLastTrackZiel()));
                aus.add(String.valueOf(mitHeader ? "Abst.2LastTrackTx:" : "") + (nurHeader ? "" : nf.format(this.getAbstandZuZielLastTrack())));
                aus.add(String.valueOf(mitHeader ? "StartTimeString  :" : "") + (nurHeader ? "" : this.getStartTimeString()));
                aus.add(String.valueOf(mitHeader ? "StartLon         :" : "") + (nurHeader ? "" : latLon.format(this.getStartLon())));
                aus.add(String.valueOf(mitHeader ? "StartLat         :" : "") + (nurHeader ? "" : latLon.format(this.getStartLat())));
                aus.add(String.valueOf(mitHeader ? "LastLon          :" : "") + (nurHeader ? "" : latLon.format(this.getLon())));
                aus.add(String.valueOf(mitHeader ? "LastLat          :" : "") + (nurHeader ? "" : latLon.format(this.getLat())));
                aus.add(String.valueOf(mitHeader ? "Start2LastTrackPt:" : "") + (nurHeader ? "" : nf.format(this.getAbstandZuLastPointLastTrack())));
                aus.add(String.valueOf(mitHeader ? "First2StartPoint :" : "") + (nurHeader ? "" : nf.format(this.getAbstandFirstPointZuStartPoint())));
                aus.add(String.valueOf(mitHeader ? "Version          :" : "") + (nurHeader ? "" : this.getVersion()));
                aus.add(String.valueOf(mitHeader ? "Favorite         :" : "") + (nurHeader ? "" : "" + this.getFavorite()));
                aus.add(String.valueOf(mitHeader ? "LogType          :" : "") + (nurHeader ? "" : this.getLogType()));
                aus.add(String.valueOf(mitHeader ? "LastMarkDistance :" : "") + (nurHeader ? "" : "" + this.getLastMarkDistance()));
            }
            return FString.arrayListToStringArray(aus);
        }

        private void setAbstandFirstPointZuLastPointLastTrack(double abstandFirstPointZuLastPointLastTrack) {
            this.abstandFirstPointZuLastPointLastTrack = abstandFirstPointZuLastPointLastTrack;
        }

        private void setAbstandFirstPointZuStartPoint(double abstandFirstPointZuStartPoint) {
            this.abstandFirstPointZuStartPoint = abstandFirstPointZuStartPoint;
        }

        private void setAbstandZuLastPointLastTrack(double abstandZuLastPointLastTrack) {
            this.abstandZuLastPointLastTrack = abstandZuLastPointLastTrack;
        }

        private void setAbstandZuZielLastTrack(double abstandZuZielLastTrack) {
            this.abstandZuZielLastTrack = abstandZuZielLastTrack;
        }

        void setAlt(long alt) {
            this.alt = alt;
        }

        void setBatteryStatus(String batteryStatus) {
            this.batteryStatus = batteryStatus;
        }

        private void setDistance(double distance) {
            this.distance = distance;
        }

        void setEndTimeFormatiert(String endTimeFormatiert) {
            this.endTimeFormatiert = endTimeFormatiert;
        }

        private void setFavorite(long favorite) {
            this.favorite = favorite;
        }

        void setFirstLat(double firstLat) {
            this.firstLat = firstLat;
        }

        void setFirstLon(double firstLon) {
            this.firstLon = firstLon;
        }

        void setGsmSignalQuality(String gsmSignalQuality) {
            this.gsmSignalQuality = gsmSignalQuality;
        }

        void setInternetSignalQuality(String internetSignalQuality) {
            this.internetSignalQuality = internetSignalQuality;
        }

        private void setLastLat(double lastLat) {
            this.lastLat = lastLat;
        }

        private void setLastLon(double lastLon) {
            this.lastLon = lastLon;
        }

        private void setLastMarkDistance(long lastMarkDistance) {
            this.lastMarkDistance = lastMarkDistance;
        }

        private void setlastTimeStamp(long lastTimeStamp) {
            this.lastTimeStamp = lastTimeStamp;
        }

        void setLastTrackLastLat(double lastTrackLastLat) {
            this.lastTrackLastLat = lastTrackLastLat;
        }

        void setLastTrackLastLon(double lastTrackLastLon) {
            this.lastTrackLastLon = lastTrackLastLon;
        }

        void setLastTrackZiel(String lastTrackZiel) {
            this.lastTrackZiel = lastTrackZiel;
        }

        void setLat(double lat) {
            this.lat = lat;
        }

        private void setLogDuration(long logDuration) {
            this.logDuration = logDuration;
        }

        private void setLogDurationFormatiert(String logDurationFormatiert) {
            this.logDurationFormatiert = logDurationFormatiert;
        }

        private void setLogLength(long logLength) {
            this.logLength = logLength;
        }

        private void setLogType(String logType) {
            this.logType = logType;
        }

        void setLon(double lon) {
            this.lon = lon;
        }

        private void setMaxSpeed(double maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        private void setPointCount(long pointCount) {
            this.pointCount = pointCount;
        }

        void setSignalQuality(String signalQuality) {
            this.signalQuality = signalQuality;
        }

        void setSpeed(double speed) {
            this.speed = speed;
        }

        private void setSpeedCalc(double speedCalc) {
            this.speedCalc = speedCalc;
        }

        void setSpeeding(String speeding) {
            this.speeding = speeding;
        }

        private void setSpeedString(String speedString) {
            this.speedString = speedString;
        }

        private void setStart(String start) {
            this.start = start;
        }

        private void setStartLat(double startLat) {
            this.startLat = startLat;
        }

        private void setStartLon(double startLon) {
            this.startLon = startLon;
        }

        private void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        private void setStartTimeFormatiert(String startTimeFormatiert) {
            this.startTimeFormatiert = startTimeFormatiert;
        }

        private void setStartTimeString(String startTimeString) {
            this.startTimeString = startTimeString;
        }

        void setTime(String time) {
            this.time = time;
        }

        void setTimeAdd(int timeAdd) {
            this.timeAdd = timeAdd;
        }

        private void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        private void setVersion(String version) {
            this.version = version;
        }

        private void setZiel(String ziel) {
            this.ziel = ziel;
        }

        private void setZielDetail(String zielDetail) {
            this.zielDetail = zielDetail;
        }

        int twoByteReverse2Int(byte[] b, int von) {
            byte[] bytes = new byte[4];
            bytes[3] = b[von];
            bytes[2] = b[von + 1];
            FProt.instance().prot(String.valueOf(von) + ", Hex: " + Integer.toHexString(von) + ", HexString: " + DatatypeConverter.printHexBinary((byte[])bytes), 2);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            return buffer.getInt();
        }

        void updateLastSpeed() {
            int i = 0;
            while (i < this.lastSpeed.length - 1) {
                this.lastSpeed[i] = this.lastSpeed[i + 1];
                ++i;
            }
            this.lastSpeed[this.lastSpeed.length - 1] = this.getSpeedCalc();
        }
    }
}

