/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JTextArea;

public class KonkatDateien {
    private String Eingabedatei;
    private String Ausgabedatei;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean TextAreaEingabe;
    private boolean KopierenAusgabeInClipboard;
    private int AnzahlSpalten;
    private boolean KopierenClipboardInEingabe;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private String Charset;
    private boolean TextAreaAusgabe;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "18.5.2009 7:21:30";

    public static void main(String[] args) {
        KonkatDateien konkatDateien = new KonkatDateien(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(konkatDateien.ArgTab, konkatDateien.ArgTabDefault, konkatDateien.getHilfeText())) {
            try {
                konkatDateien.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + konkatDateien.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                konkatDateien.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + konkatDateien.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + konkatDateien.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public KonkatDateien() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public KonkatDateien(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getAnzahlSpalten() {
        return this.AnzahlSpalten;
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "18.5.2009 7:21:30";
    }

    public boolean isKopierenAusgabeInClipboard() {
        return this.KopierenAusgabeInClipboard;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    public void run() {
        FProt fProt = FProt.instance();
        Futi.instance();
        String[] Zeile = Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), false, this.getCharset());
        String[] Ausgabe = new String[]{};
        fProt.prot(Zeile, 1);
        int i = 0;
        while (i < Zeile.length) {
            Ausgabe = FString.verbindenStringArray(Ausgabe, new FFile(Zeile[i]).inhaltToStringArray());
            ++i;
        }
        fProt.prot(Ausgabe, 1);
        Futi.setAusgabe(Ausgabe, this.getAusgabedatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), this.isKopierenAusgabeInClipboard());
    }

    public void setAnzahlSpalten() {
        FParam.instance();
        this.AnzahlSpalten = FParam.getIntParameter("AnzahlSpalten", this.ArgTab);
    }

    public void setAnzahlSpalten(int anzahlSpalten) {
        FParam.instance();
        this.AnzahlSpalten = FParam.checkIntParameter("AnzahlSpalten", anzahlSpalten, this.ArgTab);
    }

    public void setAnzahlSpalten(String anzahlSpalten) {
        FParam.instance();
        this.AnzahlSpalten = FParam.checkIntParameter("AnzahlSpalten", anzahlSpalten, this.ArgTab);
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKopierenAusgabeInClipboard() {
        this.KopierenAusgabeInClipboard = FParam.getBooleanParameter("KopierenAusgabeInClipboard", this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard(boolean kopierenAusgabeInClipboard) {
        this.KopierenAusgabeInClipboard = kopierenAusgabeInClipboard;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setWerteAusArgTab() {
        this.setEingabedatei();
        this.setAusgabedatei();
        this.setCharset();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
        this.setKopierenAusgabeInClipboard();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Liste der Dateien                                         :" + this.getEingabedatei());
        fProt.prot("Ausgabedatei                                              :" + this.getAusgabedatei());
        fProt.prot("Charset (Codepage) fuer Eingabe                           :" + this.getCharset());
        fProt.prot("TextArea statt Liste der Dateien verwenden                :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden                     :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Liste der Dateien in TextArea kopieren:" + this.isKopierenClipboardInEingabe());
        fProt.prot("TextArea fuer Ausgabe in Zwischenablage kopieren          :" + this.isKopierenAusgabeInClipboard());
    }
}

