/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class MakeKalender {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String AusgabeDatei;
    private String GeburtstagsDatei;
    private int Jahr;
    private boolean KeineFeiertage;
    private final boolean SetzenWerteInGUInachRun = true;
    private String SonnenaufUnduntergang;
    private boolean OutlookFormat;
    private String BilderDatei;
    private int AnzahlLeerzeilen;
    private int Breite;
    private final String Stand = "20.12.2005";

    public static void main(String[] args) {
        MakeKalender makeKalender = new MakeKalender(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(makeKalender.ArgTab, makeKalender.ArgTabDefault, makeKalender.getHilfeText())) {
            try {
                makeKalender.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + makeKalender.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                makeKalender.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + makeKalender.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + makeKalender.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public MakeKalender() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public MakeKalender(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public boolean checkBilderDatei() {
        FProt fProt = FProt.instance();
        boolean RC = false;
        if (!this.isOutlookFormat()) {
            if (this.getBilderDatei().length() > 0) {
                FFile testFile = new FFile(this.getBilderDatei());
                String[] testArray = testFile.inhaltToStringArray();
                if (testArray.length >= 13) {
                    RC = true;
                    if (!this.getAusgabeDatei().endsWith(".htm")) {
                        this.setAusgabeDatei(String.valueOf(this.getAusgabeDatei()) + ".htm");
                    }
                } else {
                    fProt.prot("Bilderdatei >" + this.getBilderDatei() + "< hat keine 13 Eintraege");
                }
            }
        } else {
            RC = true;
            if (!this.getAusgabeDatei().endsWith(".txt")) {
                this.setAusgabeDatei(String.valueOf(this.getAusgabeDatei()) + ".txt");
            }
        }
        return RC;
    }

    public ArrayList<String> erstellenOutlookFormat(FGregorianCalendar kal, ArrayList<String> Ausgabe) {
        FProt fProt = FProt.instance();
        if (kal.hasZusatz()) {
            fProt.prot(String.valueOf(kal.toGermanFormat('K')) + " " + kal.getZusatz(), 1);
            String[] Teile = kal.getZusatz().split(",");
            int i = 0;
            while (i < Teile.length) {
                String Privat;
                String GanztaegigesEreignis;
                String Endetum;
                String Beginntum;
                Teile[i] = Teile[i].trim();
                String Betreff = Teile[i];
                String Beginntam = kal.toGermanFormat('K');
                String Endetam = kal.toGermanFormat('K');
                String ErinnerungEinAus = "0";
                String Zeitspannezeigenal = "3";
                if (Teile[i].indexOf("Sonnenaufgang") >= 0 || Teile[i].indexOf("Sonnenuntergang") >= 0) {
                    String[] SonnenTeile = Teile[i].split(" ");
                    Beginntum = SonnenTeile[1].replace('.', ':');
                    Endetum = SonnenTeile[1].replace('.', ':');
                    GanztaegigesEreignis = "0";
                    Privat = "0";
                } else if (kal.istArbeitsfrei() && i == 0 || Teile[i].indexOf("Urlaub") >= 0) {
                    Beginntum = "0:01";
                    Endetum = "23:59";
                    GanztaegigesEreignis = "-1";
                    Privat = "0";
                } else {
                    Beginntum = "8:00";
                    Endetum = "8:00";
                    GanztaegigesEreignis = "0";
                    Privat = "-1";
                }
                Ausgabe.add(String.valueOf(Betreff) + "\t" + Beginntam + "\t" + Beginntum + "\t" + Endetam + "\t" + Endetum + "\t" + GanztaegigesEreignis + "\t" + ErinnerungEinAus + "\t" + Privat + "\t" + Zeitspannezeigenal);
                ++i;
            }
        }
        return Ausgabe;
    }

    public int getAnzahlLeerzeilen() {
        return this.AnzahlLeerzeilen;
    }

    public String getAusgabeDatei() {
        return this.AusgabeDatei;
    }

    public String getBilderDatei() {
        return this.BilderDatei;
    }

    public int getBreite() {
        return this.Breite;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getGeburtstagsDatei() {
        return this.GeburtstagsDatei;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public int getJahr() {
        return this.Jahr;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getSonnenaufUnduntergang() {
        return this.SonnenaufUnduntergang;
    }

    public String getStand() {
        return "20.12.2005";
    }

    public boolean isKeineFeiertage() {
        return this.KeineFeiertage;
    }

    public boolean isOutlookFormat() {
        return this.OutlookFormat;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public ArrayList<String> Nachlauf(ArrayList<String> Ausgabe) {
        if (!this.isOutlookFormat()) {
            Ausgabe.add("</tr>");
            Ausgabe.add("</table>");
            Ausgabe.add("</table>");
            Ausgabe.add("</body>");
            Ausgabe.add("</html>");
        }
        return Ausgabe;
    }

    public void run() {
        FProt fProt = FProt.instance();
        ArrayList<String> Ausgabe = new ArrayList<String>();
        if (this.getAusgabeDatei().length() > 0 && this.getGeburtstagsDatei().length() > 0) {
            this.Vorlauf(Ausgabe);
            this.Verarbeitung(Ausgabe);
            this.Nachlauf(Ausgabe);
            FFile Datei = new FFile(this.getAusgabeDatei());
            Datei.StringArrayListToInhalt(Ausgabe);
            if (this.isOutlookFormat()) {
                fProt.prot("AusgabeDatei " + this.getAusgabeDatei() + " in Outlook-Import-Format erstellt");
            } else {
                fProt.prot("AusgabeDatei " + this.getAusgabeDatei() + " in HTML-Format erstellt");
            }
        }
    }

    public void setAnzahlLeerzeilen() {
        this.AnzahlLeerzeilen = FParam.getIntParameter("AnzahlLeerzeilen", this.ArgTab);
    }

    public void setAnzahlLeerzeilen(int anzahlLeerzeilen) {
        FParam.instance();
        this.AnzahlLeerzeilen = FParam.checkIntParameter("AnzahlLeerzeilen", anzahlLeerzeilen, this.ArgTab);
    }

    public void setAnzahlLeerzeilen(String anzahlLeerzeilen) {
        this.AnzahlLeerzeilen = FParam.checkIntParameter("AnzahlLeerzeilen", anzahlLeerzeilen, this.ArgTab);
    }

    public void setAusgabeDatei() {
        this.AusgabeDatei = FParam.getStringParameter("AusgabeDatei", this.ArgTab);
    }

    public void setAusgabeDatei(String ausgabeDatei) {
        FParam.instance();
        this.AusgabeDatei = FParam.checkStringParameter("AusgabeDatei", ausgabeDatei, this.ArgTab);
    }

    public void setBilderDatei() {
        this.BilderDatei = FParam.getStringParameter("BilderDatei", this.ArgTab);
    }

    public void setBilderDatei(String bilderDatei) {
        FParam.instance();
        this.BilderDatei = FParam.checkStringParameter("BilderDatei", bilderDatei, this.ArgTab);
    }

    public void setBreite() {
        this.Breite = FParam.getIntParameter("Breite", this.ArgTab);
    }

    public void setBreite(int breite) {
        FParam.instance();
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setBreite(String breite) {
        this.Breite = FParam.checkIntParameter("Breite", breite, this.ArgTab);
    }

    public void setGeburtstagsDatei() {
        this.GeburtstagsDatei = FParam.getStringParameter("GeburtstagsDatei", this.ArgTab);
    }

    public void setGeburtstagsDatei(String geburtstagsDatei) {
        FParam.instance();
        this.GeburtstagsDatei = FParam.checkStringParameter("GeburtstagsDatei", geburtstagsDatei, this.ArgTab);
    }

    public void setJahr() {
        this.Jahr = FParam.getIntParameter("Jahr", this.ArgTab);
    }

    public void setJahr(int jahr) {
        FParam.instance();
        this.Jahr = FParam.checkIntParameter("Jahr", jahr, this.ArgTab);
    }

    public void setJahr(String jahr) {
        this.Jahr = FParam.checkIntParameter("Jahr", jahr, this.ArgTab);
    }

    public void setKeineFeiertage() {
        this.KeineFeiertage = FParam.getBooleanParameter("KeineFeiertage", this.ArgTab);
    }

    public void setKeineFeiertage(boolean keineFeiertage) {
        this.KeineFeiertage = keineFeiertage;
    }

    public void setOutlookFormat() {
        this.OutlookFormat = FParam.getBooleanParameter("OutlookFormat", this.ArgTab);
    }

    public void setOutlookFormat(boolean outlookFormat) {
        this.OutlookFormat = outlookFormat;
    }

    public void setSonnenaufUnduntergang() {
        this.SonnenaufUnduntergang = FParam.getStringParameter("SonnenaufUnduntergang", this.ArgTab);
    }

    public void setSonnenaufUnduntergang(String sonnenaufUnduntergang) {
        FParam.instance();
        this.SonnenaufUnduntergang = FParam.checkStringParameter("SonnenaufUnduntergang", sonnenaufUnduntergang, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setAusgabeDatei();
        this.setGeburtstagsDatei();
        this.setBilderDatei();
        this.setJahr();
        this.setKeineFeiertage();
        this.setSonnenaufUnduntergang();
        this.setOutlookFormat();
        this.setAnzahlLeerzeilen();
        this.setBreite();
    }

    public ArrayList<String> Verarbeitung(ArrayList<String> Ausgabe) {
        int i;
        FProt fProt = FProt.instance();
        int lMonat = -1;
        String AusgabeZeile = "";
        FFile BilderFile = new FFile(this.getBilderDatei());
        char SonnenaufUnduntergangArt = this.getSonnenaufUnduntergang().charAt(0);
        String[] MonatsBild = BilderFile.inhaltToStringArray();
        String[] Monatsname = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
        FGregorianCalendar kal = new FGregorianCalendar(this.getJahr(), 0, 1);
        if (SonnenaufUnduntergangArt == 'K') {
            kal.setZusatz(this.getGeburtstagsDatei(), this.getJahr(), this.getJahr(), !this.isKeineFeiertage());
        } else {
            kal.setZusatz(this.getGeburtstagsDatei(), this.getJahr(), this.getJahr(), !this.isKeineFeiertage(), true, 48.232, 10.495, SonnenaufUnduntergangArt);
        }
        while (kal.get(1) == this.getJahr()) {
            if (this.isOutlookFormat()) {
                this.erstellenOutlookFormat(kal, Ausgabe);
            } else {
                if (lMonat < kal.get(2)) {
                    int Monat = kal.get(2);
                    fProt.prot(AusgabeZeile, 2);
                    fProt.prot(String.valueOf(Monatsname[Monat]) + " " + this.getJahr(), 2);
                    File Bild = Monat + 1 < MonatsBild.length ? new File(MonatsBild[Monat + 1]) : new File(MonatsBild[MonatsBild.length - 1]);
                    if (Bild.exists()) {
                        fProt.prot(Bild.toString(), 2);
                    } else {
                        fProt.prot("Bilddatei >" + Bild + "< nicht vorhanden");
                    }
                    fProt.prot("  M  D  M  D  F  S  S", 2);
                    AusgabeZeile = "";
                    int WochentagMonatsbeginn = (kal.get(7) + 6) % 7;
                    if (WochentagMonatsbeginn == 0) {
                        WochentagMonatsbeginn = 7;
                    }
                    i = 1;
                    while (i < WochentagMonatsbeginn) {
                        AusgabeZeile = String.valueOf(AusgabeZeile) + "   ";
                        ++i;
                    }
                    if (Monat > 0) {
                        if (WochentagMonatsbeginn > 1) {
                            i = WochentagMonatsbeginn;
                            while (i < 8) {
                                Ausgabe.add("<td valign=\"top\" width=\"14%\">&nbsp;</td>");
                                ++i;
                            }
                        }
                        Ausgabe.add("</tr>");
                        Ausgabe.add("</table>");
                    }
                    Ausgabe.add("<h1 align=\"center\"><font face=\"Arial\">" + Monatsname[Monat] + " " + this.getJahr() + "</font></h1>");
                    i = 0;
                    while (i < this.getAnzahlLeerzeilen()) {
                        Ausgabe.add("<p align=\"center\">&nbsp;</p>");
                        ++i;
                    }
                    Ausgabe.add("<p align=\"center\"><font face=\"Arial\"><img src=\"" + Bild.toString() + "\" width=\"" + this.getBreite() + "\"/font></p>");
                    i = 0;
                    while (i < this.getAnzahlLeerzeilen()) {
                        Ausgabe.add("<p align=\"center\">&nbsp;</p>");
                        ++i;
                    }
                    Ausgabe.add("<table border=\"2\" cellspacing=\"1\" width=\"100%\">");
                    Ausgabe.add("<tr>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Montag</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Dienstag</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Mittwoch</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Donnerstag</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Freitag</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\">Samstag</p></td>");
                    Ausgabe.add("<td valign=\"top\" width=\"14%\"><p align=\"center\"><font color=\"#FF0000\">Sonntag</font></p></td>");
                    Ausgabe.add("</tr>");
                    Ausgabe.add("<tr>");
                    i = 1;
                    while (i < WochentagMonatsbeginn) {
                        Ausgabe.add("<td valign=\"top\" width=\"14%\">&nbsp;</td>");
                        ++i;
                    }
                    lMonat = Monat;
                }
                String Zeile = "<td valign=\"top\" width=\"14%\">";
                if (kal.hasZusatz() || kal.get(7) == 1) {
                    Zeile = String.valueOf(Zeile) + "<font color=\"#FF0000\">";
                }
                if (kal.get(5) < 10) {
                    Zeile = String.valueOf(Zeile) + "&nbsp;&nbsp;" + kal.get(5);
                    AusgabeZeile = String.valueOf(AusgabeZeile) + "  " + kal.get(5);
                } else {
                    Zeile = String.valueOf(Zeile) + kal.get(5);
                    AusgabeZeile = String.valueOf(AusgabeZeile) + " " + kal.get(5);
                }
                if (kal.hasZusatz()) {
                    fProt.prot(String.valueOf(kal.toGermanFormat('K')) + " " + kal.getZusatz(), 1);
                    Zeile = String.valueOf(Zeile) + " " + kal.getZusatz();
                    AusgabeZeile = String.valueOf(AusgabeZeile) + " >" + kal.getZusatz() + "<";
                }
                if (kal.hasZusatz() || kal.get(7) == 1) {
                    Zeile = String.valueOf(Zeile) + "</font>";
                }
                if (!kal.hasZusatz()) {
                    Zeile = String.valueOf(Zeile) + "<br>";
                }
                Zeile = String.valueOf(Zeile) + "</td>";
                Ausgabe.add(Zeile);
                if (kal.get(7) == 1) {
                    Ausgabe.add("</tr>");
                    Ausgabe.add("<tr>");
                    fProt.prot(AusgabeZeile, 2);
                    AusgabeZeile = "";
                }
            }
            fProt.prot("     : " + kal.toGermanFormat(), 9);
            kal.add(5, 1);
        }
        if (!this.isOutlookFormat() && kal.get(7) > 2) {
            i = kal.get(7);
            while (i <= 8) {
                Ausgabe.add("<td valign=\"top\" width=\"14%\">&nbsp;</td>");
                ++i;
            }
        }
        fProt.prot(AusgabeZeile, 2);
        return Ausgabe;
    }

    public ArrayList<String> Vorlauf(ArrayList<String> Ausgabe) {
        FProt fProt = FProt.instance();
        FFile BilderFile = new FFile(this.getBilderDatei());
        String[] MonatsBild = BilderFile.inhaltToStringArray();
        if (!this.isOutlookFormat()) {
            fProt.prot("Kalender fuer " + this.getJahr(), 1);
            File Bild = new File(MonatsBild[0]);
            if (Bild.exists()) {
                fProt.prot(Bild.toString(), 1);
            } else {
                fProt.prot("Bilddatei >" + Bild + "< nicht vorhanden");
            }
            Ausgabe.add("<html>");
            Ausgabe.add("<head>");
            Ausgabe.add("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            Ausgabe.add("<meta name=\"GENERATOR\" content=\"java (c) J.Fischer\">");
            Ausgabe.add("<title>Kalender " + this.getJahr() + "</title>");
            Ausgabe.add("</head>");
            Ausgabe.add("<body bgcolor=\"#FFFFFF\">");
            Ausgabe.add("<h1 align=\"center\"><font face=\"Arial\">" + this.getJahr() + "</font></h1>");
            int i = 0;
            while (i < this.getAnzahlLeerzeilen()) {
                Ausgabe.add("<p align=\"center\">&nbsp;</p>");
                ++i;
            }
            Ausgabe.add("<p align=\"center\"><font face=\"Arial\"><img src=\"" + Bild.toString() + "\" width=\"" + this.getBreite() + "\" /font></p>");
            i = 0;
            while (i < this.getAnzahlLeerzeilen()) {
                Ausgabe.add("<p align=\"center\">&nbsp;</p>");
                ++i;
            }
            Ausgabe.add("<p align=\"center\">Kalender f&uuml;r ...</p>");
        }
        return Ausgabe;
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Ausgabedatei                                               :" + this.getAusgabeDatei());
        fProt.prot("Datei mit Geburtstagseintraegen                            :" + this.getGeburtstagsDatei());
        fProt.prot("Datei mit Namen fuer Kalenderbilder (nur bei Html)         :" + this.getBilderDatei());
        fProt.prot("Jahr, fuer das der Kalender erstellt werden soll           :" + this.getJahr());
        fProt.prot("Keine Feiertage ausgeben                                   :" + this.isKeineFeiertage());
        fProt.prot("Zeit fuer Sonnenauf- bzw. untergaenge anzeigen             :" + this.getSonnenaufUnduntergang());
        fProt.prot("Ausgabe im Outlook-Import- statt im HTML-Format            :" + this.isOutlookFormat());
        fProt.prot("Anzahl Leerzeilen ober und unter den Bildern (nur bei Html):" + this.getAnzahlLeerzeilen());
        fProt.prot("maximale Breite der Bilder (nur bei Html)                  :" + this.getBreite());
    }
}

