/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;

public class ManageMetadaten {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = false;
    private String[][] ArgTab;
    private final String Stand = "26.4.2016";
    private String Funktion;
    private int HomepageMaxMSpaceTitel;
    private boolean HomepagekuerzenMSpaceWorte;
    private String Verzeichnis;
    private String HomepageWorkVerzeichnis;
    private boolean Photosbearbeiten;
    private boolean KeineHomepage;
    private String HomepageVerzeichnis;
    private String NameIndexPHPOriginal;

    private static String[] clearMedienListe(String[] data, boolean isFiles) {
        ArrayList<String> clearData = new ArrayList<String>();
        int pos = isFiles ? 2 : 0;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] teile = element.split("\t");
            if (!teile[pos].startsWith("._")) {
                clearData.add(element);
            }
            ++n2;
        }
        return FString.arrayListToStringArray(clearData);
    }

    private static String[] dataPrefix(String[] data, String art) {
        ArrayList<String> Zeilen = new ArrayList<String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Zeilen.add(String.valueOf(art) + "\t" + element);
            ++n2;
        }
        return FString.arrayListToStringArray(Zeilen);
    }

    private static String[] dataSplit(String[] data, String art) {
        ArrayList<String> Zeilen = new ArrayList<String>();
        int len = art.length() + 1;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.startsWith(String.valueOf(art) + "\t")) {
                Zeilen.add(element.substring(len));
            }
            ++n2;
        }
        return FString.arrayListToStringArray(Zeilen);
    }

    private static String[] getFotoTags() {
        String[] tags = new String[]{"-FileName", "-ImageWidth", "-ImageHeight"};
        String[] zeile = Futi.readResource("ExifMedien.TagsOrg");
        if (zeile.length > 0) {
            tags = new String[zeile.length + 1];
            tags[0] = "-FileName";
            int i = 0;
            while (i < zeile.length) {
                tags[i + 1] = zeile[i].split(" ")[0];
                ++i;
            }
        }
        return tags;
    }

    public static void main(String[] args) {
        ManageMetadaten manageMetadaten = new ManageMetadaten(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(manageMetadaten.ArgTab, manageMetadaten.ArgTabDefault, manageMetadaten.getHilfeText())) {
            try {
                manageMetadaten.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + manageMetadaten.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                manageMetadaten.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + manageMetadaten.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + manageMetadaten.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public ManageMetadaten() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public ManageMetadaten(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public int getHomepageMaxMSpaceTitel() {
        return this.HomepageMaxMSpaceTitel;
    }

    public String getHomepageVerzeichnis() {
        return this.HomepageVerzeichnis;
    }

    public String getHomepageWorkVerzeichnis() {
        return this.HomepageWorkVerzeichnis;
    }

    public String getNameIndexPHPOriginal() {
        return this.NameIndexPHPOriginal;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "26.4.2016";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public boolean isHomepagekuerzenMSpaceWorte() {
        return this.HomepagekuerzenMSpaceWorte;
    }

    public boolean isKeineHomepage() {
        return this.KeineHomepage;
    }

    public boolean isPhotosbearbeiten() {
        return this.Photosbearbeiten;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public void run() {
        char funktion = this.getFunktion().toUpperCase().charAt(0);
        if (funktion == 'L') {
            Futi.refreshFernsehserienLinks(this.getVerzeichnis());
        } else {
            FProt fProt = FProt.instance();
            String filesNameConst = ".files.txt";
            String filesPrefix = "files";
            String exifPrefix = "exif";
            String[] fotoExtAndCo = new String[]{"-ext", "JPG", "-ext", "MP4", "-ext", "PNG", "-ext", "GIF", "-Lang", "DE", "-T", "-c", "%+.8g"};
            String[] fotoTags = ManageMetadaten.getFotoTags();
            String[] fotoTagsHeader = ManageMetadaten.dataPrefix(new String[]{FString.stringArrayToString(fotoTags, "\t").replaceAll("-", "")}, "header");
            int anzVerzeichnisseUnveraendert = 0;
            int anzVerzeichnisseVeraendert = 0;
            int anzCheckfileNichtVorhanden = 0;
            int anzKeineMedienInVerzeichnis = 0;
            int anzCheckfilesErstellt = 0;
            int anzCheckfileSchreibenNichtMoeglich = 0;
            int anzCheckfileGeloescht = 0;
            FFile verz = new FFile(this.getVerzeichnis());
            String[] liste = FString.verbindenStringMitArray("", verz.listFileNames('V', true));
            if (liste.length == 0) {
                fProt.prot("Keine Unterverzeichnisse mit " + (this.isPhotosbearbeiten() ? "Fotos" : "Videos") + " in >" + this.getVerzeichnis() + "< vorhanden");
            } else {
                String[] stringArray = liste;
                int n = liste.length;
                int n2 = 0;
                while (n2 < n) {
                    String verzeichnis = stringArray[n2];
                    if (!(verzeichnis.endsWith(".Thumbs") || verzeichnis.endsWith("Poster") || verzeichnis.endsWith("Preview") || verzeichnis.contains("Video_Poster"))) {
                        boolean verzChanged = true;
                        String[] exifData = null;
                        FFile aktVerz = new FFile(this.getVerzeichnis(), verzeichnis);
                        String aktVerzName = aktVerz.getAbsolutePath();
                        fProt.prot(aktVerzName, 2);
                        FFile files = new FFile(aktVerzName, ".files.txt");
                        String filesName = files.getAbsolutePath();
                        fProt.prot(String.valueOf(filesName) + " " + files.getAttributes(), 2);
                        if (!files.canWrite()) {
                            files.setWritable(true);
                        }
                        String[] data = files.inhaltToStringArray("UTF-8");
                        String[] filesDataAlt = ManageMetadaten.dataSplit(data, "files");
                        if (this.isPhotosbearbeiten()) {
                            aktVerz.setAuswahlDatei("(.*.mp4|.*.jpg|.*.png|.*.gif)");
                        } else {
                            aktVerz.setAuswahlDatei("(.*.mp4|.*.jpg)");
                        }
                        aktVerz.setAuswahlTiefe(0);
                        String[] filesData = ManageMetadaten.clearMedienListe(aktVerz.listjfi(), true);
                        String[][] workData = FString.convertStringArrayToTabelle(filesData, 4, true);
                        int i = 0;
                        while (i < workData.length) {
                            if (!workData[i][2].startsWith("._")) {
                                filesData[i] = String.valueOf(workData[i][0]) + "\t" + workData[i][1] + "\t" + workData[i][2] + "\t" + workData[i][3].substring(aktVerzName.length());
                            }
                            ++i;
                        }
                        if (filesData.length > 0 && (filesDataAlt == null || filesDataAlt.length == 0)) {
                            fProt.prot("Keine oder leere Checkdatei >" + filesName + "< vorhanden");
                            ++anzCheckfileNichtVorhanden;
                        } else if (FString.compareArrays(filesData, filesDataAlt, true)) {
                            verzChanged = false;
                        }
                        if (filesData.length > 0) {
                            if (funktion == 'T') {
                                fProt.prot(String.valueOf(this.isPhotosbearbeiten() ? "Fotos" : "Videos") + " in >" + aktVerzName + "< sind " + (verzChanged ? "" : "nicht ") + "veraendert");
                            }
                            if (verzChanged) {
                                ++anzVerzeichnisseVeraendert;
                            } else {
                                ++anzVerzeichnisseUnveraendert;
                            }
                            if (funktion == 'F' || verzChanged && (funktion == 'U' || funktion == 'A')) {
                                if (filesData.length > 0) {
                                    String[] stringArray2;
                                    String[] stringArray3 = Futi.getBenutzerWert("ExiftoolParameter").split(" ");
                                    if (this.isPhotosbearbeiten()) {
                                        stringArray2 = FString.verbindenStringArray(fotoExtAndCo, fotoTags);
                                    } else {
                                        String[] stringArray4 = new String[13];
                                        stringArray4[0] = "-ext";
                                        stringArray4[1] = "JPG";
                                        stringArray4[2] = "-ext";
                                        stringArray4[3] = "MP4";
                                        stringArray4[4] = "-T";
                                        stringArray4[5] = "-BaseName";
                                        stringArray4[6] = "-Quicktime:Duration";
                                        stringArray4[7] = "-ImageWidth";
                                        stringArray4[8] = "-ImageHeight";
                                        stringArray4[9] = "-XMP:Title";
                                        stringArray4[10] = "-XMP:UserComment";
                                        stringArray4[11] = "-XMP:BaseUrl";
                                        stringArray2 = stringArray4;
                                        stringArray4[12] = "-XMP:Description";
                                    }
                                    exifData = ManageMetadaten.clearMedienListe(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(stringArray3, FString.verbindenArrayMitString(stringArray2, aktVerzName)), 5), "UTF-8"), false);
                                    data = FString.verbindenStringArray(ManageMetadaten.dataPrefix(exifData, "exif"), ManageMetadaten.dataPrefix(filesData, "files"));
                                    if (this.isPhotosbearbeiten()) {
                                        data = FString.verbindenStringArray(fotoTagsHeader, data);
                                    }
                                    if (files.isHidden()) {
                                        files.setHidden(false);
                                    }
                                    String[] schreibenErfolgreich = files.StringArrayToInhalt(data, "UTF-8");
                                    files.setHidden(true);
                                    if (schreibenErfolgreich.length == 0) {
                                        fProt.prot("Neue Checkdatei >" + filesName + "< erstellt");
                                        ++anzCheckfilesErstellt;
                                    } else {
                                        fProt.prot("Neue Checkdatei >" + filesName + "< kann nicht geschrieben werden");
                                        fProt.prot(schreibenErfolgreich, 1);
                                        ++anzCheckfileSchreibenNichtMoeglich;
                                    }
                                    if (!this.isPhotosbearbeiten()) {
                                        Futi.checkVideoPosterUndIndexPHP(aktVerzName, this.getNameIndexPHPOriginal());
                                        Futi.makeVideoHomepage(aktVerzName, String.valueOf(FDatei.checkFileSeperator(this.getHomepageVerzeichnis(), true)) + verzeichnis, this.getHomepageMaxMSpaceTitel(), this.isHomepagekuerzenMSpaceWorte(), false);
                                    }
                                } else if (files.exists()) {
                                    if (files.isHidden()) {
                                        files.setHidden(false);
                                    }
                                    files.delete();
                                    fProt.prot("Checkdatei >" + filesName + "< geloescht, keine " + (this.isPhotosbearbeiten() ? "Fotos" : "Videos") + " im Verzeichnis vorhanden");
                                    ++anzCheckfileGeloescht;
                                } else {
                                    fProt.prot("Keine Checkdatei >" + filesName + "< erstellt, keine " + (this.isPhotosbearbeiten() ? "Fotos" : "Videos") + " im Verzeichnis vorhanden");
                                    ++anzKeineMedienInVerzeichnis;
                                }
                            }
                            if (funktion == 'F' || funktion == 'E' || funktion == 'A') {
                                if (exifData == null) {
                                    data = files.inhaltToStringArray("UTF-8");
                                    exifData = ManageMetadaten.dataSplit(data, "exif");
                                }
                                if (exifData != null && exifData.length != 0) {
                                    new FFile(String.valueOf(this.getHomepageWorkVerzeichnis()) + System.getProperty("file.separator") + Futi.ersetzeUmlaute(verzeichnis, true, String.valueOf(System.getProperty("file.separator")) + " " + Futi.getHomepageZusaetzlichErlaubteZeichenZuAplhaNumerisch()) + "_exif.txt").StringArrayToInhalt(exifData, "UTF-8", true);
                                }
                            }
                            if (funktion == 'H') {
                                Futi.makeVideoHomepage(aktVerzName, String.valueOf(FDatei.checkFileSeperator(this.getHomepageVerzeichnis(), true)) + verzeichnis, this.getHomepageMaxMSpaceTitel(), this.isHomepagekuerzenMSpaceWorte(), false);
                            }
                            if (funktion == 'P') {
                                Futi.checkVideoPosterUndIndexPHP(aktVerzName, this.getNameIndexPHPOriginal());
                            }
                        } else {
                            fProt.prot("Keine " + (this.isPhotosbearbeiten() ? "Fotos" : "Videos") + " in >" + aktVerzName + "< vorhanden");
                            ++anzKeineMedienInVerzeichnis;
                        }
                    }
                    ++n2;
                }
                if (!this.isPhotosbearbeiten() && !this.isKeineHomepage() && funktion != 'P') {
                    Futi.makeVideoHomepageOverview(this.getHomepageVerzeichnis(), this.getHomepageWorkVerzeichnis(), this.getHomepageMaxMSpaceTitel(), this.isHomepagekuerzenMSpaceWorte());
                    Futi.makeVideoHomepageOverview(String.valueOf(FDatei.checkFileSeperator(this.getHomepageVerzeichnis(), true)) + Futi.getHomepageAuswahlName(), this.getHomepageWorkVerzeichnis(), this.getHomepageMaxMSpaceTitel(), this.isHomepagekuerzenMSpaceWorte());
                    Futi.checkVideoHomepageKategorie(this.getVerzeichnis(), this.getHomepageVerzeichnis());
                    Futi.checkVideoHomepageWork(this.getHomepageVerzeichnis(), this.getHomepageWorkVerzeichnis());
                    Futi.checkVideoHomepageAuswahl(this.getHomepageVerzeichnis());
                }
                ArrayList<String[]> protAnz = new ArrayList<String[]>();
                protAnz.add(new String[]{"Verzeichnisse unveraendert", "" + anzVerzeichnisseUnveraendert});
                protAnz.add(new String[]{"Verzeichnisse veraendert", "" + anzVerzeichnisseVeraendert});
                protAnz.add(new String[]{"Checkfiles nicht vorhanden", "" + anzCheckfileNichtVorhanden});
                protAnz.add(new String[]{"Verzeichnisse ohne " + (this.isPhotosbearbeiten() ? "Fotos" : "Videos"), "" + anzKeineMedienInVerzeichnis});
                protAnz.add(new String[]{"Checkfiles erstellt", "" + anzCheckfilesErstellt});
                protAnz.add(new String[]{"Checkfiles schreiben nicht moeglich", "" + anzCheckfileSchreibenNichtMoeglich});
                protAnz.add(new String[]{"Checkfiles geloescht", "" + anzCheckfileGeloescht});
                fProt.protAnzahl(protAnz);
            }
        }
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setHomepagekuerzenMSpaceWorte() {
        this.HomepagekuerzenMSpaceWorte = FParam.getBooleanParameter("HomepagekuerzenMSpaceWorte", this.ArgTab);
    }

    public void setHomepagekuerzenMSpaceWorte(boolean homepagekuerzenMSpaceWorte) {
        this.HomepagekuerzenMSpaceWorte = homepagekuerzenMSpaceWorte;
    }

    public void setHomepageMaxMSpaceTitel() {
        this.HomepageMaxMSpaceTitel = FParam.getIntParameter("HomepageMaxMSpaceTitel", this.ArgTab);
    }

    public void setHomepageMaxMSpaceTitel(int homepageMaxMSpaceTitel) {
        this.HomepageMaxMSpaceTitel = FParam.checkIntParameter("HomepageMaxMSpaceTitel", homepageMaxMSpaceTitel, this.ArgTab);
    }

    public void setHomepageMaxMSpaceTitel(String homepageMaxMSpaceTitel) {
        this.HomepageMaxMSpaceTitel = FParam.checkIntParameter("HomepageMaxMSpaceTitel", homepageMaxMSpaceTitel, this.ArgTab);
    }

    public void setHomepageVerzeichnis() {
        this.HomepageVerzeichnis = FParam.getStringParameter("HomepageVerzeichnis", this.ArgTab);
    }

    public void setHomepageVerzeichnis(String homepageVerzeichnis) {
        this.HomepageVerzeichnis = FParam.checkStringParameter("HomepageVerzeichnis", homepageVerzeichnis, this.ArgTab);
    }

    public void setHomepageWorkVerzeichnis() {
        this.HomepageWorkVerzeichnis = FParam.getStringParameter("HomepageWorkVerzeichnis", this.ArgTab);
    }

    public void setHomepageWorkVerzeichnis(String homepageWorkVerzeichnis) {
        this.HomepageWorkVerzeichnis = FParam.checkStringParameter("HomepageWorkVerzeichnis", homepageWorkVerzeichnis, this.ArgTab);
    }

    public void setKeineHomepage() {
        this.KeineHomepage = FParam.getBooleanParameter("KeineHomepage", this.ArgTab);
    }

    public void setKeineHomepage(boolean keineHomepage) {
        this.KeineHomepage = keineHomepage;
    }

    public void setNameIndexPHPOriginal() {
        this.NameIndexPHPOriginal = FParam.getStringParameter("NameIndexPHPOriginal", this.ArgTab);
    }

    public void setNameIndexPHPOriginal(String nameIndexPHPOriginal) {
        this.NameIndexPHPOriginal = FParam.checkStringParameter("NameIndexPHPOriginal", nameIndexPHPOriginal, this.ArgTab);
    }

    public void setPhotosbearbeiten() {
        this.Photosbearbeiten = FParam.getBooleanParameter("Photosbearbeiten", this.ArgTab);
    }

    public void setPhotosbearbeiten(boolean photosbearbeiten) {
        this.Photosbearbeiten = photosbearbeiten;
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setFunktion();
        this.setPhotosbearbeiten();
        this.setKeineHomepage();
        this.setHomepageVerzeichnis();
        this.setHomepageWorkVerzeichnis();
        this.setHomepageMaxMSpaceTitel();
        this.setHomepagekuerzenMSpaceWorte();
        this.setNameIndexPHPOriginal();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                            :" + this.getVerzeichnis());
        fProt.prot("Funktion                                      :" + this.getFunktion());
        fProt.prot("Exif-Metadaten fuer Fotos (default Videos)    :" + this.isPhotosbearbeiten());
        fProt.prot("Keine Homepage erzeugen/ aktualisieren        :" + this.isKeineHomepage());
        fProt.prot("Homepageverzeichnis                           :" + this.getHomepageVerzeichnis());
        fProt.prot("WorkVerzeichnis fuer Homepage                 :" + this.getHomepageWorkVerzeichnis());
        fProt.prot("Homepage: Maximale Breite der Titel in mSpace :" + this.getHomepageMaxMSpaceTitel());
        fProt.prot("Homepage: Bei Kuerzen Titel wortweise vorgehen:" + this.isHomepagekuerzenMSpaceWorte());
        fProt.prot("Name der Original IndexPHP-Datei              :" + this.getNameIndexPHPOriginal());
    }
}

