/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class RenameMedien {
    private final String[][] ArgTabDefault;
    private final boolean SetzenWerteInGUInachRun = true;
    private boolean CheckCopyright;
    private boolean SortierbarGrossKlein;
    private boolean SortierbareNamen;
    private boolean CheckSerienNummer;
    private boolean ExifTagsUeberSchreiben;
    private boolean CheckPrint;
    private boolean Exif2ModifyDate;
    private String ExifToolParm;
    private boolean ExifAlleTagsSchreiben;
    private boolean ExifTagsSchreiben;
    final String[] KameraUnbekannt = new String[]{"unbekannt", "", "1900.01.01", "2099.12.31", "Unbek", "*", "UBK_", "", ""};
    private boolean GPSDatumVerwenden;
    private int az_name_ok = 0;
    private int FileNameAutoMinimum;
    private int az_renamed = 0;
    private int az_rename_failed = 0;
    private int az_to_rename = 0;
    private int az_rename_nicht_entscheidbar = 0;
    private int az_datum_ok = 0;
    private int az_datum_changed = 0;
    private String NamensTabelle;
    private String KameraNameImBild;
    private String KameraSerie;
    private String KameraBildStamm;
    private String[][] CheckKameraDaten;
    private boolean NamensTabelleSchreiben;
    private int az_datum_change_failed = 0;
    private int az_datum_to_change = 0;
    private boolean OriginalFileNameAuto;
    private int az_exifdatum_nicht_vorhanden = 0;
    private int az_datumfelder_nicht_korrekt = 0;
    private int az_SerialNumber;
    private int az_ImageNumber;
    private int az_CreatorTool;
    private int az_Make;
    private int az_ModelNotice;
    private int az_Artist;
    private int az_ProcessingSoftware;
    private int az_Copyright;
    private int az_Model;
    private int az_OriginalFileName;
    private int az_ImageHistory;
    private int VorneAbschneiden;
    private String[][] ArgTab;
    private final String Stand = "10.2.2018 11:00";
    private String CheckAusgabedatei;
    private String Checkdatei;
    private String Funktion;
    private int DeltaBeiZeitvergleich;
    private String Verzeichnis;
    private boolean CheckAutor;
    private boolean AutomatischVorneAbschneiden;
    private boolean UnbekannteKamerasHaendeln;
    private boolean ExifBasisdatenSchreiben;
    private boolean OriginalDateinamen;
    private int az_kamera_unbekannt;

    public static void main(String[] args) {
        RenameMedien renameMedien = new RenameMedien(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(renameMedien.ArgTab, renameMedien.ArgTabDefault, renameMedien.getHilfeText())) {
            try {
                renameMedien.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + renameMedien.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                renameMedien.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + renameMedien.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + renameMedien.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public RenameMedien() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public RenameMedien(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void checkAndSetExifStatement(RenameMedienZeile exifFoto, ArrayList<String> exifToolStatement) {
        String set = "";
        if (exifFoto.isMyM50() || exifFoto.isRecflectaScanner()) {
            exifFoto.setImageHistorySoll();
            if (exifFoto.getImageHistorySoll().compareTo(exifFoto.getImageHistory()) != 0) {
                set = String.valueOf(set) + "\t-XMP:ImageHistory=" + exifFoto.getImageHistorySoll();
                this.incrementAz_ImageHistory();
            }
        }
        if (exifFoto.isGPSDateTimeUsed()) {
            set = String.valueOf(set) + "\t-GPSDateTime>Exif:DateTimeOriginal";
        }
        if (exifFoto.getOriginalFileNameSoll() != null && exifFoto.getOriginalFileName().compareToIgnoreCase(exifFoto.getOriginalFileNameSoll()) != 0) {
            set = String.valueOf(set) + "\t-OriginalFileName=" + exifFoto.getOriginalFileNameSoll();
            this.incrementAz_OriginalFileName();
        }
        if (exifFoto.getKameraNotiz() != null && exifFoto.getKameraNotiz().length() > 0 && exifFoto.getModelNotiz().compareTo(exifFoto.getKameraNotiz()) != 0) {
            set = String.valueOf(set) + "\t-ModelNotice=" + exifFoto.getKameraNotiz();
            this.incrementAz_ModelNotice();
        }
        if (exifFoto.getModel().startsWith("iPhone 5s") || exifFoto.getModel().startsWith("iPhone 5S") || exifFoto.getModel().startsWith("iPad")) {
            if (exifFoto.getImageNumber().length() < 7 && exifFoto.getImageNumber().compareTo(exifFoto.getImageNumberSoll()) != 0 && exifFoto.getImageNumber().compareTo("000000") != 0) {
                set = String.valueOf(set) + "\t-ImageNumber=" + exifFoto.getImageNumberSoll();
                this.incrementAz_ImageNumber();
            }
            if (exifFoto.getMake().compareTo("Apple") != 0) {
                set = String.valueOf(set) + "\t-Make=Apple";
                this.incrementAz_Make();
            }
            if ((exifFoto.getModel().startsWith("iPhone 5s") || exifFoto.getModel().startsWith("iPhone 5S")) && exifFoto.getModelKurz().compareTo("iPhone 5s") != 0) {
                set = String.valueOf(set) + "\t-Model=iPhone 5s";
                this.incrementAz_Model();
            }
            if (exifFoto.getModel().startsWith("iPhone SE") && exifFoto.getModelKurz().compareTo("iPhone SE") != 0) {
                set = String.valueOf(set) + "\t-Model=iPhone SE";
                this.incrementAz_Model();
            }
            if (exifFoto.getModel().startsWith("iPad") && exifFoto.getModelKurz().compareTo("iPad 4") != 0) {
                set = String.valueOf(set) + "\t-Model=iPad 4";
                this.incrementAz_Model();
            }
        }
        if (exifFoto.isKameraBekannt() && exifFoto.getKameraSeriennummer().length() > 1 && exifFoto.getKameraSeriennummer().compareTo(exifFoto.getSerialNumber()) != 0) {
            set = String.valueOf(set) + "\t-SerialNumber=" + exifFoto.getKameraSeriennummer();
            this.incrementAz_SerialNumber();
        }
        if (exifFoto.getCreatorTool().startsWith("FileNumber:")) {
            set = String.valueOf(set) + "\t-CreatorTool=";
            this.incrementAz_CreatorTool();
        }
        if (this.isExifAlleTagsSchreiben()) {
            if (!exifFoto.isDownloadFromWeb()) {
                if (exifFoto.getArtist().length() <= 1) {
                    set = String.valueOf(set) + "\t-Artist=Johann Fischer, Neusaess";
                    this.incrementAz_Artist();
                } else if (exifFoto.getArtist().compareTo("Johann Fischer, Neusaess") != 0 && this.isExifTagsUeberSchreiben()) {
                    set = String.valueOf(set) + "\t-Artist=Johann Fischer, Neusaess";
                    this.incrementAz_Artist();
                }
                if (exifFoto.getCopyright().length() <= 1) {
                    set = String.valueOf(set) + "\t-Copyright=Johann Fischer, Neusaess";
                    this.incrementAz_Copyright();
                } else if (exifFoto.getCopyright().compareTo("Johann Fischer, Neusaess") != 0 && this.isExifTagsUeberSchreiben()) {
                    set = String.valueOf(set) + "\t-Copyright=Johann Fischer, Neusaess";
                    this.incrementAz_Copyright();
                }
            }
            if (exifFoto.isPicture()) {
                if (exifFoto.getProcessingSoftware().length() <= 1) {
                    set = String.valueOf(set) + "\t-ProcessingSoftware=de.nss.jfi.RenameMedien.class in jfi.jar";
                    this.incrementAz_ProcessingSoftware();
                } else if (!exifFoto.getProcessingSoftware().contains("de.nss.jfi.GPS.class in jfi.jar") && exifFoto.getProcessingSoftware().compareTo("de.nss.jfi.RenameMedien.class in jfi.jar") != 0 && this.isExifTagsUeberSchreiben()) {
                    set = String.valueOf(set) + "\t-ProcessingSoftware=de.nss.jfi.RenameMedien.class in jfi.jar";
                    this.incrementAz_ProcessingSoftware();
                }
            }
        }
        if (set.length() > 0) {
            exifToolStatement.add(String.valueOf(FDatei.checkFileSeperator(String.valueOf(exifFoto.getDirectory()) + System.getProperty("file.separator") + (this.getFunktion().charAt(0) == 'W' ? exifFoto.getFileNameBase() : exifFoto.getFileNameBaseNeu()) + "." + exifFoto.getFileNameExtend(), false)) + set);
        }
    }

    private void checkSortierStringVorneAbschneiden(ArrayList<RenameMedienZeile> exifFotos) {
        if (this.isAutomatischVorneAbschneiden() && this.isSortierbareNamen()) {
            ArrayList<String> sortString = new ArrayList<String>();
            FGregorianCalendar datumExif = new FGregorianCalendar();
            RenameMedienZeile exifFoto = new RenameMedienZeile();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss");
            int i = 0;
            while (i < exifFotos.size()) {
                try {
                    exifFoto = exifFotos.get(i);
                    datumExif.setTime(dateFormat.parse(exifFoto.getExifDateTime()), true);
                    sortString.add(datumExif.toGermanFormat('T'));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ++i;
            }
            this.setVorneAbschneiden(FString.redundanteStellenVorne(FString.arrayListToStringArray(sortString)));
        }
    }

    private int getAz_Artist() {
        return this.az_Artist;
    }

    private int getAz_Copyright() {
        return this.az_Copyright;
    }

    private int getAz_CreatorTool() {
        return this.az_CreatorTool;
    }

    private int getAz_datum_change_failed() {
        return this.az_datum_change_failed;
    }

    private int getAz_datum_changed() {
        return this.az_datum_changed;
    }

    private int getAz_datum_ok() {
        return this.az_datum_ok;
    }

    private int getAz_datum_to_change() {
        return this.az_datum_to_change;
    }

    private int getAz_datumfelder_nicht_korrekt() {
        return this.az_datumfelder_nicht_korrekt;
    }

    private int getAz_exifdatum_nicht_vorhanden() {
        return this.az_exifdatum_nicht_vorhanden;
    }

    private int getAz_ImageHistory() {
        return this.az_ImageHistory;
    }

    private int getAz_ImageNumber() {
        return this.az_ImageNumber;
    }

    private int getAz_kamera_unbekannt() {
        return this.az_kamera_unbekannt;
    }

    private int getAz_Make() {
        return this.az_Make;
    }

    private int getAz_Model() {
        return this.az_Model;
    }

    private int getAz_ModelNotice() {
        return this.az_ModelNotice;
    }

    private int getAz_name_ok() {
        return this.az_name_ok;
    }

    private int getAz_OriginalFileName() {
        return this.az_OriginalFileName;
    }

    private int getAz_ProcessingSoftware() {
        return this.az_ProcessingSoftware;
    }

    private int getAz_rename_failed() {
        return this.az_rename_failed;
    }

    private int getAz_rename_nicht_entscheidbar() {
        return this.az_rename_nicht_entscheidbar;
    }

    private int getAz_renamed() {
        return this.az_renamed;
    }

    private int getAz_SerialNumber() {
        return this.az_SerialNumber;
    }

    private int getAz_to_rename() {
        return this.az_to_rename;
    }

    private int getBildnummerMax(ArrayList<RenameMedienZeile> exifFotos) {
        int maxBildNr = -1;
        int bildNr = 0;
        for (RenameMedienZeile element : exifFotos) {
            RenameMedienZeile exifFoto = element;
            if (exifFoto.getBildnummer4stellig().length() < 4 && exifFoto.getFileNameBase().compareTo(exifFoto.getOriginalFileNameSoll()) != 0) continue;
            try {
                bildNr = Integer.parseInt(exifFoto.getBildnummer4stellig());
            }
            catch (NumberFormatException e) {
                bildNr = 0;
            }
            maxBildNr = Math.max(bildNr, maxBildNr);
        }
        return FMath.checkRange(maxBildNr, this.getFileNameAutoMinimum(), 9800);
    }

    public String getCheckAusgabedatei() {
        return this.CheckAusgabedatei;
    }

    public String getCheckdatei() {
        return this.Checkdatei;
    }

    public String[][] getCheckKameraDaten() {
        return this.CheckKameraDaten;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public int getDeltaBeiZeitvergleich() {
        return this.DeltaBeiZeitvergleich;
    }

    private ArrayList<RenameMedienZeile> getExifDaten() {
        ArrayList<RenameMedienZeile> exifToolZeilen = new ArrayList<RenameMedienZeile>();
        RenameMedienZeile exifFoto = new RenameMedienZeile();
        String[] seps = new String[]{"\\", "/"};
        String[] werte = null;
        String[] tags = new String[]{"-Directory", "-FileName", "-Model", "-Artist", "-Copyright", "-Makernotes:SerialNumber", "-SerialNumber", "-FileModifyDate", "-DateTimeOriginal", "-CreateDate", "-GPSDateTime", "-FileNumber", "-XMP:ImageHistory", "-ImageNumber", "-Lensmodel", "-Make", "-ProcessingSoftware", "-Warning", "-OriginalFileName", "-OriginalFileName", "-CreatorTool", "-ScanInfo", "-ModelOriginal", "-MakeOriginal", "-SerialNumberOriginal", "-ScanFileNumber", "-ModelNotice", "-ScanModel"};
        String[][] fotos = FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(this.getExifToolParm().split(" "), FString.verbindenStringArray(tags, new String[]{"-d", "%d.%m.%Y-%H:%M:%S", "-T", "-r", "-ext", "JPEG", "-ext", "CR2", "-ext", "CR3", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV", this.getVerzeichnis()}))), 5), "UTF-8"), tags.length, true);
        fotos = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(fotos)));
        String[][] stringArray = fotos = FDatei.clearTags(fotos);
        int n = fotos.length;
        int n2 = 0;
        while (n2 < n) {
            String[] foto = stringArray[n2];
            exifFoto = new RenameMedienZeile();
            exifFoto.setScanInfo(foto[21]);
            exifFoto.setModelOriginal(foto[22]);
            exifFoto.setMakeOriginal(foto[23]);
            exifFoto.setSerialNumberOriginal(foto[24]);
            exifFoto.setScanFileNumber(foto[25]);
            exifFoto.setScanModel(foto[27]);
            exifFoto.setSerialNumber(exifFoto.isScanInfoVorhanden() ? exifFoto.getSerialNumberOriginal() : (foto[6].length() > 1 ? foto[6] : foto[5]));
            exifFoto.setDownloadFromWeb(exifFoto.getSerialNumber().compareToIgnoreCase("DownloadFromWeb") == 0);
            exifFoto.setScreenshot(exifFoto.getSerialNumber().compareToIgnoreCase("Screenshot") == 0);
            exifFoto.setWhatsApp(exifFoto.getSerialNumber().compareToIgnoreCase("WhatsApp") == 0);
            exifFoto.setWebcam(exifFoto.getSerialNumber().compareToIgnoreCase("Webcam") == 0);
            exifFoto.setDirectory(foto[0]);
            exifFoto.setFileNameBase(foto[1]);
            exifFoto.setFileNameBaseNeu("");
            exifFoto.setFileNameExtend("");
            exifFoto.setModel(exifFoto.isDownloadFromWeb() ? "DownloadFromWeb" : (exifFoto.isScreenshot() ? "Screenshot" : (exifFoto.isWhatsApp() ? "WhatsApp" : (exifFoto.isWebcam() ? "Webcam" : (exifFoto.isScanInfoVorhanden() && !exifFoto.getModelOriginal().isEmpty() ? exifFoto.getModelOriginal() : (!exifFoto.getScanModel().isEmpty() ? exifFoto.getScanModel() : foto[2]))))));
            exifFoto.setModelKurz(exifFoto.isScanInfoVorhanden() && !exifFoto.getModelOriginal().isEmpty() ? exifFoto.getModelOriginal() : foto[2]);
            exifFoto.setArtist(foto[3]);
            exifFoto.setCopyright(foto[4]);
            exifFoto.setFileModifyDate(foto[7]);
            exifFoto.setDateTimeOriginal(foto[8].length() > 1 ? foto[8] : (foto[9].length() > 1 ? foto[9] : foto[7]));
            exifFoto.setDateTimeVglKameraDaten(exifFoto.getDateTimeOriginal().length() > 10 ? exifFoto.getDateTimeOriginal() : (exifFoto.isScanInfoVorhanden() && foto[9].length() > 1 ? foto[9] : exifFoto.getFileModifyDate()));
            exifFoto.setGPSDateTime(foto[10]);
            exifFoto.setFileNumber(exifFoto.isDownloadFromWeb() || exifFoto.isScreenshot() ? "" : (exifFoto.isScanInfoVorhanden() && !exifFoto.getScanFileNumber().isEmpty() ? exifFoto.getScanFileNumber() : (exifFoto.isMyM50() ? foto[12] : foto[11])));
            exifFoto.setImageHistory(foto[12]);
            exifFoto.setImageNumber(foto[13]);
            exifFoto.setLensmodel(foto[14]);
            exifFoto.setMake(exifFoto.isScanInfoVorhanden() && !exifFoto.getMakeOriginal().isEmpty() ? exifFoto.getMakeOriginal() : foto[15]);
            exifFoto.setProcessingSoftware(foto[16]);
            exifFoto.setWarning(foto[17]);
            exifFoto.setRawFileName(foto[18]);
            exifFoto.setOriginalFileName(foto[19]);
            exifFoto.setCreatorTool(foto[20]);
            exifFoto.setModelNotiz(foto[26]);
            String[] stringArray2 = seps;
            int n3 = seps.length;
            int n4 = 0;
            while (n4 < n3) {
                String sep = stringArray2[n4];
                if (foto[17].indexOf(sep) >= 0) {
                    exifFoto.setRawFileName(foto[17].substring(foto[17].lastIndexOf(sep) + 1));
                    break;
                }
                ++n4;
            }
            if (this.isGPSDatumVerwenden() && exifFoto.getModel().compareTo("Canon EOS 400D DIGITAL") != 0 && exifFoto.getModel().compareTo("Canon EOS M50") != 0 && exifFoto.getModel().compareTo("Johann Fischer, Neusaess") != 0 && exifFoto.getGPSDateTime().length() > 18 && exifFoto.getGPSDateTime().compareTo(exifFoto.getDateTimeOriginal()) != 0) {
                exifFoto.setExifDateTime(exifFoto.getGPSDateTime());
                exifFoto.setGPSDateTimeUsed(true);
            } else {
                exifFoto.setExifDateTime(exifFoto.getDateTimeOriginal());
                exifFoto.setGPSDateTimeUsed(false);
            }
            exifFoto.setDirectory(FDatei.checkFileSeperator(exifFoto.getDirectory(), false));
            FDatei.DateinamenTeile teile = FDatei.instance().zerlegeDateiname(exifFoto.getFileNameBase(), "_");
            exifFoto.setFileNameBase(teile.getName());
            exifFoto.setFileNameBaseNeu("ccc_xx_" + (exifFoto.getOriginalFileName().isEmpty() ? teile.getNumerischesEndeVonBas4stellig() : FDatei.instance().zerlegeDateiname(exifFoto.getOriginalFileName(), "_").getNumerischesEndeVonBas4stellig()));
            exifFoto.setImageNumberSoll("1xx" + teile.getNumerischesEndeVonBas4stellig());
            exifFoto.setFileNameExtend(teile.getExtend());
            werte = this.getKameraDaten(exifFoto.getModel(), exifFoto.getDateTimeVglKameraDaten().length() > 10 ? String.valueOf(exifFoto.getDateTimeVglKameraDaten().substring(6, 10)) + exifFoto.getDateTimeVglKameraDaten().substring(2, 6) + exifFoto.getDateTimeVglKameraDaten().substring(0, 2) : String.valueOf(exifFoto.getFileModifyDate().substring(6, 10)) + exifFoto.getFileModifyDate().substring(2, 6) + exifFoto.getFileModifyDate().substring(0, 2), this.isCheckSerienNummer() ? exifFoto.getSerialNumber() : null);
            exifFoto.setKameraNameKurz(werte != null ? werte[0] : null);
            exifFoto.setKameraBildSerie(werte != null ? werte[1] : null);
            exifFoto.setKameraBildStamm(werte != null ? (exifFoto.isVideo() ? werte[2].replace("IMG", "MVI") : werte[2]) : null);
            exifFoto.setKameraSeriennummer(werte != null ? werte[3] : null);
            exifFoto.setKameraCopyrightUndArtist(werte != null ? werte[4] : null);
            exifFoto.setKameraNotiz(werte != null ? werte[5] : null);
            exifFoto.setKameraBekannt(werte != null);
            if (exifFoto.getModel().compareToIgnoreCase("Fast Camera") == 0 && exifFoto.getLensmodel().startsWith("iPhone 5s")) {
                exifFoto.setModel("iPhone 5s (Fast Camera)");
            } else if (exifFoto.getModel().compareTo("-") == 0 && exifFoto.getLensmodel().startsWith("iPhone 5s")) {
                exifFoto.setModel("iPhone 5s");
            } else if (exifFoto.getModel().compareTo("Superburst for iPhone") == 0) {
                exifFoto.setModel("iPhone 5s (Superburst)");
            }
            if (exifFoto.getFileNumber().length() >= 8 && exifFoto.getFileNumber().charAt(3) == '-') {
                exifFoto.setImageNumber(exifFoto.getFileNumber().replaceAll("-", ""));
                exifFoto.setFileNumber(String.valueOf(exifFoto.getFileNumber().substring(1, 3)) + "_" + exifFoto.getFileNumber().substring(4));
            }
            if ((exifFoto.getModel().startsWith("iPhone") || exifFoto.getModel().startsWith("iPad") || exifFoto.isDownloadFromWeb() || exifFoto.isScreenshot()) && (exifFoto.getFileNumber().compareTo("-") == 0 || exifFoto.getFileNumber().length() == 0) && exifFoto.getImageNumber().length() == 7) {
                exifFoto.setFileNumber(String.valueOf(exifFoto.getImageNumber().substring(1, 3)) + "_" + exifFoto.getImageNumber().substring(3));
            }
            if (exifFoto.getOriginalFileName().length() <= 1) {
                if (exifFoto.getRawFileName().length() >= 12) {
                    exifFoto.setOriginalFileNameSoll(FDatei.instance().zerlegeDateiname(exifFoto.getRawFileName(), "_").getName());
                } else if (exifFoto.isKameraBekannt()) {
                    exifFoto.setOriginalFileNameSoll(String.valueOf(exifFoto.getKameraBildStamm()) + (exifFoto.getBildnummer4stellig().length() == 4 ? exifFoto.getBildnummer4stellig() : teile.getNumerischesEndeVonBas4stellig()));
                }
            } else {
                exifFoto.setOriginalFileNameSoll(exifFoto.getOriginalFileName());
            }
            if (exifFoto.getFileNameBaseNeu().endsWith("0000") && exifFoto.getOriginalFileNameSoll() != null && exifFoto.getOriginalFileNameSoll().length() > 4 && !exifFoto.getOriginalFileNameSoll().endsWith("0000")) {
                exifFoto.setFileNameBaseNeu(String.valueOf(exifFoto.getFileNameBaseNeu().substring(0, 7)) + exifFoto.getOriginalFileNameSoll().substring(exifFoto.getOriginalFileNameSoll().length() - 4));
            }
            if (exifFoto.getImageNumberSoll().endsWith("0000") && exifFoto.getOriginalFileNameSoll() != null && exifFoto.getOriginalFileNameSoll().length() > 4 && !exifFoto.getOriginalFileNameSoll().endsWith("0000")) {
                exifFoto.setImageNumberSoll(String.valueOf(exifFoto.getImageNumberSoll().substring(0, 3)) + exifFoto.getOriginalFileNameSoll().substring(exifFoto.getOriginalFileNameSoll().length() - 4));
            }
            if (exifFoto.isKameraBekannt()) {
                exifFoto.setFileNameBaseNeu(exifFoto.getFileNameBaseNeu().replace("ccc_", String.valueOf(exifFoto.getKameraNameKurz()) + "_"));
                exifFoto.setImageNumberSoll((String.valueOf(exifFoto.getImageNumberSoll().replace("xx", exifFoto.getKameraBildSerie())) + "0000000").substring(0, 7));
            }
            exifToolZeilen.add(exifFoto);
            ++n2;
        }
        return exifToolZeilen;
    }

    public String getExifToolParm() {
        return this.ExifToolParm;
    }

    public int getFileNameAutoMinimum() {
        return this.FileNameAutoMinimum;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String getKameraBildStamm() {
        return this.KameraBildStamm;
    }

    private String[] getKameraDaten(String Camera, String Datum, String SerNr) {
        String[] werte = null;
        String[][] stringArray = this.getCheckKameraDaten();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (Camera.startsWith(element[0]) && Datum.compareTo(element[2]) >= 0 && Datum.compareTo(element[3]) <= 0 && (SerNr == null || SerNr.compareTo(element[1]) == 0)) {
                werte = new String[]{element[4], element[5].compareTo("*") == 0 ? Datum.substring(2, 4) : element[5], element[6], element[1], element[7], element[8]};
                break;
            }
            ++n2;
        }
        if (werte == null && this.isUnbekannteKamerasHaendeln()) {
            werte = new String[]{this.KameraUnbekannt[4], this.KameraUnbekannt[5].compareTo("*") == 0 ? Datum.substring(2, 4) : this.KameraUnbekannt[5], this.KameraUnbekannt[6], this.KameraUnbekannt[1], this.KameraUnbekannt[7], this.KameraUnbekannt[8]};
        }
        return werte;
    }

    public String getKameraNameImBild() {
        return this.KameraNameImBild;
    }

    public String getKameraSerie() {
        return this.KameraSerie;
    }

    public String getNamensTabelle() {
        return this.NamensTabelle;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "10.2.2018 11:00";
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public int getVorneAbschneiden() {
        return this.VorneAbschneiden;
    }

    private void incrementAz_Artist() {
        ++this.az_Artist;
    }

    private void incrementAz_Copyright() {
        ++this.az_Copyright;
    }

    private void incrementAz_CreatorTool() {
        ++this.az_CreatorTool;
    }

    private void incrementAz_datum_change_failed() {
        ++this.az_datum_change_failed;
    }

    private void incrementAz_datum_changed() {
        ++this.az_datum_changed;
    }

    private void incrementAz_datum_ok() {
        ++this.az_datum_ok;
    }

    private void incrementAz_datum_to_change() {
        ++this.az_datum_to_change;
    }

    private void incrementAz_datumfelder_nicht_korrekt() {
        ++this.az_datumfelder_nicht_korrekt;
    }

    private void incrementAz_ImageHistory() {
        ++this.az_ImageHistory;
    }

    private void incrementAz_ImageNumber() {
        ++this.az_ImageNumber;
    }

    private void incrementAz_kamera_unbekannt() {
        ++this.az_kamera_unbekannt;
    }

    private void incrementAz_Make() {
        ++this.az_Make;
    }

    private void incrementAz_Model() {
        ++this.az_Model;
    }

    private void incrementAz_ModelNotice() {
        ++this.az_ModelNotice;
    }

    private void incrementAz_name_ok() {
        ++this.az_name_ok;
    }

    private void incrementAz_OriginalFileName() {
        ++this.az_OriginalFileName;
    }

    private void incrementAz_ProcessingSoftware() {
        ++this.az_ProcessingSoftware;
    }

    private void incrementAz_rename_failed() {
        ++this.az_rename_failed;
    }

    private void incrementAz_rename_nicht_entscheidbar() {
        ++this.az_rename_nicht_entscheidbar;
    }

    private void incrementAz_renamed() {
        ++this.az_renamed;
    }

    private void incrementAz_SerialNumber() {
        ++this.az_SerialNumber;
    }

    private void incrementAz_to_rename() {
        ++this.az_to_rename;
    }

    private void initAz_Artist() {
        this.az_Artist = 0;
    }

    private void initAz_Copyright() {
        this.az_Copyright = 0;
    }

    private void initAz_CreatorTool() {
        this.az_CreatorTool = 0;
    }

    private void initAz_datum_change_failed() {
        this.az_datum_change_failed = 0;
    }

    private void initAz_datum_changed() {
        this.az_datum_changed = 0;
    }

    private void initAz_datum_ok() {
        this.az_datum_ok = 0;
    }

    private void initAz_datum_to_change() {
        this.az_datum_to_change = 0;
    }

    private void initAz_datumfelder_nicht_korrekt() {
        this.az_datumfelder_nicht_korrekt = 0;
    }

    private void initAz_ImageHistory() {
        this.az_ImageHistory = 0;
    }

    private void initAz_ImageNumber() {
        this.az_ImageNumber = 0;
    }

    private void initAz_kamera_unbekannt() {
        this.az_kamera_unbekannt = 0;
    }

    private void initAz_Make() {
        this.az_Make = 0;
    }

    private void initAz_Model() {
        this.az_Model = 0;
    }

    private void initAz_ModelNotice() {
        this.az_ModelNotice = 0;
    }

    private void initAz_name_ok() {
        this.az_name_ok = 0;
    }

    private void initAz_OriginalFileName() {
        this.az_OriginalFileName = 0;
    }

    private void initAz_ProcessingSoftware() {
        this.az_ProcessingSoftware = 0;
    }

    private void initAz_rename_failed() {
        this.az_rename_failed = 0;
    }

    private void initAz_rename_nicht_entscheidbar() {
        this.az_rename_nicht_entscheidbar = 0;
    }

    private void initAz_renamed() {
        this.az_renamed = 0;
    }

    private void initAz_SerialNumber() {
        this.az_SerialNumber = 0;
    }

    private void initAz_to_rename() {
        this.az_to_rename = 0;
    }

    public boolean isAutomatischVorneAbschneiden() {
        return this.AutomatischVorneAbschneiden;
    }

    public boolean isCheckAutor() {
        return this.CheckAutor;
    }

    public boolean isCheckCopyright() {
        return this.CheckCopyright;
    }

    public boolean isCheckPrint() {
        return this.CheckPrint;
    }

    public boolean isCheckSerienNummer() {
        return this.CheckSerienNummer;
    }

    public boolean isExif2ModifyDate() {
        return this.Exif2ModifyDate;
    }

    public boolean isExifAlleTagsSchreiben() {
        return this.ExifAlleTagsSchreiben;
    }

    public boolean isExifBasisdatenSchreiben() {
        return this.ExifBasisdatenSchreiben;
    }

    public boolean isExifTagsSchreiben() {
        return this.ExifTagsSchreiben;
    }

    public boolean isExifTagsUeberSchreiben() {
        return this.ExifTagsUeberSchreiben;
    }

    public boolean isGPSDatumVerwenden() {
        return this.GPSDatumVerwenden;
    }

    private boolean isNamensTabelleSchreiben() {
        return this.NamensTabelleSchreiben;
    }

    public boolean isOriginalDateinamen() {
        return this.OriginalDateinamen;
    }

    public boolean isOriginalFileNameAuto() {
        return this.OriginalFileNameAuto;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isSortierbareNamen() {
        return this.SortierbareNamen;
    }

    public boolean isSortierbarGrossKlein() {
        return this.SortierbarGrossKlein;
    }

    public boolean isUnbekannteKamerasHaendeln() {
        return this.UnbekannteKamerasHaendeln;
    }

    private void printCheckKameraDaten() {
        if (this.isCheckPrint()) {
            FProt.instance().prot(FString.convertTabelleToStringArray(this.getCheckKameraDaten()));
            if (this.getCheckAusgabedatei().length() > 0) {
                new FFile(this.getCheckAusgabedatei()).StringArrayToInhalt(FString.convertTabelleToStringArray(this.getCheckKameraDaten()));
            }
        }
    }

    public void run() {
        FProt fProt = FProt.instance();
        this.runVorlauf();
        ArrayList<String> exifStatement = new ArrayList<String>();
        ArrayList<String> namensTabelle = new ArrayList<String>();
        RenameMedienZeile exifFoto = new RenameMedienZeile();
        String neuerName = "";
        String datumVergleich = "";
        FGregorianCalendar datumDatei = new FGregorianCalendar();
        FGregorianCalendar datumExif = new FGregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss");
        this.setCheckKameraDaten();
        ArrayList<RenameMedienZeile> exifMedien = this.getExifDaten();
        if (exifMedien.size() == 0) {
            fProt.prot(String.valueOf(this.getVerzeichnis()) + " nicht vorhanden oder hat keine Medien mit Exifdaten");
        } else {
            String[] zeile = new String[exifMedien.size() + 1];
            int i = 0;
            while (i < exifMedien.size()) {
                exifFoto = exifMedien.get(i);
                if (i == 0) {
                    zeile[0] = exifFoto.printAllHeader();
                }
                zeile[i + 1] = exifFoto.printAll();
                ++i;
            }
            new FFile("/Volumes/RamDisk/ListeAllePur.txt").StringArrayToInhalt(zeile);
            if (this.isOriginalFileNameAuto()) {
                int maxBildNr = this.getBildnummerMax(exifMedien);
                this.setBildnummerAuto(exifMedien, maxBildNr, exifStatement);
            }
            this.checkSortierStringVorneAbschneiden(exifMedien);
            this.printCheckKameraDaten();
            i = 0;
            while (i < exifMedien.size()) {
                exifFoto = exifMedien.get(i);
                if (exifFoto.getWarning().length() > 1) {
                    fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " Exif-Warnung: " + exifFoto.getWarning(), 0);
                }
                if (!exifFoto.isKameraBekannt()) {
                    this.incrementAz_kamera_unbekannt();
                }
                if (exifFoto.getExifDateTime().length() == 0) {
                    fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " Exif-Datum/Uhrzeit nicht vorhanden", 0);
                    ++this.az_exifdatum_nicht_vorhanden;
                } else {
                    boolean datumFelderKorrekt;
                    try {
                        datumDatei.setTime(dateFormat.parse(exifFoto.getFileModifyDate()), true);
                        datumExif.setTime(dateFormat.parse(exifFoto.getExifDateTime()), true);
                        datumFelderKorrekt = true;
                    }
                    catch (ParseException e) {
                        datumFelderKorrekt = false;
                    }
                    if (!datumFelderKorrekt) {
                        fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + ": " + exifFoto.getFileModifyDate() + " und/oder " + exifFoto.getExifDateTime() + " nicht im korrekten Format", 0);
                        this.incrementAz_datumfelder_nicht_korrekt();
                    } else if (exifFoto.getFileModifyDate().compareTo(exifFoto.getExifDateTime()) == 0 || Math.abs(datumDatei.getTimeInMillis() - datumExif.getTimeInMillis()) <= (long)(this.getDeltaBeiZeitvergleich() * 1000) || Math.abs(datumDatei.getTimeInMillis() + 3600000L - datumExif.getTimeInMillis()) <= (long)(this.getDeltaBeiZeitvergleich() * 1000) || Math.abs(datumDatei.getTimeInMillis() - 3600000L - datumExif.getTimeInMillis()) <= (long)(this.getDeltaBeiZeitvergleich() * 1000)) {
                        fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " Datum/Uhrzeit korrekt", 2);
                        this.incrementAz_datum_ok();
                    } else if (this.isExif2ModifyDate()) {
                        if (this.getFunktion().charAt(0) == 'T') {
                            fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + ": " + exifFoto.getFileModifyDate() + " -> " + exifFoto.getExifDateTime() + " to change", 0);
                            this.incrementAz_datum_to_change();
                        } else {
                            try {
                                new File(exifFoto.getDirectory(), String.valueOf(exifFoto.getFileNameBase()) + "." + exifFoto.getFileNameExtend()).setLastModified(datumExif.getTimeInMillis());
                                fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + ": " + exifFoto.getFileModifyDate() + " -> " + exifFoto.getExifDateTime() + " changed", 0);
                                this.incrementAz_datum_changed();
                            }
                            catch (Exception e) {
                                fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + ": " + exifFoto.getFileModifyDate() + " -> " + exifFoto.getExifDateTime() + " change nicht erfolgreich", 0);
                                this.incrementAz_datum_change_failed();
                            }
                        }
                    }
                }
                if (exifFoto.isDownloadFromWeb() || (!this.isCheckAutor() || this.isCheckAutor() && exifFoto.getArtist().startsWith("Johann Fischer, Neusaess")) && (!this.isCheckCopyright() || this.isCheckCopyright() && exifFoto.getCopyright().startsWith("Johann Fischer, Neusaess"))) {
                    if (this.isOriginalDateinamen()) {
                        if (exifFoto.getOriginalFileNameSoll() != null) {
                            exifFoto.setFileNameBaseNeu(exifFoto.getOriginalFileNameSoll());
                        } else {
                            fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " Bildnummer/Originaldateiname/RawFilename in Exif nicht oder nicht korrekt vorhanden");
                        }
                    }
                    if (exifFoto.isKameraBekannt()) {
                        if (this.isSortierbareNamen()) {
                            neuerName = exifFoto.getFileNameBaseNeu();
                            datumVergleich = datumExif.toGermanFormat('T');
                            if (this.getVorneAbschneiden() > 0 && this.getVorneAbschneiden() < datumVergleich.length()) {
                                datumVergleich = datumVergleich.substring(this.getVorneAbschneiden());
                            }
                            if (this.isSortierbarGrossKlein()) {
                                datumVergleich = FString.stringGrossKlein(datumVergleich);
                            }
                            exifFoto.setFileNameBaseNeu(String.valueOf(datumVergleich) + "_" + exifFoto.getFileNameBaseNeu().replace("xx_", ""));
                        }
                        exifFoto.setFileNameBaseNeu(exifFoto.getFileNameBaseNeu().replace("xx_", String.valueOf(exifFoto.getKameraBildSerie()) + "_"));
                    }
                    if (this.isNamensTabelleSchreiben()) {
                        namensTabelle.add(String.valueOf(neuerName.replace("xx_", String.valueOf(exifFoto.getKameraBildSerie()) + "_")) + "." + exifFoto.getFileNameExtend() + "\t" + exifFoto.getFileNameBaseNeu() + "." + exifFoto.getFileNameExtend());
                    }
                }
                if (exifFoto.getFileNameBase().startsWith(exifFoto.getFileNameBaseNeu()) && !exifFoto.getFileNameBaseNeu().endsWith("_")) {
                    fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " Name korrekt", 2);
                    if (exifFoto.getFileNameBase().compareTo(exifFoto.getFileNameBaseNeu()) != 0) {
                        exifFoto.setFileNameBaseNeu(exifFoto.getFileNameBase());
                    }
                    this.incrementAz_name_ok();
                    if (this.isExifTagsSchreiben()) {
                        this.checkAndSetExifStatement(exifFoto, exifStatement);
                    }
                } else if (exifFoto.getFileNameBaseNeu().startsWith("ccc_xx") || exifFoto.getFileNameBaseNeu().startsWith("null_xx") || exifFoto.getFileNameBaseNeu().endsWith("_") || exifFoto.getFileNameBaseNeu().endsWith("0000") || exifFoto.getOriginalFileNameSoll().isEmpty() || !exifFoto.getOriginalFileNameSoll().startsWith("IMG_") && !exifFoto.getOriginalFileNameSoll().startsWith("MVI_") && !exifFoto.getOriginalFileNameSoll().startsWith("WebDl_") && !exifFoto.getOriginalFileNameSoll().startsWith("Scrsh_") && !exifFoto.getOriginalFileNameSoll().startsWith("DSC_") && !exifFoto.getOriginalFileNameSoll().startsWith("UBK_") || exifFoto.getOriginalFileNameSoll().length() == 8 && !exifFoto.getOriginalFileNameSoll().substring(4, 8).matches("[0-9]*")) {
                    if (this.getFunktion().charAt(0) != 'W') {
                        fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " rename nicht entscheidbar (neu waere: " + exifFoto.getFileNameBaseNeu() + ")", 0);
                        this.incrementAz_rename_nicht_entscheidbar();
                    }
                } else {
                    if (this.getFunktion().charAt(0) == 'T') {
                        fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " -> " + exifFoto.getFileNameBaseNeu() + "." + exifFoto.getFileNameExtend() + " to rename", 0);
                        this.incrementAz_to_rename();
                    } else if (this.getFunktion().charAt(0) == 'R') {
                        neuerName = new FFile(String.valueOf(exifFoto.getDirectory()) + System.getProperty("file.separator") + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend()).renameTo(exifFoto.getDirectory(), String.valueOf(exifFoto.getFileNameBaseNeu()) + "." + exifFoto.getFileNameExtend());
                        if (neuerName.length() > 0) {
                            exifFoto.setFileNameBaseNeu(FDatei.instance().zerlegeDateiname(neuerName).getName());
                            fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " -> " + exifFoto.getFileNameBaseNeu() + "." + exifFoto.getFileNameExtend() + " renamed", 0);
                            this.incrementAz_renamed();
                        } else {
                            fProt.prot(String.valueOf(exifFoto.getDirectory()) + ": " + exifFoto.getFileNameBase() + "." + exifFoto.getFileNameExtend() + " -> " + exifFoto.getFileNameBaseNeu() + "." + exifFoto.getFileNameExtend() + " renamed nicht erfolgreich", 0);
                            this.incrementAz_rename_failed();
                        }
                    }
                    if (this.isExifTagsSchreiben()) {
                        this.checkAndSetExifStatement(exifFoto, exifStatement);
                    }
                }
                ++i;
            }
            if (exifStatement.size() > 0) {
                fProt.prot("Folgende Exiftoolaufrufe " + (this.getFunktion().charAt(0) != 'T' ? "werden ausgefuehrt" : "sind notwendig"), 0);
                i = 0;
                while (i < exifStatement.size()) {
                    if (this.getFunktion().charAt(0) != 'T') {
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(FString.verbindenArrayMitString(Futi.getBenutzerWert("ExiftoolParameter").split(" "), "-P"), exifStatement.get(i).split("\t")), 5);
                    }
                    fProt.prot(exifStatement.get(i).replace('\t', ' '), 0);
                    ++i;
                }
            }
            if (this.isNamensTabelleSchreiben()) {
                new FFile(this.getVerzeichnis(), this.getNamensTabelle()).StringArrayListToInhalt(namensTabelle);
            }
            this.runNachlauf(exifMedien.size());
        }
    }

    void runNachlauf(int anzahl_dateien) {
        FProt fProt = FProt.instance();
        fProt.prot("Dateien im Verz. inkl. UnterVerz.  : " + anzahl_dateien);
        if (this.getAz_kamera_unbekannt() > 0) {
            fProt.prot("Kamera und/oder Aufndat. unbekannt : " + this.getAz_kamera_unbekannt());
        }
        if (this.getAz_exifdatum_nicht_vorhanden() > 0) {
            fProt.prot("Exif-Datum/Uhrzeit nicht vorhanden : " + this.getAz_exifdatum_nicht_vorhanden());
        }
        if (this.getAz_datumfelder_nicht_korrekt() > 0) {
            fProt.prot("Exif-Datum/Uhrzeit nicht korrekt   : " + this.getAz_datumfelder_nicht_korrekt());
        }
        if (this.getAz_datum_ok() > 0) {
            fProt.prot("Datum/Uhrzeit Datei gleich Exif    : " + this.getAz_datum_ok());
        }
        if (this.getAz_datum_to_change() > 0) {
            fProt.prot("Datum/Uhrzeit Datei ungleich Exif  : " + this.getAz_datum_to_change());
        }
        if (this.getAz_datum_changed() > 0) {
            fProt.prot("Datum/Uhrzeit Datei geaendert      : " + this.getAz_datum_changed());
        }
        if (this.getAz_datum_change_failed() > 0) {
            fProt.prot("Fehler beim Aendern Datum/Uhrzeit  : " + this.getAz_datum_change_failed());
        }
        if (this.getAz_name_ok() > 0) {
            fProt.prot("Dateinamen korrekt                 : " + this.getAz_name_ok());
        }
        if (this.getAz_to_rename() > 0) {
            fProt.prot("Dateien umzubenennen               : " + this.getAz_to_rename());
        }
        if (this.getAz_renamed() > 0) {
            fProt.prot("Dateien umbenannt                  : " + this.getAz_renamed());
        }
        if (this.getAz_rename_failed() > 0) {
            fProt.prot("Fehler beim Umbennen von  Dateien  : " + this.getAz_rename_failed());
        }
        if (this.getAz_rename_nicht_entscheidbar() > 0) {
            fProt.prot("Nicht entscheidbar, ob Name korrekt: " + this.getAz_rename_nicht_entscheidbar());
        }
        if (this.getAz_Artist() + this.getAz_Copyright() + this.getAz_ImageNumber() + this.getAz_Make() + this.getAz_Model() + this.getAz_OriginalFileName() + this.getAz_ProcessingSoftware() + this.getAz_SerialNumber() > 0) {
            fProt.prot("Folgende Metadaten in Exif " + (this.getFunktion().charAt(0) == 'T' ? "zu schreiben" : "geschrieben"));
            if (this.getAz_SerialNumber() > 0) {
                fProt.prot("SerialNumber                       : " + this.getAz_SerialNumber());
            }
            if (this.getAz_ImageNumber() > 0) {
                fProt.prot("ImageNumber                        : " + this.getAz_ImageNumber());
            }
            if (this.getAz_ImageHistory() > 0) {
                fProt.prot("ImageHistory                        : " + this.getAz_ImageHistory());
            }
            if (this.getAz_Make() > 0) {
                fProt.prot("Make                               : " + this.getAz_Make());
            }
            if (this.getAz_Model() > 0) {
                fProt.prot("Model                              : " + this.getAz_Model());
            }
            if (this.getAz_ModelNotice() > 0) {
                fProt.prot("ModelNotice                        : " + this.getAz_ModelNotice());
            }
            if (this.getAz_OriginalFileName() > 0) {
                fProt.prot("OriginalFileName                   : " + this.getAz_OriginalFileName());
            }
            if (this.getAz_Artist() > 0) {
                fProt.prot("Artist                             : " + this.getAz_Artist());
            }
            if (this.getAz_Copyright() > 0) {
                fProt.prot("Copyright                          : " + this.getAz_Copyright());
            }
            if (this.getAz_ProcessingSoftware() > 0) {
                fProt.prot("ProcessingSoftware                 : " + this.getAz_ProcessingSoftware());
            }
        }
        if (this.getAz_CreatorTool() > 0) {
            fProt.prot("Tag(s) XMP:Creator " + (this.getFunktion().charAt(0) == 'T' ? "werden" : "wurden") + " geloescht: " + this.getAz_CreatorTool());
        }
        if (this.getFunktion().compareTo("T") != 0) {
            this.setFunktion("T");
        }
    }

    void runVorlauf() {
        this.initAz_datum_change_failed();
        this.initAz_datum_changed();
        this.initAz_datum_ok();
        this.initAz_datum_to_change();
        this.initAz_datumfelder_nicht_korrekt();
        this.initAz_name_ok();
        this.initAz_rename_failed();
        this.initAz_rename_nicht_entscheidbar();
        this.initAz_kamera_unbekannt();
        this.initAz_renamed();
        this.initAz_to_rename();
        this.initAz_Artist();
        this.initAz_Copyright();
        this.initAz_ImageNumber();
        this.initAz_ImageHistory();
        this.initAz_Make();
        this.initAz_Model();
        this.initAz_ModelNotice();
        this.initAz_OriginalFileName();
        this.initAz_ProcessingSoftware();
        this.initAz_SerialNumber();
        this.initAz_CreatorTool();
        this.setNamensTabelleSchreiben(this.getNamensTabelle().length() > 1);
        if (this.isExifBasisdatenSchreiben()) {
            this.setExifAlleTagsSchreiben(false);
        }
        if (this.isOriginalDateinamen()) {
            this.setSortierbareNamen(false);
        }
        this.setExifTagsSchreiben(this.isExifAlleTagsSchreiben() || this.isExifBasisdatenSchreiben());
    }

    public void setAutomatischVorneAbschneiden() {
        this.AutomatischVorneAbschneiden = FParam.getBooleanParameter("AutomatischVorneAbschneiden", this.ArgTab);
    }

    public void setAutomatischVorneAbschneiden(boolean automatischVorneAbschneiden) {
        this.AutomatischVorneAbschneiden = automatischVorneAbschneiden;
    }

    private void setBildnummerAuto(ArrayList<RenameMedienZeile> exifFotos, int maxBildNr, ArrayList<String> exifStatement) {
        RenameMedienZeile exifFoto;
        int bildNr = 1;
        ArrayList<String> sortDatum = new ArrayList<String>();
        String datum = "";
        String[] datumSort = new String[]{""};
        int index = -1;
        int i = 0;
        while (i < exifFotos.size()) {
            exifFoto = exifFotos.get(i);
            if (exifFoto.getBildnummer4stellig().length() < 4 && exifFoto.getFileNameBase().compareTo(exifFoto.getOriginalFileNameSoll()) != 0 && (datum = exifFoto.getDateTimeOriginal()).length() > 18) {
                sortDatum.add(String.valueOf(datum.substring(6, 10)) + datum.substring(2, 6) + datum.substring(0, 2) + datum.substring(10) + "\t" + i);
            }
            datumSort = FQuickSort.instance().quickSort(FString.arrayListToStringArray(sortDatum));
            ++i;
        }
        String[] zeile = new String[exifFotos.size()];
        int i2 = 0;
        while (i2 < exifFotos.size()) {
            exifFoto = exifFotos.get(i2);
            zeile[i2] = String.valueOf(exifFoto.getFileNameBase()) + "\t" + exifFoto.getFileNameExtend() + "\t" + exifFoto.getDateTimeOriginal() + "\t" + exifFoto.getFileNameBaseNeu() + "\t" + exifFoto.getBildnummer4stellig() + "\t" + exifFoto.getFileNumber() + "\t" + exifFoto.getImageNumber() + "\t" + exifFoto.getImageNumberSoll() + "\t" + exifFoto.getOriginalFileNameSoll();
            ++i2;
        }
        new FFile("/Volumes/RamDisk/Liste.txt").StringArrayToInhalt(zeile);
        zeile = new String[exifFotos.size() + 1];
        i2 = 0;
        while (i2 < exifFotos.size()) {
            exifFoto = exifFotos.get(i2);
            if (i2 == 0) {
                zeile[0] = exifFoto.printAllHeader();
            }
            zeile[i2 + 1] = exifFoto.printAll();
            ++i2;
        }
        new FFile("/Volumes/RamDisk/ListeAlle.txt").StringArrayToInhalt(zeile);
        zeile = new String[datumSort.length];
        i2 = 0;
        while (i2 < datumSort.length) {
            index = Integer.parseInt(datumSort[i2].split("\t")[1]);
            exifFoto = exifFotos.get(index);
            exifFotos.get(index).setFileNameBaseNeu(String.valueOf(exifFoto.getKameraNameKurz()) + "_xx_" + (maxBildNr + bildNr));
            exifFotos.get(index).setOriginalFileNameSoll(exifFotos.get(index).isVideo() ? "MVI_" : "IMG_" + (maxBildNr + bildNr));
            zeile[i2] = String.valueOf(exifFoto.getFileNameBase()) + "\t" + exifFoto.getFileNameExtend() + "\t" + exifFoto.getDateTimeOriginal() + "\t" + exifFoto.getFileNameBaseNeu() + "\t" + exifFoto.getBildnummer4stellig() + "\t" + exifFoto.getFileNumber() + "\t" + exifFoto.getImageNumber() + "\t" + exifFoto.getImageNumberSoll() + "\t" + exifFoto.getOriginalFileNameSoll();
            ++bildNr;
            ++i2;
        }
        new FFile("/Volumes/RamDisk/Liste1.txt").StringArrayToInhalt(zeile);
    }

    public void setCheckAusgabedatei() {
        this.CheckAusgabedatei = FParam.getStringParameter("CheckAusgabedatei", this.ArgTab);
    }

    public void setCheckAusgabedatei(String checkAusgabedatei) {
        this.CheckAusgabedatei = FParam.checkStringParameter("CheckAusgabedatei", checkAusgabedatei, this.ArgTab);
    }

    public void setCheckAutor() {
        this.CheckAutor = FParam.getBooleanParameter("CheckAutor", this.ArgTab);
    }

    public void setCheckAutor(boolean checkAutor) {
        this.CheckAutor = checkAutor;
    }

    public void setCheckCopyright() {
        this.CheckCopyright = FParam.getBooleanParameter("CheckCopyright", this.ArgTab);
    }

    public void setCheckCopyright(boolean checkCopyright) {
        this.CheckCopyright = checkCopyright;
    }

    public void setCheckdatei() {
        this.Checkdatei = FParam.getStringParameter("Checkdatei", this.ArgTab);
    }

    public void setCheckdatei(String checkdatei) {
        this.Checkdatei = FParam.checkStringParameter("Checkdatei", checkdatei, this.ArgTab);
    }

    private void setCheckKameraDaten() {
        int j;
        int az_spalten = 9;
        String[][] liste_x = new String[][]{{"Canon EOS 400D DIGITAL", "1881161319", "2007.01.01", "2099.12.31", "E400", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"Canon EOS M50", "223030000769", "2021.05.08", "2099.12.31", "M50", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"EPSON XP-4100 Series", "*", "2021.08.21", "2099.12.31", "EPS", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"Medion MD 90070", "*", "2022.01.21", "2099.12.31", "MED", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"Reflecta Diascanner 6000", "*", "2021.08.23", "2021.12.31", "REFL", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"iPad", "DMQKLHAWF182", "2013.06.25", "2099.12.31", "iPad4", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"iPhone 5s", "DNPLTQPBFFG8", "2014.02.20", "2099.12.31", "iPh5s", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"iPhone 5S", "DNPLTQPBFFG8", "2014.02.20", "2099.12.31", "iPh5s", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"iPhone SE", "DX4W3L3JHTVL", "2018.02.09", "2099.12.31", "iPhSE", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"iPhone SE (1st generation)", "DX4W3L3JHTVL", "2018.02.09", "2099.12.31", "iPhSE", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"DownloadFromWeb", "DownloadFromWeb", "1970.01.01", "2099.12.31", "WebDl", "*", "WebDl_", "", ""}, {"Screenshot", "Screenshot", "1970.01.01", "2099.12.31", "Scrsh", "*", "Scrsh_", "Johann Fischer, Neusaess", ""}, {"WhatsApp", "WhatsApp", "1970.01.01", "2099.12.31", "WhA", "*", "WhatsA_", "Johann Fischer, Neusaess", ""}, {"Webcam", "Webcam", "1970.01.01", "2099.12.31", "Webc", "*", "Webcam_", "Johann Fischer, Neusaess", ""}, {"Scanned", "Scanned", "1900.01.01", "2099.12.31", "Scan", "00", "Scan_", "Johann Fischer, Neusaess", ""}, {"DSC-W210", "", "2011.11.26", "2011.11.27", "Sony", "W210", "DSC_", "", ""}, {"DSC-P100", "", "2017.07.09", "2017.07.09", "Sony", "P100", "DSC_", "", ""}, {"NIKON D5000", "", "2011.11.26", "2013.05.30", "NIKON", "D5000", "DSC_", "", ""}, {"NIKON D5100", "", "2017.07.09", "2017.07.09", "NIKON", "D5100", "DSC_", "", ""}, {"NIKON D70s", "", "2011.11.26", "2011.11.27", "NIKON", "D70s", "DSC_", "", ""}, {"DMC-TZ25", "", "2013.03.15", "2013.03.21", "Panasonic", "TZ25", "DSC_", "Johann Fischer, Neusaess", "Kamera von Achim geliehen"}, {"E5000", "", "2000.01.01", "2009.12.31", "Nikon", "E5000", "DSC_", "Johann Fischer, Neusaess", "Kamera von der Allianz ausgeliehen"}, {"Canon A1", "", "1980.04.01", "1980.08.31", "A1", "*", "IMG_", "Johann Fischer, Neusaess", "Kamera von Gerhard geliehen"}, {"Canon A1", "", "1981.08.01", "1998.05.18", "A1", "*", "IMG_", "Johann Fischer, Neusaess", "Kamera bei Triest am 18.Mai 1998 gestohlen"}, {"Canon A1", "2077614", "1998.05.27", "2008.12.31", "A1", "*", "IMG_", "Johann Fischer, Neusaess", "Am 27.Mai 1998 gebraucht gekauft"}, {"Canon EOS 50", "1754252", "2000.01.01", "2007.12.31", "E50", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"Rollei B 35", "", "1970.01.01", "1995.12.31", "B35", "*", "IMG_", "Johann Fischer, Neusaess", ""}, {"5310 XpressMusic", "", "2007.01.01", "2011.12.31", "Nokia", "XpressMusic", "IMG_", "Johann Fischer, Neusaess", "Diensthandy von der Allianz"}};
        String[][] liste_imp = FString.convertStringArrayToTabelle(new FFile(this.getCheckdatei()).inhaltToStringArray(), 9, false);
        String[][] liste = new String[liste_x.length + liste_imp.length + (this.isUnbekannteKamerasHaendeln() ? 1 : 0)][9];
        int i = 0;
        while (i < liste_imp.length) {
            j = 0;
            while (j < 9) {
                liste[i][j] = liste_imp[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < liste_x.length) {
            j = 0;
            while (j < 9) {
                liste[liste_imp.length + i][j] = liste_x[i][j];
                ++j;
            }
            ++i;
        }
        if (this.isUnbekannteKamerasHaendeln()) {
            int j2 = 0;
            while (j2 < 9) {
                liste[liste_x.length + liste_imp.length][j2] = this.KameraUnbekannt[j2];
                ++j2;
            }
        }
        this.CheckKameraDaten = liste;
    }

    public void setCheckPrint() {
        this.CheckPrint = FParam.getBooleanParameter("CheckPrint", this.ArgTab);
    }

    public void setCheckPrint(boolean checkPrint) {
        this.CheckPrint = checkPrint;
    }

    public void setCheckSerienNummer() {
        this.CheckSerienNummer = FParam.getBooleanParameter("CheckSerienNummer", this.ArgTab);
    }

    public void setCheckSerienNummer(boolean checkSerienNummer) {
        this.CheckSerienNummer = checkSerienNummer;
    }

    public void setDeltaBeiZeitvergleich() {
        this.DeltaBeiZeitvergleich = FParam.getIntParameter("DeltaBeiZeitvergleich", this.ArgTab);
    }

    public void setDeltaBeiZeitvergleich(int deltaBeiZeitvergleich) {
        this.DeltaBeiZeitvergleich = FParam.checkIntParameter("DeltaBeiZeitvergleich", deltaBeiZeitvergleich, this.ArgTab);
    }

    public void setDeltaBeiZeitvergleich(String deltaBeiZeitvergleich) {
        this.DeltaBeiZeitvergleich = FParam.checkIntParameter("DeltaBeiZeitvergleich", deltaBeiZeitvergleich, this.ArgTab);
    }

    public void setExif2ModifyDate() {
        this.Exif2ModifyDate = FParam.getBooleanParameter("Exif2ModifyDate", this.ArgTab);
    }

    public void setExif2ModifyDate(boolean exif2ModifyDate) {
        this.Exif2ModifyDate = exif2ModifyDate;
    }

    public void setExifAlleTagsSchreiben() {
        this.ExifAlleTagsSchreiben = FParam.getBooleanParameter("ExifAlleTagsSchreiben", this.ArgTab);
    }

    public void setExifAlleTagsSchreiben(boolean exifTagsSchreiben) {
        this.ExifAlleTagsSchreiben = exifTagsSchreiben;
    }

    public void setExifBasisdatenSchreiben() {
        this.ExifBasisdatenSchreiben = FParam.getBooleanParameter("ExifBasisdatenSchreiben", this.ArgTab);
    }

    public void setExifBasisdatenSchreiben(boolean exifFileNumberSchreiben) {
        this.ExifBasisdatenSchreiben = exifFileNumberSchreiben;
    }

    public void setExifFileNumberSchreiben() {
        this.ExifBasisdatenSchreiben = FParam.getBooleanParameter("ExifBasisdatenSchreiben", this.ArgTab);
    }

    public void setExifTagsSchreiben() {
        this.ExifAlleTagsSchreiben = FParam.getBooleanParameter("ExifAlleTagsSchreiben", this.ArgTab);
    }

    public void setExifTagsSchreiben(boolean exifTagsSchreiben) {
        this.ExifTagsSchreiben = exifTagsSchreiben;
    }

    public void setExifTagsUeberSchreiben() {
        this.ExifTagsUeberSchreiben = FParam.getBooleanParameter("ExifTagsUeberSchreiben", this.ArgTab);
    }

    public void setExifTagsUeberSchreiben(boolean processSoftwareSchreiben) {
        this.ExifTagsUeberSchreiben = processSoftwareSchreiben;
    }

    public void setExifToolParm() {
        this.ExifToolParm = FParam.getStringParameter("ExifToolParm", this.ArgTab);
    }

    public void setExifToolParm(String exifToolParm) {
        this.ExifToolParm = FParam.checkStringParameter("ExifToolParm", exifToolParm, this.ArgTab);
    }

    public void setFileNameAutoMinimum() {
        this.FileNameAutoMinimum = FParam.getIntParameter("FileNameAutoMinimum", this.ArgTab);
    }

    public void setFileNameAutoMinimum(int fileNameAutoMinimum) {
        this.FileNameAutoMinimum = FParam.checkIntParameter("FileNameAutoMinimum", fileNameAutoMinimum, this.ArgTab);
    }

    public void setFileNameAutoMinimum(String fileNameAutoMinimum) {
        this.FileNameAutoMinimum = FParam.checkIntParameter("FileNameAutoMinimum", fileNameAutoMinimum, this.ArgTab);
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setGPSDatumVerwenden() {
        this.GPSDatumVerwenden = FParam.getBooleanParameter("GPSDatumVerwenden", this.ArgTab);
    }

    public void setGPSDatumVerwenden(boolean gPSDatumVerwenden) {
        this.GPSDatumVerwenden = gPSDatumVerwenden;
    }

    public void setKameraBildStamm(String kameraBildStamm) {
        this.KameraBildStamm = kameraBildStamm;
    }

    public void setKameraNameImBild(String kameraNameImBild) {
        this.KameraNameImBild = kameraNameImBild;
    }

    public void setKameraSerie(String kameraSerie) {
        this.KameraSerie = kameraSerie;
    }

    public void setNamensTabelle() {
        this.NamensTabelle = FParam.getStringParameter("NamensTabelle", this.ArgTab);
    }

    public void setNamensTabelle(String namensTabelle) {
        this.NamensTabelle = FParam.checkStringParameter("NamensTabelle", namensTabelle, this.ArgTab);
    }

    private void setNamensTabelleSchreiben(boolean namensTabelleSchreiben) {
        this.NamensTabelleSchreiben = namensTabelleSchreiben;
    }

    public void setOriginalDateinamen() {
        this.OriginalDateinamen = FParam.getBooleanParameter("OriginalDateinamen", this.ArgTab);
    }

    public void setOriginalDateinamen(boolean originalDateinamen) {
        this.OriginalDateinamen = originalDateinamen;
    }

    public void setOriginalFileNameAuto() {
        this.OriginalFileNameAuto = FParam.getBooleanParameter("OriginalFileNameAuto", this.ArgTab);
    }

    public void setOriginalFileNameAuto(boolean originalFileNameAuto) {
        this.OriginalFileNameAuto = originalFileNameAuto;
    }

    public void setSortierbareNamen() {
        this.SortierbareNamen = FParam.getBooleanParameter("SortierbareNamen", this.ArgTab);
    }

    public void setSortierbareNamen(boolean sortierbareNamen) {
        this.SortierbareNamen = sortierbareNamen;
    }

    public void setSortierbarGrossKlein() {
        this.SortierbarGrossKlein = FParam.getBooleanParameter("SortierbarGrossKlein", this.ArgTab);
    }

    public void setSortierbarGrossKlein(boolean sortierbarGrossKlein) {
        this.SortierbarGrossKlein = sortierbarGrossKlein;
    }

    public void setUnbekannteKamerasHaendeln() {
        this.UnbekannteKamerasHaendeln = FParam.getBooleanParameter("UnbekannteKamerasHaendeln", this.ArgTab);
    }

    public void setUnbekannteKamerasHaendeln(boolean unbekannteKamerasHaendeln) {
        this.UnbekannteKamerasHaendeln = unbekannteKamerasHaendeln;
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setVorneAbschneiden() {
        this.VorneAbschneiden = FParam.getIntParameter("VorneAbschneiden", this.ArgTab);
    }

    public void setVorneAbschneiden(int vorneAbschneiden) {
        this.VorneAbschneiden = FParam.checkIntParameter("VorneAbschneiden", vorneAbschneiden, this.ArgTab);
    }

    public void setVorneAbschneiden(String vorneAbschneiden) {
        this.VorneAbschneiden = FParam.checkIntParameter("VorneAbschneiden", vorneAbschneiden, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setExifToolParm();
        this.setFunktion();
        this.setCheckAutor();
        this.setCheckCopyright();
        this.setCheckSerienNummer();
        this.setCheckdatei();
        this.setCheckAusgabedatei();
        this.setCheckPrint();
        this.setGPSDatumVerwenden();
        this.setDeltaBeiZeitvergleich();
        this.setExif2ModifyDate();
        this.setExifBasisdatenSchreiben();
        this.setExifAlleTagsSchreiben();
        this.setExifTagsUeberSchreiben();
        this.setOriginalFileNameAuto();
        this.setFileNameAutoMinimum();
        this.setOriginalDateinamen();
        this.setSortierbareNamen();
        this.setAutomatischVorneAbschneiden();
        this.setVorneAbschneiden();
        this.setSortierbarGrossKlein();
        this.setUnbekannteKamerasHaendeln();
        this.setNamensTabelle();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                                                     :" + this.getVerzeichnis());
        fProt.prot("zuaetzliche Exiftool-Parameter                                         :" + this.getExifToolParm());
        fProt.prot("Funktion                                                               :" + this.getFunktion());
        fProt.prot("Artist (Kuenstler) ueberpruefen                                        :" + this.isCheckAutor());
        fProt.prot("Copyright ueberpruefen                                                 :" + this.isCheckCopyright());
        fProt.prot("Seriennummer der Camera ueberpruefen                                   :" + this.isCheckSerienNummer());
        fProt.prot("Datei mit zusaetzlichen Checkangaben                                   :" + this.getCheckdatei());
        fProt.prot("Checkangaben auf Datei ausgeben                                        :" + this.getCheckAusgabedatei());
        fProt.prot("Checkangaben ausgeben                                                  :" + this.isCheckPrint());
        fProt.prot("GPSDatum statt ExifOriginalDatum verwenden                             :" + this.isGPSDatumVerwenden());
        fProt.prot("erlaubter Zeitunterschied zwischen Exif- und Dateidatum in Sekunden    :" + this.getDeltaBeiZeitvergleich());
        fProt.prot("ExifDatum nach Filedatum schreiben                                     :" + this.isExif2ModifyDate());
        fProt.prot("Nur FileNumber, Seriennummer, Modell, ... mit Exiftool schreiben       :" + this.isExifBasisdatenSchreiben());
        fProt.prot("alle ExifTags mit Exiftool schreiben                                   :" + this.isExifAlleTagsSchreiben());
        fProt.prot("vorhandene ExifTags ueberschreiben                                     :" + this.isExifTagsUeberSchreiben());
        fProt.prot("OriginalFileName automatisch setzen, falls nicht ermittelbar           :" + this.isOriginalFileNameAuto());
        fProt.prot("Minimum fuer OriginalFileName automatisch setzen                       :" + this.getFileNameAutoMinimum());
        fProt.prot("Rename zu Original-Dateinamen                                          :" + this.isOriginalDateinamen());
        fProt.prot("Dateinamen sortierbar machen                                           :" + this.isSortierbareNamen());
        fProt.prot("Dateinamen sortierbar mit String: Stellen vorne automatisch abschneiden:" + this.isAutomatischVorneAbschneiden());
        fProt.prot("Dateinamen sortierbar mit String: Stellen vorne abschneiden            :" + this.getVorneAbschneiden());
        fProt.prot("Dateinamen sortierbar mit String in Grosskleinschreibung               :" + this.isSortierbarGrossKlein());
        fProt.prot("Bilder mit unbekannter Kamera automatisch mit beruecksichtigen         :" + this.isUnbekannteKamerasHaendeln());
        fProt.prot("Name fuer Liste der Namen                                              :" + this.getNamensTabelle());
    }

    public class RenameMedienZeile {
        private String Directory = "";
        private String Model = "";
        private String Artist = "";
        private String Copyright = "";
        private String SerialNumber = "";
        private String FileModifyDate = "";
        private String ExifDateTime = "";
        private String CreatorTool = "";
        private String DateTimeOriginal = "";
        private String DateTimeVglKameraDaten = "";
        private String GPSDateTime = "";
        private String KameraNameKurz = "";
        private String KameraBildSerie = "";
        private String KameraSeriennummer = "";
        private String KameraNotiz = "";
        private String KameraCopyrightUndArtist = "";
        private String KameraBildStammx = "";
        private boolean GPSDateTimeUsed;
        private boolean KameraBekanntx;
        private String FileNameBase = "";
        private String FileNameBaseNeu = "";
        private String FileNameExtend = "";
        private String FileNumber = "";
        private String ImageHistory = "";
        private String ImageHistorySoll = "";
        private String ImageNumber = "";
        private String ImageNumberSoll = "";
        private String Lensmodel = "";
        private String Make = "";
        private String ModelKurz = "";
        private String ModelNotiz = "";
        private String RawFileName = "";
        private String OriginalFileName = "";
        private String OriginalFileNameSoll = "";
        private String ProcessingSoftware = "";
        private String Warning = "";
        private boolean ScanInfoVorhanden;
        private boolean DownloadFromWeb;
        private boolean Screenshot;
        private boolean WhatsApp;
        private boolean Webcam;
        private String ScanInfo = "";
        private String ModelOriginal = "";
        private String MakeOriginal = "";
        private String SerialNumberOriginal = "";
        private String ScanFileNumber = "";
        private String ScanModel = "";
        private boolean FotoGescanned;

        public String getArtist() {
            return this.Artist;
        }

        public String getBildnummer4stellig() {
            String nr = this.getOriginalFileNameSoll();
            if (nr.length() >= 4) {
                nr = nr.substring(nr.length() - 4);
            } else {
                nr = this.getFileNumber();
                if (nr.length() >= 4) {
                    nr = nr.substring(nr.length() - 4);
                } else {
                    nr = this.getImageNumber();
                    if (nr.length() >= 4) {
                        nr = nr.substring(nr.length() - 4);
                    }
                }
            }
            return nr;
        }

        public String getCopyright() {
            return this.Copyright;
        }

        public String getCreatorTool() {
            return this.CreatorTool;
        }

        public String getDateTimeOriginal() {
            return this.DateTimeOriginal;
        }

        String getDateTimeVglKameraDaten() {
            return this.DateTimeVglKameraDaten;
        }

        public String getDirectory() {
            return this.Directory;
        }

        public String getExifDateTime() {
            return this.ExifDateTime;
        }

        public String getFileModifyDate() {
            return this.FileModifyDate;
        }

        public String getFileNameBase() {
            return this.FileNameBase;
        }

        public String getFileNameBaseNeu() {
            return this.FileNameBaseNeu;
        }

        public String getFileNameExtend() {
            return this.FileNameExtend;
        }

        public String getFileNumber() {
            return this.FileNumber;
        }

        public String getGPSDateTime() {
            return this.GPSDateTime;
        }

        String getImageHistory() {
            return this.ImageHistory;
        }

        public String getImageHistorySoll() {
            return this.ImageHistorySoll;
        }

        public String getImageNumber() {
            return this.ImageNumber;
        }

        public String getImageNumberSoll() {
            return this.ImageNumberSoll;
        }

        public String getKameraBildSerie() {
            return this.KameraBildSerie;
        }

        public String getKameraBildStamm() {
            return this.KameraBildStammx;
        }

        public String getKameraCopyrightUndArtist() {
            return this.KameraCopyrightUndArtist;
        }

        public String getKameraNameKurz() {
            return this.KameraNameKurz;
        }

        public String getKameraNotiz() {
            return this.KameraNotiz;
        }

        public String getKameraSeriennummer() {
            return this.KameraSeriennummer;
        }

        public String getLensmodel() {
            return this.Lensmodel;
        }

        public String getMake() {
            return this.Make;
        }

        public String getMakeOriginal() {
            return this.MakeOriginal;
        }

        public String getModel() {
            return this.Model;
        }

        public String getModelKurz() {
            return this.ModelKurz;
        }

        public String getModelNotiz() {
            return this.ModelNotiz;
        }

        public String getModelOriginal() {
            return this.ModelOriginal;
        }

        public String getOriginalFileName() {
            return this.OriginalFileName;
        }

        public String getOriginalFileNameSoll() {
            return this.OriginalFileNameSoll;
        }

        public String getProcessingSoftware() {
            return this.ProcessingSoftware;
        }

        public String getRawFileName() {
            return this.RawFileName;
        }

        public String getScanFileNumber() {
            return this.ScanFileNumber;
        }

        public String getScanInfo() {
            return this.ScanInfo;
        }

        String getScanModel() {
            return this.ScanModel;
        }

        public String getSerialNumber() {
            return this.SerialNumber;
        }

        public String getSerialNumberOriginal() {
            return this.SerialNumberOriginal;
        }

        public String getWarning() {
            return this.Warning;
        }

        public boolean isDownloadFromWeb() {
            return this.DownloadFromWeb;
        }

        public boolean isFotoGescanned() {
            return this.FotoGescanned;
        }

        public boolean isGPSDateTimeUsed() {
            return this.GPSDateTimeUsed;
        }

        public boolean isKameraBekannt() {
            return this.KameraBekanntx;
        }

        boolean isMyM50() {
            return this.getModel().compareToIgnoreCase("Canon EOS M50") == 0 && this.getKameraSeriennummer().compareToIgnoreCase("223030000769") == 0;
        }

        public boolean isPicture() {
            return this.getFileNameExtend().compareToIgnoreCase("JPG") == 0 || this.getFileNameExtend().compareToIgnoreCase("JPEG") == 0;
        }

        boolean isRecflectaScanner() {
            return this.getModel().compareToIgnoreCase("Reflecta Diascanner 6000") == 0;
        }

        public boolean isScanInfoVorhanden() {
            return this.ScanInfoVorhanden;
        }

        public boolean isScreenshot() {
            return this.Screenshot;
        }

        public boolean isVideo() {
            return this.getFileNameExtend().compareToIgnoreCase("MP4") == 0 || this.getFileNameExtend().compareToIgnoreCase("MOV") == 0;
        }

        boolean isWebcam() {
            return this.Webcam;
        }

        boolean isWhatsApp() {
            return this.WhatsApp;
        }

        public String printAll() {
            return String.valueOf(this.getArtist()) + "\t" + this.getBildnummer4stellig() + "\t" + this.getCopyright() + "\t" + this.getCreatorTool() + "\t" + this.getDateTimeOriginal() + "\t" + this.getDirectory() + "\t" + this.getExifDateTime() + "\t" + this.getFileModifyDate() + "\t" + this.getFileNameBase() + "\t" + this.getFileNameBaseNeu() + "\t" + this.getFileNameExtend() + "\t" + this.getFileNumber() + "\t" + this.getImageHistory() + "\t" + this.getGPSDateTime() + "\t" + this.getImageNumber() + "\t" + this.getImageNumberSoll() + "\t" + this.getKameraBildSerie() + "\t" + this.getKameraBildStamm() + "\t" + this.getKameraCopyrightUndArtist() + "\t" + this.getKameraNameKurz() + "\t" + this.getKameraNotiz() + "\t" + this.getKameraSeriennummer() + "\t" + this.getLensmodel() + "\t" + this.getMake() + "\t" + this.getMakeOriginal() + "\t" + this.getModel() + "\t" + this.getModelKurz() + "\t" + this.getModelNotiz() + "\t" + this.getModelOriginal() + "\t" + this.getOriginalFileName() + "\t" + this.getOriginalFileNameSoll() + "\t" + this.getProcessingSoftware() + "\t" + this.getRawFileName() + "\t" + this.getScanFileNumber() + "\t" + this.getScanInfo() + "\t" + this.getSerialNumber() + "\t" + this.getSerialNumberOriginal() + "\t" + this.getWarning() + "\t" + this.isDownloadFromWeb() + "\t" + this.isFotoGescanned() + "\t" + this.isGPSDateTimeUsed() + "\t" + this.isKameraBekannt() + "\t" + this.isPicture() + "\t" + this.isScanInfoVorhanden() + "\t" + this.isScreenshot() + "\t" + this.isWhatsApp() + "\t" + this.isWebcam() + "\t" + this.isVideo();
        }

        public String printAllHeader() {
            return "Artist\tBildnummer4stellig\tCopyright\tCreatorTool\tDateTimeOriginal\tDirectory\tExifDateTime\tFileModifyDate\tFileNameBase\tFileNameBaseNeu\tFileNameExtend\tFileNumber\tImageHistory\tGPSDateTime\tImageNumber\tImageNumberSoll\tKameraBildSerie\tKameraBildStamm\tKameraCopyrightUndArtist\tKameraNameKurz\tKameraNotiz\tKameraSeriennummer\tLensmodel\tMake\tMakeOriginal\tModel\tModelKurz\tModelNotiz\tModelOriginal\tOriginalFileName\tOriginalFileNameSoll\tProcessingSoftware\tRawFileName\tScanFileNumber\tScanInfo\tSerialNumber()\tSerialNumberOriginal\tWarning\tisDownloadFromWeb\tFotoGescanned\tGPSDateTimeUsed\tKameraBekannt\tPicture\tScanInfoVorhanden\tScreenshot\tWhatsApp\tWebcam\tVideo";
        }

        public void setArtist(String artist) {
            this.Artist = artist;
        }

        public void setCopyright(String copyright) {
            this.Copyright = copyright;
        }

        public void setCreatorTool(String creatorTool) {
            this.CreatorTool = creatorTool;
        }

        public void setDateTimeOriginal(String dateTimeOriginal) {
            this.DateTimeOriginal = dateTimeOriginal;
        }

        void setDateTimeVglKameraDaten(String dateTimeVglKameraDaten) {
            this.DateTimeVglKameraDaten = dateTimeVglKameraDaten;
        }

        public void setDirectory(String directory) {
            this.Directory = directory;
        }

        public void setDownloadFromWeb(boolean downloadFromWeb) {
            this.DownloadFromWeb = downloadFromWeb;
        }

        public void setExifDateTime(String exifDateTime) {
            this.ExifDateTime = exifDateTime;
        }

        public void setFileModifyDate(String fileModifyDate) {
            this.FileModifyDate = fileModifyDate;
        }

        public void setFileNameBase(String fileNameBase) {
            this.FileNameBase = fileNameBase;
        }

        public void setFileNameBaseNeu(String fileNameBaseNeu) {
            this.FileNameBaseNeu = fileNameBaseNeu;
        }

        public void setFileNameExtend(String fileNameExtend) {
            this.FileNameExtend = fileNameExtend;
        }

        public void setFileNumber(String fileNumber) {
            this.FileNumber = fileNumber;
        }

        public void setFotoGescanned(boolean fotoGescanned) {
            this.FotoGescanned = fotoGescanned;
        }

        public void setGPSDateTime(String gPSDateTime) {
            this.GPSDateTime = gPSDateTime;
        }

        public void setGPSDateTimeUsed(boolean gPSDateTimeUsed) {
            this.GPSDateTimeUsed = gPSDateTimeUsed;
        }

        void setImageHistory(String imageHistory) {
            this.ImageHistory = imageHistory;
        }

        public void setImageHistorySoll() {
            String imageHistorySoll = "";
            String sequenz = "200";
            if (this.isMyM50()) {
                if (this.getDateTimeOriginal().compareTo("2022:01:01") >= 0 && this.getDateTimeOriginal().compareTo("2022:12:31") <= 0) {
                    sequenz = "201";
                }
                if (this.getDateTimeOriginal().compareTo("2023:01:01") >= 0 && this.getDateTimeOriginal().compareTo("2023:12:31") <= 0) {
                    sequenz = "202";
                }
                imageHistorySoll = String.valueOf(sequenz) + "-" + this.getBildnummer4stellig();
            } else if (this.isRecflectaScanner()) {
                imageHistorySoll = "999-" + this.getBildnummer4stellig();
            }
            this.ImageHistorySoll = imageHistorySoll;
        }

        public void setImageNumber(String imageNumber) {
            this.ImageNumber = imageNumber;
        }

        public void setImageNumberSoll(String imageNumberSoll) {
            this.ImageNumberSoll = imageNumberSoll;
        }

        public void setKameraBekannt(boolean kameraBekannt) {
            this.KameraBekanntx = kameraBekannt;
        }

        public void setKameraBildSerie(String kameraBildSerie) {
            this.KameraBildSerie = kameraBildSerie;
        }

        public void setKameraBildStamm(String kameraBildStammName) {
            this.KameraBildStammx = kameraBildStammName;
        }

        public void setKameraCopyrightUndArtist(String kameraCopyrightUndArtist) {
            this.KameraCopyrightUndArtist = kameraCopyrightUndArtist;
        }

        public void setKameraNameKurz(String kameraNameKurz) {
            this.KameraNameKurz = kameraNameKurz;
        }

        public void setKameraNotiz(String kameraNotiz) {
            this.KameraNotiz = kameraNotiz;
        }

        public void setKameraSeriennummer(String kameraSeriennummer) {
            this.KameraSeriennummer = kameraSeriennummer;
        }

        public void setLensmodel(String lensmodel) {
            this.Lensmodel = lensmodel;
        }

        public void setMake(String make) {
            this.Make = make;
        }

        public void setMakeOriginal(String MakeOriginal) {
            this.MakeOriginal = MakeOriginal;
        }

        public void setModel(String model) {
            this.Model = model;
        }

        public void setModelKurz(String modelkurz) {
            this.ModelKurz = modelkurz;
        }

        public void setModelNotiz(String modelNotiz) {
            this.ModelNotiz = modelNotiz;
        }

        public void setModelOriginal(String ModelOriginal) {
            this.ModelOriginal = ModelOriginal;
        }

        public void setOriginalFileName(String originalFileName) {
            this.OriginalFileName = originalFileName;
        }

        public void setOriginalFileNameSoll(String originalFileNameSoll) {
            this.OriginalFileNameSoll = originalFileNameSoll;
        }

        public void setProcessingSoftware(String processingSoftware) {
            this.ProcessingSoftware = processingSoftware;
        }

        public void setRawFileName(String rawFileName) {
            this.RawFileName = rawFileName;
        }

        public void setScanFileNumber(String scanFileNumber) {
            this.ScanFileNumber = scanFileNumber;
        }

        public void setScanInfo(String scanInfo) {
            this.ScanInfo = scanInfo;
            this.ScanInfoVorhanden = scanInfo.length() > 1;
        }

        public void setScanInfoVorhanden(boolean scanInfoVorhanden) {
            this.ScanInfoVorhanden = scanInfoVorhanden;
        }

        void setScanModel(String scanModel) {
            this.ScanModel = scanModel;
        }

        public void setScreenshot(boolean screenshot) {
            this.Screenshot = screenshot;
        }

        public void setSerialNumber(String serialNumber) {
            this.SerialNumber = serialNumber;
        }

        public void setSerialNumberOriginal(String SerialNumberOriginal) {
            this.SerialNumberOriginal = SerialNumberOriginal;
        }

        public void setWarning(String warning) {
            this.Warning = warning;
        }

        void setWebcam(boolean webcam) {
            this.Webcam = webcam;
        }

        void setWhatsApp(boolean whatsApp) {
            this.WhatsApp = whatsApp;
        }
    }
}

