/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextArea;

public class Spalten {
    private String Eingabedatei;
    private String Ausgabedatei;
    private String Mergedatei;
    private int KeySpalten;
    private final boolean SetzenWerteInGUInachRun = false;
    private String LfdNrVon;
    private String LfdNrBis;
    private long LfdNrBisNum;
    private boolean LfdNrOK;
    private boolean LfdNrDominant;
    private long LfdNrVonNum;
    private int LfdNrSchrittweiteNum;
    private String LfdNrSchrittweite;
    private boolean KeineNeueZeileAmZeilenende;
    private boolean TextAreaEingabe;
    private boolean KopierenAusgabeInClipboard;
    private String TrennzeichenEingabe;
    private String TrennzeichenAusgabe;
    private String Textbegrenzung;
    private int AnzahlSpalten;
    private String Format;
    private String FormatWork;
    private boolean KopierenClipboardInEingabe;
    private int SkipZeilen;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private boolean FehlendeSpaltenAuffuellen;
    private String Charset;
    private boolean TextAreaAusgabe;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private final String Stand = "25.5.2011";

    public static void main(String[] args) {
        Spalten spalten = new Spalten(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(spalten.ArgTab, spalten.ArgTabDefault, spalten.getHilfeText())) {
            try {
                spalten.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + spalten.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                spalten.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + spalten.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + spalten.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public Spalten() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public Spalten(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    private void checkFormat() {
        int pos;
        String formatW = this.getFormat();
        while ((pos = formatW.indexOf("#B")) > 1) {
            formatW = String.valueOf(formatW) + " ";
            int von = -1;
            int bis = -1;
            int j = 0;
            int i = pos - 1;
            while (i >= 0) {
                if (formatW.charAt(i) < '0' || formatW.charAt(i) > '9') {
                    try {
                        von = Integer.parseInt(formatW.substring(i + 1, pos));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                --i;
            }
            if (von > 0 && formatW.charAt(pos + 2) == '#') {
                j = pos + 3;
                while (j < formatW.length()) {
                    if (formatW.charAt(j) < '0' || formatW.charAt(j) > '9') {
                        try {
                            bis = Integer.parseInt(formatW.substring(pos + 3, j));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    ++j;
                }
            }
            if (bis > von) {
                String rest = j < formatW.length() ? formatW.substring(j) : "";
                formatW = i > 0 ? formatW.substring(0, i) : "";
                formatW = String.valueOf(formatW) + "#" + von;
                int k = von + 1;
                while (k <= bis) {
                    formatW = String.valueOf(formatW) + "#T#" + k;
                    ++k;
                }
                formatW = String.valueOf(formatW) + rest;
                formatW = formatW.trim();
                continue;
            }
            formatW = String.valueOf(formatW.substring(0, pos)) + "#b" + formatW.substring(pos + 2);
        }
        this.setFormatWork(formatW);
    }

    private void checkLfdNr() {
        boolean lfdNrVonOK = true;
        boolean lfdNrBisOK = true;
        boolean lfdNrSchrittweiteOK = true;
        try {
            this.setLfdNrVonNum(Long.parseLong(this.getLfdNrVon()));
        }
        catch (NumberFormatException e) {
            lfdNrVonOK = false;
        }
        try {
            this.setLfdNrBisNum(Long.parseLong(this.getLfdNrBis()));
        }
        catch (NumberFormatException e) {
            lfdNrBisOK = false;
        }
        try {
            this.setLfdNrSchrittweiteNum(Integer.parseInt(this.getLfdNrSchrittweite()));
        }
        catch (NumberFormatException e) {
            lfdNrSchrittweiteOK = false;
        }
        this.setLfdNrOK(lfdNrVonOK && lfdNrSchrittweiteOK);
        boolean lfdNrKombinationStimmig = this.getLfdNrSchrittweiteNum() > 0 && this.getLfdNrBisNum() >= this.getLfdNrVonNum() + (long)this.getLfdNrSchrittweiteNum() || this.getLfdNrSchrittweiteNum() < 0 && this.getLfdNrBisNum() <= this.getLfdNrVonNum() + (long)this.getLfdNrSchrittweiteNum();
        this.setLfdNrDominant(lfdNrVonOK && lfdNrBisOK && lfdNrSchrittweiteOK && lfdNrKombinationStimmig);
        if (this.LfdNrOK && !lfdNrKombinationStimmig) {
            FProt.instance().prot("Kombination fuer LfdNr nicht stimming, LfdNrBis kann nicht erreicht werden: ==> LfdNrBis wird ignoriert!");
        }
    }

    public int getAnzahlSpalten() {
        return this.AnzahlSpalten;
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String getFormat() {
        return this.Format;
    }

    public String getFormatWork() {
        return this.FormatWork;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public int getKeySpalten() {
        return this.KeySpalten;
    }

    public String getLfdNrBis() {
        return this.LfdNrBis;
    }

    private long getLfdNrBisNum() {
        return this.LfdNrBisNum;
    }

    public String getLfdNrSchrittweite() {
        return this.LfdNrSchrittweite;
    }

    private int getLfdNrSchrittweiteNum() {
        return this.LfdNrSchrittweiteNum;
    }

    public String getLfdNrVon() {
        return this.LfdNrVon;
    }

    private long getLfdNrVonNum() {
        return this.LfdNrVonNum;
    }

    public String getMergedatei() {
        return this.Mergedatei;
    }

    public String[] getParameterAsStringArray() {
        String[] aus = new String[]{"Eingabedatei                                    :" + this.getEingabedatei(), "Ausgabedatei                                    :" + this.getAusgabedatei(), "Trennzeichen fuer Eingabe (Separator)           :" + this.getTrennzeichenEingabe(), "Trennzeichen fuer Ausgabe (Separator)           :" + this.getTrennzeichenAusgabe(), "Text-/Spaltenbegrenzungzeichen (z.B.: Hochkomma):" + this.getTextbegrenzung(), "Anzahl Spalten                                  :" + this.getAnzahlSpalten(), "Zeilen am Anfang ueberspringen                  :" + this.getSkipZeilen(), "Keine NeueZeile am Zeilenende                   :" + this.isKeineNeueZeileAmZeilenende(), "Fehlende Spalten mit Blank auffuellen           :" + this.isFehlendeSpaltenAuffuellen(), "Format fuer Ausgabe                             :" + this.getFormat(), "                                                :" + this.getFormatWork(), "TextArea statt Eingabedatei verwenden           :" + this.isTextAreaEingabe(), "TextArea statt Ausgabedatei verwenden           :" + this.isTextAreaAusgabe(), "Zwischenablage fuer Eingabe in TextArea kopieren:" + this.isKopierenClipboardInEingabe(), "TextArea fuer Ausgabe in Zwischenablage kopieren:" + this.isKopierenAusgabeInClipboard()};
        return aus;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public int getSkipZeilen() {
        return this.SkipZeilen;
    }

    public String getStand() {
        return "25.5.2011";
    }

    public String getTextbegrenzung() {
        return this.Textbegrenzung;
    }

    public String getTrennzeichenAusgabe() {
        return this.TrennzeichenAusgabe;
    }

    public String getTrennzeichenEingabe() {
        return this.TrennzeichenEingabe;
    }

    public boolean isFehlendeSpaltenAuffuellen() {
        return this.FehlendeSpaltenAuffuellen;
    }

    public boolean isKeineNeueZeileAmZeilenende() {
        return this.KeineNeueZeileAmZeilenende;
    }

    public boolean isKopierenAusgabeInClipboard() {
        return this.KopierenAusgabeInClipboard;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    private boolean isLfdNrDominant() {
        return this.LfdNrDominant;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    private String[][] prepareZeilen(String[] Zeile) {
        int lfdNrAnzahl;
        boolean merge;
        String[] mergeZeile = null;
        boolean[] mergeZeileUsed = new boolean[1];
        String[][] mergeSpalten = null;
        boolean bl = merge = this.getMergedatei().length() > 0 && this.getKeySpalten() > 0;
        if (merge) {
            mergeZeile = new FFile(this.getMergedatei()).inhaltToStringArray(this.getCharset());
            mergeSpalten = FString.convertStringArrayToTabelle(mergeZeile, this.getAnzahlSpalten(), this.getTrennzeichenEingabe());
            mergeZeileUsed = new boolean[mergeZeile.length];
        }
        ArrayList<String[]> work = new ArrayList<String[]>();
        int i = this.getSkipZeilen();
        while (i < Zeile.length) {
            int j;
            String[] Spalte;
            if (this.getTrennzeichenEingabe().length() > 0) {
                try {
                    Spalte = Zeile[i].split(this.getTrennzeichenEingabe());
                }
                catch (Exception e) {
                    Spalte = new String[]{Zeile[i]};
                }
            } else {
                Spalte = Zeile[i].length() > 0 ? new String[]{Zeile[i]} : new String[]{};
            }
            if (this.isFehlendeSpaltenAuffuellen() && Spalte.length < this.getAnzahlSpalten()) {
                Spalte = FString.expandArray(Spalte, this.getAnzahlSpalten());
            }
            if (merge) {
                String suche = Spalte[0];
                j = 1;
                while (j < this.getKeySpalten()) {
                    suche = String.valueOf(suche) + this.getTrennzeichenEingabe() + Spalte[j];
                    ++j;
                }
                int zNr = FString.findStartingString(mergeZeile, suche);
                if (zNr > 0 && mergeSpalten != null) {
                    mergeZeileUsed[zNr] = true;
                    j = this.getKeySpalten();
                    while (j < Spalte.length) {
                        if (mergeSpalten[zNr][j].length() > 0) {
                            Spalte[j] = mergeSpalten[zNr][j];
                        }
                        ++j;
                    }
                }
            }
            if (this.getAnzahlSpalten() == 0 || this.getAnzahlSpalten() > 0 && Spalte.length >= this.getAnzahlSpalten()) {
                if (this.getTextbegrenzung().length() > 0) {
                    j = 0;
                    while (j < Spalte.length) {
                        Spalte[j] = FString.fTrim(Spalte[j], this.getTextbegrenzung());
                        ++j;
                    }
                }
                work.add(Spalte);
            }
            ++i;
        }
        String[] work1 = FString.convertTabelleToStringArray(FString.arrayListToTabelle(work));
        work.clear();
        if (mergeZeile != null && mergeSpalten != null) {
            i = 0;
            while (i < mergeZeile.length) {
                if (!mergeZeileUsed[i]) {
                    work.add(mergeSpalten[i]);
                }
                ++i;
            }
            work1 = FString.verbindenStringArraysDeleteDoppelte(work1, FString.convertTabelleToStringArray(FString.arrayListToTabelle(work)), false);
        }
        if (this.isLfdNrDominant() && (lfdNrAnzahl = (int)((this.getLfdNrBisNum() - this.getLfdNrVonNum()) / (long)this.getLfdNrSchrittweiteNum()) + 1) != work1.length) {
            work1 = FString.copyStringArray(work1, lfdNrAnzahl);
        }
        return FString.convertStringArrayToTabelle(work1, this.getAnzahlSpalten(), "\t");
    }

    public void run() {
        FProt fProt = FProt.instance();
        Futi.instance();
        String[] Zeile = Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), true, this.getCharset());
        this.checkFormat();
        this.checkLfdNr();
        ArrayList<String> Ausgabe = new ArrayList<String>();
        fProt.prot(Zeile, 1);
        this.setTrennzeichenEingabe(Futi.checkTrennzeichen(this.getTrennzeichenEingabe()));
        this.setTrennzeichenAusgabe(Futi.checkTrennzeichen(this.getTrennzeichenAusgabe()));
        String[][] work = this.prepareZeilen(Zeile);
        int i = 0;
        while (i < work.length) {
            String Aus = this.getFormatWork();
            if (this.LfdNrOK) {
                Aus = Aus.replace("#L", "" + (this.getLfdNrVonNum() + (long)(i * this.getLfdNrSchrittweiteNum())));
            }
            Aus = Aus.replace("#T", this.getTrennzeichenAusgabe());
            Aus = Aus.replace("#H", "\"");
            Aus = Aus.replace("#h", "'");
            Aus = Aus.replace("#N", System.getProperty("line.separator"));
            Aus = Aus.replace("#C", Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
            String[] Spalte = work[i];
            int j = Spalte.length - 1;
            while (j >= 0) {
                Aus = Aus.replace("#" + (j + 1), Spalte[j]);
                --j;
            }
            if (Spalte.length == 0) {
                Aus = Aus.replace("#1", " ");
            }
            Aus = Aus.replace("$$S", "#");
            Ausgabe.add(Aus);
            ++i;
        }
        Zeile = this.isKeineNeueZeileAmZeilenende() ? new String[]{FString.arrayListToString(Ausgabe)} : FString.arrayListToStringArray(Ausgabe);
        fProt.prot(Zeile, 1);
        Futi.setAusgabe(Zeile, this.getAusgabedatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), this.isKopierenAusgabeInClipboard());
    }

    public void setAnzahlSpalten() {
        this.AnzahlSpalten = FParam.getIntParameter("AnzahlSpalten", this.ArgTab);
    }

    public void setAnzahlSpalten(int anzahlSpalten) {
        FParam.instance();
        this.AnzahlSpalten = FParam.checkIntParameter("AnzahlSpalten", anzahlSpalten, this.ArgTab);
    }

    public void setAnzahlSpalten(String anzahlSpalten) {
        this.AnzahlSpalten = FParam.checkIntParameter("AnzahlSpalten", anzahlSpalten, this.ArgTab);
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setFehlendeSpaltenAuffuellen() {
        this.FehlendeSpaltenAuffuellen = FParam.getBooleanParameter("FehlendeSpaltenAuffuellen", this.ArgTab);
    }

    public void setFehlendeSpaltenAuffuellen(boolean fehlendeSpaltenAuffuellen) {
        this.FehlendeSpaltenAuffuellen = fehlendeSpaltenAuffuellen;
    }

    public void setFormat() {
        this.Format = FParam.getStringParameter("Format", this.ArgTab);
    }

    public void setFormat(String format) {
        FParam.instance();
        this.Format = FParam.checkStringParameter("Format", format, this.ArgTab);
    }

    private void setFormatWork(String formatWork) {
        this.FormatWork = formatWork;
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKeineNeueZeileAmZeilenende() {
        this.KeineNeueZeileAmZeilenende = FParam.getBooleanParameter("KeineNeueZeileAmZeilenende", this.ArgTab);
    }

    public void setKeineNeueZeileAmZeilenende(boolean keineNeueZeileAmZeilenende) {
        this.KeineNeueZeileAmZeilenende = keineNeueZeileAmZeilenende;
    }

    public void setKeySpalten() {
        this.KeySpalten = FParam.getIntParameter("KeySpalten", this.ArgTab);
    }

    public void setKeySpalten(int keySpalten) {
        this.KeySpalten = FParam.checkIntParameter("KeySpalten", keySpalten, this.ArgTab);
    }

    public void setKeySpalten(String keySpalten) {
        this.KeySpalten = FParam.checkIntParameter("KeySpalten", keySpalten, this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard() {
        this.KopierenAusgabeInClipboard = FParam.getBooleanParameter("KopierenAusgabeInClipboard", this.ArgTab);
    }

    public void setKopierenAusgabeInClipboard(boolean kopierenAusgabeInClipboard) {
        this.KopierenAusgabeInClipboard = kopierenAusgabeInClipboard;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setLfdNrBis() {
        this.LfdNrBis = FParam.getStringParameter("LfdNrBis", this.ArgTab);
    }

    public void setLfdNrBis(String lfdNrBis) {
        this.LfdNrBis = FParam.checkStringParameter("LfdNrBis", lfdNrBis, this.ArgTab);
    }

    private void setLfdNrBisNum(long lfdNrBisNum) {
        this.LfdNrBisNum = lfdNrBisNum;
    }

    private void setLfdNrDominant(boolean lfdNrDominant) {
        this.LfdNrDominant = lfdNrDominant;
    }

    private void setLfdNrOK(boolean lfdNrOK) {
        this.LfdNrOK = lfdNrOK;
    }

    public void setLfdNrSchrittweite() {
        this.LfdNrSchrittweite = FParam.getStringParameter("LfdNrSchrittweite", this.ArgTab);
    }

    public void setLfdNrSchrittweite(String lfdNrSchrittweite) {
        this.LfdNrSchrittweite = FParam.checkStringParameter("LfdNrSchrittweite", lfdNrSchrittweite, this.ArgTab);
    }

    private void setLfdNrSchrittweiteNum(int lfdNrSchrittweiteNum) {
        this.LfdNrSchrittweiteNum = lfdNrSchrittweiteNum;
    }

    public void setLfdNrVon() {
        this.LfdNrVon = FParam.getStringParameter("LfdNrVon", this.ArgTab);
    }

    public void setLfdNrVon(String lfdNrVon) {
        this.LfdNrVon = FParam.checkStringParameter("LfdNrVon", lfdNrVon, this.ArgTab);
    }

    private void setLfdNrVonNum(long lfdNrVonNum) {
        this.LfdNrVonNum = lfdNrVonNum;
    }

    public void setMergedatei() {
        this.Mergedatei = FParam.getStringParameter("Mergedatei", this.ArgTab);
    }

    public void setMergedatei(String mergedatei) {
        this.Mergedatei = FParam.checkStringParameter("Mergedatei", mergedatei, this.ArgTab);
    }

    public void setSkipZeilen() {
        this.SkipZeilen = FParam.getIntParameter("SkipZeilen", this.ArgTab);
    }

    public void setSkipZeilen(int skipZeilen) {
        FParam.instance();
        this.SkipZeilen = FParam.checkIntParameter("SkipZeilen", skipZeilen, this.ArgTab);
    }

    public void setSkipZeilen(String skipZeilen) {
        this.SkipZeilen = FParam.checkIntParameter("SkipZeilen", skipZeilen, this.ArgTab);
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setTextbegrenzung() {
        this.Textbegrenzung = FParam.getStringParameter("Textbegrenzung", this.ArgTab);
    }

    public void setTextbegrenzung(String textbegrenzung) {
        FParam.instance();
        this.Textbegrenzung = FParam.checkStringParameter("Textbegrenzung", textbegrenzung, this.ArgTab);
    }

    public void setTrennzeichenAusgabe() {
        this.TrennzeichenAusgabe = FParam.getStringParameter("TrennzeichenAusgabe", this.ArgTab);
    }

    public void setTrennzeichenAusgabe(String trennzeichenAusgabe) {
        this.TrennzeichenAusgabe = FParam.checkStringParameter("TrennzeichenAusgabe", trennzeichenAusgabe, this.ArgTab);
    }

    public void setTrennzeichenEingabe() {
        this.TrennzeichenEingabe = FParam.getStringParameter("TrennzeichenEingabe", this.ArgTab);
    }

    public void setTrennzeichenEingabe(String trennzeichenEingabe) {
        this.TrennzeichenEingabe = FParam.checkStringParameter("TrennzeichenEingabe", trennzeichenEingabe, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setEingabedatei();
        this.setMergedatei();
        this.setCharset();
        this.setAusgabedatei();
        this.setTrennzeichenEingabe();
        this.setTrennzeichenAusgabe();
        this.setTextbegrenzung();
        this.setAnzahlSpalten();
        this.setKeySpalten();
        this.setSkipZeilen();
        this.setKeineNeueZeileAmZeilenende();
        this.setFehlendeSpaltenAuffuellen();
        this.setLfdNrVon();
        this.setLfdNrBis();
        this.setLfdNrSchrittweite();
        this.setFormat();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
        this.setKopierenAusgabeInClipboard();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabedatei                                    :" + this.getEingabedatei());
        fProt.prot("Datei, die dazu gemergt wird                    :" + this.getMergedatei());
        fProt.prot("Charset (Codepage) fuer Eingabe                 :" + this.getCharset());
        fProt.prot("Ausgabedatei                                    :" + this.getAusgabedatei());
        fProt.prot("Trennzeichen fuer Eingabe (Separator)           :" + this.getTrennzeichenEingabe());
        fProt.prot("Trennzeichen fuer Ausgabe (Separator)           :" + this.getTrennzeichenAusgabe());
        fProt.prot("Text-/Spaltenbegrenzungzeichen (z.B.: Hochkomma):" + this.getTextbegrenzung());
        fProt.prot("Anzahl Spalten                                  :" + this.getAnzahlSpalten());
        fProt.prot("Anzahl Schluesselspalten                        :" + this.getKeySpalten());
        fProt.prot("Zeilen am Anfang ueberspringen                  :" + this.getSkipZeilen());
        fProt.prot("Keine NeueZeile am Zeilenende                   :" + this.isKeineNeueZeileAmZeilenende());
        fProt.prot("Fehlende Spalten mit Blank auffuellen           :" + this.isFehlendeSpaltenAuffuellen());
        fProt.prot("LfdNr von                                       :" + this.getLfdNrVon());
        fProt.prot("LfdNr bis                                       :" + this.getLfdNrBis());
        fProt.prot("LfdNr Schrittweite                              :" + this.getLfdNrSchrittweite());
        fProt.prot("Format fuer Ausgabe                             :" + this.getFormat());
        fProt.prot("TextArea statt Eingabedatei verwenden           :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden           :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Eingabe in TextArea kopieren:" + this.isKopierenClipboardInEingabe());
        fProt.prot("TextArea fuer Ausgabe in Zwischenablage kopieren:" + this.isKopierenAusgabeInClipboard());
    }
}

