/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JTextArea;

public class SucheStrings {
    private String Eingabedatei;
    private boolean EingabedateiGleichAusgabedatei;
    private String Ausgabedatei;
    private String Charset;
    private final boolean SetzenWerteInGUInachRun = false;
    private boolean TextAreaEingabe;
    private boolean KopierenClipboardInEingabe;
    private JTextArea JTextAreaEingabe = null;
    private JTextArea JTextAreaAusgabe = null;
    private final String Stand = "13.7.2009 16:47:23";
    private String Funktion;
    private String Checkdatei;
    private String Trennzeichen;
    private boolean TextAreaAusgabe;
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;

    public static void main(String[] args) {
        SucheStrings sucheStrings = new SucheStrings(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(sucheStrings.ArgTab, sucheStrings.ArgTabDefault, sucheStrings.getHilfeText())) {
            try {
                sucheStrings.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + sucheStrings.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                sucheStrings.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + sucheStrings.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + sucheStrings.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public SucheStrings() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public SucheStrings(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public String getAusgabedatei() {
        return this.Ausgabedatei;
    }

    public String getCharset() {
        return this.Charset;
    }

    public String getCheckdatei() {
        return this.Checkdatei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getEingabedatei() {
        return this.Eingabedatei;
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public JTextArea getJTextAreaAusgabe() {
        return this.JTextAreaAusgabe;
    }

    public JTextArea getJTextAreaEingabe() {
        return this.JTextAreaEingabe;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "13.7.2009 16:47:23";
    }

    public String getTrennzeichen() {
        return this.Trennzeichen;
    }

    public boolean isEingabedateiGleichAusgabedatei() {
        return this.EingabedateiGleichAusgabedatei;
    }

    public boolean isKopierenClipboardInEingabe() {
        return this.KopierenClipboardInEingabe;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return false;
    }

    public boolean isTextAreaAusgabe() {
        return this.TextAreaAusgabe;
    }

    public boolean isTextAreaEingabe() {
        return this.TextAreaEingabe;
    }

    public void run() {
        FProt fProt = FProt.instance();
        this.setTrennzeichen(Futi.checkTrennzeichen(this.getTrennzeichen()));
        String[] suche = Futi.getEingabe(this.getEingabedatei(), this.getJTextAreaEingabe(), this.isTextAreaEingabe(), this.isKopierenClipboardInEingabe(), false, this.getCharset());
        String[] sucheIn = Futi.getEingabe(this.getCheckdatei(), this.getJTextAreaAusgabe(), this.isTextAreaAusgabe(), false, false, this.getCharset());
        ArrayList<String> ausgabe = new ArrayList<String>();
        int pos = 0;
        String[] stringArray = suche;
        int n = suche.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (this.getFunktion().charAt(0) == 'A') {
                int[] poss = FString.findString(sucheIn, element, true);
                if (poss == null) {
                    ausgabe.add(String.valueOf(element) + "\tfehlt");
                } else {
                    int[] nArray = poss;
                    int n3 = poss.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int pos2 = nArray[n4];
                        ausgabe.add(String.valueOf(element) + "\t" + sucheIn[pos2]);
                        ++n4;
                    }
                }
            } else {
                pos = FString.findFirstString(sucheIn, element);
                if (pos < 0) {
                    ausgabe.add(String.valueOf(element) + "\tfehlt");
                } else if (this.getFunktion().charAt(0) != 'F') {
                    ausgabe.add(String.valueOf(element) + "\t" + sucheIn[pos]);
                }
            }
            ++n2;
        }
        if (this.getAusgabedatei().length() > 0) {
            new FFile(this.getAusgabedatei()).StringArrayListToInhalt(ausgabe);
        } else {
            fProt.prot(FString.arrayListToStringArray(ausgabe));
        }
    }

    public void setAusgabedatei() {
        this.Ausgabedatei = FParam.getStringParameter("Ausgabedatei", this.ArgTab);
    }

    public void setAusgabedatei(String ausgabedatei) {
        FParam.instance();
        this.Ausgabedatei = FParam.checkStringParameter("Ausgabedatei", ausgabedatei, this.ArgTab);
    }

    public void setCharset() {
        this.Charset = FParam.getStringParameter("Charset", this.ArgTab);
    }

    public void setCharset(String charset) {
        this.Charset = FParam.checkStringParameter("Charset", charset, this.ArgTab);
    }

    public void setCheckdatei() {
        this.Checkdatei = FParam.getStringParameter("Checkdatei", this.ArgTab);
    }

    public void setCheckdatei(String checkdatei) {
        FParam.instance();
        this.Checkdatei = FParam.checkStringParameter("Checkdatei", checkdatei, this.ArgTab);
    }

    public void setEingabedatei() {
        this.Eingabedatei = FParam.getStringParameter("Eingabedatei", this.ArgTab);
    }

    public void setEingabedatei(String eingabedatei) {
        FParam.instance();
        this.Eingabedatei = FParam.checkStringParameter("Eingabedatei", eingabedatei, this.ArgTab);
    }

    public void setEingabedateiGleichAusgabedatei() {
        FParam.instance();
        this.EingabedateiGleichAusgabedatei = FParam.getBooleanParameter("EingabedateiGleichAusgabedatei", this.ArgTab);
    }

    public void setEingabedateiGleichAusgabedatei(boolean eingabedateiGleichAusgabedatei) {
        this.EingabedateiGleichAusgabedatei = eingabedateiGleichAusgabedatei;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setJTextAreaAusgabe(JTextArea textAreaAusgabe) {
        this.JTextAreaAusgabe = textAreaAusgabe;
    }

    public void setJTextAreaEingabe(JTextArea textAreaEingabe) {
        this.JTextAreaEingabe = textAreaEingabe;
    }

    public void setKopierenClipboardInEingabe() {
        this.KopierenClipboardInEingabe = FParam.getBooleanParameter("KopierenClipboardInEingabe", this.ArgTab);
    }

    public void setKopierenClipboardInEingabe(boolean kopierenClipboardInEingabe) {
        this.KopierenClipboardInEingabe = kopierenClipboardInEingabe;
    }

    public void setTextAreaAusgabe() {
        this.TextAreaAusgabe = FParam.getBooleanParameter("TextAreaAusgabe", this.ArgTab);
    }

    public void setTextAreaAusgabe(boolean textAreaAusgabe) {
        this.TextAreaAusgabe = textAreaAusgabe;
    }

    public void setTextAreaEingabe() {
        this.TextAreaEingabe = FParam.getBooleanParameter("TextAreaEingabe", this.ArgTab);
    }

    public void setTextAreaEingabe(boolean textAreaEingabe) {
        this.TextAreaEingabe = textAreaEingabe;
    }

    public void setTrennzeichen() {
        this.Trennzeichen = FParam.getStringParameter("Trennzeichen", this.ArgTab);
    }

    public void setTrennzeichen(String trennzeichen) {
        FParam.instance();
        this.Trennzeichen = FParam.checkStringParameter("Trennzeichen", trennzeichen, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setFunktion();
        this.setEingabedatei();
        this.setCheckdatei();
        this.setCharset();
        this.setAusgabedatei();
        this.setTrennzeichen();
        this.setTextAreaEingabe();
        this.setTextAreaAusgabe();
        this.setKopierenClipboardInEingabe();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Funktion                                        :" + this.getFunktion());
        fProt.prot("Eingabedatei                                    :" + this.getEingabedatei());
        fProt.prot("Check gegen Datei                               :" + this.getCheckdatei());
        fProt.prot("Charset (Codepage) fuer Eingabe                 :" + this.getCharset());
        fProt.prot("Ausgabedatei                                    :" + this.getAusgabedatei());
        fProt.prot("Trennzeichen fuer Dat.Befehle                   :" + this.getTrennzeichen());
        fProt.prot("TextArea statt Eingabedatei verwenden           :" + this.isTextAreaEingabe());
        fProt.prot("TextArea statt Ausgabedatei verwenden           :" + this.isTextAreaAusgabe());
        fProt.prot("Zwischenablage fuer Eingabe in TextArea kopieren:" + this.isKopierenClipboardInEingabe());
    }
}

