/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Test;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FParam;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.Futi;
import java.text.NumberFormat;
import java.util.Date;

public class TestFFile {
    private String[][] ArgTab;
    private final String[][] ArgTabDefault;
    private String Verzeichnis;
    private String AuswahlDatei;
    private String AuswahlVerzeichnis;
    private boolean DirectoriesUndDateien;
    private boolean VergleichExclude;
    private String Datei;
    private String StichtagAlsDatum;
    private String StichtagUhrzeitZumDatum;
    private int StichtagInTagen;
    private final String Stand = "20.7.2009 18:41:14";
    private boolean StichtagVergleichAelter;
    private boolean NurBilder;
    private final boolean SetzenWerteInGUInachRun = true;
    private boolean NurDirectories;
    private int Groesse;
    private boolean VergleichVerzeichnisseExclude;
    private int AnzahlDateienInVerzeichnis;
    private String Funktion;
    private boolean KeineUnterverzeichnisse;

    public static void main(String[] args) {
        TestFFile testFFile = new TestFFile(args);
        FProt fProt = FProt.instance();
        FParam fParam = FParam.instance();
        double start = 0.0;
        if (fParam.runVorlauf(testFFile.ArgTab, testFFile.ArgTabDefault, testFFile.getHilfeText())) {
            try {
                testFFile.setWerteAusArgTab();
                if (fParam.isZeigeZeit()) {
                    fProt.prot("Start Verarbeitung " + testFFile.getClass().getSimpleName() + ": " + Futi.getZeit());
                    start = new Date().getTime();
                }
                testFFile.run();
                if (fParam.isZeigeZeit()) {
                    double ende = new Date().getTime();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMaximumFractionDigits(2);
                    nf.setMinimumFractionDigits(2);
                    fProt.prot("Ende  Verarbeitung " + testFFile.getClass().getSimpleName() + ": " + Futi.getZeit() + ", " + nf.format((ende - start) / 1000.0) + " Sek.");
                }
            }
            catch (Exception e) {
                System.err.println("Fehler in " + testFFile.getClass().toString());
                e.printStackTrace();
            }
        }
    }

    public TestFFile() {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(Tab);
        this.setWerteAusArgTab();
    }

    public TestFFile(String[] args) {
        String[][] Tab = FParam.readParameter(this.getClass().getSimpleName());
        this.ArgTab = FParam.instance().setArgTab(Tab);
        this.ArgTabDefault = FParam.copyArgTab(this.ArgTab);
        this.ArgTab = FParam.pruefenUndSpeichernParameter(args, this.ArgTab);
    }

    public int getAnzahlDateienInVerzeichnis() {
        return this.AnzahlDateienInVerzeichnis;
    }

    public String getAuswahlDatei() {
        return this.AuswahlDatei;
    }

    public String getAuswahlVerzeichnis() {
        return this.AuswahlVerzeichnis;
    }

    public String getDatei() {
        return this.Datei;
    }

    public String getDefault(String parameter, String typ) {
        return FParam.getDefault(parameter, typ, this.ArgTab);
    }

    public String getFunktion() {
        return this.Funktion;
    }

    public int getGroesse() {
        return this.Groesse;
    }

    public String[] getHilfeText() {
        return Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".bes");
    }

    public String[] getListeVonDateien(String verzeichnis) {
        FProt fProt = FProt.instance();
        FQuickSort fQuickSort = FQuickSort.instance();
        String[] Dateien = null;
        FFile Verz = new FFile(verzeichnis);
        fProt.prot("Verzeichnis: " + verzeichnis, 2);
        if (this.isNurDirectories()) {
            Dateien = Verz.listFileNames('V', !this.isKeineUnterverzeichnisse());
            if (this.getFunktion().compareTo("D") == 0) {
                Dateien = fQuickSort.quickSort(Dateien, false, false);
            }
        } else {
            Dateien = this.isNurBilder() ? Verz.listFileNames('B', !this.isKeineUnterverzeichnisse()) : Verz.listFileNames('D', !this.isKeineUnterverzeichnisse());
        }
        fProt.prot(Dateien, 4);
        int i = 0;
        while (i < Dateien.length) {
            Dateien[i] = String.valueOf(Verz.getAbsolutePath()) + System.getProperty("file.separator") + Dateien[i];
            ++i;
        }
        fProt.prot(Dateien, 4);
        return Dateien;
    }

    public String[] getParameterBeschreibung() {
        return FParam.getParameterBeschreibung(this.ArgTabDefault, true, "");
    }

    public String getStand() {
        return "20.7.2009 18:41:14";
    }

    public String getStichtagAlsDatum() {
        return this.StichtagAlsDatum;
    }

    public int getStichtagInTagen() {
        return this.StichtagInTagen;
    }

    public String getStichtagUhrzeitZumDatum() {
        return this.StichtagUhrzeitZumDatum;
    }

    public String getVergleichsausdruck() {
        return this.AuswahlDatei;
    }

    public String getVerzeichnis() {
        return this.Verzeichnis;
    }

    public boolean isDirectoriesUndDateien() {
        return this.DirectoriesUndDateien;
    }

    public boolean isKeineUnterverzeichnisse() {
        return this.KeineUnterverzeichnisse;
    }

    public boolean isNurBilder() {
        return this.NurBilder;
    }

    public boolean isNurDirectories() {
        return this.NurDirectories;
    }

    public boolean isSetzenWerteInGUInachRun() {
        return true;
    }

    public boolean isStichtagVergleichAelter() {
        return this.StichtagVergleichAelter;
    }

    public boolean isVergleichExclude() {
        return this.VergleichExclude;
    }

    public boolean isVergleichVerzeichnisseExclude() {
        return this.VergleichVerzeichnisseExclude;
    }

    public void run() {
        FProt fProt = FProt.instance();
        FFile datei = new FFile(this.getVerzeichnis());
        datei.setAuswahlAusgabeListe(this.getDatei());
        datei.setAuswahlDatei(this.getAuswahlDatei());
        datei.setAuswahlDateiExclude(this.isVergleichExclude());
        datei.setAuswahlDateiIgnoreCase(true);
        datei.setAuswahlGroesse(this.getGroesse());
        datei.setAuswahlAnzahlDateien(this.getAnzahlDateienInVerzeichnis());
        datei.setAuswahlNurBilder(this.isNurBilder());
        datei.setAusgabeDateien(!this.isNurDirectories());
        datei.setAusgabeVerzeichnisse(this.isNurDirectories());
        datei.setAuswahlAlles(this.isDirectoriesUndDateien());
        datei.setAuswahlStichtag(this.getStichtagInTagen());
        datei.setAuswahlStichtag(this.getStichtagAlsDatum());
        datei.setAuswahlStichtagUhrzeit(this.getStichtagUhrzeitZumDatum());
        datei.setAuswahlStichVergleichAelter(this.isStichtagVergleichAelter());
        datei.setAuswahlVerzeichnis(this.getAuswahlVerzeichnis());
        datei.setAuswahlVerzeichnisExclude(this.isVergleichVerzeichnisseExclude());
        datei.setAuswahlVerzeichnisIgnoreCase(true);
        if (this.getFunktion().compareTo("A") == 0) {
            datei.disableSortieren();
            fProt.prot("nurNamen, VerzeichnisRelativ");
            datei.setAusgabeNurNamen(true);
            datei.setAusgabeVerzeichnisRelativ(true);
            fProt.prot(datei.listjfi());
            fProt.prot("nurNamen, !VerzeichnisRelativ");
            datei.setAusgabeNurNamen(true);
            datei.setAusgabeVerzeichnisRelativ(false);
            fProt.prot(datei.listjfi());
            fProt.prot("!nurNamen, VerzeichnisRelativ");
            datei.setAusgabeNurNamen(false);
            datei.setAusgabeVerzeichnisRelativ(true);
            fProt.prot(datei.listjfi());
            fProt.prot("!nurNamen, !VerzeichnisRelativ");
            datei.setAusgabeNurNamen(false);
            datei.setAusgabeVerzeichnisRelativ(false);
            fProt.prot(datei.listjfi());
        }
        if (this.getFunktion().compareTo("D") == 0) {
            datei.setAuswahlAusgabeNurInDatei(true);
            datei.setAuswahlAusgabeListe(this.getDatei());
            fProt.prot("Ausgabe nur in Datei: keine Ausgabe mit prot ist O.K.");
        }
        if (this.getFunktion().compareTo("S") == 0) {
            datei.setSortiereNachNamen(true);
            fProt.prot("Name, A");
            fProt.prot(datei.listjfi());
            datei.setSortiereNachGroesse(true);
            fProt.prot("Groesse, A");
            fProt.prot(datei.listjfi());
            datei.setSortiereNachDatum(true);
            fProt.prot("Datum, A");
            fProt.prot(datei.listjfi());
            datei.setSortiereNachDatum(false);
            fProt.prot("kein Sort, A");
            fProt.prot(datei.listjfi());
            datei.setSortiereAufsteigend(false);
            datei.setSortiereNachNamen(true);
            fProt.prot("Name, D");
            fProt.prot(datei.listjfi());
            datei.setSortiereNachGroesse(true);
            fProt.prot("Groesse, D");
            fProt.prot(datei.listjfi());
            datei.setSortiereNachDatum(true);
            fProt.prot("Datum, D");
            fProt.prot(datei.listjfi());
            datei.disableSortieren();
            fProt.prot("kein Sort, D");
            fProt.prot(datei.listjfi());
        }
    }

    public void setAnzahlDateienInVerzeichnis() {
        this.AnzahlDateienInVerzeichnis = FParam.getIntParameter("AnzahlDateienInVerzeichnis", this.ArgTab);
    }

    public void setAnzahlDateienInVerzeichnis(int anzahlDateienInVerzeichnis) {
        this.AnzahlDateienInVerzeichnis = FParam.checkIntParameter("AnzahlDateienInVerzeichnis", anzahlDateienInVerzeichnis, this.ArgTab);
    }

    public void setAnzahlDateienInVerzeichnis(String anzahlDateienInVerzeichnis) {
        this.AnzahlDateienInVerzeichnis = FParam.checkIntParameter("AnzahlDateienInVerzeichnis", anzahlDateienInVerzeichnis, this.ArgTab);
    }

    public void setAusdruck() {
        FParam.instance();
        this.AuswahlDatei = FParam.getStringParameter("Vergleichsausdruck", this.ArgTab);
    }

    public void setAuswahlDatei() {
        this.AuswahlDatei = FParam.getStringParameter("AuswahlDatei", this.ArgTab);
    }

    public void setAuswahlDatei(String auswahlDatei) {
        FParam.instance();
        this.AuswahlDatei = FParam.checkStringParameter("AuswahlDatei", auswahlDatei, this.ArgTab);
    }

    public void setAuswahlVerzeichnis() {
        this.AuswahlVerzeichnis = FParam.getStringParameter("AuswahlVerzeichnis", this.ArgTab);
    }

    public void setAuswahlVerzeichnis(String auswahlVerzeichnis) {
        FParam.instance();
        this.AuswahlVerzeichnis = FParam.checkStringParameter("AuswahlVerzeichnis", auswahlVerzeichnis, this.ArgTab);
    }

    public void setDatei() {
        this.Datei = FParam.getStringParameter("Datei", this.ArgTab);
    }

    public void setDatei(String datei) {
        FParam.instance();
        this.Datei = FParam.checkStringParameter("Datei", datei, this.ArgTab);
    }

    public void setDirectoriesUndDateien() {
        this.DirectoriesUndDateien = FParam.getBooleanParameter("DirectoriesUndDateien", this.ArgTab);
    }

    public void setDirectoriesUndDateien(boolean dateienundDirectories) {
        this.DirectoriesUndDateien = dateienundDirectories;
    }

    public void setFunktion() {
        this.Funktion = FParam.getStringParameter("Funktion", this.ArgTab);
    }

    public void setFunktion(String funktion) {
        FParam.instance();
        this.Funktion = FParam.checkStringParameter("Funktion", funktion, this.ArgTab);
    }

    public void setGroesse() {
        this.Groesse = FParam.getIntParameter("Groesse", this.ArgTab);
    }

    public void setGroesse(int groesse) {
        FParam.instance();
        this.Groesse = FParam.checkIntParameter("Groesse", groesse, this.ArgTab);
    }

    public void setGroesse(String groesse) {
        this.Groesse = FParam.checkIntParameter("Groesse", groesse, this.ArgTab);
    }

    public void setKeineUnterverzeichnisse() {
        this.KeineUnterverzeichnisse = FParam.getBooleanParameter("KeineUnterverzeichnisse", this.ArgTab);
    }

    public void setKeineUnterverzeichnisse(boolean keineUnterverzeichnisse) {
        this.KeineUnterverzeichnisse = keineUnterverzeichnisse;
    }

    public void setNurBilder() {
        this.NurBilder = FParam.getBooleanParameter("NurBilder", this.ArgTab);
    }

    public void setNurBilder(boolean nurBilder) {
        this.NurBilder = nurBilder;
    }

    public void setNurDirectories() {
        this.NurDirectories = FParam.getBooleanParameter("NurDirectories", this.ArgTab);
    }

    public void setNurDirectories(boolean nurDirectories) {
        this.NurDirectories = nurDirectories;
    }

    public void setStichtagAlsDatum() {
        this.StichtagAlsDatum = FParam.getDateParameter("StichtagAlsDatum", this.ArgTab);
    }

    public void setStichtagAlsDatum(String stichtagAlsDatum) {
        FParam.instance();
        this.StichtagAlsDatum = FParam.checkDateParameter("StichtagAlsDatum", stichtagAlsDatum, this.ArgTab);
    }

    public void setStichtagAlsDatum(String stichtagAlsDatum, boolean umsetzen) {
        FParam.instance();
        this.StichtagAlsDatum = FParam.checkDateParameter("StichtagAlsDatum", stichtagAlsDatum, umsetzen, this.ArgTab);
    }

    public void setStichtagInTagen() {
        this.StichtagInTagen = FParam.getIntParameter("StichtagInTagen", this.ArgTab);
    }

    public void setStichtagInTagen(int stichtagInTagen) {
        FParam.instance();
        this.StichtagInTagen = FParam.checkIntParameter("StichtagInTagen", stichtagInTagen, this.ArgTab);
    }

    public void setStichtagInTagen(String stichtagInTagen) {
        this.StichtagInTagen = FParam.checkIntParameter("StichtagInTagen", stichtagInTagen, this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum() {
        this.StichtagUhrzeitZumDatum = FParam.getTimeParameter("StichtagUhrzeitZumDatum", this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum(String stichtagUhrzeitZumDatum) {
        FParam.instance();
        this.StichtagUhrzeitZumDatum = FParam.checkTimeParameter("StichtagUhrzeitZumDatum", stichtagUhrzeitZumDatum, this.ArgTab);
    }

    public void setStichtagUhrzeitZumDatum(String stichtagUhrzeitZumDatum, boolean umsetzen) {
        FParam.instance();
        this.StichtagUhrzeitZumDatum = FParam.checkTimeParameter("StichtagUhrzeitZumDatum", stichtagUhrzeitZumDatum, umsetzen, this.ArgTab);
    }

    public void setStichtagVergleichAelter() {
        this.StichtagVergleichAelter = FParam.getBooleanParameter("StichtagVergleichAelter", this.ArgTab);
    }

    public void setStichtagVergleichAelter(boolean stichVergleichAelter) {
        this.StichtagVergleichAelter = stichVergleichAelter;
    }

    public void setVergleichExclude() {
        this.VergleichExclude = FParam.getBooleanParameter("VergleichExclude", this.ArgTab);
    }

    public void setVergleichExclude(boolean vergleichExclude) {
        this.VergleichExclude = vergleichExclude;
    }

    public void setVergleichVerzeichnisseExclude() {
        this.VergleichVerzeichnisseExclude = FParam.getBooleanParameter("VergleichVerzeichnisseExclude", this.ArgTab);
    }

    public void setVergleichVerzeichnisseExclude(boolean vergleichVerzeichnisseExclude) {
        this.VergleichVerzeichnisseExclude = vergleichVerzeichnisseExclude;
    }

    public void setVerzeichnis() {
        this.Verzeichnis = FParam.getStringParameter("Verzeichnis", this.ArgTab);
    }

    public void setVerzeichnis(String verzeichnis) {
        FParam.instance();
        this.Verzeichnis = FParam.checkStringParameter("Verzeichnis", verzeichnis, this.ArgTab);
    }

    public void setWerteAusArgTab() {
        this.setVerzeichnis();
        this.setFunktion();
        this.setDatei();
        this.setAuswahlDatei();
        this.setVergleichExclude();
        this.setAuswahlVerzeichnis();
        this.setVergleichVerzeichnisseExclude();
        this.setStichtagAlsDatum();
        this.setStichtagUhrzeitZumDatum();
        this.setStichtagInTagen();
        this.setStichtagVergleichAelter();
        this.setGroesse();
        this.setAnzahlDateienInVerzeichnis();
        this.setNurBilder();
        this.setNurDirectories();
        this.setDirectoriesUndDateien();
        this.setKeineUnterverzeichnisse();
    }

    public void zeigenParameter() {
        FProt fProt = FProt.instance();
        fProt.prot("Eingabeverzeichnis                                           :" + this.getVerzeichnis());
        fProt.prot("Funktion                                                     :" + this.getFunktion());
        fProt.prot("Ausgabedatei                                                 :" + this.getDatei());
        fProt.prot("Auswahl Dateien                                              :" + this.getAuswahlDatei());
        fProt.prot("Auswahl Dateien Exclude                                      :" + this.isVergleichExclude());
        fProt.prot("Auswahl Verzeichnisse                                        :" + this.getAuswahlVerzeichnis());
        fProt.prot("Auswahl Verzeichnisse Exclude                                :" + this.isVergleichVerzeichnisseExclude());
        fProt.prot("Auswahl Dateien: Stichtag, Eingabe als Datum                 :" + this.getStichtagAlsDatum());
        fProt.prot("Auswahl Dateien: Uhrzeit zum Stichtag                        :" + this.getStichtagUhrzeitZumDatum());
        fProt.prot("Auswahl Dateien: Stichtag, Eingabe in Tagen                  :" + this.getStichtagInTagen());
        fProt.prot("Auswahl Dateien: Stichtag: aelter als Stichtag, sonst juenger:" + this.isStichtagVergleichAelter());
        fProt.prot("Auswahl Dateien: Groesse                                     :" + this.getGroesse());
        fProt.prot("Auswahl Verzeichnisse: Anzahl Dateien                        :" + this.getAnzahlDateienInVerzeichnis());
        fProt.prot("Auswahl Dateien: nur Bilder                                  :" + this.isNurBilder());
        fProt.prot("Auswahl: nur Directories                                     :" + this.isNurDirectories());
        fProt.prot("Auswahl: Dateien und Directories                             :" + this.isDirectoriesUndDateien());
        fProt.prot("Keine Unterverzeichnisse                                     :" + this.isKeineUnterverzeichnisse());
    }
}

