/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import at.jta.Key;
import at.jta.RegistryErrorException;
import at.jta.Regor;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class FDB {
    private static FDB instance;
    private static final String[][] accessTreiber;
    private static final String[][] sqliteTreiber;
    private static boolean DBAccess;
    private static boolean DBSqlite;

    static {
        accessTreiber = new String[][]{{"mdb", "Microsoft Access Driver"}, {"xls", "Microsoft Excel Driver"}};
        sqliteTreiber = new String[][]{{"sdb", "SQLite Driver"}, {"sqlite", "SQLite Driver"}, {"sqlite3", "SQLite Driver"}};
        DBAccess = false;
        DBSqlite = false;
    }

    public static boolean checkDBConnection(String DBName) {
        return FDB.createDBConnection(DBName) != null;
    }

    private static String[] checkDBName(String DBName) {
        String datei;
        String[] rc = new String[]{"", ""};
        String[] DBs = FDB.getRegistrierteDBs();
        boolean isRegDB = false;
        String[] stringArray = DBs;
        int n = DBs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            if (db.compareToIgnoreCase(DBName) == 0) {
                rc[0] = db;
                isRegDB = true;
                break;
            }
            ++n2;
        }
        if (!isRegDB && (datei = FDatei.checkDatei(DBName, 'D', 'R', "DB-Datei fuer ODBC/JDBC")).length() > 0) {
            FDatei.DateinamenTeile teile = FDatei.instance().zerlegeDateiname(datei);
            rc[0] = String.valueOf(teile.getPfad()) + System.getProperty("file.separator") + teile.getName();
            rc[1] = teile.getExtend();
        }
        return rc;
    }

    public static void closeDBStatement(Statement DBStatement) {
        try {
            DBStatement.close();
            DBStatement.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Connection createDBConnection(String DBName) {
        FProt fProt = FProt.instance();
        Connection DBVerbindung = null;
        String[] dbName = FDB.checkDBName(DBName);
        try {
            if (dbName[1].length() > 0) {
                int pos = FString.findFirstString(accessTreiber, 0, dbName[1], true, true);
                if (pos >= 0) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                    DBVerbindung = DriverManager.getConnection("jdbc:odbc:Driver={" + accessTreiber[pos][1] + " (*." + dbName[1] + ")};DBQ=" + dbName[0] + "." + dbName[1]);
                    fProt.prot("DB-Connection get: jdbc:odbc:Driver={" + accessTreiber[pos][1] + " (*." + dbName[1] + ")};DB=" + dbName[0] + "." + dbName[1], 1);
                    fProt.prot(DBVerbindung.toString(), 4);
                    FDB.setDBAccess(true);
                } else {
                    pos = FString.findFirstString(sqliteTreiber, 0, dbName[1]);
                    if (pos >= 0) {
                        Class.forName("org.sqlite.JDBC");
                        DBVerbindung = DriverManager.getConnection("jdbc:sqlite:" + DBName);
                        fProt.prot("DB-Connection get: jdbc:sqlite:Driver={" + sqliteTreiber[pos][1] + " (*." + dbName[1] + ")};DB=" + dbName[0] + "." + dbName[1], 1);
                        fProt.prot(DBVerbindung.toString(), 4);
                        FDB.setDBSqlite(true);
                    } else {
                        fProt.prot("Fehler: Fuer " + dbName[0] + "." + dbName[1] + " ist kein Treiber verfuegbar");
                    }
                }
            } else {
                DBVerbindung = DriverManager.getConnection("jdbc:odbc:" + dbName[0]);
                FDB.setDBAccess(true);
            }
            if (DBVerbindung != null) {
                fProt.prot("DB-Connection: jdbc:odbc:" + dbName[0] + "." + dbName[1] + " erfolgreich", 1);
                DatabaseMetaData DBMetaData = DBVerbindung.getMetaData();
                fProt.prot("DB-Connection URL: " + DBMetaData.getURL(), 1);
                fProt.prot("DB-Driver Name:    " + DBMetaData.getDriverName(), 1);
                fProt.prot("DB-Driver Version: " + DBMetaData.getDriverVersion(), 1);
            } else {
                fProt.prot("DB-Connection: jdbc:odbc:" + dbName[0] + "." + dbName[1] + " nicht erfolgreich");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            fProt.prot("Fehler bei Connect zu DB: " + dbName[0] + "." + dbName[1]);
            FDB.handleException(e);
        }
        return DBVerbindung;
    }

    public static Statement createDBStatement(String DBName) {
        return FDB.createDBStatement(DBName, 0, 0, 0);
    }

    public static Statement createDBStatement(String DBName, int option1, int option2) {
        return FDB.createDBStatement(DBName, option1, option2, 0);
    }

    public static Statement createDBStatement(String DBName, int option1, int option2, int option3) {
        Connection DBVerbindung = FDB.createDBConnection(DBName);
        Statement DBStatement = null;
        if (DBVerbindung != null) {
            try {
                DBStatement = option1 == 0 && option2 == 0 && option3 == 0 ? DBVerbindung.createStatement() : (option3 == 0 ? DBVerbindung.createStatement(option1, option2) : DBVerbindung.createStatement(option1, option2, option3));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return DBStatement;
    }

    public static ResultSet executeQuery(Statement DBStatement, String sqlStatement) {
        return FDB.executeQuery(DBStatement, sqlStatement, true, 0);
    }

    public static ResultSet executeQuery(Statement DBStatement, String sqlStatement, boolean DoException) {
        return FDB.executeQuery(DBStatement, sqlStatement, DoException, 0);
    }

    public static ResultSet executeQuery(Statement DBStatement, String sqlStatement, boolean DoException, int MsgLevel) {
        ResultSet rs;
        block6: {
            FProt fProt = FProt.instance();
            rs = null;
            if (DBStatement == null) {
                fProt.prot("DB-Verbindung nicht vorhanden");
            } else if (sqlStatement == null || sqlStatement.length() == 0) {
                fProt.prot("SQL-Statement nicht vorhanden");
            } else {
                try {
                    fProt.prot(String.valueOf(FDB.getDBName(DBStatement)) + ": " + sqlStatement + " (Query)", MsgLevel);
                    rs = DBStatement.executeQuery(sqlStatement);
                }
                catch (SQLException e) {
                    if (!DoException) break block6;
                    fProt.prot("Fehler bei SQL-Statement: " + sqlStatement);
                    FDB.handleException(e);
                }
            }
        }
        return rs;
    }

    public static ResultSet executeQuery(Statement DBStatement, String sqlStatement, int MsgLevel) {
        return FDB.executeQuery(DBStatement, sqlStatement, true, MsgLevel);
    }

    public static int executeUpdate(Statement DBStatement, String sqlStatement) {
        return FDB.executeUpdate(DBStatement, sqlStatement, true, 2);
    }

    public static int executeUpdate(Statement DBStatement, String sqlStatement, boolean DoException) {
        return FDB.executeUpdate(DBStatement, sqlStatement, DoException, 2);
    }

    public static int executeUpdate(Statement DBStatement, String sqlStatement, boolean DoException, int MsgLevel) {
        int UpdCount;
        block2: {
            FProt fProt = FProt.instance();
            UpdCount = 0;
            try {
                UpdCount = DBStatement.executeUpdate(sqlStatement);
                fProt.prot(String.valueOf(FDB.getDBName(DBStatement)) + ": " + sqlStatement + " (Update-Count: " + UpdCount + ")", MsgLevel);
            }
            catch (SQLException e) {
                if (!DoException) break block2;
                fProt.prot("Fehler bei SQL-Statement: " + sqlStatement);
                FDB.handleException(e);
            }
        }
        return UpdCount;
    }

    public static int executeUpdate(Statement DBStatement, String sqlStatement, int MsgLevel) {
        return FDB.executeUpdate(DBStatement, sqlStatement, true, MsgLevel);
    }

    public static int getColumnLength(String[][] ColumnTabelle, String ColumnName) {
        int Laenge = 10;
        String[][] stringArray = ColumnTabelle;
        int n = ColumnTabelle.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (element[0].compareTo(ColumnName) == 0) {
                Laenge = Integer.parseInt(element[2]);
                break;
            }
            ++n2;
        }
        return Laenge;
    }

    public static String getDBfalse() {
        String wert = "false";
        if (FDB.isDBSqlite()) {
            wert = "0";
        }
        return wert;
    }

    public static String getDBName(Statement DBStatement) {
        String dBName = "";
        try {
            dBName = "DB-" + DBStatement.getConnection().getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (dBName.startsWith("jdbc:odbc:")) {
            dBName = "DB-" + dBName.substring("jdbc:odbc:".length());
        }
        return dBName;
    }

    public static String getDBtrue() {
        String wert = "true";
        if (FDB.isDBSqlite()) {
            wert = "1";
        }
        return wert;
    }

    public static String[] getRegistrierteDBs() {
        return FDB.getRegistrierteDBs(false);
    }

    public static String[] getRegistrierteDBs(boolean mitDateinamen) {
        ArrayList<String> Ausgabe = new ArrayList<String>();
        if (Futi.isWindows()) {
            Key Key1 = null;
            Key Key2 = null;
            try {
                Regor reg = new Regor();
                Key1 = reg.openKey(Regor.HKEY_CURRENT_USER, "Software\\ODBC\\ODBC.INI\\");
                if (Key1 != null) {
                    List listKey1 = reg.listKeys(Key1);
                    int i = 0;
                    while (listKey1 != null && i != listKey1.size()) {
                        String DBName = (String)listKey1.get(i);
                        Key2 = reg.openKey(Key1, (String)listKey1.get(i));
                        List listKey2 = reg.listValueNames(Key2);
                        int j = 0;
                        while (listKey2 != null && j != listKey2.size()) {
                            String DBDatei;
                            if (((String)listKey2.get(j)).startsWith("DBQ") && (DBDatei = Regor.parseValue(reg.readValue(Key2, (String)listKey2.get(j)))).length() > 0 && new File(DBDatei).exists()) {
                                Ausgabe.add(String.valueOf(DBName) + (mitDateinamen ? " - " + DBDatei : ""));
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (RegistryErrorException e) {
                e.printStackTrace();
            }
        }
        return FString.arrayListToStringArray(Ausgabe);
    }

    public static String[] getSQLSelect(String dbName, String tabelleOrView, String[] fields) {
        return FDB.getSQLSelect(dbName, tabelleOrView, fields, null, false);
    }

    public static String[] getSQLSelect(String dbName, String tabelleOrView, String[] fields, String whereClause) {
        return FDB.getSQLSelect(dbName, tabelleOrView, fields, whereClause, false);
    }

    public static String[] getSQLSelect(String dbName, String tabelleOrView, String[] fields, String whereClause, boolean mitHeader) {
        FProt fProt = FProt.instance();
        String[] rc = null;
        if (dbName == null || dbName.length() == 0) {
            fProt.prot("DBname nicht angegeben");
        } else {
            File dbFile = new File(dbName);
            if (!dbFile.exists()) {
                fProt.prot(String.valueOf(dbName) + " nicht vorhanden");
            } else {
                Statement DBStatement = FDB.createDBStatement(dbName);
                if (DBStatement == null) {
                    fProt.prot(String.valueOf(dbName) + " DB-Verbindung nicht erstellbar");
                } else if (tabelleOrView == null || tabelleOrView.length() == 0) {
                    fProt.prot("Tabellen- oder Viewname nicht angegeben");
                } else if (fields == null || fields.length < 1) {
                    fProt.prot("Spaltennamen nicht angegeben");
                } else {
                    rc = FDB.resultSet2StringArray(FDB.executeQuery(DBStatement, "SELECT " + FString.stringArrayToString(fields, ",") + " FROM " + tabelleOrView + (whereClause == null || whereClause.length() == 0 ? "" : " WHERE " + whereClause)), mitHeader);
                }
            }
        }
        return rc;
    }

    public static String[] getTables(String DBName) {
        return FDB.getTables(DBName, "*");
    }

    public static String[] getTables(String DBName, String auswahl) {
        String Auswahl = auswahl;
        ArrayList<String> Ausgabe = new ArrayList<String>();
        if (Auswahl == null) {
            Auswahl = "*";
        }
        if (Auswahl.length() == 0) {
            Auswahl = "*";
        }
        try {
            Connection DBVerbindung = FDB.createDBConnection(DBName);
            if (DBVerbindung != null) {
                DatabaseMetaData DBMetaData = DBVerbindung.getMetaData();
                ResultSet rs = DBMetaData.getTables(null, null, "%", null);
                while (rs.next()) {
                    String Name = rs.getString("TABLE_NAME");
                    String Typ = rs.getString("TABLE_TYPE");
                    if (Auswahl.compareTo("*") == 0) {
                        Ausgabe.add(Name);
                        continue;
                    }
                    int i = 0;
                    while (i < Auswahl.length()) {
                        if (Typ.startsWith(Auswahl.substring(i, i + 1))) {
                            Ausgabe.add(Name);
                        }
                        ++i;
                    }
                }
                DBVerbindung.close();
            }
        }
        catch (SQLException e) {
            FDB.handleException(e);
        }
        return FString.arrayListToStringArray(Ausgabe);
    }

    public static void handleException(SQLException e) {
        FProt fProt = FProt.instance();
        SQLException E = e;
        while (E != null) {
            fProt.prot(e.toString());
            fProt.prot("SQL-State: " + E.getSQLState());
            fProt.prot("ErrorCode: " + E.getErrorCode());
            E = E.getNextException();
        }
    }

    public static synchronized FDB instance() {
        if (instance == null) {
            instance = new FDB();
        }
        return instance;
    }

    public static boolean isDBAccess() {
        return DBAccess;
    }

    public static boolean isDBSqlite() {
        return DBSqlite;
    }

    public static String replaceSonderzeichen(String zeile) {
        FProt fProt = FProt.instance();
        String Zeile = zeile;
        fProt.prot("Vor Bereinigung: " + Zeile, 5);
        Zeile = Zeile.replace(",", " ");
        Zeile = Zeile.replace("'", " ");
        Zeile = Zeile.replace('(', ' ');
        Zeile = Zeile.replace(')', ' ');
        Zeile = Zeile.replace('-', ' ');
        Zeile = Zeile.replace('.', ' ');
        Zeile = Zeile.replace('/', ' ');
        Zeile = Zeile.replace('\"', ' ');
        Zeile = Zeile.replace('%', ' ');
        Zeile = Zeile.replace('+', ' ');
        Zeile = Zeile.replace('-', ' ');
        Zeile = Zeile.replace(':', ' ');
        Zeile = Zeile.replace('\"', ' ');
        Zeile = Zeile.replace('\n', ' ');
        Zeile = Zeile.replace('\t', ' ');
        fProt.prot("Nach Bereinigung:" + Zeile, 5);
        return Zeile;
    }

    public static String[] resultSet2StringArray(ResultSet rs) {
        return FDB.resultSet2StringArray(rs, false);
    }

    public static String[] resultSet2StringArray(ResultSet rs, boolean mitHeader) {
        ArrayList<String> ausgabe = new ArrayList<String>();
        if (rs != null) {
            try {
                int i;
                String zeile;
                ResultSetMetaData md = rs.getMetaData();
                int anzahlSpalten = md.getColumnCount();
                if (mitHeader) {
                    zeile = "";
                    i = 1;
                    while (i <= anzahlSpalten) {
                        zeile = String.valueOf(zeile) + (zeile.isEmpty() ? "" : "\t") + md.getColumnName(i);
                        ++i;
                    }
                    ausgabe.add(zeile);
                }
                while (rs.next()) {
                    zeile = "";
                    i = 1;
                    while (i <= anzahlSpalten) {
                        try {
                            zeile = String.valueOf(zeile) + rs.getString(i).trim() + "\t";
                        }
                        catch (Exception e) {
                            zeile = String.valueOf(zeile) + "!!Spalte " + md.getColumnName(i) + " fehlerhaft, mglw. NULL!!";
                        }
                        ++i;
                    }
                    ausgabe.add(zeile);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return FString.arrayListToStringArray(ausgabe);
    }

    public static void setDBAccess(boolean dBAccess) {
        DBAccess = dBAccess;
    }

    public static void setDBSqlite(boolean dBSqlite) {
        DBSqlite = dBSqlite;
    }

    public String getColumnNamesAsString(String DBName, String Tabelle) {
        return this.getColumnNamesAsString(DBName, Tabelle, 32676);
    }

    public String getColumnNamesAsString(String DBName, String Tabelle, int MaxLength) {
        ResultSet rs = null;
        String Ausgabe = "";
        Statement DBStatement = FDB.createDBStatement(DBName);
        rs = FDB.executeQuery(DBStatement, "SELECT * FROM " + this.getName4Query(Tabelle), true, 2);
        if (rs != null) {
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                int i = 1;
                while (i <= numberOfColumns) {
                    String Feld = this.getName4Query(rsmd.getColumnName(i));
                    if (Ausgabe.length() + Feld.length() < MaxLength) {
                        if (i > 1) {
                            Ausgabe = String.valueOf(Ausgabe) + ",";
                        }
                        Ausgabe = String.valueOf(Ausgabe) + this.getName4Query(Feld);
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                FDB.handleException(e);
            }
        } else {
            Ausgabe = "*";
        }
        return Ausgabe;
    }

    public String[][] getColumns(String DBName, String Tabelle) {
        ResultSet rs = null;
        ArrayList<String[]> Ausgabe = new ArrayList<String[]>();
        Statement DBStatement = FDB.createDBStatement(DBName);
        rs = FDB.executeQuery(DBStatement, "SELECT * FROM " + Tabelle, true, 2);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int i = 1;
            while (i <= numberOfColumns) {
                String[] Column = new String[]{this.getName4Query(rsmd.getColumnName(i)), rsmd.getColumnTypeName(i), "" + rsmd.getColumnDisplaySize(i)};
                Ausgabe.add(Column);
                ++i;
            }
        }
        catch (SQLException e) {
            FDB.handleException(e);
        }
        return FString.arrayListToTabelle(Ausgabe);
    }

    public String[] getColumnsAsString(String DBName, String Tabelle) {
        ResultSet rs = null;
        ArrayList<String> Ausgabe = new ArrayList<String>();
        Statement DBStatement = FDB.createDBStatement(DBName);
        rs = FDB.executeQuery(DBStatement, "SELECT * FROM " + Tabelle, true, 2);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            int i = 1;
            while (i <= numberOfColumns) {
                Ausgabe.add(String.valueOf(this.getName4Query(rsmd.getColumnName(i))) + ", " + rsmd.getColumnTypeName(i) + ", " + rsmd.getColumnDisplaySize(i));
                ++i;
            }
        }
        catch (SQLException e) {
            FDB.handleException(e);
        }
        return FString.arrayListToStringArray(Ausgabe);
    }

    public String getName4Query(String name) {
        String[] replace;
        String Ausgabe = name;
        String[] stringArray = replace = Futi.readResource(String.valueOf(this.getClass().getSimpleName()) + ".replace");
        int n = replace.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Ausgabe = Ausgabe.replace(element.charAt(0), '_');
            ++n2;
        }
        if (!((Ausgabe = Ausgabe.trim()).startsWith("[") && Ausgabe.endsWith("]") || Ausgabe.indexOf(" ") <= 0 && Ausgabe.indexOf("-") <= 0 && Ausgabe.indexOf("+") <= 0)) {
            Ausgabe = "[" + Ausgabe + "]";
        }
        return Ausgabe;
    }
}

