/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.Uti.FBefehl;
import de.nss.jfi.Uti.FBild;
import de.nss.jfi.Uti.FDB;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FQuickSort;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class FDatei {
    private static int MsgLevelMedien = 0;
    private static boolean copyStattRecode = false;
    private static int AnzahlZeilenSpaltenPoster = 3;
    static final String[][] CountryCodes = new String[][]{{"DE", "Deutschland"}, {"FR", "Frankreich"}, {"AT", "\u00d6sterreich"}, {"CH", "Schweiz"}, {"IT", "Italien"}, {"CZ", "Tschechien"}, {"BE", "Belgien"}, {"NL", "Niederlande"}, {"LU", "Luxemburg"}, {"DK", "D\u00e4nemark"}, {"SE", "Schweden"}};
    private static FDatei instance;

    public static void audio(String dateiname, char funktion, boolean overwriteOriginal) {
        FFile medium = new FFile(dateiname);
        if (medium.isVideo()) {
            if (FDatei.hasAudio(medium.getAbsolutePath())) {
                DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
                if (funktion == 'x' || funktion == 'm') {
                    FFile output = new FFile(String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + "_audio" + System.getProperty("file.separator") + dateinamenTeile.getName() + ".mp3");
                    FFile thumbnail = new FFile(String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + "_audio" + System.getProperty("file.separator") + dateinamenTeile.getName() + "_thumbnail.jpg");
                    FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "mp3-File");
                    FDatei.checkDatei(thumbnail.getAbsolutePath(), 'D', 'W', "thumbnail-File");
                    output.deleteIfExits();
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-vn", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", thumbnail.getAbsolutePath(), "-preview:all", medium.getAbsolutePath()}), 5);
                    if (thumbnail.exists()) {
                        FBefehl.aufrufBefehl("eyed3", new String[]{"--add-image", String.valueOf(thumbnail.getAbsolutePath()) + ":FRONT_COVER", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                        thumbnail.delete();
                    }
                    FProt.instance().prot("Video " + medium.getAbsolutePath() + " Audio " + output.getAbsolutePath() + " extrahiert", 0);
                } else if (funktion == 'd') {
                    FFile output = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + "_ohne_Audio." + dateinamenTeile.getExtend());
                    output.deleteIfExits();
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-vcodec", "copy", "-an", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    FDatei.nachbereitenVideo(medium.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, false);
                    FProt.instance().prot("Video " + medium.getAbsolutePath() + " Audio geloescht", 0);
                } else if (funktion == 'd') {
                    FProt.instance().prot("Funktion " + funktion + " unbekannt: " + medium.getAbsolutePath(), 0);
                }
            } else {
                FProt.instance().prot("Video hat kein Audio: " + medium.getAbsolutePath(), 1);
            }
        } else if (medium.isAudio()) {
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
            if (funktion == 'm') {
                FFile output = new FFile(String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + "_audio" + System.getProperty("file.separator") + dateinamenTeile.getName() + ".mp3");
                FFile thumbnail = new FFile(String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + "_audio" + System.getProperty("file.separator") + dateinamenTeile.getName() + "_thumbnail.jpg");
                FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "mp3-File");
                FDatei.checkDatei(thumbnail.getAbsolutePath(), 'D', 'W', "thumbnail-File");
                output.deleteIfExits();
                FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-vn", "-q:a", "2", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", thumbnail.getAbsolutePath(), "-preview:all", medium.getAbsolutePath()}), 5);
                if (thumbnail.exists()) {
                    FBefehl.aufrufBefehl("eyed3", new String[]{"--add-image", String.valueOf(thumbnail.getAbsolutePath()) + ":FRONT_COVER", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    thumbnail.delete();
                }
                FProt.instance().prot("Audio " + medium.getAbsolutePath() + " -> " + output.getAbsolutePath() + " konvertiert", 0);
            } else if (funktion == 'd') {
                FProt.instance().prot("Funktion " + funktion + " unbekannt: " + medium.getAbsolutePath(), 0);
            }
        } else {
            FProt.instance().prot("Audio nicht implementiert, " + medium.getAbsolutePath() + " kein Video und kein Audio", 0);
        }
    }

    public static void changeSaturation(String fotoName, int prozentIn, String relVerzOutput) {
        FFile foto = new FFile(fotoName);
        if (!foto.isPicture()) {
            FProt.instance().prot(String.valueOf(fotoName) + " kein Foto", 0);
        } else {
            int prozent = FMath.checkRange(prozentIn, 50, 150);
            if (prozent == 100) {
                FProt.instance().prot(String.valueOf(fotoName) + " kein Verarbeitung, da Saettigung 100", 0);
            } else {
                DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(fotoName);
                FFile output = new FFile(String.valueOf(relVerzOutput == null || relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_saturation_" + prozent : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
                FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto Saturation");
                output.deleteIfExits();
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{foto.getAbsolutePath(), "-modulate", "100," + prozent, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FProt.instance().prot("Foto " + foto.getAbsolutePath() + " Saettigung auf " + prozent + " geaendert", 0);
            }
        }
    }

    public static int checkAndGetHoehe(String medium) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-Filename", "-GPSLatitude", "-GPSLongitude", "-GPSAltitude#", medium};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(medium) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[1].isEmpty() && !zeile[2].isEmpty()) {
                    boolean koordinatenOK = true;
                    int j = 1;
                    while (j < 3) {
                        try {
                            Double.parseDouble(zeile[j]);
                        }
                        catch (Exception e) {
                            koordinatenOK = false;
                        }
                        ++j;
                    }
                    if (koordinatenOK) {
                        medienToChange.add(zeile);
                    }
                }
                ++i;
            }
            String[][] medien = FString.convertArrayListToTabelle(medienToChange);
            String[][] org = FString.copyTabelle(medien);
            ArrayList<String> hoeheGeholt = new ArrayList<String>();
            int i2 = 0;
            while (i2 < medien.length) {
                String punkt = String.valueOf(medien[i2][1]) + "\t" + medien[i2][2];
                boolean hoeheVorhanden = false;
                if (hoeheGeholt.size() > 0) {
                    int j = hoeheGeholt.size() - 1;
                    while (j >= 0 && !hoeheVorhanden) {
                        if (((String)hoeheGeholt.get(j)).startsWith(punkt)) {
                            medien[i2][3] = ((String)hoeheGeholt.get(j)).substring(punkt.length() + 1).trim();
                            hoeheVorhanden = true;
                        }
                        --j;
                    }
                }
                if (!hoeheVorhanden) {
                    int alt = Futi.getGeoHoehe(Double.parseDouble(medien[i2][1]), Double.parseDouble(medien[i2][2]));
                    if (alt < 0) {
                        FProt.instance().prot("\tkeine Hoehe vermittelbar fuer\t" + medien[i2][0] + "\t" + medien[i2][1] + "\t" + medien[i2][2] + "\t");
                    } else {
                        medien[i2][3] = String.valueOf(alt);
                        hoeheGeholt.add(String.valueOf(punkt) + "\t" + alt);
                    }
                }
                ++i2;
            }
            ArrayList<String> parm = new ArrayList<String>();
            int i3 = 0;
            while (i3 < medien.length) {
                FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                if (medien[i3][0].compareTo(org[i3][0]) != 0) {
                    FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][2] + "\t" + org[i3][2] + "\t", 0);
                } else {
                    parm.clear();
                    if (org[i3][3].compareTo(medien[i3][3]) != 0) {
                        parm.add(String.valueOf(namen[3]) + "=" + medien[i3][3]);
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add("-GPSAltitudeRef=above");
                        parm.add(String.valueOf(verz) + medien[i3][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                }
                ++i3;
            }
            FProt.instance().prot(String.valueOf(medium) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
        }
        return anzChangedMedien;
    }

    public static int checkAndMoveScannedFotos(String medium, boolean datumAlsUnterverzeichnis) {
        return FDatei.checkAndMoveScannedFotos(medium, datumAlsUnterverzeichnis, false);
    }

    public static int checkAndMoveScannedFotos(String medium, boolean datumAlsUnterverzeichnis, boolean test) {
        String[][] medien;
        int toMove = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-Filename", "-ScanVerzeichnis", "-DateTimeOriginal", "-Directory", medium};
        String[][] stringArray = medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "JPG"}, namen)), 5), "UTF-8")), namen.length, true));
        int n = medien.length;
        int n2 = 0;
        while (n2 < n) {
            String unterVerzIst;
            String[] element = stringArray[n2];
            String datei = element[0];
            String unterVerzSoll = element[1].isEmpty() ? "" : String.valueOf(element[1]) + (!element[2].isEmpty() && datumAlsUnterverzeichnis ? String.valueOf(System.getProperty("file.separator")) + element[2].substring(0, 10).replace(':', '-') : "");
            String string = unterVerzIst = element[3].length() < verz.length() ? "" : element[3].substring(verz.length());
            if (unterVerzSoll.compareToIgnoreCase(unterVerzIst) != 0) {
                ++toMove;
                FProt.instance().prot(String.valueOf(verz) + datei + ": " + unterVerzIst + " -> " + unterVerzSoll);
                if (!test) {
                    File check = new File(verz, unterVerzSoll);
                    if (!check.exists() && check.mkdirs()) {
                        FProt.instance().prot(String.valueOf(check.toString()) + " wurde erzeugt");
                    }
                    new FFile(String.valueOf(verz) + unterVerzIst, datei).renameTo(String.valueOf(verz) + unterVerzSoll, datei);
                }
            }
            ++n2;
        }
        return toMove;
    }

    public static int checkAndMoveVideoSammlung(String verzIn, boolean ersterBuchstabeAlsQualifier, boolean test, boolean usePrefMsg) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String prefMsg = usePrefMsg ? "FDatei.checkAndMoveVideoSammlung: " : "";
        String[] namen = new String[]{"-Directory", "-Filename", "-ImageWidth", verzIn};
        String[][] medien = FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "MP4"}, namen)), 5), "UTF-8")), namen.length, true);
        int toMove = 0;
        String[] verzArten = new String[]{"3_Klein", "2_Mittel", "1_Gross"};
        int breite = 0;
        String[][] stringArray = medien;
        int n = medien.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            String verzIst = element[0];
            String datei = element[1];
            String verzSoll = verzIst;
            String unterVerzIst = "";
            String unterVerzSoll = "";
            boolean unterVerzIstSammlung = false;
            String[] teile = verzIst.split(System.getProperty("file.separator"));
            if (teile.length > 2) {
                String string = unterVerzIst = ersterBuchstabeAlsQualifier ? String.valueOf(teile[teile.length - 2]) + System.getProperty("file.separator") + teile[teile.length - 1] : teile[teile.length - 1];
                if (FString.findFirstString(verzArten, teile[teile.length - 2], true, true) >= 0) {
                    unterVerzIstSammlung = true;
                    unterVerzIst = String.valueOf(teile[teile.length - 2]) + System.getProperty("file.separator") + teile[teile.length - 1];
                } else if (FString.findFirstString(verzArten, teile[teile.length - 1], true, true) >= 0) {
                    unterVerzIstSammlung = true;
                    unterVerzIst = teile[teile.length - 1];
                }
            }
            try {
                breite = Integer.parseInt(element[2]);
            }
            catch (Exception e) {
                breite = 0;
                FProt.instance().prot(String.valueOf(prefMsg) + verz + "\t" + verzIst + "\t" + datei + "\tbreite\t" + element[2] + "\tBreite nicht feststellbar");
            }
            String verzArt = "";
            if (breite > 0) {
                verzArt = breite < 480 ? verzArten[0] : (breite < 720 ? verzArten[1] : verzArten[2]);
            }
            unterVerzSoll = verzArt.length() == 0 ? "" : String.valueOf(verzArt) + (ersterBuchstabeAlsQualifier ? String.valueOf(System.getProperty("file.separator")) + datei.substring(0, 1).toUpperCase() : "");
            FProt.instance().prot(String.valueOf(prefMsg) + verz + "\t" + verzIst + "\t" + datei + "\tbreite\t" + element[2] + "\tUnterVerzIst:\t" + unterVerzIst + "\tunterVerzIstSammlung:\t" + unterVerzIstSammlung + "\tUnterVerzSoll:\t" + unterVerzSoll, 5);
            if (unterVerzSoll.length() > 0 && unterVerzSoll.compareTo(unterVerzIst) != 0) {
                verzSoll = unterVerzIstSammlung ? String.valueOf(verzIst.substring(0, verzIst.length() - unterVerzIst.length())) + unterVerzSoll : String.valueOf(verzIst) + System.getProperty("file.separator") + unterVerzSoll;
            }
            if (verzSoll.compareToIgnoreCase(verzIst) != 0) {
                ++toMove;
                FProt.instance().prot(String.valueOf(prefMsg) + datei + "\tbreite\t" + element[2] + "\t" + verzIst + "\t=>\t" + verzSoll, test ? 0 : 2);
                if (!test) {
                    File check = new File(verzSoll);
                    if (!check.exists() && check.mkdirs()) {
                        FProt.instance().prot(String.valueOf(check.toString()) + " wurde erzeugt");
                    }
                    FProt.instance().prot(String.valueOf(prefMsg) + datei + " moved from >" + verzIst + "< to >" + verzSoll + "< " + new FFile(verzIst, datei).renameTo(verzSoll, datei));
                }
            }
            ++n2;
        }
        FProt.instance().prot(String.valueOf(prefMsg) + verzIn + ": " + medien.length + " Video" + (medien.length != 1 ? "s" : "") + " vorhanden, " + toMove + " Video" + (toMove != 1 ? "s" : "") + (test ? " zu verschieben" : " verschoben"));
        return toMove;
    }

    public static int checkAndRepairBeschreibungsreferenzen(String verzIn, boolean checkOnly) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-xmp:ImageDescription", "-xmp:Label", "-xmp:Nickname", "-xmp:Scene", "-ImageRef", "-OriginalFileName", "-Filename", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
        ArrayList<String[]> medienOrg = new ArrayList<String[]>();
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[0].isEmpty() && !zeile[5].isEmpty()) {
                    medienOrg.add(zeile);
                    medienToChange.add(FString.copyStringArray(medienAlle.get(i)));
                }
                ++i;
            }
            String[][] org = FString.convertArrayListToTabelle(medienOrg);
            String[][] medien = FString.convertArrayListToTabelle(medienToChange);
            String ref = "";
            String lastDescript = "";
            String descript = "";
            int i2 = 0;
            while (i2 < medien.length) {
                descript = String.valueOf(medien[i2][0]) + "\t" + medien[i2][1] + "\t" + medien[i2][2] + "\t" + medien[i2][3];
                if (descript.compareTo(lastDescript) != 0) {
                    ref = medien[i2][5];
                } else {
                    medien[i2][4] = ref;
                }
                lastDescript = descript;
                ++i2;
            }
            ArrayList<String> parm = new ArrayList<String>();
            int i3 = 0;
            while (i3 < medien.length) {
                FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                if (medien[i3][6].compareTo(org[i3][6]) != 0) {
                    FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][6] + "\t" + org[i3][6] + "\t", 0);
                } else {
                    parm.clear();
                    int j = 4;
                    while (j < 5) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][6] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t") + "\talter Wert von " + namen[4] + ": " + org[i3][4], 0);
                        parm.add(String.valueOf(verz) + medien[i3][6]);
                        if (!checkOnly) {
                            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        }
                        ++anzChangedMedien;
                    }
                }
                ++i3;
            }
            FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienOrg.size() + " relevanten Medien, " + anzChangedMedien + (checkOnly ? " zu aendernde" : " geaenderte") + " Medien");
        }
        return anzChangedMedien;
    }

    public static int checkAndSetBeschreibungsreferenzen(String verzIn) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-Filename", "-OriginalFileName", "-ImageRef", "-xmp:ImageDescription", "-xmp:Label", "-xmp:Nickname", "-xmp:Scene", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        ArrayList<String[]> medienOrg = new ArrayList<String[]>();
        ArrayList<String[]> medienReferenz = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (zeile[2].isEmpty()) {
                    if (!zeile[3].isEmpty()) {
                        medienReferenz.add(zeile);
                    }
                } else {
                    medienToChange.add(zeile);
                    medienOrg.add(FString.copyStringArray(medienAlle.get(i)));
                }
                ++i;
            }
            String[][] medien = FString.convertArrayListToTabelle(medienToChange);
            String[][] org = FString.convertArrayListToTabelle(medienOrg);
            String[][] referenz = FString.convertArrayListToTabelle(medienReferenz);
            int posRef = -1;
            int i2 = 0;
            while (i2 < medien.length) {
                posRef = FString.findFirstString(referenz, 1, medien[i2][2], true, true);
                if (posRef < 0) {
                    FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + medien[i2][2] + "\tReferenz nicht gefunden", 0);
                } else {
                    int j = 3;
                    while (j < medien[i2].length) {
                        medien[i2][j] = referenz[posRef][j];
                        ++j;
                    }
                }
                ++i2;
            }
            ArrayList<String> parm = new ArrayList<String>();
            int i3 = 0;
            while (i3 < medien.length) {
                FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                if (medien[i3][0].compareTo(org[i3][0]) != 0) {
                    FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][2] + "\t" + org[i3][2] + "\t", 0);
                } else {
                    parm.clear();
                    int j = 3;
                    while (j < medien[i3].length) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                }
                ++i3;
            }
            FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
        }
        return anzChangedMedien;
    }

    public static int checkAndSetGeonamen(String medium, boolean overwrite) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-Filename", "-OriginalFileName", "-GPSAreaInformation", "-xmp:CountryCode", "-xmp:Country", "-xmp:State", "-xmp:City", "-xmp:Location", "-GPSLatitude", "-GPSLongitude", "-GPSAltitude#", "-XMP:Subject", medium};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        ArrayList<String[]> medienOrg = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(medium) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!(zeile[8].isEmpty() || zeile[9].isEmpty() || !zeile[2].isEmpty() && medienAlle.size() != 1)) {
                    boolean koordinatenOK = true;
                    int j = 8;
                    while (j < 10) {
                        try {
                            Double.parseDouble(zeile[j]);
                        }
                        catch (Exception e) {
                            koordinatenOK = false;
                        }
                        ++j;
                    }
                    if (koordinatenOK) {
                        medienToChange.add(zeile);
                        medienOrg.add(FString.copyStringArray(medienAlle.get(i)));
                    }
                }
                ++i;
            }
            String[][] medien = FString.convertArrayListToTabelle(medienToChange);
            String[][] org = FString.convertArrayListToTabelle(medienOrg);
            int i2 = 0;
            while (i2 < medien.length) {
                String[] geonamen = Futi.getGeoDataOnline(Double.parseDouble(medien[i2][8]), Double.parseDouble(medien[i2][9]), 1.0, String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Java" + System.getProperty("file.separator") + "GPS" + System.getProperty("file.separator") + "geonames.sqlite", 'A');
                medien[i2][3] = overwrite || medien[i2][3].length() == 0 ? geonamen[0] : medien[i2][3];
                medien[i2][4] = overwrite || medien[i2][4].length() == 0 ? geonamen[1] : medien[i2][4];
                medien[i2][5] = overwrite || medien[i2][5].length() == 0 ? geonamen[2] : medien[i2][5];
                medien[i2][6] = overwrite || medien[i2][6].length() == 0 ? geonamen[5] : medien[i2][6];
                medien[i2][7] = overwrite || medien[i2][7].length() == 0 ? geonamen[6] : medien[i2][7];
                medien[i2][7] = medien[i2][7].compareTo(medien[i2][6]) == 0 ? "" : medien[i2][7];
                medien[i2][10] = overwrite || medien[i2][10].length() == 0 ? geonamen[7] : medien[i2][10];
                medien[i2][11] = FString.stringArrayToString(geonamen, " ", true);
                ++i2;
            }
            ArrayList<String> parm = new ArrayList<String>();
            int i3 = 0;
            while (i3 < medien.length) {
                FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                if (medien[i3][0].compareTo(org[i3][0]) != 0) {
                    FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][2] + "\t" + org[i3][2] + "\t", 0);
                } else {
                    parm.clear();
                    int j = 3;
                    while (j < medien[i3].length) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                }
                ++i3;
            }
            FProt.instance().prot(String.valueOf(medium) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
        }
        return anzChangedMedien;
    }

    public static int checkAndSetOrtsreferenzen(String verzIn, boolean ohneHoehe) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-Filename", "-OriginalFileName", "-GPSAreaInformation", "-xmp:CountryCode", "-xmp:Country", "-xmp:State", "-xmp:City", "-xmp:Location", ohneHoehe ? "" : "-GPSAltitude#", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        ArrayList<String[]> medienOrg = new ArrayList<String[]>();
        ArrayList<String[]> medienReferenz = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (zeile[2].isEmpty()) {
                    if (!(zeile[3].isEmpty() || zeile[4].isEmpty() || zeile[5].isEmpty() || zeile[6].isEmpty())) {
                        medienReferenz.add(zeile);
                    }
                } else {
                    medienToChange.add(zeile);
                    medienOrg.add(FString.copyStringArray(medienAlle.get(i)));
                }
                ++i;
            }
            String[][] medien = FString.convertArrayListToTabelle(medienToChange);
            String[][] org = FString.convertArrayListToTabelle(medienOrg);
            String[][] referenz = FString.convertArrayListToTabelle(medienReferenz);
            int posRef = -1;
            int i2 = 0;
            while (i2 < medien.length) {
                posRef = FString.findFirstString(referenz, 1, medien[i2][2], true, true);
                if (posRef < 0) {
                    FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + medien[i2][2] + "\tReferenz nicht gefunden", 0);
                } else {
                    int j = 3;
                    while (j < medien[i2].length) {
                        medien[i2][j] = referenz[posRef][j];
                        ++j;
                    }
                }
                ++i2;
            }
            ArrayList<String> parm = new ArrayList<String>();
            int i3 = 0;
            while (i3 < medien.length) {
                FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                if (medien[i3][0].compareTo(org[i3][0]) != 0) {
                    FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][2] + "\t" + org[i3][2] + "\t", 0);
                } else {
                    parm.clear();
                    int j = 3;
                    while (j < medien[i3].length) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                }
                ++i3;
            }
            FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
        }
        return anzChangedMedien;
    }

    public static int checkAndSetVideoSammlung(String medium, boolean extractCoverArt) {
        int anzChangedMedien = 0;
        String[] namen = new String[]{"-Filename", "-Album", "-Artist", "-Description", "-xmp:ImageDescription", "-exif:ImageDescription", "-SeriesDescription", "-Comment", "-Logcomment", "-Comment-eng", "-Composer", "-Compilation", "-Copyright", "-Title", "-Directory", medium};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "MP4"}, namen)), 5), "UTF-8")), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            DateinamenTeile name = FDatei.instance().zerlegeDateiname(medien[i][0], "_");
            medien[i][1] = name.getBaseBis_EndeBaseIgnorierenAbUndNummerisch().replaceAll("_", " ");
            medien[i][2] = medien[i][1];
            int j = 3;
            while (j < 14) {
                medien[i][j] = "";
                ++j;
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            String dateiname = String.valueOf(FDatei.checkFileSeperator(medien[i2][14], true)) + medien[i2][0];
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 1;
                while (j < medien[i2].length) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot("Change " + dateiname + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                    parm.add(dateiname);
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                    ++anzChangedMedien;
                } else {
                    FProt.instance().prot("Metadaten korrekt, Update nicht erforderlich\t" + dateiname, 0);
                }
                FDatei.makeThumbnail(dateiname);
                if (extractCoverArt) {
                    FDatei.extraktCoverArtOrUnknownThumbnail(dateiname, 'c', String.valueOf(FDatei.checkFileSeperator(medien[i2][14], true)) + "_Poster");
                }
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Video" + (medien.length != 1 ? "s" : "") + ", " + anzChangedMedien + " geaenderte Video" + (anzChangedMedien != 1 ? "s" : ""));
        return anzChangedMedien;
    }

    public static int checkAndSetVideoTitleAndDescription(String medium) {
        int anzChangedMedien = 0;
        String[] namen = new String[]{"-Filename", "-Description", "-Title", "-Quicktime:Information", "-Quicktime:Comment", "-xmp:logcomment", "-BaseUrl", "-Basename", "-Directory", medium};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "MP4"}, namen)), 5), "UTF-8")), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            String kommentar;
            if (medien[i][1].compareTo("(null)") == 0) {
                medien[i][1] = "";
            }
            if (!(kommentar = FString.convertUmlaute(FDatei.getAppleKommentar(String.valueOf(FDatei.checkFileSeperator(medien[i][2], true)) + medien[i][0]))).isEmpty()) {
                medien[i][1] = kommentar;
            }
            medien[i][2] = medien[i][7];
            if (medien[i][4].startsWith("CoverArt=Poster by Johann Fischer_")) {
                medien[i][5] = medien[i][4];
                medien[i][4] = "";
            }
            medien[i][3] = (String.valueOf(Futi.ersetzeUmlaute(medien[i][1], true, 0, "().,\"'", ' ')) + (medien[i][6].length() < 10 ? "" : String.valueOf(medien[i][1].isEmpty() ? "" : " url: ") + medien[i][6])).trim();
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            String dateiname = String.valueOf(FDatei.checkFileSeperator(medien[i2][8], true)) + medien[i2][0];
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 1;
                while (j < 6) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot("Change " + dateiname + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                    parm.add(dateiname);
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                    ++anzChangedMedien;
                } else {
                    FProt.instance().prot("Description und Title korrekt, Update nicht erforderlich\t" + dateiname, 0);
                }
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Video" + (medien.length != 1 ? "s" : "") + ", " + anzChangedMedien + " geaenderte Video" + (anzChangedMedien != 1 ? "s" : ""));
        return anzChangedMedien;
    }

    public static String checkDatei(String DateiEin, char Art, char Check, String Bedeutung) {
        return FDatei.checkDatei(DateiEin, Art, Check, Bedeutung, false, false, null);
    }

    public static String checkDatei(String DateiEin, char Art, char Check, String Bedeutung, boolean keineVerzeichnisstrukturAnlegen) {
        return FDatei.checkDatei(DateiEin, Art, Check, Bedeutung, false, keineVerzeichnisstrukturAnlegen, null);
    }

    public static String checkDatei(String DateiEin, char Art, char Check, String Bedeutung, boolean exitBeiFehler, boolean keineVerzeichnisstrukturAnlegen, Component ParentObject) {
        String DateiAus = "";
        if (DateiEin != null && DateiEin.length() > 0) {
            DateiAus = DateiEin.replace('/', System.getProperty("file.separator").charAt(0));
            File Test = new File(DateiAus);
            try {
                DateiAus = Test.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Art == 'V' && !DateiAus.endsWith(System.getProperty("file.separator"))) {
                DateiAus = String.valueOf(DateiAus) + System.getProperty("file.separator").charAt(0);
            }
            block1 : switch (Check) {
                case 'R': 
                case 'r': {
                    if (!Test.canRead()) {
                        DateiAus = "";
                        FDatei.checkDateiMessage(String.valueOf(Bedeutung) + " >" + DateiEin + "< kann nicht gelesen werden!", exitBeiFehler, ParentObject);
                        break;
                    }
                    switch (Art) {
                        case 'D': 
                        case 'd': {
                            if (Test.isFile()) break block1;
                            DateiAus = "";
                            FDatei.checkDateiMessage(String.valueOf(Bedeutung) + " >" + DateiEin + "< ist keine Datei!", exitBeiFehler, ParentObject);
                            break block1;
                        }
                        case 'V': 
                        case 'v': {
                            if (Test.isDirectory()) break block1;
                            DateiAus = "";
                            FDatei.checkDateiMessage(String.valueOf(Bedeutung) + " >" + DateiEin + "< ist kein Verzeichnis!", exitBeiFehler, ParentObject);
                            break block1;
                        }
                        case 'F': 
                        case 'f': {
                            if (!Test.isFile() || !Test.isDirectory()) break block1;
                            DateiAus = "";
                            FDatei.checkDateiMessage(String.valueOf(Bedeutung) + " >" + DateiEin + "< ist keine Datei und kein Verzeichnis!", exitBeiFehler, ParentObject);
                            break block1;
                        }
                    }
                    break;
                }
                case 'W': 
                case 'w': {
                    File Work;
                    if (DateiAus.indexOf(58) + DateiAus.indexOf(42) + DateiAus.indexOf(63) + DateiAus.indexOf(34) + DateiAus.indexOf(60) + DateiAus.indexOf(62) + DateiAus.indexOf(124) >= 0 || DateiEin.length() == 0) {
                        DateiAus = "";
                        FDatei.checkDateiMessage(String.valueOf(Bedeutung) + " >" + DateiEin + "< kann nicht geschrieben werden, ungueltiger Dateiname!", exitBeiFehler, ParentObject);
                        break;
                    }
                    if (Test.exists() || (Work = Art == 'D' ? new File(FDatei.instance().zerlegeDateiname(DateiAus).getPfad()) : new File(DateiEin)).exists() || keineVerzeichnisstrukturAnlegen) break;
                    if (Work.mkdirs()) {
                        FDatei.checkDateiMessage("Verzeichnisstruktur fuer >" + DateiEin + "< komplettiert!", exitBeiFehler, ParentObject);
                        break;
                    }
                    FDatei.checkDateiMessage("File >" + DateiEin + "< nicht vorhanden und nicht zu erstellen!", exitBeiFehler, ParentObject);
                    DateiAus = "";
                    break;
                }
            }
        }
        return DateiAus;
    }

    public static String checkDatei(String DateiEin, char Art, char Check, String Bedeutung, boolean exitBeiFehler, Component ParentObject) {
        return FDatei.checkDatei(DateiEin, Art, Check, Bedeutung, exitBeiFehler, false, ParentObject);
    }

    public static String checkDatei(String DateiEin, char Art, char Check, String Bedeutung, Component ParentObject) {
        return FDatei.checkDatei(DateiEin, Art, Check, Bedeutung, false, false, ParentObject);
    }

    public static void checkDateiMessage(String message, boolean exitBeiFehler, Component ParentObject) {
        FProt fProt = FProt.instance();
        if (ParentObject == null) {
            fProt.prot(message, FDatei.getMsgLevelMedien());
            if (exitBeiFehler) {
                System.exit(0);
            }
        } else {
            JOptionPane.showMessageDialog(ParentObject, message, "Fehler", 0);
        }
    }

    public static String checkFileSeperator(String pfad, boolean letzte_Stelle_FileSeparator) {
        String Ausgabe = pfad;
        if (pfad.indexOf(".") >= 0) {
            File Work = new File(pfad);
            try {
                Ausgabe = Work.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Ausgabe.endsWith(System.getProperty("file.separator")) && letzte_Stelle_FileSeparator) {
            Ausgabe = String.valueOf(Ausgabe) + System.getProperty("file.separator");
        }
        if (Ausgabe.endsWith(System.getProperty("file.separator")) && !letzte_Stelle_FileSeparator) {
            Ausgabe = Ausgabe.substring(0, pfad.length() - 1);
        }
        return Ausgabe;
    }

    public static void checkKoordinaten(String medienVerzeichnis) {
        FFile dir = new FFile(medienVerzeichnis);
        FProt fProt = FProt.instance();
        String[] verz = dir.listFileNames('V', true);
        String[][] fotos = new String[][]{{""}};
        boolean verzValid = false;
        String dateiName = "";
        String dirName = "";
        String latitudeIst = "";
        String latitudeSoll = "";
        double latitudeMin = 38.0;
        double latitudeMax = 67.0;
        String longitudeIst = "";
        String longitudeSoll = "";
        double longitudeMin = -7.0;
        double longitudeMax = 22.0;
        boolean etwasGeaendertVerzeichnis = false;
        boolean etwasGeaendertGesamt = false;
        if (verz.length == 0) {
            fProt.prot(String.valueOf(medienVerzeichnis) + " hat keine Unterverzeichnisse");
        } else {
            String[] stringArray = verz;
            int n = verz.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                verzValid = false;
                double latitude = -999.0;
                double longitude = -999.0;
                String[] teile = FDatei.instance().zerlegeDateiname(element).getNamePlusExtend().split("=");
                if (teile.length > 1) {
                    try {
                        latitude = Double.parseDouble(teile[0]);
                        longitude = Double.parseDouble(teile[1]);
                        if (FMath.checkRange(latitude, 38.0, 67.0) == latitude && FMath.checkRange(longitude, -7.0, 22.0) == longitude) {
                            latitudeSoll = String.valueOf(latitude);
                            longitudeSoll = String.valueOf(longitude);
                            verzValid = true;
                        }
                    }
                    catch (Exception e) {
                        verzValid = false;
                    }
                }
                if (!verzValid) {
                    fProt.prot(String.valueOf(element) + " hat keine gueltigen Koordinaten");
                } else {
                    dirName = dir.getAbsoluteFile() + System.getProperty("file.separator") + element;
                    fotos = FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-c", "%+.8g", "-ext", "JPG", "-FileName", "-GPSLatitude", "-GPSLongitude", "-T", dirName})), true, true), 3, true);
                    if (fotos.length == 0) {
                        fProt.prot(String.valueOf(element) + " enthaelt keine Fotos");
                    } else {
                        fProt.prot(String.valueOf(element) + " enthaelt " + fotos.length + "Foto" + (fotos.length > 1 ? "s" : ""));
                        etwasGeaendertVerzeichnis = false;
                        String[][] stringArrayArray = fotos;
                        int n3 = fotos.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            double nullenWeg;
                            String[] foto = stringArrayArray[n4];
                            dateiName = foto[0];
                            try {
                                nullenWeg = Double.parseDouble(foto[1]);
                                latitudeIst = String.valueOf(nullenWeg);
                            }
                            catch (NumberFormatException e) {
                                latitudeIst = foto[1];
                            }
                            try {
                                nullenWeg = Double.parseDouble(foto[2]);
                                longitudeIst = String.valueOf(nullenWeg);
                            }
                            catch (NumberFormatException e) {
                                longitudeIst = foto[2];
                            }
                            if (latitudeIst.compareTo(latitudeSoll) != 0 || longitudeIst.compareTo(longitudeSoll) != 0) {
                                fProt.prot(" " + dateiName + " " + latitudeIst + ":" + longitudeIst + " => " + latitudeSoll + ":" + longitudeSoll);
                                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-G", "-GPSLatitude=" + latitudeSoll, "-GPSLongitude=" + longitudeSoll, longitudeSoll.startsWith("-") ? "-GPSLongitudeRef=W" : "", "-GPSDateStamp=" + Futi.getZeit('E'), "-GPSTimeStamp=" + Futi.getZeit('Y'), String.valueOf(dirName) + System.getProperty("file.separator") + dateiName}), 5);
                                etwasGeaendertVerzeichnis = true;
                            } else {
                                fProt.prot(" " + dateiName + " " + latitudeIst + ":" + longitudeIst + " korrekt", 2);
                            }
                            ++n4;
                        }
                        if (etwasGeaendertVerzeichnis) {
                            etwasGeaendertGesamt = true;
                        } else {
                            fProt.prot("keine Changes in " + element + " notwendig");
                        }
                    }
                }
                ++n2;
            }
            if (!etwasGeaendertGesamt) {
                fProt.prot("Insgesamt keine Changes notwendig");
            }
        }
    }

    public static int checkMetadaten(String medium, boolean nurSumme) {
        int anzNichtKomplettMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-FileName", "-OriginalFileName", "-PreviewImageCount", "-xmp:ImageDescription", "-xmp:CountryCode", "-xmp:Country", "-xmp:State", "-xmp:City", "-GPSAltitude", "-GPSLatitude", "-GPSLongitude", "-Artist", "-Copyright", "-Make", "-Model", "-SerialNumber", "-XMP:Album", "-XMP:StartingPage", "-XMP:EndingPage", medium};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), true, true), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            int j = 0;
            while (j < namen.length - 1) {
                if (medien[i][j].isEmpty() && (medien[i][16].compareTo("DownloadFromWeb") != 0 && medien[i][16].compareTo("Screenshot") != 0 || j < 12 || j > 15)) {
                    medien[i][j] = "fehlt";
                }
                ++j;
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 1;
                while (j < medien[i2].length) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(namen[j].substring(1));
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot(String.valueOf(medien[i2][0]) + " " + (parm.size() == 1 ? "Fehlt" : "Fehlen") + " : " + FString.stringArrayToString(FString.arrayListToStringArray(parm), ", "), nurSumme ? 5 : 0);
                    parm.add(String.valueOf(verz) + medien[i2][0]);
                    ++anzNichtKomplettMedien;
                }
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Medien, " + (medien.length - anzNichtKomplettMedien) + " Medien komplett" + (anzNichtKomplettMedien > 0 ? ", " + anzNichtKomplettMedien + " Medien nicht komplett" : ""));
        return anzNichtKomplettMedien;
    }

    public static boolean checkSortierungUndDateTimeOriginal(String verz, boolean mitDetails) {
        String[][] tab = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-Basename", "-DateTimeOriginal", verz}), 5), "UTF-8")), 2, true));
        String lastDateTimeOriginal = "";
        boolean sortFehler = false;
        String[][] stringArray = tab;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            if (!element[0].startsWith("aaa_")) {
                if (element[1].compareTo(lastDateTimeOriginal) < 0) {
                    FProt.instance().prot(String.valueOf(verz) + ": \t" + element[0] + "\t" + element[1] + "\t < \t" + lastDateTimeOriginal, mitDetails ? 0 : 2);
                    sortFehler = true;
                }
                lastDateTimeOriginal = element[1];
            }
            ++n2;
        }
        return sortFehler;
    }

    public static boolean checkSymbolicLink(String dateiname, boolean deleteIfBroken) {
        boolean ok = false;
        try {
            Path candidate = Paths.get(dateiname, new String[0]);
            if (Files.isSymbolicLink(candidate)) {
                ok = true;
                Path original = Files.readSymbolicLink(candidate);
                if (!Files.exists(original, new LinkOption[0])) {
                    FProt.instance().prot("Check SymbolicLink: '" + dateiname + "' -> '" + original.getFileName() + "' Ziel nicht vorhanden", 0);
                    if (deleteIfBroken) {
                        Files.delete(candidate);
                        FProt.instance().prot("Check SymbolicLink: '" + dateiname + "' -> '" + original.getFileName() + "' Ziel nicht vorhanden, SymbolicLink geloescht", 0);
                    }
                    ok = false;
                } else {
                    FProt.instance().prot("Check SymbolicLink: '" + dateiname + "' -> '" + original.getFileName() + "' konstistent", 0);
                }
            } else {
                FProt.instance().prot("Check SymbolicLink: '" + dateiname + "' ist kein SymbolicLink", 0);
            }
        }
        catch (IOException ex) {
            FProt.instance().prot("Fehler bei Check SymbolicLink: '" + dateiname + "' :" + ex.toString().split(":")[0]);
            ok = false;
        }
        catch (UnsupportedOperationException x) {
            FProt.instance().prot(x.toString());
            ok = false;
        }
        return ok;
    }

    public static void checkVideoRotationAndCreateDate(String videoName) {
        FFile video = new FFile(videoName);
        if (video.isVideo()) {
            String[] teile;
            int rotation = 0;
            String CreateDate = "";
            String CreationDate = "";
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Rotation", "-CreateDate", "-CreationDate", "-T", video.getAbsolutePath()}), FDatei.getMsgLevelMedien());
            if (tags.length > 0 && tags[0].length() > 0 && (teile = tags[0].split("\t")).length > 2) {
                try {
                    rotation = Integer.parseInt(teile[0]);
                    CreateDate = teile[1];
                    CreationDate = teile[2];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rotation != 0 || CreateDate.compareTo(CreationDate) != 0) {
                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{rotation != 0 ? "-Rotation=0" : "", CreateDate.compareTo(CreationDate) != 0 ? "-CreateDate<CreationDate" : "", video.getAbsolutePath()}), FDatei.getMsgLevelMedien());
                FDatei.makeThumbnail(video.getAbsolutePath(), 999);
            }
        }
    }

    static String[] clearTags(String[] tags) {
        int i = 0;
        while (i < tags.length) {
            tags[i] = tags[i].compareTo("-") == 0 ? "" : tags[i];
            ++i;
        }
        return tags;
    }

    public static String[][] clearTags(String[][] tags) {
        int i = 0;
        while (i < tags.length) {
            int j = 0;
            while (j < tags[i].length) {
                tags[i][j] = tags[i][j].compareTo("-") == 0 ? "" : tags[i][j];
                ++j;
            }
            ++i;
        }
        return tags;
    }

    public static boolean compactImage(String dateiname, int densityIn, String relVerzOutput, boolean overwriteOriginalIn, boolean test) {
        boolean overwriteOriginal;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(1);
        NumberFormat gnf = NumberFormat.getInstance();
        gnf.setGroupingUsed(true);
        float einsparungMinimum = 10.0f;
        boolean resizeToDo = false;
        FFile medium = new FFile(dateiname);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (medium.isPicture()) {
            int density = FMath.checkRange(densityIn, 72, 150);
            long filesizeIst = medium.length();
            int[] dimension = FDatei.getImageDimension(medium.getAbsolutePath());
            long filesizeSoll = FDatei.getImageOptimalFilesize(dimension[0], dimension[1]);
            float einsparung = (1.0f - (float)filesizeSoll * 1.0f / (float)filesizeIst) * 100.0f;
            if (einsparung <= 0.0f) {
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " nicht " + (test ? " zu veraendern" : "veraendert") + ": " + nf.format(einsparung) + " Prozent Einsparung, d.h. keine Einsaprung", test ? 2 : 0);
            } else if (einsparung <= 10.0f) {
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " nicht " + (test ? " zu veraendern" : "veraendert") + ": " + nf.format(einsparung) + " Prozent Einsparung moeglich, weniger als Minimaleinsparung von " + nf.format(10.0) + "%", test ? 2 : 0);
            } else if (test) {
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf Groesse " + gnf.format(filesizeSoll / 1024L) + "KB zu aendern: " + nf.format(einsparung) + " Prozent einzusparen");
            } else {
                FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_jpg_compact" : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
                FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto Komapkt");
                output.deleteIfExits();
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), "-density", String.valueOf(density), " -define", "jpeg:extent=" + filesizeSoll / 1024L + "KB", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FDatei.setImageQuality2Exif(output.getAbsolutePath(), true);
                filesizeSoll = output.length();
                einsparung = (1.0f - (float)output.length() * 1.0f / (float)filesizeIst) * 100.0f;
                if (overwriteOriginal && einsparung > 10.0f) {
                    medium.delete();
                    output.renameTo(dateiname);
                    FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf Groesse " + gnf.format(filesizeSoll / 1024L) + "KB geaendert: " + nf.format(einsparung) + " Prozent eingespart");
                } else if (einsparung > 10.0f) {
                    FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf Groesse " + gnf.format(filesizeSoll / 1024L) + "KB geaendert: " + nf.format(einsparung) + " Prozent eingespart, geaenderte Datei: " + output.getAbsolutePath());
                } else {
                    output.delete();
                    FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf Groesse " + gnf.format(filesizeSoll / 1024L) + "KB geaendert: " + nf.format(einsparung) + " Prozent eingespart, weniger als Minimaleinsparung von " + nf.format(10.0) + " density, Foto nicht veraendert");
                }
            }
        } else {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Foto", test ? 2 : 0);
        }
        return false;
    }

    public static void compactImage(String dateiname, String relVerzOutput, boolean overwriteOriginalIn, boolean test) {
        FDatei.compactImage(dateiname, 72, relVerzOutput, overwriteOriginalIn, test);
    }

    public static int completeJFiMetadaten(String verz, boolean nurTest, boolean keinProtokoll) {
        String[] element;
        int anzChangedMedien = 0;
        String[] namen = new String[]{"-Filename", "-Scene", "-Artist", "-Copyright", "-ProcessingSoftware", "-GPSAltitude#", "-City", "-Location", "-TextOnImage", "-DateTimeOriginal", "-DatePrecision", "-DateFormatiert", "-IPTCDigest", "-EXIF:ImageDescription", "-XMP:ImageDescription", "-Album", "-StartingPage", "-EndingPage", "-PreSelectedTitle", "-MIMEType", "-XMP:CountryCode", "-XMP:Country", "-Directory", verz};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "GIF", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        String[][] scene = new String[][]{{"a", "Architektur"}, {"c", "Technik"}, {"g", "sonstiges"}, {"k", "Kunst und Kultur"}, {"l", "Landschaft"}, {"m", "Menschen"}, {"n", "Natur"}, {"s", "Sport"}, {"t", "Tiere"}, {"b", "Berge"}};
        String[][] artistCopyright = new String[][]{{"j", "Johann Fischer, Neusaess"}, {"h", "Johann Fischer, Neusaess"}, {"g", "Gerlinde Fischer, Neusaess"}};
        String[][] textOnImage = new String[][]{{"r", "Reisebericht"}, {"hk", "HoeheStattKuenstler"}, {"hr", "HoeheStattRechte"}, {"z", "ArtistUndZeit"}, {"n", "nurBeschreibung"}, {"b", "BeschreibungUnterBild"}, {"a", "alles"}, {"e", "allesMitErweiterung"}, {"k", "nichts"}};
        String album = "";
        String startingPage = "";
        String endingPage = "";
        boolean albumEindeutig = false;
        boolean startingPageEindeutig = false;
        boolean endingPageEindeutig = false;
        int anzahlTitelMarkiert = 0;
        String ersteTitelbild = "";
        String[][] stringArray = medien;
        int n = medien.length;
        int n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            if (!element[15].isEmpty()) {
                if (album.isEmpty()) {
                    album = element[15];
                    albumEindeutig = true;
                } else {
                    boolean bl = albumEindeutig = album.compareTo(element[15]) == 0;
                    if (!albumEindeutig) {
                        FProt.instance().prot("Album unterschiedlich: " + element[22] + System.getProperty("file.separator") + element[0] + " hat: " + element[15] + ", bis hierher: " + album);
                        break;
                    }
                }
            }
            ++n2;
        }
        stringArray = medien;
        n = medien.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            if (!element[16].isEmpty()) {
                if (startingPage.isEmpty()) {
                    startingPage = element[16];
                    startingPageEindeutig = true;
                } else {
                    boolean bl = startingPageEindeutig = startingPage.compareTo(element[16]) == 0;
                    if (!startingPageEindeutig) {
                        FProt.instance().prot("StartingPage unterschiedlich: " + element[22] + System.getProperty("file.separator") + element[0] + " hat: " + element[16] + ", bis hierher: " + startingPage);
                        break;
                    }
                }
            }
            ++n2;
        }
        stringArray = medien;
        n = medien.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            if (!element[17].isEmpty()) {
                if (endingPage.isEmpty()) {
                    endingPage = element[17];
                    endingPageEindeutig = true;
                } else {
                    boolean bl = endingPageEindeutig = endingPage.compareTo(element[17]) == 0;
                    if (!endingPageEindeutig) {
                        FProt.instance().prot("EndingPage unterschiedlich: " + element[22] + System.getProperty("file.separator") + element[0] + " hat: " + element[17] + ", bis hierher: " + endingPage);
                        break;
                    }
                }
            }
            ++n2;
        }
        stringArray = medien;
        n = medien.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            if (!element[18].isEmpty()) {
                if (anzahlTitelMarkiert == 0) {
                    ersteTitelbild = element[0];
                    ++anzahlTitelMarkiert;
                    if (!keinProtokoll) {
                        FProt.instance().prot(String.valueOf(element[22]) + ": Titelbild ist " + element[0]);
                    }
                } else {
                    if (!ersteTitelbild.endsWith(element[0])) {
                        ++anzahlTitelMarkiert;
                    }
                    if (!keinProtokoll) {
                        FProt.instance().prot(String.valueOf(element[22]) + ": " + (ersteTitelbild.endsWith(element[0]) ? String.valueOf(element[0]) + " ist Ursprung des Titelbildes " + ersteTitelbild : " Titelbild ist " + element[0]));
                    }
                }
            }
            ++n2;
        }
        if (medien.length > 0) {
            if (anzahlTitelMarkiert == 0) {
                FProt.instance().prot(String.valueOf(medien[0][22]) + ": kein Titelbild markiert!!!");
            } else if (anzahlTitelMarkiert > 1) {
                FProt.instance().prot(String.valueOf(medien[0][22]) + ": " + anzahlTitelMarkiert + " Titelbilder markiert!!!");
            }
        }
        int i = 0;
        while (i < medien.length) {
            int pos = FString.findFirstString(scene, 0, medien[i][1], true, true);
            if (pos >= 0) {
                medien[i][1] = scene[pos][1];
            }
            if ((pos = FString.findFirstString(artistCopyright, 0, medien[i][2], true, true)) >= 0) {
                medien[i][2] = artistCopyright[pos][1];
            }
            if ((pos = FString.findFirstString(artistCopyright, 0, medien[i][3], true, true)) >= 0) {
                medien[i][3] = artistCopyright[pos][1];
            }
            if (!(medien[i][19].startsWith("video") || medien[i][19].compareTo("image/gif") == 0 || !medien[i][4].isEmpty() && medien[i][4].startsWith("Exiftool, Imagemagick,"))) {
                medien[i][4] = "Exiftool, Imagemagick, Sqlite, de.nss.jfi.ExifMedien.class, de.nss.jfi.RenameMedien.class und de.nss.jfi.GPS.class in jfi.jar";
            }
            if (medien[i][19].compareTo("video/mp4") != 0) {
                try {
                    medien[i][5] = "" + Math.round(Double.parseDouble(medien[i][5]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (medien[i][7].compareToIgnoreCase(medien[i][6]) == 0) {
                medien[i][7] = "";
            }
            if (!medien[i][19].startsWith("video") && medien[i][19].compareTo("image/gif") != 0) {
                pos = FString.findFirstString(textOnImage, 0, medien[i][8], true, true);
                if (pos >= 0) {
                    medien[i][8] = textOnImage[pos][1];
                }
                if (!medien[i][10].isEmpty()) {
                    if (medien[i][10].length() > 1) {
                        medien[i][10] = "";
                    } else if ("123456".indexOf(medien[i][10]) < 0) {
                        medien[i][10] = "";
                    }
                }
            }
            if (!medien[i][19].startsWith("video") && medien[i][19].compareTo("image/gif") != 0 && !medien[i][9].isEmpty()) {
                FGregorianCalendar datum = new FGregorianCalendar();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                try {
                    datum.setTime(dateFormat.parse(medien[i][9]));
                    medien[i][11] = datum.toGermanFormat((String.valueOf(medien[i][10]) + "0").charAt(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!medien[i][12].isEmpty()) {
                medien[i][12] = "";
            }
            if (medien[i][13].length() < 3) {
                medien[i][13] = "";
            }
            if (medien[i][14].length() < 3) {
                medien[i][14] = "";
            }
            if (!medien[i][13].isEmpty()) {
                if (medien[i][13].compareTo(medien[i][14]) == 0) {
                    medien[i][13] = "";
                } else if (medien[i][14].isEmpty()) {
                    medien[i][14] = medien[i][13];
                    medien[i][13] = "";
                } else {
                    FProt.instance().prot("Error in Zeile\t" + (i + 1) + "\t" + medien[i][22] + System.getProperty("file.separator") + medien[i][0] + "\tEXIF:ImageDescription" + "\t" + medien[i][13] + "\tXMP:ImageDescription" + "\t" + medien[i][14], 0);
                }
            }
            if (medien[i][15].isEmpty() && !album.isEmpty() && albumEindeutig) {
                medien[i][15] = album;
            }
            if (medien[i][16].isEmpty() && !startingPage.isEmpty() && startingPageEindeutig) {
                medien[i][16] = startingPage;
            }
            if (medien[i][17].isEmpty() && !endingPage.isEmpty() && endingPageEindeutig) {
                medien[i][17] = endingPage;
            }
            if ((pos = FString.findFirstString(CountryCodes, 0, medien[i][20], false, true)) >= 0) {
                medien[i][21] = CountryCodes[pos][1];
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + (i2 + 1) + "\t" + medien[i2][22] + System.getProperty("file.separator") + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 1;
                while (j < medien[i2].length) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot(String.valueOf(nurTest ? "To change" : "Change") + " " + medien[i2][22] + System.getProperty("file.separator") + medien[i2][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                    if (!nurTest) {
                        parm.add(String.valueOf(medien[i2][22]) + System.getProperty("file.separator") + medien[i2][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                    }
                    ++anzChangedMedien;
                }
            }
            ++i2;
        }
        if (!keinProtokoll) {
            FProt.instance().prot(String.valueOf(verz) + ": " + medien.length + " Medien, " + anzChangedMedien + " " + (nurTest ? "zu aendernde" : "geaenderte") + " Medien");
        }
        return anzChangedMedien;
    }

    public static void copyAuswahl(String OrgIn, String AuswIn) {
        FDatei.copyAuswahl(OrgIn, AuswIn, new File(OrgIn, "Auswahl.txt").getAbsolutePath(), false);
    }

    public static void copyAuswahl(String OrgIn, String AuswIn, boolean nurTest) {
        FDatei.copyAuswahl(OrgIn, AuswIn, new File(OrgIn, "Auswahl.txt").getAbsolutePath(), nurTest);
    }

    public static void copyAuswahl(String org, String auswIn, String dateiMitAuswahlNamen, boolean nurTest) {
        String[] auswahl = new FFile(dateiMitAuswahlNamen).inhaltToStringArray();
        if (auswahl.length == 0) {
            FProt.instance().prot("keine Namen in " + dateiMitAuswahlNamen + " oder Datei nicht vorhanden");
        } else {
            String[] namen = new String[]{"-Filename", "-Directory", "-OriginalFileName"};
            String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "JPG", org}, namen)), 5), "UTF-8"), namen.length, true));
            if (medien.length == 0) {
                FProt.instance().prot("keine Medien in " + org);
            } else {
                String ausw = FDatei.checkFileSeperator(auswIn, true);
                String[] stringArray = auswahl;
                int n = auswahl.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    int pos = FString.findFirstString(medien, 2, element, true, true);
                    if (pos < 0) {
                        FProt.instance().prot("kein Medium in " + org + " zu OriginalFileName " + element + " gefunden");
                    } else {
                        String von = String.valueOf(medien[pos][1]) + System.getProperty("file.separator") + medien[pos][0];
                        String nach = String.valueOf(ausw) + medien[pos][0];
                        FProt.instance().prot(String.valueOf(von) + " -> " + nach);
                        if (!nurTest) {
                            new FFile(von).copyFile(nach);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public static int copyBeschreibungMarkierung(String verzIn) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-xmp:ProjectName", "-xmp:ImageDescription", "-xmp:Scene", "-Filename", "-OriginalFilename", "-xmp:ImageRef", "-xmp:Label", "-xmp:Nickname", verzIn};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[0].isEmpty()) {
                    medienToChange.add(zeile);
                }
                ++i;
            }
            if (medienToChange.size() < 2) {
                FProt.instance().prot(String.valueOf(verzIn) + " zu wenig Markierungen vorhanden, keine Verarbeitung");
            } else {
                medienToChange.add(new String[]{"ZZZZZZZ", "-xmp:ImageDescription", "-xmp:Scene", "-Filename", "-OriginalFilename", "-xmp:ImageRef", "-xmp:Label", "-xmp:Nickname"});
                String[][] medien = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(FString.convertArrayListToTabelle(medienToChange))), namen.length);
                String[][] org = FString.copyTabelle(medien);
                String letzteMarkierung = medien[0][0];
                int startMarkierung = 0;
                int endeMarkierung = 0;
                int i2 = 1;
                while (i2 < medien.length) {
                    if (letzteMarkierung.compareToIgnoreCase(medien[i2][0]) != 0) {
                        endeMarkierung = i2 - 1;
                        if (endeMarkierung - startMarkierung < 1) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " zu wenig Markierungen vorhanden, keine Verarbeitung");
                        } else if (medien[endeMarkierung][1].isEmpty()) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " keine Beschreibung vorhanden, keine Verarbeitung");
                        } else if (!medien[endeMarkierung - 1][1].isEmpty() && !medien[endeMarkierung - 1][2].isEmpty()) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " zu viele Beschreibungen mit Szene vorhanden, keine Verarbeitung");
                        } else {
                            int j = startMarkierung;
                            while (j < endeMarkierung) {
                                medien[j][0] = "";
                                medien[j][1] = medien[endeMarkierung][1];
                                medien[j][2] = medien[endeMarkierung][2];
                                medien[j][5] = medien[endeMarkierung][4];
                                medien[j][6] = medien[endeMarkierung][6];
                                medien[j][7] = medien[endeMarkierung][7];
                                ++j;
                            }
                            medien[endeMarkierung][0] = "";
                            medien[endeMarkierung][5] = "";
                        }
                        startMarkierung = i2;
                        endeMarkierung = i2;
                        letzteMarkierung = medien[i2][0];
                    }
                    ++i2;
                }
                ArrayList<String> parm = new ArrayList<String>();
                int i3 = 0;
                while (i3 < medien.length) {
                    FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                    FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                    parm.clear();
                    if (org[i3][0].compareTo(medien[i3][0]) != 0) {
                        parm.add(String.valueOf(namen[0]) + "=" + medien[i3][0]);
                    }
                    int j = 1;
                    while (j < 3) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    j = 4;
                    while (j < 7) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][3] + ": " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][3]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                    ++i3;
                }
                FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
            }
        }
        return anzChangedMedien;
    }

    public static int copyKoordinatenMarkierung(String verzIn) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-xmp:ProjectName", "-GPSLatitude", "-GPSLongitude", "-Filename", "-xmp:City", "-xmp:Location", "-GPSAltitude#", "-GPSLatitudeRef", "-GPSLongitudeRef", verzIn};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[0].isEmpty()) {
                    medienToChange.add(zeile);
                }
                ++i;
            }
            if (medienToChange.size() < 2) {
                FProt.instance().prot(String.valueOf(verzIn) + " zu wenig Markierungen vorhanden, keine Verarbeitung");
            } else {
                medienToChange.add(new String[]{"ZZZZZZZ", "-GPSLatitude", "-GPSLongitude", "-Filename", "-xmp:City", "-xmp:Location"});
                String[][] medien = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(FString.convertArrayListToTabelle(medienToChange))), namen.length);
                String[][] org = FString.copyTabelle(medien);
                String letzteMarkierung = medien[0][0];
                int startMarkierung = 0;
                int endeMarkierung = 0;
                int i2 = 1;
                while (i2 < medien.length) {
                    if (letzteMarkierung.compareToIgnoreCase(medien[i2][0]) != 0) {
                        endeMarkierung = i2 - 1;
                        if (endeMarkierung - startMarkierung < 1) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " zu wenig Markierungen vorhanden, keine Verarbeitung");
                        } else if (medien[endeMarkierung][1].isEmpty() || medien[endeMarkierung][2].isEmpty()) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " keine Koordinaten vorhanden, keine Verarbeitung");
                        } else if (!medien[endeMarkierung - 1][1].isEmpty() && !medien[endeMarkierung - 1][2].isEmpty()) {
                            FProt.instance().prot(String.valueOf(letzteMarkierung) + " zu viele (mehr als ein Punkt) Koordinaten vorhanden, keine Verarbeitung");
                        } else {
                            try {
                                medien[endeMarkierung][6] = "" + Math.round(Double.parseDouble(medien[endeMarkierung][6]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int j = startMarkierung;
                            while (j < endeMarkierung) {
                                medien[j][0] = "";
                                medien[j][1] = medien[endeMarkierung][1];
                                medien[j][2] = medien[endeMarkierung][2];
                                medien[j][6] = medien[endeMarkierung][6];
                                medien[j][7] = medien[endeMarkierung][7];
                                medien[j][8] = medien[endeMarkierung][8];
                                ++j;
                            }
                            medien[endeMarkierung][0] = "";
                        }
                        startMarkierung = i2;
                        endeMarkierung = i2;
                        letzteMarkierung = medien[i2][0];
                    }
                    ++i2;
                }
                ArrayList<String> parm = new ArrayList<String>();
                int i3 = 0;
                while (i3 < medien.length) {
                    FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                    FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                    parm.clear();
                    int j = 0;
                    while (j < 3) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    j = 6;
                    while (j < 9) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][3] + ": " + medien[i3][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][3]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                    ++i3;
                }
                FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
            }
        }
        return anzChangedMedien;
    }

    public static int copyKoordinatenUmgebung(String medium, int abstandMaxIn) {
        int anzChangedMedien = 0;
        int abstandMax = FMath.checkRange(abstandMaxIn, 1, 30) * 60;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        String dateiname = "";
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        if (new File(medium).isFile()) {
            dateiname = FDatei.instance().zerlegeDateiname(medium).getNamePlusExtend();
        }
        String[] namen = new String[]{"-DateTimeOriginal", "-CreateDate", "-GPSLatitude", "-GPSLongitude", "-Filename", "-OriginalFilename", "-GPSProcessingMethod", "-GPSAltitude#", "-GPSLatitudeRef", "-GPSLongitudeRef", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienToChange = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(medium) + " hat keine relevanten Medien");
        } else {
            FGregorianCalendar datum = new FGregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            boolean zeileMitKoordinatengefunden = false;
            int anzahlOhneKoordinaten = 0;
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                try {
                    datum.setTime(dateFormat.parse(zeile[1]));
                    zeile[0] = "" + datum.getTimeInMillis() / 1000L;
                }
                catch (Exception e) {
                    zeile[0] = "0000000000000000000000";
                }
                medienToChange.add(zeile);
                if (zeile[2].isEmpty() && zeile[3].isEmpty()) {
                    ++anzahlOhneKoordinaten;
                }
                zeileMitKoordinatengefunden = true;
                ++i;
            }
            if (anzahlOhneKoordinaten == 0) {
                FProt.instance().prot(String.valueOf(medium) + " keine Medien ohne Koordinaten");
            } else if (!zeileMitKoordinatengefunden) {
                FProt.instance().prot(String.valueOf(medium) + " keine Medien mit Koordinaten");
            } else {
                int abstandNichtGefunden;
                String[][] medien = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(FString.convertArrayListToTabelle(medienToChange))), namen.length);
                String[][] org = FString.copyTabelle(medien);
                long suche = -1L;
                long sucheWork = -1L;
                int abstandZurueck = abstandNichtGefunden = abstandMax * 2;
                int abstandVor = abstandNichtGefunden;
                int gefundenZurueck = -1;
                int gefundenVor = -1;
                int gefunden = -1;
                int i2 = 0;
                while (i2 < medien.length) {
                    if ((dateiname.isEmpty() || dateiname.compareToIgnoreCase(medien[i2][4]) == 0) && medien[i2][2].isEmpty() && medien[i2][3].isEmpty()) {
                        int j;
                        suche = Long.parseLong(medien[i2][0]);
                        abstandZurueck = abstandNichtGefunden;
                        abstandVor = abstandNichtGefunden;
                        gefundenZurueck = -1;
                        gefundenVor = -1;
                        if (i2 > 0) {
                            j = i2 - 1;
                            while (j >= 0) {
                                if (!medien[j][2].isEmpty() && !medien[j][3].isEmpty() && medien[j][6].isEmpty() && Math.abs(suche - (sucheWork = Long.parseLong(medien[j][0]))) <= (long)abstandMax) {
                                    abstandZurueck = (int)Math.abs(suche - sucheWork);
                                    gefundenZurueck = j;
                                    break;
                                }
                                --j;
                            }
                        }
                        if (i2 < medien.length - 1) {
                            j = i2 + 1;
                            while (j < medien.length) {
                                if (!medien[j][2].isEmpty() && !medien[j][3].isEmpty() && medien[j][6].isEmpty() && Math.abs(suche - (sucheWork = Long.parseLong(medien[j][0]))) <= (long)abstandMax) {
                                    abstandVor = (int)Math.abs(suche - sucheWork);
                                    gefundenVor = j;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (Math.min(abstandZurueck, abstandVor) <= abstandMax) {
                            gefunden = abstandZurueck < abstandVor ? gefundenZurueck : gefundenVor;
                            medien[i2][2] = medien[gefunden][2];
                            medien[i2][3] = medien[gefunden][3];
                            medien[i2][6] = "Koordinaten und H\u00f6he \u00fcbernommen von " + medien[gefunden][5] + ", Abstand " + Math.min(abstandZurueck, abstandVor) + " Sekunden, " + medien[gefunden][1].substring(11) + " => " + medien[i2][1].substring(11);
                            try {
                                medien[gefunden][7] = "" + Math.round(Double.parseDouble(medien[gefunden][7]));
                            }
                            catch (Exception j2) {
                                // empty catch block
                            }
                            medien[i2][7] = medien[gefunden][7];
                            medien[i2][8] = medien[gefunden][8];
                            medien[i2][9] = medien[gefunden][9];
                        }
                    }
                    ++i2;
                }
                ArrayList<String> parm = new ArrayList<String>();
                int i3 = 0;
                while (i3 < medien.length) {
                    FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                    FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                    parm.clear();
                    int j = 2;
                    while (j <= 3) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    j = 6;
                    while (j <= 9) {
                        if (org[i3][j].compareTo(medien[i3][j]) != 0) {
                            parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                        }
                        ++j;
                    }
                    if (parm.size() > 0) {
                        FProt.instance().prot("Change " + medien[i3][4] + ": " + medien[i3][5] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                        parm.add(String.valueOf(verz) + medien[i3][4]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        ++anzChangedMedien;
                    }
                    ++i3;
                }
                FProt.instance().prot(String.valueOf(medium) + ": " + medienAlle.size() + " Medien, " + medienToChange.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
            }
        }
        return anzChangedMedien;
    }

    public static int copyMetadaten(String medium, String refVerzIn, boolean test, boolean refVerzRekursiv) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String refVerz = FDatei.checkFileSeperator(refVerzIn, true);
        String[] tags = new String[]{"-Filename", "-MimeType", "-OriginalFileName", "-DateTimeOriginal", "-Directory", medium};
        String[][] toChange = FDatei.clearTags(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, tags)), 5), "UTF-8"), tags.length, true));
        int i = 0;
        while (i < toChange.length) {
            toChange[i][1] = toChange[i][1].lastIndexOf("/") > 0 ? toChange[i][1].substring(0, toChange[i][1].lastIndexOf("/")) : toChange[i][1];
            ++i;
        }
        tags[tags.length - 1] = refVerz;
        String[][] referenz = FDatei.clearTags(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", refVerzRekursiv ? "-R" : "", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, tags)), 5), "UTF-8"), tags.length, true));
        int i2 = 0;
        while (i2 < referenz.length) {
            referenz[i2][1] = referenz[i2][1].lastIndexOf("/") > 0 ? referenz[i2][1].substring(0, referenz[i2][1].lastIndexOf("/")) : referenz[i2][1];
            ++i2;
        }
        int[] found = null;
        String duplikate = "";
        String ref = "";
        String art = "";
        int i3 = 0;
        while (i3 < toChange.length) {
            art = "OriginalFileName " + toChange[i3][2];
            int[] nArray = found = toChange[i3][2].isEmpty() ? null : FString.findString(referenz, 2, toChange[i3][2], true, true);
            if (found == null) {
                art = "FileName";
                found = FString.findString(referenz, 0, toChange[i3][0], true, true);
            }
            if (found == null) {
                art = "DateTimeOriginal " + toChange[i3][3];
                found = FString.findString(referenz, 3, toChange[i3][3], true, true);
            }
            if (found == null) {
                FProt.instance().prot("Error in Zeile\t" + (i3 + 1) + "\t" + toChange[i3][0] + "\t" + toChange[i3][2] + "\tReferenz nicht gefunden", 0);
            } else if (found.length > 1) {
                duplikate = "";
                int[] nArray2 = found;
                int n = found.length;
                int n2 = 0;
                while (n2 < n) {
                    int element = nArray2[n2];
                    duplikate = String.valueOf(duplikate) + "\t" + referenz[element][4] + (art.startsWith("FileName") ? "" : ": " + referenz[element][0]);
                    ++n2;
                }
                FProt.instance().prot("Error in Zeile\t" + (i3 + 1) + "\t" + toChange[i3][0] + "\t" + toChange[i3][2] + "\t" + found.length + " Referenzen (" + art + ") gefunden, nicht eindeutig" + duplikate, 0);
            } else if (toChange[i3][1].compareToIgnoreCase(referenz[found[0]][1]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + (i3 + 1) + "\t" + toChange[i3][0] + "\t" + toChange[i3][1] + "\tFiletyp nicht uebereinstimmend mit\t" + referenz[found[0]][1], 0);
            } else {
                ref = String.valueOf(FDatei.checkFileSeperator(referenz[found[0]][4], true)) + referenz[found[0]][0];
                if (toChange[i3][3].compareTo(referenz[found[0]][3]) != 0) {
                    FProt.instance().prot("Warning in Zeile\t" + (i3 + 1) + "\t" + toChange[i3][1] + "\t" + toChange[i3][3] + "\tDateTimeOriginal nicht uebereinstimmend mit\t" + referenz[found[0]][3], 0);
                }
                FProt.instance().prot("Doing in Zeile\t" + (i3 + 1) + "\tcopy Metadaten via " + art + " " + ref + "\t==>\t" + toChange[i3][4] + ": " + toChange[i3][0], 5);
                if (test) {
                    FProt.instance().prot("copy Metadaten via " + art + " " + ref + "\t==>\t" + toChange[i3][4] + ": " + toChange[i3][0], 0);
                } else {
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-XMP=", "-IPTC=", "-m", String.valueOf(verz) + toChange[i3][0], "-execute", "-tagsFromFile", ref, "-all:all", "--exif:datetimeoriginal", "--exif:ThumbnailImage", "-m", " -overwrite_original_in_place", String.valueOf(verz) + toChange[i3][0]}), 0);
                }
                ++anzChangedMedien;
            }
            ++i3;
        }
        FProt.instance().prot("Metadaten von " + anzChangedMedien + " (" + toChange.length + ") Medien aus " + medium + " kopiert aus " + refVerzIn);
        return anzChangedMedien;
    }

    public static int copyProjectName2GPSKoordinaten(String medium) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-Filename", "-GPSLatitude", "-GPSLongitude", "-xmp:ProjectName", medium};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            String[] teile = medien[i][3].split(",");
            if (teile.length > 1) {
                medien[i][1] = teile[0];
                medien[i][2] = teile[1].trim();
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 1;
                while (j < medien[i2].length) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot("Change " + medien[i2][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                    parm.add(String.valueOf(verz) + medien[i2][0]);
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                    ++anzChangedMedien;
                }
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Medien, " + anzChangedMedien + " geaenderte Medien");
        return anzChangedMedien;
    }

    private static void createAndClearVerzeichnis(String verzeichnisName) {
        FFile verz = new FFile(verzeichnisName);
        if (verz.exists()) {
            String[] videos;
            String[] stringArray = videos = verz.listFileNames();
            int n = videos.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                new File(verz, element).delete();
                ++n2;
            }
        } else {
            verz.mkdirs();
        }
    }

    public static void createBookmarks(String verzIn) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-GPSMapDatum", "-GPSLatitude", "-GPSLongitude", "-OriginalFileName", "-Basename", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienRelevant = new ArrayList<String[]>();
        ArrayList<String> bookmarks = new ArrayList<String>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[1].isEmpty() && !zeile[2].isEmpty()) {
                    if (zeile[3].isEmpty()) {
                        zeile[3] = zeile[4];
                    }
                    zeile[0] = String.valueOf(zeile[1]) + zeile[2];
                    medienRelevant.add(zeile);
                }
                ++i;
            }
            medienRelevant.add(new String[]{"9999999.99999", "-GPSLatitude", "-GPSLongitude", "-OriginalFileName", "-Basename", verz});
            String[][] medien = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(FString.convertArrayListToTabelle(medienRelevant))), namen.length);
            String filenames = medien[0][3];
            int i2 = 1;
            while (i2 < medien.length) {
                if (medien[i2][0].compareTo(medien[i2 - 1][0]) == 0) {
                    filenames = String.valueOf(filenames) + ", " + medien[i2][3];
                } else {
                    bookmarks.add("{\"name\":\"" + filenames + "\",\"latitude\":" + medien[i2 - 1][1].replace('+', ' ').trim() + ",\"longitude\":" + medien[i2 - 1][2].replace('+', ' ').trim() + "}");
                    filenames = medien[i2][3];
                }
                ++i2;
            }
            String bookmarksString = "[" + FString.arrayListToString(bookmarks, true, ",") + "]";
            new FFile(String.valueOf(verz) + "fotos.bookmark").StringToInhalt(bookmarksString);
            FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienRelevant.size() + " relevanten Medien, " + bookmarks.size() + " Bookmarks");
        }
    }

    public static void createErsteBilder(String videoName, int ersteXSekunden) {
        String zielVerz = String.valueOf(FDatei.instance().zerlegeDateiname(videoName).getPfadPlusName()) + "_Bilder_erste_" + ersteXSekunden + "_Sek";
        int laengeVideo = 0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(5);
        try {
            laengeVideo = (int)Float.parseFloat(FDatei.getExiftag(videoName, "Duration#"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FProt.instance().prot(String.valueOf(videoName) + ", Laenge " + laengeVideo + " Sekunden", 1);
        FDatei.createAndClearVerzeichnis(zielVerz);
        int i = 1;
        while (i <= Math.min(laengeVideo, ersteXSekunden)) {
            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-noaccurate_seek", "-ss", String.valueOf(i), "-i", videoName, "-qmin", "1", "-q:v", "1", "-vframes", "1", String.valueOf(zielVerz) + "/" + nf.format(i) + ".jpg"}, FDatei.getMsgLevelMedien());
            ++i;
        }
    }

    public static boolean createLink(String originalDateiname, String linkDateiname, boolean symbolic) {
        boolean ok = true;
        try {
            Path original = Paths.get(originalDateiname, new String[0]);
            if (Files.exists(original, new LinkOption[0])) {
                Path link = Paths.get(linkDateiname, new String[0]);
                if (symbolic) {
                    Files.createSymbolicLink(link, original, new FileAttribute[0]);
                } else {
                    Files.createLink(link, original);
                }
            } else {
                FProt.instance().prot("Fehler bei Erstellung " + (symbolic ? "Symbolic" : "Hard") + "Link: '" + originalDateiname + "' -> '" + linkDateiname + "' : Original nicht vorhanden");
            }
        }
        catch (IOException ex) {
            FProt.instance().prot("Fehler bei Erstellung " + (symbolic ? "Symbolic" : "Hard") + "Link: '" + originalDateiname + "' -> '" + linkDateiname + "' :" + ex.toString().split(":")[0]);
            ok = false;
        }
        catch (UnsupportedOperationException x) {
            FProt.instance().prot(x.toString());
        }
        return ok;
    }

    public static String createOriginalFilename(String name) {
        String originalFileName = "";
        String nummer = FDatei.getNummer(name);
        String stamm = "";
        if (name.startsWith("IMG_") || name.indexOf("_E400_") >= 0 || name.indexOf("_iPhSE_") >= 0) {
            stamm = "IMG";
        } else if (name.indexOf("WebDl_") >= 0) {
            stamm = "WebDl";
        } else if (name.indexOf("Scrsh_") >= 0) {
            stamm = "Scrsh";
        }
        if (!stamm.isEmpty() || nummer.length() < 4) {
            originalFileName = String.valueOf(stamm) + "_" + nummer;
        }
        return originalFileName;
    }

    public static int createSingleTextOnImages(String medium, boolean nurTest) {
        int anzMedien = 0;
        String[] namen = new String[]{"-xmp:ImageDescription", "-xmp:Label", "-xmp:Nickname", "-composite:ImageSize", "-FileName", "-Directory", medium};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-r", "-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG"}, namen)), 5), true, true), namen.length, true));
        String letzt = "";
        String aktuell = "";
        String[][] stringArray = medien;
        int n = medien.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            aktuell = String.valueOf(element[0]) + (element[1].isEmpty() ? "" : "\t" + element[1]) + (element[2].isEmpty() ? "" : "\t" + element[2]) + "\t" + element[3];
            if (aktuell.compareTo(letzt) != 0) {
                if (!nurTest) {
                    FDatei.instance().textOnImage(String.valueOf(element[5]) + "/" + element[4], 1920);
                }
                FProt.instance().prot(String.valueOf(element[5]) + "/" + element[4] + "\t" + aktuell);
                ++anzMedien;
                letzt = aktuell;
            }
            ++n2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Medien, " + anzMedien + " Medien ausgewaehlt");
        return anzMedien;
    }

    public static void createSingleTitleImage(String verzIn) {
        FDatei.createSingleTitleImage(verzIn, 0);
    }

    public static void createSingleTitleImage(String verzIn, int titelUmbrechenNach) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-PreSelectedTitle", "-Filename", verz};
        String[][] images = FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG"}, namen)), 5), "UTF-8")), namen.length, true);
        if (images.length > 0) {
            int preSelTitlePos = 0;
            int i = 0;
            while (i < images.length) {
                if (!images[i][0].isEmpty() && images[i][0].compareTo("-") != 0) {
                    preSelTitlePos = i;
                    break;
                }
                ++i;
            }
            FDatei.instance().textOnImage(String.valueOf(verz) + images[preSelTitlePos][1], 1920, "_mit_Titel", "Titel", false, 0, 0, false, false, titelUmbrechenNach);
            FProt.instance().prot("Titelbild fuer " + verzIn + " aus " + images[preSelTitlePos][1] + " erzeugt");
        } else {
            FProt.instance().prot("keine Images in " + verzIn + ", kein Titelbild erzeugt");
        }
    }

    public static int createStandbilder(String videoName, int bildAlleXSekunden) {
        int anzBilder = 0;
        String zielVerz = String.valueOf(FDatei.instance().zerlegeDateiname(videoName).getPfadPlusName()) + "_Standbilder_alle_" + bildAlleXSekunden + "_Sek";
        int laengeVideo = 0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(5);
        try {
            laengeVideo = (int)Float.parseFloat(FDatei.getExiftag(videoName, "Duration#"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FProt.instance().prot(String.valueOf(videoName) + ", Laenge " + laengeVideo + " Sekunden", 1);
        FDatei.createAndClearVerzeichnis(zielVerz);
        int i = 0;
        while (i <= laengeVideo) {
            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-noaccurate_seek", "-ss", String.valueOf(i), "-i", videoName, "-vframes", "1", String.valueOf(zielVerz) + "/" + nf.format(i) + ".jpg"}, FDatei.getMsgLevelMedien());
            ++anzBilder;
            i += bildAlleXSekunden;
        }
        return anzBilder;
    }

    public static void deleteFileIfExists(String verz, String datei) {
        File imageFile = new File(verz, datei);
        if (imageFile.exists()) {
            imageFile.delete();
        }
    }

    public static void delValueExiftag(String mediumName, String tagName) {
        FFile medium = new FFile(mediumName);
        if (medium.exists()) {
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-" + tagName + "=", "-T", medium.getAbsolutePath()}));
        }
    }

    public static void delValueExiftags(String mediumName, String[] tagNamen) {
        FFile medium = new FFile(mediumName);
        if (medium.exists() && tagNamen.length > 0) {
            String[] listeTags = new String[tagNamen.length];
            int i = 0;
            while (i < tagNamen.length) {
                listeTags[i] = "-" + tagNamen[i] + "=";
                ++i;
            }
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(listeTags, new String[]{"-T", medium.getAbsolutePath()})));
        }
    }

    public static void drehen(String dateiname, int gradIn) {
        FDatei.drehen(dateiname, gradIn, false);
    }

    public static void drehen(String dateiname, int gradIn, boolean overwriteOriginal) {
        FFile medium = new FFile(dateiname);
        int grad = FMath.checkRange(gradIn, 0, 359);
        if (grad == 0) {
            FProt.instance().prot("Drehen nicht bei 0 Grad nicht notwendig: " + medium.getAbsolutePath(), 0);
        } else if (medium.isPicture()) {
            FBefehl.aufrufBefehl("mogrify", new String[]{"-rotate", "" + grad, medium.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-orientation#=1", "-overwrite_original_in_place", medium.getAbsolutePath()}), FDatei.getMsgLevelMedien());
            FDatei.makeThumbnail(medium.getAbsolutePath(), true, 0, 999);
            FProt.instance().prot("Foto " + medium.getAbsolutePath() + " um " + grad + " Grad gedreht", 0);
        } else if (medium.isVideo()) {
            String vfWert;
            String string = grad == 270 ? "transpose=2" : (grad == 90 ? "transpose=1" : (vfWert = grad == 180 ? "hflip,vflip" : ""));
            if (vfWert.length() == 0) {
                FProt.instance().prot("Drehen Video " + medium.getAbsolutePath() + " um " + grad + " Grad nicht implementiert", 0);
            } else {
                DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(dateiname);
                FFile output = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + "_gedreht_" + grad + "_Grad." + dateinamenTeile.getExtend());
                output.deleteIfExits();
                FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-vf", vfWert, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FDatei.nachbereitenVideo(medium.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, true);
                FProt.instance().prot("Video " + medium.getAbsolutePath() + " um " + grad + " Grad gedreht", 0);
            }
        } else {
            FProt.instance().prot("Drehen nicht implementiert, " + medium.getAbsolutePath() + " kein Foto und kein Video", 0);
        }
    }

    public static void drehenNachExif(String dateiname) {
        FFile medium = new FFile(dateiname);
        if (medium.isPicture()) {
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Orientation#", "-T", medium.getAbsolutePath()}), FDatei.getMsgLevelMedien());
            if (tags.length > 0 && tags[0].length() > 0) {
                char orientNr = tags[0].charAt(0);
                if (orientNr == '6') {
                    FDatei.drehen(medium.getAbsolutePath(), 90);
                } else if (orientNr == '8') {
                    FDatei.drehen(medium.getAbsolutePath(), 270);
                } else if (orientNr == '3') {
                    FDatei.drehen(medium.getAbsolutePath(), 180);
                }
            }
        } else {
            FProt.instance().prot("Drehen nach Exif nicht implementiert, " + medium.getAbsolutePath() + " kein Foto", 0);
        }
    }

    public static void drehenNachExifVerzeichnis(String name) {
        FFile verz = new FFile(name);
        if (verz.isDirectory()) {
            String[] file;
            verz.setAusgabeNurNamen(true);
            String[] stringArray = file = verz.listjfi();
            int n = file.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                FFile test = new FFile(element);
                if (test.isPicture()) {
                    FDatei.drehenNachExif(element);
                }
                if (test.isVideo()) {
                    FDatei.checkVideoRotationAndCreateDate(element);
                }
                ++n2;
            }
        } else if (verz.isPicture()) {
            FDatei.drehenNachExif(name);
        }
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, 'c', null, 0, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, char art) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, art, null, 0, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, char art, int overwrite) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, art, null, overwrite, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, char art, String verzPreviewName) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, art, verzPreviewName, 0, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, char art, String verzPreviewName, int overwrite) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, art, verzPreviewName, overwrite, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, char art, String verzPreviewName, int overwrite, int[] dimensionSoll, String previewNameIn) {
        FFile video = new FFile(videoName);
        if (video.isVideo()) {
            int[] dimensionIst;
            File fileCheck;
            String extraktDisplayName;
            boolean createPoster = true;
            DateinamenTeile name = FDatei.instance().zerlegeDateiname(video.getAbsolutePath());
            String extraktArt = art == 'c' ? "CoverArt" : "UnknownThumbnail";
            String string = extraktDisplayName = art == 'c' ? "Poster" : "Thumbnail";
            String previewName = previewNameIn == null ? name.getName() : (previewNameIn.isEmpty() ? name.getName() : previewNameIn);
            String extraktName = String.valueOf(name.getPfad()) + System.getProperty("file.separator") + previewName + "_" + extraktArt + ".jpg";
            if (verzPreviewName != null && !verzPreviewName.isEmpty()) {
                File verzPreview = new File(verzPreviewName);
                if (!verzPreview.exists()) {
                    verzPreview.mkdirs();
                }
                if (verzPreview.exists() && verzPreview.canWrite()) {
                    extraktName = String.valueOf(verzPreview.getAbsolutePath()) + System.getProperty("file.separator") + previewName + ".jpg";
                }
            }
            if ((fileCheck = new File(extraktName)).exists()) {
                if (overwrite > 1) {
                    fileCheck.delete();
                } else if (overwrite == 1 && video.lastModified() > fileCheck.lastModified()) {
                    fileCheck.delete();
                    FProt.instance().prot(String.valueOf(extraktDisplayName) + " vorhanden, Update notwendig, da Video neuer als extrahiertes " + extraktArt + "\t" + fileCheck.getAbsolutePath(), 1);
                } else {
                    FProt.instance().prot(String.valueOf(extraktDisplayName) + " vorhanden, Erstellung nicht notwendig\t" + fileCheck.getAbsolutePath(), 1);
                    createPoster = false;
                }
            }
            if (createPoster) {
                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-b", "-" + extraktArt, "-W", extraktName, video.getAbsolutePath()}), 5);
                if (fileCheck.exists()) {
                    FProt.instance().prot(String.valueOf(extraktDisplayName) + " erstellt (Preview " + extraktArt + " extrahiert)\t" + extraktName);
                    if (art == 'c') {
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-tagsFromFile", video.getAbsolutePath(), "-all:all", "-GPSLatitude<GPSLatitude", "-GPSLongitude<GPSLongitude", "-GPSAltitude<GPSAltitude", "-Model<Model", "-Make<Make", "-CreationDate<CreateDate", "-DateTimeOriginal<CreateDate", "-m", " -overwrite_original_in_place", extraktName}), 0);
                    }
                } else {
                    FProt.instance().prot(String.valueOf(extraktDisplayName) + " nicht erstellt (Preview " + extraktArt + " konnte nicht extrahiert werden)\t" + extraktName);
                }
            }
            if (fileCheck.exists() && dimensionSoll != null && dimensionSoll.length == 2 && ((dimensionIst = FDatei.getImageDimension(extraktName))[0] != dimensionSoll[0] || dimensionIst[1] != dimensionSoll[1])) {
                String[] parmResizeAndFillPreview = new String[]{"-define", "jpeg:size=" + dimensionSoll[0] + "x" + dimensionSoll[1], extraktName, "-thumbnail", String.valueOf(dimensionSoll[0]) + "x" + dimensionSoll[1], "-background", "grey", "-gravity", "center", "-extent", String.valueOf(dimensionSoll[0]) + "x" + dimensionSoll[1], String.valueOf(extraktName) + ".resize.jpg"};
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parmResizeAndFillPreview, 0);
                fileCheck.delete();
                new FFile(String.valueOf(extraktName) + ".resize.jpg").renameTo(extraktName);
            }
        }
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, int overwrite) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, 'c', null, overwrite, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, String verzPreviewName) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, 'c', verzPreviewName, 0, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, String verzPreviewName, int overwrite) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, 'c', verzPreviewName, overwrite, null, null);
    }

    public static void extraktCoverArtOrUnknownThumbnail(String videoName, String verzPreviewName, int overwrite, String previewName) {
        FDatei.extraktCoverArtOrUnknownThumbnail(videoName, 'c', verzPreviewName, overwrite, null, previewName);
    }

    public static void extraktPreviewFiles(String videoName) {
        FFile video = new FFile(videoName);
        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", "%d%f_%t%-c.%s", "-preview:all", video.getAbsolutePath()}), 5);
    }

    public static void extraktPreviewUndPoster(String verz) {
        FDatei.extraktPreviewUndPoster(verz, "poster und preview");
    }

    public static void extraktPreviewUndPoster(String verzIn, String funktion) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        FFile verzFile = new FFile(verz);
        if (verzFile.isDirectory()) {
            String[] dateien = verzFile.listFileNames('d', false);
            ArrayList<String> files = new ArrayList<String>();
            String[] stringArray = dateien;
            int n = dateien.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                FDatei.extraktPreviewUndPoster1Medium(String.valueOf(verz) + element, funktion, files);
                ++n2;
            }
            if (funktion.contains("beschreibung") && files.size() > 0) {
                new FFile(verz, "_files.txt").StringArrayListToInhalt(files);
                String indexOrgName = Futi.instance().restoreField1Wert("FDatei", "index.php");
                if (indexOrgName.isEmpty()) {
                    FProt.instance().prot("Parameterdatei ../FDatei/index.php.txt nicht gefunden");
                } else {
                    FFile indexFileOrg = new FFile(indexOrgName);
                    if (!indexFileOrg.exists()) {
                        FProt.instance().prot(String.valueOf(indexOrgName) + " nicht gefunden");
                    } else {
                        File indexFile = new File(verz, "index.php");
                        indexFileOrg.copyFile(indexFile.getAbsolutePath());
                    }
                }
            }
        } else {
            FProt.instance().prot(String.valueOf(verzIn) + " ist kein Verzeichnis");
        }
    }

    public static void extraktPreviewUndPoster1Medium(String mediumName, String funktion) {
        FDatei.extraktPreviewUndPoster1Medium(mediumName, funktion, null);
    }

    public static void extraktPreviewUndPoster1Medium(String mediumName, String funktion, ArrayList<String> files) {
        FFile medium = new FFile(mediumName);
        DateinamenTeile name = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        if (medium.isPicture() || medium.isVideo()) {
            if (name.getParent().compareToIgnoreCase("Poster") == 0) {
                FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " ist im Verzeichnis Poster, keine Verarbeitung", 2);
            } else if (name.getParent().compareToIgnoreCase("Preview") == 0) {
                FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " ist im Verzeichnis Preview, keine Verarbeitung", 2);
            } else {
                String postername = String.valueOf(name.getPfad()) + System.getProperty("file.separator") + "Poster" + System.getProperty("file.separator") + name.getName() + ".jpg";
                if (medium.isPicture()) {
                    if (!medium.isGIF() && funktion.contains("poster")) {
                        new File(name.getPfad(), "Poster").mkdirs();
                        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{mediumName, "-thumbnail", "160x160>", postername}, FDatei.getMsgLevelMedien());
                    }
                } else {
                    if (funktion.contains("poster")) {
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", postername, "-UnknownThumbnail", mediumName}));
                        FBefehl.aufrufBefehl("mogrify", new String[]{"-thumbnail", "160x160>", postername}, FDatei.getMsgLevelMedien());
                    }
                    if (funktion.contains("preview")) {
                        String previewname = String.valueOf(name.getPfad()) + System.getProperty("file.separator") + "Preview" + System.getProperty("file.separator") + name.getName() + ".jpg";
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", previewname, "-CoverArt", mediumName}));
                    }
                }
            }
            if (funktion.contains("beschreibung") && files != null) {
                files.add(String.valueOf(name.getName()) + "$" + (medium.isVideo() ? "$" + FDatei.getExiftag(mediumName, "duration#") : ""));
            }
        }
    }

    public static void extraktPreviewUndPosterCreateBeschreibung(String verz) {
        FDatei.extraktPreviewUndPoster(verz, "poster und preview und beschreibung");
    }

    public static String findDateien(String[] Datei) {
        String DatChecked = "";
        int i = 0;
        while (i < Datei.length) {
            File TestDatei = new File(Datei[i]);
            if (TestDatei.exists()) {
                DatChecked = Datei[i];
                break;
            }
            ++i;
        }
        return DatChecked;
    }

    private static String getAlbumFromDatabase(String mediumName) {
        FProt fProt = FProt.instance();
        String album = "";
        FFile medium = new FFile(mediumName);
        if (medium.exists()) {
            String verzQuelle = medium.isDirectory() ? medium.getName() : FDatei.instance().zerlegeDateiname(mediumName).getParent();
            String selectStatement = "SELECT DiashowName FROM Verzeichnisse_Diashow WHERE verzQuelle like \"%" + verzQuelle + "\"";
            Statement dBStatement = FDB.createDBStatement("/Volumes/User-Dokumente/BilderOverview/bilder.sqlite");
            ResultSet rs = FDB.executeQuery(dBStatement, selectStatement, 2);
            if (rs != null) {
                try {
                    if (rs.next()) {
                        album = rs.getString("DiashowName").trim();
                    }
                }
                catch (SQLException SQLe) {
                    fProt.prot("Fehler bei SQL-Statement: " + selectStatement);
                    FDB.handleException(SQLe);
                }
                catch (Exception e) {
                    fProt.prot(e.toString());
                }
            }
            FDB.closeDBStatement(dBStatement);
        }
        return album;
    }

    public static int getAnzahlZeilenSpaltenPoster() {
        return AnzahlZeilenSpaltenPoster;
    }

    public static String getAppleKommentar(String dateiName) {
        return FDatei.getAppleKommentar(dateiName, -1);
    }

    public static String getAppleKommentar(String dateiName, int msgLevel) {
        String AppleKommentar = "";
        FFile datei = new FFile(dateiName);
        if (datei.exists() && Futi.isMac()) {
            String[] comment = FBefehl.aufrufBefehl("mdls", new String[]{"-name", "kMDItemFinderComment", "-raw", datei.getAbsolutePath()}, 2);
            if (comment.length > 0 && comment[0].length() > 0 && comment[0].length() > 1 && (AppleKommentar = comment[0]).compareTo("(null)") == 0) {
                AppleKommentar = "";
            }
            if (msgLevel >= 0) {
                FProt.instance().prot(String.valueOf(datei.getAbsolutePath()) + ": " + AppleKommentar, msgLevel);
            }
        }
        return AppleKommentar;
    }

    public static String getDescription(String mediumName) {
        String[] tags;
        String imageDescription = "";
        FFile medium = new FFile(mediumName);
        if (medium.exists() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Description", "-T", "-charset", System.getProperty("sun.jnu.encoding"), medium.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0) {
            imageDescription = tags[0];
        }
        return imageDescription;
    }

    public static String getExiftag(String mediumName, String tagName) {
        String[] tags;
        String tagWert = "";
        FFile medium = new FFile(mediumName);
        if (medium.exists() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-" + tagName, "-T", medium.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0) {
            tagWert = tags[0];
        }
        return tagWert;
    }

    public static String[] getExiftags(String mediumName, String[] tagNamen) {
        String[] tagWerte = new String[tagNamen.length];
        FFile medium = new FFile(mediumName);
        if (medium.exists() && tagNamen.length > 0) {
            String[] teile;
            String[] listeTags = new String[tagNamen.length];
            int i = 0;
            while (i < tagNamen.length) {
                listeTags[i] = "-" + tagNamen[i];
                ++i;
            }
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(listeTags, new String[]{"-T", "-c", "%+.8g", medium.getAbsolutePath()})), 5);
            if (tags.length > 0 && tags[0].length() > 0 && (teile = tags[0].split("\t")).length <= tagNamen.length) {
                int i2 = 0;
                while (i2 < tagWerte.length) {
                    tagWerte[i2] = i2 < teile.length ? teile[i2] : "-";
                    ++i2;
                }
            }
        }
        return tagWerte;
    }

    public static String getFullQualifiedName(String Datei) {
        File F = new File(Datei);
        String Name = Datei;
        try {
            Name = F.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Name;
    }

    public static int getHardlinkCount(String fileName) {
        int hardlinkCount = -1;
        Path nioAttr = Paths.get(fileName, new String[0]);
        try {
            hardlinkCount = (Integer)Files.getAttribute(nioAttr, "unix:nlink", new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hardlinkCount;
    }

    static int[] getImageDimension(String imageName) {
        String[] teile;
        String[] tags;
        FFile image = new FFile(imageName);
        int[] dimension = new int[2];
        if (image.isPicture() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ImageWidth", "-ImageHeight", "-T", image.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0 && (teile = tags[0].split("\t")).length > 1) {
            try {
                dimension[0] = Integer.parseInt(teile[0]);
                dimension[1] = Integer.parseInt(teile[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dimension;
    }

    public static long getImageOptimalFilesize(int breite, int hoehe) {
        return FDatei.getImageOptimalFilesize(breite * hoehe);
    }

    public static long getImageOptimalFilesize(long anzahlPixel) {
        long filesize = anzahlPixel;
        filesize = anzahlPixel < 50000L ? (long)((double)anzahlPixel * 1.5) : (anzahlPixel < 100000L ? anzahlPixel : (anzahlPixel < 500000L ? (long)((double)anzahlPixel / 1.15) : (anzahlPixel < 200000L ? (long)((double)anzahlPixel / 1.3) : (anzahlPixel < 500000L ? (long)((double)anzahlPixel / 1.5) : (anzahlPixel < 1500000L ? (long)((double)anzahlPixel / 1.75) : anzahlPixel / 2L)))));
        return filesize;
    }

    public static int getImageOptimalFilesizeKB(int breite, int hoehe) {
        return (int)(FDatei.getImageOptimalFilesize(breite, hoehe) / 1024L);
    }

    public static int getImageOptimalFilesizeKB(long anzahlPixel) {
        return (int)(FDatei.getImageOptimalFilesize(anzahlPixel) / 1024L);
    }

    public static long getImageResizeAnzahlPixel(int breiteIn, int hoeheIn, int faktorIn, int sizeIn) {
        long anzahlPixel = breiteIn * hoeheIn;
        if (faktorIn > 0) {
            float prozent = (float)((double)FMath.checkRange(faktorIn, 1, 100) / 100.0);
            anzahlPixel = (long)((float)breiteIn * prozent * ((float)hoeheIn * prozent));
        } else {
            int hoehe;
            int breite;
            int size = FMath.checkRange(sizeIn, 10, Math.max(breiteIn, hoeheIn));
            if (breiteIn >= hoeheIn) {
                breite = size;
                hoehe = (int)((double)(breite * hoeheIn) * 1.0 / (double)breiteIn);
            } else {
                hoehe = size;
                breite = (int)((double)(hoehe * breiteIn) * 1.0 / (double)hoeheIn);
            }
            anzahlPixel = breite * hoehe;
        }
        return anzahlPixel;
    }

    public static int getMsgLevelMedien() {
        return MsgLevelMedien;
    }

    public static String getNummer(String name) {
        String nummer = "";
        int posPunkt = name.lastIndexOf(".");
        int posStrich = name.lastIndexOf("_");
        int n = posPunkt = posPunkt < 0 ? name.length() : posPunkt;
        if (posStrich + 1 < posPunkt) {
            nummer = name.substring(posStrich + 1, posPunkt);
        }
        return nummer;
    }

    private static int getPosterAnzahlZeilenSpalten(String thumbnailName) {
        int anzahl = 0;
        FFile thumbnail = new FFile(thumbnailName);
        if (thumbnail.exists() && thumbnail.isPicture()) {
            String[] teile;
            int zeilen = 0;
            int spalten = 0;
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ImageDescription", "-T", thumbnail.getAbsolutePath()}), 5);
            if (tags.length > 0 && tags[0].length() > 0 && (teile = tags[0].split("_")).length > 2 && (teile = teile[1].split("x")).length > 1) {
                try {
                    zeilen = Integer.parseInt(teile[0]);
                    spalten = Integer.parseInt(teile[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (zeilen > 0 && spalten > 0 && zeilen == spalten) {
                anzahl = zeilen;
            }
        }
        return anzahl;
    }

    private static String getPosterImageDescription(String thumbnailName) {
        String[] tags;
        String imageDescription = "";
        FFile thumbnail = new FFile(thumbnailName);
        if (thumbnail.exists() && thumbnail.isPicture() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ImageDescription", "-T", thumbnail.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0) {
            imageDescription = tags[0];
        }
        return imageDescription;
    }

    public static String getTempFileName() {
        String Name = "";
        try {
            File tempFile = File.createTempFile("de.nss.jfi-Java", "FDatei");
            Name = tempFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Name;
    }

    private static int getVideoBitrate(int breite, int hoehe, float faktor) {
        return (int)FMath.checkRange((float)(breite * hoehe) / faktor, 150.0f, 6000.0f);
    }

    private static int getVideoBitrateSoll(int breite, int hoehe) {
        return FDatei.getVideoBitrate(breite, hoehe, 350.0f);
    }

    public static int[] getVideoDimensionAndBitrate(String videoName) {
        String[] teile;
        String[] tags;
        FFile video = new FFile(videoName);
        int[] dimBitrate = new int[3];
        if (video.isVideo() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ImageWidth", "-ImageHeight", "-AvgBitrate#", "-T", video.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0 && (teile = tags[0].split("\t")).length > 2) {
            try {
                dimBitrate[0] = Integer.parseInt(teile[0]);
                dimBitrate[1] = Integer.parseInt(teile[1]);
                dimBitrate[2] = Integer.parseInt(teile[2]) / 1024;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dimBitrate;
    }

    public static long getVideoUnknownThumbnailSize(String videoName) {
        String[] tags;
        FFile video = new FFile(videoName);
        long unknownThumbnailSize = 0L;
        if (video.isVideo() && (tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-UnknownThumbnailSize#", "-T", video.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0) {
            try {
                unknownThumbnailSize = Long.parseLong(tags[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return unknownThumbnailSize;
    }

    public static void gpsOrtsdaten2verzeichnisstruktur(String verz, boolean nurTest) {
        FProt.instance().prot("Verzeichnisstruktur wird:\t..../Country/State[/City[/Location]]");
        String[] namen = new String[]{"-Filename", "-Directory", "-XMP:CountryCode", "-XMP:Country", "-XMP:State", "-XMP:City", "-XMP:Location", verz};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "GIF", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
        int i = 0;
        while (i < medien.length) {
            String von = String.valueOf(medien[i][1]) + System.getProperty("file.separator") + medien[i][0];
            String countryCode = medien[i][2];
            String country = medien[i][3];
            String verzRel = "";
            if (!countryCode.isEmpty() && !country.isEmpty()) {
                verzRel = String.valueOf(verzRel) + System.getProperty("file.separator") + country;
                int j = 4;
                while (j <= 6) {
                    if (!medien[i][j].isEmpty()) {
                        verzRel = String.valueOf(verzRel) + System.getProperty("file.separator") + medien[i][j];
                    }
                    ++j;
                }
            }
            if (verzRel.isEmpty()) {
                FProt.instance().prot(String.valueOf(von) + "\that keine gueltigen Ortsdaten");
            } else {
                String nach = String.valueOf(medien[i][1]) + verzRel + System.getProperty("file.separator") + medien[i][0];
                if (medien[i][1].endsWith(verzRel)) {
                    FProt.instance().prot(String.valueOf(von) + "\tist bereits im Zielverzeichnis");
                } else {
                    FProt.instance().prot(String.valueOf(von) + (nurTest ? "\tto move\t" : "\tmove to\t") + nach);
                    if (!nurTest && von.compareTo(nach) != 0) {
                        File nachVerz = new File(medien[i][1], verzRel);
                        if (!nachVerz.exists()) {
                            nachVerz.mkdirs();
                        }
                        new FFile(von).renameTo(nach);
                    }
                }
            }
            ++i;
        }
    }

    public static boolean hasAudio(String videoName) {
        FFile video = new FFile(videoName);
        boolean hasAudio = false;
        if (video.isVideo()) {
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-audio*", "-T", video.getAbsolutePath()}), 5);
            hasAudio = tags.length > 0 && tags[0].length() > 0;
        }
        return hasAudio;
    }

    public static synchronized FDatei instance() {
        if (instance == null) {
            instance = new FDatei();
        }
        return instance;
    }

    public static int iOSMediathekCopy(String vonVerz, String zielVerz, boolean nurAktuelleMedien) {
        int anzWorkedOnMedien = 0;
        int anzErrorOnMedien = 0;
        int anzUntouchedMedien = 0;
        if (!new File(zielVerz).exists() || !new File(zielVerz).isDirectory()) {
            FProt.instance().prot(String.valueOf(zielVerz) + " nicht vorhanden oder kein Verzeichnis");
        } else {
            String[][] medien;
            String datumRelevantOriginalFormat = "";
            String letztesJahr = "" + (new FGregorianCalendar(System.currentTimeMillis()).get(1) - 1);
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            SimpleDateFormat dateTimeFormatLong = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            ArrayList<String> parm = new ArrayList<String>();
            String[] namen = new String[]{"-Filename", "-Basename", "-FileTypeExtension", "-Directory", "-SubSecDateTimeOriginal", "-SubSecCreateDate", "-DateTimeOriginal", "-CreateDate", "-DateTimeCreated", "-xmp:DateCreated", "-DigitalCreationDateTime", "-FileCreateDate", "-RawFileName", "-Make", "-Model", "-ImageSize", "-UserComment", "-SerialNumber", vonVerz};
            String[][] stringArray = medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-R", "-ext", "JPEG", "-ext", "HEIC", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
            int n = medien.length;
            int n2 = 0;
            while (n2 < n) {
                String datumRelevant;
                String[] element = stringArray[n2];
                String dateiname = String.valueOf(FDatei.checkFileSeperator(element[3], true)) + element[0];
                boolean dateinameImDatumformat = false;
                try {
                    boolean bl = dateinameImDatumformat = dateTimeFormat.parse(element[1]).getTime() > 0L;
                    if (!dateinameImDatumformat) {
                        boolean bl2 = dateinameImDatumformat = dateTimeFormatLong.parse(element[1]).getTime() > 0L;
                        if (!dateinameImDatumformat && element[1].length() > 19) {
                            dateinameImDatumformat = dateTimeFormatLong.parse(element[1].substring(0, 19)).getTime() > 0L;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dateinameImDatumformat) {
                    datumRelevant = element[1];
                } else {
                    String datumMitMillisekunden = "";
                    boolean datumFound = false;
                    int j = 4;
                    while (j < 6) {
                        if (element[j].length() > 22) {
                            datumMitMillisekunden = element[j].substring(0, 23);
                            datumFound = true;
                        }
                        if (datumFound) break;
                        ++j;
                    }
                    String datum = "";
                    datumFound = false;
                    j = 6;
                    while (j < 12) {
                        if (element[j].length() > 18 && !element[j].startsWith("0000:00:00 00:00:00")) {
                            datum = element[j].substring(0, 19);
                            datumFound = true;
                        }
                        if (datumFound) break;
                        ++j;
                    }
                    datumRelevantOriginalFormat = datumMitMillisekunden.isEmpty() ? (datum.isEmpty() ? "" : datum) : datumMitMillisekunden;
                    datumRelevant = datumRelevantOriginalFormat.replaceAll(":", "-").replaceAll(" ", "-");
                    FProt.instance().prot(String.valueOf(dateiname) + "\t" + datumRelevant + "\t" + datum + "\t" + datumMitMillisekunden, 2);
                }
                if (datumRelevant.isEmpty()) {
                    FProt.instance().prot(String.valueOf(dateiname) + " kein relevantes Datum feststellbar");
                    ++anzErrorOnMedien;
                } else {
                    String datumRelevantJahr = datumRelevant.substring(0, 4);
                    String datumRelevantDatum = datumRelevant.substring(0, 10);
                    if (element[13].compareToIgnoreCase("Canon") == 0 && element[14].compareToIgnoreCase("Canon EOS 400D DIGITAL") == 0) {
                        FProt.instance().prot(String.valueOf(dateiname) + " von Canon EOS 400D schon gesichert", 2);
                        ++anzUntouchedMedien;
                    } else if (nurAktuelleMedien && datumRelevantJahr.compareTo(letztesJahr) < 0) {
                        FProt.instance().prot(String.valueOf(dateiname) + " aelter als Vorjahr " + datumRelevantDatum, 2);
                        ++anzUntouchedMedien;
                    } else {
                        boolean copyNotwendig = false;
                        String dateinameNeu = String.valueOf(FDatei.checkFileSeperator(zielVerz, true)) + datumRelevantJahr + System.getProperty("file.separator") + datumRelevant + "." + element[2];
                        FFile dateiFile = new FFile(dateiname);
                        FFile dateiNeuFile = new FFile(dateinameNeu);
                        if (dateiNeuFile.exists()) {
                            if (dateiNeuFile.isPicture()) {
                                copyNotwendig = !FBild.vergleicheImages(dateiname, dateinameNeu);
                            } else {
                                boolean bl = copyNotwendig = dateiFile.length() != dateiNeuFile.length() || dateiFile.lastModified() != dateiNeuFile.lastModified();
                            }
                            if (copyNotwendig) {
                                dateinameNeu = String.valueOf(FDatei.checkFileSeperator(zielVerz, true)) + datumRelevantJahr + System.getProperty("file.separator") + datumRelevant + "-" + element[1] + "." + element[2];
                                copyNotwendig = dateiFile.length() != new FFile(dateinameNeu).length() || dateiFile.lastModified() != new FFile(dateinameNeu).lastModified();
                            }
                            FProt.instance().prot(String.valueOf(dateinameNeu) + " vorhanden, " + (copyNotwendig ? "" : "keine ") + "Aktion notwendig", copyNotwendig ? 0 : 2);
                        } else {
                            copyNotwendig = true;
                        }
                        parm.clear();
                        if (element[7].isEmpty()) {
                            parm.add(String.valueOf(namen[7]) + "=" + datumRelevantOriginalFormat);
                        }
                        if (element[12].isEmpty()) {
                            parm.add(String.valueOf(namen[12]) + "=" + element[0]);
                        }
                        if (element[13].isEmpty() || element[14].isEmpty()) {
                            if (element[16].compareToIgnoreCase("Screenshot") == 0) {
                                parm.add(String.valueOf(namen[13]) + "=Apple");
                                parm.add(String.valueOf(namen[14]) + "=" + (element[15].compareTo("2048x1536") == 0 || element[15].compareTo("1536x2048") == 0 ? "iPad 4" : "iPhone " + (datumRelevantDatum.compareTo("2018-02-09") < 0 ? "5S" : "SE")));
                            }
                            if (element[2].compareToIgnoreCase("MP4") == 0 && element[17].isEmpty()) {
                                parm.add(String.valueOf(namen[17]) + "=DownloadFromWeb");
                            }
                        }
                        if (element[17].isEmpty() && element[16].compareToIgnoreCase("Screenshot") == 0) {
                            parm.add(String.valueOf(namen[17]) + "=Screenshot");
                        }
                        if (parm.size() > 0) {
                            FProt.instance().prot("Change " + dateiname + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                            parm.add(dateiname);
                            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                        }
                        if (copyNotwendig) {
                            dateiFile.copyFile(dateinameNeu, true);
                            FProt.instance().prot("Copy: " + dateiname + " -> " + dateinameNeu);
                            ++anzWorkedOnMedien;
                        } else {
                            ++anzUntouchedMedien;
                        }
                    }
                }
                ++n2;
            }
            FProt.instance().prot(String.valueOf(vonVerz) + ": " + medien.length + " Medien" + ", " + anzWorkedOnMedien + " Medien kopiert, " + anzUntouchedMedien + " Medien O.K., " + anzErrorOnMedien + " Medien mit Problemen");
        }
        return anzWorkedOnMedien;
    }

    private static boolean isCopyStattRecode() {
        return copyStattRecode;
    }

    public static String[] makeKontaktAbzuege(String verz, int breite, int hoehe, int anzahlZeilen) {
        return FDatei.makeKontaktAbzuege(verz, breite, hoehe, anzahlZeilen, 99, false);
    }

    public static String[] makeKontaktAbzuege(String verzIn, int breite, int hoehe, int anzahlZeilen, int anzahlMaxKontaktAbzugIn, boolean nameAufImage) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String verzOutput = String.valueOf(FDatei.checkFileSeperator(verzIn, true)) + "_Kontaktabzuege/";
        FDatei.checkDatei(verzOutput, 'V', 'W', "Kontaktabzuege");
        int anzahlMaxKontaktAbzug = FMath.checkRange(anzahlMaxKontaktAbzugIn, 1, 99);
        ArrayList<String> kontaktAbzug = new ArrayList<String>();
        int hoeheThumb = Math.round((float)hoehe * 1.0f / (float)anzahlZeilen);
        int breiteThumb = 0;
        int breiteRest = 0;
        int zeile = 1;
        int anzahlThumbs = 0;
        int anzahlThumbsMax = 0;
        int breiteThumbsGesamt = 0;
        int pointsize = Math.round((float)hoeheThumb * 1.0f / 15.0f);
        int strokewidth = Math.round((float)pointsize * 1.0f / 7.5f);
        int annotate = pointsize / 4;
        String name = "";
        String nummer = "";
        String nameThumbStamm = "_Thumb_";
        String nameThumb = "";
        String nameThumbAlt = "";
        String nameKontaktAbzugStamm = "_KontaktAbzug_";
        String nameKontaktAbzug = "";
        int anzahlImages = 0;
        ArrayList<String> append = new ArrayList<String>();
        append.add("(");
        FFile verzFile = new FFile(verz);
        verzFile.setAuswahlNurBilder(true);
        verzFile.setAuswahlTiefe(0);
        verzFile.setAusgabeNurNamen(true);
        String[] liste = verzFile.listjfi();
        ArrayList<String> parm = new ArrayList<String>();
        String[] stringArray = liste;
        int n = liste.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (kontaktAbzug.size() >= anzahlMaxKontaktAbzug) break;
            name = element.substring(verz.length());
            if (!name.startsWith("_KontaktAbzug_") && !name.startsWith("_Thumb_")) {
                ++anzahlImages;
                anzahlThumbsMax = Math.max(anzahlThumbsMax, ++anzahlThumbs);
                nameThumb = String.valueOf(verzOutput) + "_Thumb_" + anzahlThumbs + ".jpg";
                parm.clear();
                parm.add(element);
                parm.add("-thumbnail");
                parm.add(String.valueOf(breite) + "x" + hoeheThumb);
                if (nameAufImage) {
                    nummer = FDatei.getNummer(name);
                    if (nummer.isEmpty()) {
                        nummer = name;
                    }
                    parm.add("-gravity");
                    parm.add("Southwest");
                    parm.add("-font");
                    parm.add(Futi.getBenutzerWert("ExiftoolTAHOMA"));
                    parm.add("-pointsize");
                    parm.add("" + pointsize);
                    parm.add("-fill");
                    parm.add("black");
                    parm.add("-stroke");
                    parm.add("#000C");
                    parm.add("-strokewidth");
                    parm.add("" + strokewidth);
                    parm.add("-annotate");
                    parm.add("+" + annotate + "+" + annotate);
                    parm.add(nummer);
                    parm.add("-stroke");
                    parm.add("none");
                    parm.add("-fill");
                    parm.add("white");
                    parm.add("-annotate");
                    parm.add("+" + annotate + "+" + annotate);
                    parm.add(nummer);
                }
                parm.add(nameThumb);
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), FString.arrayListToStringArray(parm), 5);
                breiteThumb = FDatei.getImageDimension(nameThumb)[0];
                breiteRest = breite - breiteThumbsGesamt;
                if (breiteRest < breiteThumb) {
                    boolean imageWiederholen;
                    boolean bl = imageWiederholen = breiteRest > 0 && (float)breiteRest <= (float)breiteThumb * 0.75f;
                    if (breiteRest > 0) {
                        nameThumbAlt = nameThumb;
                        anzahlThumbsMax = Math.max(anzahlThumbsMax, ++anzahlThumbs);
                        nameThumb = String.valueOf(verzOutput) + "_Thumb_" + anzahlThumbs + ".jpg";
                        new FFile(nameThumb).deleteIfExits();
                        new FFile(nameThumbAlt).renameTo(nameThumb);
                        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{nameThumb, "-crop", String.valueOf(breiteRest) + "x" + hoeheThumb + "+0+0", nameThumbAlt}, 5);
                        append.add(nameThumbAlt);
                        breiteThumbsGesamt += breiteRest;
                        if (!imageWiederholen) {
                            --anzahlThumbs;
                        }
                    }
                    append.add("+append");
                    append.add(")");
                    if (++zeile > anzahlZeilen) {
                        append.add("-append");
                        nameKontaktAbzug = String.valueOf(verzOutput) + "_KontaktAbzug_" + (kontaktAbzug.size() + 1) + ".jpg";
                        append.add(nameKontaktAbzug);
                        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), FString.arrayListToStringArray(append), FDatei.getMsgLevelMedien());
                        FDatei.makeThumbnail(nameKontaktAbzug);
                        append.clear();
                        kontaktAbzug.add(nameKontaktAbzug.substring(verzOutput.length()));
                        nameThumbAlt = nameThumb;
                        anzahlThumbs = 1;
                        nameThumb = String.valueOf(verzOutput) + "_Thumb_" + anzahlThumbs + ".jpg";
                        new FFile(nameThumb).deleteIfExits();
                        new FFile(nameThumbAlt).renameTo(nameThumb);
                        zeile = 1;
                    }
                    breiteThumbsGesamt = 0;
                    if (zeile <= anzahlZeilen) {
                        append.add("(");
                    }
                    if (imageWiederholen) {
                        append.add(nameThumb);
                        breiteThumbsGesamt += breiteThumb;
                    }
                } else {
                    append.add(nameThumb);
                    breiteThumbsGesamt += breiteThumb;
                }
            }
            ++n2;
        }
        if (anzahlThumbs > 0) {
            if (((String)append.get(append.size() - 1)).compareToIgnoreCase(")") != 0) {
                append.add("+append");
                append.add(")");
            }
            append.add("-append");
            nameKontaktAbzug = String.valueOf(verzOutput) + "_KontaktAbzug_" + (kontaktAbzug.size() + 1) + ".jpg";
            append.add(nameKontaktAbzug);
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), FString.arrayListToStringArray(append), FDatei.getMsgLevelMedien());
            FDatei.makeThumbnail(nameKontaktAbzug);
            kontaktAbzug.add(nameKontaktAbzug.substring(verzOutput.length()));
        }
        int i = 0;
        while (i <= anzahlThumbsMax) {
            new FFile(String.valueOf(verzOutput) + "_Thumb_" + i + ".jpg").deleteIfExits();
            ++i;
        }
        i = kontaktAbzug.size() + 1;
        while (i <= 99) {
            new FFile(String.valueOf(verzOutput) + "_KontaktAbzug_" + i + ".jpg").deleteIfExits();
            new FFile(String.valueOf(verzOutput) + "_KontaktAbzug_" + "0" + i + ".jpg").deleteIfExits();
            ++i;
        }
        if (kontaktAbzug.size() > 9) {
            int i2 = 0;
            while (i2 < 9) {
                String nameAlt = (String)kontaktAbzug.get(i2);
                String nameNeu = nameAlt.replaceAll("_KontaktAbzug_", "_KontaktAbzug_0");
                new FFile(String.valueOf(verzOutput) + nameNeu).deleteIfExits();
                if (new FFile(String.valueOf(verzOutput) + nameAlt).renameTo(String.valueOf(verzOutput) + nameNeu).compareTo(String.valueOf(verzOutput) + nameNeu) == 0) {
                    kontaktAbzug.set(i2, nameNeu);
                }
                ++i2;
            }
        }
        FProt.instance().prot(String.valueOf(verzIn) + ": " + kontaktAbzug.size() + " Kontaktabzuege fuer " + anzahlImages + " Bilder erstellt");
        return FString.arrayListToStringArray(kontaktAbzug);
    }

    private static String makePoster(String dateiname, String posterNameIn, int anzTeileIn) {
        return FDatei.makePoster(dateiname, posterNameIn, anzTeileIn, -1, true);
    }

    private static String makePoster(String dateiname, String posterNameIn, int anzTeileIn, int size, boolean writeExifDaten) {
        String posterName = "";
        FFile medium = new FFile(dateiname);
        if (medium.isVideo()) {
            float dauer = 0.0f;
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Duration#", "-T", medium.getAbsolutePath()}), 5);
            if (tags.length > 0 && tags[0].length() > 0) {
                try {
                    dauer = Float.parseFloat(tags[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dauer != 0.0f) {
                FFile work;
                ArrayList<String> append = new ArrayList<String>();
                ArrayList<String> times = new ArrayList<String>();
                FGregorianCalendar zpunkt = new FGregorianCalendar();
                int anzTeile = FMath.checkRange(anzTeileIn, 2, 5);
                long abstandThumbs = (long)(dauer * 1000.0f) / (long)(anzTeile * anzTeile);
                posterName = posterNameIn != null && posterNameIn.length() > 0 ? posterNameIn : String.valueOf(dateinamenTeile.getPfadPlusName()) + "_poster.jpg";
                FFile output = new FFile(posterName);
                FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Poster-File");
                output.deleteIfExits();
                int z = 1;
                while (z <= anzTeile) {
                    append.add("(");
                    int s = 1;
                    while (s <= anzTeile) {
                        work = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + "_Thumb_Zeile_" + z + "_Reihe_" + s + ".jpg");
                        work.deleteIfExits();
                        zpunkt.setTimeInMillis((long)((z - 1) * anzTeile + s) * abstandThumbs - abstandThumbs / 2L);
                        times.add(zpunkt.toGermanFormat('m'));
                        FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-noaccurate_seek", "-ss", zpunkt.toGermanFormat('m'), "-i", medium.getAbsolutePath(), "-vframes", "1", "-vf", "scale=iw/" + anzTeile + ":ih/" + anzTeile, work.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                        append.add(work.getAbsolutePath());
                        ++s;
                    }
                    append.add("+append");
                    append.add(")");
                    ++z;
                }
                append.add("-append");
                append.add(output.getAbsolutePath());
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), FString.arrayListToStringArray(append), FDatei.getMsgLevelMedien());
                if (size > 0) {
                    FBefehl.aufrufBefehl("mogrify", new String[]{"-thumbnail", String.valueOf(size) + "x" + size + ">", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                }
                if (writeExifDaten) {
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-tagsFromFile", medium.getAbsolutePath(), "-all:all", "-overwrite_original_in_place", output.getAbsolutePath()}), 5);
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-UserComment=Poster by Johann Fischer_" + anzTeile + "x" + anzTeile + "_Positionen " + FString.arrayListToString(times, true, ", "), "-overwrite_original_in_place", output.getAbsolutePath()}), 5);
                }
                int i = 1;
                while (i <= anzTeile) {
                    int j = 1;
                    while (j <= anzTeile) {
                        work = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + "_Thumb_Zeile_" + i + "_Reihe_" + j + ".jpg");
                        work.deleteIfExits();
                        ++j;
                    }
                    ++i;
                }
                FProt.instance().prot("Videoposter " + output.getAbsolutePath() + " " + anzTeile + "x" + anzTeile + " Spalten erstellt", 0);
            } else {
                FProt.instance().prot("Laenge des Videos, " + medium.getAbsolutePath() + " nicht verstellbar", 0);
            }
        } else {
            FProt.instance().prot("Videoposter nicht implementiert, " + medium.getAbsolutePath() + " kein Video", 0);
        }
        return posterName;
    }

    public static void makeThumbnail(String dateiname) {
        FDatei.makeThumbnail(dateiname, null, false, 0, false, 0);
    }

    public static void makeThumbnail(String dateiname, boolean refresh) {
        FDatei.makeThumbnail(dateiname, null, refresh, 0, false, 0);
    }

    public static void makeThumbnail(String dateiname, boolean refresh, boolean copyMDLSComment) {
        FDatei.makeThumbnail(dateiname, null, refresh, 0, copyMDLSComment, 0);
    }

    public static void makeThumbnail(String dateiname, boolean refresh, int anzahlZeilenSpaltenIn, int msgLvl) {
        FDatei.makeThumbnail(dateiname, null, refresh, anzahlZeilenSpaltenIn, false, msgLvl);
    }

    public static void makeThumbnail(String dateiname, int msgLvl) {
        FDatei.makeThumbnail(dateiname, null, false, 0, false, msgLvl);
    }

    public static void makeThumbnail(String dateiname, String postername) {
        FDatei.makeThumbnail(dateiname, postername, false, 0, false, 0);
    }

    public static void makeThumbnail(String dateiname, String postername, boolean refresh, boolean copyMDLSComment) {
        FDatei.makeThumbnail(dateiname, postername, refresh, 0, copyMDLSComment, 0);
    }

    public static void makeThumbnail(String dateiname, String postername, boolean refreshIn, int anzahlZeilenSpaltenIn, boolean copyMDLSComment, int msgLvl) {
        int anzahlZeilenSpalten = anzahlZeilenSpaltenIn == 0 ? FDatei.getAnzahlZeilenSpaltenPoster() : anzahlZeilenSpaltenIn;
        FFile medium = new FFile(dateiname);
        if (!(medium.isPicture() || medium.isVideo() || medium.isMP3File() || medium.isPDF())) {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " ist weder Foto, Video, MP3 noch PDF");
        } else {
            boolean thumbnailCreate;
            FFile thumbnail = new FFile(String.valueOf(FDatei.instance().zerlegeDateiname(dateiname).getPfadPlusName()) + "_" + (medium.isPicture() ? "ThumbnailImage" : "UnknownThumbnail") + ".jpg");
            FFile poster = null;
            FFile inbededThumbnail = new FFile(String.valueOf(FDatei.instance().zerlegeDateiname(dateiname).getPfadPlusName()) + "_inbededThumbnail.jpg");
            boolean thumbnailErstellt = false;
            FFile coverArt = new FFile(String.valueOf(FDatei.instance().zerlegeDateiname(dateiname).getPfadPlusName()) + "_CoverArt.jpg");
            boolean coverArtErstellt = false;
            thumbnail.deleteIfExits();
            String anzahlPreviews = "";
            String xmpLogComment = "";
            String setDescription = "";
            int pixelAnzahl = 0;
            String[] tags = FDatei.getExiftags(medium.getAbsolutePath(), new String[]{"PreviewImageCount", "ImageSize"});
            if (tags[0] != null && tags[0].compareTo("1") >= 0) {
                anzahlPreviews = tags[0];
            }
            if ((tags = tags[1].split("x"))[1].length() > 1) {
                try {
                    pixelAnzahl = Integer.parseInt(tags[0]) * Integer.parseInt(tags[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean createBigThumbnailWithInbededSmallThumbnail = pixelAnzahl > 8000000;
            String anzahlPreviewsSoll = medium.isVideo() ? "2" : "1";
            boolean bl = thumbnailCreate = anzahlPreviews.compareTo(anzahlPreviewsSoll) < 0;
            if (!thumbnailCreate && refreshIn) {
                thumbnailCreate = true;
            }
            if (medium.isVideo() && postername != null && postername.length() > 0 && (poster = new FFile(postername)).exists() && poster.isPicture()) {
                thumbnailCreate = true;
            }
            boolean refreshDescription = false;
            if (medium.isVideo() && Futi.isMac() && copyMDLSComment) {
                String mdlsComment = FString.convertUmlaute(FDatei.getAppleKommentar(medium.getAbsolutePath()));
                String description = FDatei.getDescription(medium.getAbsolutePath());
                if (mdlsComment.length() > 0 && mdlsComment.compareTo(description) != 0) {
                    setDescription = "-Description=" + mdlsComment;
                    refreshDescription = true;
                }
            }
            if (!thumbnailCreate && !refreshDescription) {
                FProt.instance().prot("Thumbnail vorhanden," + (medium.isVideo() && Futi.isMac() && copyMDLSComment ? " Beschreibung korrekt," : "") + " Erneuerung nicht notwendig\t" + medium.getAbsolutePath(), 0);
                thumbnail.deleteIfExits();
                inbededThumbnail.deleteIfExits();
            } else if (medium.isPicture() || medium.isPDF()) {
                if (medium.isPicture()) {
                    if (medium.isGIF()) {
                        FProt.instance().prot("Thumbnail fuer " + medium.getAbsolutePath() + " nicht erstellt, bei Gifs nicht sinnvoll");
                    } else {
                        FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), "-thumbnail", createBigThumbnailWithInbededSmallThumbnail ? "640x640>" : "160x160>", "-background", "white", "-alpha", "remove", "-define", "jpeg:extent=" + (createBigThumbnailWithInbededSmallThumbnail ? "42" : "8") + "kb", thumbnail.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                        if (createBigThumbnailWithInbededSmallThumbnail) {
                            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), "-thumbnail", "160x160>", "-background", "white", "-alpha", "remove", "-define", "jpeg:extent=8kb", inbededThumbnail.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-thumbnailimage<=" + inbededThumbnail.getAbsolutePath(), "-overwrite_original_in_place", thumbnail.getAbsolutePath()}), 5);
                            inbededThumbnail.delete();
                        }
                    }
                } else {
                    FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{String.valueOf(medium.getAbsolutePath()) + "[0]", "-thumbnail", "300x400>", "-background", "white", "-alpha", "remove", "-define", "jpeg:extent=20kb", thumbnail.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                }
                if (thumbnail.exists()) {
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-thumbnailimage<=" + thumbnail.getAbsolutePath(), "-ThumbnailImageContainsSmallThumbnailOriginal=" + (createBigThumbnailWithInbededSmallThumbnail ? "1" : ""), "-overwrite_original_in_place", medium.getAbsolutePath()}), 5);
                    thumbnail.delete();
                    FProt.instance().prot("Thumbnail fuer " + medium.getAbsolutePath() + " erstellt", msgLvl);
                }
            } else if (medium.isVideo()) {
                if (thumbnailCreate) {
                    boolean bl2 = coverArtErstellt = FDatei.makePoster(medium.getAbsolutePath(), coverArt.getAbsolutePath(), anzahlZeilenSpalten).compareTo(coverArt.getAbsolutePath()) == 0;
                    if (poster != null) {
                        thumbnail = new FFile(postername);
                        thumbnailErstellt = true;
                    } else {
                        boolean bl3 = thumbnailErstellt = FDatei.makePoster(medium.getAbsolutePath(), thumbnail.getAbsolutePath(), 2, 320, true).compareTo(thumbnail.getAbsolutePath()) == 0;
                    }
                }
                if (thumbnailErstellt || coverArtErstellt || setDescription.length() > 0) {
                    xmpLogComment = coverArtErstellt ? "CoverArt=" + FDatei.getPosterImageDescription(coverArt.getAbsolutePath()) : "";
                    xmpLogComment = String.valueOf(xmpLogComment) + (thumbnailErstellt && postername == null ? String.valueOf(coverArtErstellt ? ", " : "") + "UnknownThumbnail=" + FDatei.getPosterImageDescription(thumbnail.getAbsolutePath()) : "");
                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{thumbnailErstellt ? "-UnknownThumbnail=" : "", thumbnailErstellt ? "-overwrite_original_in_place" : "", thumbnailErstellt ? medium.getAbsolutePath() : "", thumbnailErstellt ? "-execute" : "", coverArtErstellt ? "-CoverArt<=" + coverArt.getAbsolutePath() : "", thumbnailErstellt ? "-ThumbnailImage<=" + thumbnail.getAbsolutePath() : "", "-xmp:LogComment=" + xmpLogComment, setDescription.length() > 0 ? setDescription : "", setDescription.length() > 0 ? "-Title<BaseName" : "", "-overwrite_original_in_place", medium.getAbsolutePath()}), 0);
                    if (postername == null) {
                        thumbnail.delete();
                    }
                    coverArt.delete();
                    if (thumbnailErstellt || coverArtErstellt) {
                        FProt.instance().prot("Preview fuer " + medium.getAbsolutePath() + " erstellt", msgLvl);
                    }
                    if (setDescription.length() > 0) {
                        FProt.instance().prot("Description " + medium.getAbsolutePath() + " erneuert", msgLvl);
                    }
                } else {
                    FProt.instance().prot("Thumbnailerstellung nicht erfolgreich: " + medium.getAbsolutePath(), 0);
                }
            } else if (medium.isMP3File()) {
                poster = new FFile(postername != null && postername.length() > 0 ? postername : String.valueOf(FDatei.instance().zerlegeDateiname(dateiname).getPfadPlusName()) + "_picture.jpg");
                if (poster.exists() && poster.isPicture()) {
                    FBefehl.aufrufBefehl("eyed3", new String[]{"--add-image", String.valueOf(poster.getAbsolutePath()) + ":FRONT_COVER", medium.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                } else {
                    FProt.instance().prot("Poster " + poster.getAbsolutePath() + " f\u00fcr " + medium.getAbsolutePath() + " nicht vorhanden, kein Thumbnail (Cover) erstellt", 0);
                }
            } else {
                FProt.instance().prot("Thumbnailerstellung nicht implementiert, " + medium.getAbsolutePath() + " kein Foto, Video oder MP3", 0);
            }
        }
    }

    public static void makeThumbnailVerzeichnis(String name) {
        FFile verz = new FFile(name);
        if (verz.isDirectory()) {
            String[] file;
            verz.setAusgabeNurNamen(true);
            String[] stringArray = file = verz.listjfi();
            int n = file.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                FDatei.makeThumbnail(element, false, true);
                ++n2;
            }
        } else {
            FDatei.makeThumbnail(name, false, true);
        }
    }

    private static void nachbereitenVideo(String altName, String neuName, boolean overwriteOriginal, boolean refreshThumbnail) {
        FFile alt = new FFile(altName);
        FFile neu = new FFile(neuName);
        float dauerAlt = 0.0f;
        float dauerNeu = 0.0f;
        boolean dauerIdentisch = false;
        if (alt.isVideo() && neu.isVideo()) {
            if (overwriteOriginal) {
                String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Duration#", "-T", alt.getAbsolutePath()}), 5);
                if (tags.length > 0 && tags[0].length() > 0) {
                    try {
                        dauerAlt = Float.parseFloat(tags[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Duration#", "-T", neu.getAbsolutePath()}), 5)).length > 0 && tags[0].length() > 0) {
                    try {
                        dauerNeu = Float.parseFloat(tags[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dauerIdentisch = (double)dauerAlt > 0.0 && (double)dauerNeu > 0.0 && (double)dauerNeu == FMath.checkRange((double)dauerNeu, (double)dauerAlt - 0.1, (double)dauerAlt + 0.1);
            }
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-tagsFromFile", alt.getAbsolutePath(), "--SourceImageHeight", "--SourceImageWidth", "--ImageHeight", "--ImageWidth", "-overwrite_original_in_place", neu.getAbsolutePath()}), 5);
            FDatei.makeThumbnail(neu.getAbsolutePath(), refreshThumbnail, 0, 999);
            if (overwriteOriginal && dauerIdentisch) {
                alt.delete();
                neu.renameTo(altName);
            } else {
                FProt.instance().prot("Video " + alt.getAbsolutePath() + " => " + neu.getAbsolutePath(), 0);
            }
        } else {
            FProt.instance().prot("Nicht beide Dateien, " + alt.getAbsolutePath() + ", " + neu.getAbsolutePath() + " sind Videos", 0);
        }
    }

    public static BufferedReader openBufferedReader(String datei) {
        FProt fProt = FProt.instance();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(datei));
            fProt.prot(String.valueOf(datei) + " O.K.", 1);
        }
        catch (Exception e) {
            fProt.prot(String.valueOf(datei) + " kann nicht gelesen werden ");
        }
        return reader;
    }

    public static BufferedWriter openBufferedWriter(String datei) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(datei));
            FProt.instance().prot(String.valueOf(datei) + " O.K.", 1);
        }
        catch (IOException e) {
            FProt.instance().prot(String.valueOf(datei) + " kann nicht geschrieben werden");
        }
        return writer;
    }

    public static void prepareDownloadedFilm(String videoName) {
        FDatei.prepareDownloadedFilm(videoName, 0);
    }

    public static void prepareDownloadedFilm(String videoName, int useInfoJPG) {
        if (new FFile(videoName).isVideo()) {
            DateinamenTeile teile = FDatei.instance().zerlegeDateiname(videoName);
            File thumbnail = null;
            if (useInfoJPG > 0 && !(thumbnail = new FFile(String.valueOf(teile.getPfad()) + System.getProperty("file.separator") + "_info", String.valueOf(teile.getName()) + ".jpg")).exists() && useInfoJPG > 1) {
                thumbnail = new File(String.valueOf(teile.getPfad()) + System.getProperty("file.separator") + "_info.jpg");
            }
            String baseUrl = "";
            if (thumbnail != null && thumbnail.exists()) {
                FDatei.makeThumbnail(videoName, thumbnail.getAbsolutePath(), false, true);
                baseUrl = FDatei.getExiftag(thumbnail.getAbsolutePath(), "BaseUrl");
            } else {
                FDatei.makeThumbnail(videoName, false, true);
            }
            FDatei.checkAndSetVideoTitleAndDescription(videoName);
            if (baseUrl.isEmpty()) {
                baseUrl = Futi.isVerfuegbarAufFernsehsereien(teile.getName());
            }
            if (Futi.isUrlValid(baseUrl)) {
                FDatei.updateExiftag(videoName, "BaseUrl", baseUrl);
            }
        }
    }

    public static int prepareFotos4Diashow(String verzIn) {
        return FDatei.prepareFotos4Diashow(verzIn, false, false, false);
    }

    public static int prepareFotos4Diashow(String verzIn, boolean test) {
        return FDatei.prepareFotos4Diashow(verzIn, test, false, false);
    }

    public static int prepareFotos4Diashow(String verzIn, boolean test, boolean nurOverview, boolean noOverwrite) {
        String verz = FDatei.checkFileSeperator(verzIn, false);
        int anzChangedMedien = 0;
        if (!new File(verz).isDirectory()) {
            FProt.instance().prot(String.valueOf(verz) + " ist kein Verzeichnis");
        } else {
            String[] namen = new String[]{"-Filename", "-DateTimeOriginal", "-DatePrecision", "-StartingPage", "-EndingPage", "-Album", "-AlbumIfImageDescriptionEmpty", "-Directory", verz};
            String[][] medienAlle = FDatei.clearTags(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
            ArrayList<String[]> medienWork = new ArrayList<String[]>();
            String[][] stringArray = medienAlle;
            int n = medienAlle.length;
            int n2 = 0;
            while (n2 < n) {
                String[] element = stringArray[n2];
                if (element[7].compareToIgnoreCase(verz) == 0) {
                    medienWork.add(element);
                }
                ++n2;
            }
            if (medienWork.size() == 0) {
                FProt.instance().prot(String.valueOf(verz) + " hat keine Medien");
            } else {
                String[][] medien = FString.arrayListToTabelle(medienWork);
                String[][] org = FString.copyTabelle(medien);
                int datePrecision = 0;
                String ersterTag = "9999.99.99";
                String letzterTag = "0000.00.00";
                String[][] stringArray2 = medien;
                int n3 = medien.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] element = stringArray2[n4];
                    try {
                        datePrecision = Math.max(datePrecision, Integer.parseInt(element[2]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (element[1].length() >= 10) {
                        if (ersterTag.compareTo(element[1].substring(0, 10)) > 0) {
                            ersterTag = element[1].substring(0, 10);
                        }
                        if (letzterTag.compareTo(element[1].substring(0, 10)) < 0) {
                            letzterTag = element[1].substring(0, 10);
                        }
                    }
                    ++n4;
                }
                boolean einTag = ersterTag.compareTo(letzterTag) == 0;
                boolean keinGueltigerTag = ersterTag.compareTo("9999.99.99") == 0 || letzterTag.compareTo("0000.00.00") == 0;
                String albumFromDatabase = FDatei.getAlbumFromDatabase(verz);
                String feld1 = "";
                String feld2 = "";
                if (!keinGueltigerTag) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd");
                    FGregorianCalendar zeit1 = new FGregorianCalendar();
                    FGregorianCalendar zeit2 = new FGregorianCalendar();
                    try {
                        zeit1.setTime(dateFormat.parse(ersterTag));
                        zeit2.setTime(dateFormat.parse(letzterTag));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (datePrecision < 2) {
                        if (einTag) {
                            feld1 = zeit1.getWochentag();
                            feld2 = zeit2.toGermanFormat('i');
                        } else {
                            feld1 = zeit1.toGermanFormat('I');
                            feld2 = zeit2.toGermanFormat('I');
                        }
                    } else if (datePrecision == 2) {
                        feld2 = zeit2.getMonat();
                    } else if (datePrecision == 3) {
                        if (zeit1.getJahreszeit().compareTo(zeit2.getJahreszeit()) != 0) {
                            feld1 = zeit1.getJahreszeit();
                        }
                        feld2 = zeit2.getJahreszeit();
                    }
                }
                FProt.instance().prot(String.valueOf(verz) + "\tmax DP\t" + datePrecision + "\t" + ersterTag + (einTag ? "" : " - " + letzterTag) + "\tFelder\t" + feld1 + " - " + feld2 + "\t" + (keinGueltigerTag ? "kein gueltiger Tag " : "") + "\t" + (albumFromDatabase.length() > 0 ? "Album von SQL-DB\t" + albumFromDatabase : ""));
                if (!nurOverview) {
                    int i = 0;
                    while (i < medien.length) {
                        String string = noOverwrite ? (medien[i][3].trim().length() > 0 ? medien[i][3] : feld1) : (medien[i][3] = feld1);
                        String string2 = noOverwrite ? (medien[i][4].trim().length() > 0 ? medien[i][4] : feld2) : (medien[i][4] = feld2);
                        if (albumFromDatabase.length() > 0) {
                            medien[i][5] = noOverwrite ? (medien[i][5].trim().length() > 0 ? medien[i][5] : albumFromDatabase) : albumFromDatabase;
                        }
                        medien[i][6] = "x";
                        ++i;
                    }
                    ArrayList<String> parm = new ArrayList<String>();
                    int i2 = 0;
                    while (i2 < medien.length) {
                        FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
                        FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
                        if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                            FProt.instance().prot("Error in Zeile\t" + i2 + "\t" + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
                        } else {
                            parm.clear();
                            int j = 1;
                            while (j < medien[i2].length) {
                                if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                                    parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                                }
                                ++j;
                            }
                            if (parm.size() > 0) {
                                FProt.instance().prot("Change " + medien[i2][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                                if (!test) {
                                    parm.add(String.valueOf(medien[i2][7]) + System.getProperty("file.separator") + medien[i2][0]);
                                    FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                                }
                                ++anzChangedMedien;
                            }
                        }
                        ++i2;
                    }
                    FProt.instance().prot(String.valueOf(verz) + ": " + medien.length + " Medien, " + anzChangedMedien + (test ? " zu aendernde" : " geaenderte") + " Medien");
                }
            }
        }
        return anzChangedMedien;
    }

    public static void prepareReiseMedien(String verz, int imageSizeIn, int videoSizeIn) {
        String[] medien;
        int imageSize = FMath.checkRange(imageSizeIn, 640, 1920);
        int videoSize = FMath.checkRange(videoSizeIn, 320, 960);
        FFile verzFile = new FFile(verz);
        FFile verzZielFile = new FFile(verz, verzFile.getName());
        FFile verzPosterFile = new FFile(verzZielFile.getAbsolutePath(), "Poster");
        FFile verzPreviewFile = new FFile(verzZielFile.getAbsolutePath(), "Preview");
        String[] tagNames = new String[]{"ImageWidth", "ImageHeight", "Rotation"};
        ArrayList<String> files = new ArrayList<String>();
        verzZielFile.deleteDirectoryIfExist();
        String[] stringArray = medien = verzFile.listFileNames();
        int n = medien.length;
        int n2 = 0;
        while (n2 < n) {
            File posterMediumFile;
            File zielMediumFile;
            String medium = stringArray[n2];
            FFile mediumFile = new FFile(verz, medium);
            String baseName = FDatei.instance().zerlegeDateiname(mediumFile.getAbsolutePath()).getName();
            if (mediumFile.isPicture()) {
                verzPosterFile.mkdirs();
                zielMediumFile = new File(verzZielFile, String.valueOf(baseName) + ".jpg");
                posterMediumFile = new File(verzPosterFile.getAbsolutePath(), String.valueOf(baseName) + ".jpg");
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{mediumFile.getAbsolutePath(), "-resize", String.valueOf(imageSize) + "x" + imageSize + ">", zielMediumFile.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FProt.instance().prot("Foto " + mediumFile.getAbsolutePath() + " auf " + imageSize + " verkleinert und in " + zielMediumFile.getAbsolutePath() + " gespeichert");
                FDatei.drehenNachExif(zielMediumFile.getAbsolutePath());
                FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{zielMediumFile.getAbsolutePath(), "-thumbnail", "160x160>", posterMediumFile.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FProt.instance().prot("Foto " + zielMediumFile.getAbsolutePath() + " als Thumbnail " + imageSize + " verkleinert und in " + posterMediumFile.getAbsolutePath() + " gespeichert");
                files.add(String.valueOf(medium) + "$");
            } else if (mediumFile.isVideo()) {
                verzPreviewFile.mkdirs();
                zielMediumFile = new File(verzZielFile, String.valueOf(baseName) + ".mp4");
                posterMediumFile = new File(verzPosterFile.getAbsolutePath(), String.valueOf(baseName) + ".jpg");
                File previewMediumFile = new File(verzPreviewFile.getAbsolutePath(), String.valueOf(baseName) + ".jpg");
                String[] tags = FDatei.getExiftags(mediumFile.getAbsolutePath(), tagNames);
                int breiteIst = 0;
                int hoeheIst = 0;
                int rotation = -1;
                try {
                    if (tags.length > 0 && tags[0].length() > 0) {
                        breiteIst = Integer.parseInt(tags[0]);
                    }
                    if (tags.length > 1 && tags[1].length() > 0) {
                        hoeheIst = Integer.parseInt(tags[1]);
                    }
                    if (tags.length > 2 && tags[2].length() > 0) {
                        rotation = Integer.parseInt(tags[2]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (breiteIst == 0 || hoeheIst == 0 || rotation < 0) {
                    FProt.instance().prot("Hoehe, Breite oder Rotation von " + medium + " nicht feststellbar, keine Verarbeitung");
                } else {
                    int hoehe;
                    int breite;
                    if (rotation != 0) {
                        FDatei.updateExiftag(mediumFile.getAbsolutePath(), "Rotation", "0");
                    }
                    if (breiteIst > hoeheIst) {
                        breite = videoSize;
                        hoehe = (int)FMath.runden((float)videoSize * 1.0f * (float)hoeheIst / (float)breiteIst, 0);
                    } else {
                        hoehe = videoSize;
                        breite = (int)FMath.runden((float)videoSize * 1.0f * (float)breiteIst / (float)hoeheIst, 0);
                    }
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", mediumFile.getAbsolutePath(), "-acodec", "copy", "-vcodec", "libx264", "-b:v", String.valueOf(FDatei.getVideoBitrateSoll(breite, hoehe)) + "k", "-vf", "scale=" + breite + ":" + hoehe, zielMediumFile.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    FProt.instance().prot("Video " + mediumFile.getAbsolutePath() + " auf " + breite + "x" + hoehe + " verkleinert und in " + zielMediumFile.getAbsolutePath() + " gespeichert");
                    FDatei.makePoster(zielMediumFile.getAbsolutePath(), posterMediumFile.getAbsolutePath(), 2, 160, false);
                    FProt.instance().prot("Poster von " + zielMediumFile.getAbsolutePath() + " erstellt und in " + posterMediumFile.getAbsolutePath() + " gespeichert");
                    FDatei.makePoster(zielMediumFile.getAbsolutePath(), previewMediumFile.getAbsolutePath(), 3, -1, false);
                    FProt.instance().prot("Preview von " + zielMediumFile.getAbsolutePath() + " erstellt und in " + previewMediumFile.getAbsolutePath() + " gespeichert");
                    files.add(String.valueOf(medium) + "$");
                }
            }
            ++n2;
        }
        String indexOrgName = Futi.instance().restoreField1Wert("FDatei", "index.php");
        if (indexOrgName.isEmpty()) {
            FProt.instance().prot("Parameterdatei ../FDatei/index.php.txt nicht gefunden");
        } else {
            FFile indexFileOrg = new FFile(indexOrgName);
            if (!indexFileOrg.exists()) {
                FProt.instance().prot(String.valueOf(indexOrgName) + " nicht gefunden");
            } else {
                File indexFile = new File(verzZielFile.getAbsoluteFile(), "index.php");
                indexFileOrg.copyFile(indexFile.getAbsolutePath());
            }
        }
    }

    public static void prepareVideosAndGifs4Diashow(String verzIn) {
        String element;
        String[] verzListe;
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String textUnterVerz = "Video_Poster";
        String textUnterVerzIndex = String.valueOf(System.getProperty("file.separator")) + "Video_Poster_fuer_Index_(muessen_im_Diashow_Verzeichnis_sein)";
        String textUnterVerzPreview = String.valueOf(System.getProperty("file.separator")) + "Video_Poster_fuer_Preview";
        String unknownThumbnail = "_UnknownThumbnail.jpg";
        String coverArt = "_CoverArt.jpg";
        new File(String.valueOf(verz) + "Video_Poster" + textUnterVerzIndex).mkdirs();
        new File(String.valueOf(verz) + "Video_Poster" + textUnterVerzPreview).mkdirs();
        String[] stringArray = verzListe = new FFile(String.valueOf(verz) + "Video_Poster").listFileNames('b', true);
        int n = verzListe.length;
        int n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            new FFile(String.valueOf(verz) + "Video_Poster", element).delete();
            ++n2;
        }
        stringArray = verzListe = new FFile(verz).listFileNames('m', false);
        n = verzListe.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            File video = new File(verz, element);
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", "%d/Video_Poster/%f_%t%-c.%s", "-preview:all", video.getAbsolutePath()}), 5);
            ++n2;
        }
        stringArray = verzListe = new FFile(String.valueOf(verz) + "Video_Poster").listFileNames('b', false);
        n = verzListe.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            FFile preview = new FFile(String.valueOf(verz) + "Video_Poster", element);
            if (element.endsWith("_UnknownThumbnail.jpg")) {
                preview.renameTo(String.valueOf(verz) + "Video_Poster" + textUnterVerzIndex, String.valueOf(element.substring(0, element.length() - "_UnknownThumbnail.jpg".length())) + "_video_poster.jpg");
            } else if (element.endsWith("_CoverArt.jpg")) {
                preview.renameTo(String.valueOf(verz) + "Video_Poster" + textUnterVerzPreview, String.valueOf(element.substring(0, element.length() - "_CoverArt.jpg".length())) + "_video_poster.jpg");
            }
            ++n2;
        }
        String[] namen = new String[]{"-Basename", "-xmp:ImageDescription", "-Filename", "-Duration#", verz};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "MP4"}, namen)), 5), true, true), namen.length, true));
        if (medien.length > 0) {
            int i = 0;
            while (i < medien.length) {
                double duration = Double.parseDouble(medien[i][3]);
                medien[i][3] = String.valueOf(FMath.runden(duration, 0));
                medien[i][3] = medien[i][3].substring(0, medien[i][3].length() - 2);
                ++i;
            }
            new FFile(verz, "_videos_Input.txt").StringArrayToInhalt(FString.convertTabelleToStringArray(medien));
        }
        if ((medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "GIF"}, namen)), 5), true, true), namen.length, true))).length > 0) {
            int i = 0;
            while (i < medien.length) {
                double duration = Double.parseDouble(medien[i][3]);
                medien[i][3] = String.valueOf(FMath.runden(duration, 0));
                medien[i][3] = medien[i][3].substring(0, medien[i][3].length() - 2);
                ++i;
            }
            new FFile(verz, "_gifs.txt").StringArrayToInhalt(FString.convertTabelleToStringArray(medien));
        }
    }

    public static String pruefenPfadname(String Pfad, boolean letzte_Stelle_Fileseperator) {
        return FDatei.pruefenPfadname(Pfad, 0, letzte_Stelle_Fileseperator);
    }

    public static String pruefenPfadname(String Pfad, int pruefen_ab_stelle_in, boolean letzte_Stelle_Fileseperator) {
        int pruefen_ab_stelle = pruefen_ab_stelle_in;
        String Pfad_geprueft = Pfad;
        if (pruefen_ab_stelle < 2 && Pfad.length() > 3 && (Pfad.substring(1).startsWith(System.getProperty("file.separator")) || Pfad.substring(1).startsWith(":" + System.getProperty("file.separator")))) {
            pruefen_ab_stelle = 3;
        }
        Pfad_geprueft = String.valueOf(Pfad.substring(0, pruefen_ab_stelle)) + Pfad.substring(pruefen_ab_stelle).replace(":*?\"<>|", "_______");
        return FDatei.checkFileSeperator(Pfad_geprueft, letzte_Stelle_Fileseperator);
    }

    public static boolean reduceImageFilesize(String dateiname, int faktorIn, String relVerzOutput, boolean overwriteOriginalIn) {
        boolean overwriteOriginal;
        boolean resizeToDo = false;
        FFile medium = new FFile(dateiname);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (medium.isPicture()) {
            int prozent = FMath.checkRange(faktorIn, 10, 90);
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_reduce_to_" + prozent + "_Proz" : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto Reduce Filesize");
            output.deleteIfExits();
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), "-alpha", "remove", "-define", "jpeg:extent=" + medium.length() * (long)prozent / 100L, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf " + prozent + "% verkleinert", FDatei.getMsgLevelMedien());
            if (overwriteOriginal) {
                medium.delete();
                output.renameTo(dateiname);
            }
        } else {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Foto", 0);
        }
        return false;
    }

    public static int removeTimeKorrektur(String medium) {
        int anzChangedMedien = 0;
        String verz = FDatei.checkFileSeperator(FDatei.instance().zerlegeDateiname(medium).getPfad(), true);
        if (new File(medium).isDirectory()) {
            verz = FDatei.checkFileSeperator(medium, true);
        }
        String[] namen = new String[]{"-Filename", "-DateTimeOriginal", "-CreateDate", "-CreationDate", "-MediaCreateDate", "-MediaModifyDate", "-TrackCreateDate", "-TrackModifyDate", "-ModifyDate", medium};
        String[][] medien = FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true);
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            int j = 1;
            while (j < medien[i].length) {
                if (medien[i][j].length() > 24 && medien[i][j].charAt(10) == ' ') {
                    medien[i][j] = medien[i][j].substring(0, 19);
                }
                ++j;
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            parm.clear();
            int j = 1;
            while (j < medien[i2].length) {
                if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                    parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                }
                ++j;
            }
            if (parm.size() > 0) {
                FProt.instance().prot("Change " + medien[i2][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                parm.add(String.valueOf(verz) + medien[i2][0]);
                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                ++anzChangedMedien;
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(medium) + ": " + medien.length + " Medien, " + anzChangedMedien + " geaenderte Medien");
        return anzChangedMedien;
    }

    public static void removeTimeKorrekturVerzeichnis(String name) {
        FFile verz = new FFile(name);
        if (verz.isDirectory()) {
            String[] file;
            verz.setAusgabeNurNamen(true);
            verz.setAusgabeVerzeichnisse(true);
            String[] stringArray = file = verz.listjfi();
            int n = file.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                FDatei.removeTimeKorrektur(element);
                ++n2;
            }
        } else {
            FDatei.removeTimeKorrektur(name);
        }
    }

    public static void renameDateien(String DirName, String Extent, String Endung_alt, String Endung_neu, int VerschiebenUm, boolean Test) {
        File dir;
        int l = Endung_alt.length() + 1 + Extent.length() - VerschiebenUm;
        if (l < 0) {
            l = 0;
        }
        if ((dir = new File(DirName)).isDirectory()) {
            String[] file = dir.list();
            int i = 0;
            while (i < file.length) {
                if (file[i].endsWith(Extent) && file[i].endsWith(String.valueOf(Endung_alt) + "." + Extent)) {
                    String Name_neu = l >= file[i].length() ? String.valueOf(Endung_neu) + "." + Extent : String.valueOf(file[i].substring(0, file[i].length() - l)) + Endung_neu + "." + Extent;
                    File file_org = new File(dir, file[i]);
                    File file_rename = new File(dir, Name_neu);
                    if (Test) {
                        System.out.println("Rename '" + file[i] + "' in '" + Name_neu + "' ausgewaehlt");
                    } else if (file_org.renameTo(file_rename)) {
                        System.out.println("Rename '" + file[i] + "' in '" + Name_neu + "' erfolgreich");
                    } else {
                        System.out.println("Rename '" + file[i] + "' in '" + Name_neu + "' nicht erfolgreich");
                    }
                }
                ++i;
            }
        } else {
            System.err.println(dir + " nicht vorhanden bzw. kein Verzeichnis");
        }
    }

    public static void repairVideoMetadaten(String dateiname, String relVerzOutput) {
        FFile medium = new FFile(dateiname);
        if (!medium.isVideo()) {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Video", 0);
        } else {
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + "_repair_Metadaten" : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput) + System.getProperty("file.separator") + dateinamenTeile.getName() + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Video Repair Metadaten");
            output.deleteIfExits();
            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-c", "copy", "-map_metadata", "0", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
        }
    }

    public static void resize(String dateiname, int faktorIn, int sizeIn, boolean overwriteOriginal) {
        FDatei.resize(dateiname, faktorIn, sizeIn, "", overwriteOriginal, false);
    }

    public static boolean resize(String dateiname, int faktorIn, int sizeIn, boolean overwriteOriginal, boolean checkOnly) {
        return FDatei.resize(dateiname, faktorIn, sizeIn, "", overwriteOriginal, checkOnly);
    }

    public static void resize(String dateiname, int faktorIn, int sizeIn, String relVerzOutput, boolean overwriteOriginal) {
        FDatei.resize(dateiname, faktorIn, sizeIn, relVerzOutput, overwriteOriginal, false);
    }

    public static boolean resize(String dateiname, int faktorIn, int sizeIn, String relVerzOutput, boolean overwriteOriginalIn, boolean checkOnly) {
        boolean overwriteOriginal;
        boolean resizeToDo = false;
        FFile medium = new FFile(dateiname);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (medium.isVideo()) {
            int[] dimBitrate = FDatei.getVideoDimensionAndBitrate(medium.getAbsolutePath());
            int breite = dimBitrate[0];
            int hoehe = dimBitrate[1];
            String groesseIst = String.valueOf(breite) + "x" + hoehe;
            int bitrateIst = dimBitrate[2];
            int bitrateSoll = 0;
            float faktor = FMath.checkRange((float)faktorIn / 100.0f, 0.05f, 1.0f);
            String verkleinerung = "";
            if (faktorIn != 100 && breite > 0 && hoehe > 0) {
                float f = faktor = faktorIn != 0 ? faktor : (float)sizeIn * 1.0f / (float)Math.max(breite, hoehe);
                if (faktor < 1.0f) {
                    breite = FMath.checkRange(Math.round((float)breite * faktor), 160, 1920);
                    hoehe = FMath.checkRange(Math.round((float)hoehe * faktor), 160, 1920);
                }
            }
            if (breite > 0 && hoehe > 0) {
                breite = FMath.abrundenAufGeradeZahl(breite);
                hoehe = FMath.abrundenAufGeradeZahl(hoehe);
                String groesseSoll = String.valueOf(breite) + "x" + hoehe;
                bitrateSoll = FDatei.getVideoBitrateSoll(breite, hoehe);
                resizeToDo = (float)bitrateIst > (float)bitrateSoll * 1.1f;
                float einsparProzent = Math.max((1.0f - (float)bitrateSoll * 1.0f / (float)bitrateIst) * 100.0f, 0.0f);
                float sizeVideoMB = (float)medium.length() / 1048576.0f;
                float einsparMB = einsparProzent * sizeVideoMB / 100.0f;
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                nf.setMinimumFractionDigits(1);
                if (checkOnly) {
                    FProt.instance().prot(String.valueOf(resizeToDo ? "resize" : "ok") + "\t" + nf.format(einsparProzent) + "\t" + "%" + "\t" + nf.format(sizeVideoMB) + "\t" + "MB" + "\t" + nf.format(einsparMB) + "\t" + "MB" + "\t" + medium.getAbsolutePath() + "\tBitrate Ist Soll\t" + bitrateIst + "\t" + bitrateSoll + (groesseIst.compareTo(groesseSoll) == 0 ? "" : "\t" + groesseIst + "\t" + groesseSoll), resizeToDo ? 0 : 2);
                } else {
                    if (!resizeToDo) {
                        FProt.instance().prot("Bitrate: " + bitrateIst + "k < " + bitrateSoll + "k (Bitrate-Soll * 110% ) => keine Verkleinerung notwendig: " + medium.getAbsolutePath(), FDatei.getMsgLevelMedien());
                    } else {
                        verkleinerung = ", Bitrate: " + bitrateIst + "k => " + bitrateSoll + "k" + (faktor < 1.0f ? ", Groesse: " + groesseIst + " => " + groesseSoll : "");
                    }
                    if (verkleinerung.length() > 0) {
                        FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_resize_" + breite + "x" + hoehe + "_" + bitrateSoll + "k" : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
                        FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Video Resize");
                        output.deleteIfExits();
                        if (!Futi.isRaspberry()) {
                            FDatei.checkVideoRotationAndCreateDate(medium.getAbsolutePath());
                        }
                        FProt.instance().prot("Video " + medium.getAbsolutePath() + verkleinerung + " wird verkleinert", 0);
                        if (FDatei.isCopyStattRecode()) {
                            medium.copyFile(output.getAbsolutePath(), true);
                        } else {
                            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-acodec", "copy", "-vcodec", "libx264", "-b:v", String.valueOf(bitrateSoll) + "k", "-vf", "scale=" + breite + ":" + hoehe, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                        }
                        FDatei.nachbereitenVideo(medium.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, false);
                        FProt.instance().prot("Video " + medium.getAbsolutePath() + verkleinerung + " ist verkleinert, Einsparung errechnet: " + nf.format(einsparMB) + " MB, erreicht: " + nf.format((float)(medium.length() - output.length()) / 1048576.0f) + " MB", 0);
                    }
                }
            } else {
                FProt.instance().prot("Breite und Hoehe fuer " + medium.getAbsolutePath() + " nicht verstellbar", 0);
            }
        } else if (medium.isPicture()) {
            int prozent = FMath.checkRange(faktorIn, 0, 100);
            int size = FMath.checkRange(sizeIn, 10, 1920);
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_resize_" + (prozent > 0 ? String.valueOf(prozent) + "Proz" : String.valueOf(size)) : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto Resize");
            int[] dimension = FDatei.getImageDimension(medium.getAbsolutePath());
            output.deleteIfExits();
            int filesizeAltKB = (int)(medium.length() / 1024L);
            int filesizeNeuKB = FDatei.getImageOptimalFilesizeKB(FDatei.getImageResizeAnzahlPixel(dimension[0], dimension[1], prozent, size));
            boolean groesseBegrenzen = filesizeNeuKB < filesizeAltKB;
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), groesseBegrenzen ? " -define" : "", groesseBegrenzen ? "jpeg:extent=" + filesizeNeuKB + "KB" : "", "-resize", prozent > 0 ? String.valueOf(prozent) + "%" : String.valueOf(size) + "x" + size + ">", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FProt.instance().prot("Foto " + medium.getAbsolutePath() + " auf " + (prozent > 0 ? String.valueOf(prozent) + "%" : String.valueOf(size)) + " verkleinert", FDatei.getMsgLevelMedien());
            if (overwriteOriginal) {
                medium.delete();
                output.renameTo(dateiname);
            }
        } else {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Foto und kein Video", 0);
        }
        return resizeToDo;
    }

    public static double rundeGPSKoordinate(double in, int abstand) {
        float rundenAuf = 2.0f;
        rundenAuf = abstand <= 500 ? 2.0f : (abstand <= 1000 ? 1.75f : (abstand <= 2000 ? 1.5f : 1.2f));
        return FMath.runden(in, rundenAuf);
    }

    public static void setAlbumFromDatabase(String mediumName) {
        FFile medium = new FFile(mediumName);
        if (medium.exists()) {
            String albumIst = FDatei.getExiftag(mediumName, "Album");
            String albumSoll = FDatei.getAlbumFromDatabase(mediumName);
            if (albumSoll.length() > 0 && albumSoll.compareTo(albumIst) != 0) {
                FDatei.updateExiftag(mediumName, "Album", albumSoll);
            }
        }
    }

    public static void setAnzahlZeilenSpaltenPoster(int anzahlZeilenSpaltenPoster) {
        AnzahlZeilenSpaltenPoster = anzahlZeilenSpaltenPoster;
    }

    public static void setBasename2Album(String dateiName, boolean replaceNonAlphanumeric) {
        String[] tag = FDatei.getExiftags(dateiName, new String[]{"Basename", "Album"});
        String basename = tag[0];
        String album = tag[1];
        if (replaceNonAlphanumeric) {
            basename = FString.clearString(basename, true).trim();
        }
        if (basename.compareTo(album) != 0) {
            FDatei.updateExiftag(dateiName, "Album", basename);
        }
    }

    public static void setCopyStattRecode(boolean copyStattRecode) {
        FDatei.copyStattRecode = copyStattRecode;
    }

    public static void setGPSOrte(String verzIn, int abstand) {
        String verz = FDatei.checkFileSeperator(verzIn, true);
        String[] namen = new String[]{"-GPSMapDatum", "-DateTimeOriginal", "-Filename", "-OriginalFileName", "-GPSAreaInformation", "-GPSLatitude", "-GPSLongitude", "-GPSDestLatitude", "-GPSDestLongitude", "-GPSDestDistance", verz};
        ArrayList<String[]> medienAlle = FString.convertTabelleToArrayList(FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-c", "%+.8g", "-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "MOV"}, namen)), 5), "UTF-8"), namen.length, true));
        ArrayList<String[]> medienRelevant = new ArrayList<String[]>();
        ArrayList<String[]> medienRelevantOrg = new ArrayList<String[]>();
        if (medienAlle.size() == 0) {
            FProt.instance().prot(String.valueOf(verzIn) + " hat keine relevanten Medien");
        } else {
            int anzChangedMedien = 0;
            int i = 0;
            while (i < medienAlle.size()) {
                String[] zeile = FDatei.clearTags(medienAlle.get(i));
                if (!zeile[5].isEmpty() && !zeile[6].isEmpty()) {
                    medienRelevantOrg.add(FString.copyStringArray(medienAlle.get(i)));
                    int j = 5;
                    while (j < 7) {
                        try {
                            double koord = Double.parseDouble(zeile[j]);
                            zeile[j + 2] = String.valueOf(koord < 0.0 ? "-" : "+") + FDatei.rundeGPSKoordinate(koord, abstand);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++j;
                    }
                    zeile[0] = String.valueOf(zeile[7]) + zeile[8];
                    zeile[9] = "" + abstand;
                    medienRelevant.add(zeile);
                }
                ++i;
            }
            if (medienRelevant.size() == 0) {
                FProt.instance().prot(String.valueOf(verzIn) + " hat keine Medien mit Koordinaten");
            } else {
                String[][] medien = FString.instance().convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertTabelleToStringArray(FString.convertArrayListToTabelle(medienRelevant))), namen.length);
                String[][] org = FQuickSort.instance().quickSort(FString.convertArrayListToTabelle(medienRelevantOrg), 2);
                String ersterDerGruppe = medien[0][3];
                int i2 = 0;
                while (i2 < medien.length) {
                    if (i2 > 0) {
                        if (medien[i2][0].compareTo(medien[i2 - 1][0]) == 0) {
                            medien[i2][4] = ersterDerGruppe;
                        } else {
                            medien[i2][4] = "";
                            ersterDerGruppe = medien[i2][3];
                        }
                    }
                    ++i2;
                }
                medien = FQuickSort.instance().quickSort(medien, 2);
                ArrayList<String> parm = new ArrayList<String>();
                double alt = -999.0;
                double neu = -999.0;
                int i3 = 0;
                while (i3 < medien.length) {
                    FProt.instance().prot("\t" + FString.stringArrayToString(medien[i3], "\t"), 5);
                    FProt.instance().prot("O\t" + FString.stringArrayToString(org[i3], "\t"), 5);
                    if (medien[i3][2].compareTo(org[i3][2]) != 0) {
                        FProt.instance().prot("Error in Zeile\t" + i3 + "\t" + medien[i3][2] + "\t" + org[i3][2] + "\t", 0);
                    } else {
                        parm.clear();
                        if (medien[i3][0].compareTo(org[i3][0]) != 0) {
                            parm.add(String.valueOf(namen[0]) + "=" + medien[i3][0]);
                        }
                        if (medien[i3][4].compareTo(org[i3][4]) != 0) {
                            parm.add(String.valueOf(namen[4]) + "=" + medien[i3][4]);
                        }
                        int j = 7;
                        while (j < 9) {
                            try {
                                alt = Double.parseDouble(org[i3][j]);
                            }
                            catch (Exception e) {
                                alt = -999.0;
                            }
                            try {
                                neu = Double.parseDouble(medien[i3][j]);
                            }
                            catch (Exception e) {
                                neu = -999.0;
                            }
                            if (neu > -300.0 && alt != neu) {
                                parm.add(String.valueOf(namen[j]) + "=" + medien[i3][j]);
                            }
                            ++j;
                        }
                        if (medien[i3][9].compareTo(org[i3][9]) != 0) {
                            parm.add(String.valueOf(namen[9]) + "=" + medien[i3][9]);
                        }
                        if (parm.size() > 0) {
                            FProt.instance().prot("Change " + medien[i3][2] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                            parm.add(String.valueOf(verz) + medien[i3][2]);
                            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                            ++anzChangedMedien;
                        }
                    }
                    ++i3;
                }
            }
            FProt.instance().prot(String.valueOf(verzIn) + ": " + medienAlle.size() + " Medien, " + medienRelevant.size() + " relevanten Medien, " + anzChangedMedien + " geaenderte Medien");
        }
    }

    public static void setImageQuality2Exif(String dateiname, boolean update) {
        if (new FFile(dateiname).isPicture()) {
            String oldValue = FDatei.getExiftag(dateiname, "IPTC:ImageQuality");
            String string = oldValue = oldValue.compareTo("-") == 0 ? "" : oldValue;
            if (oldValue.isEmpty() || update) {
                String newValue = FBefehl.aufrufBefehl("identify", new String[]{"-verbose", "-format", "%Q", dateiname}, FDatei.getMsgLevelMedien())[0];
                if (oldValue.compareTo(newValue) != 0) {
                    FDatei.updateExiftag(dateiname, "IPTC:ImageQuality", newValue);
                }
                FProt.instance().prot(String.valueOf(dateiname) + ": IPTC:ImageQuality: " + oldValue + "=>" + newValue);
            } else {
                FProt.instance().prot(String.valueOf(dateiname) + ": IPTC:ImageQuality=" + oldValue, 1);
            }
        } else {
            FProt.instance().prot(String.valueOf(dateiname) + " kein Foto, Qualitaet nicht feststellbar", 0);
        }
    }

    public static boolean setJPEGQuality(String dateiname, int prozentIn, String relVerzOutput, boolean overwriteOriginalIn) {
        boolean overwriteOriginal;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(1);
        float einsparungMinimum = 10.0f;
        boolean resizeToDo = false;
        FFile medium = new FFile(dateiname);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (medium.isPicture()) {
            int prozent = FMath.checkRange(prozentIn, 20, 100);
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_jpg_" + prozent + "Proz" : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto Resize");
            output.deleteIfExits();
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), new String[]{medium.getAbsolutePath(), "-quality", String.valueOf(prozent) + "%", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FDatei.setImageQuality2Exif(output.getAbsolutePath(), true);
            float einsparung = (1.0f - (float)output.length() * 1.0f / (float)medium.length()) * 100.0f;
            if (overwriteOriginal && einsparung > 10.0f) {
                medium.delete();
                output.renameTo(dateiname);
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " komprimiert: " + nf.format(einsparung) + " Prozent eingespart", 0);
            } else if (einsparung > 10.0f) {
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " komprimiert: " + nf.format(einsparung) + " Prozent eingespart, geaenderte Datei: " + output.getAbsolutePath(), 0);
            } else {
                output.delete();
                FProt.instance().prot("Foto " + medium.getAbsolutePath() + " komprimiert: " + nf.format(einsparung) + " Prozent eingespart, weniger als Minimaleinsparung von " + nf.format(10.0) + " Prozent, Foto nicht veraendert", 0);
            }
        } else {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Foto", 0);
        }
        return false;
    }

    public static void setMsgLevelMedien(int MsgLevelMedien) {
        FDatei.MsgLevelMedien = MsgLevelMedien;
    }

    public static void setParent2Album(String dateiName, boolean replaceNonAlphanumeric) {
        String[] tag = FDatei.getExiftags(dateiName, new String[]{"\"Directory\"", "Album"});
        String directory = tag[0];
        String album = tag[1];
        String parent = directory.substring(directory.lastIndexOf("/") + 1);
        if (replaceNonAlphanumeric) {
            parent = FString.clearString(parent);
        }
        if (parent.compareTo(album) != 0) {
            FDatei.updateExiftag(dateiName, "Album", parent);
        }
    }

    public static String shortenDateiname(String Datei, int input_len) {
        String Aus;
        int Pos_Backslash = Datei.lastIndexOf(System.getProperty("file.separator").charAt(0));
        int len = input_len;
        int Pos_Punkt = Datei.lastIndexOf(46);
        if (len < 0) {
            len = 0;
        }
        if (Pos_Backslash > Pos_Punkt) {
            Pos_Punkt = 0;
        }
        if (Pos_Punkt > 0) {
            int len_ext = Datei.length() - Pos_Punkt;
            if (len > Datei.length() - len_ext) {
                len = Datei.length() - len_ext;
            }
            if (Pos_Backslash + len + 1 > Datei.length()) {
                len = Datei.length() - (Pos_Backslash + 1);
            }
            Aus = String.valueOf(Datei.substring(0, Pos_Backslash + len + 1)) + Datei.substring(Pos_Punkt);
        } else {
            if (len > Datei.length()) {
                len = Datei.length();
            }
            if (Pos_Backslash + len + 1 > Datei.length()) {
                len = Datei.length() - (Pos_Backslash + 1);
            }
            Aus = Datei.substring(0, Pos_Backslash + len + 1);
        }
        return Aus;
    }

    public static String[] shortenDateinamen(String[] Dateien, int len) {
        String[] Aus = new String[Dateien.length];
        int i = 0;
        while (i < Dateien.length) {
            Aus[i] = FDatei.shortenDateiname(Dateien[i], len);
            ++i;
        }
        return Aus;
    }

    public static void spiegeln(String dateiname, char horiVerti) {
        FDatei.spiegeln(dateiname, horiVerti, false);
    }

    public static void spiegeln(String dateiname, char horiVerti, boolean overwriteOriginal) {
        FFile medium = new FFile(dateiname);
        if (medium.isPicture()) {
            FBefehl.aufrufBefehl("mogrify", new String[]{horiVerti == 'h' ? "-flop" : "-flip", medium.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FDatei.makeThumbnail(medium.getAbsolutePath(), 999);
            FProt.instance().prot("Foto " + medium.getAbsolutePath() + " " + (horiVerti == 'h' ? "horizontal" : "vertikal") + " gespiegelt", 0);
        } else if (medium.isVideo()) {
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(dateiname);
            FFile output = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + "_gespiegelt_" + (horiVerti == 'h' ? "horizontal" : "vertikal") + "." + dateinamenTeile.getExtend());
            output.deleteIfExits();
            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", medium.getAbsolutePath(), "-vf", horiVerti == 'h' ? "hflip" : "vflip", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FDatei.nachbereitenVideo(medium.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, true);
            FProt.instance().prot("Video " + medium.getAbsolutePath() + " " + (horiVerti == 'h' ? "horizontal" : "vertikal") + " gespiegelt", 0);
        } else {
            FProt.instance().prot("Spiegeln nicht implementiert, " + medium.getAbsolutePath() + " kein Foto und kein Video", 0);
        }
    }

    public static void syncFolderModifyDate(String orgFolder, String zielFolder, boolean extraCheck) {
        String[] org = new FFile(orgFolder).listFileNames();
        String[] extra1 = new String[]{"", "aaa_", "_thumb"};
        String[] extra2 = new String[]{""};
        String[] extra = extraCheck ? extra1 : extra2;
        int anzahlChanged = 0;
        String[] stringArray = org;
        int n = org.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            int j = 0;
            while (j < extra.length) {
                File orgFile;
                File ziel = new File(zielFolder, j == 0 ? element : (j == 1 ? String.valueOf(extra[j]) + element : (element.lastIndexOf(".") > 0 ? String.valueOf(element.substring(0, element.lastIndexOf("."))) + extra[j] + element.substring(element.lastIndexOf(".")) : element)));
                if (ziel.exists() && (orgFile = new File(orgFolder, element)).lastModified() != ziel.lastModified()) {
                    ziel.setLastModified(orgFile.lastModified());
                    ++anzahlChanged;
                }
                ++j;
            }
            ++n2;
        }
        FProt.instance().prot("Anzahl changed in " + zielFolder + ": " + anzahlChanged);
    }

    public static void updateExiftag(String mediumName, String tagName, String tagWert) {
        FDatei.updateExiftag(mediumName, tagName, tagWert, false);
    }

    public static void updateExiftag(String mediumName, String tagName, String tagWert, boolean datumNichtAendern) {
        FFile medium = new FFile(mediumName);
        if (medium.exists()) {
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-" + tagName + "=" + tagWert, datumNichtAendern ? "-P" : "", medium.getAbsolutePath()}));
        }
    }

    public static void updateExiftags(String mediumName, String[] tagNamen, String[] tagWerte) {
        FFile medium = new FFile(mediumName);
        if (medium.exists() && tagNamen.length > 0 && tagNamen.length == tagWerte.length) {
            String[] listeTags = new String[tagNamen.length];
            int i = 0;
            while (i < tagNamen.length) {
                listeTags[i] = "-" + tagNamen[i] + "=" + tagWerte[i];
                ++i;
            }
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(listeTags, new String[]{"-T", medium.getAbsolutePath()})));
        }
    }

    public static boolean verzeichnis2DateTimeOriginal(String verzeichnis, String[][] fotos, FGregorianCalendar datum) {
        FProt fProt = FProt.instance();
        int[][] schritte = new int[][]{{10, 60}, {20, 30}, {40, 15}, {60, 10}, {120, 5}, {600, 1}};
        int schrittweite = 1;
        Object datumIst = "";
        String datumSoll = "";
        Object dateiName = "";
        fProt.prot(String.valueOf(verzeichnis) + " enthaelt " + fotos.length + " Foto" + (fotos.length > 1 ? "s" : ""));
        boolean etwasGeaendertVerzeichnis = false;
        schrittweite = 1;
        Object object = schritte;
        int n = schritte.length;
        int n2 = 0;
        while (n2 < n) {
            int[] element = object[n2];
            if (fotos.length <= element[0]) {
                schrittweite = element[1];
                break;
            }
            ++n2;
        }
        fProt.prot(" " + fotos.length + " Fotos => Schrittweite (Minuten): " + schrittweite);
        object = fotos;
        n = fotos.length;
        n2 = 0;
        while (n2 < n) {
            int[] foto = object[n2];
            dateiName = foto[0];
            datumIst = foto[1];
            datumSoll = datum.toGermanFormat('E');
            if (((String)datumIst).compareTo(datumSoll) != 0) {
                fProt.prot(" " + dateiName + " " + (String)datumIst + " => " + datumSoll);
                FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-DateTimeOriginal=" + datumSoll, String.valueOf(verzeichnis) + System.getProperty("file.separator") + dateiName}), 5);
                etwasGeaendertVerzeichnis = true;
            } else {
                fProt.prot(" " + dateiName + " " + (String)datumIst + " korrekt", 2);
            }
            datum.add(12, schrittweite);
            ++n2;
        }
        if (!etwasGeaendertVerzeichnis) {
            fProt.prot("keine Changes in " + verzeichnis + " notwendig");
        }
        return etwasGeaendertVerzeichnis;
    }

    public static String verzeichnisEbenenZurueck(String verzIn, int ebenenZurueck) {
        String verz = FDatei.checkFileSeperator(verzIn, false);
        File test = new File(verzIn);
        if (!test.isDirectory()) {
            FProt.instance().prot(String.valueOf(verzIn) + " ist kein Verzeichnis");
        } else {
            int pos = verz.length();
            int i = 0;
            while (i < Math.abs(ebenenZurueck)) {
                pos = verz.lastIndexOf(System.getProperty("file.separator"));
                if (pos <= 0) break;
                verz = verz.substring(0, pos);
                ++i;
            }
        }
        return verz;
    }

    public static void verzeichnisse2DateTimeOriginal(String medienVerzeichnisIn) {
        String medienVerzeichnis = FDatei.checkFileSeperator(medienVerzeichnisIn, false);
        FProt fProt = FProt.instance();
        FFile dir = new FFile(medienVerzeichnis);
        String[] verz = dir.listFileNames('V', true);
        String[][] fotos = new String[][]{{""}};
        FGregorianCalendar datum = new FGregorianCalendar(System.currentTimeMillis());
        if (verz.length == 0) {
            fotos = FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ext", "JPG", "-FileName", "-DateTimeOriginal", "-T", medienVerzeichnis})), true, true), 2, true);
            if (fotos.length == 0) {
                fProt.prot(String.valueOf(medienVerzeichnis) + " enthaelt keine Fotos");
            } else {
                boolean datumEindeutig = true;
                String datumCheck = fotos[0][1].substring(0, 10);
                String[][] stringArray = fotos;
                int n = fotos.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] foto = stringArray[n2];
                    boolean bl = datumEindeutig = foto[1].substring(0, 10).compareTo(datumCheck) == 0;
                    if (!datumEindeutig) break;
                    ++n2;
                }
                if (!datumEindeutig) {
                    fProt.prot(String.valueOf(medienVerzeichnis) + " unterschiedliche Dates in DateTimeOriginal");
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy:MM:dd");
                    try {
                        datum.setTime(format.parse(datumCheck));
                        datum.set(10, 8);
                        FDatei.verzeichnis2DateTimeOriginal(medienVerzeichnis, fotos, datum);
                    }
                    catch (ParseException e) {
                        fProt.prot(String.valueOf(medienVerzeichnis) + " mit " + datumCheck + " ist kein gueltiges Datum");
                    }
                }
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            FGregorianCalendar now = new FGregorianCalendar(System.currentTimeMillis());
            String dirName = "";
            boolean etwasGeaendertVerzeichnis = false;
            boolean etwasGeaendertGesamt = false;
            String[] stringArray = verz;
            int n = verz.length;
            int n3 = 0;
            while (n3 < n) {
                String element = stringArray[n3];
                boolean verzValid = false;
                try {
                    datum.setTime(format.parse(FDatei.instance().zerlegeDateiname(element).getNamePlusExtend()));
                    if (datum.get(1) < 1900 || datum.getTimeInMillis() >= now.getTimeInMillis()) {
                        fProt.prot(String.valueOf(element) + " ist kein gueltiges Datum");
                    } else {
                        datum.set(10, 8);
                        fProt.prot(String.valueOf(element) + " " + datum.toGermanFormat('E'));
                        verzValid = true;
                    }
                }
                catch (ParseException e) {
                    fProt.prot(String.valueOf(element) + " ist kein Datum");
                }
                if (verzValid) {
                    dirName = dir.getAbsoluteFile() + System.getProperty("file.separator") + element;
                    fotos = FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-ext", "JPG", "-FileName", "-DateTimeOriginal", "-T", dirName})), true, true), 2, true);
                    if (fotos.length == 0) {
                        fProt.prot(String.valueOf(element) + " enthaelt keine Fotos");
                    } else {
                        etwasGeaendertVerzeichnis = FDatei.verzeichnis2DateTimeOriginal(dirName, fotos, datum);
                    }
                    if (etwasGeaendertVerzeichnis) {
                        etwasGeaendertGesamt = true;
                    }
                }
                ++n3;
            }
            if (!etwasGeaendertGesamt) {
                fProt.prot("Insgesamt keine Changes notwendig");
            }
        }
    }

    public static int verzeichnisstruktur2GPSOrtsdaten(String verz, boolean inklLeereFelder, boolean nurTest) {
        FProt.instance().prot("Verzeichnisstruktur muss sein:\t..../CountryCode/State[/City[/Location]]");
        int anzChangedMedien = 0;
        String[] namen = new String[]{"-Filename", "-Directory", "-XMP:CountryCode", "-XMP:Country", "-XMP:State", "-XMP:City", "-XMP:Location", verz};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "GIF", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
        String[][] org = FString.copyTabelle(medien);
        int i = 0;
        while (i < medien.length) {
            String verzRel = verz.length() < medien[i][1].length() ? medien[i][1].substring(verz.length()) : "";
            verzRel = verzRel.startsWith("/") ? verzRel.substring(1) : verzRel;
            String countryCode = "";
            String country = "";
            String state = "";
            String city = "";
            String location = "";
            String[] teile = verzRel.split("/");
            if (teile.length > 0) {
                int pos;
                countryCode = teile[0];
                if (countryCode.length() > 2 && (pos = FString.findFirstString(CountryCodes, 1, countryCode, false, true)) >= 0) {
                    countryCode = CountryCodes[pos][0];
                }
                if ((pos = FString.findFirstString(CountryCodes, 0, countryCode, false, true)) >= 0) {
                    country = CountryCodes[pos][1];
                }
            }
            if (teile.length > 1) {
                state = teile[1];
            }
            if (teile.length > 2) {
                city = teile[2];
            }
            if (teile.length > 3) {
                location = teile[3];
            }
            if (!countryCode.isEmpty()) {
                medien[i][2] = countryCode;
            }
            if (!country.isEmpty()) {
                medien[i][3] = country;
            }
            if (!state.isEmpty()) {
                medien[i][4] = state;
            }
            if (!city.isEmpty() || inklLeereFelder) {
                medien[i][5] = city;
            }
            if (!location.isEmpty() || inklLeereFelder) {
                medien[i][6] = location;
            }
            ++i;
        }
        ArrayList<String> parm = new ArrayList<String>();
        int i2 = 0;
        while (i2 < medien.length) {
            FProt.instance().prot("\t" + FString.stringArrayToString(medien[i2], "\t"), 5);
            FProt.instance().prot("O\t" + FString.stringArrayToString(org[i2], "\t"), 5);
            if (medien[i2][0].compareTo(org[i2][0]) != 0) {
                FProt.instance().prot("Error in Zeile\t" + (i2 + 1) + "\t" + medien[i2][1] + System.getProperty("file.separator") + medien[i2][0] + "\t" + org[i2][0] + "\t", 0);
            } else {
                parm.clear();
                int j = 2;
                while (j < medien[i2].length) {
                    if (org[i2][j].compareTo(medien[i2][j]) != 0) {
                        parm.add(String.valueOf(namen[j]) + "=" + medien[i2][j]);
                    }
                    ++j;
                }
                if (parm.size() > 0) {
                    FProt.instance().prot(String.valueOf(nurTest ? "To change" : "Change") + " " + medien[i2][1] + System.getProperty("file.separator") + medien[i2][0] + ": " + FString.stringArrayToString(FString.arrayListToStringArray(parm), "\t"), 0);
                    if (!nurTest) {
                        parm.add(String.valueOf(medien[i2][1]) + System.getProperty("file.separator") + medien[i2][0]);
                        FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.arrayListToStringArray(parm)), 5);
                    }
                    ++anzChangedMedien;
                }
            }
            ++i2;
        }
        FProt.instance().prot(String.valueOf(verz) + ": " + medien.length + " Medien, " + anzChangedMedien + " " + (nurTest ? "zu aendernde" : "geaenderte") + " Medien");
        return anzChangedMedien;
    }

    public static long video2GIF(String dateiname, String outputDateiname, int breiteIn, int framesProSekundeIn, boolean fein, long groesseMin, long groesseMax) {
        return FDatei.video2GIF(dateiname, outputDateiname, breiteIn, framesProSekundeIn, fein, groesseMin, groesseMax, "", "");
    }

    public static long video2GIF(String dateiname, String outputDateiname, int breiteIn, int framesProSekundeIn, boolean fein, long groesseMin, long groesseMax, String start, String laenge) {
        long groesse = 0L;
        if (FDatei.instance().zerlegeDateiname(dateiname).getExtend().compareToIgnoreCase("gif") == 0) {
            FProt.instance().prot(String.valueOf(dateiname) + " ist schon gif-Datei", 0);
        } else {
            FFile video = new FFile(dateiname);
            if (video.isVideo()) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(3);
                nf.setMinimumFractionDigits(3);
                FFile output = new FFile(outputDateiname);
                int[] dimBitrate = FDatei.getVideoDimensionAndBitrate(video.getAbsolutePath());
                int breite = dimBitrate[0];
                int framesProSekunde = FMath.checkRange(framesProSekundeIn, 10, 25);
                if (breiteIn > 0 && breiteIn < breite) {
                    breite = breiteIn;
                }
                FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "MP4 to GIF");
                output.deleteIfExits();
                if (fein) {
                    String palette = String.valueOf(Futi.getBenutzerWert("Workfiles")) + "palette.png";
                    FDatei.checkDatei(palette, 'D', 'W', "MP4 to GIF: palette");
                    String filters = "fps=" + framesProSekunde + ",scale=" + breite + ":-1:flags=lanczos";
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-vf", String.valueOf(filters) + ",palettegen", palette}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-i", palette, "-lavfi", String.valueOf(filters) + " [x]; [x][1:v] paletteuse=dither=bayer:bayer_scale=3", "-loop", "-1", start.isEmpty() ? "" : "-ss", start.isEmpty() ? "" : start, laenge.isEmpty() ? "" : "-t", laenge.isEmpty() ? "" : laenge, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                } else {
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-pix_fmt", "rgb8", "-loop", "-1", start.isEmpty() ? "" : "-ss", start.isEmpty() ? "" : start, laenge.isEmpty() ? "" : "-t", laenge.isEmpty() ? "" : laenge, "-r", String.valueOf(framesProSekunde), "-vf", "scale=" + breite + ":-1", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                }
                groesse = output.length();
                if (groesse < groesseMax * 2L) {
                    FBefehl.aufrufBefehl("gifsicle", new String[]{"-O3", output.getAbsolutePath(), "-o", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    groesse = output.length();
                }
                if (groesse < groesseMin || groesse > groesseMax) {
                    output.delete(true);
                    new FFile(output.getParent()).delete(true);
                    FProt.instance().prot("???\t" + video.getAbsolutePath() + " => " + output.getAbsolutePath() + "\tbreite: " + breite + "\tframesProSekunde: " + framesProSekunde + "\tGroesse (KB): " + nf.format((double)groesse / 1048576.0));
                } else {
                    FProt.instance().prot("!!!\t" + video.getAbsolutePath() + " => " + output.getAbsolutePath() + "\tbreite: " + breite + "\tframesProSekunde: " + framesProSekunde + "\tGroesse (KB): " + nf.format((double)groesse / 1048576.0));
                }
            } else {
                FProt.instance().prot(String.valueOf(video.getAbsolutePath()) + " kein Video", 0);
            }
        }
        return groesse;
    }

    public static void videoChangeSpeed(String videoName, float speedfaktor) {
        FDatei.videoChangeSpeed(videoName, speedfaktor, "", false);
    }

    public static void videoChangeSpeed(String videoName, float speedfaktor, String relVerzOutput, boolean overwriteOriginalIn) {
        boolean overwriteOriginal;
        FFile video = new FFile(videoName);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(video.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (video.isVideo()) {
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_speed_" + speedfaktor : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Video Change Speed");
            output.deleteIfExits();
            FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-filter:v", "setpts=" + 1.0f / speedfaktor + "*PTS", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
            FDatei.nachbereitenVideo(video.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, false);
        }
    }

    public static void videoSlowAtPosition(String videoName) {
        FDatei.videoSlowAtPosition(videoName, -1.0f, 4.0f, 20, 3.0f, -1.0f, "", false);
    }

    public static void videoSlowAtPosition(String videoName, float position, float lengthStandbild) {
        FDatei.videoSlowAtPosition(videoName, position, 4.0f, 20, 3.0f, lengthStandbild, "", false);
    }

    public static void videoSlowAtPosition(String videoName, float positionIn, float lengthPhase, int anzahlSteps, float slowestFaktor, float lengthStandbildIn, String relVerzOutput, boolean overwriteOriginalIn) {
        boolean overwriteOriginal;
        FFile video = new FFile(videoName);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(video.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (video.isVideo()) {
            String extent = videoName.lastIndexOf(".") > 0 ? videoName.substring(videoName.lastIndexOf(".") + 1) : "mp4";
            float duration = 0.0f;
            float positionExif = -1.0f;
            float lengthStandbildExif = -1.0f;
            String projectName = "";
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Duration#", "-ProjectName", "-T", video.getAbsolutePath()}), 5);
            if (tags.length > 0 && tags[0].length() > 0) {
                float lengthStandbild;
                float position;
                String[] teile = tags[0].split("\t");
                if (teile.length > 1) {
                    try {
                        duration = Float.parseFloat(teile[0]);
                        projectName = teile[1];
                        teile = projectName.split(",");
                        positionExif = Float.parseFloat(teile[0]);
                        lengthStandbildExif = Float.parseFloat(teile[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                float f = positionIn < 0.0f ? (positionExif < 0.0f ? FMath.runden(duration / 2.0f, 3) : positionExif) : (position = positionIn);
                float f2 = lengthStandbildIn < 0.0f ? (lengthStandbildExif < 0.0f ? 3.0f : lengthStandbildExif) : (lengthStandbild = lengthStandbildIn);
                if (duration <= 0.0f) {
                    FProt.instance().prot(String.valueOf(video.getAbsolutePath()) + " Dauer nicht feststellbar");
                } else if (position < 5.0f) {
                    FProt.instance().prot(String.valueOf(video.getAbsolutePath()) + " Position " + position + " zu nahe am Start");
                } else if (position > duration - 5.0f) {
                    FProt.instance().prot(String.valueOf(video.getAbsolutePath()) + " Position " + position + " zu nahe am Ende oder spaeter als das Ende " + duration);
                } else {
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-ss", String.valueOf(position), "-i", video.getAbsolutePath(), "-vframes", "1", "-q:v", "2", String.valueOf(video.getAbsolutePath()) + "." + position + ".jpg"}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-loop", "1", "-i", String.valueOf(video.getAbsolutePath()) + "." + position + ".jpg", "-t", String.valueOf(lengthStandbild), String.valueOf(video.getAbsolutePath()) + "." + position + "." + extent}, FDatei.getMsgLevelMedien());
                    String v = "";
                    int i = 1;
                    while (i <= anzahlSteps * 2 + 3) {
                        v = String.valueOf(v) + "[v" + i + "]";
                        ++i;
                    }
                    FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_freeze_at_" + position + "_for_" + lengthStandbild + "_sec_S_" + anzahlSteps + "_F_" + slowestFaktor : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + (relVerzOutput.endsWith("AtPosition") ? String.valueOf(relVerzOutput) + "_" + position + "_for_" + lengthStandbild + "_s" : relVerzOutput) + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + extent);
                    FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Video Change Speed");
                    output.deleteIfExits();
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-i", String.valueOf(video.getAbsolutePath()) + "." + position + "." + extent, "-filter_complex", "[0:v]trim=0:" + (position - lengthPhase) + ",setpts=PTS-STARTPTS[v1];" + FDatei.videoSlowprepare(position, true, lengthPhase, anzahlSteps, slowestFaktor, 2) + "[1:v]trim=0:" + lengthStandbild + ",setpts=PTS-STARTPTS[v" + (anzahlSteps + 2) + "];" + FDatei.videoSlowprepare(position, false, lengthPhase, anzahlSteps, slowestFaktor, anzahlSteps + 3) + "[0:v]trim=" + (position + lengthPhase) + ":" + duration + ",setpts=PTS-STARTPTS[v" + (anzahlSteps * 2 + 3) + "];" + v + " concat=n=" + (anzahlSteps * 2 + 3) + ":v=1 [v]", "-map", "[v]", "-preset", "superfast", "-profile:v", "baseline", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    FDatei.nachbereitenVideo(video.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, false);
                    new FFile(String.valueOf(video.getAbsolutePath()) + "." + position + ".jpg").deleteIfExits();
                    new FFile(String.valueOf(video.getAbsolutePath()) + "." + position + "." + extent).deleteIfExits();
                }
            }
        }
    }

    public static void videoSlowAtPosition(String videoName, float position, float lengthStandbild, String relVerzOutput, boolean overwriteOriginal) {
        FDatei.videoSlowAtPosition(videoName, position, 4.0f, 20, 3.0f, lengthStandbild, relVerzOutput, overwriteOriginal);
    }

    public static void videoSlowAtPosition(String videoName, String relVerzOutput, boolean overwriteOriginal) {
        FDatei.videoSlowAtPosition(videoName, -1.0f, 4.0f, 20, 3.0f, -1.0f, relVerzOutput, overwriteOriginal);
    }

    public static String videoSlowprepare(float position, boolean slowDown, float lengthPhase, int anzahlSteps, float slowestFaktor, int startVideopart) {
        String parm = "";
        String step = "";
        double x = 0.0;
        double slowFaktor = 0.0;
        float schrittweite = lengthPhase / (float)anzahlSteps;
        int i = 0;
        while (i < anzahlSteps) {
            x = FMath.runden((double)i / ((double)anzahlSteps / 3.14) - 1.57, 3);
            slowFaktor = FMath.runden(Math.sin(x) + 2.0 + (x + 1.57) * (((double)slowestFaktor - 3.0) / 3.14), 3);
            step = slowDown ? "[0:v]trim=" + FMath.runden(position - (float)(anzahlSteps - i) * schrittweite, 3) + ":" + FMath.runden(position - (float)(anzahlSteps - i - 1) * schrittweite, 3) + ",setpts=" + slowFaktor + "*(PTS-STARTPTS)[v" + (startVideopart + i) + "]; " : "[0:v]trim=" + FMath.runden(position + (float)i * schrittweite, 3) + ":" + FMath.runden(position + (float)(i + 1) * schrittweite, 3) + ",setpts=" + FMath.runden((double)(slowestFaktor + 1.0f) - slowFaktor, 3) + "*(PTS-STARTPTS)[v" + (startVideopart + i) + "]; ";
            FProt.instance().prot(String.valueOf(FMath.runden(position + (float)(slowDown ? i - anzahlSteps : i) * schrittweite, 3)) + "\t" + x + "\t" + (slowDown ? slowFaktor : (double)(slowestFaktor + 1.0f) - slowFaktor) + "\t" + step, 5);
            parm = String.valueOf(parm) + step;
            ++i;
        }
        return parm;
    }

    public static void videoSlowStartAndEnd(String videoName) {
        FDatei.videoSlowStartAndEnd(videoName, 4.0f, 20, 3.0f, -1.0f, -1.0f, "", false);
    }

    public static void videoSlowStartAndEnd(String videoName, float lengthPhase, int anzahlSteps, float slowestFaktor) {
        FDatei.videoSlowStartAndEnd(videoName, lengthPhase, anzahlSteps, slowestFaktor, -1.0f, -1.0f, "", false);
    }

    public static void videoSlowStartAndEnd(String videoName, float lengthPhase, int anzahlSteps, float slowestFaktor, float lengthStandbildStartIn, float lengthStandbildEndeIn, String relVerzOutput, boolean overwriteOriginalIn) {
        boolean overwriteOriginal;
        FFile video = new FFile(videoName);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(video.getAbsolutePath());
        boolean bl = overwriteOriginal = relVerzOutput.isEmpty() ? overwriteOriginalIn : false;
        if (video.isVideo()) {
            String extent = videoName.lastIndexOf(".") > 0 ? videoName.substring(videoName.lastIndexOf(".") + 1) : "mp4";
            float duration = 0.0f;
            float lengthStandbildStartExif = -1.0f;
            float lengthStandbildEndeExif = -1.0f;
            String projectName = "";
            String[] tags = FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-Duration#", "-ProjectName", "-T", video.getAbsolutePath()}), 5);
            if (tags.length > 0 && tags[0].length() > 0) {
                float lengthStandbildEnde;
                float lengthStandbildStart;
                String[] teile = tags[0].split("\t");
                if (teile.length > 1) {
                    try {
                        duration = Float.parseFloat(teile[0]);
                        projectName = teile[1];
                        teile = projectName.split(",");
                        lengthStandbildStartExif = Float.parseFloat(teile[0]);
                        lengthStandbildEndeExif = Float.parseFloat(teile[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                float f = lengthStandbildStartIn < 0.0f ? (lengthStandbildStartExif < 0.0f ? 3.0f : lengthStandbildStartExif) : (lengthStandbildStart = lengthStandbildStartIn);
                float f2 = lengthStandbildEndeIn < 0.0f ? (lengthStandbildEndeExif < 0.0f ? 3.0f : lengthStandbildEndeExif) : (lengthStandbildEnde = lengthStandbildEndeIn);
                if (duration <= 0.0f) {
                    FProt.instance().prot(String.valueOf(video.getAbsolutePath()) + " Dauer nicht feststellbar");
                } else {
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-ss", "00:00:00", "-vframes", "1", "-q:v", "2", String.valueOf(video.getAbsolutePath()) + ".opening.jpg"}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-loop", "1", "-i", String.valueOf(video.getAbsolutePath()) + ".opening.jpg", "-t", String.valueOf(lengthStandbildStart), String.valueOf(video.getAbsolutePath()) + ".opening." + extent}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-sseof", "-1", "-i", video.getAbsolutePath(), "-update", "1", "-q:v", "2", String.valueOf(video.getAbsolutePath()) + ".closing.jpg"}, FDatei.getMsgLevelMedien());
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-loop", "1", "-i", String.valueOf(video.getAbsolutePath()) + ".closing.jpg", "-t", String.valueOf(lengthStandbildEnde), String.valueOf(video.getAbsolutePath()) + ".closing." + extent}, FDatei.getMsgLevelMedien());
                    String v = "";
                    int i = 1;
                    while (i <= anzahlSteps * 2 + 3) {
                        v = String.valueOf(v) + "[v" + i + "]";
                        ++i;
                    }
                    FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_start_L" + lengthStandbildStart + "_end_L" + lengthStandbildEnde + "_slow_L_" + lengthPhase + "_S_" + anzahlSteps + "_F_" + slowestFaktor : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
                    FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Video Change Speed");
                    output.deleteIfExits();
                    FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-i", String.valueOf(video.getAbsolutePath()) + ".opening." + extent, "-i", String.valueOf(video.getAbsolutePath()) + ".closing." + extent, "-filter_complex", "[1:v]trim=0:" + lengthStandbildStart + ",setpts=PTS-STARTPTS[v1];" + FDatei.videoSlowprepare(0.0f, false, lengthPhase, anzahlSteps, slowestFaktor, 2) + "[0:v]trim=" + lengthPhase + ":" + (duration - lengthPhase) + ",setpts=PTS-STARTPTS[v" + (anzahlSteps + 2) + "];" + FDatei.videoSlowprepare(duration, true, lengthPhase, anzahlSteps, slowestFaktor, anzahlSteps + 3) + "[2:v]trim=0" + ":" + lengthStandbildEnde + ",setpts=PTS-STARTPTS[v" + (anzahlSteps * 2 + 3) + "];" + v + " concat=n=" + (anzahlSteps * 2 + 3) + ":v=1 [v]", "-map", "[v]", "-preset", "superfast", "-profile:v", "baseline", output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                    FDatei.nachbereitenVideo(video.getAbsolutePath(), output.getAbsolutePath(), overwriteOriginal, false);
                    new FFile(String.valueOf(video.getAbsolutePath()) + ".opening.jpg").deleteIfExits();
                    new FFile(String.valueOf(video.getAbsolutePath()) + ".opening." + extent).deleteIfExits();
                    new FFile(String.valueOf(video.getAbsolutePath()) + ".closing.jpg").deleteIfExits();
                    new FFile(String.valueOf(video.getAbsolutePath()) + ".closing." + extent).deleteIfExits();
                }
            }
        }
    }

    public static void videoSlowStartAndEnd(String videoName, String relVerzOutput, boolean overwriteOriginal) {
        FDatei.videoSlowStartAndEnd(videoName, 4.0f, 20, 3.0f, -1.0f, -1.0f, relVerzOutput, overwriteOriginal);
    }

    public static void videoToMP4(String dateiname) {
        String mimeType = FDatei.getExiftag(dateiname, "MIMEType");
        if (!mimeType.startsWith("video/")) {
            FProt.instance().prot(String.valueOf(dateiname) + " ist kein Video");
        } else if (mimeType.endsWith("/mp4")) {
            FProt.instance().prot(String.valueOf(dateiname) + " ist schon mp4-Datei");
        } else {
            FFile video = new FFile(dateiname);
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(video.getAbsolutePath());
            int[] dimBitrate = FDatei.getVideoDimensionAndBitrate(video.getAbsolutePath());
            int breite = dimBitrate[0];
            int hoehe = dimBitrate[1];
            int bitrateIst = dimBitrate[2];
            if (breite > 0 && hoehe > 0) {
                int bitrateSoll = FDatei.getVideoBitrateSoll(breite, hoehe);
                if (bitrateIst < bitrateSoll) {
                    FProt.instance().prot("Bitrate-Ist (" + bitrateIst + "k) < Bitrate-Soll (" + bitrateSoll + "k): " + video.getAbsolutePath(), 0);
                }
                FFile output = new FFile(String.valueOf(dateinamenTeile.getPfadPlusName()) + (dateinamenTeile.getExtend().compareToIgnoreCase("mp4") == 0 ? "_recode" : "") + ".mp4");
                output.deleteIfExits();
                FDatei.checkVideoRotationAndCreateDate(video.getAbsolutePath());
                FBefehl.aufrufBefehl("ffmpeg", new String[]{"-y", FDatei.getMsgLevelMedien() <= 1 ? "-stats" : "", "-loglevel", "panic", "-i", video.getAbsolutePath(), "-acodec", "mp3", "-vcodec", "libx264", "-b:v", String.valueOf(bitrateSoll) + "k", "-vf", "scale=" + breite + ":" + hoehe, output.getAbsolutePath()}, FDatei.getMsgLevelMedien());
                FDatei.nachbereitenVideo(video.getAbsolutePath(), output.getAbsolutePath(), false, false);
            } else {
                FProt.instance().prot("Breite und Hoehe fuer " + video.getAbsolutePath() + " nicht verstellbar", 0);
            }
        }
    }

    public static String writePoster(String dateiname) {
        return FDatei.writePoster(dateiname, null, 0);
    }

    public static String writePoster(String dateiname, int anzahlZeilenSpalten) {
        return FDatei.writePoster(dateiname, null, anzahlZeilenSpalten);
    }

    public static String writePoster(String dateiname, String posterNameIn) {
        return FDatei.writePoster(dateiname, posterNameIn, 0);
    }

    public static String writePoster(String dateiname, String posterNameIn, int anzahlZeilenSpaltenIn) {
        String posterName = "";
        FFile medium = new FFile(dateiname);
        if (medium.isVideo()) {
            int anzahlZeilenSpalten = anzahlZeilenSpaltenIn == 0 ? FDatei.getAnzahlZeilenSpaltenPoster() : anzahlZeilenSpaltenIn;
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
            posterName = posterNameIn != null && posterNameIn.length() > 0 ? posterNameIn : String.valueOf(dateinamenTeile.getPfadPlusName()) + "_poster.jpg";
            FFile poster = new FFile(posterName);
            poster.deleteIfExits();
            FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-a", "-b", "-W!", poster.getAbsolutePath(), "-preview:all", medium.getAbsolutePath()}), 5);
            if (!poster.exists()) {
                posterName = FDatei.makePoster(medium.getAbsolutePath(), poster.getAbsolutePath(), anzahlZeilenSpalten);
                FProt.instance().prot("Poster fuer " + medium.getAbsolutePath() + (poster.exists() ? "" : " nicht") + " erstellt: " + posterName);
            } else if (anzahlZeilenSpalten != FDatei.getPosterAnzahlZeilenSpalten(poster.getAbsolutePath())) {
                posterName = FDatei.makePoster(medium.getAbsolutePath(), poster.getAbsolutePath(), anzahlZeilenSpalten);
                FProt.instance().prot("Poster fuer " + medium.getAbsolutePath() + (poster.exists() ? "" : " nicht") + " erstellt: " + posterName);
            } else {
                posterName = poster.getAbsolutePath();
                FProt.instance().prot("Poster fuer " + medium.getAbsolutePath() + (poster.exists() ? "" : " nicht") + " aus Video extrahiert: " + posterName);
            }
        } else {
            FProt.instance().prot("Videoposter nicht implementiert, " + medium.getAbsolutePath() + " kein Video", 0);
        }
        return posterName;
    }

    public static void writeZeile(BufferedWriter out, String zeile) {
        try {
            out.write(zeile);
            out.newLine();
            FProt.instance().prot(zeile.substring(0, Math.min(80, zeile.length())), 1);
        }
        catch (IOException e) {
            FProt.instance().prot("Fehler bei schreiben von: " + zeile, 0);
        }
    }

    boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        return directoryToBeDeleted.delete();
    }

    public void textOnImage(String dateiname, int sizeIn) {
        this.textOnImage(dateiname, sizeIn, "_mit_Text", "", false, 0, 0, false, false, 0);
    }

    public void textOnImage(String dateiname, int sizeIn, String relVerz) {
        this.textOnImage(dateiname, sizeIn, relVerz, "", false, 0, 0, false, false, 0);
    }

    public void textOnImage(String dateiname, int sizeIn, String relVerzOutput, String printMethode, boolean beschreibungFlaecheErweitern, int showKuenstler, int showRechte, boolean datumStattRechte, boolean hoeheStattKuenstler) {
        this.textOnImage(dateiname, sizeIn, relVerzOutput, printMethode, beschreibungFlaecheErweitern, showKuenstler, showRechte, datumStattRechte, hoeheStattKuenstler, 0);
    }

    public void textOnImage(String dateiname, int sizeIn, String relVerzOutput, String printMethode, boolean beschreibungFlaecheErweitern, int showKuenstler, int showRechte, boolean datumStattRechte, boolean hoeheStattKuenstler, int titelUmbrechenNach) {
        FFile medium = new FFile(dateiname);
        DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(medium.getAbsolutePath());
        if (medium.isPicture() && !medium.isGIF()) {
            Exif2Text image = new Exif2Text();
            image.setMax_Size(FMath.checkRange(sizeIn, 16, 1920));
            image.setData(medium.getAbsolutePath());
            if (!printMethode.isEmpty()) {
                image.setPrintMethode(printMethode);
                image.setPrint_Beschreibung_Flaeche_erweitern(beschreibungFlaecheErweitern);
            }
            image.setShow_Kuenstler(showKuenstler);
            image.setShow_Rechte(showRechte);
            if (datumStattRechte) {
                image.setDatum_statt_Rechte(true);
            }
            if (hoeheStattKuenstler) {
                image.setHoehe_statt_Kuenstler(true);
            }
            FFile output = new FFile(String.valueOf(relVerzOutput.isEmpty() ? String.valueOf(dateinamenTeile.getPfadPlusName()) + "_mit_Text_" + image.getMax_Size() : String.valueOf(dateinamenTeile.getPfad()) + System.getProperty("file.separator") + relVerzOutput + System.getProperty("file.separator") + dateinamenTeile.getName()) + "." + dateinamenTeile.getExtend());
            FDatei.checkDatei(output.getAbsolutePath(), 'D', 'W', "Foto mit Text");
            output.deleteIfExits();
            ArrayList<String> convertParm = new ArrayList<String>();
            convertParm.add("-resize");
            convertParm.add(String.valueOf(image.getMax_Size()) + "x" + image.getMax_Size() + ">");
            convertParm.add("-define");
            convertParm.add("jpeg:extent=" + FDatei.getImageOptimalFilesizeKB(FDatei.getImageResizeAnzahlPixel(image.getBild_Breite(), image.getBild_Hoehe(), 0, 1920)) + "KB");
            if (printMethode.compareToIgnoreCase("Titel") == 0) {
                convertParm = image.getPrintTitel(convertParm, titelUmbrechenNach);
                convertParm = image.getPrintRechte(convertParm);
            } else {
                convertParm = image.getPrintBeschreibungFlaecheErweitern(convertParm);
                convertParm = image.getPrintBeschreibung(convertParm);
                convertParm = image.getPrintGPSAngaben(convertParm);
                convertParm = image.getPrintKuenstler(convertParm);
                convertParm = image.getPrintRechte(convertParm);
                convertParm = image.getPrintAufnahmeDetails(convertParm);
                convertParm = image.getPrintDateiname(convertParm);
            }
            convertParm.add(medium.getAbsolutePath());
            convertParm.add(output.getAbsolutePath());
            String[] parm = FString.arrayListToStringArray(convertParm);
            FBefehl.aufrufBefehl(Futi.getBenutzerWert("ImageMagickConvert"), parm, FDatei.getMsgLevelMedien());
            FDatei.setImageQuality2Exif(output.getAbsolutePath(), true);
        } else {
            FProt.instance().prot(String.valueOf(medium.getAbsolutePath()) + " kein Foto oder nicht vorhanden", 0);
        }
    }

    public DateinamenTeile zerlegeDateiname(String Dateiname) {
        return this.zerlegeDateiname(Dateiname, "");
    }

    public DateinamenTeile zerlegeDateiname(String Dateiname, String EndeBaseIgnorierenAb) {
        int pos_IgnoreAb;
        DateinamenTeile dateinamenTeile = new DateinamenTeile();
        dateinamenTeile.init();
        int pos_Backslash = Dateiname.lastIndexOf(System.getProperty("file.separator"));
        int pos_Punkt = Dateiname.lastIndexOf(".");
        if (pos_Punkt < pos_Backslash) {
            pos_Punkt = -1;
        }
        if (pos_Backslash < 0) {
            if (pos_Punkt < 0) {
                dateinamenTeile.setName(Dateiname);
            } else {
                dateinamenTeile.setName(Dateiname.substring(0, pos_Punkt));
                dateinamenTeile.setExtend(Dateiname.substring(pos_Punkt + 1));
            }
        } else if (pos_Punkt < 0) {
            dateinamenTeile.setPfad(Dateiname.substring(0, pos_Backslash));
            dateinamenTeile.setName(Dateiname.substring(pos_Backslash + 1));
        } else {
            dateinamenTeile.setPfad(Dateiname.substring(0, pos_Backslash));
            dateinamenTeile.setName(Dateiname.substring(pos_Backslash + 1, pos_Punkt));
            dateinamenTeile.setExtend(Dateiname.substring(pos_Punkt + 1));
        }
        pos_Backslash = dateinamenTeile.getPfad().lastIndexOf(System.getProperty("file.separator"));
        if (pos_Backslash >= 0 && dateinamenTeile.getPfad().length() > pos_Backslash) {
            dateinamenTeile.setParent(dateinamenTeile.getPfad().substring(pos_Backslash + 1));
        }
        dateinamenTeile.setBaseBis_EndeBaseIgnorierenAb(dateinamenTeile.getName());
        dateinamenTeile.setBaseBis_EndeBaseIgnorierenAbUndNummerisch(dateinamenTeile.getName());
        if (EndeBaseIgnorierenAb != null && EndeBaseIgnorierenAb.length() > 0 && (pos_IgnoreAb = dateinamenTeile.getName().lastIndexOf(EndeBaseIgnorierenAb)) > 0 && dateinamenTeile.getName().length() > pos_IgnoreAb) {
            dateinamenTeile.setBaseBis_EndeBaseIgnorierenAb(dateinamenTeile.getName().substring(0, pos_IgnoreAb));
            if (dateinamenTeile.getName().length() > pos_IgnoreAb + 1 && dateinamenTeile.getName().charAt(pos_IgnoreAb + 1) >= '0' && dateinamenTeile.getName().charAt(pos_IgnoreAb + 1) <= '9') {
                dateinamenTeile.setBaseBis_EndeBaseIgnorierenAbUndNummerisch(dateinamenTeile.getName().substring(0, pos_IgnoreAb));
                dateinamenTeile.setNumerischesEndeVonBas(dateinamenTeile.getName().substring(pos_IgnoreAb + 1));
            }
        }
        String CheckString = "jjjj.mm.tt-hh.mm.ss_B";
        String CheckDateiname = dateinamenTeile.getPfad().replaceFirst("\\d\\d\\d\\d.\\d\\d.\\d\\d-\\d\\d.\\d\\d.\\d\\d_[I|F]", "jjjj.mm.tt-hh.mm.ss_B");
        int pos = CheckDateiname.indexOf("jjjj.mm.tt-hh.mm.ss_B");
        if (pos > 0) {
            dateinamenTeile.setBackupVerzeichnis(dateinamenTeile.getPfad().substring(0, pos + "jjjj.mm.tt-hh.mm.ss_B".length()));
            if (dateinamenTeile.getPfad().length() > pos + "jjjj.mm.tt-hh.mm.ss_B".length()) {
                dateinamenTeile.setPfad_ohne_BackupVerzeichnis(dateinamenTeile.getPfad().substring(pos + "jjjj.mm.tt-hh.mm.ss_B".length() + 1));
            }
        }
        return dateinamenTeile;
    }

    public static void gpsOrtsdatenCreateAliasMitVerzeichnisstruktur(String verz, String zielVerz, boolean nurTest) {
        FProt.instance().prot("Verzeichnisstruktur wird: " + zielVerz + "/Country/State[/City[/Location]]");
        String[] namen = new String[]{"-Filename", "-Directory", "-XMP:CountryCode", "-XMP:Country", "-XMP:State", "-XMP:City", "-XMP:Location", verz};
        String[][] medien = FDatei.clearTags(FString.convertStringArrayToTabelle(FQuickSort.instance().quickSort(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), FString.verbindenStringArray(new String[]{"-T", "-r", "-ext", "JPEG", "-ext", "JPG", "-ext", "PNG", "-ext", "MP4", "-ext", "GIF", "-ext", "MOV"}, namen)), 5), "UTF-8")), namen.length, true));
        int i = 0;
        while (i < medien.length) {
            String von = String.valueOf(medien[i][1]) + System.getProperty("file.separator") + medien[i][0];
            String countryCode = medien[i][2];
            String country = medien[i][3];
            String verzRel = "";
            if (!countryCode.isEmpty() && !country.isEmpty()) {
                verzRel = String.valueOf(verzRel) + System.getProperty("file.separator") + country;
                int j = 4;
                while (j <= 6) {
                    if (!medien[i][j].isEmpty()) {
                        verzRel = String.valueOf(verzRel) + System.getProperty("file.separator") + medien[i][j];
                    }
                    ++j;
                }
            }
            if (verzRel.isEmpty()) {
                FProt.instance().prot(String.valueOf(von) + "\that keine gueltigen Ortsdaten");
            } else {
                File alias = new File(zielVerz, String.valueOf(verzRel) + System.getProperty("file.separator") + medien[i][0]);
                if (alias.exists()) {
                    FProt.instance().prot(String.valueOf(von) + "\tist bereits vorhanden");
                } else {
                    FProt.instance().prot(String.valueOf(von) + "\talias " + (nurTest ? "to create\t" : "\tcreated\t") + alias);
                    if (!nurTest) {
                        File aliasVerz = new File(zielVerz, verzRel);
                        if (!aliasVerz.exists()) {
                            aliasVerz.mkdirs();
                        }
                        FBefehl.aufrufBefehl("ln", new String[]{"-s", von, alias.getAbsolutePath()});
                    }
                }
            }
            ++i;
        }
    }

    public class DateinamenTeile {
        private String Pfad;
        private String Name;
        private String Extend;
        private String Parent;
        private String BaseBis_EndeBaseIgnorierenAb;
        private String BaseBis_EndeBaseIgnorierenAbUndNummerisch;
        private String NumerischesEndeVonBas;
        private String BackupVerzeichnis;
        private String Pfad_ohne_BackupVerzeichnis;

        public String getBackupVerzeichnis() {
            return this.BackupVerzeichnis;
        }

        public String getBaseBis_EndeBaseIgnorierenAb() {
            return this.BaseBis_EndeBaseIgnorierenAb;
        }

        public String getBaseBis_EndeBaseIgnorierenAbUndNummerisch() {
            return this.BaseBis_EndeBaseIgnorierenAbUndNummerisch;
        }

        public String getExtend() {
            return this.Extend;
        }

        public String getName() {
            return this.Name;
        }

        public String getNamePlusExtend() {
            return String.valueOf(this.Name) + "." + this.Extend;
        }

        public String getNumerischesEndeVonBas() {
            return this.NumerischesEndeVonBas;
        }

        public String getNumerischesEndeVonBas4stellig() {
            String erg = this.NumerischesEndeVonBas;
            if (erg.length() < 4) {
                erg = ("0000" + erg).substring(erg.length());
            } else if (erg.length() > 4) {
                erg = erg.substring(erg.length() - 4);
            }
            return erg;
        }

        public String getParent() {
            return this.Parent;
        }

        public String getPfad() {
            return this.Pfad;
        }

        public String getPfad_ohne_BackupVerzeichnis() {
            return this.Pfad_ohne_BackupVerzeichnis;
        }

        public String getPfadPlusName() {
            return String.valueOf(this.Pfad) + System.getProperty("file.separator") + this.Name;
        }

        void init() {
            this.setPfad("");
            this.setName("");
            this.setExtend("");
            this.setParent("");
            this.setBaseBis_EndeBaseIgnorierenAb("");
            this.setBaseBis_EndeBaseIgnorierenAbUndNummerisch("");
            this.setNumerischesEndeVonBas("");
            this.setBackupVerzeichnis("");
            this.setPfad_ohne_BackupVerzeichnis("");
        }

        void setBackupVerzeichnis(String backupVerzeichnis) {
            this.BackupVerzeichnis = backupVerzeichnis;
        }

        void setBaseBis_EndeBaseIgnorierenAb(String baseBis_EndeBaseIgnorierenAb) {
            this.BaseBis_EndeBaseIgnorierenAb = baseBis_EndeBaseIgnorierenAb;
        }

        void setBaseBis_EndeBaseIgnorierenAbUndNummerisch(String baseBis_EndeBaseIgnorierenAbUndNummerisch) {
            this.BaseBis_EndeBaseIgnorierenAbUndNummerisch = baseBis_EndeBaseIgnorierenAbUndNummerisch;
        }

        void setExtend(String extend) {
            this.Extend = extend;
        }

        void setName(String name) {
            this.Name = name;
        }

        void setNumerischesEndeVonBas(String numerischesEndeVonBas) {
            this.NumerischesEndeVonBas = numerischesEndeVonBas;
        }

        void setParent(String parent) {
            this.Parent = parent;
        }

        void setPfad(String pfad) {
            this.Pfad = pfad;
        }

        void setPfad_ohne_BackupVerzeichnis(String pfad_ohne_BackupVerzeichnis) {
            this.Pfad_ohne_BackupVerzeichnis = pfad_ohne_BackupVerzeichnis;
        }

        public void show() {
            FProt fProt = FProt.instance();
            fProt.prot("BackupVerzeichnis: " + this.getBackupVerzeichnis());
            fProt.prot("BaseBis_EndeBaseIgnorierenAb: " + this.getBaseBis_EndeBaseIgnorierenAb());
            fProt.prot("BaseBis_EndeBaseIgnorierenAbUndNummerisch: " + this.getBaseBis_EndeBaseIgnorierenAbUndNummerisch());
            fProt.prot("Extend: " + this.getExtend());
            fProt.prot("Name: " + this.getName());
            fProt.prot("NamePlusExtend: " + this.getNamePlusExtend());
            fProt.prot("NumerischesEndeVonBas: " + this.getNumerischesEndeVonBas());
            fProt.prot("NumerischesEndeVonBas4stellig: " + this.getNumerischesEndeVonBas4stellig());
            fProt.prot("Parent: " + this.getParent());
            fProt.prot("Pfad: " + this.getPfad());
            fProt.prot("Pfad_ohne_BackupVerzeichnis: " + this.getPfad_ohne_BackupVerzeichnis());
            fProt.prot("getPfadPlusName: " + this.getPfadPlusName());
        }
    }

    public class Exif2Text {
        private String Dateiname;
        private String XMP_Country;
        private String XMP_State;
        private String XMP_City;
        private String XMP_Location;
        private String Datum_Text;
        private final String[] Links_Oben = new String[]{"", "", "", "", "", ""};
        private final String[] Rechts_Oben = new String[]{"", "", "", "", ""};
        private final String[] Beschreibung = new String[]{"", "", ""};
        private String XMP_ImageDescription;
        private String XMP_Label;
        private String XMP_Nickname;
        private String Artist;
        private String Copyright;
        private int Bild_Breite = 0;
        private int Annotate1 = 0;
        private int Annotate2 = 0;
        private int Bild_Hoehe = 0;
        private boolean Datum_statt_Rechte;
        private boolean Hoehe_statt_Kuenstler;
        private boolean Hoehe_statt_Rechte;
        private String Font = Futi.getBenutzerWert("ExiftoolTAHOMA");
        private int Max_Size = 1920;
        private int Pointsize;
        private int PrintZeileVersion = 1;
        private boolean PrintManuellerZeilenumbruch = false;
        private float Faktor_Fontsize = 0.031f;
        private float Faktor_Stroke = 0.133f;
        private float Faktor_Anno1 = 0.266f;
        private float Faktor_Anno2 = 0.75f;
        private double Faktor_Resize;
        private final float Zeilen_Abstand = 1.7f;
        private float Faktor_Fontsize_Rechte = 0.7f;
        private float Faktor_Fontsize_Titel = 2.0f;
        private boolean Print_Aufnahme_Details;
        private boolean Print_Dateiname;
        private boolean Print_GPS_Angaben;
        private boolean Print_Beschreibung;
        private boolean Print_Beschreibung_Flaeche_erweitern;
        private String TextOnImage;
        private char DatePrecision = (char)48;
        private int Kurze_Seite = 0;
        private String Model;
        private String ModelNotice;
        private String SerialNumber;
        private String Objektiv;
        private String Messart;
        private String Lichtwert;
        private String Programm;
        private String Titel;
        private String Start;
        private String Ende;
        private String ISO;
        private String Blende;
        private String Verschlusszeit;
        private String Brennweite;
        private int Strokewidth;
        private String Kuenstler;
        private String Hoehe;
        private String Latitude;
        private String Longitude;
        private int Print_Beschreibung_Anzahl_Zeilen;
        private String ScanInfo;
        private boolean Print_Kuenstler;
        private int Show_Kuenstler = 0;
        private int Show_Rechte = 0;
        private boolean Print_Rechte;
        private String Foto_aus_dem_Internet;

        private int getAnnotate1() {
            return this.Annotate1;
        }

        private int getAnnotate2() {
            return this.Annotate2;
        }

        private String getArtist() {
            return this.Artist;
        }

        String[] getBeschreibung() {
            return this.Beschreibung;
        }

        int getBild_Breite() {
            return this.Bild_Breite;
        }

        int getBild_Hoehe() {
            return this.Bild_Hoehe;
        }

        private String getBlende() {
            return this.Blende;
        }

        private String getBrennweite() {
            return this.Brennweite;
        }

        private String getCopyright() {
            return this.Copyright;
        }

        private String getDateiname() {
            return this.Dateiname;
        }

        public String[] getDaten4Diashow() {
            return new String[]{this.getLatitude(), this.getLongitude(), this.getHoehe(), FString.stringArrayToString(this.getLinks_Oben(), ", ", true).replaceAll(", Details siehe Tag Exif:SEMInfo", "").replaceAll(", Teilbild,", ",").replaceAll(", Nicht definiert,", ",")};
        }

        private char getDatePrecision() {
            return this.DatePrecision;
        }

        private String getDatum_Text() {
            return this.Datum_Text;
        }

        private String getEnde() {
            return this.Ende;
        }

        private float getFaktor_Anno1() {
            return this.Faktor_Anno1;
        }

        private float getFaktor_Anno2() {
            return this.Faktor_Anno2;
        }

        private float getFaktor_Fontsize() {
            return this.Faktor_Fontsize;
        }

        private float getFaktor_Fontsize_Rechte() {
            return this.Faktor_Fontsize_Rechte;
        }

        private float getFaktor_Fontsize_Titel() {
            return this.Faktor_Fontsize_Titel;
        }

        private double getFaktor_Resize() {
            return this.Faktor_Resize;
        }

        private float getFaktor_Stroke() {
            return this.Faktor_Stroke;
        }

        private String getFont() {
            return this.Font;
        }

        private String getFoto_aus_dem_Internet() {
            return this.Foto_aus_dem_Internet;
        }

        private String getHoehe() {
            return this.Hoehe;
        }

        private int getInteger(String input) {
            int aus = 0;
            try {
                aus = Integer.parseInt(input);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return aus;
        }

        private String getISO() {
            return this.ISO;
        }

        private String getKuenstler() {
            return this.Kuenstler;
        }

        private int getKurze_Seite() {
            return this.Kurze_Seite;
        }

        private String getLatitude() {
            return this.Latitude;
        }

        private String getLichtwert() {
            return this.Lichtwert;
        }

        public String[] getLinks_Oben() {
            return this.Links_Oben;
        }

        private String getLongitude() {
            return this.Longitude;
        }

        int getMax_Size() {
            return this.Max_Size;
        }

        private String getMessart() {
            return this.Messart;
        }

        private String getModel() {
            return this.Model;
        }

        private String getModelNotice() {
            return this.ModelNotice;
        }

        private String getObjektiv() {
            return this.Objektiv;
        }

        private int getPointsize() {
            return this.Pointsize;
        }

        private int getPrint_Beschreibung_Anzahl_Zeilen() {
            return this.Print_Beschreibung_Anzahl_Zeilen;
        }

        ArrayList<String> getPrintAufnahmeDetails(ArrayList<String> PrintZeile) {
            if (this.isPrint_Aufnahme_Details()) {
                String pointsize = "" + FMath.punkt5abrunden((float)this.getPointsize() * this.getFaktor_Fontsize_Rechte());
                int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Rechte());
                if (this.isPrintManuellerZeilenumbruch()) {
                    float zeilen_Abstand = this.getZeilen_Abstand() * this.getFaktor_Fontsize_Rechte();
                    int i = 0;
                    while (i < this.getLinks_Oben().length) {
                        this.getPrintZeile(PrintZeile, "NorthWest", pointsize, strokewidth, zeilen_Abstand, i, this.getLinks_Oben()[i]);
                        ++i;
                    }
                } else {
                    this.getPrintZeile(PrintZeile, "NorthWest", pointsize, strokewidth, FString.zusammenfuegenStringArray(this.getLinks_Oben(), "\n"));
                }
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintBeschreibung(ArrayList<String> PrintZeile) {
            if (this.isPrint_Beschreibung()) {
                String pointsize = "" + this.getPointsize();
                int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Rechte());
                if (this.isPrintManuellerZeilenumbruch()) {
                    int i = 0;
                    while (i < this.getBeschreibung().length) {
                        this.getPrintZeile(PrintZeile, "South", pointsize, strokewidth, 0, this.getAnnotate2(), this.getZeilen_Abstand(), this.getBeschreibung().length - 1 - i, this.getBeschreibung()[i]);
                        ++i;
                    }
                } else {
                    this.getPrintZeile(PrintZeile, "South", pointsize, strokewidth, 0, this.getAnnotate2(), FString.zusammenfuegenStringArray(this.getBeschreibung(), "\n"));
                }
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintBeschreibungFlaecheErweitern(ArrayList<String> PrintZeile) {
            if (this.isPrint_Beschreibung_Flaeche_erweitern()) {
                int print_Beschreibung_Anzahl_Zeilen = this.isPrint_Beschreibung() ? this.getPrint_Beschreibung_Anzahl_Zeilen() : 0;
                PrintZeile.add("-background");
                PrintZeile.add("white");
                PrintZeile.add("-splice");
                PrintZeile.add("0x" + FMath.punkt5abrunden(((double)print_Beschreibung_Anzahl_Zeilen * 1.3 + 0.7) * (double)this.getPointsize() + (double)((float)print_Beschreibung_Anzahl_Zeilen * this.getZeilen_Abstand())));
                PrintZeile.add("-gravity");
                PrintZeile.add("South");
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintDateiname(ArrayList<String> PrintZeile) {
            if (this.isPrint_Dateiname()) {
                String pointsize = "" + FMath.punkt5abrunden((float)this.getPointsize() * this.getFaktor_Fontsize_Rechte());
                int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Rechte());
                this.getPrintZeile(PrintZeile, "South", pointsize, strokewidth, this.getAnnotate1(), 0, this.getZeilen_Abstand(), 0, this.getDateiname());
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintGPSAngaben(ArrayList<String> PrintZeile) {
            if (this.isPrint_GPS_Angaben()) {
                String pointsize = "" + this.getPointsize();
                int strokewidth = this.getStrokewidth();
                if (this.isPrintManuellerZeilenumbruch()) {
                    int i = 0;
                    while (i < this.getRechts_Oben().length) {
                        this.getPrintZeile(PrintZeile, "NorthEast", pointsize, strokewidth, this.getZeilen_Abstand(), i, this.getRechts_Oben()[i]);
                        ++i;
                    }
                } else {
                    this.getPrintZeile(PrintZeile, "NorthEast", pointsize, strokewidth, FString.zusammenfuegenStringArray(this.getRechts_Oben(), "\n"));
                }
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintKuenstler(ArrayList<String> PrintZeile) {
            if (this.isPrint_Kuenstler()) {
                String kuenstler;
                String pointsize = "" + FMath.punkt5abrunden((float)this.getPointsize() * this.getFaktor_Fontsize_Rechte());
                int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Rechte());
                String string = kuenstler = this.isHoehe_statt_Kuenstler() ? String.valueOf(this.getHoehe()) + " m" : this.getKuenstler();
                if (this.getShow_Kuenstler() == 0) {
                    kuenstler = kuenstler.replaceAll("Gerlinde Fischer, Neusaess", "G");
                    kuenstler = kuenstler.replaceAll("Johann Fischer, Neusaess", "");
                } else if (this.getShow_Kuenstler() == 1) {
                    kuenstler = kuenstler.replaceAll("Gerlinde Fischer, Neusaess", "G");
                    kuenstler = kuenstler.replaceAll("Johann Fischer, Neusaess", "H");
                }
                kuenstler = kuenstler.length() > 1 ? "(" + kuenstler + ")" : kuenstler;
                this.getPrintZeile(PrintZeile, "SouthWest", pointsize, strokewidth, this.getAnnotate1(), 0, this.getZeilen_Abstand(), 0, kuenstler);
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintRechte(ArrayList<String> PrintZeile) {
            if (this.isPrint_Rechte()) {
                String rechte;
                String pointsize = "" + FMath.punkt5abrunden((float)this.getPointsize() * this.getFaktor_Fontsize_Rechte());
                int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Rechte());
                String string = rechte = this.isHoehe_statt_Rechte() ? String.valueOf(this.getHoehe()) + " m" : this.getCopyright();
                if (this.getShow_Rechte() == 0) {
                    rechte = rechte.replaceAll("Johann Fischer, Neusaess", "");
                }
                this.getPrintZeile(PrintZeile, "SouthEast", pointsize, strokewidth, this.getAnnotate1(), 0, this.getZeilen_Abstand(), 0, this.isDatum_statt_Rechte() ? this.getDatum_Text() : String.valueOf(rechte.isEmpty() ? "" : (this.isHoehe_statt_Rechte() ? "(" : "(c) ")) + rechte + this.getFoto_aus_dem_Internet() + (this.isHoehe_statt_Rechte() ? ")" : ""));
            }
            return PrintZeile;
        }

        ArrayList<String> getPrintTitel(ArrayList<String> PrintZeile) {
            return this.getPrintTitel(PrintZeile, 0);
        }

        ArrayList<String> getPrintTitel(ArrayList<String> PrintZeile, int titelUmbrechenNach) {
            String pointsize = "" + FMath.punkt5abrunden((float)this.getPointsize() * this.getFaktor_Fontsize_Titel());
            int strokewidth = FMath.punkt5abrunden((float)this.getStrokewidth() * this.getFaktor_Fontsize_Titel());
            this.getPrintZeile(PrintZeile, "Center", pointsize, strokewidth, 0, 0, this.getTitel().isEmpty() ? "kein Titel vorhanden, Exif-Tag Album leer" : (titelUmbrechenNach >= 10 && this.getTitel().length() > titelUmbrechenNach ? FString.zusammenfuegenStringArray(FString.zerlegeString(this.getTitel(), " ", titelUmbrechenNach), "\n") : this.getTitel()));
            pointsize = "" + this.getPointsize();
            strokewidth = this.getStrokewidth();
            this.getPrintZeile(PrintZeile, "Northwest", pointsize, strokewidth, 0, 0, this.getStart());
            this.getPrintZeile(PrintZeile, "Northeast", pointsize, strokewidth, 0, 0, this.getEnde());
            return PrintZeile;
        }

        private ArrayList<String> getPrintZeile(ArrayList<String> PrintZeile, String gravity, String pointsize, int strokewidth, float zeilen_Abstand, int zeileNr, String text) {
            return this.getPrintZeile(PrintZeile, gravity, pointsize, strokewidth, this.getAnnotate1(), this.getAnnotate2(), zeilen_Abstand, zeileNr, text);
        }

        private ArrayList<String> getPrintZeile(ArrayList<String> PrintZeile, String gravity, String pointsize, int strokewidth, int annotate1, int annotate2, float zeilen_Abstand, int zeileNr, String text) {
            if (!text.isEmpty()) {
                boolean textNurSchwarz;
                boolean bl = textNurSchwarz = this.isPrint_Beschreibung_Flaeche_erweitern() && (gravity.startsWith("South") || gravity.startsWith("south"));
                if (this.getPrintZeileVersion() == 2) {
                    this.getPrintZeile_V2(PrintZeile, gravity, pointsize, strokewidth, annotate1, annotate2, zeilen_Abstand, zeileNr, text);
                } else {
                    PrintZeile.add("-gravity");
                    PrintZeile.add(gravity);
                    PrintZeile.add("-font");
                    PrintZeile.add(this.getFont());
                    PrintZeile.add("-pointsize");
                    PrintZeile.add(pointsize);
                    PrintZeile.add("-fill");
                    PrintZeile.add("black");
                    if (!textNurSchwarz) {
                        PrintZeile.add("-stroke");
                        PrintZeile.add("#000C");
                        PrintZeile.add("-strokewidth");
                        PrintZeile.add("" + strokewidth);
                    }
                    PrintZeile.add("-annotate");
                    PrintZeile.add("+" + annotate1 + "+" + FMath.punkt5abrunden((float)annotate2 * (1.0f + (float)zeileNr * zeilen_Abstand)));
                    PrintZeile.add(text);
                    if (!textNurSchwarz) {
                        PrintZeile.add("-stroke");
                        PrintZeile.add("none");
                        PrintZeile.add("-fill");
                        PrintZeile.add("white");
                        PrintZeile.add("-annotate");
                        PrintZeile.add("+" + annotate1 + "+" + FMath.punkt5abrunden((float)annotate2 * (1.0f + (float)zeileNr * zeilen_Abstand)));
                        PrintZeile.add(text);
                    }
                }
            }
            return PrintZeile;
        }

        private ArrayList<String> getPrintZeile(ArrayList<String> PrintZeile, String gravity, String pointsize, int strokewidth, int annotate1, int annotate2, String text) {
            return this.getPrintZeile(PrintZeile, gravity, pointsize, strokewidth, annotate1, annotate2, 0.0f, 0, text);
        }

        private ArrayList<String> getPrintZeile(ArrayList<String> PrintZeile, String gravity, String pointsize, int strokewidth, String text) {
            return this.getPrintZeile(PrintZeile, gravity, pointsize, strokewidth, this.getAnnotate1(), this.getAnnotate2(), 0.0f, 0, text);
        }

        private ArrayList<String> getPrintZeile_V2(ArrayList<String> PrintZeile, String gravity, String pointsize, int strokewidthIn, int annotate1, int annotate2In, float zeilen_Abstand, int zeileNr, String text) {
            if (!text.isEmpty()) {
                boolean textNurSchwarz = this.isPrint_Beschreibung_Flaeche_erweitern() && (gravity.startsWith("South") || gravity.startsWith("south"));
                int annotate2 = FMath.punkt5abrunden((float)annotate2In * (1.0f + (float)zeileNr * zeilen_Abstand));
                int strokewidth = FMath.checkRange(strokewidthIn - 2, 1, 1);
                PrintZeile.add("-font");
                PrintZeile.add(this.getFont());
                PrintZeile.add("-pointsize");
                PrintZeile.add(pointsize);
                PrintZeile.add("-draw");
                String fill = "gravity " + gravity;
                if (textNurSchwarz) {
                    fill = String.valueOf(fill) + " fill black text " + annotate1 + "," + annotate2 + " '" + text + "'";
                } else {
                    fill = String.valueOf(fill) + " fill black text " + (annotate1 - strokewidth) + "," + (annotate2 + strokewidth) + " '" + text + "'";
                    fill = String.valueOf(fill) + " fill black text " + (annotate1 + strokewidth) + "," + (annotate2 + strokewidth) + " '" + text + "'";
                    fill = String.valueOf(fill) + " fill black text " + (annotate1 - strokewidth) + "," + (annotate2 - strokewidth) + " '" + text + "'";
                    fill = String.valueOf(fill) + " fill black text " + (annotate1 + strokewidth) + "," + (annotate2 - strokewidth) + " '" + text + "'";
                    fill = String.valueOf(fill) + " fill white text " + annotate1 + "," + annotate2 + " '" + text + "'";
                }
                PrintZeile.add(fill);
            }
            return PrintZeile;
        }

        private int getPrintZeileVersion() {
            return this.PrintZeileVersion;
        }

        private String getProgramm() {
            return this.Programm;
        }

        String[] getRechts_Oben() {
            return this.Rechts_Oben;
        }

        private String getScanInfo() {
            return this.ScanInfo;
        }

        private String getSerialNumber() {
            return this.SerialNumber;
        }

        private int getShow_Kuenstler() {
            return this.Show_Kuenstler;
        }

        private int getShow_Rechte() {
            return this.Show_Rechte;
        }

        private String getStart() {
            return this.Start;
        }

        private int getStrokewidth() {
            return this.Strokewidth;
        }

        private String getTextOnImage() {
            return this.TextOnImage;
        }

        private String getTitel() {
            return this.Titel;
        }

        private String getVerschlusszeit() {
            return this.Verschlusszeit;
        }

        private String getXMP_City() {
            return this.XMP_City;
        }

        private String getXMP_Country() {
            return this.XMP_Country;
        }

        private String getXMP_ImageDescription() {
            return this.XMP_ImageDescription;
        }

        private String getXMP_Label() {
            return this.XMP_Label;
        }

        private String getXMP_Location() {
            return this.XMP_Location;
        }

        private String getXMP_Nickname() {
            return this.XMP_Nickname;
        }

        private String getXMP_State() {
            return this.XMP_State;
        }

        private float getZeilen_Abstand() {
            return 1.7f;
        }

        private boolean isDatum_statt_Rechte() {
            return this.Datum_statt_Rechte;
        }

        private boolean isHoehe_statt_Kuenstler() {
            return this.Hoehe_statt_Kuenstler;
        }

        private boolean isHoehe_statt_Rechte() {
            return this.Hoehe_statt_Rechte;
        }

        private boolean isPrint_Aufnahme_Details() {
            return this.Print_Aufnahme_Details;
        }

        private boolean isPrint_Beschreibung() {
            return this.Print_Beschreibung;
        }

        private boolean isPrint_Beschreibung_Flaeche_erweitern() {
            return this.Print_Beschreibung_Flaeche_erweitern;
        }

        private boolean isPrint_Dateiname() {
            return this.Print_Dateiname;
        }

        private boolean isPrint_GPS_Angaben() {
            return this.Print_GPS_Angaben;
        }

        private boolean isPrint_Kuenstler() {
            return this.Print_Kuenstler;
        }

        private boolean isPrint_Rechte() {
            return this.Print_Rechte;
        }

        private boolean isPrintManuellerZeilenumbruch() {
            return this.PrintManuellerZeilenumbruch;
        }

        private boolean isScan() {
            return !this.getScanInfo().isEmpty();
        }

        private void setAnnotate1(int annotate1) {
            this.Annotate1 = annotate1;
        }

        private void setAnnotate2(int annotate2) {
            this.Annotate2 = annotate2;
        }

        private void setArtist(String artist) {
            this.Artist = artist;
        }

        private void setBeschreibung(String beschreibung, int zeile) {
            this.Beschreibung[FMath.checkRange((int)zeile, (int)0, (int)(this.Beschreibung.length - 1))] = beschreibung;
        }

        private void setBild_Breite(int bild_Breite) {
            this.Bild_Breite = bild_Breite;
        }

        private void setBild_Hoehe(int bild_Hoehe) {
            this.Bild_Hoehe = bild_Hoehe;
        }

        private void setBlende(String blende) {
            this.Blende = blende;
        }

        private void setBrennweite(String brennweite) {
            this.Brennweite = brennweite;
        }

        private void setCopyright(String copyright) {
            this.Copyright = copyright;
        }

        public void setData(String dateiname) {
            String[][] tags = FString.convertStringArrayToTabelle(FString.convertStringArrayFromCharset(FBefehl.aufrufBefehl("exiftool", FString.verbindenStringArray(Futi.getBenutzerWert("ExiftoolParameter").split(" "), new String[]{"-lang", "de", "-c", "%+.8g", "-T", "-ImageDescriptionDurchschauMimik", "-xmp:Label", "-xmp:Nickname", "-xmp:Country", "-xmp:State", "-xmp:City", "-xmp:Location", "-Artist", "-Copyright", "-DateTimeOriginal", "-DatePrecision", "-TextOnImage", "-ImageWidth", "-ImageHeight", "-AlbumDurchschauMimik", "-VonDatumDurchschauMimik", "-BisDatumDurchschauMimik", "-ScanInfo", "-Model", "-ModelOriginal", "-ModelNotice", "-SerialNumber", "-LensModel", "-MeteringMode", "-ExposureProgram", "-LightValue", "-ISO", "-Aperture", "-ExposureTime", "-FocalLength", "-FocalLengthIn35mmFormat", "-GPSAltitude#", "-GPSLatitude", "-GPSLongitude", dateiname}), 5), "UTF-8"), 40, true);
            String[] tag = new String[40];
            if (tags.length == 0) {
                int i = 0;
                while (i < tag.length) {
                    tag[i] = "";
                    ++i;
                }
            } else {
                tags = FDatei.clearTags(tags);
                tag = tags[0];
            }
            DateinamenTeile dateinamenTeile = FDatei.instance().zerlegeDateiname(dateiname);
            this.setDateiname(dateinamenTeile.getName());
            this.setXMP_ImageDescription(tag[0]);
            this.setXMP_Label(tag[1]);
            this.setXMP_Nickname(tag[2]);
            this.setXMP_Country(tag[3]);
            this.setXMP_State(tag[4]);
            this.setXMP_City(tag[5]);
            this.setXMP_Location(tag[6]);
            this.setArtist(tag[7]);
            this.setCopyright(tag[8]);
            FGregorianCalendar datum = new FGregorianCalendar();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            try {
                datum.setTime(dateFormat.parse(tag[9]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setDatePrecision((String.valueOf(FMath.checkRange(this.getInteger(tag[10]), 0, 6)) + " ").charAt(0));
            this.setDatum_Text(datum.toGermanFormat(this.getDatePrecision()));
            this.setTextOnImage(tag[11]);
            this.setBild_Breite(this.getInteger(tag[12]));
            this.setBild_Hoehe(this.getInteger(tag[13]));
            this.setTitel(tag[14]);
            this.setStart(tag[15]);
            this.setEnde(tag[16]);
            this.setScanInfo(tag[17]);
            this.setModel(tag[19].isEmpty() ? tag[18] : tag[19]);
            this.setModelNotice(tag[20]);
            this.setSerialNumber(tag[21]);
            this.setObjektiv(tag[22]);
            this.setMessart(tag[23]);
            this.setProgramm(tag[24]);
            this.setLichtwert(tag[25]);
            this.setISO(tag[26]);
            this.setBlende(tag[27]);
            this.setVerschlusszeit(tag[28]);
            this.setBrennweite(tag[30].isEmpty() ? tag[29] : tag[30]);
            this.setHoehe(tag[31]);
            this.setLatitude(tag[32]);
            this.setLongitude(tag[33]);
            this.setPrintMethode(this.getTextOnImage());
            this.setFoto_aus_dem_Internet(this.getSerialNumber().compareToIgnoreCase("DownloadFromWeb") == 0 ? " (freies Foto aus dem Internet)" : "");
            this.setKuenstler(this.getArtist().compareToIgnoreCase("unbekannt") == 0 || this.getArtist().compareToIgnoreCase("unknown") == 0 ? "" : this.getArtist());
            if (this.getXMP_ImageDescription().isEmpty() && this.getTextOnImage().compareToIgnoreCase("AlbumFallsImagedescriptionLeer") == 0) {
                this.setXMP_ImageDescription(this.getTitel());
                this.setTextOnImage("");
            }
            this.setPrint_Beschreibung_Anzahl_Zeilen(this.getXMP_Nickname().length() > 0 ? 3 : (this.getXMP_Label().length() > 0 ? 2 : (this.getXMP_ImageDescription().length() > 0 ? 1 : 0)));
            if (this.getPrint_Beschreibung_Anzahl_Zeilen() == 3) {
                this.setBeschreibung(this.getXMP_ImageDescription(), 0);
                this.setBeschreibung(this.getXMP_Label(), 1);
                this.setBeschreibung(this.getXMP_Nickname(), 2);
            } else if (this.getPrint_Beschreibung_Anzahl_Zeilen() == 2) {
                this.setBeschreibung(this.getXMP_ImageDescription(), 1);
                this.setBeschreibung(this.getXMP_Label(), 2);
            } else if (this.getPrint_Beschreibung_Anzahl_Zeilen() == 1) {
                this.setBeschreibung(this.getXMP_ImageDescription(), 2);
            }
            String[] ScanInfoTeile = new String[]{""};
            if (this.isScan()) {
                ScanInfoTeile = this.getScanInfo().split(",");
                this.setLinks_Oben(this.getModel(), 0);
                this.setLinks_Oben(this.getModelNotice(), 1);
                this.setLinks_Oben(ScanInfoTeile.length > 0 ? ScanInfoTeile[0].trim() : "", 2);
                this.setLinks_Oben(ScanInfoTeile.length > 1 ? ScanInfoTeile[1].trim() : "", 3);
            } else {
                this.setLinks_Oben(this.getModel(), 0);
                this.setLinks_Oben(this.getObjektiv(), 1);
                this.setLinks_Oben(this.getMessart(), 2);
                this.setLinks_Oben(this.getProgramm(), 3);
                this.setLinks_Oben(String.valueOf(this.getLichtwert().isEmpty() ? "" : "Lichtwert: " + this.getLichtwert()) + (this.getISO().isEmpty() ? "" : String.valueOf(this.getLichtwert().isEmpty() ? "" : ", ") + "ISO: " + this.getISO()), 4);
                this.setLinks_Oben(String.valueOf(this.getBlende().isEmpty() ? "" : "f: " + this.getBlende()) + (this.getVerschlusszeit().isEmpty() ? "" : String.valueOf(this.getBlende().isEmpty() ? "" : ", ") + "t: " + this.getVerschlusszeit()) + (this.getBrennweite().isEmpty() ? "" : String.valueOf(this.getBlende().isEmpty() && this.getVerschlusszeit().isEmpty() ? "" : ", ") + "F: " + this.getBrennweite()), 5);
            }
            this.setRechts_Oben(this.getDatum_Text(), 0);
            this.setRechts_Oben(this.getXMP_Country(), 1);
            this.setRechts_Oben(this.getXMP_State(), 2);
            this.setRechts_Oben(this.getXMP_City(), 3);
            this.setRechts_Oben(this.getXMP_Location().compareToIgnoreCase(this.getXMP_City()) == 0 ? "" : this.getXMP_Location(), 4);
            this.setKurze_Seite(Math.min(this.getBild_Hoehe(), this.getBild_Breite()));
            this.setFaktor_Resize(Math.min(1.0f, (float)this.getMax_Size() * 1.0f / (float)Math.max(this.getBild_Hoehe(), this.getBild_Breite())));
            this.setPointsize((int)FMath.punkt5abrunden((double)this.getKurze_Seite() * this.getFaktor_Resize() * (double)this.getFaktor_Fontsize()));
            this.setStrokewidth((int)FMath.punkt5abrunden((double)this.getKurze_Seite() * this.getFaktor_Resize() * (double)this.getFaktor_Fontsize() * (double)this.getFaktor_Stroke()));
            this.setAnnotate1((int)FMath.punkt5abrunden((double)this.getKurze_Seite() * this.getFaktor_Resize() * (double)this.getFaktor_Fontsize() * (double)this.getFaktor_Anno1()));
            this.setAnnotate2((int)FMath.punkt5abrunden((double)this.getKurze_Seite() * this.getFaktor_Resize() * (double)this.getFaktor_Fontsize() * (double)this.getFaktor_Anno2()));
            FProt.instance().prot(String.valueOf(this.Dateiname) + "\tMax-Size\t" + this.getMax_Size() + "\tKurze_Seite\t" + this.getKurze_Seite() + "\tFaktor_Resize\t" + this.getFaktor_Resize() + "\tPointsize\t" + this.getPointsize(), 2);
        }

        private void setDateiname(String dateiname) {
            this.Dateiname = dateiname;
        }

        private void setDatePrecision(char datePrecision) {
            this.DatePrecision = datePrecision;
        }

        void setDatum_statt_Rechte(boolean swap_Kuenstler_Rechte_Datum) {
            this.Datum_statt_Rechte = swap_Kuenstler_Rechte_Datum;
        }

        private void setDatum_Text(String datum_Text) {
            this.Datum_Text = datum_Text;
        }

        private void setEnde(String ende) {
            this.Ende = ende;
        }

        public void setFaktor_Anno1(float faktor_Anno1) {
            this.Faktor_Anno1 = faktor_Anno1;
        }

        public void setFaktor_Anno2(float faktor_Anno2) {
            this.Faktor_Anno2 = faktor_Anno2;
        }

        public void setFaktor_Fontsize(float faktor_Fontsize) {
            this.Faktor_Fontsize = faktor_Fontsize;
        }

        public void setFaktor_Fontsize_Rechte(float faktor_Fontsize_Rechte) {
            this.Faktor_Fontsize_Rechte = faktor_Fontsize_Rechte;
        }

        public void setFaktor_Fontsize_Titel(float faktor_Fontsize_Titel) {
            this.Faktor_Fontsize_Titel = faktor_Fontsize_Titel;
        }

        public void setFaktor_Resize(float faktor_Resize) {
            this.Faktor_Resize = faktor_Resize;
        }

        public void setFaktor_Stroke(float faktor_Stroke0) {
            this.Faktor_Stroke = faktor_Stroke0;
        }

        public void setFont(String font) {
            this.Font = font;
        }

        private void setFoto_aus_dem_Internet(String foto_aus_dem_Internet) {
            this.Foto_aus_dem_Internet = foto_aus_dem_Internet;
        }

        private void setHoehe(String hoehe) {
            this.Hoehe = hoehe;
        }

        void setHoehe_statt_Kuenstler(boolean hoehe_statt_Kuenstler) {
            this.Hoehe_statt_Kuenstler = hoehe_statt_Kuenstler;
        }

        private void setHoehe_statt_Rechte(boolean hoehe_statt_Rechte) {
            this.Hoehe_statt_Rechte = hoehe_statt_Rechte;
        }

        private void setISO(String iSO) {
            this.ISO = iSO;
        }

        private void setKuenstler(String kuenstler) {
            this.Kuenstler = kuenstler;
        }

        private void setKurze_Seite(int kurze_Seite) {
            this.Kurze_Seite = kurze_Seite;
        }

        private void setLatitude(String latitude) {
            this.Latitude = latitude;
        }

        private void setLichtwert(String lichtwert) {
            this.Lichtwert = lichtwert;
        }

        private void setLinks_Oben(String links_Oben, int zeile) {
            this.Links_Oben[FMath.checkRange((int)zeile, (int)0, (int)(this.Links_Oben.length - 1))] = links_Oben;
        }

        private void setLongitude(String longitude) {
            this.Longitude = longitude;
        }

        public void setMax_Size(int max_Size) {
            this.Max_Size = max_Size;
        }

        private void setMessart(String messart) {
            this.Messart = messart;
        }

        private void setModel(String model) {
            this.Model = model;
        }

        private void setModelNotice(String modelNotice) {
            this.ModelNotice = modelNotice;
        }

        private void setObjektiv(String objektiv) {
            this.Objektiv = objektiv;
        }

        private void setPointsize(int pointsize) {
            this.Pointsize = pointsize;
        }

        public void setPrint_Aufnahme_Details(boolean print_Aufnahme_Details) {
            this.Print_Aufnahme_Details = print_Aufnahme_Details;
        }

        public void setPrint_Beschreibung(boolean print_Beschreibung) {
            this.Print_Beschreibung = print_Beschreibung;
        }

        private void setPrint_Beschreibung_Anzahl_Zeilen(int print_Beschreibung_Anzahl_Zeilen) {
            this.Print_Beschreibung_Anzahl_Zeilen = print_Beschreibung_Anzahl_Zeilen;
        }

        void setPrint_Beschreibung_Flaeche_erweitern(boolean print_Beschreibung_Flaeche_erweitern) {
            this.Print_Beschreibung_Flaeche_erweitern = print_Beschreibung_Flaeche_erweitern;
        }

        public void setPrint_Dateiname(boolean print_Dateiname) {
            this.Print_Dateiname = print_Dateiname;
        }

        public void setPrint_GPS_Angaben(boolean print_GPS_Angaben) {
            this.Print_GPS_Angaben = print_GPS_Angaben;
        }

        public void setPrint_Kuenstler(boolean print_Kuenstler) {
            this.Print_Kuenstler = print_Kuenstler;
        }

        public void setPrint_Rechte(boolean print_Rechte) {
            this.Print_Rechte = print_Rechte;
        }

        public void setPrintManuellerZeilenumbruch(boolean printManuellerZeilenumbruch) {
            this.PrintManuellerZeilenumbruch = printManuellerZeilenumbruch;
        }

        public void setPrintMethode(String printMethode) {
            this.setPrint_Beschreibung(false);
            this.setPrint_Beschreibung_Flaeche_erweitern(false);
            this.setPrint_GPS_Angaben(false);
            this.setPrint_Kuenstler(false);
            this.setPrint_Rechte(false);
            this.setPrint_Aufnahme_Details(false);
            this.setPrint_Dateiname(false);
            this.setDatum_statt_Rechte(false);
            this.setHoehe_statt_Kuenstler(false);
            this.setHoehe_statt_Rechte(false);
            if (printMethode.isEmpty() || printMethode.compareToIgnoreCase("Reisebericht") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_GPS_Angaben(true);
                this.setPrint_Kuenstler(true);
                this.setPrint_Rechte(true);
            } else if (printMethode.compareToIgnoreCase("HoeheStattKuenstler") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_GPS_Angaben(true);
                this.setPrint_Kuenstler(true);
                this.setHoehe_statt_Kuenstler(true);
                this.setPrint_Rechte(true);
            } else if (printMethode.compareToIgnoreCase("HoeheStattRechte") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_GPS_Angaben(true);
                this.setPrint_Kuenstler(true);
                this.setHoehe_statt_Rechte(true);
                this.setPrint_Rechte(true);
            } else if (printMethode.compareToIgnoreCase("Artist") == 0) {
                this.setPrint_Kuenstler(true);
            } else if (printMethode.compareToIgnoreCase("ArtistUndZeit") == 0) {
                this.setPrint_Kuenstler(true);
                this.setPrint_Rechte(true);
                this.setDatum_statt_Rechte(true);
            } else if (printMethode.compareToIgnoreCase("nurBeschreibung") == 0) {
                this.setPrint_Beschreibung(true);
            } else if (printMethode.compareToIgnoreCase("BeschreibungUnterBild") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_Beschreibung_Flaeche_erweitern(true);
                this.setPrint_Rechte(true);
            } else if (printMethode.compareToIgnoreCase("alles") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_GPS_Angaben(true);
                this.setPrint_Kuenstler(true);
                this.setPrint_Rechte(true);
                this.setPrint_Aufnahme_Details(true);
                this.setPrint_Dateiname(true);
            } else if (printMethode.compareToIgnoreCase("allesMitErweiterung") == 0) {
                this.setPrint_Beschreibung(true);
                this.setPrint_Beschreibung_Flaeche_erweitern(true);
                this.setPrint_GPS_Angaben(true);
                this.setPrint_Kuenstler(true);
                this.setPrint_Rechte(true);
                this.setPrint_Aufnahme_Details(true);
                this.setPrint_Dateiname(true);
            } else {
                printMethode.compareToIgnoreCase("nichts");
            }
        }

        public void setPrintZeileVersion(int printZeileVersion) {
            this.PrintZeileVersion = printZeileVersion;
        }

        private void setProgramm(String programm) {
            this.Programm = programm;
        }

        private void setRechts_Oben(String rechts_Oben, int zeile) {
            this.Rechts_Oben[FMath.checkRange((int)zeile, (int)0, (int)(this.Rechts_Oben.length - 1))] = rechts_Oben;
        }

        private void setScanInfo(String scanInfo) {
            this.ScanInfo = scanInfo;
        }

        private void setSerialNumber(String serialNumber) {
            this.SerialNumber = serialNumber;
        }

        public void setShow_Kuenstler(int show_Kuenstler) {
            this.Show_Kuenstler = show_Kuenstler;
        }

        void setShow_Rechte(int show_Rechte) {
            this.Show_Rechte = show_Rechte;
        }

        private void setStart(String start) {
            this.Start = start;
        }

        private void setStrokewidth(int strokewidth) {
            this.Strokewidth = strokewidth;
        }

        private void setTextOnImage(String textOnImage) {
            this.TextOnImage = textOnImage;
        }

        private void setTitel(String titel) {
            this.Titel = titel;
        }

        private void setVerschlusszeit(String verschlusszeit) {
            this.Verschlusszeit = verschlusszeit;
        }

        private void setXMP_City(String xMP_City) {
            this.XMP_City = xMP_City;
        }

        private void setXMP_Country(String xMP_Country) {
            this.XMP_Country = xMP_Country;
        }

        private void setXMP_ImageDescription(String xMP_ImageDescription) {
            this.XMP_ImageDescription = xMP_ImageDescription;
        }

        private void setXMP_Label(String xMP_ImageDescription_Z2) {
            this.XMP_Label = xMP_ImageDescription_Z2;
        }

        private void setXMP_Location(String xMP_Location) {
            this.XMP_Location = xMP_Location;
        }

        private void setXMP_Nickname(String xMP_ImageDescription_Z3) {
            this.XMP_Nickname = xMP_ImageDescription_Z3;
        }

        private void setXMP_State(String xMP_State) {
            this.XMP_State = xMP_State;
        }
    }
}

