/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FMath;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class FGregorianCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, String> Table = new HashMap();
    private final HashMap<String, String> arbeitsfrei = new HashMap();
    private final String[] Wochentage = new String[]{"Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"};
    private final String[] Jahreszeiten = new String[]{"Fr\u00fchjahr", "Sommer", "Herbst", "Winter"};
    private final String[] Monate = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
    private final SimpleTimeZone Sommerzeit = new SimpleTimeZone(3600000, "Europe/Berlin", 2, -1, 7, 3600000, 2, 9, -1, 7, 3600000, 2, 3600000);

    public static String getZeit2StringSortierbar(int jahr, int monat, int tag, int stunde, int minute, int sekunde) {
        char[] tab = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        String rc = "";
        long dez = 0L;
        if (jahr < 1900) {
            rc = "aaaaaaa";
        } else if (jahr > 2060) {
            rc = "zzzzzzz";
        } else {
            double dezfloat = (double)(FMath.checkRange(sekunde, 0, 59) + 60 * FMath.checkRange(minute, 0, 59) + 3600 * FMath.checkRange(stunde, 0, 23) + 86400 * FMath.checkRange(tag - 1, 0, 30) + 2678400 * FMath.checkRange(monat - 1, 0, 11)) + 3.21408E7 * (double)FMath.checkRange(jahr - 1970, 0, 100);
            if (dezfloat > 2.147483647E9) {
                rc = String.valueOf(tab[(int)(dezfloat % 26.0)]) + rc;
                dez = (long)(dezfloat / 26.0);
            } else {
                dez = FMath.checkRange(sekunde, 0, 59) + 60 * FMath.checkRange(minute, 0, 59) + 3600 * FMath.checkRange(stunde, 0, 23) + 86400 * FMath.checkRange(tag - 1, 0, 30) + 2678400 * FMath.checkRange(monat - 1, 0, 11) + 32140800 * FMath.checkRange(jahr - 1970, 0, 100);
            }
            long dezDecr = dez / 26L;
            while (dezDecr > 0L) {
                rc = String.valueOf(tab[(int)(dez % 26L)]) + rc;
                dez = dezDecr;
                dezDecr = dez / 26L;
            }
            rc = "aaaaaa" + tab[(int)(dez % 26L)] + rc;
            rc = rc.substring(rc.length() - 7);
        }
        return rc;
    }

    public FGregorianCalendar() {
        super(TimeZone.getTimeZone("Europe/Berlin"));
    }

    public FGregorianCalendar(int year, int month, int date) {
        super(year, month, date);
    }

    public FGregorianCalendar(int year, int month, int date, int hour, int minute) {
        super(year, month, date, hour, minute);
    }

    public FGregorianCalendar(int year, int month, int date, int hour, int minute, int second) {
        super(year, month, date, hour, minute, second);
    }

    public FGregorianCalendar(Locale aLocale) {
        super(aLocale);
    }

    public FGregorianCalendar(TimeZone zone) {
        super(zone);
    }

    public FGregorianCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    public FGregorianCalendar(long DateLong) {
        this.setTimeZone(TimeZone.getTimeZone("Europe/Berlin"));
        this.setTime(DateLong);
    }

    public String[] berechnenSonnenaufUnduntergaengeAlleMontageEinesJahres(int Jahr, double Breite, double Laenge, char Art) {
        Date aktTime = this.getTime();
        String[] Montage = new String[60];
        int Anzahl = 0;
        this.set(1, Jahr);
        this.set(2, 0);
        this.set(5, 1);
        while (this.get(7) != 2) {
            this.add(5, 1);
        }
        do {
            int[] Stunde_Minuten = this.berechnenSonnenaufUnduntergang(Breite, Laenge);
            switch (Art) {
                case 'A': {
                    this.set(11, Stunde_Minuten[0]);
                    this.set(12, Stunde_Minuten[1]);
                    Montage[Anzahl++] = String.valueOf(this.toGermanFormat('K')) + " Sonnenaufgang " + this.toGermanFormat().substring(12, 16);
                    break;
                }
                case 'U': {
                    this.set(11, Stunde_Minuten[2]);
                    this.set(12, Stunde_Minuten[3]);
                    Montage[Anzahl++] = String.valueOf(this.toGermanFormat('K')) + " Sonnenuntergang " + this.toGermanFormat().substring(11, 16);
                    break;
                }
                case 'B': {
                    this.set(11, Stunde_Minuten[0]);
                    this.set(12, Stunde_Minuten[1]);
                    Montage[Anzahl] = String.valueOf(this.toGermanFormat('K')) + " Sonnenaufgang " + this.toGermanFormat().substring(12, 16);
                    this.set(11, Stunde_Minuten[2]);
                    this.set(12, Stunde_Minuten[3]);
                    int n = Anzahl++;
                    Montage[n] = String.valueOf(Montage[n]) + ", Sonnenuntergang " + this.toGermanFormat().substring(11, 16);
                    break;
                }
                default: {
                    this.set(11, Stunde_Minuten[0]);
                    this.set(12, Stunde_Minuten[1]);
                    Montage[Anzahl++] = String.valueOf(this.toGermanFormat('K')) + " Sonnenaufgang " + this.toGermanFormat().substring(12, 16);
                }
            }
            this.add(3, 1);
        } while (Jahr == this.get(1));
        String[] RC = new String[Anzahl];
        int i = 0;
        while (i < Anzahl) {
            RC[i] = Montage[i];
            ++i;
        }
        this.setTime(aktTime);
        return RC;
    }

    public int[] berechnenSonnenaufUnduntergang(double BreiteMitMinuten, double LaengeMitMinuten) {
        double Breite = Math.floor(BreiteMitMinuten) + (BreiteMitMinuten - Math.floor(BreiteMitMinuten)) / 60.0 * 100.0;
        double Laenge = Math.floor(LaengeMitMinuten) + (LaengeMitMinuten - Math.floor(LaengeMitMinuten)) / 60.0 * 100.0;
        int[] RC = new int[4];
        double Deklination = 0.40954 * Math.sin(0.0172 * ((double)this.get(6) - 79.34974));
        double Zeitdifferenz = 12.0 * Math.acos((Math.sin(-0.0145) - Math.sin(Math.toRadians(Breite)) * Math.sin(Deklination)) / (Math.cos(Math.toRadians(Breite)) * Math.cos(Deklination))) / Math.PI;
        double Zeitgleichung = -0.1752 * Math.sin(0.03343 * (double)this.get(6) + 0.5474) - 0.134 * Math.sin(0.018234 * (double)this.get(6) - 0.1939);
        double Sonnenaufgang = 12.0 - Zeitdifferenz - Zeitgleichung + (15.0 - Laenge) * 4.0 / 60.0;
        int A_Stunde = (int)Sonnenaufgang;
        int A_Minuten = (int)Math.round((Sonnenaufgang - (double)A_Stunde) * 60.0);
        double Sonnenuntergang = 12.0 + Zeitdifferenz - Zeitgleichung + (15.0 - Laenge) * 4.0 / 60.0;
        int U_Stunde = (int)Sonnenuntergang;
        int U_Minuten = (int)Math.round((Sonnenuntergang - (double)U_Stunde) * 60.0);
        RC[0] = A_Stunde;
        if (this.istInSommerzeit()) {
            RC[0] = RC[0] + 1;
        }
        RC[1] = A_Minuten;
        RC[2] = U_Stunde;
        if (this.istInSommerzeit()) {
            RC[2] = RC[2] + 1;
        }
        RC[3] = U_Minuten;
        return RC;
    }

    public String getJahreszeit() {
        int ix = 3;
        int mon = this.get(2) + 1;
        if (mon >= 3 && mon <= 5) {
            ix = 0;
        } else if (mon >= 6 && mon <= 8) {
            ix = 1;
        } else if (mon >= 9 && mon <= 11) {
            ix = 2;
        }
        return this.getJahreszeiten()[ix];
    }

    private String[] getJahreszeiten() {
        return this.Jahreszeiten;
    }

    public String getMonat() {
        return this.getMonate()[this.get(2)];
    }

    private String[] getMonate() {
        return this.Monate;
    }

    public String getWochentag() {
        return this.getWochentage()[this.get(7) - 1];
    }

    private String[] getWochentage() {
        return this.Wochentage;
    }

    public String getWochentagKurz() {
        return this.getWochentage()[this.get(7) - 1].substring(0, 2);
    }

    public String getZusatz() {
        String Zusatz = "Fehler! Zusatz nicht vorhanden!";
        if (this.Table.get(new String(this.toGermanFormat('K'))) != null) {
            Zusatz = this.Table.get(new String(this.toGermanFormat('K')));
        }
        return Zusatz;
    }

    public boolean hasZusatz() {
        boolean rc = this.Table.get(new String(this.toGermanFormat('K'))) != null;
        return rc;
    }

    private void ignoreSommerzeit() {
        if (this.get(1) > 1980 && this.istInSommerzeit()) {
            this.add(10, -1);
        }
    }

    public boolean istArbeitsfrei() {
        boolean rc = this.arbeitsfrei.get(new String(this.toGermanFormat('K'))) != null;
        return rc;
    }

    private boolean istInSommerzeit() {
        return this.Sommerzeit.inDaylightTime(this.getTime());
    }

    public void roundTimetoMinutes(int minutes) {
        if (minutes > 0) {
            long runde = this.getTimeInMillis() + (long)(30000 * minutes);
            runde -= runde % (long)(60000 * minutes);
            this.setTime(runde);
        }
    }

    public void setFeiertage(int Jahr) {
        String[] festeFeiertage = new String[]{"01.01. Neujahr", "06.01. Dreik\u00f6nig", "01.05. Maifeiertag", "15.08. Maria Himmelfahrt", "03.10. Tag der deutschen Einheit", "01.11. Allerheiligen", "24.12. Heiligabend", "25.12. Weihnachten", "26.12. Stephanstag", "31.12. Silvester"};
        String[] vonOsternAbhaengigeFeiertage = new String[]{"0;Ostern", "1;Ostermontag", "-2;Karfreitag", "-46;Aschermittwoch;N", "-47;Faschingsdienstag;N", "39;Christi Himmelfahrt", "49;Pfingsten", "50;Pfingstmontag", "60;Fronleichnam"};
        int i = 0;
        while (i < festeFeiertage.length) {
            String Datum = String.valueOf(festeFeiertage[i].substring(0, 5)) + "." + Jahr;
            this.Table.put(new String(Datum), festeFeiertage[i].substring(7));
            this.arbeitsfrei.put(new String(Datum), new String("J"));
            ++i;
        }
        int k = Jahr / 100;
        int p = (13 + 8 * k) / 25;
        int q = k / 4;
        int m = (15 - p + k - q) % 30;
        int n = (4 + k - q) % 7;
        int a = Jahr % 19;
        int b = Jahr % 4;
        int c = Jahr % 7;
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        int OsterTag = d + e - 9;
        int OsterMonat = 4;
        if (OsterTag < 1) {
            OsterTag = 22 + d + e;
            OsterMonat = 3;
        }
        Date aktTime = this.getTime();
        i = 0;
        while (i < vonOsternAbhaengigeFeiertage.length) {
            String[] Teile = vonOsternAbhaengigeFeiertage[i].split(";");
            this.set(Jahr, OsterMonat - 1, OsterTag);
            this.add(5, Integer.parseInt(Teile[0]));
            this.updateTable(Teile[1]);
            if (Teile.length <= 2 || Teile[2].length() <= 0 || Teile[2].compareToIgnoreCase("N") != 0) {
                this.arbeitsfrei.put(new String(this.toGermanFormat('K')), new String("J"));
            }
            ++i;
        }
        this.set(Jahr, 4, 1);
        int AnzahlMaiSonntage = 0;
        i = 0;
        while (i < 14) {
            if (this.get(7) == 1) {
                ++AnzahlMaiSonntage;
            }
            if (AnzahlMaiSonntage == 2) break;
            this.add(6, 1);
            ++i;
        }
        this.updateTable("Muttertag");
        this.set(Jahr, 2, 31);
        while (this.get(7) != 1) {
            this.add(6, -1);
        }
        this.updateTable("Beginn Sommerzeit");
        this.set(Jahr, 9, 31);
        while (this.get(7) != 1) {
            this.add(6, -1);
        }
        this.updateTable("Ende Sommerzeit");
        this.setTime(aktTime);
    }

    public void setTime(Date date, boolean ignoreSommerzeit) {
        this.setTime(date);
        if (ignoreSommerzeit) {
            this.ignoreSommerzeit();
        }
    }

    public void setTime(long DateLong) {
        Date ZeitDate = new Date();
        ZeitDate.setTime(DateLong);
        this.setTime(ZeitDate);
    }

    public void setTime(long DateLong, boolean ignoreSommerzeit) {
        Date ZeitDate = new Date();
        ZeitDate.setTime(DateLong);
        this.setTime(ZeitDate);
        if (ignoreSommerzeit) {
            this.ignoreSommerzeit();
        }
    }

    public void setTimeToNow() {
        this.setTime(new Date());
    }

    public void setZusatz() {
        this.setZusatz(null, this.get(1), this.get(1), true);
    }

    public void setZusatz(String DateiName) {
        this.setZusatz(DateiName, this.get(1), this.get(1), true);
    }

    public void setZusatz(String DateiName, boolean mitFeiertagen) {
        this.setZusatz(DateiName, this.get(1), this.get(1), mitFeiertagen);
    }

    public void setZusatz(String DateiName, int vonJahr, int bisJahr, boolean mitFeiertagen) {
        this.setZusatz(DateiName, vonJahr, bisJahr, mitFeiertagen, false, 0.0, 0.0);
    }

    public void setZusatz(String DateiName, int vonJahr, int bisJahr, boolean mitFeiertagen, boolean mitSonnenaufgang, double Breite, double Laenge) {
        this.setZusatz(DateiName, vonJahr, bisJahr, mitFeiertagen, mitSonnenaufgang, Breite, Laenge, 'A');
    }

    public void setZusatz(String DateiName, int vonJahr, int bisJahr, boolean mitFeiertagen, boolean mitSonnenaufgang, double Breite, double Laenge, char Art) {
        String[] Anniversary = new String[]{""};
        if (DateiName != null) {
            FFile Datei = new FFile(DateiName);
            Anniversary = Datei.inhaltToStringArray();
        }
        Date aktTime = this.getTime();
        int j = vonJahr;
        while (j <= bisJahr) {
            if (mitFeiertagen) {
                this.setFeiertage(j);
            }
            if (mitSonnenaufgang) {
                Anniversary = FString.verbindenStringArray(Anniversary, this.berechnenSonnenaufUnduntergaengeAlleMontageEinesJahres(j, Breite, Laenge, Art));
            }
            int i = 0;
            while (i < Anniversary.length) {
                if (Anniversary[i].length() > 11) {
                    try {
                        int Jahr = Integer.parseInt(Anniversary[i].substring(6, 10));
                        String Datum = String.valueOf(Anniversary[i].substring(0, 5)) + "." + j;
                        String Wert = Anniversary[i].substring(11);
                        if (Wert.indexOf("Urlaub") == 0 && Jahr == j || Wert.indexOf("Urlaub") != 0) {
                            if (Wert.compareToIgnoreCase("Hochzeitstag") == 0) {
                                Wert = String.valueOf(j - Jahr) + ".Hochzeitstag";
                            } else if (Wert.indexOf("Namenstag") != 0 && Wert.indexOf("Urlaub") != 0 && Wert.indexOf("Sonnenaufgang") != 0 && Wert.indexOf("Sonnenuntergang") != 0 && j - Jahr < 100) {
                                Wert = String.valueOf(Wert) + " (" + (j - Jahr) + " Jahre)";
                            }
                            if (this.Table.get(new String(Datum)) == null) {
                                this.Table.put(new String(Datum), Wert);
                            } else {
                                String alterWert = this.Table.get(new String(Datum));
                                this.Table.put(new String(Datum), String.valueOf(alterWert) + ", " + Wert);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Ungueltige Zeile: " + Anniversary[i] + " Fehler: " + e.getMessage());
                    }
                }
                ++i;
            }
            ++j;
        }
        this.setTime(aktTime);
    }

    public String toGermanFormat() {
        return this.toGermanFormat(' ');
    }

    public String toGermanFormat(char Format2) {
        String Ausgabe;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        NumberFormat kf = NumberFormat.getInstance();
        kf.setMinimumIntegerDigits(1);
        NumberFormat mf = NumberFormat.getInstance();
        mf.setMaximumIntegerDigits(2);
        NumberFormat msf = NumberFormat.getInstance();
        msf.setMinimumIntegerDigits(3);
        switch (Format2) {
            case 'A': 
            case 'a': {
                Ausgabe = String.valueOf(nf.format(this.get(5))) + "." + nf.format(this.get(2) + 1) + "." + this.get(1) + " " + nf.format(this.get(11)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13));
                break;
            }
            case 'B': 
            case 'b': {
                Ausgabe = String.valueOf(this.get(1)) + "-" + nf.format(this.get(2) + 1) + "-" + nf.format(this.get(5)) + (Format2 == 'b' ? "" : "T" + nf.format(this.get(11)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13)));
                break;
            }
            case 'Q': 
            case 'q': {
                Ausgabe = String.valueOf(this.get(1)) + "-" + nf.format(this.get(2) + 1) + "-" + nf.format(this.get(5)) + "T" + nf.format(this.get(11)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13)) + "." + msf.format(this.get(14));
                break;
            }
            case 'E': 
            case 'e': {
                Ausgabe = String.valueOf(this.get(1)) + ":" + nf.format(this.get(2) + 1) + ":" + nf.format(this.get(5)) + " " + nf.format(this.get(11)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13));
                break;
            }
            case 'C': 
            case 'c': {
                Ausgabe = String.valueOf(this.get(1)) + nf.format(this.get(2) + 1) + nf.format(this.get(5));
                break;
            }
            case '0': 
            case 'F': {
                Ausgabe = String.valueOf(kf.format(this.get(5))) + "." + kf.format(this.get(2) + 1) + "." + mf.format(this.get(1)) + " (" + this.getWochentagKurz() + ")" + " " + kf.format(this.get(11)) + "." + nf.format(this.get(12));
                break;
            }
            case '1': 
            case 'f': {
                Ausgabe = String.valueOf(kf.format(this.get(5))) + "." + kf.format(this.get(2) + 1) + "." + mf.format(this.get(1)) + " (" + this.getWochentagKurz() + ")";
                break;
            }
            case 'I': 
            case 'i': {
                Ausgabe = String.valueOf(kf.format(this.get(5))) + ". " + this.getMonat() + (Format2 == 'I' ? " (" + this.getWochentagKurz() + ")" : "");
                break;
            }
            case '2': {
                Ausgabe = String.valueOf(this.getMonat()) + " " + this.get(1);
                break;
            }
            case '3': {
                Ausgabe = String.valueOf(this.getJahreszeit()) + " " + this.get(1);
                break;
            }
            case '4': {
                Ausgabe = "" + this.get(1);
                break;
            }
            case '5': {
                Ausgabe = String.valueOf(("" + this.get(1)).substring(0, 3)) + "0er";
                break;
            }
            case '6': {
                Ausgabe = String.valueOf(this.get(5) < 11 ? "Anfang" : (this.get(5) < 21 ? "Mitte" : "Ende")) + " " + this.getMonat() + " " + this.get(1);
                break;
            }
            case 'G': 
            case 'g': {
                Ausgabe = String.valueOf(this.get(1)) + "-" + nf.format(this.get(2) + 1) + "-" + nf.format(this.get(5)) + "T" + nf.format(this.get(11)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13)) + "Z";
                break;
            }
            case 'K': 
            case 'k': {
                Ausgabe = String.valueOf(nf.format(this.get(5))) + "." + nf.format(this.get(2) + 1) + "." + this.get(1);
                break;
            }
            case 'L': 
            case 'l': {
                Ausgabe = String.valueOf(this.get(1)) + "." + nf.format(this.get(2) + 1) + "." + nf.format(this.get(5)) + "-" + nf.format(this.get(11)) + "." + nf.format(this.get(12)) + "." + nf.format(this.get(13));
                break;
            }
            case 'N': 
            case 'n': {
                Ausgabe = String.valueOf(this.get(1)) + nf.format(this.get(2) + 1) + nf.format(this.get(5)) + nf.format(this.get(11)) + nf.format(this.get(12)) + nf.format(this.get(13));
                break;
            }
            case 'R': 
            case 'r': {
                Ausgabe = String.valueOf(mf.format(this.get(1))) + nf.format(this.get(2) + 1) + nf.format(this.get(5)) + "_" + nf.format(this.get(11)) + nf.format(this.get(12));
                break;
            }
            case 'O': 
            case 'o': {
                Ausgabe = String.valueOf(kf.format(this.get(5))) + "." + kf.format(this.get(2) + 1) + "." + mf.format(this.get(1)) + " " + kf.format(this.get(11)) + "." + nf.format(this.get(12));
                break;
            }
            case 'S': 
            case 's': {
                Ausgabe = String.valueOf(this.get(1)) + "." + nf.format(this.get(2) + 1) + "." + nf.format(this.get(5));
                break;
            }
            case 'T': 
            case 't': {
                Ausgabe = FGregorianCalendar.getZeit2StringSortierbar(this.get(1), this.get(2) + 1, this.get(5), this.get(11), this.get(12), this.get(13));
                break;
            }
            case 'W': 
            case 'w': {
                Ausgabe = String.valueOf(this.get(1)) + "." + nf.format(this.get(2) + 1) + "." + nf.format(this.get(5)) + " (" + this.getWochentagKurz() + ")" + (Format2 == 'w' ? "" : " " + nf.format(this.get(11)) + "." + nf.format(this.get(12)));
                break;
            }
            case 'Y': 
            case 'y': {
                Ausgabe = String.valueOf(nf.format(this.get(11))) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13));
                break;
            }
            case 'M': 
            case 'm': {
                Ausgabe = String.valueOf(nf.format(this.get(11) - 1)) + ":" + nf.format(this.get(12)) + ":" + nf.format(this.get(13)) + "." + msf.format(this.get(14));
                break;
            }
            case 'Z': 
            case 'z': {
                Ausgabe = String.valueOf(nf.format(this.get(11))) + "." + nf.format(this.get(12)) + (Format2 == 'z' ? "" : "." + nf.format(this.get(13)));
                break;
            }
            default: {
                Ausgabe = String.valueOf(nf.format(this.get(5))) + "." + nf.format(this.get(2) + 1) + "." + this.get(1) + "," + nf.format(this.get(11)) + "." + nf.format(this.get(12)) + "." + nf.format(this.get(13));
            }
        }
        return Ausgabe;
    }

    public void toGermanList() {
        FProt fProt = FProt.instance();
        String a = "abcdefghijklmnopqrstuvwxyz0123456789";
        String A = "abcdefghijklmnopqrstuvwxyz0123456789".toUpperCase();
        String ohne = this.toGermanFormat();
        char x = ' ';
        char X = ' ';
        int i = 0;
        while (i < "abcdefghijklmnopqrstuvwxyz0123456789".length()) {
            String klein;
            x = "abcdefghijklmnopqrstuvwxyz0123456789".charAt(i);
            X = A.charAt(i);
            String gross = this.toGermanFormat(X);
            if (gross.compareTo(klein = this.toGermanFormat(x)) != 0 || gross.compareTo(ohne) != 0) {
                if (gross.compareTo(klein) != 0) {
                    fProt.prot(String.valueOf(X) + "       : " + gross + "\t" + x + ": " + klein);
                } else {
                    fProt.prot(String.valueOf(X) + " oder " + x + ": " + gross);
                }
            }
            ++i;
        }
        fProt.prot("        : " + ohne);
    }

    public void updateTable(String Wert) {
        if (this.Table.get(new String(this.toGermanFormat('K'))) == null) {
            this.Table.put(new String(this.toGermanFormat('K')), Wert);
        } else {
            String alterWert = this.Table.get(new String(this.toGermanFormat('K')));
            this.Table.put(new String(this.toGermanFormat('K')), String.valueOf(alterWert) + ", " + Wert);
        }
    }
}

