/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FString;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class FJComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = 1L;
    private final int HistorieMaxEntry = 25;
    private boolean mitHistorie = false;
    private boolean reihenfolgeNichtPflegen = false;
    private String HistorieDateiName;

    public FJComboBox() {
        this.setMaximumRowCount(this.getHistorieMaxEntry());
    }

    public void addStringItem(boolean ignoreCase) {
        String item = (String)this.getSelectedItem();
        if (item != null && item.length() > 0) {
            this.addStringItem(item.trim(), ignoreCase);
        }
    }

    public void addStringItem(String item, boolean ignoreCase) {
        this.addStringItem(item, ignoreCase, true);
    }

    public void addStringItem(String[] itemArray, boolean ignoreCase, boolean atTop) {
        this.addStringItem(itemArray, ignoreCase, atTop, false);
    }

    public void addStringItem(String item, boolean ignoreCase, boolean atTop) {
        this.addStringItem(item, ignoreCase, atTop, false);
    }

    public void addStringItem(String item, boolean ignoreCase, boolean atTop, boolean forceInsert) {
        this.addStringItem(item, ignoreCase, atTop, forceInsert, false);
    }

    public void addStringItem(String[] itemArray, boolean ignoreCase, boolean atTop, boolean forceInsert) {
        String[] stringArray = itemArray;
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.addStringItem(item, ignoreCase, atTop, forceInsert);
            ++n2;
        }
    }

    public void addStringItem(String item, boolean ignoreCase, boolean atTop, boolean forceInsert, boolean mitLeerzeile) {
        if (item != null && (!this.isReihenfolgeNichtPflegen() || forceInsert)) {
            String eintrag = item.trim();
            int pos = -1;
            if (mitLeerzeile || eintrag.length() > 0) {
                int Anzahl = this.getItemCount();
                if (Anzahl == 0) {
                    this.addItem(eintrag);
                } else {
                    int i = 0;
                    while (i < Anzahl) {
                        if (!ignoreCase) {
                            if (((String)this.getItemAt(i)).compareTo(eintrag) == 0) {
                                pos = i;
                                break;
                            }
                        } else if (((String)this.getItemAt(i)).compareToIgnoreCase(eintrag) == 0) {
                            pos = i;
                            break;
                        }
                        ++i;
                    }
                    if (atTop) {
                        if (pos > 0) {
                            this.removeItem(this.getItemAt(pos));
                        }
                        if (pos != 0) {
                            this.insertItemAt(eintrag, 0);
                        }
                        this.setSelectedIndex(0);
                    } else if (pos < 0) {
                        this.addItem(eintrag);
                    }
                }
            }
        }
    }

    public String getCurrentItem() {
        String Item = null;
        if (this.getSelectedItem() != null) {
            Item = (String)this.getSelectedItem();
        } else if (this.getItemCount() > 0) {
            Item = (String)this.getItemAt(0);
        }
        return Item;
    }

    protected int getHistorieMaxEntry() {
        return 25;
    }

    public String getHistoryFileName() {
        return this.HistorieDateiName;
    }

    public boolean isMitHistorie() {
        return this.mitHistorie;
    }

    public boolean isReihenfolgeNichtPflegen() {
        return this.reihenfolgeNichtPflegen;
    }

    public boolean readHistory() {
        return this.readHistory(false);
    }

    public boolean readHistory(boolean mitLeerzeilen) {
        boolean rc = true;
        if (this.isMitHistorie()) {
            String[] Liste2;
            FFile Datei = new FFile(this.getHistoryFileName());
            String[] stringArray = Liste2 = Datei.inhaltToStringArray();
            int n = Liste2.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (mitLeerzeilen || element.length() > 0) {
                    this.addStringItem(element.trim(), true);
                }
                ++n2;
            }
        } else {
            rc = false;
        }
        return rc;
    }

    public void resetHistory() {
        Object aktuell = this.getSelectedItem();
        this.removeAllItems();
        if (aktuell != null) {
            this.addItem(aktuell);
        }
    }

    public void setHistory(String histName) {
        if (histName != null && histName.length() > 0) {
            this.setMitHistorie(true);
            this.HistorieDateiName = String.valueOf(histName) + ".txt";
        } else {
            this.setMitHistorie(false);
        }
    }

    public void setMitHistorie(boolean mitHistorieIn) {
        this.mitHistorie = mitHistorieIn;
    }

    public void setReihenfolgeNichtPflegen(boolean reihenfolgeNichtPflegenIn) {
        this.reihenfolgeNichtPflegen = reihenfolgeNichtPflegenIn;
    }

    public boolean writeHistory() {
        return this.writeHistory(false);
    }

    public boolean writeHistory(boolean mitLeerzeilen) {
        boolean rc = true;
        if (this.isMitHistorie()) {
            File del;
            int Anzahl = Math.min(this.getItemCount(), this.getHistorieMaxEntry());
            String[] Zeilen = new String[]{};
            String selectedItem = this.getSelectedIndex() >= 0 ? ((String)this.getSelectedItem()).trim() : null;
            ArrayList<String> Ausgabe = new ArrayList<String>();
            boolean writeHistorie = false;
            if (Anzahl > 0) {
                int i = Anzahl - 1;
                while (i >= 0) {
                    String item = ((String)this.getItemAt(i)).trim();
                    if (mitLeerzeilen || item.length() > 0) {
                        if (selectedItem != null) {
                            if (item.compareTo(selectedItem) != 0) {
                                Ausgabe.add(item);
                            }
                        } else {
                            Ausgabe.add(item);
                        }
                    }
                    --i;
                }
                if (selectedItem != null) {
                    Ausgabe.add(selectedItem);
                }
                if (Ausgabe.size() > 0) {
                    Zeilen = FString.arrayListToStringArray(Ausgabe);
                    if (!mitLeerzeilen) {
                        Zeilen = FString.deleteDoppelte(Zeilen);
                    }
                    new FFile(this.getHistoryFileName()).StringArrayToInhalt(Zeilen, true, "", 0, true);
                    writeHistorie = true;
                }
            }
            if (!writeHistorie && (del = new File(this.getHistoryFileName())).exists()) {
                del.delete();
            }
        } else {
            File del;
            if (this.getHistoryFileName() != null && (del = new File(this.getHistoryFileName())).exists()) {
                del.delete();
            }
            rc = false;
        }
        return rc;
    }
}

