/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FJTable {
    public static void setPreferredSizes(JTable table) {
        int j;
        TableModel model = table.getModel();
        TableColumn column = null;
        Component comp = null;
        int[][] cellSize = new int[table.getColumnCount()][table.getRowCount() + 1];
        int[] averageColumnSize = new int[table.getColumnCount()];
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < table.getColumnCount()) {
            cellWidth = 0;
            j = 0;
            while (j < table.getRowCount()) {
                comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, table.getValueAt(j, i), false, false, 0, i);
                cellSize[i][j] = comp.getPreferredSize().width;
                cellWidth = Math.max(cellWidth, comp.getPreferredSize().width);
                ++j;
            }
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, -1, i);
            cellSize[i][table.getRowCount()] = comp.getPreferredSize().width;
            ++i;
        }
        i = 0;
        while (i < table.getColumnCount()) {
            averageColumnSize[i] = 0;
            j = 0;
            while (j <= table.getRowCount()) {
                int n = i;
                averageColumnSize[n] = averageColumnSize[n] + cellSize[i][j];
                ++j;
            }
            int n = i;
            averageColumnSize[n] = averageColumnSize[n] / (table.getRowCount() + 1);
            table.getColumnModel().getColumn(i).setPreferredWidth(averageColumnSize[i] * 7 / 4);
            ++i;
        }
    }

    public void setColumnRenderer(JTable table, Font font) {
        LineWrapCellRenderer lineWrapCellRenderer = new LineWrapCellRenderer();
        LineWrapHeaderRenderer lineWrapHeaderRenderer = new LineWrapHeaderRenderer();
        lineWrapCellRenderer.setFont(font);
        lineWrapHeaderRenderer.setFont(font);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(lineWrapCellRenderer);
            ++i;
        }
    }

    public class LineWrapCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public LineWrapCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setMargin(new Insets(0, 5, 5, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) < this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            } else if (table.getRowHeight(row) > this.getPreferredSize().height) {
                int maxHeight = table.getRowHeight(row) - 1;
                table.setRowHeight(row, maxHeight);
            }
            return this;
        }
    }

    public class LineWrapHeaderRenderer
    extends JTextArea
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public LineWrapHeaderRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setMargin(new Insets(0, 5, 5, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            if (table != null && table.getRowHeight(row) > 0) {
                this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
                if (table.getRowHeight(row) < this.getPreferredSize().height) {
                    table.setRowHeight(row, this.getPreferredSize().height);
                } else if (table.getRowHeight(row) > this.getPreferredSize().height) {
                    int maxHeight = table.getRowHeight(row) - 1;
                    table.setRowHeight(row, maxHeight);
                }
            }
            return this;
        }
    }
}

