/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import de.nss.jfi.Uti.ArgTabZeile;
import de.nss.jfi.Uti.FDatei;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FProt;
import de.nss.jfi.Uti.FString;
import de.nss.jfi.Uti.Futi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FParam {
    private static FParam instance;
    public String[][] ArgTabTO;
    private boolean ZeigeParameter;
    private boolean ZeigeZeit;
    private boolean ZeigeHilfe;

    public static boolean checkArgTab(String argTabName) {
        boolean rc = true;
        String[][] argTab = FString.verbindenTabellen(FParam.readParameter(argTabName), FParam.readParameter("Standard.par"), 7);
        int s = 0;
        while (s <= 1) {
            int i = 0;
            while (i < argTab.length) {
                if (argTab[i][s].length() > 0 && argTab[i][s].compareToIgnoreCase("Remark") != 0) {
                    int j = 0;
                    while (j < argTab.length) {
                        if (i != j && argTab[j][s].length() > 0 && argTab[i][s].startsWith(argTab[j][s])) {
                            FProt.instance().prot("!!! " + argTabName + ", " + (s == 0 ? "Kuerzel" : "Parameter") + ": " + argTab[j][s] + " und " + argTab[i][s] + " nicht eindeutig !!!");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++s;
        }
        return true;
    }

    public static String checkDateParameter(String Parameter, String Wert, boolean heuteUmsetzen, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "Date";
        String Ergebnis = "";
        SimpleDateFormat formatTag_aus = new SimpleDateFormat("dd.MM.yyyy");
        Date Tag2 = new Date();
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "Date", Tab);
        if (pos >= 0) {
            Ergebnis = FParam.checkUndGetWertParameter(pos, Wert, Tab);
            if (heuteUmsetzen && Ergebnis.compareTo("heute") == 0) {
                Ergebnis = formatTag_aus.format(Tag2);
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "Date" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static String checkDateParameter(String Parameter, String Wert, String[][] Tab) {
        return FParam.checkDateParameter(Parameter, Wert, false, Tab);
    }

    public static double checkDoubleParameter(String Parameter, double Wert, String[][] Tab) {
        return FParam.checkDoubleParameter(Parameter, new Double(Wert).toString(), Tab);
    }

    public static double checkDoubleParameter(String Parameter, String Wert, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "double";
        double Ergebnis = 0.0;
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "double", Tab);
        if (pos >= 0) {
            String ErgebnisCheckundGet = FParam.checkUndGetWertParameter(pos, Wert, Tab);
            if (ErgebnisCheckundGet.length() > 0) {
                Ergebnis = Double.parseDouble(ErgebnisCheckundGet);
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "double" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static int checkIntParameter(String Parameter, int Wert, String[][] Tab) {
        return FParam.checkIntParameter(Parameter, new Integer(Wert).toString(), Tab);
    }

    public static int checkIntParameter(String Parameter, String Wert, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "int";
        int Ergebnis = 0;
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "int", Tab);
        if (pos >= 0) {
            String ErgebnisCheckundGet = FParam.checkUndGetWertParameter(pos, Wert, Tab);
            if (ErgebnisCheckundGet.length() > 0) {
                Ergebnis = Integer.parseInt(ErgebnisCheckundGet);
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "int" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static long checkLongParameter(String Parameter, long Wert, String[][] Tab) {
        return FParam.checkLongParameter(Parameter, new Long(Wert).toString(), Tab);
    }

    public static long checkLongParameter(String Parameter, String Wert, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "long";
        long Ergebnis = 0L;
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "long", Tab);
        if (pos >= 0) {
            String ErgebnisCheckundGet = FParam.checkUndGetWertParameter(pos, Wert, Tab);
            if (ErgebnisCheckundGet.length() > 0) {
                Ergebnis = Long.parseLong(ErgebnisCheckundGet);
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "long" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static String checkStringParameter(String Parameter, String Wert, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "String";
        String Ergebnis = "";
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "String", Tab);
        if (pos >= 0) {
            Ergebnis = FParam.checkUndGetWertParameter(pos, Wert, Tab);
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "String" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static String checkTimeParameter(String Parameter, String Wert, boolean jetztUmsetzen, String[][] Tab) {
        FProt fProt = FProt.instance();
        String typ = "Time";
        String Ergebnis = "";
        SimpleDateFormat formatZeit_aus = new SimpleDateFormat("HH:mm:ss");
        Date Uhrzeit = new Date();
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "Time", Tab);
        if (pos >= 0) {
            Ergebnis = FParam.checkUndGetWertParameter(pos, Wert, Tab);
            if (jetztUmsetzen && Ergebnis.compareTo("jetzt") == 0) {
                Ergebnis = formatZeit_aus.format(Uhrzeit);
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "Time" + "< nicht gefunden");
        }
        return Ergebnis;
    }

    public static String checkTimeParameter(String Parameter, String Wert, String[][] Tab) {
        return FParam.checkTimeParameter(Parameter, Wert, false, Tab);
    }

    public static String checkUndGetWertParameter(int pos, String wert, String[][] Tab) {
        FProt fProt = FProt.instance();
        fProt.prot("##### Start checkUndGetWertParameter: " + Tab[pos][3], 29);
        int temp_int = 0;
        long temp_long = 0L;
        double temp_double = 0.0;
        String[] Werte = new String[]{};
        String Ergebnis = "";
        SimpleDateFormat formatTag = new SimpleDateFormat("d.M.y");
        SimpleDateFormat formatTag_aus = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat formatZeit = new SimpleDateFormat("H:m:s");
        SimpleDateFormat formatZeit_aus = new SimpleDateFormat("HH:mm:ss");
        Date DatumUhrzeit = new Date();
        String Wert = wert;
        if (Wert == null) {
            Wert = Tab[pos][4];
        }
        Ergebnis = Tab[pos][4];
        String FeldNameKurz = Tab[pos][0];
        String FeldNameLang = Tab[pos][1];
        boolean Werte_vorhanden = false;
        if (Tab[pos].length > 5 && Tab[pos][5] != null && Tab[pos][5].length() > 0) {
            Werte = Tab[pos][5].split(",");
            Werte_vorhanden = true;
        }
        if (Tab[pos][2].compareTo("String") == 0) {
            if (Werte_vorhanden) {
                Ergebnis = FParam.pruefenUndGetWertauspraegungenEinzelParameterCheck(Tab[pos][1], Wert, Werte, false);
                if (Werte[0].startsWith("LI")) {
                    Ergebnis = Ergebnis.toUpperCase();
                }
            } else {
                Ergebnis = Wert;
            }
        } else if (Tab[pos][2].compareTo("boolean") == 0) {
            Ergebnis = "ja";
            if (Wert.length() > Tab[pos][0].length()) {
                fProt.prot("Endung >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< unnoetig und ignoriert");
            }
            if (Werte_vorhanden) {
                fProt.prot("Wertepruefung bei Typ boolean nicht vorgesehen, >" + Tab[pos][5] + "< unnoetig und ignoriert");
            }
        } else if (Tab[pos][2].compareTo("Date") == 0) {
            if (Wert.length() > 0) {
                boolean Format_gueltig = true;
                try {
                    DatumUhrzeit = formatTag.parse(Wert);
                }
                catch (Exception e) {
                    Format_gueltig = false;
                }
                if (Format_gueltig || Wert.compareTo("heute") == 0) {
                    Ergebnis = formatTag_aus.format(DatumUhrzeit);
                } else {
                    fProt.prot("Wert >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< nicht Typ Date, ungueltig und ignoriert");
                }
                if (Werte_vorhanden && Werte[0].compareToIgnoreCase("[BL]") != 0) {
                    fProt.prot("Wertepruefung bei Typ Date nicht vorgesehen, >" + Tab[pos][5] + "< unnoetig und ignoriert");
                }
            } else {
                Ergebnis = "";
            }
        } else if (Tab[pos][2].compareTo("Time") == 0) {
            if (Wert.length() > 0) {
                boolean Format_gueltig = true;
                try {
                    if (Wert.length() > 0) {
                        DatumUhrzeit = formatZeit.parse(String.valueOf(Wert) + ":0:0");
                    }
                }
                catch (Exception e) {
                    Format_gueltig = false;
                }
                if (Format_gueltig || Wert.compareTo("jetzt") == 0) {
                    Ergebnis = formatZeit_aus.format(DatumUhrzeit);
                } else {
                    fProt.prot("Wert >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< nicht Typ Time, ungueltig und ignoriert, Format ist [h]h[:[m][m[:[s][s]]");
                }
                if (Werte_vorhanden && Werte[0].compareToIgnoreCase("[BL]") != 0) {
                    fProt.prot("Wertepruefung bei Typ Time nicht vorgesehen, >" + Tab[pos][5] + "< unnoetig und ignoriert");
                }
            } else {
                Ergebnis = "";
            }
        } else if (Tab[pos][2].compareTo("int") == 0) {
            boolean Format_gueltig = true;
            try {
                temp_int = Integer.parseInt(Wert);
            }
            catch (Exception e) {
                Format_gueltig = false;
            }
            if (Format_gueltig) {
                Ergebnis = Werte_vorhanden ? FParam.pruefenUndGetWertauspraegungenEinzelParameterCheck(Tab[pos][1], Wert, Werte, true) : Integer.toString(temp_int);
            } else {
                fProt.prot("Wert >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< nicht Typ int, ungueltig und ignoriert");
            }
        } else if (Tab[pos][2].compareTo("long") == 0) {
            boolean Format_gueltig = true;
            try {
                temp_long = Long.parseLong(Wert);
            }
            catch (Exception e) {
                Format_gueltig = false;
            }
            if (Format_gueltig) {
                if (Format_gueltig) {
                    Ergebnis = Werte_vorhanden ? FParam.pruefenUndGetWertauspraegungenEinzelParameterCheck(Tab[pos][1], Wert, Werte, true) : Long.toString(temp_long);
                }
            } else {
                fProt.prot("Wert >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< nicht Typ long, ungueltig und ignoriert");
            }
        } else if (Tab[pos][2].compareTo("double") == 0) {
            boolean Format_gueltig = true;
            try {
                temp_double = Double.parseDouble(Wert);
            }
            catch (Exception e) {
                Format_gueltig = false;
            }
            if (Format_gueltig) {
                Ergebnis = Werte_vorhanden ? FParam.pruefenUndGetWertauspraegungenEinzelParameterCheck(Tab[pos][1], Wert, Werte, true) : Double.toString(temp_double);
            } else {
                fProt.prot("Wert >" + Wert + "< von Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "< nicht Typ long, ungueltig und ignoriert");
            }
        } else {
            fProt.prot("Nicht unterstuetzter Typ >" + Tab[pos][2] + "< bei Parameter >" + FeldNameKurz + " bzw. " + FeldNameLang + "<");
        }
        fProt.prot("##### Ende  checkUndGetWertParameter: " + Tab[pos][3], 30);
        return Ergebnis;
    }

    public static void checkUndSetWertEinzelParameter(int pos, String Wert, String[][] Tab) {
        Tab[pos][4] = FParam.checkUndGetWertParameter(pos, Wert, Tab);
    }

    public static String[][] copyArgTab(String[][] ArgTabEin) {
        return FParam.copyArgTab(ArgTabEin, ArgTabEin[0].length);
    }

    public static String[][] copyArgTab(String[][] ArgTabEin, int AnzahlSpalten) {
        int j;
        FProt fProt = FProt.instance();
        fProt.prot("##### Start copyArgTab: ", 29);
        String[][] ArgTab = new String[ArgTabEin.length][AnzahlSpalten];
        int i = 0;
        while (i < ArgTabEin.length) {
            j = 0;
            while (j < ArgTabEin[i].length) {
                ArgTab[i][j] = ArgTabEin[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ArgTab.length) {
            j = 0;
            while (j < ArgTab[i].length) {
                if (ArgTab[i][j] == null) {
                    ArgTab[i][j] = "";
                }
                ++j;
            }
            if (ArgTab[i][0].length() == 0) {
                ArgTab[i][0] = " ";
            }
            if (ArgTab[i][1].length() == 0) {
                ArgTab[i][1] = " ";
            }
            if (ArgTab[i][4].length() == 0) {
                if (ArgTab[i][2].compareTo("boolean") == 0) {
                    ArgTab[i][4] = "nein";
                }
                if (ArgTab[i][2].compareTo("int") == 0 || ArgTab[i][2].compareTo("long") == 0) {
                    ArgTab[i][4] = "0";
                }
                if (ArgTab[i][2].compareTo("double") == 0) {
                    ArgTab[i][4] = "0.0";
                }
            }
            ++i;
        }
        fProt.prot(FString.convertTabelleToStringArray(ArgTabEin), 30);
        fProt.prot("##### Ende  copyArgTab: ", 30);
        return ArgTab;
    }

    public static String createArgTabelleCheckWertebereich(String werteBereich, ArrayList<ArgTabZeile> ArgTabZeilen) {
        String WerteBereich = werteBereich;
        String[] Teile = WerteBereich.split(",");
        if (Teile.length > 1) {
            int i = 1;
            while (i < Teile.length) {
                boolean found = false;
                int j = 0;
                while (j < ArgTabZeilen.size()) {
                    if (ArgTabZeilen.get(j).isName(Teile[i])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    WerteBereich = WerteBereich.replaceAll("," + Teile[i], "");
                }
                ++i;
            }
        }
        return WerteBereich;
    }

    public static boolean createArgTabelleFindRegDBReferenz(String name, ArrayList<ArgTabZeile> ArgTabZeilen) {
        boolean found = false;
        int i = 0;
        while (i < ArgTabZeilen.size()) {
            if (ArgTabZeilen.get(i).isInRegDBReferenz(name)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public static boolean getBooleanParameter(String Parameter, String[][] Tab) {
        FProt fProt = FProt.instance();
        boolean Wert = false;
        String typ = "boolean";
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, "boolean", Tab);
        if (pos >= 0) {
            if (Tab[pos][4].compareTo("ja") == 0) {
                Wert = true;
            }
        } else {
            fProt.prot("Parameter >" + Parameter + "< und Typ >" + "boolean" + "< nicht gefunden");
        }
        return Wert;
    }

    public static String getDateParameter(String Parameter, String[][] Tab) {
        return FParam.checkDateParameter(Parameter, null, false, Tab);
    }

    public static String getDefault(String Parameter, String Typ, String[][] Tab) {
        FProt fProt = FProt.instance();
        String Wert = "";
        int pos = FParam.getIndexOfParameterZeileViaNameUndTyp(Parameter, Typ, Tab);
        if (pos >= 0) {
            Wert = Tab[pos][4];
        } else {
            fProt.prot("Wert fuer Parameter >" + Parameter + "< und Typ >" + Typ + "< nicht gefunden");
        }
        return Wert;
    }

    public static double getDoubleParameter(String Parameter, String[][] Tab) {
        return FParam.checkDoubleParameter(Parameter, null, Tab);
    }

    public static int getIndexOfParameterZeileViaKuerzelInklWert(String KuerzelInklWert, String[][] Tab) {
        FProt fProt = FProt.instance();
        int pos = -1;
        int i = 0;
        while (i < Tab.length) {
            if (Tab[i][0].length() > 0 && KuerzelInklWert.length() >= Tab[i][0].length() && KuerzelInklWert.substring(0, Tab[i][0].length()).compareToIgnoreCase(Tab[i][0]) == 0) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos < 0) {
            fProt.prot("Parameter >" + KuerzelInklWert + "< unbekannt");
        }
        return pos;
    }

    public static int getIndexOfParameterZeileViaNameUndTyp(String Name, String Typ, String[][] Tab) {
        FProt fProt = FProt.instance();
        int pos = -1;
        int i = 0;
        while (i < Tab.length) {
            if (Name.length() >= Tab[i][1].length() && Name.substring(0, Tab[i][1].length()).compareToIgnoreCase(Tab[i][1]) == 0 && Typ.length() >= Tab[i][2].length() && Typ.substring(0, Tab[i][2].length()).compareToIgnoreCase(Tab[i][2]) == 0) {
                pos = i;
                break;
            }
            ++i;
        }
        if (i >= Tab.length) {
            fProt.prot("Parameter >" + Name + " mit " + Typ + "< unbekannt");
        }
        return pos;
    }

    public static int getIntParameter(String Parameter, String[][] Tab) {
        return FParam.checkIntParameter(Parameter, null, Tab);
    }

    public static long getLongParameter(String Parameter, String[][] Tab) {
        return FParam.checkLongParameter(Parameter, null, Tab);
    }

    public static String[] getParameterBeschreibung(String[][] Tab, boolean anzeigeFuerGUI, String prefix) {
        String Filler;
        String Prefix;
        int pos;
        FProt fProt = FProt.instance();
        fProt.prot("##### Start getParameterBeschreibung: ", 29);
        fProt.prot(FString.convertTabelleToStringArray(Tab), 30);
        ArrayList<String> Ausgabe = new ArrayList<String>();
        int max = 0;
        String Zeile = "";
        if (anzeigeFuerGUI) {
            pos = 1;
            Prefix = "";
            Filler = " ... ";
        } else {
            pos = 0;
            Prefix = prefix;
            Filler = "                                                                                  ";
        }
        int i = 0;
        while (i < Tab.length) {
            if (Prefix.length() + Tab[i][pos].length() + Tab[i][2].length() > max) {
                max = Prefix.length() + Tab[i][pos].length() + Tab[i][2].length();
            }
            ++i;
        }
        max += 2;
        Ausgabe.add("Folgende Parameter sind moeglich:");
        i = 0;
        while (i < Tab.length) {
            String Feld;
            if (Tab[i][2].compareTo("boolean") == 0) {
                Feld = String.valueOf(Prefix) + Tab[i][pos] + Filler;
                if (!anzeigeFuerGUI) {
                    Ausgabe.add(String.valueOf(Feld.substring(0, max)) + ": " + Tab[i][3] + ", Schalter, default: " + Tab[i][4]);
                } else {
                    Ausgabe.add(String.valueOf(Feld) + Tab[i][3]);
                }
            } else if (Tab[i][2].compareTo("Date") == 0) {
                if (!anzeigeFuerGUI) {
                    Feld = String.valueOf(Prefix) + Tab[i][pos] + "[" + Tab[i][2] + "]" + Filler;
                    Ausgabe.add(String.valueOf(Feld.substring(0, max)) + ": " + Tab[i][3] + ", Format: [t]t.[m]m.[jj]jj, default: " + Tab[i][4]);
                } else {
                    Ausgabe.add(String.valueOf(Tab[i][pos]) + Filler + Tab[i][3] + ", Format: [t]t.[m]m.[jj]jj");
                }
            } else if (Tab[i][2].compareTo("Time") == 0) {
                if (!anzeigeFuerGUI) {
                    Feld = String.valueOf(Prefix) + Tab[i][pos] + "[" + Tab[i][2] + "]" + Filler;
                    Ausgabe.add(String.valueOf(Feld.substring(0, max)) + ": " + Tab[i][3] + ", Format: [h]h[.[m]m][.[s]s], default: " + Tab[i][4]);
                } else {
                    Ausgabe.add(String.valueOf(Tab[i][pos]) + Filler + Tab[i][3] + ", Format: [h]h[.[m]m][.[s]s]");
                }
            } else if (Tab[i][2].compareTo("Remark") == 0) {
                Feld = " _> " + Filler;
                if (!anzeigeFuerGUI) {
                    Ausgabe.add(String.valueOf(Feld.substring(0, max)) + ": " + Tab[i][3]);
                } else {
                    Ausgabe.add(String.valueOf(Feld) + Tab[i][3]);
                }
            } else {
                Zeile = "";
                if (Tab[i].length > 5 && Tab[i][5] != null) {
                    String[] Werte = Tab[i][5].split(",");
                    if (Werte[0].compareToIgnoreCase("L") == 0 || Werte[0].compareToIgnoreCase("LI") == 0 || Werte[0].compareToIgnoreCase("LD") == 0 || Werte[0].compareToIgnoreCase("LID") == 0) {
                        if (Werte.length < 2) {
                            System.err.println("keine Wertauspraegungen fuer Typ >" + Werte[0] + "< vorhanden");
                        } else {
                            Zeile = Werte[0].compareToIgnoreCase("L") == 0 ? ", gueltige Werte sind (case sensitiv): " + Werte[1] : ", gueltige Werte sind: " + Werte[1];
                            int w = 2;
                            while (w < Werte.length) {
                                Zeile = String.valueOf(Zeile) + "," + Werte[w];
                                ++w;
                            }
                        }
                    }
                    if (Werte[0].compareToIgnoreCase("G") == 0) {
                        if (Werte.length < 3) {
                            System.err.println("keine 2 Wertauspraegungen fuer Typ >" + Werte[0] + "< vorhanden");
                        } else {
                            Zeile = ", gueltige Werte: >=" + Werte[1] + " und <=" + Werte[2];
                        }
                    }
                }
                if (!anzeigeFuerGUI) {
                    Feld = String.valueOf(Prefix) + Tab[i][pos] + "[" + Tab[i][2] + "]" + Filler;
                    Ausgabe.add(String.valueOf(Feld.substring(0, max)) + ": " + Tab[i][3] + Zeile + ", default: " + Tab[i][4]);
                } else {
                    Ausgabe.add(String.valueOf(Tab[i][pos]) + Filler + Tab[i][3] + Zeile + ", default: " + Tab[i][4]);
                }
            }
            ++i;
        }
        Ausgabe.add("");
        fProt.prot("##### Ende  getParameterBeschreibung: ", 30);
        return FString.arrayListToStringArray(Ausgabe);
    }

    public static String[] getParameterBeschreibung(String[][] Tab, String prefix) {
        return FParam.getParameterBeschreibung(Tab, false, prefix);
    }

    public static String getStringParameter(String Parameter, String[][] Tab) {
        return FParam.checkStringParameter(Parameter, null, Tab);
    }

    public static String getTimeParameter(String Parameter, String[][] Tab) {
        return FParam.checkTimeParameter(Parameter, null, false, Tab);
    }

    public static synchronized FParam instance() {
        if (instance == null) {
            instance = new FParam();
        }
        return instance;
    }

    public static String pruefenUndGetWertauspraegungenEinzelParameterCheck(String Feld, String Wert, String[] Werte, boolean vergleiche_numerisch) {
        FProt fProt = FProt.instance();
        boolean gueltig = false;
        String Zeile = "";
        String RC = "";
        String Werterklaerung = "";
        if (Werte[0].compareToIgnoreCase("L") == 0 || Werte[0].compareToIgnoreCase("LI") == 0 || Werte[0].compareToIgnoreCase("LD") == 0 || Werte[0].compareToIgnoreCase("LID") == 0) {
            if (Werte.length < 2) {
                fProt.prot("keine Wertauspraegungen fuer Typ >" + Werte[0] + "< vorhanden");
            } else {
                int i = 1;
                while (i < Werte.length) {
                    if (Wert.compareTo(Werte[i]) == 0 || Werte[0].startsWith("LI") && Wert.compareToIgnoreCase(Werte[i]) == 0) {
                        gueltig = true;
                        RC = Werte[i];
                        break;
                    }
                    ++i;
                }
                if (!gueltig) {
                    RC = Werte[1];
                    Zeile = Werte[1];
                    i = 2;
                    while (i < Werte.length) {
                        Zeile = String.valueOf(Zeile) + "," + Werte[i];
                        ++i;
                    }
                    fProt.prot("Wertauspraegung >" + Wert + "< von >" + Feld + "< ungueltig, gueltig sind:" + Zeile + "; Wert auf >" + RC + "< (erster Wert der Auswahlliste) gesetzt");
                }
            }
        } else if (Werte[0].compareToIgnoreCase("G") == 0) {
            if (Werte.length < 3) {
                fProt.prot("keine 2 Wertauspraegungen fuer Typ >" + Werte[0] + "< vorhanden");
            } else {
                if (vergleiche_numerisch) {
                    gueltig = false;
                    try {
                        if (Double.parseDouble(Wert) >= Double.parseDouble(Werte[1]) && Double.parseDouble(Wert) <= Double.parseDouble(Werte[2])) {
                            gueltig = true;
                            RC = Wert;
                        }
                        if (Double.parseDouble(Wert) < Double.parseDouble(Werte[1])) {
                            RC = Werte[1];
                            Werterklaerung = ", da kleiner als untere Grenze ";
                        }
                        if (Double.parseDouble(Wert) > Double.parseDouble(Werte[2])) {
                            RC = Werte[2];
                            Werterklaerung = ", da groesser als obere Grenze ";
                        }
                    }
                    catch (Exception e) {
                        RC = Werte[1];
                        Werterklaerung = ", auf kleinsten gueltigen Wert, ab ungueltiges Format ";
                    }
                } else {
                    if (Wert.compareToIgnoreCase(Werte[1]) >= 0 && Wert.compareToIgnoreCase(Werte[2]) <= 0) {
                        gueltig = true;
                        RC = Wert;
                    } else {
                        gueltig = false;
                    }
                    if (Wert.compareToIgnoreCase(Werte[1]) < 0) {
                        RC = Werte[1];
                        Werterklaerung = ", da kleiner als untere Grenze";
                    }
                    if (Wert.compareToIgnoreCase(Werte[2]) > 0) {
                        RC = Werte[2];
                        Werterklaerung = ", da groesser als obere Grenze ";
                    }
                }
                if (!gueltig) {
                    fProt.prot("Wertauspraegung >" + Wert + "< von >" + Feld + "< ungueltig, nicht >=" + Werte[1] + " und <=" + Werte[2] + "; Wert auf >" + RC + "< gesetzt" + Werterklaerung);
                }
            }
        } else if (Werte[0].compareToIgnoreCase("V") == 0 || Werte[0].compareToIgnoreCase("D") == 0 || Werte[0].compareToIgnoreCase("F") == 0) {
            if (Werte.length < 2) {
                fProt.prot("keine Wertauspraegung fuer Typ >" + Werte[0] + "< vorhanden");
            } else if (Werte[1].compareToIgnoreCase("R") != 0 && Werte[1].compareToIgnoreCase("W") != 0) {
                fProt.prot("Wertauspraegung >" + Werte[1] + "< von >" + Werte[0] + "< ungueltig, gueltig sind R (Read) und W (Write)");
            } else if (Wert.length() > 0) {
                RC = Werte.length > 2 && Werte[2].compareToIgnoreCase("K") == 0 ? FDatei.checkDatei(Wert, Werte[0].charAt(0), Werte[1].charAt(0), Feld, true) : FDatei.checkDatei(Wert, Werte[0].charAt(0), Werte[1].charAt(0), Feld);
                if (RC.length() == 0) {
                    fProt.prot("Datei/Verzeichnis >" + Wert + "< von >" + Feld + "< ungueltig, Wert ignoriert");
                } else if (Werte.length > 2 && Werte[2].compareToIgnoreCase("N") == 0) {
                    RC = Wert;
                }
            }
        } else if (Werte[0].compareToIgnoreCase("R") == 0 || Werte[0].compareToIgnoreCase("RT") == 0 || Werte[0].compareToIgnoreCase("RV") == 0 || Werte[0].compareToIgnoreCase("RTV") == 0 || Werte[0].compareToIgnoreCase("R*") == 0 || Werte[0].compareToIgnoreCase("RT*") == 0 || Werte[0].compareToIgnoreCase("RV*") == 0 || Werte[0].compareToIgnoreCase("RTV*") == 0 || Werte[0].compareToIgnoreCase("T") == 0 || Werte[0].compareToIgnoreCase("T*") == 0 || Werte[0].compareToIgnoreCase("TI") == 0 || Werte[0].compareToIgnoreCase("[BL]") == 0) {
            RC = Wert;
        } else {
            fProt.prot("Wertauspraegungstyp >" + Werte[0] + "< ungueltig, keine Pruefung durchgefuehrt, gueltig sind: \nL=Liste, LI=Liste mit Pruefung ignore Case, G=Pruefung auf Grenzen, D=Datei, V=Verzeichnis, F=File,\nR[T[V]]=registrierte DB, R[T[V]]*=reg. DB inkl. Auswahl alle (*) (T=nur Tabellen, V=nur Views), T=Tabelle,TI=Tabelle inkl. Aenderung Name, T*=Tabelle inkl. Auswahl alle (*), S=Spalten");
        }
        return RC;
    }

    public static String[][] pruefenUndSpeichernParameter(String[] arg, String[][] Tab) {
        Futi.instance();
        return FParam.pruefenUndSpeichernParameter(arg, Tab, Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
    }

    public static String[][] pruefenUndSpeichernParameter(String[] args, String[][] Tab, String Prefix) {
        FProt fProt = FProt.instance();
        int i = 0;
        while (i < args.length) {
            int pos;
            if (args[i].substring(0, Prefix.length()).compareToIgnoreCase(Prefix) == 0) {
                pos = FParam.getIndexOfParameterZeileViaKuerzelInklWert(args[i].substring(Prefix.length()), Tab);
                if (pos >= 0) {
                    FParam.checkUndSetWertEinzelParameter(pos, args[i].substring(Prefix.length() + Tab[pos][0].length()), Tab);
                }
            } else if (args[i].charAt(0) == '-') {
                pos = FParam.getIndexOfParameterZeileViaKuerzelInklWert(args[i].substring(1), Tab);
                if (pos >= 0) {
                    FParam.checkUndSetWertEinzelParameter(pos, args[i].substring(1 + Tab[pos][0].length()), Tab);
                }
            } else {
                fProt.prot("Parameter >" + args[i] + "< unbekannt");
            }
            ++i;
        }
        return Tab;
    }

    public static String[][] readParameter(String Name) {
        Futi.instance();
        String name = Name;
        if (!name.endsWith(".par")) {
            name = String.valueOf(name) + ".par";
        }
        return FString.convertStringArrayToTabelle(Futi.readResource(name), 7, true);
    }

    public static void zeigenArgTab(String[][] Tab) {
        FParam.zeigenArgTab(Tab, null);
    }

    public static void zeigenArgTab(String[][] Tab, String datei) {
        FProt fProt = FProt.instance();
        ArrayList<String> Ausgabe = new ArrayList<String>();
        String[][] stringArray = Tab;
        int n = Tab.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            String Zeile = element[0];
            int j = 1;
            while (j < element.length) {
                Zeile = String.valueOf(Zeile) + "\t" + element[j];
                ++j;
            }
            Ausgabe.add(Zeile);
            ++n2;
        }
        if (datei == null) {
            fProt.prot(FString.arrayListToStringArray(Ausgabe), 0, false);
        } else {
            FFile Datei = new FFile(datei);
            Datei.StringArrayListToInhalt(Ausgabe);
        }
    }

    public static void zeigenHilfezuParametern(String[][] Tab) {
        Futi.instance();
        FParam.zeigenHilfezuParametern(Tab, Tab, Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
    }

    public static void zeigenHilfezuParametern(String[][] Tab, String[][] Tab_aktuell) {
        Futi.instance();
        FParam.zeigenHilfezuParametern(Tab, Tab_aktuell, Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
    }

    public static void zeigenHilfezuParametern(String[][] Tab, String[][] Tab_aktuell, String Prefix) {
        FProt fProt = FProt.instance();
        fProt.prot(FParam.getParameterBeschreibung(Tab, Prefix), 0, false);
        FParam.zeigenParameter(Tab_aktuell);
    }

    public static void zeigenParameter(String[][] Tab) {
        FProt fProt = FProt.instance();
        int max = 0;
        int i = 0;
        while (i < Tab.length) {
            if (Tab[i][2].compareTo("Remark") != 0 && Tab[i][3].length() > max) {
                max = Tab[i][3].length();
            }
            ++i;
        }
        String Filler = " ";
        i = 0;
        while (i < max) {
            Filler = String.valueOf(Filler) + " ";
            ++i;
        }
        fProt.prot("Die aktuell gesetzten Parameter sind:");
        i = 0;
        while (i < Tab.length) {
            if (Tab[i][2].compareTo("Remark") != 0) {
                String Feld = String.valueOf(Tab[i][3]) + Filler;
                Feld = Feld.substring(0, max);
                fProt.prot(String.valueOf(Feld) + ": " + Tab[i][4]);
            }
            ++i;
        }
    }

    public ArrayList<ArgTabZeile> createArgTabelle(ArrayList<ArgTabZeile> ArgTabZeilen, String[][] ArgTabelle) {
        return this.createArgTabelle(ArgTabZeilen, ArgTabelle, false);
    }

    public ArrayList<ArgTabZeile> createArgTabelle(ArrayList<ArgTabZeile> ArgTabZeilen, String[][] ArgTabelle, boolean ignoreKeinGUIoption) {
        ArgTabZeilen.clear();
        ArgTabZeile argTabZeile = new ArgTabZeile();
        int i = 0;
        while (i < ArgTabelle.length) {
            if (ArgTabelle[i][0].length() + ArgTabelle[i][1].length() + ArgTabelle[i][2].length() + ArgTabelle[i][3].length() + ArgTabelle[i][4].length() + ArgTabelle[i][5].length() > 0) {
                argTabZeile = new ArgTabZeile();
                argTabZeile.setKuerzel(ArgTabelle[i][0]);
                argTabZeile.setName(ArgTabelle[i][1]);
                argTabZeile.setTyp(ArgTabelle[i][2]);
                argTabZeile.setBeschreibung(ArgTabelle[i][3]);
                argTabZeile.setDefault(ArgTabelle[i][4]);
                argTabZeile.setWerteBereich(ArgTabelle[i][5]);
                argTabZeile.setKeinGUIerstellen(ignoreKeinGUIoption ? "" : ArgTabelle[i][6]);
                if (ArgTabZeilen.size() > 0 && argTabZeile.isRemark()) {
                    argTabZeile.setName(ArgTabZeilen.get(ArgTabZeilen.size() - 1).getName());
                }
                if (!argTabZeile.isKeinGUIerstellen()) {
                    argTabZeile.setGUITyp("FJComboBox");
                    argTabZeile.setGUIFeldName(String.valueOf(argTabZeile.getName()) + "ComboBox");
                    if (argTabZeile.getTyp().compareTo("boolean") == 0) {
                        argTabZeile.setGUITyp("JCheckBox");
                        argTabZeile.setGUIFeldName(String.valueOf(argTabZeile.getName()) + "CheckBox");
                    }
                    if (argTabZeile.getWerteBereich().startsWith("G") && argTabZeile.getTyp().compareTo("int") == 0) {
                        argTabZeile.setGUITyp("JSlider");
                        argTabZeile.setGUIFeldName(String.valueOf(argTabZeile.getName()) + "Slider");
                    }
                    if (argTabZeile.getWerteBereich().startsWith("L") || !argTabZeile.getWerteBereich().startsWith("TI") && FParam.createArgTabelleFindRegDBReferenz(argTabZeile.getName(), ArgTabZeilen)) {
                        argTabZeile.setGUIPruefTyp("Auswahlliste");
                    }
                    if (argTabZeile.getWerteBereich().startsWith("D") || argTabZeile.getWerteBereich().startsWith("V") || argTabZeile.getWerteBereich().startsWith("F")) {
                        argTabZeile.setGUIPruefTyp("File");
                    }
                }
                ArgTabZeilen.add(argTabZeile);
            }
            ++i;
        }
        argTabZeile = new ArgTabZeile();
        i = 0;
        while (i < ArgTabZeilen.size()) {
            argTabZeile = ArgTabZeilen.get(i);
            if (!argTabZeile.isKeinGUIerstellen()) {
                if (argTabZeile.getGUITyp().compareTo("FJComboBox") == 0) {
                    String[] Teile;
                    if (argTabZeile.getWerteBereich().indexOf("[BL]") >= 0) {
                        argTabZeile.setGUITyp("FJComboBoxStoreBlankLine");
                    }
                    if (argTabZeile.getWerteBereich().startsWith("R")) {
                        argTabZeile.setWerteBereich(FParam.createArgTabelleCheckWertebereich(argTabZeile.getWerteBereich(), ArgTabZeilen));
                        Teile = argTabZeile.getWerteBereich().split(",");
                        if (Teile.length > 1 && Teile[1] != null && Teile[1].length() > 0) {
                            argTabZeile.setGUIPruefTyp("Datenbank");
                        } else {
                            argTabZeile.setGUIPruefTyp("Datenbank_ONLY");
                        }
                    }
                    if (argTabZeile.getWerteBereich().startsWith("T")) {
                        argTabZeile.setWerteBereich(FParam.createArgTabelleCheckWertebereich(argTabZeile.getWerteBereich(), ArgTabZeilen));
                        Teile = argTabZeile.getWerteBereich().split(",");
                        if (Teile.length > 2 && Teile[1] != null && Teile[1].length() > 0 && Teile[2] != null && Teile[2].length() > 0) {
                            argTabZeile.setGUIPruefTyp("Tabelle");
                        }
                    }
                }
                if (argTabZeile.isRemark()) {
                    if (i > 0 && !ArgTabZeilen.get(i - 1).isRemark() && argTabZeile.getName().compareTo(ArgTabZeilen.get(i - 1).getName()) == 0) {
                        if (i < ArgTabZeilen.size() - 1 && ArgTabZeilen.get(i + 1).isRemark() && argTabZeile.getName().compareTo(ArgTabZeilen.get(i + 1).getName()) == 0 && ArgTabZeilen.get(i - 1).getGUITyp().compareTo("FJComboBox") == 0 && ArgTabZeilen.get(i - 1).getGUIPruefTyp().compareTo("File") != 0) {
                            argTabZeile.setGUITyp("JButton");
                            argTabZeile.setGUIFeldName(String.valueOf(argTabZeile.getName()) + "Button");
                        } else {
                            argTabZeile.setGUITyp("ToolTip");
                            argTabZeile.setGUIFeldName("");
                        }
                    } else {
                        argTabZeile.setGUITyp("");
                        argTabZeile.setGUIFeldName("");
                    }
                }
                ArgTabZeilen.set(i, argTabZeile);
            }
            ++i;
        }
        return ArgTabZeilen;
    }

    public String[] getParameterBeschreibung() {
        Futi.instance();
        return FParam.getParameterBeschreibung(this.ArgTabTO, Futi.getBenutzerWert("Trennzeichen CommandlineParameter"));
    }

    public boolean isZeigeHilfe() {
        return this.ZeigeHilfe;
    }

    public boolean isZeigeParameter() {
        return this.ZeigeParameter;
    }

    public boolean isZeigeZeit() {
        return this.ZeigeZeit;
    }

    public boolean runVorlauf(String[][] ArgTab, String[][] ArgTab_Default, String[] HilfeText) {
        FProt fProt = FProt.instance();
        boolean run = true;
        fProt.setMsgLevel(FParam.getIntParameter("MsgLevel", ArgTab));
        this.setZeigeParameter(FParam.getBooleanParameter("ZeigeParameter", ArgTab));
        this.setZeigeZeit(FParam.getBooleanParameter("ZeigeZeit", ArgTab));
        this.setZeigeHilfe(FParam.getBooleanParameter("ZeigeHilfe", ArgTab));
        if (this.isZeigeHilfe()) {
            fProt.prot(HilfeText, 0, false);
            FParam.zeigenHilfezuParametern(ArgTab_Default, ArgTab);
            run = false;
        }
        if (this.isZeigeParameter()) {
            FParam.zeigenParameter(ArgTab);
        }
        return run;
    }

    public String[][] setArgTab(String[][] ArgTabT1) {
        int j;
        String[] Zeile;
        String[][] ArgTabT2 = FParam.readParameter("Standard.par");
        ArrayList<String[]> Zeilen = new ArrayList<String[]>();
        int i = 0;
        while (i < ArgTabT1.length) {
            if (ArgTabT1[i].length > 5 && ArgTabT1[i][0].length() + ArgTabT1[i][1].length() + ArgTabT1[i][2].length() + ArgTabT1[i][3].length() + ArgTabT1[i][4].length() + ArgTabT1[i][5].length() > 0) {
                Zeile = new String[ArgTabT1[i].length];
                j = 0;
                while (j < ArgTabT1[i].length) {
                    Zeile[j] = ArgTabT1[i][j];
                    ++j;
                }
                Zeilen.add(Zeile);
            }
            ++i;
        }
        i = 0;
        while (i < ArgTabT2.length) {
            if (ArgTabT2[i].length > 5 && ArgTabT2[i][0].length() + ArgTabT2[i][1].length() + ArgTabT2[i][2].length() + ArgTabT2[i][3].length() + ArgTabT2[i][4].length() + ArgTabT2[i][5].length() > 0) {
                Zeile = new String[ArgTabT2[i].length];
                j = 0;
                while (j < ArgTabT2[i].length) {
                    Zeile[j] = ArgTabT2[i][j];
                    ++j;
                }
                Zeilen.add(Zeile);
            }
            ++i;
        }
        String[][] ArgTab = FString.arrayListToTabelle(Zeilen);
        i = 0;
        while (i < ArgTab.length) {
            j = 0;
            while (j < ArgTab[i].length) {
                if (ArgTab[i][j] == null) {
                    ArgTab[i][j] = "";
                }
                ++j;
            }
            if (ArgTab[i][4].length() == 0) {
                if (ArgTab[i][2].compareTo("boolean") == 0) {
                    ArgTab[i][4] = "nein";
                } else if (ArgTab[i][5].startsWith("G") || ArgTab[i][5].startsWith("L")) {
                    String[] Teile = ArgTab[i][5].split(",");
                    if (Teile.length > 1) {
                        ArgTab[i][4] = Teile[1];
                    }
                } else if (ArgTab[i][2].compareTo("int") == 0 || ArgTab[i][2].compareTo("long") == 0) {
                    ArgTab[i][4] = "0";
                } else if (ArgTab[i][2].compareTo("double") == 0) {
                    ArgTab[i][4] = "0.0";
                }
            }
            ++i;
        }
        this.ArgTabTO = ArgTabT1;
        return ArgTab;
    }

    public void setZeigeHilfe(boolean zeigeHilfe) {
        this.ZeigeHilfe = zeigeHilfe;
    }

    public void setZeigeParameter(boolean zeigeParameter) {
        this.ZeigeParameter = zeigeParameter;
    }

    public void setZeigeZeit(boolean zeigeZeit) {
        this.ZeigeZeit = zeigeZeit;
    }
}

