/*
 * Decompiled with CFR 0.152.
 */
package de.nss.jfi.Uti;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import de.nss.jfi.ChangeChars;
import de.nss.jfi.Uti.FFile;
import de.nss.jfi.Uti.FGregorianCalendar;
import de.nss.jfi.Uti.FString;
import java.io.IOException;
import java.util.ArrayList;

public class JpegExif {
    private String Beschreibung;
    private String KameraModel;
    private String KameraMake;
    private String Artist;
    private String Copyright;
    private String SerialNumberMakernotes;
    private String SerialNumberExif;
    private String DateTimeOriginal;
    private String DateOriginal;
    private String TimeOriginal;
    private String DateTimeGPS;
    private String DateGPS;
    private String TimeGPS;
    private String FileNumber;
    private String ImageNumber;
    private String LensModel;
    private String LensMake;
    private String ProcessingSoftware;
    private String Warning;
    private int Breite;
    private int Hoehe;

    public static String[] getJpegExifAlleTags(FFile ffile, boolean mitStruktur, boolean mitGPS, boolean mitMaker, boolean alleAttribute) {
        ArrayList<String> tagArray = new ArrayList<String>();
        if (ffile.canRead() && ffile.isPicture()) {
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(ffile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (metadata != null) {
                for (Directory directory : metadata.getDirectories()) {
                    if (alleAttribute || directory.getName().compareToIgnoreCase("Exif") == 0 || mitGPS && (directory.getName().compareToIgnoreCase("GPS") == 0 || directory.getName().compareToIgnoreCase("IPTC") == 0) || mitMaker && directory.getName().indexOf("Makernote") >= 0) {
                        for (Tag tag : directory.getTags()) {
                            if (alleAttribute || tag.getTagName().indexOf("Unknown") < 0) {
                                if (mitStruktur) {
                                    try {
                                        tagArray.add(String.valueOf(ffile.getCanonicalPath()) + "\t" + directory.getName() + "\t" + tag.getTagType() + "\t" + tag.getTagName() + "\t" + tag.getDescription());
                                    }
                                    catch (IOException iOException) {}
                                    continue;
                                }
                                tagArray.add(String.valueOf(tag.toString()) + " (" + tag.getTagType() + ")");
                                continue;
                            }
                            System.console().writer().println(" Tag not selected:" + tag.getTagName() + "\t" + tag.getDescription() + "\t" + tagArray.add(String.valueOf(tag.toString()) + "\t" + tag.getTagType()));
                        }
                        continue;
                    }
                    System.out.println("Directory not selected:" + directory.getName());
                }
            }
        } else {
            System.out.println("Datei >" + ffile.getName() + "< nicht vorhanden, kein Bild oder nicht lesbar");
        }
        return FString.arrayListToStringArray(tagArray);
    }

    public static String getJpegExifTag(FFile ffile, String DirectoryName, int TagNummer) {
        String Tag2 = "";
        if (ffile.canRead() && ffile.isPicture()) {
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(ffile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (metadata != null) {
                for (Directory directory : metadata.getDirectories()) {
                    Tag tag;
                    if (directory.getName().compareToIgnoreCase(DirectoryName) != 0 || (tag = new Tag(TagNummer, directory)).getDescription() == null) continue;
                    Tag2 = tag.getDescription();
                }
            }
        }
        return Tag2;
    }

    public static String getJpegExifTag(FFile ffile, String DirectoryName, String TagName) {
        String[][] DirAndTag = new String[1][2];
        DirAndTag[0][0] = DirectoryName;
        DirAndTag[0][1] = TagName;
        return JpegExif.getJpegExifTags(ffile, DirAndTag)[0];
    }

    public static String[] getJpegExifTags(FFile ffile, String[][] DirAndTag) {
        String[] tags = new String[DirAndTag.length];
        int i = 0;
        while (i < tags.length) {
            tags[i] = "-";
            ++i;
        }
        if (ffile.canRead() && ffile.isPicture()) {
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(ffile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (metadata != null) {
                for (Directory directory : metadata.getDirectories()) {
                    for (Tag tag : directory.getTags()) {
                        int i2 = 0;
                        while (i2 < DirAndTag.length) {
                            if (directory.getName().compareToIgnoreCase(DirAndTag[i2][0]) == 0 && tag.getTagName().compareToIgnoreCase(DirAndTag[i2][1]) == 0 && tag.getDescription() != null) {
                                tags[i2] = tag.getDescription();
                            }
                            ++i2;
                        }
                    }
                }
            }
        }
        return tags;
    }

    public static JpegExif getJpegExifWichtigeTags(FFile ffile) {
        JpegExif aus = new JpegExif();
        aus.init();
        if (ffile.canRead() && ffile.isPicture()) {
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(ffile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (metadata != null) {
                GpsDirectory gps;
                JpegDirectory jpeg;
                IptcDirectory iptc;
                ExifSubIFDDirectory exifSubIFD;
                ExifIFD0Directory exifIFD0;
                ExifDirectoryBase exifBase;
                CanonMakernoteDirectory canonMakernotes = metadata.getFirstDirectoryOfType(CanonMakernoteDirectory.class);
                if (canonMakernotes != null) {
                    aus.setSerialNumberMakernotes(canonMakernotes.getString(12));
                    aus.setFileNumber(canonMakernotes.getString(8));
                }
                if ((exifBase = metadata.getFirstDirectoryOfType(ExifDirectoryBase.class)) != null) {
                    aus.setBeschreibung(exifBase.getString(270));
                }
                if ((exifIFD0 = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class)) != null) {
                    aus.setArtist(exifIFD0.getString(315));
                    aus.setKameraModel(exifIFD0.getString(272));
                    aus.setKameraMake(exifIFD0.getString(271));
                    aus.setCopyright(exifIFD0.getString(33432));
                    aus.setProcessingSoftware(exifIFD0.getString(305));
                }
                if ((exifSubIFD = metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class)) != null) {
                    aus.setSerialNumberExif(exifSubIFD.getString(42033));
                    aus.setDateTimeOriginal(exifSubIFD.getString(36867));
                    aus.setImageNumber(exifSubIFD.getString(37393));
                    aus.setLensMake(exifSubIFD.getString(42035));
                    aus.setLensModel(exifSubIFD.getString(42036));
                }
                if ((iptc = metadata.getFirstDirectoryOfType(IptcDirectory.class)) != null && aus.getBeschreibung().length() == 0) {
                    aus.setBeschreibung(iptc.getString(632));
                }
                if ((jpeg = metadata.getFirstDirectoryOfType(JpegDirectory.class)) != null) {
                    try {
                        aus.setHoehe(jpeg.getImageHeight());
                        aus.setBreite(jpeg.getImageWidth());
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                }
                if ((gps = metadata.getFirstDirectoryOfType(GpsDirectory.class)) != null) {
                    aus.setDateGPS(gps.getString(29));
                    aus.setTimeGPS(gps.getString(7));
                    aus.setTimeGPS(aus.getTimeGPS().replace("/1", "").replace(' ', ':'));
                }
                for (Directory directory : metadata.getDirectories()) {
                    if (metadata.hasErrors()) {
                        aus.setWarning(String.valueOf(aus.getWarning()) + (aus.getWarning().length() > 0 ? "; " : "") + "Fehler in Exifdaten");
                    }
                    if (!directory.hasErrors()) continue;
                    for (String error : directory.getErrors()) {
                        aus.setWarning(String.valueOf(aus.getWarning()) + (aus.getWarning().length() > 0 ? "; " : "") + error);
                    }
                }
            }
            if (aus.getDateTimeOriginal().length() > 11) {
                aus.setDateTimeOriginal(String.valueOf(aus.getDateTimeOriginal().substring(8, 10)) + "." + aus.getDateTimeOriginal().substring(5, 7) + "." + aus.getDateTimeOriginal().substring(0, 4) + " " + aus.getDateTimeOriginal().substring(11));
                aus.setDateOriginal(aus.getDateTimeOriginal().substring(0, 10));
                aus.setTimeOriginal(aus.getDateTimeOriginal().substring(11, 19));
            }
            if (aus.getDateGPS().length() > 9) {
                aus.setDateGPS(String.valueOf(aus.getDateGPS().substring(8, 10)) + "." + aus.getDateGPS().substring(5, 7) + "." + aus.getDateGPS().substring(0, 4));
                aus.setDateTimeGPS(String.valueOf(aus.getDateGPS()) + " " + aus.getTimeGPS());
            }
            if (aus.getBeschreibung().length() > 0) {
                ChangeChars changeChars = ChangeChars.instance();
                changeChars.setExterneZeile(aus.getBeschreibung());
                changeChars.setKonvertierung("U");
                changeChars.run();
                aus.setBeschreibung(changeChars.getExterneZeile());
            }
        }
        return aus;
    }

    public String getArtist() {
        return this.Artist;
    }

    public String getBeschreibung() {
        return this.Beschreibung;
    }

    public int getBreite() {
        return this.Breite;
    }

    public String getCopyright() {
        return this.Copyright;
    }

    public String getDateGPS() {
        return this.DateGPS;
    }

    public String getDateOriginal() {
        return this.DateOriginal;
    }

    public String getDateTimeGPS() {
        return this.DateTimeGPS;
    }

    public String getDateTimeOriginal() {
        return this.DateTimeOriginal;
    }

    public String getDateTimeOriginal(char auswahl) {
        String rc = this.DateTimeOriginal;
        if (this.DateTimeOriginal.length() >= 19) {
            this.DateTimeOriginal = this.DateTimeOriginal.replace(' ', '0');
            try {
                FGregorianCalendar zeit = new FGregorianCalendar();
                zeit.set(Integer.parseInt(this.DateTimeOriginal.substring(6, 10)), Integer.parseInt(this.DateTimeOriginal.substring(3, 5)) - 1, Integer.parseInt(this.DateTimeOriginal.substring(0, 2)), Integer.parseInt(this.DateTimeOriginal.substring(11, 13)), Integer.parseInt(this.DateTimeOriginal.substring(14, 16)), Integer.parseInt(this.DateTimeOriginal.substring(17, 19)));
                rc = zeit.toGermanFormat(auswahl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rc;
    }

    public String getFileNumber() {
        return this.FileNumber;
    }

    public int getHoehe() {
        return this.Hoehe;
    }

    public String getImageNumber() {
        return this.ImageNumber;
    }

    public String getKameraMake() {
        return this.KameraMake;
    }

    public String getKameraModel() {
        return this.KameraModel;
    }

    public String getLensMake() {
        return this.LensMake;
    }

    public String getLensModel() {
        return this.LensModel;
    }

    public String getProcessingSoftware() {
        return this.ProcessingSoftware;
    }

    public String getSerialNumberExif() {
        return this.SerialNumberExif;
    }

    public String getSerialNumberMakernotes() {
        return this.SerialNumberMakernotes;
    }

    public String getTimeGPS() {
        return this.TimeGPS;
    }

    public String getTimeOriginal() {
        return this.TimeOriginal;
    }

    public String getWarning() {
        return this.Warning;
    }

    void init() {
        this.setBeschreibung("");
        this.setKameraModel("");
        this.setKameraMake("");
        this.setArtist("");
        this.setCopyright("");
        this.setSerialNumberMakernotes("");
        this.setSerialNumberExif("");
        this.setDateTimeOriginal("");
        this.setDateOriginal("");
        this.setTimeOriginal("");
        this.setDateTimeGPS("");
        this.setDateGPS("");
        this.setTimeGPS("");
        this.setFileNumber("");
        this.setImageNumber("");
        this.setLensModel("");
        this.setLensMake("");
        this.setKameraMake("");
        this.setProcessingSoftware("");
        this.setWarning("");
        this.setBreite(0);
        this.setHoehe(0);
    }

    void setArtist(String input) {
        this.Artist = input != null ? input : "";
    }

    void setBeschreibung(String input) {
        this.Beschreibung = input != null ? input : "";
    }

    public void setBreite(int breite) {
        this.Breite = breite;
    }

    void setCopyright(String input) {
        this.Copyright = input != null ? input : "";
    }

    public void setDateGPS(String input) {
        this.DateGPS = input != null ? input : "";
    }

    public void setDateOriginal(String input) {
        this.DateOriginal = input != null ? input : "";
    }

    public void setDateTimeGPS(String input) {
        this.DateTimeGPS = input != null ? input : "";
    }

    public void setDateTimeOriginal(String input) {
        this.DateTimeOriginal = input != null ? input : "";
    }

    public void setFileNumber(String input) {
        this.FileNumber = input != null ? input : "";
    }

    public void setHoehe(int hoehe) {
        this.Hoehe = hoehe;
    }

    public void setImageNumber(String input) {
        this.ImageNumber = input != null ? input : "";
    }

    public void setKameraMake(String input) {
        this.KameraMake = input != null ? input : "";
    }

    public void setKameraModel(String input) {
        this.KameraModel = input != null ? input : "";
    }

    public void setLensMake(String lensMake) {
        this.LensMake = lensMake;
    }

    public void setLensModel(String input) {
        this.LensModel = input != null ? input : "";
    }

    public void setProcessingSoftware(String input) {
        this.ProcessingSoftware = input != null ? input : "";
    }

    public void setSerialNumberExif(String input) {
        this.SerialNumberExif = input != null ? input : "";
    }

    public void setSerialNumberMakernotes(String input) {
        this.SerialNumberMakernotes = input != null ? input : "";
    }

    public void setTimeGPS(String input) {
        this.TimeGPS = input != null ? input : "";
    }

    public void setTimeOriginal(String input) {
        this.TimeOriginal = input != null ? input : "";
    }

    public void setWarning(String input) {
        this.Warning = input != null ? input : "";
    }

    public String toString() {
        return "Beschreibung           : " + this.getBeschreibung() + System.getProperty("line.separator") + "KameraModel            : " + this.getKameraModel() + System.getProperty("line.separator") + "KameraMake             : " + this.getKameraMake() + System.getProperty("line.separator") + "Artist                 : " + this.getArtist() + System.getProperty("line.separator") + "Copyright              : " + this.getCopyright() + System.getProperty("line.separator") + "SerialNumberMakernotes : " + this.getSerialNumberMakernotes() + System.getProperty("line.separator") + "SerialNumberExif       : " + this.getSerialNumberExif() + System.getProperty("line.separator") + "DateTimeOriginal       : " + this.getDateTimeOriginal() + System.getProperty("line.separator") + "DateOriginal           : " + this.getDateOriginal() + System.getProperty("line.separator") + "TimeOriginal           : " + this.getTimeOriginal() + System.getProperty("line.separator") + "DateTimeGPS            : " + this.getDateTimeGPS() + System.getProperty("line.separator") + "DateGPS                : " + this.getDateGPS() + System.getProperty("line.separator") + "TimeGPS                : " + this.getTimeGPS() + System.getProperty("line.separator") + "FileNumber             : " + this.getFileNumber() + System.getProperty("line.separator") + "ImageNumber            : " + this.getImageNumber() + System.getProperty("line.separator") + "LensModel              : " + this.getLensModel() + System.getProperty("line.separator") + "LensMake               : " + this.getKameraMake() + System.getProperty("line.separator") + "ProcessingSoftware     : " + this.getProcessingSoftware() + System.getProperty("line.separator") + "Breite                 : " + this.getBreite() + System.getProperty("line.separator") + "Hoehe                  : " + this.getHoehe() + System.getProperty("line.separator") + "Warning                : " + this.getWarning() + System.getProperty("line.separator");
    }
}

