/*
 * Decompiled with CFR 0.152.
 */
package net.java.frej;

import net.java.frej.Regex;

abstract class Elem {
    Regex owner;
    int matchStart;
    int matchLen;
    Elem[] children;
    String replacement;
    String matchReplacement;
    String group;
    boolean optional;

    Elem(Regex regex) {
        this.owner = regex;
    }

    abstract double matchAt(int var1);

    int getMatchLen() {
        return this.matchLen;
    }

    String childrenString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < this.children.length; ++i) {
            stringBuilder.append(this.children[i].toString());
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    void setReplacement(String string) {
        this.replacement = string;
    }

    String getReplacement() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.replacement == null) {
            return this.getMatchReplacement();
        }
        for (int i = 0; i < this.replacement.length(); ++i) {
            char c = this.replacement.charAt(i);
            if (c == '$' && i < this.replacement.length() - 1) {
                c = this.replacement.charAt(++i);
                switch (c) {
                    case '$': {
                        stringBuilder.append(this.getMatchReplacement());
                        break;
                    }
                    case '<': {
                        stringBuilder.append(this.owner.prefix());
                        break;
                    }
                    case '>': {
                        stringBuilder.append(this.owner.suffix());
                        break;
                    }
                    default: {
                        if (i < 2 || this.replacement.charAt(i - 2) != '(') {
                            stringBuilder.append(this.owner.getGroup(this.replacement.substring(i, i + 1)));
                            break;
                        }
                        String string = this.replacement.substring(i).replaceFirst("\\).*", "");
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        stringBuilder.append(this.owner.getGroup(string));
                        i += string.length();
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    String getMatchReplacement() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.matchReplacement != null) {
            return this.matchReplacement;
        }
        for (int i = 0; i < this.matchLen; ++i) {
            stringBuilder.append(this.owner.tokens[this.matchStart + i]);
            stringBuilder.append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    void saveGroup() {
        if (this.group == null || this.group.isEmpty()) {
            return;
        }
        this.owner.setGroup(this.group, this.getMatchReplacement());
    }

    void setGroup(String string) {
        this.group = string;
    }

    public String toString() {
        return (this.group != "" && this.group != null ? "~" + this.group : "") + (this.replacement != null ? "|" + this.replacement : "");
    }
}

