/*
 * Decompiled with CFR 0.152.
 */
package net.java.frej;

import net.java.frej.Elem;
import net.java.frej.Regex;

final class Numeric
extends Elem {
    private int min;
    private int max;

    Numeric(Regex regex, String string) {
        super(regex);
        String[] stringArray = string.split(":");
        if (stringArray.length == 0 || stringArray[0].isEmpty()) {
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
        } else if (stringArray.length == 1) {
            this.min = 1;
            this.max = Integer.parseInt(stringArray[0]);
        } else {
            this.min = Integer.parseInt(stringArray[0]);
            this.max = Integer.parseInt(stringArray[1]);
        }
    }

    @Override
    double matchAt(int n) {
        int n2;
        this.matchStart = n;
        this.matchLen = 0;
        if (n >= this.owner.tokens.length) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            n2 = Integer.parseInt(this.owner.tokens[n]);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.POSITIVE_INFINITY;
        }
        if (n2 < this.min || n2 > this.max) {
            return Double.POSITIVE_INFINITY;
        }
        this.matchLen = 1;
        this.saveGroup();
        return 0.0;
    }

    @Override
    public String toString() {
        if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            return "(#)";
        }
        if (this.min == 1) {
            return "(#" + this.max + ")";
        }
        return "(#" + this.min + ":" + this.max + ")" + super.toString();
    }
}

