/*
 * Decompiled with CFR 0.152.
 */
package net.java.frej;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.java.frej.Any;
import net.java.frej.Both;
import net.java.frej.Elem;
import net.java.frej.Follow;
import net.java.frej.Memory;
import net.java.frej.Numeric;
import net.java.frej.Regular;
import net.java.frej.Special;
import net.java.frej.Subexpr;
import net.java.frej.Token;
import net.java.frej.fuzzy.Fuzzy;

public final class Regex {
    private Elem root;
    private Special terminator = new Special(this, null);
    String[] tokens;
    private int[] tokenPos;
    private double matchResult;
    private String original;
    private String replaceResult;
    private int firstMatched;
    private int lastMatched;
    GroupMap groups = new GroupMap();
    private String allowedPunct = "/-";
    private double threshold = Fuzzy.threshold;
    Map<String, Elem> subs = new HashMap<String, Elem>();

    public Regex(String string) {
        string = this.fixPattern(string);
        String[] stringArray = string.split("::");
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n;
            if (i > 0) {
                n = 0;
                while (Character.isLetterOrDigit(stringArray[i].charAt(n))) {
                    ++n;
                }
            } else {
                n = 0;
            }
            this.subs.put(stringArray[i].substring(0, n), this.parse(stringArray[i].substring(n).replaceAll("\\s+", "")));
        }
        this.root = this.subs.get("");
    }

    public Regex(String string, double d, String string2) {
        this(string);
        if (d >= 0.0) {
            this.setThreshold(d);
        }
        if (string2 != null) {
            this.setAllowedPunctuationMarks(string2);
        }
    }

    private String fixPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            ++n4;
            if (bl) {
                if (c != '\r' && c != '\n') continue;
                bl = false;
            } else if (n2 == 47 && c == '/') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                bl = true;
                continue;
            }
            n2 = c;
            stringBuilder.append(c);
            if (c == '\\') {
                ++n;
                continue;
            }
            if ((n & 1) == 0) {
                if (Character.isWhitespace(c)) {
                    if (c == '\r' || c == '\n') {
                        ++n3;
                        n4 = 0;
                    }
                } else if ("({[".indexOf(c) >= 0) {
                    stack.push(Character.valueOf(c));
                    stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "(");
                } else if (")}]".indexOf(c) >= 0) {
                    if (stack.empty() || ((Character)stack.peek()).charValue() != "({[".charAt(")}]".indexOf(c))) {
                        throw new IllegalArgumentException("Mismatched bracket at " + n3 + ":" + n4);
                    }
                    stack.pop();
                    stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), ")");
                }
            } else {
                switch (c) {
                    case '(': {
                        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "o");
                        break;
                    }
                    case ')': {
                        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "c");
                    }
                }
            }
            n = 0;
        }
        return stringBuilder.toString();
    }

    private String eliminateEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == '_') {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            bl = false;
            if (c == 'r') {
                stringBuilder.append('\r');
                continue;
            }
            if (c == 'n') {
                stringBuilder.append('\n');
                continue;
            }
            if (c == 'o') {
                stringBuilder.append('(');
                continue;
            }
            if (c == 'c') {
                stringBuilder.append(')');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Elem parse(String string) {
        void var2_18;
        String string2;
        char c;
        String string3 = null;
        int n = 0;
        block14: for (int i = string.length() - 1; i >= 0; --i) {
            c = string.charAt(i);
            switch (c) {
                case ')': {
                    ++n;
                    break;
                }
                case '(': {
                    --n;
                    break;
                }
                case '|': {
                    if (n != 0) break;
                    string3 = string.substring(i + 1);
                    string = string.substring(0, i);
                    break block14;
                }
            }
        }
        if ((string2 = this.extractGroupName(string)).length() > 0) {
            string = string.substring(0, string.length() - string2.length() - 1);
        }
        if (string.charAt(0) == '(') {
            n = 1;
            if (string.charAt(n) == '?') {
                c = '\u0001';
                ++n;
            } else {
                c = '\u0000';
            }
            if (string.length() <= n || string.charAt(string.length() - 1) != ')') {
                throw new RuntimeException("Unclosed closure!");
            }
            String string4 = string.toString().substring(n + 1, string.length() - 1);
            switch (string.charAt(n)) {
                case '=': {
                    Both both = new Both(this, this.parseList(string4));
                    break;
                }
                case '^': {
                    Any any = new Any(this, this.parseList(string4));
                    break;
                }
                case '!': {
                    Regular regular = new Regular(this, this.eliminateEscapes(string4));
                    break;
                }
                case '#': {
                    Numeric numeric = new Numeric(this, string4);
                    break;
                }
                case '@': {
                    if (!this.subs.containsKey(string4)) {
                        throw new RuntimeException("Undefined sub '" + string4 + "'!");
                    }
                    Subexpr subexpr = new Subexpr(this, string4);
                    break;
                }
                case '$': {
                    Memory memory = new Memory(this, string4);
                    break;
                }
                case '.': {
                    Special special = new Special(this, string4);
                    break;
                }
                default: {
                    Follow follow = new Follow(this, this.parseList(string.toString().substring(n, string.length() - 1)));
                }
            }
            var2_16.optional = c;
        } else {
            Token token = new Token(this, this.eliminateEscapes(string));
        }
        if (string3 != null) {
            var2_18.setReplacement(this.eliminateEscapes(string3));
        }
        var2_18.setGroup(string2);
        return var2_18;
    }

    private String extractGroupName(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '~') {
                return string.substring(i + 1);
            }
            if (Character.isLetterOrDigit(c)) continue;
            return "";
        }
        return "";
    }

    private Elem[] parseList(String string) {
        LinkedList<Elem> linkedList = new LinkedList<Elem>();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        stringBuilder.append(',');
        int n2 = 0;
        while (stringBuilder.length() > 0) {
            char c = stringBuilder.charAt(n2);
            if (c == '(') {
                ++n;
            } else if (c == ')') {
                --n;
            } else if (c == ',' && n == 0) {
                linkedList.add(this.parse(stringBuilder.substring(0, n2)));
                stringBuilder.delete(0, n2 + 1);
                n2 = -1;
            }
            ++n2;
        }
        return linkedList.toArray(new Elem[linkedList.size()]);
    }

    public int presentInSequence(String string) {
        double d = Double.POSITIVE_INFINITY;
        int n = -1;
        int n2 = -1;
        GroupMap groupMap = null;
        this.groups.clear();
        this.splitTokens(string);
        for (int i = 0; i < this.tokens.length; ++i) {
            double d2 = this.root.matchAt(i);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
            n2 = this.root.getMatchLen();
            this.firstMatched = n;
            this.lastMatched = n + n2 - 1;
            this.replaceResult = this.root.getReplacement();
            groupMap = this.groups;
            this.groups = new GroupMap();
        }
        if (d > this.threshold) {
            return -1;
        }
        this.groups = groupMap;
        this.matchResult = d;
        return n;
    }

    public boolean match(String string) {
        this.groups.clear();
        this.splitTokens(string);
        this.matchResult = this.root.matchAt(0);
        if (this.matchResult > this.threshold || this.root.getMatchLen() != this.tokens.length) {
            return false;
        }
        this.firstMatched = 0;
        this.lastMatched = this.tokens.length - 1;
        this.replaceResult = this.root.getReplacement();
        return true;
    }

    public boolean matchFromStart(String string) {
        this.groups.clear();
        this.splitTokens(string);
        this.matchResult = this.root.matchAt(0);
        if (this.matchResult > this.threshold) {
            return false;
        }
        this.firstMatched = 0;
        this.lastMatched = this.root.getMatchLen() - 1;
        this.replaceResult = this.root.getReplacement();
        return true;
    }

    public double getMatchResult() {
        return this.matchResult;
    }

    public String getReplacement() {
        return this.replaceResult;
    }

    public int getMatchStart() {
        if (this.firstMatched < 0) {
            return 0;
        }
        if (this.firstMatched >= this.tokens.length) {
            return this.original.length();
        }
        return this.tokenPos[this.firstMatched];
    }

    public int getMatchEnd() {
        if (this.lastMatched < 0) {
            return 0;
        }
        if (this.lastMatched >= this.tokens.length) {
            return this.original.length();
        }
        return this.tokenPos[this.lastMatched] + this.tokens[this.lastMatched].length();
    }

    public String pattern() {
        return this.root.toString();
    }

    public int matchedTokenCount() {
        return this.root.getMatchLen();
    }

    public String prefix() {
        return this.original.substring(0, this.getMatchStart()).trim();
    }

    public String suffix() {
        return this.original.substring(this.getMatchEnd()).trim();
    }

    public String setAllowedPunctuationMarks(String string) {
        this.allowedPunct = string;
        return this.allowedPunct;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    private void splitTokens(String string) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        this.original = string;
        CharType charType = CharType.SEPARATOR;
        for (n = 0; n <= string.length(); ++n) {
            CharType charType2;
            char c;
            try {
                c = string.charAt(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                c = '\u0000';
                charType2 = CharType.SEPARATOR;
            }
            CharType charType3 = Character.isLetter(c) ? CharType.LETTER : (Character.isDigit(c) ? CharType.DIGIT : (charType2 = this.allowedPunct.indexOf(c) >= 0 ? CharType.ALLOWED_PUNCT : CharType.SEPARATOR));
            if ((charType != charType2 || charType2 == CharType.ALLOWED_PUNCT) && stringBuilder.length() > 0) {
                linkedList.add(stringBuilder.toString());
                linkedList2.add(n - stringBuilder.length());
                stringBuilder.setLength(0);
            }
            charType = charType2;
            if (charType2 == CharType.SEPARATOR) continue;
            stringBuilder.append(c);
        }
        this.tokens = linkedList.toArray(new String[linkedList.size()]);
        this.tokenPos = new int[linkedList2.size()];
        for (n = 0; n < this.tokenPos.length; ++n) {
            this.tokenPos[n] = (Integer)linkedList2.remove(0);
        }
    }

    String getGroup(String string) {
        String string2 = (String)this.groups.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    void setGroup(String string, String string2) {
        this.groups.put(string, string2);
    }

    static class GroupMap
    extends HashMap<String, String> {
        public GroupMap() {
        }

        public GroupMap(GroupMap groupMap) {
            super(groupMap);
        }
    }

    private static enum CharType {
        SEPARATOR,
        DIGIT,
        LETTER,
        ALLOWED_PUNCT;

    }
}

