/*
 * Decompiled with CFR 0.152.
 */
package net.java.frej;

import net.java.frej.Elem;
import net.java.frej.Regex;
import net.java.frej.fuzzy.Fuzzy;

final class Token
extends Elem {
    private String token;
    private boolean partial;

    Token(Regex regex, String string) {
        super(regex);
        this.changePattern(string);
    }

    @Override
    double matchAt(int n) {
        this.matchStart = n;
        this.matchLen = 0;
        if (n >= this.owner.tokens.length) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.partial && this.owner.tokens[n].length() > this.token.length()) {
            Fuzzy.similarity(this.owner.tokens[n].substring(0, this.token.length()), this.token);
        } else {
            Fuzzy.similarity(this.owner.tokens[n], this.token);
        }
        this.matchLen = 1;
        this.saveGroup();
        return Fuzzy.result;
    }

    @Override
    String getReplacement() {
        if (this.replacement == null) {
            return this.partial ? this.getMatchReplacement() : this.token;
        }
        return super.getReplacement();
    }

    @Override
    public String toString() {
        return this.token + super.toString();
    }

    void changePattern(String string) {
        if (string == null || string.charAt(string.length() - 1) != '*') {
            this.token = string;
            this.partial = false;
        } else {
            this.token = string.substring(0, string.length() - 1);
            this.partial = true;
        }
    }
}

