/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import org.geonames.InvalidParameterException;
import org.geonames.Style;

public class PostalCodeSearchCriteria {
    private String postalCode;
    private String placeName;
    private String adminCode1;
    private String countryCode;
    private String countryBias;
    private Double latitude;
    private Double longitude;
    private double radius;
    private Style style;
    private int maxRows;
    private int startRow;
    private boolean isOROperator = false;
    private Boolean isReduced;

    public String getAdminCode1() {
        return this.adminCode1;
    }

    public String getCountryBias() {
        return this.countryBias;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean isOROperator() {
        return this.isOROperator;
    }

    public Boolean isReduced() {
        return this.isReduced;
    }

    public void setAdminCode1(String adminCode1) {
        this.adminCode1 = adminCode1;
    }

    public void setCountryBias(String countryBias) {
        this.countryBias = countryBias;
    }

    public void setCountryCode(String countryCode) throws InvalidParameterException {
        if (countryCode != null && countryCode.length() != 2) {
            throw new InvalidParameterException("invalid country code " + countryCode);
        }
        this.countryCode = countryCode;
    }

    public void setIsReduced(Boolean isReduced) {
        this.isReduced = isReduced;
    }

    public void setLatitude(double latitude) throws InvalidParameterException {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new InvalidParameterException("invalid latitude " + latitude);
        }
        this.latitude = new Double(latitude);
    }

    public void setLongitude(double longitude) throws InvalidParameterException {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new InvalidParameterException("invalid longitude " + longitude);
        }
        this.longitude = new Double(longitude);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setOROperator(boolean isOROperator) {
        this.isOROperator = isOROperator;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStyle(Style style) {
        this.style = style;
    }
}

