/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geonames.Address;
import org.geonames.FeatureClass;
import org.geonames.GeoNamesException;
import org.geonames.Intersection;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.StreetSegment;
import org.geonames.Style;
import org.geonames.Timezone;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WeatherObservation;
import org.geonames.WikipediaArticle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WebService {
    private static Logger logger;
    private static String USER_AGENT;
    private static boolean isAndroid;
    private static String geoNamesServer;
    private static String geoNamesServerFailover;
    private static long timeOfLastFailureMainServer;
    private static long averageConnectTime;
    private static long averageSampleSize;
    private static Style defaultStyle;
    private static int readTimeOut;
    private static int connectTimeOut;
    private static String DATEFMT;
    private static String userName;
    private static String token;
    private static TimeZone utc;

    static {
        String osVersion;
        logger = Logger.getLogger("org.geonames");
        USER_AGENT = "gnwsc/1.1.7";
        isAndroid = false;
        geoNamesServer = "http://api.geonames.org";
        geoNamesServerFailover = "http://api.geonames.org";
        averageSampleSize = 20L;
        defaultStyle = Style.MEDIUM;
        readTimeOut = 120000;
        connectTimeOut = 10000;
        DATEFMT = "yyyy-MM-dd HH:mm:ss";
        USER_AGENT = String.valueOf(USER_AGENT) + " (";
        String os = System.getProperty("os.name");
        if (os != null) {
            USER_AGENT = String.valueOf(USER_AGENT) + os + ",";
        }
        if ((osVersion = System.getProperty("os.version")) != null) {
            USER_AGENT = String.valueOf(USER_AGENT) + osVersion;
        }
        USER_AGENT = String.valueOf(USER_AGENT) + ")";
        try {
            Class<?> aClass = Class.forName("android.os.Build");
            if (aClass != null) {
                Field field;
                int n;
                int n2;
                Field[] fieldArray;
                isAndroid = true;
                Field[] fields = aClass.getFields();
                if (fields != null) {
                    fieldArray = fields;
                    n2 = fields.length;
                    n = 0;
                    while (n < n2) {
                        field = fieldArray[n];
                        if ("MODEL".equalsIgnoreCase(field.getName())) {
                            USER_AGENT = String.valueOf(USER_AGENT) + "(" + field.get(aClass) + ", ";
                        }
                        ++n;
                    }
                }
                if ((aClass = Class.forName("android.os.Build$VERSION")) != null && (fields = aClass.getFields()) != null) {
                    fieldArray = fields;
                    n2 = fields.length;
                    n = 0;
                    while (n < n2) {
                        field = fieldArray[n];
                        if ("RELEASE".equalsIgnoreCase(field.getName())) {
                            USER_AGENT = String.valueOf(USER_AGENT) + field.get(aClass);
                        }
                        ++n;
                    }
                }
                USER_AGENT = String.valueOf(USER_AGENT) + ")";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        utc = TimeZone.getTimeZone("UTC");
    }

    private static String addDefaultStyle(String url) {
        String url1 = url;
        if (defaultStyle != Style.MEDIUM) {
            url1 = String.valueOf(url1) + "&style=" + defaultStyle.name();
        }
        return url1;
    }

    private static String addUserName(String url) {
        String url1 = url;
        if (userName != null) {
            url1 = String.valueOf(url1) + "&username=" + userName;
        }
        if (token != null) {
            url1 = String.valueOf(url1) + "&token=" + token;
        }
        return url1;
    }

    public static int astergdem(double latitude, double longitude) throws IOException {
        String url = "/astergdem?lat=" + latitude + "&lng=" + longitude;
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        String astergdem = in.readLine();
        in.close();
        return Integer.parseInt(astergdem);
    }

    public static int[] astergdem(double[] latitude, double[] longitude) throws IOException {
        if (latitude.length != longitude.length) {
            throw new Error("number of lats and longs must be equal");
        }
        int[] elevation = new int[latitude.length];
        String lats = "";
        String lngs = "";
        int i = 0;
        while (i < elevation.length) {
            lats = String.valueOf(lats) + latitude[i] + ",";
            lngs = String.valueOf(lngs) + longitude[i] + ",";
            ++i;
        }
        String url = "/astergdem?lats=" + lats + "&lngs=" + lngs;
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        int i2 = 0;
        while (i2 < elevation.length) {
            String astergdem = in.readLine();
            elevation[i2] = Integer.parseInt(astergdem);
            ++i2;
        }
        in.close();
        return elevation;
    }

    private static void checkException(Element root) throws GeoNamesException {
        Element message = root.getChild("status");
        if (message != null) {
            int code = 0;
            try {
                code = Integer.parseInt(message.getAttributeValue("value"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new GeoNamesException(code, message.getAttributeValue("message"));
        }
    }

    public static ToponymSearchResult children(int geonameId, String language, Style style) throws Exception {
        ToponymSearchResult searchResult = new ToponymSearchResult();
        String url = "/children?";
        url = String.valueOf(url) + "geonameId=" + geonameId;
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = style != null ? String.valueOf(url) + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(url);
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        searchResult.totalResultsCount = Integer.parseInt(root.getChildText("totalResultsCount"));
        searchResult.setStyle(Style.valueOf(root.getAttributeValue("style")));
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            searchResult.toponyms.add(toponym);
        }
        return searchResult;
    }

    private static InputStream connect(String url) throws IOException {
        int status = 0;
        String currentlyActiveServer = WebService.getCurrentlyActiveServer();
        try {
            long begin = System.currentTimeMillis();
            HttpURLConnection httpConnection = (HttpURLConnection)new URL(String.valueOf(currentlyActiveServer) + url).openConnection();
            httpConnection.setConnectTimeout(connectTimeOut);
            httpConnection.setReadTimeout(readTimeOut);
            httpConnection.setRequestProperty("User-Agent", USER_AGENT);
            InputStream in = httpConnection.getInputStream();
            status = httpConnection.getResponseCode();
            if (status == 200) {
                long elapsedTime = System.currentTimeMillis() - begin;
                averageConnectTime = (averageConnectTime * (averageSampleSize - 1L) + elapsedTime) / averageSampleSize;
                if (geoNamesServerFailover != null && averageConnectTime > 5000L && !currentlyActiveServer.equals(geoNamesServerFailover)) {
                    timeOfLastFailureMainServer = System.currentTimeMillis();
                }
                return in;
            }
        }
        catch (IOException e) {
            return WebService.tryFailoverServer(url, currentlyActiveServer, 0, e);
        }
        IOException ioException = new IOException("status code " + status + " for " + url);
        return WebService.tryFailoverServer(url, currentlyActiveServer, status, ioException);
    }

    private static Element connectAndParse(String url) throws GeoNamesException, IOException, JDOMException {
        SAXBuilder parser = new SAXBuilder();
        Document doc = parser.build(WebService.connect(url));
        try {
            Element root = WebService.rootAndCheckException(doc);
            return root;
        }
        catch (GeoNamesException geoNamesException) {
            if (geoNamesException.getExceptionCode() == 13 || geoNamesException.getMessage() != null && geoNamesException.getMessage().indexOf("canceling statement due to statement timeout") > -1) {
                String currentlyActiveServer = WebService.getCurrentlyActiveServer();
                if (geoNamesServerFailover != null && !currentlyActiveServer.equals(geoNamesServerFailover)) {
                    timeOfLastFailureMainServer = System.currentTimeMillis();
                    doc = parser.build(WebService.connect(url));
                    Element root = WebService.rootAndCheckException(doc);
                    return root;
                }
            }
            throw geoNamesException;
        }
    }

    public static String countryCode(double latitude, double longitude) throws IOException {
        return WebService.countryCode(latitude, longitude, 0.0);
    }

    public static String countryCode(double latitude, double longitude, double radius) throws IOException {
        String url = "/countryCode?lat=" + latitude + "&lng=" + longitude;
        if (radius != 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        String cc = in.readLine();
        in.close();
        if (cc != null && cc.length() == 2) {
            return cc;
        }
        return null;
    }

    public static List<Toponym> findNearby(double latitude, double longitude, double radius, FeatureClass featureClass, String[] featureCodes, String language, int maxRows) throws IOException, Exception {
        ArrayList<Toponym> places = new ArrayList<Toponym>();
        String url = "/findNearby?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        if (maxRows > 0) {
            url = String.valueOf(url) + "&maxRows=" + maxRows;
        }
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        if (featureClass != null) {
            url = String.valueOf(url) + "&featureClass=" + (Object)((Object)featureClass);
        }
        if (featureCodes != null && featureCodes.length > 0) {
            String[] stringArray = featureCodes;
            int n = featureCodes.length;
            int n2 = 0;
            while (n2 < n) {
                String featureCode = stringArray[n2];
                url = String.valueOf(url) + "&featureCode=" + featureCode;
                ++n2;
            }
        }
        url = WebService.addUserName(url);
        url = WebService.addDefaultStyle(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            places.add(toponym);
        }
        return places;
    }

    public static List<Toponym> findNearby(double latitude, double longitude, FeatureClass featureClass, String[] featureCodes) throws IOException, Exception {
        return WebService.findNearby(latitude, longitude, 0.0, featureClass, featureCodes, null, 0);
    }

    public static List<Toponym> findNearbyPlaceName(double latitude, double longitude) throws IOException, Exception {
        return WebService.findNearbyPlaceName(latitude, longitude, 0.0, 0);
    }

    public static List<Toponym> findNearbyPlaceName(double latitude, double longitude, double radius, int maxRows) throws IOException, Exception {
        ArrayList<Toponym> places = new ArrayList<Toponym>();
        String url = "/findNearbyPlaceName?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        if (maxRows > 0) {
            url = String.valueOf(url) + "&maxRows=" + maxRows;
        }
        url = WebService.addUserName(url);
        url = WebService.addDefaultStyle(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            places.add(toponym);
        }
        return places;
    }

    public static List<Toponym> findNearbyPOIsOSM(double latitude, double longitude) throws IOException, Exception {
        return WebService.findNearbyPOIsOSM(latitude, longitude, null, 0.0);
    }

    public static List<Toponym> findNearbyPOIsOSM(double latitude, double longitude, String language, double radius) throws IOException, Exception {
        ArrayList<Toponym> places = new ArrayList<Toponym>();
        String url = "/findNearbyPOIsOSM?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        url = String.valueOf(url) + "&maxRows=10";
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = WebService.addUserName(url);
        url = WebService.addDefaultStyle(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("poi")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            places.add(toponym);
        }
        return places;
    }

    public static List<PostalCode> findNearbyPostalCodes(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> postalCodes = new ArrayList<PostalCode>();
        String url = "/findNearbyPostalCodes?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            url = String.valueOf(url) + "&postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            url = String.valueOf(url) + "&placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            url = String.valueOf(url) + "&country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getLatitude() != null) {
            url = String.valueOf(url) + "&lat=" + postalCodeSearchCriteria.getLatitude();
        }
        if (postalCodeSearchCriteria.getLongitude() != null) {
            url = String.valueOf(url) + "&lng=" + postalCodeSearchCriteria.getLongitude();
        }
        if (postalCodeSearchCriteria.getStyle() != null) {
            url = String.valueOf(url) + "&style=" + (Object)((Object)postalCodeSearchCriteria.getStyle());
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            url = String.valueOf(url) + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getRadius() > 0.0) {
            url = String.valueOf(url) + "&radius=" + postalCodeSearchCriteria.getRadius();
        }
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("code")) {
            Element codeElement = (Element)obj;
            PostalCode code = new PostalCode();
            code.setPostalCode(codeElement.getChildText("postalcode"));
            code.setPlaceName(codeElement.getChildText("name"));
            code.setCountryCode(codeElement.getChildText("countryCode"));
            code.setLatitude(Double.parseDouble(codeElement.getChildText("lat")));
            code.setLongitude(Double.parseDouble(codeElement.getChildText("lng")));
            code.setAdminName1(codeElement.getChildText("adminName1"));
            code.setAdminCode1(codeElement.getChildText("adminCode1"));
            code.setAdminName2(codeElement.getChildText("adminName2"));
            code.setAdminCode2(codeElement.getChildText("adminCode2"));
            if (codeElement.getChildText("distance") != null) {
                code.setDistance(Double.parseDouble(codeElement.getChildText("distance")));
            }
            postalCodes.add(code);
        }
        return postalCodes;
    }

    public static List<StreetSegment> findNearbyStreets(double latitude, double longitude, double radius) throws Exception {
        String url = "/findNearbyStreets?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        url = WebService.addUserName(url);
        ArrayList<StreetSegment> segments = new ArrayList<StreetSegment>();
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("streetSegment")) {
            Element e = (Element)obj;
            StreetSegment streetSegment = new StreetSegment();
            String line = e.getChildText("line");
            String[] points = line.split(",");
            double[] latArray = new double[points.length];
            double[] lngArray = new double[points.length];
            int i = 0;
            while (i < points.length) {
                String[] coords = points[i].split(" ");
                lngArray[i] = Double.parseDouble(coords[0]);
                latArray[i] = Double.parseDouble(coords[1]);
                ++i;
            }
            streetSegment.setCfcc(e.getChildText("cfcc"));
            streetSegment.setName(e.getChildText("name"));
            streetSegment.setFraddl(e.getChildText("fraddl"));
            streetSegment.setFraddr(e.getChildText("fraddr"));
            streetSegment.setToaddl(e.getChildText("toaddl"));
            streetSegment.setToaddr(e.getChildText("toaddr"));
            streetSegment.setPostalCode(e.getChildText("postalcode"));
            streetSegment.setPlaceName(e.getChildText("placename"));
            streetSegment.setCountryCode(e.getChildText("countryCode"));
            streetSegment.setAdminName2(e.getChildText("adminName2"));
            streetSegment.setAdminCode1(e.getChildText("adminCode1"));
            streetSegment.setAdminName1(e.getChildText("adminName1"));
            segments.add(streetSegment);
        }
        return segments;
    }

    public static List<StreetSegment> findNearbyStreetsOSM(double latitude, double longitude, String language, double radius) throws Exception {
        String url = "/findNearbyStreetsOSM?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        url = String.valueOf(url) + "&lang=" + language;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        url = WebService.addUserName(url);
        ArrayList<StreetSegment> segments = new ArrayList<StreetSegment>();
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("streetSegment")) {
            Element e = (Element)obj;
            StreetSegment streetSegment = new StreetSegment();
            String line = e.getChildText("line");
            String[] points = line.split(",");
            double[] latArray = new double[points.length];
            double[] lngArray = new double[points.length];
            int i = 0;
            while (i < points.length) {
                String[] coords = points[i].split(" ");
                lngArray[i] = Double.parseDouble(coords[0]);
                latArray[i] = Double.parseDouble(coords[1]);
                ++i;
            }
            streetSegment.setName(e.getChildText("name"));
            segments.add(streetSegment);
        }
        return segments;
    }

    public static WeatherObservation findNearByWeather(double latitude, double longitude) throws IOException, Exception {
        String url = "/findNearByWeatherXML?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        Element root = WebService.connectAndParse(url = WebService.addUserName(url));
        Iterator iterator = root.getChildren("observation").iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            Element weatherObservationElement = (Element)obj;
            WeatherObservation weatherObservation = WebService.getWeatherObservationFromElement(weatherObservationElement);
            return weatherObservation;
        }
        return null;
    }

    public static List<WikipediaArticle> findNearbyWikipedia(double latitude, double longitude, double radius, String language, int maxRows) throws Exception {
        ArrayList<WikipediaArticle> articles = new ArrayList<WikipediaArticle>();
        String url = "/findNearbyWikipedia?";
        url = String.valueOf(url) + "lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        if (maxRows > 0) {
            url = String.valueOf(url) + "&maxRows=" + maxRows;
        }
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("entry")) {
            Element wikipediaArticleElement = (Element)obj;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(wikipediaArticleElement);
            articles.add(wikipediaArticle);
        }
        return articles;
    }

    public static List<WikipediaArticle> findNearbyWikipedia(double latitude, double longitude, String language) throws Exception {
        return WebService.findNearbyWikipedia(latitude, longitude, 0.0, language, 0);
    }

    public static Address findNearestAddress(double latitude, double longitude) throws IOException, Exception {
        String url = "/findNearestAddress?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        Element root = WebService.connectAndParse(url = WebService.addUserName(url));
        Iterator iterator = root.getChildren("address").iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            Element codeElement = (Element)obj;
            Address address = new Address();
            address.setStreet(codeElement.getChildText("street"));
            address.setStreetNumber(codeElement.getChildText("streetNumber"));
            address.setMtfcc(codeElement.getChildText("mtfcc"));
            address.setPostalCode(codeElement.getChildText("postalcode"));
            address.setPlaceName(codeElement.getChildText("placename"));
            address.setCountryCode(codeElement.getChildText("countryCode"));
            address.setLatitude(Double.parseDouble(codeElement.getChildText("lat")));
            address.setLongitude(Double.parseDouble(codeElement.getChildText("lng")));
            address.setAdminName1(codeElement.getChildText("adminName1"));
            address.setAdminCode1(codeElement.getChildText("adminCode1"));
            address.setAdminName2(codeElement.getChildText("adminName2"));
            address.setAdminCode2(codeElement.getChildText("adminCode2"));
            address.setDistance(Double.parseDouble(codeElement.getChildText("distance")));
            return address;
        }
        return null;
    }

    public static Intersection findNearestIntersection(double latitude, double longitude) throws Exception {
        return WebService.findNearestIntersection(latitude, longitude, 0.0);
    }

    public static Intersection findNearestIntersection(double latitude, double longitude, double radius) throws Exception {
        Element root;
        Iterator iterator;
        String url = "/findNearestIntersection?";
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        if (radius > 0.0) {
            url = String.valueOf(url) + "&radius=" + radius;
        }
        if ((iterator = (root = WebService.connectAndParse(url = WebService.addUserName(url))).getChildren("intersection").iterator()).hasNext()) {
            Object obj = iterator.next();
            Element e = (Element)obj;
            Intersection intersection = new Intersection();
            intersection.setStreet1(e.getChildText("street1"));
            intersection.setStreet2(e.getChildText("street2"));
            intersection.setLatitude(Double.parseDouble(e.getChildText("lat")));
            intersection.setLongitude(Double.parseDouble(e.getChildText("lng")));
            intersection.setDistance(Double.parseDouble(e.getChildText("distance")));
            intersection.setPostalCode(e.getChildText("postalcode"));
            intersection.setPlaceName(e.getChildText("placename"));
            intersection.setCountryCode(e.getChildText("countryCode"));
            intersection.setAdminName2(e.getChildText("adminName2"));
            intersection.setAdminCode1(e.getChildText("adminCode1"));
            intersection.setAdminName1(e.getChildText("adminName1"));
            return intersection;
        }
        return null;
    }

    public static Toponym get(int geoNameId, String language, String style) throws IOException, Exception {
        String url = "/get?";
        url = String.valueOf(url) + "geonameId=" + geoNameId;
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = style != null ? String.valueOf(url) + "&style=" + style : WebService.addDefaultStyle(url);
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        Toponym toponym = WebService.getToponymFromElement(root);
        return toponym;
    }

    public static int getConnectTimeOut() {
        return connectTimeOut;
    }

    private static String getCurrentlyActiveServer() {
        if (timeOfLastFailureMainServer == 0L) {
            return geoNamesServer;
        }
        if (System.currentTimeMillis() - timeOfLastFailureMainServer > 600000L) {
            timeOfLastFailureMainServer = 0L;
            return geoNamesServer;
        }
        if (System.currentTimeMillis() < timeOfLastFailureMainServer) {
            throw new Error("time of last failure cannot be in future.");
        }
        if (geoNamesServerFailover != null) {
            return geoNamesServerFailover;
        }
        return geoNamesServer;
    }

    public static Style getDefaultStyle() {
        return defaultStyle;
    }

    public static String getGeoNamesServer() {
        return geoNamesServer;
    }

    public static String getGeoNamesServerFailover() {
        return geoNamesServerFailover;
    }

    public static int getReadTimeOut() {
        return readTimeOut;
    }

    public static String getToken() {
        return token;
    }

    private static Toponym getToponymFromElement(Element toponymElement) {
        String elevation;
        Toponym toponym = new Toponym();
        toponym.setName(toponymElement.getChildText("name"));
        toponym.setAlternateNames(toponymElement.getChildText("alternateNames"));
        toponym.setLatitude(Double.parseDouble(toponymElement.getChildText("lat")));
        toponym.setLongitude(Double.parseDouble(toponymElement.getChildText("lng")));
        String geonameId = toponymElement.getChildText("geonameId");
        if (geonameId != null) {
            toponym.setGeoNameId(Integer.parseInt(geonameId));
        }
        toponym.setContinentCode(toponymElement.getChildText("continentCode"));
        toponym.setCountryCode(toponymElement.getChildText("countryCode"));
        toponym.setCountryName(toponymElement.getChildText("countryName"));
        toponym.setFeatureClass(FeatureClass.fromValue(toponymElement.getChildText("fcl")));
        toponym.setFeatureCode(toponymElement.getChildText("fcode"));
        toponym.setFeatureClassName(toponymElement.getChildText("fclName"));
        toponym.setFeatureCodeName(toponymElement.getChildText("fCodeName"));
        String population = toponymElement.getChildText("population");
        if (population != null && !"".equals(population)) {
            toponym.setPopulation(Long.parseLong(population));
        }
        if ((elevation = toponymElement.getChildText("elevation")) != null && !"".equals(elevation)) {
            toponym.setElevation(Integer.parseInt(elevation));
        }
        toponym.setAdminCode1(toponymElement.getChildText("adminCode1"));
        toponym.setAdminName1(toponymElement.getChildText("adminName1"));
        toponym.setAdminCode2(toponymElement.getChildText("adminCode2"));
        toponym.setAdminName2(toponymElement.getChildText("adminName2"));
        toponym.setAdminCode3(toponymElement.getChildText("adminCode3"));
        toponym.setAdminCode4(toponymElement.getChildText("adminCode4"));
        Element timezoneElement = toponymElement.getChild("timezone");
        if (timezoneElement != null) {
            Timezone timezone = new Timezone();
            timezone.setTimezoneId(timezoneElement.getValue());
            timezone.setDstOffset(Double.parseDouble(timezoneElement.getAttributeValue("dstOffset")));
            timezone.setGmtOffset(Double.parseDouble(timezoneElement.getAttributeValue("gmtOffset")));
            toponym.setTimezone(timezone);
        }
        return toponym;
    }

    public static String getUserName() {
        return userName;
    }

    private static WeatherObservation getWeatherObservationFromElement(Element weatherObservationElement) throws ParseException {
        String humidity;
        String dewPoint;
        WeatherObservation weatherObservation = new WeatherObservation();
        weatherObservation.setObservation(weatherObservationElement.getChildText("observation"));
        SimpleDateFormat df = new SimpleDateFormat(DATEFMT);
        df.setTimeZone(utc);
        weatherObservation.setObservationTime(df.parse(weatherObservationElement.getChildText("observationTime")));
        weatherObservation.setStationName(weatherObservationElement.getChildText("stationName"));
        weatherObservation.setIcaoCode(weatherObservationElement.getChildText("ICAO"));
        weatherObservation.setCountryCode(weatherObservationElement.getChildText("countryCode"));
        String elevation = weatherObservationElement.getChildText("elevation");
        if (elevation != null && !"".equals(elevation)) {
            weatherObservation.setElevation(Integer.parseInt(elevation));
        }
        weatherObservation.setLatitude(Double.parseDouble(weatherObservationElement.getChildText("lat")));
        weatherObservation.setLongitude(Double.parseDouble(weatherObservationElement.getChildText("lng")));
        String temperature = weatherObservationElement.getChildText("temperature");
        if (temperature != null && !"".equals(temperature)) {
            weatherObservation.setTemperature(Double.parseDouble(temperature));
        }
        if ((dewPoint = weatherObservationElement.getChildText("dewPoint")) != null && !"".equals(dewPoint)) {
            weatherObservation.setDewPoint(Double.parseDouble(dewPoint));
        }
        if ((humidity = weatherObservationElement.getChildText("humidity")) != null && !"".equals(humidity)) {
            weatherObservation.setHumidity(Double.parseDouble(humidity));
        }
        weatherObservation.setClouds(weatherObservationElement.getChildText("clouds"));
        weatherObservation.setWeatherCondition(weatherObservationElement.getChildText("weatherCondition"));
        weatherObservation.setWindSpeed(weatherObservationElement.getChildText("windSpeed"));
        return weatherObservation;
    }

    private static WikipediaArticle getWikipediaArticleFromElement(Element wikipediaArticleElement) {
        String elevation;
        WikipediaArticle wikipediaArticle = new WikipediaArticle();
        wikipediaArticle.setLanguage(wikipediaArticleElement.getChildText("lang"));
        wikipediaArticle.setTitle(wikipediaArticleElement.getChildText("title"));
        wikipediaArticle.setSummary(wikipediaArticleElement.getChildText("summary"));
        wikipediaArticle.setFeature(wikipediaArticleElement.getChildText("feature"));
        wikipediaArticle.setWikipediaUrl(wikipediaArticleElement.getChildText("wikipediaUrl"));
        wikipediaArticle.setThumbnailImg(wikipediaArticleElement.getChildText("thumbnailImg"));
        wikipediaArticle.setLatitude(Double.parseDouble(wikipediaArticleElement.getChildText("lat")));
        wikipediaArticle.setLongitude(Double.parseDouble(wikipediaArticleElement.getChildText("lng")));
        wikipediaArticle.setRank(Integer.parseInt(wikipediaArticleElement.getChildText("rank")));
        String population = wikipediaArticleElement.getChildText("population");
        if (population != null && !"".equals(population)) {
            wikipediaArticle.setPopulation(Integer.parseInt(population));
        }
        if ((elevation = wikipediaArticleElement.getChildText("elevation")) != null && !"".equals(elevation)) {
            wikipediaArticle.setElevation(Integer.parseInt(elevation));
        }
        return wikipediaArticle;
    }

    public static int gtopo30(double latitude, double longitude) throws IOException {
        String url = "/gtopo30?lat=" + latitude + "&lng=" + longitude;
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        String gtopo30 = in.readLine();
        in.close();
        return Integer.parseInt(gtopo30);
    }

    public static List<Toponym> hierarchy(int geonameId, String language, Style style) throws Exception {
        String url = "/hierarchy?";
        url = String.valueOf(url) + "geonameId=" + geonameId;
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = style != null ? String.valueOf(url) + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(url);
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        ArrayList<Toponym> toponyms = new ArrayList<Toponym>();
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            toponyms.add(toponym);
        }
        return toponyms;
    }

    public static boolean isAndroid() {
        return isAndroid;
    }

    public static ToponymSearchResult neighbours(int geonameId, String language, Style style) throws Exception {
        ToponymSearchResult searchResult = new ToponymSearchResult();
        String url = "/neighbours?";
        url = String.valueOf(url) + "geonameId=" + geonameId;
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = style != null ? String.valueOf(url) + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(url);
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        searchResult.totalResultsCount = Integer.parseInt(root.getChildText("totalResultsCount"));
        searchResult.setStyle(Style.valueOf(root.getAttributeValue("style")));
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            searchResult.toponyms.add(toponym);
        }
        return searchResult;
    }

    public static List<PostalCode> postalCodeSearch(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> postalCodes = new ArrayList<PostalCode>();
        String url = "/postalCodeSearch?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            url = String.valueOf(url) + "postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            if (!url.endsWith("&")) {
                url = String.valueOf(url) + "&";
            }
            url = String.valueOf(url) + "placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getAdminCode1() != null) {
            url = String.valueOf(url) + "&adminCode1=" + URLEncoder.encode(postalCodeSearchCriteria.getAdminCode1(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            if (!url.endsWith("&")) {
                url = String.valueOf(url) + "&";
            }
            url = String.valueOf(url) + "country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getCountryBias() != null) {
            if (!url.endsWith("&")) {
                url = String.valueOf(url) + "&";
            }
            url = String.valueOf(url) + "countryBias=" + postalCodeSearchCriteria.getCountryBias();
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            url = String.valueOf(url) + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getStartRow() > 0) {
            url = String.valueOf(url) + "&startRow=" + postalCodeSearchCriteria.getStartRow();
        }
        if (postalCodeSearchCriteria.isOROperator()) {
            url = String.valueOf(url) + "&operator=OR";
        }
        if (postalCodeSearchCriteria.isReduced() != null) {
            url = String.valueOf(url) + "&isReduced=" + postalCodeSearchCriteria.isReduced().toString();
        }
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("code")) {
            Element codeElement = (Element)obj;
            PostalCode code = new PostalCode();
            code.setPostalCode(codeElement.getChildText("postalcode"));
            code.setPlaceName(codeElement.getChildText("name"));
            code.setCountryCode(codeElement.getChildText("countryCode"));
            code.setAdminCode1(codeElement.getChildText("adminCode1"));
            code.setAdminCode2(codeElement.getChildText("adminCode2"));
            code.setAdminName1(codeElement.getChildText("adminName1"));
            code.setAdminName2(codeElement.getChildText("adminName2"));
            code.setLatitude(Double.parseDouble(codeElement.getChildText("lat")));
            code.setLongitude(Double.parseDouble(codeElement.getChildText("lng")));
            postalCodes.add(code);
        }
        return postalCodes;
    }

    public static List<PostalCode> postalCodeSearch(String postalCode, String placeName, String countryCode) throws Exception {
        PostalCodeSearchCriteria postalCodeSearchCriteria = new PostalCodeSearchCriteria();
        postalCodeSearchCriteria.setPostalCode(postalCode);
        postalCodeSearchCriteria.setPlaceName(placeName);
        postalCodeSearchCriteria.setCountryCode(countryCode);
        return WebService.postalCodeSearch(postalCodeSearchCriteria);
    }

    private static Element rootAndCheckException(Document doc) throws GeoNamesException {
        Element root = doc.getRootElement();
        WebService.checkException(root);
        return root;
    }

    public static void saveTags(String[] tags, Toponym toponym, String username, String password) throws Exception {
        if (toponym.getGeoNameId() == 0) {
            throw new Error("no geonameid specified");
        }
        String url = "/servlet/geonames?srv=61";
        url = String.valueOf(url) + "&geonameId=" + toponym.getGeoNameId();
        url = WebService.addUserName(url);
        StringBuilder tagsCommaseparated = new StringBuilder();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            tagsCommaseparated.append(String.valueOf(tag) + ",");
            ++n2;
        }
        url = String.valueOf(url) + "&tag=" + tagsCommaseparated;
        WebService.connectAndParse(url);
    }

    public static ToponymSearchResult search(String q, String countryCode, String name, String[] featureCodes, int startRow) throws Exception {
        return WebService.search(q, countryCode, name, featureCodes, startRow, null, null, null);
    }

    public static ToponymSearchResult search(String q, String countryCode, String name, String[] featureCodes, int startRow, String language, Style style, String exactName) throws Exception {
        ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
        searchCriteria.setQ(q);
        searchCriteria.setCountryCode(countryCode);
        searchCriteria.setName(name);
        searchCriteria.setFeatureCodes(featureCodes);
        searchCriteria.setStartRow(startRow);
        searchCriteria.setLanguage(language);
        searchCriteria.setStyle(style);
        searchCriteria.setNameEquals(exactName);
        return WebService.search(searchCriteria);
    }

    public static ToponymSearchResult search(ToponymSearchCriteria searchCriteria) throws Exception {
        ToponymSearchResult searchResult = new ToponymSearchResult();
        String url = "/search?";
        if (searchCriteria.getQ() != null) {
            url = String.valueOf(url) + "q=" + URLEncoder.encode(searchCriteria.getQ(), "UTF8");
        }
        if (searchCriteria.getNameEquals() != null) {
            url = String.valueOf(url) + "&name_equals=" + URLEncoder.encode(searchCriteria.getNameEquals(), "UTF8");
        }
        if (searchCriteria.getNameStartsWith() != null) {
            url = String.valueOf(url) + "&name_startsWith=" + URLEncoder.encode(searchCriteria.getNameStartsWith(), "UTF8");
        }
        if (searchCriteria.getName() != null) {
            url = String.valueOf(url) + "&name=" + URLEncoder.encode(searchCriteria.getName(), "UTF8");
        }
        if (searchCriteria.getTag() != null) {
            url = String.valueOf(url) + "&tag=" + URLEncoder.encode(searchCriteria.getTag(), "UTF8");
        }
        if (searchCriteria.getCountryCode() != null) {
            url = String.valueOf(url) + "&country=" + searchCriteria.getCountryCode();
        }
        if (searchCriteria.getCountryBias() != null) {
            if (!url.endsWith("&")) {
                url = String.valueOf(url) + "&";
            }
            url = String.valueOf(url) + "countryBias=" + searchCriteria.getCountryBias();
        }
        if (searchCriteria.getContinentCode() != null) {
            url = String.valueOf(url) + "&continentCode=" + searchCriteria.getContinentCode();
        }
        if (searchCriteria.getAdminCode1() != null) {
            url = String.valueOf(url) + "&adminCode1=" + URLEncoder.encode(searchCriteria.getAdminCode1(), "UTF8");
        }
        if (searchCriteria.getAdminCode2() != null) {
            url = String.valueOf(url) + "&adminCode2=" + URLEncoder.encode(searchCriteria.getAdminCode2(), "UTF8");
        }
        if (searchCriteria.getAdminCode3() != null) {
            url = String.valueOf(url) + "&adminCode3=" + URLEncoder.encode(searchCriteria.getAdminCode3(), "UTF8");
        }
        if (searchCriteria.getAdminCode4() != null) {
            url = String.valueOf(url) + "&adminCode4=" + URLEncoder.encode(searchCriteria.getAdminCode4(), "UTF8");
        }
        if (searchCriteria.getLanguage() != null) {
            url = String.valueOf(url) + "&lang=" + searchCriteria.getLanguage();
        }
        if (searchCriteria.getFeatureClass() != null) {
            url = String.valueOf(url) + "&featureClass=" + (Object)((Object)searchCriteria.getFeatureClass());
        }
        if (searchCriteria.getFeatureCodes() != null) {
            String[] stringArray = searchCriteria.getFeatureCodes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String featureCode = stringArray[n2];
                url = String.valueOf(url) + "&fcode=" + featureCode;
                ++n2;
            }
        }
        if (searchCriteria.getMaxRows() > 0) {
            url = String.valueOf(url) + "&maxRows=" + searchCriteria.getMaxRows();
        }
        if (searchCriteria.getStartRow() > 0) {
            url = String.valueOf(url) + "&startRow=" + searchCriteria.getStartRow();
        }
        url = searchCriteria.getStyle() != null ? String.valueOf(url) + "&style=" + (Object)((Object)searchCriteria.getStyle()) : WebService.addDefaultStyle(url);
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        searchResult.totalResultsCount = Integer.parseInt(root.getChildText("totalResultsCount"));
        searchResult.setStyle(Style.valueOf(root.getAttributeValue("style")));
        for (Object obj : root.getChildren("geoname")) {
            Element toponymElement = (Element)obj;
            Toponym toponym = WebService.getToponymFromElement(toponymElement);
            toponym.setStyle(searchResult.getStyle());
            searchResult.toponyms.add(toponym);
        }
        return searchResult;
    }

    public static void setConnectTimeOut(int connectTimeOut) {
        WebService.connectTimeOut = connectTimeOut;
    }

    public static void setDefaultStyle(Style defaultStyle) {
        WebService.defaultStyle = defaultStyle;
    }

    public static void setGeoNamesServer(String pGeoNamesServer1) {
        if (pGeoNamesServer1 == null) {
            throw new Error();
        }
        String pGeoNamesServer = pGeoNamesServer1.trim().toLowerCase();
        if (!pGeoNamesServer.startsWith("http://") && !pGeoNamesServer.startsWith("https://")) {
            pGeoNamesServer = "http://" + pGeoNamesServer;
        }
        geoNamesServer = pGeoNamesServer;
    }

    public static void setGeoNamesServerFailover(String geoNamesServerFailover1) {
        String geoNamesServerFailover2 = null;
        if (geoNamesServerFailover1 != null && !(geoNamesServerFailover2 = geoNamesServerFailover1.trim().toLowerCase()).startsWith("http://") && !geoNamesServerFailover2.startsWith("https://")) {
            geoNamesServerFailover2 = "http://" + geoNamesServerFailover2;
        }
        geoNamesServerFailover = geoNamesServerFailover2;
    }

    public static void setReadTimeOut(int readTimeOut) {
        WebService.readTimeOut = readTimeOut;
    }

    public static void setToken(String token) {
        WebService.token = token;
    }

    public static void setUserName(String userName) {
        WebService.userName = userName;
    }

    public static int srtm3(double latitude, double longitude) throws IOException {
        String url = "/srtm3?lat=" + latitude + "&lng=" + longitude;
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        String srtm3 = in.readLine();
        in.close();
        return Integer.parseInt(srtm3);
    }

    public static int[] srtm3(double[] latitude, double[] longitude) throws IOException {
        if (latitude.length != longitude.length) {
            throw new Error("number of lats and longs must be equal");
        }
        int[] elevation = new int[latitude.length];
        String lats = "";
        String lngs = "";
        int i = 0;
        while (i < elevation.length) {
            lats = String.valueOf(lats) + latitude[i] + ",";
            lngs = String.valueOf(lngs) + longitude[i] + ",";
            ++i;
        }
        String url = "/srtm3?lats=" + lats + "&lngs=" + lngs;
        url = WebService.addUserName(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(WebService.connect(url)));
        int i2 = 0;
        while (i2 < elevation.length) {
            String srtm3 = in.readLine();
            elevation[i2] = Integer.parseInt(srtm3);
            ++i2;
        }
        in.close();
        return elevation;
    }

    public static Timezone timezone(double latitude, double longitude) throws IOException, Exception {
        String url = "/timezone?";
        double radius = 0.0;
        url = String.valueOf(url) + "&lat=" + latitude;
        url = String.valueOf(url) + "&lng=" + longitude;
        Element root = WebService.connectAndParse(url = WebService.addUserName(url));
        Iterator iterator = root.getChildren("timezone").iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            Element codeElement = (Element)obj;
            Timezone timezone = new Timezone();
            timezone.setTimezoneId(codeElement.getChildText("timezoneId"));
            timezone.setCountryCode(codeElement.getChildText("countryCode"));
            if (codeElement.getChildText("time") != null) {
                String minuteDateFmt = "yyyy-MM-dd HH:mm";
                SimpleDateFormat df = null;
                df = codeElement.getChildText("time").length() == "yyyy-MM-dd HH:mm".length() ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat(DATEFMT);
                timezone.setTime(df.parse(codeElement.getChildText("time")));
                if (codeElement.getChildText("sunrise") != null) {
                    timezone.setSunrise(df.parse(codeElement.getChildText("sunrise")));
                }
                if (codeElement.getChildText("sunset") != null) {
                    timezone.setSunset(df.parse(codeElement.getChildText("sunset")));
                }
                timezone.setGmtOffset(Double.parseDouble(codeElement.getChildText("gmtOffset")));
                timezone.setDstOffset(Double.parseDouble(codeElement.getChildText("dstOffset")));
            }
            return timezone;
        }
        return null;
    }

    private static synchronized InputStream tryFailoverServer(String url, String currentlyActiveServer, int status, IOException e) throws MalformedURLException, IOException {
        logger.log(Level.WARNING, "problems connecting to geonames server " + currentlyActiveServer);
        if (geoNamesServerFailover == null || currentlyActiveServer.equals(geoNamesServerFailover)) {
            if (currentlyActiveServer.equals(geoNamesServerFailover)) {
                timeOfLastFailureMainServer = 0L;
            }
            throw e;
        }
        timeOfLastFailureMainServer = System.currentTimeMillis();
        logger.info("trying to connect to failover server " + geoNamesServerFailover);
        URLConnection conn = new URL(String.valueOf(geoNamesServerFailover) + url).openConnection();
        String userAgent = String.valueOf(USER_AGENT) + " failover from " + geoNamesServer;
        if (status != 0) {
            userAgent = String.valueOf(userAgent) + " " + status;
        }
        conn.setRequestProperty("User-Agent", userAgent);
        InputStream in = conn.getInputStream();
        return in;
    }

    public static WeatherObservation weatherIcao(String icaoCode) throws IOException, Exception {
        String url = "/weatherIcaoXML?";
        url = String.valueOf(url) + "&ICAO=" + icaoCode;
        Element root = WebService.connectAndParse(url = WebService.addUserName(url));
        Iterator iterator = root.getChildren("observation").iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            Element weatherObservationElement = (Element)obj;
            WeatherObservation weatherObservation = WebService.getWeatherObservationFromElement(weatherObservationElement);
            return weatherObservation;
        }
        return null;
    }

    public static List<WikipediaArticle> wikipediaSearch(String q, String language) throws Exception {
        ArrayList<WikipediaArticle> articles = new ArrayList<WikipediaArticle>();
        String url = "/wikipediaSearch?";
        url = String.valueOf(url) + "q=" + URLEncoder.encode(q, "UTF8");
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("entry")) {
            Element wikipediaArticleElement = (Element)obj;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(wikipediaArticleElement);
            articles.add(wikipediaArticle);
        }
        return articles;
    }

    public static List<WikipediaArticle> wikipediaSearchForTitle(String title, String language) throws Exception {
        ArrayList<WikipediaArticle> articles = new ArrayList<WikipediaArticle>();
        String url = "/wikipediaSearch?";
        url = String.valueOf(url) + "title=" + URLEncoder.encode(title, "UTF8");
        if (language != null) {
            url = String.valueOf(url) + "&lang=" + language;
        }
        url = WebService.addUserName(url);
        Element root = WebService.connectAndParse(url);
        for (Object obj : root.getChildren("entry")) {
            Element wikipediaArticleElement = (Element)obj;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(wikipediaArticleElement);
            articles.add(wikipediaArticle);
        }
        return articles;
    }
}

