/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import org.geonames.WebService;

public class WikipediaArticle {
    public static final Comparator<WikipediaArticle> ELEVATION_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle o1, WikipediaArticle o2) {
            return Double.compare(o2.elevation.intValue(), o1.elevation.intValue());
        }
    };
    public static final Comparator<WikipediaArticle> RANK_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle o1, WikipediaArticle o2) {
            return Double.compare(o2.rank, o1.rank);
        }
    };
    private String language;
    private String title;
    private String summary;
    private String wikipediaUrl;
    private String feature;
    private int population;
    Integer elevation;
    private double latitude;
    private double longitude;
    private String thumbnailImg;
    int rank;

    public Integer getElevation() {
        return this.elevation;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getLanguage() {
        return this.language;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getPopulation() {
        return this.population;
    }

    public int getRank() {
        return this.rank;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getThumbnailImg() {
        return this.thumbnailImg;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWikipediaUrl() {
        if (this.wikipediaUrl == null || WebService.isAndroid()) {
            String urlTitle = this.title.replace(' ', '_');
            try {
                urlTitle = URLEncoder.encode(urlTitle, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String lang = this.language;
            if (WebService.isAndroid()) {
                lang = String.valueOf(lang) + ".m";
            }
            return "http://" + lang + ".wikipedia.org/wiki/" + urlTitle;
        }
        return this.wikipediaUrl;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setThumbnailImg(String thumbnailImg) {
        this.thumbnailImg = thumbnailImg;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWikipediaUrl(String wikipediaURL) {
        this.wikipediaUrl = wikipediaURL;
    }
}

