/*
 * Decompiled with CFR 0.152.
 */
package org.geonames.wikipedia;

public class TextSummaryExtractor {
    public static String extractSummary(String pText, int length) {
        return TextSummaryExtractor.extractSummary(pText, length, true);
    }

    public static String extractSummary(String pText, int length, boolean stopAtParagraph) {
        int paragraph;
        if (pText == null) {
            return null;
        }
        StringBuilder summary = new StringBuilder();
        int idx = 0;
        while (idx > -1 && (summary.length() < 50 + 2 * length || length == 0) && idx < pText.length()) {
            char c = pText.charAt(idx);
            if (c == '{') {
                int begLabelIdx;
                int endidx = TextSummaryExtractor.skipTemplate(pText, idx);
                if (pText.toLowerCase().indexOf("{{audio") == idx) {
                    begLabelIdx = pText.lastIndexOf("|", endidx);
                    if (begLabelIdx > -1) {
                        String label = pText.substring(begLabelIdx + 1, endidx - 2).trim();
                        summary.append(label);
                    }
                } else if (pText.toLowerCase().indexOf("{{lang") == idx && pText.charAt(idx - 1) != '(') {
                    begLabelIdx = pText.lastIndexOf("|", endidx);
                    if (begLabelIdx > -1) {
                        String label = pText.substring(begLabelIdx + 1, endidx - 2).trim();
                        summary.append(label);
                    }
                } else if (pText.toLowerCase().indexOf("{{unit\u00c8") == idx && (begLabelIdx = pText.lastIndexOf("|", endidx)) > -1) {
                    String value = pText.substring(idx + 8, begLabelIdx).trim();
                    summary.append(value);
                    String label = pText.substring(begLabelIdx + 1, endidx - 2).trim();
                    summary.append(label);
                }
                idx = endidx;
                continue;
            }
            if (c == '<') {
                if (pText.length() > idx + 1 && pText.charAt(idx + 1) == '!') {
                    idx = TextSummaryExtractor.skipHTMLComment(pText, idx);
                    continue;
                }
                if (pText.length() > idx + 5 && pText.toLowerCase().charAt(idx + 1) == 'r' && pText.toLowerCase().charAt(idx + 2) == 'e' && pText.toLowerCase().charAt(idx + 3) == 'f' && pText.toLowerCase().charAt(idx + 4) == '>') {
                    idx = TextSummaryExtractor.skipRef(pText, idx);
                    continue;
                }
                idx = TextSummaryExtractor.skipHTMLElement(pText, idx);
                continue;
            }
            if (c == '[') {
                int endOfLink;
                if (pText.charAt(idx + 1) == '[') {
                    endOfLink = pText.indexOf("]]", idx);
                    int colon = pText.indexOf(":", idx);
                    if (colon > -1 && colon < endOfLink) {
                        idx = TextSummaryExtractor.findEndOfLink(pText, idx);
                        continue;
                    }
                    int beginAnchor = pText.indexOf("|", idx);
                    if (beginAnchor > -1 && beginAnchor < endOfLink) {
                        idx = beginAnchor + 1;
                        continue;
                    }
                    idx += 2;
                    continue;
                }
                endOfLink = pText.indexOf("]", idx);
                if (endOfLink > -1) {
                    idx = endOfLink + 1;
                    continue;
                }
            } else if (c == ']') {
                if (idx + 1 < pText.length() && pText.charAt(idx + 1) == ']') {
                    idx += 2;
                    continue;
                }
            } else if (c == '=' && idx < 5 && idx + 1 < pText.length() && pText.charAt(idx + 1) == '=') {
                idx = TextSummaryExtractor.skipHeader(pText, idx);
                continue;
            }
            summary.append(c);
            ++idx;
        }
        String textString = TextSummaryExtractor.removeIndentAtBeginning(summary.toString());
        textString = TextSummaryExtractor.removeMarkup(textString);
        textString = textString.replaceAll("\\([^\\w]*\\)", "");
        textString = textString.replaceAll("\\([, ]*", "(");
        textString = textString.replaceAll("[, ]*\\)", ")");
        textString = TextSummaryExtractor.removeWhiteSpace(textString.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ")).trim();
        textString = TextSummaryExtractor.removeBold(textString);
        if ((textString = TextSummaryExtractor.removeItalic(textString)).length() > 0 && textString.charAt(0) != '\'') {
            textString = textString.replaceFirst("^([\\p{Punct} ])*", "");
        }
        textString = textString.replaceAll("&nbsp;", " ");
        textString = textString.replaceAll("\\( ", "(");
        textString = textString.replaceAll(" \\)", ")");
        int endOfTextIdx = textString.length();
        if (stopAtParagraph && (paragraph = textString.indexOf("==")) > 10) {
            endOfTextIdx = paragraph;
        }
        if ((endOfTextIdx < 20 || endOfTextIdx > length) && (double)(endOfTextIdx = textString.lastIndexOf(".", length)) < 0.7 * (double)length) {
            endOfTextIdx = textString.lastIndexOf(" ", length);
        }
        if (endOfTextIdx > -1 && endOfTextIdx < textString.length()) {
            textString = String.valueOf(textString.substring(0, endOfTextIdx)) + " (...)";
        }
        return textString.trim();
    }

    private static int findEndOfLink(String pText, int pIdx) {
        int end = pText.indexOf("]]", pIdx);
        if (end == -1) {
            return pIdx;
        }
        int idx = pIdx;
        int openingIdx = pText.indexOf("[[", idx + 2);
        while (openingIdx > -1 && openingIdx < end) {
            idx = end;
            end = pText.indexOf("]]", end + 2);
            openingIdx = pText.indexOf("[[", idx);
        }
        if (end != -1) {
            idx = end;
        }
        return idx;
    }

    public static String removeBold(String pString) {
        return pString.replaceAll("'''", "");
    }

    private static String removeIndentAtBeginning(String pText1) {
        String pText = pText1.trim();
        if (pText.startsWith(":")) {
            int italic;
            int lineFeed = pText.indexOf("\n");
            if (lineFeed > -1) {
                pText = pText.substring(lineFeed + 1);
            } else if (pText.startsWith(":''") && (italic = pText.indexOf("''", 3)) > -1) {
                pText = pText.substring(italic + 2);
            }
        }
        return pText;
    }

    public static String removeItalic(String pString) {
        return pString.replaceAll("''", "");
    }

    public static String removeMarkup(String pString) {
        String[] terms;
        String newString = pString;
        String[] stringArray = terms = new String[]{"__NOTOC__"};
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            newString = newString.replaceAll(term, "");
            ++n2;
        }
        return newString;
    }

    public static String removeWhiteSpace(String pString) {
        StringBuffer buf = new StringBuffer();
        char[] chars = pString.toCharArray();
        int counter = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ') {
                if (counter == 0) {
                    buf.append(c);
                }
                ++counter;
            } else {
                buf.append(c);
                counter = 0;
            }
            ++n2;
        }
        return buf.toString();
    }

    static int skipHeader(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '=') {
            return pIdx;
        }
        int idx = pText.indexOf("==", pIdx + 3) + 2;
        return idx;
    }

    static int skipHTMLComment(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '<' && pText.charAt(pIdx + 1) != '!') {
            return pIdx;
        }
        int idx = pIdx;
        while ((idx = pText.indexOf(45, idx)) > -1) {
            if (pText.length() < idx + 2) {
                return pText.length();
            }
            if (pText.charAt(idx) == '-' && pText.charAt(idx + 1) == '-' && pText.charAt(idx + 2) == '>') {
                return idx + 3;
            }
            ++idx;
        }
        return idx;
    }

    static int skipHTMLElement(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '<') {
            return pIdx;
        }
        int numOpenings = 1;
        int idx = pIdx + 1;
        while (numOpenings > 0 && pText.length() > idx) {
            if (pText.charAt(idx) == '<') {
                ++numOpenings;
            } else if (pText.charAt(idx) == '>') {
                --numOpenings;
            }
            ++idx;
        }
        return idx;
    }

    static int skipRef(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '<') {
            return pIdx;
        }
        int idx = pText.indexOf("</ref>", pIdx + 3) + 6;
        return idx;
    }

    static int skipTemplate(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '{') {
            return pIdx;
        }
        int numOpenings = 1;
        int idx = pIdx + 1;
        while (numOpenings > 0 && pText.length() > idx) {
            if (pText.charAt(idx) == '{') {
                ++numOpenings;
            } else if (pText.charAt(idx) == '}') {
                --numOpenings;
            }
            ++idx;
        }
        return idx;
    }
}

