#
clear all
#
Modus="r"

if [ $Modus == "t" ]
then
	dryRun="--dry-run"
else
	dryRun=""
fi
#
do_rsync()
{
	echo "rsync $1 ==> $2, Modus=$Modus"
	if [ ! -d "$2" ]
	then
		echo mkdir -p "$2"
		mkdir -p "$2"
	fi
	echo "rsync $dryRun -a --stats --delete --exclude-from ~/.rsync-exclude '$1' '$2'"
	rsync $dryRun -a --stats --delete --exclude-from ~/.rsync-exclude "$1" "$2"
}
do_rsync_kopie()
{
	echo "rsync $1 ==> $2, Modus=$Modus"
	if [ ! -d "$2" ]
	then
		echo mkdir -p "$2"
		mkdir -p "$2"
	fi
	echo "rsync $dryRun -a --stats --exclude-from ~/.rsync-exclude '$1' '$2'"
	rsync $dryRun -a --stats --exclude-from ~/.rsync-exclude "$1" "$2"
}
do_update_Video_Listen()
{
	terminal-notifier -message "Videoliste von $1 wird aktualisiert" -title "Sync_Mac"
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.ManageMetadaten -FA -V/Volumes/$1/Videos/ -HL12 -IO/Volumes/Daten/Dropbox/Reisen/Webseiten4unterwegs/Html/AnzeigeVideosNAS.php
	# java -cp ~/Java/Jar/jfi.jar de.nss.jfi.ManageMetadaten -FP -V/Volumes/$1/Videos/ -HL12 -IO/Volumes/Daten/Dropbox/Reisen/Webseiten4unterwegs/Html/AnzeigeVideosNAS.php
 	terminal-notifier -message "Videoliste von $1 ist aktualisiert" -title "Sync_Mac"
}
do_Update_Tabelle_Kategorie()
{
	osascript -e 'quit app "sqlitebrowser"'
	if [ -d "/Volumes/$1/Videos" ]
	then
		java -cp ~/Java/Jar/jfi.jar de.nss.jfi.FDir -V/Volumes/$1/Videos/ -DCUTF-8 -DW -DB/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -DT$1 -MV -Y:V:T:R:T:F:T:G:T:POS -PK >/Volumes/Work/Work/Null.txt
	fi
}
do_Videolisten_und_Tabelle()
{
	if [ -d /Volumes/$1/Videos ]
	then
		do_Update_Tabelle_Kategorie $1
		do_update_Video_Listen $1
	else
		echo "Platte $1 nicht gemountet"
	fi
}
do_Sync_Videos()
for kat in /Volumes/NAS_HD/Videos/* ;
do
    if [ -d "$kat" ]
    then
		for volume in "BackupPassport" "BackupSeagate" "Passport" "Seagate" ;
  		do
			ziel="/Volumes/$volume/Videos/$(basename "$kat")"
			if [ -d $ziel ]
			then
				terminal-notifier -message "$kat wird auf $ziel gesichert" -title "Sync_Mac"
				do_rsync_kopie "$kat/" "$ziel/"
				terminal-notifier -message "$kat ist auf $ziel gesichert" -title "Sync_Mac"
			fi
  		done
    fi
done
#
terminal-notifier -message "iOS-Mediathek wird gesichert" -title "Sync_Mac"
java -cp ~/Java/Jar/jfi.jar de.nss.jfi.FUti -E/Volumes/Daten/Mediatheken/Monterey.photoslibrary/originals -HW/Volumes/Daten/Mediatheken/iOSMedien/ -FM
terminal-notifier -message "iOS-Mediathek ist gesichert" -title "Sync_Mac"
#
if [ -d /Volumes/TRANSFER/Mac ]
then
 	terminal-notifier -message "Platte TRANSFER wird synchronisiert" -title "Sync_Mac"
	do_rsync /Volumes/User-Dokumente/ /Volumes/TRANSFER/Mac/Dokumente
	do_rsync /Volumes/User-Downloads/ /Volumes/TRANSFER/Mac/Downloads
	do_rsync /Volumes/Daten/Dropbox/ /Volumes/TRANSFER/Mac/Dropbox
	do_rsync "/Users/hans/Library/Mobile Documents/" /Volumes/TRANSFER/Mac/iCloud
	do_rsync /Volumes/User-Dokumente/Java/ /Volumes/TRANSFER/Mac/Java
	do_rsync /Volumes/User-Dokumente/Jar/ /Volumes/TRANSFER/Mac/Jar
	do_rsync /Volumes/TRANSFER/PC/Backup/Daten/ /Volumes/Daten/PC/Daten
	do_rsync /Volumes/TRANSFER/PC/Backup/Tools/ /Volumes/Daten/PC/Tools
	# Backup Transfer
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Backup -DB/Volumes/User-Dokumente/Sicherungen/Backup.sqlite -ATransfer
	terminal-notifier -message "Platte TRANSFER ist synchronisiert" -title "Sync_Mac"
else
	echo "Platte TRANSFER nicht gemountet"
fi
#
if [ -d /Volumes/HD3_Daten/Backup ]
then
	terminal-notifier -message "Platte Revoltec, Partition HD3_Daten wird synchronisiert" -title "Sync_Mac"
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Backup -DB/Volumes/User-Dokumente/Sicherungen/Backup.sqlite -AHD3_Daten
	if [ -d /Volumes/Work ]
	then
		do_rsync /Volumes/Work/Bilder/ /Volumes/HD3_Daten/Bilder_Work
		do_rsync /Volumes/Work/Filme/ /Volumes/HD3_Daten/Filme_Work/Mac/Work_Filme
	fi
	if [ -d /Volumes/Webspace ]
	then
		do_rsync /Volumes/Webspace/ /Volumes/HD3_Daten/Webspace
	fi
	terminal-notifier -message "Platte Revoltec, Partition HD3_Daten ist synchronisiert" -title "Sync_Mac"
else
	echo "Platte HD3_Daten nicht gemountet"
fi
#
if [ -d /Volumes/NAS_SSD/Transfer ]
then
	if [ -d /Volumes/TRANSFER/Mac ]
	then
		terminal-notifier -message "Änderungen von Platte TRANSFER werden auf NAS_SSD/Transfer kopiert" -title "Sync_Mac"
		do_rsync_kopie /Volumes/TRANSFER/ /Volumes/NAS_SSD/Transfer/
		terminal-notifier -message "Änderungen von Platte TRANSFER sind auf NAS_SSD/Transfer kopiert" -title "Sync_Mac"
	fi
	if [ -d /Volumes/Work/iOS ]
	then
		terminal-notifier -message "iOS-Backups werden mit NAS_SSD/iOS synchronisiert" -title "Sync_Mac"
		do_rsync /Volumes/Work/iOS/ /Volumes/NAS_SSD/iOS/
		terminal-notifier -message "iOS-Backups sind mit NAS_SSD/iOS synchronisiert" -title "Sync_Mac"
	fi
	if [ -d /Volumes/Webspace/Originalbilder ]
	then
		terminal-notifier -message "Originalbilder werden mit NAS_SSD/Originalbilder synchronisiert" -title "Sync_Mac"
		do_rsync /Volumes/Webspace/Originalbilder/ /Volumes/NAS_SSD/Originalbilder/
		terminal-notifier -message "Originalbilder sind mit NAS_SSD/Originalbilder synchronisiert" -title "Sync_Mac"
	fi
	if [ -d /Volumes/Sammlung_Work/Audios ]
	then
		terminal-notifier -message "Audios werden mit NAS_SSD/Audios synchronisiert" -title "Sync_Mac"
		do_rsync /Volumes/Sammlung_Work/Audios/ /Volumes/NAS_SSD/Audios/
		terminal-notifier -message "Audios sind mit NAS_SSD/Audios synchronisiert" -title "Sync_Mac"
	fi
else
	echo "Platte NAS_SSD nicht gemountet"
fi
do_Videolisten_und_Tabelle NAS_HD 
osascript -e 'quit app "DB Browser for SQLite"'
java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Datei2Tabelle -E/Volumes/Daten/Dropbox/Videos/HomepageWork/alles.txt -CUTF-8 -D/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -TallesExif -N -F -O
#
do_Sync_Videos
do_Update_Tabelle_Kategorie BackupPassport
do_Update_Tabelle_Kategorie BackupSeagate
do_Update_Tabelle_Kategorie Passport
do_Update_Tabelle_Kategorie Seagate
#
if [ -d /Volumes/Passport/Originalbilder ] && [ -d /Volumes/Webspace/Originalbilder ] 
then
	terminal-notifier -message "Originalbilder werden mit Passport/Originalbilder synchronisiert" -title "Sync_Mac"
	do_rsync /Volumes/Webspace/Originalbilder/ /Volumes/Passport/Originalbilder/
	terminal-notifier -message "Originalbilder sind mit Passport/Originalbilder synchronisiert" -title "Sync_Mac"
fi
#
if [ -d /Volumes/Transcend/Videos ]
then
	terminal-notifier -message "Platte Transcend wird aktualisiert" -title "Sync_Mac"
	osascript -e 'quit app "DB Browser for SQLite"'
	do_Update_Tabelle_Kategorie Transcend
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Tabelle2Datei -D/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -TAuswahl -A/Volumes/Daten/Dropbox/Videos/HomepageWork/AuswahlSequenzen.txt -CUTF-8 -R
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Tabelle2Datei -D/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -TTranscend_del_Verz -A~/Daten/Skripts/VideosAuswahlUpdate.sh -CUTF-8 -R
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Tabelle2Datei -D/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -TTranscend_del_not_sel_Videos -A~/Daten/Skripts/VideosAuswahlUpdate.sh -CUTF-8 -P -R
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.Tabelle2Datei -D/Volumes/Daten/Dropbox/Videos/HomepageWork/VideosAlle.sqlite -TAuswahl_copy -A~/Daten/Skripts/VideosAuswahlUpdate.sh -CUTF-8 -P -R
	if [ -d /Volumes/BackupPassport/Videos -a -d /Volumes/BackupSeagate/Videos ]
	then
		. ~/Daten/Skripts/VideosAuswahlUpdate.sh	
	fi
	java -cp ~/Java/Jar/jfi.jar de.nss.jfi.FUti -E/Volumes/Webspace/lima-city1/Videos_auf_Festplatten -HW/Volumes/Daten/Dropbox/Videos/HomepageWork/ -FH -Y12
	terminal-notifier -message "Platte Transcend ist aktualisiert" -title "Sync_Mac"
else
	echo "Platte Transcend nicht gemountet"
fi
#
if [ -d /Volumes/HD3_SmartBackup ]
then
	terminal-notifier -message "HD3_SmartBackup wird synchronisiert" -title "Sync_Mac"
	/Volumes/User-Programme/SystemTools/SmartBackup.app/Contents/MacOS/SmartBackup /Volumes/HD3_SmartBackup
	terminal-notifier -message "HD3_SmartBackup ist synchronisiert" -title "Sync_Mac"
else
	echo Platte HD3_SmartBackup nicht vorhanden
fi
#
if [ -d /Volumes/WD_Work/SmartBackup ]
then
	terminal-notifier -message "WD_Work/SmartBackup wird synchronisiert" -title "Sync_Mac"
	/Volumes/User-Programme/SystemTools/SmartBackup.app/Contents/MacOS/SmartBackup /Volumes/WD_Work/SmartBackup
	terminal-notifier -message "WD_Work/SmartBackup ist synchronisiert" -title "Sync_Mac"
else
	echo Platte WD_Work/SmartBackup nicht vorhanden
fi
#
#
if [ -d /Volumes/WD_mobile_Work/SmartBackup ]
then
	terminal-notifier -message "WD_mobile_Work/SmartBackup wird synchronisiert" -title "Sync_Mac"
	/Volumes/User-Programme/SystemTools/SmartBackup.app/Contents/MacOS/SmartBackup /Volumes/WD_mobile_Work/SmartBackup
	terminal-notifier -message "WD_mobile_Work/SmartBackup ist synchronisiert" -title "Sync_Mac"
else
	echo Platte WD_mobile_Work/SmartBackup nicht vorhanden
fi
#
if [ -d /Volumes/TransferApple/SmartBackup ]
then
	terminal-notifier -message "TransferApple/SmartBackup wird synchronisiert" -title "Sync_Mac"
	/Volumes/User-Programme/SystemTools/SmartBackup.app/Contents/MacOS/SmartBackup /Volumes/TransferApple/SmartBackup
	terminal-notifier -message "TransferApple/SmartBackup ist synchronisiert" -title "Sync_Mac"
else
	echo Platte TransferApple nicht vorhanden
fi
if [ -d /Volumes/HD1_Daten ]
then
	terminal-notifier -message "HD1_Daten wird synchronisiert" -title "Sync_Mac"
	do_rsync /Volumes/Daten/Dropbox/Tipps/Linux/ /Volumes/HD1_Daten/Linux_Install/
	terminal-notifier -message "HD1_Daten ist synchronisiert" -title "Sync_Mac"
else
	echo Platte TransferApple nicht vorhanden
fi
#